/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.backup;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.BinaryType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DateType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.backup.BackupProgress;
import org.unitime.timetable.backup.SessionBackupInterface;
import org.unitime.timetable.backup.TableData;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PitStudentAcadAreaMajorClassification;
import org.unitime.timetable.model.PitStudentAcadAreaMinorClassification;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao._RootDAO;

public class SessionBackup
implements SessionBackupInterface {
    private static Log sLog = LogFactory.getLog(SessionBackup.class);
    private SessionFactory iHibSessionFactory = null;
    private org.hibernate.Session iHibSession = null;
    private CodedOutputStream iOut = null;
    private PrintWriter iDebug = null;
    private Long iSessionId = null;
    private BackupProgress iProgress = null;
    private int iQueueItemCoutner = 0;
    private Map<String, Set<Serializable>> iExclude = new HashMap<String, Set<Serializable>>();

    public BackupProgress getProgress() {
        return this.iProgress;
    }

    private void add(TableData.Table table) throws IOException {
        this.iProgress.info("Writing " + table.getName().substring(table.getName().lastIndexOf(46) + 1) + " [" + table.getRecordCount() + " records, " + table.getSerializedSize() + " bytes]");
        this.iOut.writeInt32NoTag(table.getSerializedSize());
        table.writeTo(this.iOut);
        this.iOut.flush();
        if (this.iDebug != null) {
            this.iDebug.println("## " + table.getName() + " ##");
            this.iDebug.print(table.toString());
            this.iDebug.flush();
        }
    }

    public void debug(PrintWriter pw) {
        this.iDebug = pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(OutputStream out, BackupProgress progress, Long sessionId) throws IOException {
        this.iOut = CodedOutputStream.newInstance((OutputStream)out);
        this.iProgress = progress;
        this.iSessionId = sessionId;
        this.iHibSession = new _RootDAO().createNewSession();
        this.iHibSession.setCacheMode(CacheMode.IGNORE);
        this.iHibSessionFactory = this.iHibSession.getSessionFactory();
        try {
            List<QueueItem> items;
            QueueItem qi;
            String pDisallowed;
            this.iProgress.setStatus("Exporting Session");
            this.iProgress.setPhase("Loading Model", 3.0);
            TreeSet<ClassMetadata> allMeta = new TreeSet<ClassMetadata>(new Comparator<ClassMetadata>(){

                @Override
                public int compare(ClassMetadata m1, ClassMetadata m2) {
                    return m1.getEntityName().compareTo(m2.getEntityName());
                }
            });
            allMeta.addAll(this.iHibSessionFactory.getAllClassMetadata().values());
            this.iProgress.incProgress();
            LinkedList<QueueItem> queue = new LinkedList<QueueItem>();
            queue.add(new QueueItem(this.iHibSessionFactory.getClassMetadata(Session.class), null, "uniqueId", Relation.None));
            HashSet<String> avoid = new HashSet<String>();
            avoid.add(TimetableManager.class.getName() + ".departments");
            avoid.add(TimetableManager.class.getName() + ".solverGroups");
            avoid.add(TimetableManager.class.getName() + ".settings");
            avoid.add(DistributionType.class.getName() + ".departments");
            avoid.add(LastLikeCourseDemand.class.getName() + ".student");
            avoid.add(Student.class.getName() + ".lastLikeCourseDemands");
            String pAvoid = ApplicationProperty.SessionBackupAvoid.value();
            if (pAvoid != null && !pAvoid.isEmpty()) {
                for (String av : pAvoid.split("[\n,;]")) {
                    if (av.isEmpty()) continue;
                    avoid.add(av.trim());
                }
            }
            HashSet<String> disallowedNotNullRelations = new HashSet<String>();
            disallowedNotNullRelations.add(Assignment.class.getName() + ".datePattern");
            disallowedNotNullRelations.add(Assignment.class.getName() + ".timePattern");
            disallowedNotNullRelations.add(LastLikeCourseDemand.class.getName() + ".student");
            disallowedNotNullRelations.add(OnlineSectioningLog.class.getName() + ".session");
            disallowedNotNullRelations.add(PointInTimeData.class.getName() + ".session");
            disallowedNotNullRelations.add(SectioningSolutionLog.class.getName() + ".session");
            if (ApplicationProperty.SessionBackupPointInTime.isFalse()) {
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".academicArea");
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".academicClassification");
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".major");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".academicArea");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".academicClassification");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".minor");
                disallowedNotNullRelations.add(PitDepartmentalInstructor.class.getName() + ".department");
                disallowedNotNullRelations.add(PitCourseOffering.class.getName() + ".subjectArea");
            }
            if ((pDisallowed = ApplicationProperty.SessionBackupDisallowed.value()) != null && !pDisallowed.isEmpty()) {
                for (String dis : pDisallowed.split("[\n,;]")) {
                    if (dis.isEmpty()) continue;
                    disallowedNotNullRelations.add(dis.trim());
                }
            }
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            ArrayList sessions = new ArrayList();
            sessions.add(queue.peek());
            data.put(((QueueItem)queue.peek()).name(), sessions);
            QueueItem item = null;
            while ((item = (QueueItem)queue.poll()) != null) {
                if (item.size() == 0) continue;
                for (ClassMetadata meta : allMeta) {
                    if (meta.hasSubclasses()) continue;
                    for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                        Type type;
                        String property = meta.getPropertyNames()[i];
                        if (disallowedNotNullRelations.contains(meta.getEntityName() + "." + property) || meta.getPropertyNullability()[i] || !((type = meta.getPropertyTypes()[i]) instanceof EntityType) || !type.getReturnedClass().equals(item.clazz()) || data.containsKey((qi = new QueueItem(meta, item, property, Relation.Parent)).name())) continue;
                        items = new ArrayList<QueueItem>();
                        data.put(qi.name(), items);
                        queue.add(qi);
                        items.add(qi);
                        if (qi.size() <= 0) continue;
                        this.iProgress.info("Parent: " + qi);
                    }
                }
            }
            this.iProgress.incProgress();
            for (Object list : data.values()) {
                queue.addAll((Collection<QueueItem>)list);
            }
            ArrayList<QueueItem> distributions = new ArrayList<QueueItem>();
            for (QueueItem instructor : (List)data.get(DepartmentalInstructor.class.getName())) {
                QueueItem qi2 = new QueueItem(this.iHibSessionFactory.getClassMetadata(DistributionPref.class), instructor, "owner", Relation.Parent);
                distributions.add(qi2);
                queue.add(qi2);
                if (qi2.size() <= 0) continue;
                this.iProgress.info("Extra: " + qi2);
            }
            data.put(DistributionPref.class.getName(), distributions);
            while ((item = (QueueItem)queue.poll()) != null) {
                if (item.size() == 0) continue;
                for (int i = 0; i < item.meta().getPropertyNames().length; ++i) {
                    ClassMetadata meta;
                    String property = item.meta().getPropertyNames()[i];
                    Type type = item.meta().getPropertyTypes()[i];
                    if (type instanceof EntityType) {
                        if (avoid.contains(item.name() + "." + property) || item.contains((meta = this.iHibSessionFactory.getClassMetadata(type.getReturnedClass())).getEntityName())) continue;
                        qi = new QueueItem(meta, item, property, Relation.One);
                        items = (List)data.get(qi.name());
                        if (items == null) {
                            items = new ArrayList();
                            data.put(qi.name(), items);
                        }
                        queue.add(qi);
                        items.add(qi);
                        if (qi.size() > 0) {
                            this.iProgress.info("One: " + qi);
                        }
                    }
                    if (!(type instanceof CollectionType) || avoid.contains(item.name() + "." + property) || (meta = this.iHibSessionFactory.getClassMetadata(((CollectionType)type).getElementType((SessionFactoryImplementor)this.iHibSessionFactory).getReturnedClass())) == null || item.contains(meta.getEntityName())) continue;
                    qi = new QueueItem(meta, item, property, Relation.Many);
                    items = (List)data.get(qi.name());
                    if (items == null) {
                        items = new ArrayList();
                        data.put(qi.name(), items);
                    }
                    queue.add(qi);
                    items.add(qi);
                    if (qi.size() <= 0) continue;
                    this.iProgress.info("Many: " + qi);
                }
            }
            this.iProgress.incProgress();
            HashMap<String, HashSet<Serializable>> allExportedIds = new HashMap<String, HashSet<Serializable>>();
            for (String name : new TreeSet(data.keySet())) {
                List list = (List)data.get(name);
                HashMap<String, TableData.Table.Builder> tables = new HashMap<String, TableData.Table.Builder>();
                for (QueueItem current : list) {
                    if (current.size() == 0) continue;
                    this.iProgress.info("Loading " + current);
                    List<Object> objects = current.list();
                    if (objects == null || objects.isEmpty()) continue;
                    this.iProgress.setPhase(current.abbv() + " [" + objects.size() + "]", objects.size());
                    block14: for (Object object : objects) {
                        HashSet<Serializable> exportedIds;
                        this.iProgress.incProgress();
                        ClassMetadata meta = this.iHibSessionFactory.getClassMetadata(object.getClass());
                        if (meta == null) {
                            meta = current.meta();
                        }
                        if (meta.hasSubclasses()) {
                            for (Map.Entry entry : this.iHibSessionFactory.getAllClassMetadata().entrySet()) {
                                ClassMetadata classMetadata = (ClassMetadata)entry.getValue();
                                if (!classMetadata.getMappedClass().isInstance(object) || classMetadata.hasSubclasses()) continue;
                                meta = classMetadata;
                                break;
                            }
                        }
                        Serializable id = meta.getIdentifier(object, (SessionImplementor)this.iHibSession);
                        if (meta.getIdentifierType().isComponentType()) {
                            ComponentType cid = (ComponentType)meta.getIdentifierType();
                            Object[] ids = new Object[cid.getPropertyNames().length];
                            for (int i = 0; i < cid.getPropertyNames().length; ++i) {
                                Type type = meta.getPropertyType(cid.getPropertyNames()[i]);
                                Object value = cid.getPropertyValue(object, i);
                                if (value == null) continue;
                                ids[i] = type.isEntityType() ? this.iHibSessionFactory.getClassMetadata(type.getReturnedClass()).getIdentifier(value, (SessionImplementor)this.iHibSession) : value;
                            }
                            id = new CompositeId(ids);
                        }
                        if ((exportedIds = (HashSet<Serializable>)allExportedIds.get(meta.getEntityName())) == null) {
                            exportedIds = new HashSet<Serializable>();
                            allExportedIds.put(meta.getEntityName(), exportedIds);
                        }
                        if (!exportedIds.add(id)) continue;
                        for (String property : meta.getPropertyNames()) {
                            Session s;
                            Type type = meta.getPropertyType(property);
                            if (!(type instanceof EntityType) || !type.getReturnedClass().equals(Session.class) || (s = (Session)meta.getPropertyValue(object, property)) == null || s.getUniqueId().equals(this.iSessionId)) continue;
                            this.iProgress.warn(meta.getEntityName().substring(meta.getEntityName().lastIndexOf(46) + 1) + "@" + id + " belongs to a different academic session (" + s + ")");
                            continue block14;
                        }
                        TableData.Table.Builder table = (TableData.Table.Builder)tables.get(meta.getEntityName());
                        if (table == null) {
                            table = TableData.Table.newBuilder();
                            tables.put(meta.getEntityName(), table);
                            table.setName(meta.getEntityName());
                        }
                        TableData.Record.Builder record = TableData.Record.newBuilder();
                        record.setId(id.toString());
                        for (String property : meta.getPropertyNames()) {
                            List<Object> ids;
                            Type type = meta.getPropertyType(property);
                            Object value = meta.getPropertyValue(object, property);
                            if (value == null) continue;
                            TableData.Element.Builder element = TableData.Element.newBuilder();
                            element.setName(property);
                            if (type instanceof PrimitiveType) {
                                element.addValue(((PrimitiveType)type).toString(value));
                            } else if (type instanceof StringType) {
                                element.addValue(((StringType)type).toString((String)value));
                            } else if (type instanceof BinaryType) {
                                element.addValueBytes(ByteString.copyFrom((byte[])((byte[])value)));
                            } else if (type instanceof TimestampType) {
                                element.addValue(((TimestampType)type).toString((Object)((Date)value)));
                            } else if (type instanceof DateType) {
                                element.addValue(((DateType)type).toString((Object)((Date)value)));
                            } else if (type instanceof EntityType) {
                                ids = current.relation(property, id, false);
                                if (ids != null) {
                                    for (Object i : ids) {
                                        element.addValue(i.toString());
                                    }
                                }
                                this.iHibSession.evict(value);
                            } else if (type instanceof CustomType && value instanceof Document) {
                                if (object instanceof CurriculumClassification && property.equals("students")) continue;
                                StringWriter w = new StringWriter();
                                XMLWriter x = new XMLWriter((Writer)w, OutputFormat.createCompactFormat());
                                x.write((Document)value);
                                x.flush();
                                x.close();
                                element.addValue(w.toString());
                            } else if (type instanceof CollectionType) {
                                ids = current.relation(property, id, false);
                                if (ids != null) {
                                    for (Object i : ids) {
                                        element.addValue(i.toString());
                                    }
                                }
                            } else {
                                if (type instanceof EmbeddedComponentType && property.equalsIgnoreCase("uniqueCourseNbr")) continue;
                                this.iProgress.warn("Unknown data type: " + type + " (property " + meta.getEntityName() + "." + property + ", class " + value.getClass() + ")");
                                continue;
                            }
                            record.addElement(element.build());
                        }
                        if (meta.getIdentifierType().isComponentType()) {
                            ComponentType cid = (ComponentType)meta.getIdentifierType();
                            for (int i = 0; i < cid.getPropertyNames().length; ++i) {
                                String property = cid.getPropertyNames()[i];
                                Type type = cid.getSubtypes()[i];
                                Serializable value = ((CompositeId)id).iId[i];
                                if (value == null) continue;
                                TableData.Element.Builder element = TableData.Element.newBuilder();
                                element.setName(property);
                                if (type instanceof PrimitiveType) {
                                    element.addValue(((PrimitiveType)type).toString((Object)value));
                                } else if (type instanceof StringType) {
                                    element.addValue(((StringType)type).toString((String)((Object)value)));
                                } else if (type instanceof BinaryType) {
                                    element.addValueBytes(ByteString.copyFrom((byte[])((byte[])value)));
                                } else if (type instanceof TimestampType) {
                                    element.addValue(((TimestampType)type).toString((Object)((Date)value)));
                                } else if (type instanceof DateType) {
                                    element.addValue(((DateType)type).toString((Object)((Date)value)));
                                } else if (type instanceof EntityType) {
                                    element.addValue(value.toString());
                                } else {
                                    this.iProgress.warn("Not-supported composite key data type: " + type + " (property " + meta.getEntityName() + "." + property + ", class " + value.getClass() + ")");
                                    continue;
                                }
                                record.addElement(element.build());
                            }
                        }
                        table.addRecord(record.build());
                        this.iHibSession.evict(object);
                    }
                    current.clearCache();
                }
                for (TableData.Table.Builder table : tables.values()) {
                    this.add(table.build());
                }
            }
            this.iProgress.setStatus("All done.");
        }
        finally {
            this.iHibSession.close();
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2012"), ApplicationProperties.getProperty("term", "Spring"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            FileOutputStream out = new FileOutputStream(args.length == 0 ? session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative() + ".dat" : args[0]);
            final Progress progress = Progress.getInstance();
            sLog.info((Object)("Using " + ApplicationProperty.SessionBackupInterface.value()));
            SessionBackup backup = (SessionBackup)Class.forName(ApplicationProperty.SessionBackupInterface.value()).newInstance();
            PrintWriter debug = null;
            if (args.length >= 2) {
                debug = new PrintWriter(args[1]);
                backup.debug(debug);
            }
            progress.addProgressListener((ProgressListener)new ProgressWriter(System.out));
            backup.backup(out, new BackupProgress(){

                @Override
                public void setStatus(String status) {
                    progress.setStatus(status);
                }

                @Override
                public void setPhase(String phase, double max) {
                    progress.setPhase(phase, Math.round(max));
                }

                @Override
                public void incProgress() {
                    progress.incProgress();
                }

                @Override
                public void info(String message) {
                    progress.info(message);
                }

                @Override
                public void warn(String message) {
                    progress.warn(message);
                }

                @Override
                public void error(String message) {
                    progress.error(message);
                }
            }, session.getUniqueId());
            out.close();
            if (debug != null) {
                debug.close();
            }
        }
        catch (Exception e) {
            sLog.fatal((Object)("Backup failed: " + e.getMessage()), (Throwable)e);
        }
    }

    public static class CompositeId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Serializable[] iId;

        public CompositeId(Object ... id) {
            this.iId = new Serializable[id.length];
            for (int i = 0; i < this.iId.length; ++i) {
                this.iId[i] = (Serializable)id[i];
            }
        }

        public int hashCode() {
            int hashCode = this.iId[0] == null ? 0 : this.iId[0].hashCode();
            for (int i = 1; i < this.iId.length; ++i) {
                if (this.iId[i] == null) continue;
                hashCode ^= this.iId[i].hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CompositeId)) {
                return false;
            }
            CompositeId id = (CompositeId)o;
            if (id.iId.length != this.iId.length) {
                return false;
            }
            for (int i = 0; i < this.iId.length; ++i) {
                if (ToolBox.equals((Object)this.iId[i], (Object)id.iId[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String ret = "";
            for (int i = 0; i < this.iId.length; ++i) {
                ret = ret + (i > 0 ? "|" : "") + (this.iId[i] == null ? "" : this.iId[i].toString());
            }
            return ret;
        }
    }

    class QueueItem {
        QueueItem iParent;
        ClassMetadata iMeta;
        String iProperty;
        int iQueueItemId;
        Relation iRelation;
        int size;
        Map<String, Map<Serializable, List<Object>>> iRelationCache;

        QueueItem(ClassMetadata meta, QueueItem parent, String property, Relation relation) {
            this.iQueueItemId = SessionBackup.this.iQueueItemCoutner++;
            this.size = -1;
            this.iRelationCache = new HashMap<String, Map<Serializable, List<Object>>>();
            this.iMeta = meta;
            this.iParent = parent;
            this.iProperty = property;
            this.iRelation = relation;
        }

        String property() {
            return this.iProperty;
        }

        QueueItem parent() {
            return this.iParent;
        }

        ClassMetadata meta() {
            return this.iMeta;
        }

        String name() {
            return this.meta().getEntityName();
        }

        String abbv() {
            return this.meta().getEntityName().substring(this.meta().getEntityName().lastIndexOf(46) + 1);
        }

        Class clazz() {
            return this.meta().getMappedClass();
        }

        int qid() {
            return this.iQueueItemId;
        }

        Relation relation() {
            return this.iRelation;
        }

        boolean contains(String name) {
            if (name.equals(this.name())) {
                return true;
            }
            if (this.parent() == null) {
                return false;
            }
            return this.parent().contains(name);
        }

        int depth() {
            return this.parent() == null ? 0 : 1 + this.parent().depth();
        }

        public String toString() {
            return this.abbv() + ": " + this.chain() + " [" + this.size() + "]";
        }

        public String chain() {
            switch (this.relation()) {
                case None: {
                    return this.property();
                }
                case Parent: {
                    return this.property() + "." + this.parent().chain();
                }
            }
            switch (this.parent().relation()) {
                case Parent: {
                    return "(" + this.parent().abbv() + "." + this.parent().chain() + ")." + this.property();
                }
                case None: {
                    return this.parent().abbv() + "." + this.property();
                }
            }
            return this.parent().chain() + "." + this.property();
        }

        String hqlName() {
            return "q" + this.qid();
        }

        String hqlFrom() {
            switch (this.relation()) {
                case One: 
                case Many: {
                    return this.parent().hqlFrom() + " inner join " + this.parent().hqlName() + "." + this.property() + " " + this.hqlName();
                }
            }
            return (this.parent() == null ? "" : this.parent().hqlFrom() + ", ") + this.name() + " " + this.hqlName();
        }

        String hqlWhere() {
            String where = null;
            switch (this.relation()) {
                case None: {
                    where = this.hqlName() + "." + this.property() + " = :sessionId";
                    break;
                }
                case Parent: {
                    where = this.hqlName() + "." + this.property() + " = " + this.parent().hqlName() + " and " + this.parent().hqlWhere();
                    break;
                }
                default: {
                    where = this.parent().hqlWhere();
                }
            }
            if (Solution.class.getName().equals(this.name())) {
                where = where + " and " + this.hqlName() + ".commited = true";
            }
            if (Assignment.class.getName().equals(this.name())) {
                where = where + " and " + this.hqlName() + ".solution.commited = true";
            }
            if (SolutionInfo.class.getName().equals(this.name())) {
                where = where + " and " + this.hqlName() + ".definition.name = 'GlobalInfo'";
            }
            return where;
        }

        int size() {
            block10: {
                if (this.relation() == Relation.Empty) {
                    return 0;
                }
                if (AssignmentInfo.class.getName().equals(this.name())) {
                    return 0;
                }
                if (ConstraintInfo.class.getName().equals(this.name())) {
                    return 0;
                }
                if (ChangeLog.class.getName().equals(this.name())) {
                    return 0;
                }
                if (this.size >= 0) break block10;
                HashSet<Serializable> ids = (HashSet<Serializable>)SessionBackup.this.iExclude.get(this.name());
                if (ids == null) {
                    ids = new HashSet<Serializable>();
                    SessionBackup.this.iExclude.put(this.name(), ids);
                }
                this.size = 0;
                if (this.meta().getIdentifierType().isComponentType()) {
                    ComponentType type = (ComponentType)this.meta().getIdentifierType();
                    String select = "";
                    for (int i = 0; i < type.getPropertyNames().length; ++i) {
                        ClassMetadata meta = SessionBackup.this.iHibSessionFactory.getClassMetadata(type.getSubtypes()[i].getReturnedClass());
                        select = meta == null ? select + (i > 0 ? ", " : "") + this.hqlName() + "." + type.getPropertyNames()[i] : select + (i > 0 ? ", " : "") + this.hqlName() + "." + type.getPropertyNames()[i] + "." + meta.getIdentifierPropertyName();
                    }
                    for (Object[] id : SessionBackup.this.iHibSession.createQuery("select distinct " + select + " from " + this.hqlFrom() + " where " + this.hqlWhere()).setLong("sessionId", SessionBackup.this.iSessionId.longValue()).list()) {
                        if (!ids.add(new CompositeId(id))) continue;
                        ++this.size;
                    }
                } else {
                    for (Serializable id : SessionBackup.this.iHibSession.createQuery("select distinct " + this.hqlName() + "." + this.meta().getIdentifierPropertyName() + " from " + this.hqlFrom() + " where " + this.hqlWhere()).setLong("sessionId", SessionBackup.this.iSessionId.longValue()).list()) {
                        if (!ids.add(id)) continue;
                        ++this.size;
                    }
                }
            }
            return this.size;
        }

        boolean hasBlob() {
            for (String property : this.iMeta.getPropertyNames()) {
                if (!(this.iMeta.getPropertyType(property) instanceof BinaryType)) continue;
                return true;
            }
            return false;
        }

        boolean distinct() {
            if (this.hasBlob()) {
                return true;
            }
            switch (this.relation()) {
                case Many: {
                    return false;
                }
                case One: {
                    return this.parent().distinct();
                }
            }
            return true;
        }

        List<Object> list() {
            if (this.relation() == Relation.Empty) {
                return null;
            }
            if (AssignmentInfo.class.getName().equals(this.name())) {
                return null;
            }
            if (ConstraintInfo.class.getName().equals(this.name())) {
                return null;
            }
            if (ChangeLog.class.getName().equals(this.name())) {
                return null;
            }
            return SessionBackup.this.iHibSession.createQuery("select " + (this.distinct() ? "" : "distinct ") + this.hqlName() + " from " + this.hqlFrom() + " where " + this.hqlWhere()).setLong("sessionId", SessionBackup.this.iSessionId.longValue()).list();
        }

        List<Object> relation(String property, Serializable id, boolean data) {
            Map<Serializable, List<Object>> relation = this.iRelationCache.get(property);
            if (relation == null) {
                int i;
                Type type = this.meta().getPropertyType(property);
                String idProperty = null;
                int composite = 0;
                if (!data) {
                    ClassMetadata meta = null;
                    meta = type instanceof CollectionType ? SessionBackup.this.iHibSessionFactory.getClassMetadata(((CollectionType)type).getElementType((SessionFactoryImplementor)SessionBackup.this.iHibSessionFactory).getReturnedClass()) : SessionBackup.this.iHibSessionFactory.getClassMetadata(type.getReturnedClass());
                    if (meta == null) {
                        data = true;
                    } else if (meta.getIdentifierType().isComponentType()) {
                        ComponentType idtype = (ComponentType)meta.getIdentifierType();
                        idProperty = "";
                        for (i = 0; i < idtype.getPropertyNames().length; ++i) {
                            ClassMetadata idmeta = SessionBackup.this.iHibSessionFactory.getClassMetadata(idtype.getSubtypes()[i].getReturnedClass());
                            idProperty = idmeta == null ? idProperty + (i > 0 ? ", p." : "") + idtype.getPropertyNames()[i] : idProperty + (i > 0 ? ", p." : "") + idtype.getPropertyNames()[i] + "." + idmeta.getIdentifierPropertyName();
                        }
                        composite = idtype.getPropertyNames().length;
                    } else {
                        idProperty = meta.getIdentifierPropertyName();
                        if (this.name().equals(LastLikeCourseDemand.class.getName()) && "student".equals(property)) {
                            idProperty = "externalUniqueId";
                        }
                    }
                }
                relation = new HashMap<Serializable, List<Object>>();
                if (this.meta().getIdentifierType().isComponentType()) {
                    ComponentType idtype = (ComponentType)this.meta().getIdentifierType();
                    String select = "";
                    for (i = 0; i < idtype.getPropertyNames().length; ++i) {
                        ClassMetadata meta = SessionBackup.this.iHibSessionFactory.getClassMetadata(idtype.getSubtypes()[i].getReturnedClass());
                        select = meta == null ? select + (i > 0 ? ", " : "") + this.hqlName() + "." + idtype.getPropertyNames()[i] : select + (i > 0 ? ", " : "") + this.hqlName() + "." + idtype.getPropertyNames()[i] + "." + meta.getIdentifierPropertyName();
                    }
                    for (Object[] o : SessionBackup.this.iHibSession.createQuery("select distinct " + select + (data ? ", p" : ", p." + idProperty) + " from " + this.hqlFrom() + " inner join " + this.hqlName() + "." + property + " p where " + this.hqlWhere()).setLong("sessionId", SessionBackup.this.iSessionId.longValue()).list()) {
                        Object[] cid = new Object[idtype.getPropertyNames().length];
                        for (int i2 = 0; i2 < idtype.getPropertyNames().length; ++i2) {
                            cid[i2] = o[i2];
                        }
                        Object obj = o[idtype.getPropertyNames().length];
                        List<Object> list = relation.get(new CompositeId(cid));
                        if (list == null) {
                            list = new ArrayList<Object>();
                            relation.put(new CompositeId(cid), list);
                        }
                        if (composite > 1) {
                            Object[] oid = new Object[composite];
                            for (int i3 = 0; i3 < composite; ++i3) {
                                oid[i3] = o[idtype.getPropertyNames().length + i3];
                            }
                            list.add(new CompositeId(oid));
                            continue;
                        }
                        list.add(obj);
                    }
                } else {
                    for (Object[] o : SessionBackup.this.iHibSession.createQuery("select distinct " + this.hqlName() + "." + this.meta().getIdentifierPropertyName() + (data ? ", p" : ", p." + idProperty) + " from " + this.hqlFrom() + " inner join " + this.hqlName() + "." + property + " p where " + this.hqlWhere()).setLong("sessionId", SessionBackup.this.iSessionId.longValue()).list()) {
                        List<Object> list = relation.get((Serializable)o[0]);
                        if (list == null) {
                            list = new ArrayList<Object>();
                            relation.put((Serializable)o[0], list);
                        }
                        if (composite > 1) {
                            Object[] oid = new Object[composite];
                            for (int i4 = 0; i4 < composite; ++i4) {
                                oid[i4] = o[1 + i4];
                            }
                            list.add(new CompositeId(oid));
                            continue;
                        }
                        list.add(o[1]);
                    }
                }
                this.iRelationCache.put(property, relation);
            }
            return relation.get(id);
        }

        private void clearCache() {
            this.iRelationCache.clear();
        }
    }

    static enum Relation {
        None,
        Parent,
        One,
        Many,
        Empty;

    }
}

