/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.authenticate.jaas;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.springframework.security.authentication.encoding.MessageDigestPasswordEncoder;
import org.unitime.timetable.authenticate.jaas.AuthenticateModule;
import org.unitime.timetable.authenticate.jaas.AuthenticatedUser;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.UserDAO;

@Deprecated
public class DbAuthenticateModule
extends AuthenticateModule {
    private static Logger sLog = Logger.getLogger(DbAuthenticateModule.class);
    private String iExternalUid;

    @Override
    public boolean abort() throws LoginException {
        if (!this.isAuthSucceeded()) {
            return false;
        }
        if (this.isAuthSucceeded() && !this.isCommitSucceeded()) {
            this.reset();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.isAuthSucceeded()) {
            if (this.iExternalUid == null || this.iExternalUid.trim().length() == 0) {
                throw new LoginException("External UID not found");
            }
            this.getSubject().getPrincipals().add(new AuthenticatedUser(this.getUser(), this.iExternalUid));
            this.setCommitSucceeded(true);
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.iExternalUid = null;
    }

    @Override
    public boolean login() throws LoginException {
        sLog.debug((Object)"Performing db authentication ... ");
        if (this.getCallbackHandler() == null) {
            throw new LoginException("Error: no CallbackHandler available ");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("User Name: "), new PasswordCallback("Password: ", true)};
        try {
            this.getCallbackHandler().handle(callbacks);
            String n = ((NameCallback)callbacks[0]).getName();
            String p = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            HashMap<String, String> userProps = new HashMap<String, String>();
            userProps.put("username", n);
            userProps.put("password", p);
            if (this.doAuthenticate(userProps)) {
                return true;
            }
            sLog.debug((Object)"Db authentication failed ... ");
            this.setAuthSucceeded(false);
            return false;
        }
        catch (Exception ex) {
            sLog.debug((Object)("Db authentication failed ... " + ex.getMessage()), (Throwable)ex);
            this.setAuthSucceeded(false);
            return false;
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.reset();
        return true;
    }

    @Override
    public void reset() {
        this.iExternalUid = null;
        super.reset();
    }

    @Override
    public boolean doAuthenticate(HashMap userProps) throws Exception {
        String pwd;
        String n = (String)userProps.get("username");
        String p = (String)userProps.get("password");
        User u = (User)new UserDAO().get(n);
        if (u != null && DbAuthenticateModule.checkPassword(p, pwd = u.getPassword())) {
            sLog.debug((Object)"Db authentication passed ... ");
            this.setAuthSucceeded(true);
            this.iExternalUid = u.getExternalUniqueId();
            this.setUser(n);
            return true;
        }
        return false;
    }

    public static String getEncodedPassword(String clearTextPassword) {
        return new MessageDigestPasswordEncoder("MD5", true).encodePassword(clearTextPassword, null);
    }

    public static boolean checkPassword(String clearTextTestPassword, String encodedActualPassword) throws NoSuchAlgorithmException {
        String encodedTestPassword = DbAuthenticateModule.getEncodedPassword(clearTextTestPassword);
        return encodedTestPassword.equals(encodedActualPassword);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DbAuthenticateModule.getEncodedPassword(args[0]));
    }
}

