/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.BinaryFileApiHelper;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseLocationPicture;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.LocationPictureDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;
import org.unitime.timetable.server.rooms.RoomUpdateBackend;

@Service(value="/api/rooms")
public class RoomsConnector
extends ApiConnector {
    @Override
    public void doGet(ApiHelper helper) throws IOException {
        Long pictureId = helper.getOptinalParameterLong("pictureId", null);
        if (pictureId != null) {
            LocationPicture picture = (LocationPicture)LocationPictureDAO.getInstance().get(pictureId);
            if (picture == null) {
                throw new IllegalArgumentException("Room picture of the given id does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)picture.getLocation().getSession(), Right.ApiRetrieveRooms, new Qualifiable[0]);
            helper.setResponse(new BinaryFileApiHelper.BinaryFile(picture.getDataFile(), picture.getContentType(), picture.getFileName()));
            return;
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)session, Right.ApiRetrieveRooms, new Qualifiable[0]);
        RoomInterface.RoomFilterRpcRequest request = new RoomInterface.RoomFilterRpcRequest();
        request.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
        request.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("r:text")) {
                request.setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                request.addOption(command.substring(2), value);
            }
        }
        request.setOption("flag", "plain");
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        new RoomDetailsBackend().enumarate(request, response, context);
        ArrayList<RoomInterface.RoomDetailInterface> rooms = new ArrayList<RoomInterface.RoomDetailInterface>();
        if (response.hasResults()) {
            for (EventInterface.FilterRpcResponse.Entity e2 : response.getResults()) {
                rooms.add((RoomInterface.RoomDetailInterface)e2);
            }
        }
        helper.setResponse(rooms);
    }

    @Override
    public void doPut(ApiHelper helper) throws IOException {
        Location location = null;
        Long roomId = helper.getOptinalParameterLong("roomId", null);
        if (roomId != null) {
            location = (Location)LocationDAO.getInstance().get(roomId, helper.getHibSession());
            if (location == null) {
                throw new IllegalArgumentException("Room " + roomId + " does not exist.");
            }
        } else {
            Long sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            String room = helper.getRequiredParameter("room");
            location = Location.findByName(helper.getHibSession(), sessionId, room);
            if (location == null) {
                throw new IllegalArgumentException("Room " + room + " does not exist.");
            }
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)location.getSession(), Right.ApiRoomPictureUpload, new Qualifiable[0]);
        BinaryFileApiHelper.BinaryFile file = (BinaryFileApiHelper.BinaryFile)helper.getRequest((Type)((Object)BinaryFileApiHelper.BinaryFile.class));
        this.updatePicture(helper, location, file);
        if (helper.getOptinalParameterBoolean("future", false).booleanValue()) {
            List futureLocations = helper.getHibSession().createQuery("select l from Location l, Session s where l.permanentId = :permanentId and s.uniqueId = :sessionId and s.sessionBeginDateTime < l.session.sessionBeginDateTime order by l.session.sessionBeginDateTime").setLong("permanentId", location.getPermanentId().longValue()).setLong("sessionId", location.getSession().getUniqueId().longValue()).list();
            for (Location loc : futureLocations) {
                this.updatePicture(helper, loc, file);
            }
        }
    }

    @Override
    public void doDelete(ApiHelper helper) throws IOException {
        Long pictureId = helper.getOptinalParameterLong("pictureId", null);
        if (pictureId != null) {
            LocationPicture picture = (LocationPicture)LocationPictureDAO.getInstance().get(pictureId);
            if (picture == null) {
                throw new IllegalArgumentException("Room picture of the given id does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)picture.getLocation().getSession(), Right.ApiRoomPictureUpload, new Qualifiable[0]);
            picture.getLocation().getPictures().remove(picture);
            helper.getHibSession().delete((Object)picture);
            helper.getHibSession().saveOrUpdate((Object)picture.getLocation());
            helper.getHibSession().flush();
            helper.setResponse(new RoomInterface.RoomPictureInterface(picture.getUniqueId(), picture.getFileName(), picture.getContentType(), picture.getTimeStamp().getTime(), RoomPicturesBackend.getPictureType(picture.getType())));
            return;
        }
        Location location = null;
        Long roomId = helper.getOptinalParameterLong("roomId", null);
        if (roomId != null) {
            location = (Location)LocationDAO.getInstance().get(roomId, helper.getHibSession());
            if (location == null) {
                throw new IllegalArgumentException("Room " + roomId + " does not exist.");
            }
        } else {
            Long sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            String room = helper.getRequiredParameter("room");
            location = Location.findByName(helper.getHibSession(), sessionId, room);
            if (location == null) {
                throw new IllegalArgumentException("Room " + room + " does not exist.");
            }
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)location.getSession(), Right.ApiRoomEdit, new Qualifiable[0]);
        RoomInterface.RoomUpdateRpcRequest request = new RoomInterface.RoomUpdateRpcRequest();
        request.setLocationId(location.getUniqueId());
        request.setSessionId(location.getSession().getUniqueId());
        request.setOperation(RoomInterface.RoomUpdateRpcRequest.Operation.DELETE);
        if (helper.getOptinalParameterBoolean("future", false).booleanValue()) {
            List futureLocations = helper.getHibSession().createQuery("select l from Location l, Session s where l.permanentId = :permanentId and s.uniqueId = :sessionId and s.sessionBeginDateTime < l.session.sessionBeginDateTime order by l.session.sessionBeginDateTime").setLong("permanentId", location.getPermanentId().longValue()).setLong("sessionId", location.getSession().getUniqueId().longValue()).list();
            for (Location loc : futureLocations) {
                request.setFutureFlag(loc.getUniqueId(), RoomInterface.FutureOperation.getFlagAllEnabled());
            }
        }
        helper.setResponse(new RoomUpdateBackend().execute(request, helper.getSessionContext()));
    }

    protected void updatePicture(ApiHelper helper, Location location, BinaryFileApiHelper.BinaryFile file) throws IOException {
        String name = helper.getOptinalParameter("name", file.getFileName());
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' was not provided.");
        }
        String type = helper.getOptinalParameter("contentType", file.getContentType());
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'contentType' was not provided.");
        }
        String reference = helper.getOptinalParameter("type", null);
        BaseLocationPicture picture = null;
        for (LocationPicture locationPicture : location.getPictures()) {
            if (!locationPicture.getFileName().equals(name)) continue;
            picture = locationPicture;
            break;
        }
        if (picture == null) {
            if (location instanceof Room) {
                picture = new RoomPicture();
                picture.setFileName(name);
                ((LocationPicture)picture).setLocation(location);
                ((Room)location).getPictures().add((RoomPicture)picture);
            } else {
                picture = new NonUniversityLocationPicture();
                picture.setFileName(name);
                ((LocationPicture)picture).setLocation(location);
                ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)picture);
            }
        }
        if (type != null) {
            picture.setContentType(type);
        }
        if (reference != null) {
            picture.setType(AttachmentType.findByReference(helper.getHibSession(), reference));
        }
        picture.setTimeStamp(new Date());
        picture.setDataFile(file.getBytes());
        helper.getHibSession().saveOrUpdate((Object)picture);
        helper.getHibSession().saveOrUpdate((Object)location);
        helper.getHibSession().flush();
        helper.setResponse(new RoomInterface.RoomPictureInterface(picture.getUniqueId(), picture.getFileName(), picture.getContentType(), picture.getTimeStamp().getTime(), RoomPicturesBackend.getPictureType(picture.getType())));
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        Location location;
        RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)helper.getRequest((Type)((Object)RoomInterface.RoomDetailInterface.class));
        if (room == null) {
            throw new IllegalArgumentException("No room data provided.");
        }
        Long roomId = helper.getOptinalParameterLong("roomId", null);
        if (roomId != null) {
            room.setUniqueId(roomId);
        }
        room.setSessionId(helper.getAcademicSessionId());
        if (room.getUniqueId() == null && room.getSessionId() == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        if (helper.getOptinalParameter("room", null) != null && (location = Location.findByName(helper.getHibSession(), room.getSessionId(), helper.getOptinalParameter("room", null))) != null) {
            room.setUniqueId(location.getUniqueId());
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)(room.getSessionId() != null ? room.getSessionId() : helper.getAcademicSessionId()), Right.ApiRoomEdit, new Qualifiable[0]);
        RoomInterface.RoomUpdateRpcRequest request = new RoomInterface.RoomUpdateRpcRequest();
        request.setLocationId(room.getUniqueId());
        request.setSessionId(helper.getAcademicSessionId());
        request.setRoom(room);
        request.setOperation(room.getUniqueId() == null ? RoomInterface.RoomUpdateRpcRequest.Operation.CREATE : RoomInterface.RoomUpdateRpcRequest.Operation.UPDATE);
        String[] flags = helper.getParameterValues("flag");
        int f = 0;
        if (flags != null) {
            for (String flag : flags) {
                f = RoomInterface.FutureOperation.valueOf(flag.toUpperCase()).set(f);
            }
        }
        if (f == 0) {
            f = RoomInterface.FutureOperation.PICTURES.clear(RoomInterface.FutureOperation.getFlagAllEnabled());
        }
        request.setFutureFlag(0L, f);
        if (helper.getOptinalParameterBoolean("future", false).booleanValue()) {
            if (room.getUniqueId() != null) {
                List futureLocations = helper.getHibSession().createQuery("select l from Location l, Location o where o.uniqueId = :uniqueId and l.permanentId = o.permanentId and o.session.sessionBeginDateTime < l.session.sessionBeginDateTime order by l.session.sessionBeginDateTime").setLong("uniqueId", room.getUniqueId().longValue()).list();
                for (Location loc : futureLocations) {
                    request.setFutureFlag(loc.getUniqueId(), f);
                }
            } else {
                List futureSessionIds = helper.getHibSession().createQuery("select f.uniqueId from Session f, Session s where s.uniqueId = :sessionId and s.sessionBeginDateTime < f.sessionBeginDateTime and s.academicInitiative = f.academicInitiative order by f.sessionBeginDateTime").setLong("sessionId", room.getSessionId().longValue()).list();
                for (Long id : futureSessionIds) {
                    request.setFutureFlag(-id.longValue(), f);
                }
            }
        }
        helper.setResponse(new RoomUpdateBackend().execute(request, helper.getSessionContext()));
    }

    @Override
    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new BinaryFileApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    @Override
    protected String getName() {
        return "rooms";
    }
}

