/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;

@Service(value="/distributionPrefsAjax")
public class DistributionPrefsAjax
extends Action {
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.addHeader("Content-Type", "text/xml; charset=UTF-8");
        request.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        out.print("<results>");
        this.coumputeSuggestionList(request, out);
        out.print("</results>");
        return null;
    }

    public String escapeXml(String s) {
        return (s == null ? "" : s).replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    protected void print(PrintWriter out, String id, String value) throws IOException {
        out.print("<result id=\"" + id + "\" value=\"" + this.escapeXml(value) + "\" />");
    }

    protected void print(PrintWriter out, String id, String value, String extra) throws IOException {
        out.print("<result id=\"" + id + "\" value=\"" + this.escapeXml(value) + "\" extra=\"" + this.escapeXml(extra) + "\" />");
    }

    protected void coumputeSuggestionList(HttpServletRequest request, PrintWriter out) throws Exception {
        if ("subjectArea".equals(request.getParameter("type"))) {
            this.coumputeCourseNumbers(request.getParameter("id"), out);
        } else if ("courseNbr".equals(request.getParameter("type"))) {
            this.coumputeSubparts(request.getParameter("id"), out);
        } else if ("itype".equals(request.getParameter("type"))) {
            this.coumputeClasses(request.getParameter("id"), out);
        } else if ("grouping".equals(request.getParameter("type"))) {
            this.coumputeGroupingDesc(request.getParameter("id"), out);
        } else if ("distType".equals(request.getParameter("type"))) {
            this.computePreferenceLevels(request.getParameter("id"), out);
        } else if ("exam".equals(request.getParameter("type"))) {
            this.coumputeExams(request.getParameter("id"), Long.valueOf(request.getParameter("examType")), out);
        }
    }

    protected void coumputeGroupingDesc(String groupingId, PrintWriter out) throws Exception {
        try {
            for (DistributionPref.Structure structure : DistributionPref.Structure.values()) {
                if (!structure.getName().equals(groupingId)) continue;
                this.print(out, "desc", structure.getDescription().replaceAll("<", "@lt@").replaceAll(">", "@gt@").replaceAll("\"", "@quot@").replaceAll("&", "@amp@"));
            }
        }
        catch (Exception e) {
            this.print(out, "desc", "");
        }
    }

    protected void computePreferenceLevels(String distTypeId, PrintWriter out) throws Exception {
        if (distTypeId == null || distTypeId.length() == 0 || distTypeId.equals("-")) {
            return;
        }
        DistributionType dist = (DistributionType)new DistributionTypeDAO().get(Long.valueOf(distTypeId));
        this.print(out, "desc", dist.getDescr().replaceAll("<", "@lt@").replaceAll(">", "@gt@").replaceAll("\"", "@quot@").replaceAll("&", "@amp@"));
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
            if (!dist.isAllowed(pref)) continue;
            this.print(out, pref.getPrefId().toString(), pref.getPrefName(), pref.prefcolor());
        }
    }

    protected void coumputeCourseNumbers(String subjectAreaId, PrintWriter out) throws Exception {
        if (subjectAreaId == null || subjectAreaId.length() == 0 || subjectAreaId.equals("-")) {
            return;
        }
        List courseNumbers = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false and co.isControl = true order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", Long.parseLong(subjectAreaId)).list();
        for (Object[] o : courseNumbers) {
            this.print(out, o[0].toString(), o[1].toString() + " - " + (o[2] == null ? "" : o[2]));
        }
    }

    protected void coumputeSubparts(String courseOfferingId, PrintWriter out) throws Exception {
        if (courseOfferingId == null || courseOfferingId.length() == 0 || courseOfferingId.equals("-")) {
            return;
        }
        TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
        subparts.addAll(new SchedulingSubpartDAO().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", Long.parseLong(courseOfferingId)).list());
        for (SchedulingSubpart s : subparts) {
            String id = s.getUniqueId().toString();
            String name = s.getItype().getAbbv();
            String sufix = s.getSchedulingSubpartSuffix();
            while (s.getParentSubpart() != null) {
                name = "_" + name;
                s = s.getParentSubpart();
            }
            if (s.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                name = name + " [" + s.getInstrOfferingConfig().getName() + "]";
            }
            this.print(out, id, name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")"));
        }
    }

    protected void coumputeClasses(String schedulingSubpartId, PrintWriter out) throws Exception {
        if (schedulingSubpartId == null || schedulingSubpartId.length() == 0 || schedulingSubpartId.equals("-")) {
            return;
        }
        TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
        classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId").setFetchSize(200).setCacheable(true).setLong("schedulingSubpartId", Long.parseLong(schedulingSubpartId)).list());
        this.print(out, "-1", MSG.dropDistrPrefAll());
        boolean suffix = ApplicationProperty.DistributionsShowClassSufix.isTrue();
        for (Class_ c : classes) {
            if (suffix) {
                String extId = c.getClassSuffix(c.getSchedulingSubpart().getControllingCourseOffering());
                this.print(out, c.getUniqueId().toString(), c.getSectionNumberString() + (extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId));
                continue;
            }
            this.print(out, c.getUniqueId().toString(), c.getSectionNumberString());
        }
    }

    protected void coumputeExams(String courseOfferingId, Long examType, PrintWriter out) throws Exception {
        if (courseOfferingId == null || courseOfferingId.length() == 0 || courseOfferingId.equals("-")) {
            return;
        }
        TreeSet exams = new TreeSet(Exam.findExamsOfCourseOffering(Long.valueOf(courseOfferingId), examType));
        if (exams.size() > 1 || exams.isEmpty()) {
            this.print(out, "-1", "-");
        }
        for (Exam exam : exams) {
            this.print(out, exam.getUniqueId().toString(), exam.getLabel().replaceAll("&", "@amp@"));
        }
    }
}

