/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.form.SuggestionsForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.SuggestionsModel;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="/suggestions")
public class SuggestionsAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SuggestionsForm myForm = (SuggestionsForm)form;
        try {
            Hint newAssignment;
            String id;
            String op;
            this.sessionContext.checkPermission(Right.Suggestions);
            SuggestionsModel model = (SuggestionsModel)request.getSession().getAttribute("Suggestions.model");
            if (model == null) {
                model = new SuggestionsModel();
                model.load(this.sessionContext.getUser());
                request.getSession().setAttribute("Suggestions.model", (Object)model);
            }
            SolverProxy solver = this.courseTimetablingSolverService.getSolver();
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if ("Reset".equals(op) || "Select".equals(op)) {
                id = request.getParameter("id");
                if (id == null) {
                    throw new Exception("No class selected.");
                }
                Long classId = Long.valueOf(id);
                if ("Reset".equals(op)) {
                    model.reset(solver);
                }
                model.setClassId(classId);
            }
            if ("Apply".equals(op)) {
                myForm.save(model);
                model.save(this.sessionContext.getUser());
            }
            if ("Search Deeper".equals(op)) {
                model.incDepth();
            }
            if ("Search Longer".equals(op)) {
                model.doubleTimeout();
            }
            if ("Remove".equals(op)) {
                id = request.getParameter("id");
                if (id == null) {
                    throw new Exception("No class selected.");
                }
                model.remHint(Long.valueOf(id));
            }
            if ("Try".equals(op)) {
                String room;
                if (request.getParameter("reset") != null) {
                    model.reset(solver);
                }
                id = request.getParameter("id");
                Vector<Long> roomIds = new Vector<Long>();
                int idx = 0;
                while ((room = request.getParameter("room" + idx)) != null) {
                    roomIds.addElement(Long.valueOf(room));
                    ++idx;
                }
                String days = request.getParameter("days");
                String slot = request.getParameter("slot");
                String pattern = request.getParameter("pattern");
                String dates = request.getParameter("dates");
                if (id == null) {
                    throw new Exception("No class selected.");
                }
                model.setClassId(new Long(id));
                if (days == null || slot == null || pattern == null) {
                    throw new Exception("No time selected.");
                }
                if (dates == null) {
                    throw new Exception("No dates selected.");
                }
                if (solver == null || solver.getInfo(new Hint(Long.valueOf(id), Integer.parseInt(days), Integer.parseInt(slot), roomIds, Long.valueOf(pattern), Long.valueOf(dates))) != null) {
                    model.addHint(Long.valueOf(id), Integer.parseInt(days), Integer.parseInt(slot), roomIds, Long.valueOf(pattern), Long.valueOf(dates));
                } else {
                    String message = solver.getNotValidReason(new Hint(Long.valueOf(id), Integer.parseInt(days), Integer.parseInt(slot), roomIds, Long.valueOf(pattern), Long.valueOf(dates)));
                    request.setAttribute("Suggestions.currentAssignmentMessage", (Object)("<script language='JavaScript'>alert('" + (message == null ? "Selected placement is not valid (room or instructor not avaiable)." : message) + "');</script>"));
                }
            }
            if ("Assign".equals(op)) {
                if (model.getSelectedSuggestion() != null) {
                    model.getSelectedSuggestion().assign(solver);
                } else if (model.getCurrentSuggestion() != null && model.getCurrentSuggestion().isCanAssign()) {
                    model.getCurrentSuggestion().assign(solver);
                } else {
                    throw new Exception("Nothing to assign.");
                }
                model.reset(solver);
                myForm.setOp("close");
                return mapping.findForward("showSuggestions");
            }
            if ("Unassign".equals(op)) {
                if (solver == null) {
                    throw new Exception("Solver not loaded.");
                }
                Hint unassignment = new Hint(model.getClassId(), 0, 0, new ArrayList<Long>(), null, null);
                ArrayList<Hint> assignments = new ArrayList<Hint>(1);
                assignments.add(unassignment);
                solver.assign(assignments);
                model.reset(solver);
                myForm.setOp("close");
                return mapping.findForward("showSuggestions");
            }
            if ("Suggestion".equals(op)) {
                id = request.getParameter("id");
                if (id == null) {
                    throw new Exception("No suggestion selected.");
                }
                model.selectSuggestion(Integer.parseInt(id));
            }
            if ("Placement".equals(op)) {
                id = request.getParameter("id");
                if (id == null) {
                    throw new Exception("No placement selected.");
                }
                model.selectPlacement(Integer.parseInt(id));
            }
            if ("ShowHistory".equals(op)) {
                model.reset(solver);
                int idx = Integer.parseInt(request.getParameter("hist"));
                TimetableSolver.AssignmentRecord record = solver.getAssignmentRecords().get(idx);
                for (TimetableSolver.RecordedAssignment assignment : record.getAssignments()) {
                    if (myForm.getId() == null) {
                        myForm.setId(assignment.getAfter() == null ? assignment.getBefore().getClassId() : assignment.getAfter().getClassId());
                    }
                    if (assignment.getBefore() == null) continue;
                    model.addHint(assignment.getBefore().getClassId(), assignment.getBefore().getDays(), assignment.getBefore().getStartSlot(), assignment.getBefore().getRoomIds(), assignment.getBefore().getPatternId(), assignment.getBefore().getDatePatternId());
                }
            }
            myForm.load(model);
            ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, solver, myForm.getId(), true);
            Hint hint = newAssignment = ca == null ? null : ca.getHint();
            if (model.compute(solver)) {
                String suggestions;
                String selectedInfo;
                myForm.load(model);
                myForm.setCanUnassign(ca.getAssignedTime() != null);
                Hashtable<Long, String> confInfo = new Hashtable<Long, String>();
                if (model.getSelectedSuggestion() != null) {
                    confInfo.putAll(model.getSelectedSuggestion().conflictInfo(solver));
                }
                if (model.getCurrentSuggestion() != null) {
                    confInfo.putAll(model.getCurrentSuggestion().conflictInfo(solver));
                }
                String selectedAssignments = this.getHintTable(model.getSimpleMode(), request, this.sessionContext, solver, "Selected Assignments", model.getHints(), null);
                if (model.getHints() != null) {
                    confInfo.putAll(solver.conflictInfo(model.getHints()));
                    Enumeration e = model.getHints().elements();
                    while (e.hasMoreElements()) {
                        Hint h = (Hint)e.nextElement();
                        if (ca == null || !ca.getClazz().getClassId().equals(h.getClassId())) continue;
                        newAssignment = h;
                    }
                }
                if (selectedAssignments != null) {
                    request.setAttribute("Suggestions.selectedAssignments", (Object)selectedAssignments);
                    myForm.setCanUnassign(false);
                }
                if (model.getSelectedSuggestion() != null) {
                    String selectedSuggestion;
                    Vector ass = new Vector(model.getSelectedSuggestion().getDifferentAssignments());
                    Iterator i = ass.iterator();
                    while (i.hasNext()) {
                        Hint h = (Hint)i.next();
                        if (ca != null && ca.getClazz().getClassId().equals(h.getClassId())) {
                            newAssignment = h;
                        }
                        boolean contains = false;
                        Enumeration e = model.getHints().elements();
                        while (!contains && e.hasMoreElements()) {
                            Hint x = (Hint)e.nextElement();
                            if (!x.equals(h)) continue;
                            contains = true;
                        }
                        if (!contains) continue;
                        i.remove();
                    }
                    String string2 = selectedSuggestion = model.getSelectedSuggestion() == null ? null : this.getHintTable(model.getSimpleMode(), request, this.sessionContext, solver, "Selected Suggestion", ass, confInfo);
                    if (selectedSuggestion != null) {
                        request.setAttribute("Suggestions.selectedSuggestion", selectedSuggestion);
                        myForm.setCanUnassign(false);
                    }
                }
                Suggestion s = model.getSelectedSuggestion() != null ? model.getSelectedSuggestion() : model.getCurrentSuggestion();
                Set conf = s == null ? null : s.getUnresolvedConflicts();
                String conflictAssignments = this.getHintTable(model.getSimpleMode(), request, this.sessionContext, solver, "Conflicting Assignments", conf, confInfo);
                if (conf != null) {
                    for (Hint h : conf) {
                        if (ca == null || !ca.getClazz().getClassId().equals(h.getClassId())) continue;
                        newAssignment = null;
                    }
                }
                if (conflictAssignments != null) {
                    request.setAttribute("Suggestions.conflictAssignments", (Object)conflictAssignments);
                }
                if ((selectedInfo = this.getInfoTable(model.getSimpleMode(), request, model.getEmptySuggestion(), model.getSelectedSuggestion() != null ? model.getSelectedSuggestion() : model.getCurrentSuggestion())) != null && s.isCanAssign()) {
                    request.setAttribute("Suggestions.selectedInfo", (Object)selectedInfo);
                }
                if ((suggestions = this.getSuggestionsTable(model.getSimpleMode(), request, this.sessionContext, solver, "Suggestions", "Suggestion", model, model.getSuggestions())) != null) {
                    request.setAttribute("Suggestions.suggestions", (Object)suggestions);
                }
                String message = null;
                message = model.getTimeoutReached() ? "(" + model.getTimeout() / 1000L + "s timeout reached, " + model.getNrCombinationsConsidered() + " possibilities up to " + model.getDepth() + " changes were considered, " : "(all " + model.getNrCombinationsConsidered() + " possibilities up to " + model.getDepth() + " changes were considered, ";
                message = model.getSuggestions().size() == 0 ? message + "no suggestion found)" : (model.getNrSolutions() > (long)model.getSuggestions().size() ? message + "top " + model.getSuggestions().size() + " of " + model.getNrSolutions() + " suggestions displayed)" : message + model.getSuggestions().size() + " suggestions displayed)");
                if (model.getNrCombinationsConsidered() == 0L) {
                    request.removeAttribute("Suggestions.suggestions");
                }
                request.setAttribute("Suggestions.suggestionsMessage", (Object)message);
                if (model.getTryAssignments() != null) {
                    String placements = this.getSuggestionsTable(model.getSimpleMode(), request, this.sessionContext, solver, "Placements", "Placement", model, model.getTryAssignments());
                    if (placements != null) {
                        request.setAttribute("Suggestions.placements", (Object)placements);
                    }
                    message = model.getNrTries() > (long)model.getTryAssignments().size() ? "(top " + model.getTryAssignments().size() + " of " + model.getNrTries() + " placements displayed)" : "(all " + model.getTryAssignments().size() + " placements displayed)";
                    request.setAttribute("Suggestions.placementsMessage", (Object)message);
                }
                if (model.getNrTries() == 0L) {
                    request.removeAttribute("Suggestions.placements");
                }
                if (model.getConfTable() != null && !model.getConfTable().isEmpty()) {
                    request.setAttribute("Suggestions.confTable", (Object)this.getConfTable(model.getSimpleMode(), request, this.sessionContext, solver, model, model.getConfTable()));
                }
            }
            if (ca != null) {
                String assignment = SuggestionsAction.getAssignmentTable(this.sessionContext, solver, ca, true, newAssignment);
                request.setAttribute("Suggestions.assignment", (Object)("<a href='classDetail.do?cid=" + ca.getClazz().getClassId() + "' target='_blank' class='l8' title='Open Class Detail for " + ca.getClassName() + " in a new window.'>" + ca.getClassName() + "</a>"));
                if (assignment != null) {
                    request.setAttribute("Suggestions.assignmentInfo", (Object)assignment);
                }
            }
            if (myForm.getId() != null) {
                request.setAttribute("Suggestions.id", (Object)myForm.getId());
            }
            return mapping.findForward("showSuggestions");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    public String getHintTable(boolean simple, HttpServletRequest request, SessionContext context, SolverProxy solver, String name, Collection hints, Hashtable confInfo) {
        if (hints == null || hints.isEmpty()) {
            return null;
        }
        boolean hasConfInfo = false;
        if (confInfo != null) {
            for (Hint hint : hints) {
                if (confInfo.get(hint) == null) continue;
                hasConfInfo = true;
                break;
            }
        }
        boolean remove = "Selected Assignments".equals(name);
        WebTable.setOrder(context, "suggestions.hints.ord", request.getParameter("hord"), 1);
        WebTable webTable = hasConfInfo ? (simple ? new WebTable(6, name, "suggestions.do?hord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Class", "Date", "Time", "Room", "Students", "Constraint"}, new String[]{"left", "left", "left", "left", "left", "left"}, null) : new WebTable(15, name, "suggestions.do?hord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Class", "Date", "Time", "Room", "Std", "Tm", "Rm", "Dist", "Ins", "Usl", "Big", "Dept", "Subp", "Pert", "Constraint"}, new String[]{"left", "left", "left", "left", "left", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right", "left"}, null)) : (simple ? new WebTable(6, name, "suggestions.do?hord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Class", "Date", "Time", "Room", "Students"}, new String[]{"left", "left", "left", "left", "left"}, null) : new WebTable(15, name, "suggestions.do?hord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Class", "Date", "Time", "Room", "Std", "Tm", "Rm", "Dist", "Ins", "Usl", "Big", "Dept", "Subp", "Pert"}, new String[]{"left", "left", "left", "left", "left", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right"}, null));
        webTable.setRowStyle("white-space:nowrap");
        try {
            int lines = 0;
            for (Hint hint : hints) {
                String conf;
                ++lines;
                String string = conf = confInfo == null ? null : (String)confInfo.get(hint);
                if (conf == null) {
                    conf = "";
                }
                ClassAssignmentDetails ca = null;
                ca = "Conflicting Assignments".equals(name) ? hint.getDetailsUnassign(context, solver, false) : hint.getDetails(context, solver, false);
                String remLink = null;
                if (remove) {
                    remLink = "<a href='suggestions.do?id=" + ca.getClazz().getClassId() + "&op=Remove&noCacheTS=" + new Date().getTime() + "'><img src='images/action_delete.png' border='0'></a>&nbsp;";
                }
                String[] line = new String[hasConfInfo ? (simple ? 6 : 15) : (simple ? 5 : 14)];
                Comparable[] cmp = new Comparable[hasConfInfo ? (simple ? 6 : 15) : (simple ? 5 : 14)];
                int i1 = 0;
                int i2 = 0;
                line[i1++] = (remLink == null ? "" : remLink) + ca.getClassHtml();
                line[i1++] = ca.getDaysHtml();
                line[i1++] = ca.getTimeHtml();
                line[i1++] = ca.getRoomHtml();
                line[i1++] = ca.getNrStudentConflicts();
                cmp[i2++] = ca;
                cmp[i2++] = ca.getDaysName();
                cmp[i2++] = ca.getTimeName();
                cmp[i2++] = ca.getRoomName();
                cmp[i2++] = ca.getNrStudentConflictsCmp();
                if (!simple) {
                    line[i1++] = ca.getTimePreference();
                    line[i1++] = ca.getRoomPreference();
                    line[i1++] = ca.getGroupConstraintPref();
                    line[i1++] = ca.getBtbInstructorPreference();
                    line[i1++] = ca.getUselessHalfHours();
                    line[i1++] = ca.getIsTooBig();
                    line[i1++] = ca.getDeptBalancPenalty();
                    line[i1++] = ca.getSpreadPenalty();
                    line[i1++] = ca.getPertPenalty();
                    cmp[i2++] = ca.getTimePreferenceCmp();
                    cmp[i2++] = ca.getRoomPreferenceCmp();
                    cmp[i2++] = ca.getGroupConstraintPrefCmp();
                    cmp[i2++] = ca.getBtbInstructorPreferenceCmp();
                    cmp[i2++] = ca.getUselessHalfHoursCmp();
                    cmp[i2++] = ca.getIsTooBigCmp();
                    cmp[i2++] = ca.getSpreadPenaltyCmp();
                    cmp[i2++] = ca.getDeptBalancPenaltyCmp();
                    cmp[i2++] = ca.getPertPenaltyCmp();
                }
                if (hasConfInfo) {
                    line[i1++] = conf;
                    cmp[i2++] = conf;
                }
                webTable.addLine(null, line, cmp);
            }
            if (lines == 0) {
                return null;
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable.printTable(WebTable.getOrder(context, "suggestions.hints.ord"));
    }

    public String getInfoTable(boolean simple, HttpServletRequest request, Suggestion oldSuggestion, Suggestion newSuggestion) {
        if (oldSuggestion == null || newSuggestion == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<TR><TD width='5%' nowrap>Not-assigned classes:</TD><TD width='2%' nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getUnassignedVariables(), oldSuggestion.getUnassignedVariables()) + "</TD></TR>");
        if (!simple) {
            sb.append("<TR><TD>Student conflicts:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getViolatedStudentConflicts(), (double)oldSuggestion.getViolatedStudentConflicts()) + "</TD></TR>");
            if (newSuggestion.getCommitedStudentConflicts() != 0L || oldSuggestion.getCommitedStudentConflicts() != 0L) {
                sb.append("<TR><TD>Commited student conflicts:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getCommitedStudentConflicts(), (double)oldSuggestion.getCommitedStudentConflicts()) + "</TD></TR>");
            }
            sb.append("<TR><TD>Distance student conflicts:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getDistanceStudentConflicts(), (double)oldSuggestion.getDistanceStudentConflicts()) + "</TD></TR>");
            sb.append("<TR><TD>Hard student conflicts:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getHardStudentConflicts(), (double)oldSuggestion.getHardStudentConflicts()) + "</TD></TR>");
            sb.append("<TR><TD>Time preferences:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getGlobalTimePreference(), oldSuggestion.getGlobalTimePreference()) + "</TD></TR>");
            sb.append("<TR><TD>Room preferences:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getGlobalRoomPreference(), (double)oldSuggestion.getGlobalRoomPreference()) + "</TD></TR>");
            sb.append("<TR><TD>Distribution preferences:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getGlobalGroupConstraintPreference(), (double)oldSuggestion.getGlobalGroupConstraintPreference()) + "</TD></TR>");
            sb.append("<TR><TD nowrap>Back-to-back instructor preferences:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getInstructorDistancePreference(), (double)oldSuggestion.getInstructorDistancePreference()) + "</TD></TR>");
            sb.append("<TR><TD>Too big rooms:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getTooBigRooms(), oldSuggestion.getTooBigRooms()) + "</TD></TR>");
            sb.append("<TR><TD>Useless half-hours:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getUselessSlots(), (double)oldSuggestion.getUselessSlots()) + "</TD></TR>");
            sb.append("<TR><TD>Department balancing penalty:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getDepartmentSpreadPenalty(), oldSuggestion.getDepartmentSpreadPenalty()) + "</TD></TR>");
            sb.append("<TR><TD>Same subpart balancing penalty:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getSpreadPenalty(), oldSuggestion.getSpreadPenalty()) + "</TD></TR>");
            sb.append("<TR><TD>Perturbation penalty:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getPerturbationPenalty(), oldSuggestion.getPerturbationPenalty()) + "</TD></TR>");
        }
        sb.append("<TR><TD nowrap>Overall solution value:</TD><TD nowrap>" + ClassAssignmentDetails.dispNumber(newSuggestion.getValue(), oldSuggestion.getValue()) + "</TD></TR>");
        if (newSuggestion.hasStudentConflictInfo()) {
            sb.append("<TR><TD nowrap>Student conflicts:</TD><TD colspan='2' nowrap>" + newSuggestion.getStudentConflictInfosAsHtml(this.sessionContext, this.courseTimetablingSolverService.getSolver(), true, 0, 3) + "</TD></TR>");
        }
        if (newSuggestion.hasDistributionConstraintInfo() || newSuggestion.hasBtbInstructorInfo()) {
            sb.append("<TR><TD nowrap>Violated constraints:</TD><TD colspan='2' nowrap>");
            if (newSuggestion.hasDistributionConstraintInfo()) {
                sb.append(newSuggestion.getDistributionConstraintInfoAsHtml(this.sessionContext, this.courseTimetablingSolverService.getSolver(), true, 0, -1));
            }
            if (newSuggestion.hasDistributionConstraintInfo() && newSuggestion.hasBtbInstructorInfo()) {
                sb.append("<BR>");
            }
            if (newSuggestion.hasBtbInstructorInfo()) {
                sb.append(newSuggestion.getBtbInstructorInfosAsHtml(this.sessionContext, this.courseTimetablingSolverService.getSolver(), true));
            }
            sb.append("</TD></TR>");
        }
        return sb.toString();
    }

    public String getSuggestionsTable(boolean simple, HttpServletRequest request, SessionContext context, SolverProxy solver, String name, String op, SuggestionsModel model, Collection suggestions) {
        WebTable.setOrder(context, "suggestions.suggestions." + op + ".ord", request.getParameter(op + "_ord"), 1);
        WebTable webTable = simple ? new WebTable(6, name, "suggestions.do?" + op + "_ord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Score", "Class", "Date", "Time", "Room", "Students"}, new String[]{"left", "left", "left", "left", "left", "left"}, null) : new WebTable(16, name, "suggestions.do?" + op + "_ord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Score", "Class", "Date", "Time", "Room", "Conf", "Std", "Tm", "Rm", "Dist", "Ins", "Usl", "Big", "Dept", "Subp", "Pert"}, new String[]{"left", "left", "left", "left", "left", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right"}, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            Suggestion empty = model.getEmptySuggestion();
            int idx = 0;
            for (Suggestion s : suggestions) {
                ClassAssignmentDetails ca;
                StringBuffer classes = new StringBuffer("<table colspan='0' rowspan='0' border='0'>");
                StringBuffer classesSort = new StringBuffer();
                StringBuffer rooms = new StringBuffer("<table colspan='0' rowspan='0' border='0'>");
                StringBuffer times = new StringBuffer("<table colspan='0' rowspan='0' border='0'>");
                StringBuffer roomsSort = new StringBuffer();
                StringBuffer timesSort = new StringBuffer();
                StringBuffer dates = new StringBuffer("<table colspan='0' rowspan='0' border='0'>");
                StringBuffer datesSort = new StringBuffer();
                for (Hint hint : s.getDifferentAssignments()) {
                    if (model.getHints().contains(hint) && (!"Placement".equals(op) || !model.getClassId().equals(hint.getClassId()))) continue;
                    ca = hint.getDetails(context, solver, false);
                    if (classesSort.length() > 0) {
                        classesSort.append(":");
                        datesSort.append(":");
                        roomsSort.append(":");
                        timesSort.append(":");
                    }
                    classes.append("<tr valign='top' height='25'><td nowrap>");
                    rooms.append("<tr valign='top' height='25'><td nowrap>");
                    times.append("<tr valign='top' height='25'><td nowrap>");
                    dates.append("<tr valign='top' height='25'><td nowrap>");
                    classes.append(ca.getClassHtml());
                    classesSort.append(ca.getClassName());
                    times.append(ca.getTimeHtml());
                    rooms.append(ca.getRoomHtml());
                    dates.append(ca.getDaysHtml());
                    timesSort.append(ca.getTimeNoHtml());
                    roomsSort.append(ca.getRoomNoHtml());
                    datesSort.append(ca.getDaysName());
                    classes.append("</td></tr>");
                    rooms.append("</td></tr>");
                    times.append("</td></tr>");
                    dates.append("</td></tr>");
                }
                for (Hint hint : s.getUnresolvedConflicts()) {
                    if (model.getHints().contains(hint)) continue;
                    ca = hint.getDetailsUnassign(context, solver, false);
                    if (classesSort.length() > 0) {
                        classesSort.append(":");
                        datesSort.append(":");
                        roomsSort.append(":");
                        timesSort.append(":");
                    }
                    classes.append("<tr valign='top' height='25'><td nowrap>");
                    classesSort.append(ca.getClassName());
                    rooms.append("<tr valign='top' height='25'><td nowrap>");
                    times.append("<tr valign='top' height='25'><td nowrap>");
                    dates.append("<tr valign='top' height='25'><td nowrap>");
                    classes.append(ca.getClassHtml());
                    times.append(ca.getTimeHtml());
                    rooms.append(ca.getRoomHtml());
                    dates.append(ca.getDaysHtml());
                    timesSort.append(ca.getTimeNoHtml());
                    roomsSort.append(ca.getRoomNoHtml());
                    datesSort.append(ca.getDaysName());
                    classes.append("</td></tr>");
                    rooms.append("</td></tr>");
                    times.append("</td></tr>");
                    dates.append("</td></tr>");
                }
                if (classesSort.length() != 0) {
                    classes.append("</table>");
                    rooms.append("</table>");
                    times.append("</table>");
                    dates.append("</table>");
                    StringBuffer sb = new StringBuffer();
                    if (s.getCommitedStudentConflicts() - empty.getCommitedStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append(ClassAssignmentDetails.dispNumber("c", (double)(s.getCommitedStudentConflicts() - empty.getCommitedStudentConflicts())));
                    }
                    if (s.getDistanceStudentConflicts() - empty.getDistanceStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append(ClassAssignmentDetails.dispNumber("d", (double)(s.getDistanceStudentConflicts() - empty.getDistanceStudentConflicts())));
                    }
                    if (s.getHardStudentConflicts() - empty.getHardStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append(ClassAssignmentDetails.dispNumber("h", (double)(s.getHardStudentConflicts() - empty.getHardStudentConflicts())));
                    }
                    if (sb.length() > 0) {
                        sb.append(")");
                    }
                    if (simple) {
                        webTable.addLine("onClick=\"document.location='suggestions.do?id=" + idx + "&op=" + op + "&noCacheTS=" + new Date().getTime() + "';\"", new String[]{ClassAssignmentDetails.dispNumber(s.getValue() - empty.getValue()), classes.toString(), dates.toString(), times.toString(), rooms.toString(), ClassAssignmentDetails.dispNumber(s.getViolatedStudentConflicts() - empty.getViolatedStudentConflicts()) + sb}, new Comparable[]{new Double(s.getValue() - empty.getValue()), classesSort.toString(), datesSort.toString(), timesSort.toString(), roomsSort.toString(), new Long(s.getViolatedStudentConflicts() - empty.getViolatedStudentConflicts())});
                    } else {
                        webTable.addLine("onClick=\"document.location='suggestions.do?id=" + idx + "&op=" + op + "&noCacheTS=" + new Date().getTime() + "';\"", new String[]{ClassAssignmentDetails.dispNumber(s.getValue() - empty.getValue()), classes.toString(), dates.toString(), times.toString(), rooms.toString(), ClassAssignmentDetails.dispNumber(s.getUnassignedVariables() - empty.getUnassignedVariables()), ClassAssignmentDetails.dispNumber(s.getViolatedStudentConflicts() - empty.getViolatedStudentConflicts()) + sb, ClassAssignmentDetails.dispNumber(s.getGlobalTimePreference() - empty.getGlobalTimePreference()), ClassAssignmentDetails.dispNumber(s.getGlobalRoomPreference() - empty.getGlobalRoomPreference()), ClassAssignmentDetails.dispNumber(s.getGlobalGroupConstraintPreference() - empty.getGlobalGroupConstraintPreference()), ClassAssignmentDetails.dispNumber(s.getInstructorDistancePreference() - empty.getInstructorDistancePreference()), ClassAssignmentDetails.dispNumber(s.getUselessSlots() - empty.getUselessSlots()), ClassAssignmentDetails.dispNumber(s.getTooBigRooms() - empty.getTooBigRooms()), ClassAssignmentDetails.dispNumber(s.getDepartmentSpreadPenalty() - empty.getDepartmentSpreadPenalty()), ClassAssignmentDetails.dispNumber(s.getSpreadPenalty() - empty.getSpreadPenalty()), ClassAssignmentDetails.dispNumber(s.getPerturbationPenalty() - empty.getPerturbationPenalty())}, new Comparable[]{new Double(s.getValue() - empty.getValue()), classes.toString(), datesSort.toString(), timesSort.toString(), roomsSort.toString(), new Integer(s.getUnassignedVariables() - empty.getUnassignedVariables()), new Long(s.getViolatedStudentConflicts() - empty.getViolatedStudentConflicts()), new Double(s.getGlobalTimePreference() - empty.getGlobalTimePreference()), new Long(s.getGlobalRoomPreference() - empty.getGlobalRoomPreference()), new Long(s.getGlobalGroupConstraintPreference() - empty.getGlobalGroupConstraintPreference()), new Long(s.getInstructorDistancePreference() - empty.getInstructorDistancePreference()), new Long(s.getUselessSlots() - empty.getUselessSlots()), new Long(s.getTooBigRooms() - empty.getTooBigRooms()), new Double(s.getDepartmentSpreadPenalty() - empty.getDepartmentSpreadPenalty()), new Double(s.getSpreadPenalty() - empty.getSpreadPenalty()), new Double(s.getPerturbationPenalty() - empty.getPerturbationPenalty())});
                    }
                }
                ++idx;
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable.printTable(WebTable.getOrder(context, "suggestions.suggestions." + op + ".ord"));
    }

    public static String getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca, boolean dispLinks) {
        return SuggestionsAction.getAssignmentTable(context, solver, ca, dispLinks, null, true);
    }

    public static String getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca, boolean dispLinks, Hint selection) {
        return SuggestionsAction.getAssignmentTable(context, solver, ca, dispLinks, selection, true);
    }

    public static String getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca, boolean dispLinks, Hint selection, boolean dispDate) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (ca.getTime() == null) {
            sb.append("<TR><TD colspan='2'><I>" + MSG.messageNotAssigned() + "</I></TD></TR>");
        } else {
            if (dispDate) {
                sb.append("<TR><TD>" + MSG.propertyDate() + "</TD><TD>" + ca.getAssignedTime().getDatePatternHtml() + "</TD></TR>");
            }
            sb.append("<TR><TD>" + MSG.propertyTime() + "</TD><TD>" + ca.getAssignedTime().toHtml(false, false, true, true) + "</TD></TR>");
            if (ca.getAssignedRoom() != null) {
                sb.append("<TR><TD>" + MSG.propertyRoom() + "</TD><TD>");
                for (i = 0; i < ca.getAssignedRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getAssignedRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInstructor() != null) {
            sb.append("<TR><TD>" + MSG.propertyInstructor() + "</TD><TD>" + ca.getInstructorHtml() + "</TD></TR>");
            if (!ca.getBtbInstructors().isEmpty()) {
                sb.append("<TR><TD></TD><TD>");
                Enumeration e = ca.getBtbInstructors().elements();
                while (e.hasMoreElements()) {
                    ClassAssignmentDetails.BtbInstructorInfo btb = (ClassAssignmentDetails.BtbInstructorInfo)e.nextElement();
                    sb.append(btb.toHtml(context, solver));
                    if (!e.hasMoreElements()) continue;
                    sb.append("<br>");
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInitialTime() != null) {
            sb.append("<TR><TD nowrap>" + MSG.propertyInitialAssignment() + "</TD><TD>");
            if (ca.isInitial()) {
                sb.append("<I>" + MSG.messageThisOne() + "</I>");
            } else {
                sb.append(ca.getInitialTime().toHtml(false, false, true, true) + " ");
                for (i = 0; i < ca.getInitialRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getInitialRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
            sb.append("</TD></TR>");
        }
        if (!ca.getStudentConflicts().isEmpty()) {
            sb.append("<TR><TD nowrap>" + MSG.propertyStudentConflicts() + "</TD><TD>");
            Collections.sort(ca.getStudentConflicts(), new ClassAssignmentDetails.StudentConflictInfoComparator(context, solver));
            Enumeration e = ca.getStudentConflicts().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.StudentConflictInfo std = (ClassAssignmentDetails.StudentConflictInfo)e.nextElement();
                sb.append(std.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (ca.hasViolatedGroupConstraint()) {
            sb.append("<TR><TD>" + MSG.propertyViolatedConstraints() + "</TD><TD>");
            Enumeration e = ca.getGroupConstraints().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.DistributionInfo gc = (ClassAssignmentDetails.DistributionInfo)e.nextElement();
                if (gc.getInfo().isSatisfied()) continue;
                sb.append(gc.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (dispLinks) {
            if (!ca.getRooms().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyRoomLocations() + "</TD><TD>" + ca.getRooms().toHtml(true, true, selection) + "</TD></TR>");
            } else {
                sb.append("<input type='hidden' name='nrRooms' value='0'/>");
                sb.append("<input type='hidden' name='roomState' value='0'/>");
            }
            if (!ca.getTimes().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyTimeLocations() + "</TD><TD>" + ca.getTimes().toHtml(true, true, selection) + "</TD></TR>");
                sb.append("<TR" + (ca.getTimes().getNrDates() <= 1 ? " style='display:none;'" : "") + "><TD nowrap>" + MSG.propertyDatePatterns() + "</TD><TD>" + ca.getTimes().toDatesHtml(true, true, selection) + "</TD></TR>");
            }
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getRoomCapacity() >= 0 && ca.getClazz().getRoomCapacity() < Integer.MAX_VALUE && ca.getClazz().nrRooms() > 0) {
            sb.append("<TR><TD>" + MSG.propertyMinimumRoomSize() + "</TD><TD>" + ca.getClazz().getRoomCapacity() + "</TD></TR>");
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getNote() != null) {
            sb.append("<TR><TD>" + MSG.propertyNote() + "</TD><TD>" + ca.getClazz().getNote().replaceAll("\n", "<BR>") + "</TD></TR>");
        }
        return sb.toString();
    }

    public String getConfTable(boolean simple, HttpServletRequest request, SessionContext context, SolverProxy solver, SuggestionsModel model, Collection suggestions) {
        WebTable.setOrder(context, "suggestions.suggestions.conf.ord", request.getParameter("conf_ord"), 1);
        boolean hasViolDistConst = false;
        for (Suggestion s : suggestions) {
            if (s.getGlobalGroupConstraintPreference() <= 0L) continue;
            hasViolDistConst = true;
            break;
        }
        WebTable webTable = hasViolDistConst ? new WebTable(5, "Conflict Table", "suggestions.do?conf_ord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Time", null, "Student Conflicts", null, "Violated Distr. Constr."}, new String[]{"left", "right", "left", "right", "left"}, null) : new WebTable(3, "Conflict Table", "suggestions.do?conf_ord=%%&noCacheTS=" + new Date().getTime(), new String[]{"Time", null, "Student Conflicts"}, new String[]{"left", "right", "left"}, null);
        webTable.setRowStyle("white-space:nowrap");
        int nrLines = 0;
        try {
            int idx = 0;
            for (Suggestion s : suggestions) {
                if (s.getDifferentAssignments() != null && !s.getDifferentAssignments().isEmpty()) {
                    Hint h = (Hint)s.getDifferentAssignments().firstElement();
                    ClassAssignmentDetails ca = h.getDetails(context, solver, false);
                    StringBuffer sb = new StringBuffer();
                    if (s.getCommitedStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append("c" + s.getCommitedStudentConflicts());
                    }
                    if (s.getDistanceStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append("d" + s.getDistanceStudentConflicts());
                    }
                    if (s.getHardStudentConflicts() != 0L) {
                        if (sb.length() == 0) {
                            sb.append(" (");
                        } else {
                            sb.append(",");
                        }
                        sb.append("h" + s.getHardStudentConflicts());
                    }
                    if (sb.length() > 0) {
                        sb.append(")");
                    }
                    ++nrLines;
                    if (hasViolDistConst) {
                        webTable.addLine(null, new String[]{ca.getAssignedTime().toHtml(true, true, true, false), (s.getViolatedStudentConflicts() > 0L ? "<font color='red'>" : "") + s.getViolatedStudentConflicts() + sb.toString() + (s.getViolatedStudentConflicts() > 0L ? "</font>" : ""), s.getStudentConflictInfosAsHtml(context, solver, true, idx + 1, 0), "" + s.getGlobalGroupConstraintPreference(), s.getDistributionConstraintInfoAsHtml(context, solver, true, idx + 1, 0)}, new Comparable[]{new Integer(-ca.getAssignedTime().getDays() * 1000 + ca.getAssignedTime().getStartSlot()), new Long(s.getViolatedStudentConflicts()), new Long(s.getViolatedStudentConflicts()), new Long(s.getGlobalGroupConstraintPreference()), new Long(s.getGlobalGroupConstraintPreference())});
                    } else {
                        webTable.addLine(null, new String[]{ca.getAssignedTime().toHtml(true, true, true, false), (s.getViolatedStudentConflicts() > 0L ? "<font color='red'>" : "") + s.getViolatedStudentConflicts() + sb.toString() + (s.getViolatedStudentConflicts() > 0L ? "</font>" : ""), s.getStudentConflictInfosAsHtml(context, solver, true, idx + 1, 0)}, new Comparable[]{new Integer(-ca.getAssignedTime().getDays() * 1000 + ca.getAssignedTime().getStartSlot()), new Long(s.getViolatedStudentConflicts()), new Long(s.getViolatedStudentConflicts())});
                    }
                }
                ++idx;
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        if (nrLines == 0) {
            return null;
        }
        return webTable.printTable(WebTable.getOrder(context, "suggestions.suggestions.conf.ord"));
    }
}

