/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SolverParamGroupsForm;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/solverParamGroups")
public class SolverParamGroupsAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List list;
        Session hibSession;
        Transaction tx;
        SolverParameterGroup group;
        SolverParameterGroupDAO dao;
        String op;
        SolverParamGroupsForm myForm = (SolverParamGroupsForm)form;
        this.sessionContext.checkPermission(Right.SolverParameterGroups);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
            op = request.getParameter("op2");
        }
        if (op == null) {
            myForm.setOp("List");
        }
        if ("Back".equals(op)) {
            myForm.reset(mapping, request);
        }
        if ("Add Solver Parameter Group".equals(op)) {
            myForm.reset(mapping, request);
            myForm.setOp("Save");
        }
        if ("Update".equals(op) || "Save".equals(op)) {
            ActionErrors errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                dao = new SolverParameterGroupDAO();
                SolverParameterGroup group2 = null;
                group2 = op.equals("Save") ? new SolverParameterGroup() : (SolverParameterGroup)dao.get(myForm.getUniqueId());
                group2.setName(myForm.getName());
                group2.setDescription(myForm.getDescription());
                group2.setType(myForm.getType());
                if (myForm.getOrder() < 0) {
                    group2.setOrder(new Integer(dao.findAll().size()));
                }
                dao.saveOrUpdate(group2);
                myForm.reset(mapping, request);
            }
        }
        if ("Edit".equals(op)) {
            String id = request.getParameter("id");
            ActionMessages errors = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
            } else {
                SolverParameterGroupDAO dao2 = new SolverParameterGroupDAO();
                group = (SolverParameterGroup)dao2.get(new Long(id));
                if (group == null) {
                    errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                } else {
                    myForm.setUniqueId(group.getUniqueId());
                    myForm.setName(group.getName());
                    myForm.setOrder(group.getOrder());
                    myForm.setType(group.getType());
                    myForm.setDescription(group.getDescription());
                    myForm.setOp("Update");
                }
            }
        }
        if ("Delete".equals(op)) {
            tx = null;
            try {
                dao = new SolverParameterGroupDAO();
                hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                group = (SolverParameterGroup)dao.get(myForm.getUniqueId(), hibSession);
                list = hibSession.createCriteria(SolverParameterGroup.class).add((Criterion)Restrictions.gt((String)"order", (Object)group.getOrder())).list();
                for (SolverParameterGroup g : list) {
                    g.setOrder(new Integer(g.getOrder() - 1));
                    dao.save(g, hibSession);
                }
                dao.delete(group, hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            myForm.reset(mapping, request);
        }
        if ("Move Up".equals(op) || "Move Down".equals(op)) {
            tx = null;
            try {
                dao = new SolverParameterGroupDAO();
                hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                group = (SolverParameterGroup)dao.get(myForm.getUniqueId(), hibSession);
                if ("Move Up".equals(op)) {
                    list = hibSession.createCriteria(SolverParameterGroup.class).add((Criterion)Restrictions.eq((String)"order", (Object)new Integer(group.getOrder() - 1))).list();
                    if (!list.isEmpty()) {
                        SolverParameterGroup prior = (SolverParameterGroup)list.get(0);
                        prior.setOrder(new Integer(prior.getOrder() + 1));
                        dao.save(prior, hibSession);
                        group.setOrder(new Integer(group.getOrder() - 1));
                        dao.save(group, hibSession);
                    }
                } else {
                    list = hibSession.createCriteria(SolverParameterGroup.class).add((Criterion)Restrictions.eq((String)"order", (Object)new Integer(group.getOrder() + 1))).list();
                    if (!list.isEmpty()) {
                        SolverParameterGroup next = (SolverParameterGroup)list.get(0);
                        next.setOrder(new Integer(next.getOrder() - 1));
                        dao.save(next, hibSession);
                        group.setOrder(new Integer(group.getOrder() + 1));
                        dao.save(group, hibSession);
                    }
                }
                myForm.setOrder(group.getOrder());
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            myForm.reset(mapping, request);
        }
        if ("List".equals(myForm.getOp())) {
            this.getSolverParameterGroups(request);
            return mapping.findForward("list");
        }
        return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
    }

    private void getSolverParameterGroups(HttpServletRequest request) throws Exception {
        Transaction tx = null;
        WebTable.setOrder(this.sessionContext, "solverParamGroups.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(3, null, "solverParamGroups.do?ord=%%", new String[]{"Order", "Name", "Type", "Description"}, new String[]{"left", "left", "left", "left"}, null);
        int size = 0;
        try {
            SolverParameterGroupDAO dao = new SolverParameterGroupDAO();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            List list = hibSession.createCriteria(SolverParameterGroup.class).addOrder(Order.asc((String)"order")).list();
            size = list.size();
            if (list.isEmpty()) {
                webTable.addLine(null, new String[]{"No solver parameter group defined."}, null, null);
            } else {
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    SolverParameterGroup group = (SolverParameterGroup)i.next();
                    String onClick = "onClick=\"document.location='solverParamGroups.do?op=Edit&id=" + group.getUniqueId() + "';\"";
                    String ops = "";
                    ops = group.getOrder() > 0 ? ops + "<img src='images/arrow_up.png' border='0' align='absmiddle' title='Move Up' onclick=\"solverParamGroupsForm.op2.value='Move Up';solverParamGroupsForm.uniqueId.value='" + group.getUniqueId() + "';solverParamGroupsForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
                    ops = i.hasNext() ? ops + "<img src='images/arrow_down.png' border='0' align='absmiddle' title='Move Down' onclick=\"solverParamGroupsForm.op2.value='Move Down';solverParamGroupsForm.uniqueId.value='" + group.getUniqueId() + "';solverParamGroupsForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
                    webTable.addLine(onClick, new String[]{ops, group.getName(), group.getSolverType().name().toLowerCase(), group.getDescription()}, new Comparable[]{group.getOrder(), group.getName(), group.getType(), group.getDescription()});
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        request.setAttribute("SolverParameterGroup.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "solverParamGroups.ord")));
        request.setAttribute("SolverParameterGroup.last", (Object)new Integer(size - 1));
    }
}

