/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SolverInfoDefForm;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.dao.SolverInfoDefDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/solverInfoDef")
public class SolverInfoDefAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolverInfoDef info;
        SolverInfoDefDAO dao;
        String op;
        SolverInfoDefForm myForm = (SolverInfoDefForm)form;
        this.sessionContext.checkPermission(Right.SolutionInformationDefinitions);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null) {
            myForm.setOp("Add New");
            op = "list";
        }
        if ("Clear".equals(op)) {
            myForm.reset(mapping, request);
            myForm.setOp("Add New");
        }
        if ("Update".equals(op) || "Add New".equals(op)) {
            ActionErrors errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                mapping.findForward("showSolverInfoDef");
            } else {
                dao = new SolverInfoDefDAO();
                SolverInfoDef info2 = null;
                info2 = op.equals("Add New") ? new SolverInfoDef() : (SolverInfoDef)dao.get(myForm.getUniqueId());
                info2.setName(myForm.getName());
                info2.setDescription(myForm.getDescription());
                info2.setImplementation(myForm.getImplementation());
                dao.saveOrUpdate(info2);
                myForm.reset(mapping, request);
                myForm.setOp("Add New");
            }
        }
        if (op.equals("Edit")) {
            String id = request.getParameter("id");
            ActionMessages errors = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
                mapping.findForward("showSolverInfoDef");
            } else {
                SolverInfoDefDAO dao2 = new SolverInfoDefDAO();
                info = (SolverInfoDef)dao2.get(new Long(id));
                if (info == null) {
                    errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                    mapping.findForward("showSolverInfoDef");
                } else {
                    myForm.setUniqueId(info.getUniqueId());
                    myForm.setName(info.getName());
                    myForm.setDescription(info.getDescription());
                    myForm.setImplementation(info.getImplementation());
                    myForm.setOp("Update");
                }
            }
        }
        if ("Delete".equals(op)) {
            Transaction tx = null;
            try {
                dao = new SolverInfoDefDAO();
                Session hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                info = (SolverInfoDef)dao.get(myForm.getUniqueId(), hibSession);
                dao.delete(info, hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            myForm.reset(mapping, request);
            myForm.setOp("Add New");
        }
        this.getSolverInfoDefs(request);
        return mapping.findForward("showSolverInfoDef");
    }

    private void getSolverInfoDefs(HttpServletRequest request) throws Exception {
        Transaction tx = null;
        WebTable.setOrder(this.sessionContext, "solverInfoDef.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(3, "Solution Info Definitions", "solverInfoDef.do?ord=%%", new String[]{"Name", "Description", "Implementation"}, new String[]{"left", "left", "left"}, null);
        try {
            List list;
            SolverInfoDefDAO dao = new SolverInfoDefDAO();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((list = hibSession.createCriteria(SolverInfoDef.class).list()).isEmpty()) {
                webTable.addLine(null, new String[]{"No solution info defined."}, null, null);
            } else {
                for (SolverInfoDef info : list) {
                    String onClick = "onClick=\"document.location='solverInfoDef.do?op=Edit&id=" + info.getUniqueId() + "';\"";
                    webTable.addLine(onClick, new String[]{info.getName(), info.getDescription(), info.getImplementation()}, new Comparable[]{info.getName(), info.getDescription(), info.getImplementation()});
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        request.setAttribute("SolverInfoDef.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "solverInfoDef.ord")));
    }
}

