/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SettingsForm;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.dao.SettingsDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/settings")
public class SettingsAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.SettingsAdmin);
        SettingsForm settingsForm = (SettingsForm)form;
        String op = settingsForm.getOp();
        if (op == null && (op = request.getParameter("op")) == null) {
            op = settingsForm.getOp();
        }
        if (op.equals("Back")) {
            settingsForm.reset(mapping, request);
        }
        if (op.equals("Add Setting")) {
            settingsForm.reset(mapping, request);
            settingsForm.setOp("Save");
        }
        if (op.equals("Save") || op.equals("Update")) {
            ActionErrors errors = settingsForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                SettingsDAO sdao = new SettingsDAO();
                Settings s = null;
                s = op.equals("Save") ? new Settings() : (Settings)sdao.get(settingsForm.getUniqueId());
                s.setKey(settingsForm.getKey());
                s.setDefaultValue(settingsForm.getDefaultValue());
                s.setAllowedValues(settingsForm.getAllowedValues());
                s.setDescription(settingsForm.getDescription());
                sdao.saveOrUpdate(s);
                settingsForm.reset(mapping, request);
            }
        }
        if (op.equals("Edit")) {
            String id = request.getParameter("id");
            ActionMessages errors = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
            } else {
                SettingsDAO sdao = new SettingsDAO();
                Settings s = (Settings)sdao.get(new Long(id));
                if (s == null) {
                    errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                } else {
                    settingsForm.setUniqueId(s.getUniqueId());
                    settingsForm.setKey(s.getKey());
                    settingsForm.setDefaultValue(s.getDefaultValue());
                    settingsForm.setAllowedValues(s.getAllowedValues());
                    settingsForm.setDescription(s.getDescription());
                    settingsForm.setOp("Update");
                }
            }
        }
        if (op.equals("Delete")) {
            SettingsDAO sdao = new SettingsDAO();
            sdao.delete(settingsForm.getUniqueId());
            settingsForm.reset(mapping, request);
        }
        if ("List".equals(settingsForm.getOp())) {
            this.getSettingsList(request);
            return mapping.findForward("list");
        }
        return mapping.findForward("Save".equals(settingsForm.getOp()) ? "add" : "edit");
    }

    private void getSettingsList(HttpServletRequest request) throws Exception {
        WebTable.setOrder(this.sessionContext, "settings.ord", request.getParameter("ord"), 1);
        Session hibSession = null;
        WebTable webTable = new WebTable(4, null, "settings.do?ord=%%", new String[]{"Reference", "Description", "Default Value", "Allowed Values"}, new String[]{"left", "left", "left", "left"}, null);
        try {
            SettingsDAO sDao = new SettingsDAO();
            hibSession = sDao.getSession();
            List settingsList = hibSession.createCriteria(Settings.class).addOrder(Order.asc((String)"key")).list();
            if (settingsList.size() == 0) {
                webTable.addLine(null, new String[]{"No user settings found"}, null, null);
            } else {
                for (Settings s : settingsList) {
                    String key = s.getKey();
                    String defaultValue = s.getDefaultValue();
                    String allowedValues = s.getAllowedValues();
                    String description = s.getDescription();
                    String onClick = "onClick=\"document.location='settings.do?op=Edit&id=" + s.getUniqueId() + "';\"";
                    webTable.addLine(onClick, new String[]{key, description, defaultValue, allowedValues}, (Comparable[])new String[]{key, description, defaultValue, allowedValues}, null);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "settings.ord")));
    }
}

