/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.CSVFile;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.RoomListForm;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDepartmentRoomFeature;
import org.unitime.timetable.model.base.BaseRoomFeature;
import org.unitime.timetable.model.comparators.DepartmentNameComparator;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="/roomList")
public class RoomListAction
extends Action {
    public static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.Rooms);
        RoomListForm roomListForm = (RoomListForm)form;
        roomListForm.save(request.getSession());
        ActionMessages errors = new ActionMessages();
        String dept = (String)request.getAttribute("deptCode");
        if (dept != null) {
            roomListForm.setDeptCodeX(dept);
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null && roomListForm.getDeptCodeX() == null) {
            roomListForm.setDeptCodeX((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        if (roomListForm.getDeptCodeX() != null && !roomListForm.getDeptCodeX().isEmpty()) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)roomListForm.getDeptCodeX());
        }
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        errors = roomListForm.validate(mapping, request);
        if (errors.size() > 0) {
            this.saveErrors(request, errors);
            return mapping.findForward("showRoomSearch");
        }
        this.lookupRooms(roomListForm, request.getParameter("op"));
        if (roomListForm.getRooms() == null || roomListForm.getRooms().isEmpty()) {
            errors.add("searchResult", new ActionMessage("errors.generic", (Object)"No room matching the above criteria was found."));
            request.setAttribute("colspan", (Object)"7");
            this.saveErrors(request, errors);
            return mapping.findForward("showRoomSearch");
        }
        ExamType examType = null;
        if (roomListForm.getDeptCodeX() != null && roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            examType = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(roomListForm.getDeptCodeX().substring(4)));
        }
        if ("Export PDF".equals(request.getParameter("op"))) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "rooms");
            this.buildPdfWebTable(out, roomListForm, CommonValues.Yes.eq(UserProperty.RoomFeaturesInOneColumn.get(this.sessionContext.getUser())), examType);
            out.flush();
            out.close();
            return null;
        }
        if ("Export CSV".equals(request.getParameter("op"))) {
            PrintWriter pw = ExportUtils.getCsvWriter(response, "rooms");
            this.buildCsvWebTable(pw, roomListForm, CommonValues.Yes.eq(UserProperty.RoomFeaturesInOneColumn.get(this.sessionContext.getUser())), examType);
            pw.flush();
            pw.close();
            return null;
        }
        this.buildWebTable(request, roomListForm, CommonValues.Yes.eq(UserProperty.RoomFeaturesInOneColumn.get(this.sessionContext.getUser())), examType);
        return mapping.findForward("showRoomList");
    }

    public void lookupRooms(RoomListForm form, String op) {
        int i;
        int i2;
        String from = "Location l left join l.roomDepts rd left join l.examTypes xt left join fetch l.features f left join fetch l.roomGroups g left join fetch l.roomType t";
        String where = "l.session.uniqueId = :sessionId";
        ArrayList<Long> departmentIds = null;
        Long examTypeId = null;
        if (form.getDeptCodeX().equalsIgnoreCase("All")) {
            if (!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                departmentIds = new ArrayList<Long>();
                String depts = "";
                for (Department department : Department.getUserDepartments(this.sessionContext.getUser())) {
                    depts = depts + (depts.isEmpty() ? "" : ",") + ":dept" + departmentIds.size();
                    departmentIds.add(department.getUniqueId());
                }
                where = where + " and (rd.department.uniqueId in (" + depts + ") or l.eventDepartment.uniqueId in (" + depts + "))";
            }
        } else if (form.getDeptCodeX().equals("Exam")) {
            TreeSet<ExamType> types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
            if (!types.isEmpty()) {
                examTypeId = types.first().getUniqueId();
                form.setDeptCodeX("Exam" + examTypeId);
                where = where + " and xt.uniqueId = :examTypeId";
            }
        } else if (form.getDeptCodeX().matches("Exam[0-9]*")) {
            examTypeId = Long.valueOf(form.getDeptCodeX().substring(4));
            where = where + " and xt.uniqueId = :examTypeId";
        } else {
            Department department = Department.findByDeptCode(form.getDeptCodeX(), this.sessionContext.getUser().getCurrentAcademicSessionId());
            if (department != null) {
                if ("Export PDF".equals(op)) {
                    this.sessionContext.checkPermission(Right.RoomsExportPdf);
                } else if ("Export CSV".equals(op)) {
                    this.sessionContext.checkPermission(Right.RoomsExportCsv);
                } else {
                    this.sessionContext.checkPermission(Right.Rooms);
                }
                where = where + " and (rd.department.uniqueId = :dept0 or l.eventDepartment.uniqueId = :dept0)";
                departmentIds = new ArrayList();
                departmentIds.add(department.getUniqueId());
            } else {
                return;
            }
        }
        Integer minSize = null;
        Integer maxSize = null;
        if (form.getMinRoomSize() != null && !form.getMinRoomSize().isEmpty()) {
            try {
                minSize = Integer.valueOf(form.getMinRoomSize());
                where = where + " and l.capacity >= :minSize";
            }
            catch (NumberFormatException department) {
                // empty catch block
            }
        }
        if (form.getMaxRoomSize() != null && !form.getMaxRoomSize().isEmpty()) {
            try {
                maxSize = Integer.valueOf(form.getMaxRoomSize());
                where = where + " and l.capacity <= :maxSize";
            }
            catch (NumberFormatException department) {
                // empty catch block
            }
        }
        ArrayList<Long> roomTypes = null;
        if (form.getRoomTypes() != null && form.getRoomTypes().length > 0) {
            String types = "";
            roomTypes = new ArrayList<Long>();
            for (int i3 = 0; i3 < form.getRoomTypes().length; ++i3) {
                types = types + (types.isEmpty() ? "" : ",") + ":type" + i3;
                roomTypes.add(form.getRoomTypes()[i3]);
            }
            where = where + " and l.roomType.uniqueId in (" + types + ")";
        }
        ArrayList<Long> roomGroups = null;
        if (form.getRoomGroups() != null && form.getRoomGroups().length > 0) {
            String groups = "";
            roomGroups = new ArrayList<Long>();
            for (i2 = 0; i2 < form.getRoomGroups().length; ++i2) {
                groups = groups + (groups.isEmpty() ? "" : ",") + ":group" + i2;
                roomGroups.add(form.getRoomGroups()[i2]);
            }
            where = where + " and g.uniqueId in (" + groups + ")";
        }
        ArrayList<Long> roomFeatures = null;
        if (form.getRoomFeatures() != null && form.getRoomFeatures().length > 0) {
            roomFeatures = new ArrayList<Long>();
            for (i2 = 0; i2 < form.getRoomFeatures().length; ++i2) {
                from = from + " inner join l.features f" + i2;
                where = where + " and f" + i2 + ".uniqueId = :feature" + i2;
                roomFeatures.add(form.getRoomFeatures()[i2]);
            }
        }
        String filter = null;
        if (form.getFilter() != null && !form.getFilter().isEmpty()) {
            filter = form.getFilter();
            where = where + " and ((l.class = Room and (lower(l.buildingAbbv || ' ' || l.roomNumber) like :filter or lower(l.displayName) like :filter)) or (l.class = NonUniversityLocation and lower(l.name) like :filter))";
        }
        Query query = LocationDAO.getInstance().getSession().createQuery("select distinct l from " + from + " where " + where);
        query.setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue());
        if (departmentIds != null) {
            for (i = 0; i < departmentIds.size(); ++i) {
                query.setLong("dept" + i, ((Long)departmentIds.get(i)).longValue());
            }
        }
        if (examTypeId != null) {
            query.setLong("examTypeId", examTypeId.longValue());
        }
        if (minSize != null) {
            query.setInteger("minSize", minSize.intValue());
        }
        if (maxSize != null) {
            query.setInteger("maxSize", maxSize.intValue());
        }
        if (filter != null) {
            query.setString("filter", "%" + filter.toLowerCase() + "%");
        }
        if (roomTypes != null) {
            for (i = 0; i < roomTypes.size(); ++i) {
                query.setLong("type" + i, ((Long)roomTypes.get(i)).longValue());
            }
        }
        if (roomGroups != null) {
            for (i = 0; i < roomGroups.size(); ++i) {
                query.setLong("group" + i, ((Long)roomGroups.get(i)).longValue());
            }
        }
        if (roomFeatures != null) {
            for (i = 0; i < roomFeatures.size(); ++i) {
                query.setLong("feature" + i, ((Long)roomFeatures.get(i)).longValue());
            }
        }
        form.setRooms(query.setCacheable(true).list());
    }

    private void buildWebTable(HttpServletRequest request, RoomListForm roomListForm, boolean featuresOneColumn, ExamType examType) throws Exception {
        ActionMessages errors = new ActionMessages();
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        DecimalFormat dfa = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value());
        Collection rooms = roomListForm.getRooms();
        if (rooms.size() == 0) {
            errors.add("searchResult", new ActionMessage("errors.generic", (Object)"No rooms for the selected department were found."));
            this.saveErrors(request, errors);
        } else {
            int i;
            String[][] stringArrayArray;
            String[][] stringArrayArray2;
            String colArea;
            ArrayList<GlobalRoomFeature> globalRoomFeatures = new ArrayList<GlobalRoomFeature>();
            TreeSet deptRoomFeatures = new TreeSet();
            AbstractSet depts = null;
            if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                depts = Department.getUserDepartments(this.sessionContext.getUser());
            } else if (roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                depts = new HashSet(0);
            } else {
                depts = new HashSet(1);
                depts.add((Department)Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId));
            }
            org.hibernate.Session hibSession = null;
            try {
                RoomFeatureDAO d = new RoomFeatureDAO();
                hibSession = d.getSession();
                List list = hibSession.createCriteria(GlobalRoomFeature.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).addOrder(Order.asc((String)"label")).list();
                for (Object rf : list) {
                    globalRoomFeatures.add((GlobalRoomFeature)rf);
                }
                Debug.debug("global room feature: " + globalRoomFeatures.size());
                if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                    if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                        deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                    } else {
                        String deptIds = "";
                        for (Qualifiable qualifiable : this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")) {
                            if (!deptIds.isEmpty()) {
                                deptIds = deptIds + ",";
                            }
                            deptIds = deptIds + qualifiable.getQualifierId();
                        }
                        if (!deptIds.isEmpty()) {
                            deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.uniqueId in (" + deptIds + ") order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                        }
                    }
                } else if (!roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                    deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.deptCode = :deptCode order by f.label").setLong("sessionId", sessionId.longValue()).setString("deptCode", roomListForm.getDeptCodeX()).setCacheable(true).list());
                }
                Debug.debug("manager room feature: " + deptRoomFeatures.size());
            }
            catch (Exception e) {
                Debug.error(e);
            }
            String string = colArea = ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.columnAreaMetric() : MSG.columnArea();
            if (examType != null) {
                if (featuresOneColumn) {
                    String[][] stringArrayArray3 = new String[8][];
                    stringArrayArray3[0] = new String[]{"Bldg", "left", "true"};
                    stringArrayArray3[1] = new String[]{"Room", "left", "true"};
                    stringArrayArray3[2] = new String[]{"Capacity", "right", "false"};
                    stringArrayArray3[3] = new String[]{"Exam Capacity", "right", "false"};
                    stringArrayArray3[4] = new String[]{colArea, "right", "false"};
                    stringArrayArray3[5] = new String[]{"Period Preferences", "center", "false"};
                    stringArrayArray3[6] = new String[]{"Groups", "left", "true"};
                    stringArrayArray2 = stringArrayArray3;
                    stringArrayArray3[7] = new String[]{"Features", "left", "true"};
                } else {
                    String[][] stringArrayArray4 = new String[7][];
                    stringArrayArray4[0] = new String[]{"Bldg", "left", "true"};
                    stringArrayArray4[1] = new String[]{"Room", "left", "true"};
                    stringArrayArray4[2] = new String[]{"Capacity", "right", "false"};
                    stringArrayArray4[3] = new String[]{colArea, "right", "false"};
                    stringArrayArray4[4] = new String[]{"Exam Capacity", "right", "false"};
                    stringArrayArray4[5] = new String[]{"Period Preferences", "center", "false"};
                    stringArrayArray2 = stringArrayArray4;
                    stringArrayArray4[6] = new String[]{"Groups", "left", "true"};
                }
            } else if (featuresOneColumn) {
                String[][] stringArrayArray5 = new String[10][];
                stringArrayArray5[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray5[1] = new String[]{"Room", "left", "true"};
                stringArrayArray5[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray5[3] = new String[]{colArea, "right", "false"};
                stringArrayArray5[4] = new String[]{"Availability", "left", "true"};
                stringArrayArray5[5] = new String[]{"Departments", "left", "true"};
                stringArrayArray5[6] = new String[]{"Control", "left", "true"};
                stringArrayArray5[7] = new String[]{"Events", "left", "true"};
                stringArrayArray5[8] = new String[]{"Groups", "left", "true"};
                stringArrayArray2 = stringArrayArray5;
                stringArrayArray5[9] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray6 = new String[9][];
                stringArrayArray6[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray6[1] = new String[]{"Room", "left", "true"};
                stringArrayArray6[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray6[3] = new String[]{colArea, "right", "false"};
                stringArrayArray6[4] = new String[]{"Availability", "left", "true"};
                stringArrayArray6[5] = new String[]{"Departments", "left", "true"};
                stringArrayArray6[6] = new String[]{"Control", "left", "true"};
                stringArrayArray6[7] = new String[]{"Events", "left", "true"};
                stringArrayArray2 = stringArrayArray6;
                stringArrayArray6[8] = new String[]{"Groups", "left", "true"};
            }
            String[][] fixedHeading1 = stringArrayArray2;
            String[] heading1 = new String[fixedHeading1.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
            String[] alignment1 = new String[heading1.length];
            boolean[] blArray = new boolean[heading1.length];
            for (int i2 = 0; i2 < fixedHeading1.length; ++i2) {
                heading1[i2] = fixedHeading1[i2][0];
                alignment1[i2] = fixedHeading1[i2][1];
                blArray[i2] = Boolean.valueOf(fixedHeading1[i2][2]);
            }
            if (!featuresOneColumn) {
                int i2 = fixedHeading1.length;
                for (GlobalRoomFeature grf : globalRoomFeatures) {
                    heading1[i2] = "<span title='" + grf.getLabel() + "'>" + grf.getAbbv() + "</span>";
                    alignment1[i2] = "center";
                    blArray[i2] = true;
                    ++i2;
                }
                for (DepartmentRoomFeature drf : deptRoomFeatures) {
                    String title = drf.getLabel();
                    if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                        Department dept = drf.getDepartment();
                        title = title + " (" + dept.getShortLabel() + ")";
                    }
                    heading1[i2] = "<span title='" + title + "'>" + drf.getAbbv() + "</span>";
                    alignment1[i2] = "center";
                    blArray[i2] = true;
                    ++i2;
                }
            }
            if (examType != null) {
                if (featuresOneColumn) {
                    String[][] stringArrayArray7 = new String[7][];
                    stringArrayArray7[0] = new String[]{"Location", "left", "true"};
                    stringArrayArray7[1] = new String[]{"Capacity", "right", "false"};
                    stringArrayArray7[2] = new String[]{"Exam Capacity", "right", "false"};
                    stringArrayArray7[3] = new String[]{colArea, "right", "false"};
                    stringArrayArray7[4] = new String[]{"Period Preferences", "center", "false"};
                    stringArrayArray7[5] = new String[]{"Groups", "left", "true"};
                    stringArrayArray = stringArrayArray7;
                    stringArrayArray7[6] = new String[]{"Features", "left", "true"};
                } else {
                    String[][] stringArrayArray8 = new String[6][];
                    stringArrayArray8[0] = new String[]{"Location", "left", "true"};
                    stringArrayArray8[1] = new String[]{"Capacity", "right", "false"};
                    stringArrayArray8[2] = new String[]{"Exam Capacity", "right", "false"};
                    stringArrayArray8[3] = new String[]{colArea, "right", "false"};
                    stringArrayArray8[4] = new String[]{"Period Preferences", "center", "false"};
                    stringArrayArray = stringArrayArray8;
                    stringArrayArray8[5] = new String[]{"Groups", "left", "true"};
                }
            } else if (featuresOneColumn) {
                String[][] stringArrayArray9 = new String[11][];
                stringArrayArray9[0] = new String[]{"Location", "left", "true"};
                stringArrayArray9[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray9[2] = new String[]{colArea, "right", "false"};
                stringArrayArray9[3] = new String[]{"IgnTooFar", "center", "true"};
                stringArrayArray9[4] = new String[]{"IgnChecks", "center", "true"};
                stringArrayArray9[5] = new String[]{"Availability", "left", "true"};
                stringArrayArray9[6] = new String[]{"Departments", "left", "true"};
                stringArrayArray9[7] = new String[]{"Control", "left", "true"};
                stringArrayArray9[8] = new String[]{"Events", "left", "true"};
                stringArrayArray9[9] = new String[]{"Groups", "left", "true"};
                stringArrayArray = stringArrayArray9;
                stringArrayArray9[10] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray10 = new String[10][];
                stringArrayArray10[0] = new String[]{"Location", "left", "true"};
                stringArrayArray10[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray10[2] = new String[]{colArea, "right", "false"};
                stringArrayArray10[3] = new String[]{"IgnTooFar", "center", "true"};
                stringArrayArray10[4] = new String[]{"IgnChecks", "center", "true"};
                stringArrayArray10[5] = new String[]{"Availability", "left", "true"};
                stringArrayArray10[6] = new String[]{"Departments", "left", "true"};
                stringArrayArray10[7] = new String[]{"Control", "left", "true"};
                stringArrayArray10[8] = new String[]{"Events", "left", "true"};
                stringArrayArray = stringArrayArray10;
                stringArrayArray10[9] = new String[]{"Groups", "left", "true"};
            }
            String[][] fixedHeading2 = stringArrayArray;
            String[] heading2 = new String[fixedHeading2.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
            String[] alignment2 = new String[heading2.length];
            boolean[] sorted2 = new boolean[heading2.length];
            for (i = 0; i < fixedHeading2.length; ++i) {
                heading2[i] = fixedHeading2[i][0];
                alignment2[i] = fixedHeading2[i][1];
                sorted2[i] = Boolean.valueOf(fixedHeading2[i][2]);
            }
            if (!featuresOneColumn) {
                i = fixedHeading2.length;
                for (GlobalRoomFeature grf : globalRoomFeatures) {
                    heading2[i] = "<span title='" + grf.getLabel() + "'>" + grf.getAbbv() + "</span>";
                    alignment2[i] = "center";
                    sorted2[i] = true;
                    ++i;
                }
                for (Object drf : deptRoomFeatures) {
                    String title = ((BaseRoomFeature)drf).getLabel();
                    if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                        Department dept = ((BaseDepartmentRoomFeature)drf).getDepartment();
                        title = title + " (" + dept.getShortLabel() + ")";
                    }
                    heading2[i] = "<span title='" + title + "'>" + ((RoomFeature)drf).getAbbv() + "</span>";
                    alignment2[i] = "center";
                    sorted2[i] = true;
                    ++i;
                }
            }
            TreeSet roomTypes = new TreeSet(RoomTypeDAO.getInstance().findAll());
            Hashtable<RoomType, WebTable> tables = new Hashtable<RoomType, WebTable>();
            for (RoomType t : roomTypes) {
                WebTable.setOrder(this.sessionContext, t.getReference() + ".ord", request.getParameter(t.getReference() + "Ord"), 1);
                WebTable table = t.isRoom() != false ? new WebTable(heading1.length, t.getLabel(), "roomList.do?" + t.getReference() + "Ord=%%", heading1, alignment1, blArray) : new WebTable(heading2.length, t.getLabel(), "roomList.do?" + t.getReference() + "Ord=%%", heading2, alignment2, sorted2);
                table.setRowStyle("white-space:nowrap");
                tables.put(t, table);
            }
            boolean timeVertical = CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
            boolean gridAsText = CommonValues.TextGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
            String timeGridSize = UserProperty.GridSize.get(this.sessionContext.getUser());
            Department dept = new Department();
            dept = !roomListForm.getDeptCodeX().equalsIgnoreCase("All") ? Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId) : null;
            for (Location location : rooms) {
                boolean editable = this.sessionContext.hasPermission(location, Right.RoomDetail);
                Room room = location instanceof Room ? (Room)location : null;
                Building bldg = room == null ? null : room.getBuilding();
                DecimalFormat df5 = new DecimalFormat("####0");
                String[] text = new String[Math.max(heading1.length, heading2.length)];
                Comparable[] comp = new Comparable[text.length];
                int idx = 0;
                if (bldg != null) {
                    text[idx] = (editable ? "" : "<font color='gray'>") + (location.isIgnoreRoomCheck() != false ? "<i>" : "") + "<span onmouseover=\"showGwtRoomHint(this, '-" + bldg.getUniqueId() + "');\" onmouseout=\"hideGwtRoomHint();\">" + bldg.getAbbreviation() + "</span>" + (location.isIgnoreRoomCheck() != false ? "</i>" : "") + (editable ? "" : "</font>");
                    comp[0] = location.getLabel();
                    ++idx;
                }
                text[idx] = (editable ? "" : "<font color='gray'>") + (location.isIgnoreRoomCheck() != false ? "<i>" : "") + (room == null ? location.getLabelWithHint() : "<span onmouseover=\"showGwtRoomHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomHint();\">" + room.getRoomNumber() + "</span>") + (location.isIgnoreRoomCheck() != false ? "</i>" : "") + (editable ? "" : "</font>");
                comp[idx] = location.getLabel();
                text[++idx] = (editable ? "" : "<font color='gray'>") + df5.format(location.getCapacity()) + (editable ? "" : "</font>");
                comp[idx] = new Long(location.getCapacity().intValue());
                ++idx;
                if (examType != null) {
                    if (location.isExamEnabled(examType)) {
                        text[idx] = (editable ? "" : "<font color='gray'>") + df5.format(location.getExamCapacity()) + (editable ? "" : "</font>");
                        comp[idx] = location.getExamCapacity();
                    } else {
                        text[idx] = "&nbsp;";
                        comp[idx] = new Integer(0);
                    }
                    ++idx;
                    if (location.getArea() == null) {
                        text[idx] = "&nbsp;";
                        comp[idx] = new Double(0.0);
                    } else {
                        text[idx] = dfa.format(location.getArea());
                        comp[idx] = location.getArea();
                    }
                    ++idx;
                    if (location.isExamEnabled(examType)) {
                        if (gridAsText) {
                            text[idx] = location.getExamPreferencesAbbreviationHtml(examType);
                        } else if (examType.getType() == 1) {
                            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(location.getSession(), examType);
                            epx.load(location);
                            text[idx] = epx.toString(true).replaceAll(", ", "<br>");
                        } else {
                            PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), examType.getUniqueId());
                            px.load(location);
                            RequiredTimeTable rtt = new RequiredTimeTable(px);
                            String hint = rtt.print(false, timeVertical).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
                            text[idx] = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&loc=" + location.getUniqueId() + "&xt=" + examType.getUniqueId() + "' onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\">";
                        }
                        comp[idx] = null;
                    } else {
                        text[idx] = "";
                        comp[idx] = null;
                    }
                    ++idx;
                } else {
                    if (location.getArea() == null) {
                        text[idx] = "&nbsp;";
                        comp[idx] = new Double(0.0);
                    } else {
                        text[idx] = dfa.format(location.getArea());
                        comp[idx] = location.getArea();
                    }
                    ++idx;
                    PreferenceLevel roomPref = location.getRoomPreferenceLevel(dept);
                    if (editable && roomPref != null && !PreferenceLevel.sNeutral.equals(roomPref.getPrefProlog())) {
                        if (room == null) {
                            text[0] = (location.isIgnoreRoomCheck() != false ? "<i>" : "") + "<span style='color:" + roomPref.prefcolor() + ";font-weight:bold;' onmouseover=\"showGwtRoomHint(this, '" + location.getUniqueId() + "', '" + roomPref.getPrefName() + "');\" onmouseout=\"hideGwtRoomHint();\">" + location.getLabel() + "</span>" + (location.isIgnoreRoomCheck() != false ? "</i>" : "");
                        } else {
                            text[0] = (location.isIgnoreRoomCheck() != false ? "<i>" : "") + "<span style='color:" + roomPref.prefcolor() + ";font-weight:bold;' onmouseover=\"showGwtRoomHint(this, '-" + bldg.getUniqueId() + "', '" + (bldg == null ? roomPref.getPrefName() : "") + "');\" onmouseout=\"hideGwtRoomHint();\">" + (bldg == null ? "" : bldg.getAbbreviation()) + "</span>" + (location.isIgnoreRoomCheck() != false ? "</i>" : "");
                            text[1] = (location.isIgnoreRoomCheck() != false ? "<i>" : "") + "<span style='color:" + roomPref.prefcolor() + ";font-weight:bold;' onmouseover=\"showGwtRoomHint(this, '" + location.getUniqueId() + "', '" + roomPref.getPrefName() + "');\" onmouseout=\"hideGwtRoomHint();\">" + room.getRoomNumber() + "</span>" + (location.isIgnoreRoomCheck() != false ? "</i>" : "");
                        }
                    }
                    if (location instanceof NonUniversityLocation) {
                        boolean itf = location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar();
                        text[idx] = itf ? "<IMG border='0' title='Ignore too far distances' alt='true' align='absmiddle' src='images/accept.png'>" : "&nbsp;";
                        comp[idx] = new Integer(itf ? 1 : 0);
                        boolean con = location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck();
                        text[++idx] = con ? "<IMG border='0' title='Create Constraint' alt='true' align='absmiddle' src='images/accept.png'>" : "&nbsp;";
                        comp[idx] = new Integer(con ? 1 : 0);
                        ++idx;
                    }
                    if (this.sessionContext.hasPermission(location, Right.RoomDetailAvailability)) {
                        RequiredTimeTable rtt = location.getRoomSharingTable();
                        rtt.getModel().setDefaultSelection(timeGridSize);
                        text[idx] = gridAsText ? "<span onmouseover=\"showGwtRoomAvailabilityHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomAvailabilityHint();\">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>" : "<img border='0' onmouseover=\"showGwtRoomAvailabilityHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomAvailabilityHint();\" src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&loc=" + location.getUniqueId() + "'>&nbsp;";
                    } else if (this.sessionContext.hasPermission(location, Right.RoomDetailEventAvailability)) {
                        RequiredTimeTable rtt = location.getEventAvailabilityTable();
                        rtt.getModel().setDefaultSelection(timeGridSize);
                        text[idx] = gridAsText ? "<span onmouseover=\"showGwtRoomEventAvailabilityHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomEventAvailabilityHint();\">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>" : "<img border='0' onmouseover=\"showGwtRoomEventAvailabilityHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomEventAvailabilityHint();\" src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&loc=" + location.getUniqueId() + "&e=1'>&nbsp;";
                    }
                    comp[idx] = null;
                    Department controlDept = null;
                    text[++idx] = "";
                    Set<RoomDept> rds = location.getRoomDepts();
                    HashSet<Department> departments = new HashSet<Department>();
                    for (RoomDept rd : rds) {
                        Department d = rd.getDepartment();
                        if (rd.isControl().booleanValue()) {
                            controlDept = d;
                        }
                        departments.add(d);
                    }
                    TreeSet<Department> ts = new TreeSet<Department>(new DepartmentNameComparator());
                    ts.addAll(departments);
                    if (ts.size() == session.getDepartments().size()) {
                        text[idx] = "<b>All</b>";
                        comp[idx] = "";
                    } else {
                        int cnt = 0;
                        for (Department d : ts) {
                            if (text[idx].length() > 0) {
                                text[idx] = text[idx] + (ts.size() <= 5 || cnt % 5 == 0 ? "<br>" : ", ");
                            } else {
                                comp[idx] = d.getDeptCode();
                            }
                            text[idx] = text[idx] + d.htmlShortLabel();
                            ++cnt;
                        }
                    }
                    ++idx;
                    if (!roomListForm.getDeptCodeX().equalsIgnoreCase("All") && !roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                        if (controlDept != null && controlDept.getDeptCode().equals(roomListForm.getDeptCodeX())) {
                            text[idx] = "<IMG border='0' title='Selected department is controlling this room.' alt='true' align='absmiddle' src='images/accept.png'>";
                            comp[idx] = new Integer(1);
                        } else {
                            text[idx] = "";
                            comp[idx] = new Integer(0);
                        }
                    } else if (controlDept != null) {
                        text[idx] = controlDept.htmlShortLabel();
                        comp[idx] = controlDept.getDeptCode();
                    } else {
                        text[idx] = "";
                        comp[idx] = "";
                    }
                    ++idx;
                    if (location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue()) {
                        text[idx] = this.sessionContext.hasPermission(location, Right.RoomDetailEventAvailability) ? "<span onmouseover=\"showGwtRoomEventAvailabilityHint(this, '" + location.getUniqueId() + "');\" onmouseout=\"hideGwtRoomEventAvailabilityHint();\">" + location.getEventDepartment().htmlShortLabel() + "</span>" : location.getEventDepartment().htmlShortLabel();
                        comp[idx] = location.getEventDepartment().getDeptCode();
                    } else {
                        text[idx] = "";
                        comp[idx] = "";
                    }
                    ++idx;
                }
                text[0] = text[0] + "<A name=\"A" + location.getUniqueId() + "\"></A>";
                text[idx] = "";
                comp[idx] = "";
                for (RoomGroup rg : new TreeSet<RoomGroup>(location.getRoomGroups())) {
                    if (!rg.isGlobal().booleanValue() && (examType != null || !depts.contains(rg.getDepartment()))) continue;
                    if (!rg.isGlobal().booleanValue()) {
                        boolean skip = true;
                        for (RoomDept rd : location.getRoomDepts()) {
                            if (!rg.getDepartment().equals(rd.getDepartment())) continue;
                            skip = false;
                            break;
                        }
                        if (skip) continue;
                    }
                    if (text[idx].length() > 0) {
                        int n = idx;
                        text[n] = text[n] + "<br>";
                    }
                    comp[idx] = comp[idx] + rg.getName().trim();
                    int n = idx;
                    text[n] = text[n] + rg.htmlLabel();
                }
                ++idx;
                if (featuresOneColumn) {
                    text[idx] = "";
                    comp[idx] = "";
                    for (GlobalRoomFeature rf : new TreeSet<GlobalRoomFeature>((SortedSet<GlobalRoomFeature>)location.getGlobalRoomFeatures())) {
                        if (text[idx].length() > 0) {
                            int n = idx;
                            text[n] = text[n] + "<br>";
                        }
                        comp[idx] = comp[idx] + rf.getLabel().trim();
                        int n = idx;
                        text[n] = text[n] + rf.htmlLabel();
                    }
                    if (examType == null) {
                        for (DepartmentRoomFeature drf : new TreeSet<DepartmentRoomFeature>((SortedSet<DepartmentRoomFeature>)location.getDepartmentRoomFeatures())) {
                            if (!depts.contains(drf.getDepartment())) continue;
                            boolean skip = true;
                            for (RoomDept rd : location.getRoomDepts()) {
                                if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                                skip = false;
                                break;
                            }
                            if (skip) continue;
                            if (text[idx].length() > 0) {
                                int n = idx;
                                text[n] = text[n] + "<br>";
                            }
                            comp[idx] = comp[idx] + drf.getLabel().trim();
                            int n = idx;
                            text[n] = text[n] + drf.htmlLabel();
                        }
                    }
                    ++idx;
                } else {
                    for (GlobalRoomFeature grf : globalRoomFeatures) {
                        boolean b = location.hasFeature(grf);
                        text[idx] = b ? "<IMG border='0' title='" + grf.getLabel() + "' alt='" + grf.getLabel() + "' align='absmiddle' src='images/accept.png'>" : "&nbsp;";
                        comp[idx] = "" + b;
                        ++idx;
                    }
                    for (DepartmentRoomFeature drf : deptRoomFeatures) {
                        boolean b = location.hasFeature(drf);
                        for (RoomDept rd : location.getRoomDepts()) {
                            if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                            b = false;
                            break;
                        }
                        text[idx] = b ? "<IMG border='0' title='" + drf.getLabel() + "' alt='" + drf.getLabel() + "' align='absmiddle' src='images/accept.png'>" : "&nbsp;";
                        comp[idx] = "" + b;
                        ++idx;
                    }
                }
                if (location instanceof NonUniversityLocation) {
                    ((WebTable)tables.get(location.getRoomType())).addLine(editable ? "onClick=\"document.location='roomDetail.do?id=" + location.getUniqueId() + "';\"" : null, text, comp, location.getUniqueId().toString());
                    continue;
                }
                ((WebTable)tables.get(room.getRoomType())).addLine(editable ? "onClick=\"document.location='roomDetail.do?id=" + room.getUniqueId() + "';\"" : null, text, comp, room.getUniqueId().toString());
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Map.Entry entry : tables.entrySet()) {
                int ord = WebTable.getOrder(this.sessionContext, ((RoomType)entry.getKey()).getReference() + ".ord");
                if (ord > heading1.length) {
                    ord = 0;
                }
                if (!((WebTable)entry.getValue()).getLines().isEmpty()) {
                    request.setAttribute(((RoomType)entry.getKey()).getReference(), (Object)((WebTable)entry.getValue()).printTable(ord));
                }
                if (!ids.isEmpty()) {
                    ids.add(-1L);
                }
                Enumeration e = ((WebTable)entry.getValue()).getLines().elements();
                while (e.hasMoreElements()) {
                    ids.add(Long.parseLong(((WebTable.WebTableLine)e.nextElement()).getUniqueId()));
                }
            }
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
            if (request.getParameter("backId") != null) {
                request.setAttribute("hash", (Object)("A" + request.getParameter("backId")));
            }
            BackTracker.markForBack(request, "roomSearch.do", "Rooms", true, true);
            request.setAttribute("colspan", (Object)String.valueOf(Math.max(heading1.length, heading2.length)));
        }
    }

    public void buildPdfWebTable(OutputStream out, RoomListForm roomListForm, boolean featuresOneColumn, ExamType examType) throws Exception {
        int i;
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        String colArea;
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        DecimalFormat dfa = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value());
        Collection rooms = roomListForm.getRooms();
        ArrayList<GlobalRoomFeature> globalRoomFeatures = new ArrayList<GlobalRoomFeature>();
        TreeSet deptRoomFeatures = new TreeSet();
        AbstractSet depts = null;
        if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
            depts = Department.getUserDepartments(this.sessionContext.getUser());
        } else if (roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            depts = new HashSet(0);
        } else {
            depts = new HashSet(1);
            depts.add((Department)Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId));
        }
        org.hibernate.Session hibSession = null;
        try {
            RoomFeatureDAO d = new RoomFeatureDAO();
            hibSession = d.getSession();
            List list = hibSession.createCriteria(GlobalRoomFeature.class).addOrder(Order.asc((String)"label")).list();
            for (Object rf : list) {
                globalRoomFeatures.add((GlobalRoomFeature)rf);
            }
            if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                } else {
                    String deptIds = "";
                    for (Qualifiable qualifiable : this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")) {
                        if (!deptIds.isEmpty()) {
                            deptIds = deptIds + ",";
                        }
                        deptIds = deptIds + qualifiable.getQualifierId();
                    }
                    if (!deptIds.isEmpty()) {
                        deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.uniqueId in (" + deptIds + ") order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                    }
                }
            } else if (!roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.deptCode = :deptCode order by f.label").setLong("sessionId", sessionId.longValue()).setString("deptCode", roomListForm.getDeptCodeX()).setCacheable(true).list());
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        String string = colArea = ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.columnAreaMetricPDF() : MSG.columnAreaPDF();
        if (examType != null) {
            if (featuresOneColumn) {
                String[][] stringArrayArray3 = new String[8][];
                stringArrayArray3[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray3[1] = new String[]{"Room", "left", "true"};
                stringArrayArray3[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray3[3] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray3[4] = new String[]{colArea, "right", "false"};
                stringArrayArray3[5] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray3[6] = new String[]{"Groups", "left", "true"};
                stringArrayArray2 = stringArrayArray3;
                stringArrayArray3[7] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray4 = new String[7][];
                stringArrayArray4[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray4[1] = new String[]{"Room", "left", "true"};
                stringArrayArray4[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray4[3] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray4[4] = new String[]{colArea, "right", "false"};
                stringArrayArray4[5] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray2 = stringArrayArray4;
                stringArrayArray4[6] = new String[]{"Groups", "left", "true"};
            }
        } else if (featuresOneColumn) {
            String[][] stringArrayArray5 = new String[10][];
            stringArrayArray5[0] = new String[]{"Bldg", "left", "true"};
            stringArrayArray5[1] = new String[]{"Room", "left", "true"};
            stringArrayArray5[2] = new String[]{"Capacity", "right", "false"};
            stringArrayArray5[3] = new String[]{colArea, "right", "false"};
            stringArrayArray5[4] = new String[]{"Availability", "left", "true"};
            stringArrayArray5[5] = new String[]{"Departments", "left", "true"};
            stringArrayArray5[6] = new String[]{"Control", "left", "true"};
            stringArrayArray5[7] = new String[]{"Events", "left", "true"};
            stringArrayArray5[8] = new String[]{"Groups", "left", "true"};
            stringArrayArray2 = stringArrayArray5;
            stringArrayArray5[9] = new String[]{"Features", "left", "true"};
        } else {
            String[][] stringArrayArray6 = new String[9][];
            stringArrayArray6[0] = new String[]{"Bldg", "left", "true"};
            stringArrayArray6[1] = new String[]{"Room", "left", "true"};
            stringArrayArray6[2] = new String[]{"Capacity", "right", "false"};
            stringArrayArray6[3] = new String[]{colArea, "right", "false"};
            stringArrayArray6[4] = new String[]{"Availability", "left", "true"};
            stringArrayArray6[5] = new String[]{"Departments", "left", "true"};
            stringArrayArray6[6] = new String[]{"Control", "left", "true"};
            stringArrayArray6[7] = new String[]{"Events", "left", "true"};
            stringArrayArray2 = stringArrayArray6;
            stringArrayArray6[8] = new String[]{"Groups", "left", "true"};
        }
        String[][] fixedHeading1 = stringArrayArray2;
        String[] heading1 = new String[fixedHeading1.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
        String[] alignment1 = new String[heading1.length];
        boolean[] blArray = new boolean[heading1.length];
        for (int i2 = 0; i2 < fixedHeading1.length; ++i2) {
            heading1[i2] = fixedHeading1[i2][0];
            alignment1[i2] = fixedHeading1[i2][1];
            blArray[i2] = Boolean.valueOf(fixedHeading1[i2][2]);
        }
        if (!featuresOneColumn) {
            int i2 = fixedHeading1.length;
            Iterator it = globalRoomFeatures.iterator();
            while (it.hasNext()) {
                heading1[i2] = ((GlobalRoomFeature)it.next()).getLabel();
                heading1[i2] = heading1[i2].replaceFirst(" ", "\n");
                alignment1[i2] = "center";
                blArray[i2] = true;
                ++i2;
            }
            for (DepartmentRoomFeature drf : deptRoomFeatures) {
                heading1[i2] = drf.getLabel();
                heading1[i2] = heading1[i2].replaceFirst(" ", "\n");
                if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                    Department dept = drf.getDepartment();
                    int n = i2;
                    heading1[n] = heading1[n] + " (" + dept.getShortLabel() + ")";
                }
                alignment1[i2] = "center";
                blArray[i2] = true;
                ++i2;
            }
        }
        if (examType != null) {
            if (featuresOneColumn) {
                String[][] stringArrayArray7 = new String[7][];
                stringArrayArray7[0] = new String[]{"Location", "left", "true"};
                stringArrayArray7[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray7[2] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray7[3] = new String[]{colArea, "right", "false"};
                stringArrayArray7[4] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray7[5] = new String[]{"Groups", "left", "true"};
                stringArrayArray = stringArrayArray7;
                stringArrayArray7[6] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray8 = new String[5][];
                stringArrayArray8[0] = new String[]{"Location", "left", "true"};
                stringArrayArray8[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray8[2] = new String[]{colArea, "right", "false"};
                stringArrayArray8[3] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray = stringArrayArray8;
                stringArrayArray8[4] = new String[]{"Groups", "left", "true"};
            }
        } else if (featuresOneColumn) {
            String[][] stringArrayArray9 = new String[11][];
            stringArrayArray9[0] = new String[]{"Location", "left", "true"};
            stringArrayArray9[1] = new String[]{"Capacity", "right", "false"};
            stringArrayArray9[2] = new String[]{colArea, "right", "false"};
            stringArrayArray9[3] = new String[]{"IgnTooFar", "center", "true"};
            stringArrayArray9[4] = new String[]{"IgnChecks", "center", "true"};
            stringArrayArray9[5] = new String[]{"Availability", "left", "true"};
            stringArrayArray9[6] = new String[]{"Departments", "left", "true"};
            stringArrayArray9[7] = new String[]{"Control", "left", "true"};
            stringArrayArray9[8] = new String[]{"Events", "left", "true"};
            stringArrayArray9[9] = new String[]{"Groups", "left", "true"};
            stringArrayArray = stringArrayArray9;
            stringArrayArray9[10] = new String[]{"Features", "left", "true"};
        } else {
            String[][] stringArrayArray10 = new String[11][];
            stringArrayArray10[0] = new String[]{"Location", "left", "true"};
            stringArrayArray10[1] = new String[]{"Capacity", "right", "false"};
            stringArrayArray10[2] = new String[]{"Exam Capacity", "right", "false"};
            stringArrayArray10[3] = new String[]{colArea, "right", "false"};
            stringArrayArray10[4] = new String[]{"IgnTooFar", "center", "true"};
            stringArrayArray10[5] = new String[]{"IgnChecks", "center", "true"};
            stringArrayArray10[6] = new String[]{"Availability", "left", "true"};
            stringArrayArray10[7] = new String[]{"Departments", "left", "true"};
            stringArrayArray10[8] = new String[]{"Control", "left", "true"};
            stringArrayArray10[9] = new String[]{"Events", "left", "true"};
            stringArrayArray = stringArrayArray10;
            stringArrayArray10[10] = new String[]{"Groups", "left", "true"};
        }
        String[][] fixedHeading2 = stringArrayArray;
        String[] heading2 = new String[fixedHeading2.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
        String[] alignment2 = new String[heading2.length];
        boolean[] sorted2 = new boolean[heading2.length];
        for (i = 0; i < fixedHeading2.length; ++i) {
            heading2[i] = fixedHeading2[i][0];
            alignment2[i] = fixedHeading2[i][1];
            sorted2[i] = Boolean.valueOf(fixedHeading2[i][2]);
        }
        if (!featuresOneColumn) {
            i = fixedHeading2.length;
            Iterator it = globalRoomFeatures.iterator();
            while (it.hasNext()) {
                heading2[i] = ((GlobalRoomFeature)it.next()).getLabel();
                heading2[i] = heading2[i].replaceFirst(" ", "\n");
                alignment2[i] = "center";
                sorted2[i] = true;
                ++i;
            }
            for (Object drf : deptRoomFeatures) {
                heading2[i] = ((BaseRoomFeature)drf).getLabel();
                heading2[i] = heading2[i].replaceFirst(" ", "\n");
                if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                    Department dept = Department.findByDeptCode(((DepartmentRoomFeature)drf).getDeptCode(), sessionId);
                    int n = i;
                    heading2[n] = heading2[n] + " (" + dept.getShortLabel() + ")";
                }
                alignment2[i] = "center";
                sorted2[i] = true;
                ++i;
            }
        }
        TreeSet roomTypes = new TreeSet(RoomTypeDAO.getInstance().findAll());
        Hashtable<RoomType, PdfWebTable> tables = new Hashtable<RoomType, PdfWebTable>();
        for (RoomType t : roomTypes) {
            PdfWebTable table = t.isRoom() != false ? new PdfWebTable(heading1.length, t.getLabel(), null, heading1, alignment1, blArray) : new PdfWebTable(heading2.length, t.getLabel(), null, heading2, alignment2, sorted2);
            tables.put(t, table);
        }
        boolean timeVertical = CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
        boolean gridAsText = CommonValues.TextGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
        String timeGridSize = UserProperty.GridSize.get(this.sessionContext.getUser());
        Department dept = new Department();
        dept = !roomListForm.getDeptCodeX().equalsIgnoreCase("All") ? Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId) : null;
        for (Location location : rooms) {
            boolean editable = this.sessionContext.hasPermission(location, Right.RoomDetail);
            Room room = location instanceof Room ? (Room)location : null;
            Building bldg = room == null ? null : room.getBuilding();
            PdfWebTable table = (PdfWebTable)tables.get(location.getRoomType());
            DecimalFormat df5 = new DecimalFormat("####0");
            String[] text = new String[Math.max(heading1.length, heading2.length)];
            Comparable[] comp = new Comparable[text.length];
            int idx = 0;
            if (bldg != null) {
                text[idx] = (location.isIgnoreRoomCheck() != false ? "@@ITALIC " : "") + bldg.getAbbreviation() + (location.isIgnoreRoomCheck() != false ? "@@END_ITALIC " : "");
                comp[0] = location.getLabel();
                ++idx;
            }
            text[idx] = (location.isIgnoreRoomCheck() != false ? "@@ITALIC " : "") + (room == null ? location.getLabel() : room.getRoomNumber()) + (location.isIgnoreRoomCheck() != false ? "@@END_ITALIC " : "");
            comp[idx] = location.getLabel();
            text[++idx] = df5.format(location.getCapacity());
            comp[idx] = new Long(location.getCapacity().intValue());
            ++idx;
            if (examType != null) {
                if (location.isExamEnabled(examType)) {
                    text[idx] = df5.format(location.getExamCapacity());
                    comp[idx] = location.getExamCapacity();
                } else {
                    text[idx] = "";
                    comp[idx] = new Integer(0);
                }
                ++idx;
                if (location.getArea() == null) {
                    text[idx] = "";
                    comp[idx] = new Double(0.0);
                } else {
                    text[idx] = dfa.format(location.getArea());
                    comp[idx] = location.getArea();
                }
                ++idx;
                if (location.isExamEnabled(examType)) {
                    text[idx] = location.getExamPreferencesAbbreviation(examType);
                    comp[idx] = null;
                } else {
                    text[idx] = "";
                    comp[idx] = null;
                }
                ++idx;
            } else {
                if (location.getArea() == null) {
                    text[idx] = "";
                    comp[idx] = new Double(0.0);
                } else {
                    text[idx] = dfa.format(location.getArea());
                    comp[idx] = location.getArea();
                }
                ++idx;
                PreferenceLevel roomPref = location.getRoomPreferenceLevel(dept);
                if (editable && roomPref != null && !PreferenceLevel.sNeutral.equals(roomPref.getPrefProlog())) {
                    if (room == null) {
                        text[0] = (location.isIgnoreRoomCheck() != false ? "@@ITALIC " : "") + location.getLabel() + " (" + roomPref.getAbbreviation() + ")" + (location.isIgnoreRoomCheck() != false ? "@@END_ITALIC " : "");
                    } else {
                        text[0] = (location.isIgnoreRoomCheck() != false ? "@@ITALIC " : "") + (bldg == null ? "" : bldg.getAbbreviation()) + (location.isIgnoreRoomCheck() != false ? "@@END_ITALIC " : "");
                        text[1] = (location.isIgnoreRoomCheck() != false ? "@@ITALIC " : "") + room.getRoomNumber() + " (" + roomPref.getAbbreviation() + ")" + (location.isIgnoreRoomCheck() != false ? "@@END_ITALIC " : "");
                    }
                }
                if (location instanceof NonUniversityLocation) {
                    boolean itf = location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar();
                    text[idx] = itf ? "Yes" : "No";
                    comp[idx] = new Integer(itf ? 1 : 0);
                    boolean con = location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck();
                    text[++idx] = con ? "YES" : "No";
                    comp[idx] = new Integer(con ? 1 : 0);
                    ++idx;
                }
                RequiredTimeTable rtt = location.getRoomSharingTable();
                if (gridAsText) {
                    text[idx] = rtt.getModel().toString().replaceAll(", ", "\n");
                } else {
                    rtt.getModel().setDefaultSelection(timeGridSize);
                    BufferedImage image = rtt.createBufferedImage(timeVertical);
                    if (image != null) {
                        table.addImage(location.getUniqueId().toString(), image);
                        text[idx] = "@@IMAGE " + location.getUniqueId().toString() + " ";
                    } else {
                        text[idx] = rtt.getModel().toString().replaceAll(", ", "\n");
                    }
                }
                comp[idx] = null;
                Department controlDept = null;
                text[++idx] = "";
                Set<RoomDept> rds = location.getRoomDepts();
                HashSet<Department> departments = new HashSet<Department>();
                for (RoomDept rd : rds) {
                    Department d = rd.getDepartment();
                    if (rd.isControl().booleanValue()) {
                        controlDept = d;
                    }
                    departments.add(d);
                }
                TreeSet<Department> ts = new TreeSet<Department>(new DepartmentNameComparator());
                ts.addAll(departments);
                if (ts.size() == session.getDepartments().size()) {
                    text[idx] = "@@BOLD All";
                    comp[idx] = "";
                } else {
                    int cnt = 0;
                    for (Department d : ts) {
                        if (text[idx].length() > 0) {
                            text[idx] = text[idx] + (ts.size() <= 5 || cnt % 5 == 0 ? "\n" : ", ");
                        } else {
                            comp[idx] = d.getDeptCode();
                        }
                        text[idx] = text[idx] + "@@COLOR " + d.getRoomSharingColor(null) + " " + d.getShortLabel();
                        ++cnt;
                    }
                }
                ++idx;
                if (!roomListForm.getDeptCodeX().equalsIgnoreCase("All") && !roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                    if (controlDept != null && controlDept.getDeptCode().equals(roomListForm.getDeptCodeX())) {
                        text[idx] = "Yes";
                        comp[idx] = new Integer(1);
                    } else {
                        text[idx] = "No";
                        comp[idx] = new Integer(0);
                    }
                } else if (controlDept != null) {
                    text[idx] = "@@COLOR " + controlDept.getRoomSharingColor(null) + " " + controlDept.getShortLabel();
                    comp[idx] = controlDept.getDeptCode();
                } else {
                    text[idx] = "";
                    comp[idx] = "";
                }
                ++idx;
                if (location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue()) {
                    text[idx] = "@@COLOR " + location.getEventDepartment().getRoomSharingColor(null) + " " + location.getEventDepartment().getShortLabel();
                    comp[idx] = location.getEventDepartment().getDeptCode();
                } else {
                    text[idx] = "";
                    comp[idx] = "";
                }
                ++idx;
            }
            text[idx] = "";
            for (RoomGroup rg : new TreeSet<RoomGroup>(location.getRoomGroups())) {
                if (!rg.isGlobal().booleanValue() && (examType != null || !depts.contains(rg.getDepartment()))) continue;
                if (!rg.isGlobal().booleanValue()) {
                    boolean skip = true;
                    for (RoomDept rd : location.getRoomDepts()) {
                        if (!rg.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (text[idx].length() > 0) {
                    int n = idx;
                    text[n] = text[n] + "\n";
                }
                comp[idx] = comp[idx] + rg.getName().trim();
                int n = idx;
                text[n] = text[n] + (rg.isGlobal() != false ? "" : "@@COLOR " + rg.getDepartment().getRoomSharingColor(null) + " ") + rg.getName();
            }
            ++idx;
            if (featuresOneColumn) {
                text[idx] = "";
                for (GlobalRoomFeature rf : new TreeSet<GlobalRoomFeature>((SortedSet<GlobalRoomFeature>)location.getGlobalRoomFeatures())) {
                    if (text[idx].length() > 0) {
                        int n = idx;
                        text[n] = text[n] + "\n";
                    }
                    comp[idx] = comp[idx] + rf.getLabel().trim();
                    int n = idx;
                    text[n] = text[n] + rf.getLabelWithType();
                }
                if (examType == null) {
                    for (DepartmentRoomFeature drf : new TreeSet<DepartmentRoomFeature>((SortedSet<DepartmentRoomFeature>)location.getDepartmentRoomFeatures())) {
                        if (!depts.contains(drf.getDepartment())) continue;
                        boolean skip = true;
                        for (RoomDept rd : location.getRoomDepts()) {
                            if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                            skip = false;
                            break;
                        }
                        if (skip) continue;
                        if (text[idx].length() > 0) {
                            int n = idx;
                            text[n] = text[n] + "\n";
                        }
                        comp[idx] = comp[idx] + drf.getLabel().trim();
                        int n = idx;
                        text[n] = text[n] + "@@COLOR " + drf.getDepartment().getRoomSharingColor(null) + " " + drf.getLabelWithType();
                    }
                }
                ++idx;
            } else {
                for (GlobalRoomFeature grf : globalRoomFeatures) {
                    boolean b = location.hasFeature(grf);
                    text[idx] = b ? "Yes" : "No";
                    comp[idx] = "" + b;
                    ++idx;
                }
                for (DepartmentRoomFeature drf : deptRoomFeatures) {
                    boolean b = location.hasFeature(drf);
                    for (RoomDept rd : location.getRoomDepts()) {
                        if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                        b = false;
                        break;
                    }
                    text[idx] = b ? "Yes" : "No";
                    comp[idx] = "" + b;
                    ++idx;
                }
            }
            table.addLine(editable ? "onClick=\"document.location='roomDetail.do?id=" + location.getUniqueId() + "';\"" : null, text, comp);
        }
        Document doc = null;
        for (RoomType t : roomTypes) {
            PdfWebTable table = (PdfWebTable)tables.get(t);
            if (table.getLines().isEmpty()) continue;
            int ord = WebTable.getOrder(this.sessionContext, t.getReference() + ".ord");
            if (ord > heading1.length) {
                ord = 0;
            }
            PdfPTable pdfTable = table.printPdfTable(ord);
            if (doc == null) {
                doc = new Document(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()), 30.0f, 30.0f, 30.0f, 30.0f);
                PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
                iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
                doc.open();
            } else {
                doc.setPageSize(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()));
                doc.newPage();
            }
            doc.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
            doc.add((Element)pdfTable);
        }
        if (doc == null) {
            return;
        }
        doc.close();
    }

    public void buildCsvWebTable(PrintWriter out, RoomListForm roomListForm, boolean featuresOneColumn, ExamType examType) throws Exception {
        int i;
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        String colArea;
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        DecimalFormat dfa = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value());
        Collection rooms = roomListForm.getRooms();
        ArrayList<GlobalRoomFeature> globalRoomFeatures = new ArrayList<GlobalRoomFeature>();
        TreeSet deptRoomFeatures = new TreeSet();
        AbstractSet depts = null;
        if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
            depts = Department.getUserDepartments(this.sessionContext.getUser());
        } else if (roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            depts = new HashSet(0);
        } else {
            depts = new HashSet(1);
            depts.add((Department)Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId));
        }
        org.hibernate.Session hibSession = null;
        try {
            RoomFeatureDAO d = new RoomFeatureDAO();
            hibSession = d.getSession();
            List list = hibSession.createCriteria(GlobalRoomFeature.class).addOrder(Order.asc((String)"label")).list();
            for (Object rf : list) {
                globalRoomFeatures.add((GlobalRoomFeature)rf);
            }
            if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                } else {
                    String deptIds = "";
                    for (Qualifiable qualifiable : this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")) {
                        if (!deptIds.isEmpty()) {
                            deptIds = deptIds + ",";
                        }
                        deptIds = deptIds + qualifiable.getQualifierId();
                    }
                    if (!deptIds.isEmpty()) {
                        deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.uniqueId in (" + deptIds + ") order by f.label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
                    }
                }
            } else if (!roomListForm.getDeptCodeX().matches("Exam[0-9]*")) {
                deptRoomFeatures.addAll(hibSession.createQuery("select distinct f from DepartmentRoomFeature f inner join f.department d where d.session.uniqueId=:sessionId and d.deptCode = :deptCode order by f.label").setLong("sessionId", sessionId.longValue()).setString("deptCode", roomListForm.getDeptCodeX()).setCacheable(true).list());
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        String string = colArea = ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.columnAreaMetricPDF() : MSG.columnAreaPDF();
        if (examType != null) {
            if (featuresOneColumn) {
                String[][] stringArrayArray3 = new String[8][];
                stringArrayArray3[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray3[1] = new String[]{"Room", "left", "true"};
                stringArrayArray3[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray3[3] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray3[4] = new String[]{colArea, "right", "false"};
                stringArrayArray3[5] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray3[6] = new String[]{"Groups", "left", "true"};
                stringArrayArray2 = stringArrayArray3;
                stringArrayArray3[7] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray4 = new String[6][];
                stringArrayArray4[0] = new String[]{"Bldg", "left", "true"};
                stringArrayArray4[1] = new String[]{"Room", "left", "true"};
                stringArrayArray4[2] = new String[]{"Capacity", "right", "false"};
                stringArrayArray4[3] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray4[4] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray2 = stringArrayArray4;
                stringArrayArray4[5] = new String[]{"Groups", "left", "true"};
            }
        } else if (featuresOneColumn) {
            String[][] stringArrayArray5 = new String[10][];
            stringArrayArray5[0] = new String[]{"Bldg", "left", "true"};
            stringArrayArray5[1] = new String[]{"Room", "left", "true"};
            stringArrayArray5[2] = new String[]{"Capacity", "right", "false"};
            stringArrayArray5[3] = new String[]{colArea, "right", "false"};
            stringArrayArray5[4] = new String[]{"Availability", "left", "true"};
            stringArrayArray5[5] = new String[]{"Departments", "left", "true"};
            stringArrayArray5[6] = new String[]{"Control", "left", "true"};
            stringArrayArray5[7] = new String[]{"Events", "left", "true"};
            stringArrayArray5[8] = new String[]{"Groups", "left", "true"};
            stringArrayArray2 = stringArrayArray5;
            stringArrayArray5[9] = new String[]{"Features", "left", "true"};
        } else {
            String[][] stringArrayArray6 = new String[9][];
            stringArrayArray6[0] = new String[]{"Bldg", "left", "true"};
            stringArrayArray6[1] = new String[]{"Room", "left", "true"};
            stringArrayArray6[2] = new String[]{"Capacity", "right", "false"};
            stringArrayArray6[3] = new String[]{colArea, "right", "false"};
            stringArrayArray6[4] = new String[]{"Availability", "left", "true"};
            stringArrayArray6[5] = new String[]{"Departments", "left", "true"};
            stringArrayArray6[6] = new String[]{"Control", "left", "true"};
            stringArrayArray6[7] = new String[]{"Events", "left", "true"};
            stringArrayArray2 = stringArrayArray6;
            stringArrayArray6[8] = new String[]{"Groups", "left", "true"};
        }
        String[][] fixedHeading1 = stringArrayArray2;
        String[] heading1 = new String[fixedHeading1.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
        for (int i2 = 0; i2 < fixedHeading1.length; ++i2) {
            heading1[i2] = fixedHeading1[i2][0];
        }
        if (!featuresOneColumn) {
            int i2 = fixedHeading1.length;
            Iterator iterator = globalRoomFeatures.iterator();
            while (iterator.hasNext()) {
                heading1[i2] = ((GlobalRoomFeature)iterator.next()).getLabel();
                heading1[i2] = heading1[i2].replaceFirst(" ", "\n");
                ++i2;
            }
            for (DepartmentRoomFeature drf : deptRoomFeatures) {
                heading1[i2] = drf.getLabel();
                heading1[i2] = heading1[i2].replaceFirst(" ", "\n");
                if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                    Department dept = drf.getDepartment();
                    int n = i2;
                    heading1[n] = heading1[n] + " (" + dept.getShortLabel() + ")";
                }
                ++i2;
            }
        }
        if (examType != null) {
            if (featuresOneColumn) {
                String[][] stringArrayArray7 = new String[7][];
                stringArrayArray7[0] = new String[]{"Location", "left", "true"};
                stringArrayArray7[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray7[2] = new String[]{"Exam Capacity", "right", "false"};
                stringArrayArray7[3] = new String[]{colArea, "right", "false"};
                stringArrayArray7[4] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray7[5] = new String[]{"Groups", "left", "true"};
                stringArrayArray = stringArrayArray7;
                stringArrayArray7[6] = new String[]{"Features", "left", "true"};
            } else {
                String[][] stringArrayArray8 = new String[5][];
                stringArrayArray8[0] = new String[]{"Location", "left", "true"};
                stringArrayArray8[1] = new String[]{"Capacity", "right", "false"};
                stringArrayArray8[2] = new String[]{colArea, "right", "false"};
                stringArrayArray8[3] = new String[]{"Period Preferences", "center", "true"};
                stringArrayArray = stringArrayArray8;
                stringArrayArray8[4] = new String[]{"Groups", "left", "true"};
            }
        } else if (featuresOneColumn) {
            String[][] stringArrayArray9 = new String[11][];
            stringArrayArray9[0] = new String[]{"Location", "left", "true"};
            stringArrayArray9[1] = new String[]{"Capacity", "right", "false"};
            stringArrayArray9[2] = new String[]{colArea, "right", "false"};
            stringArrayArray9[3] = new String[]{"IgnTooFar", "center", "true"};
            stringArrayArray9[4] = new String[]{"IgnChecks", "center", "true"};
            stringArrayArray9[5] = new String[]{"Availability", "left", "true"};
            stringArrayArray9[6] = new String[]{"Departments", "left", "true"};
            stringArrayArray9[7] = new String[]{"Control", "left", "true"};
            stringArrayArray9[8] = new String[]{"Events", "left", "true"};
            stringArrayArray9[9] = new String[]{"Groups", "left", "true"};
            stringArrayArray = stringArrayArray9;
            stringArrayArray9[10] = new String[]{"Features", "left", "true"};
        } else {
            String[][] stringArrayArray10 = new String[11][];
            stringArrayArray10[0] = new String[]{"Location", "left", "true"};
            stringArrayArray10[1] = new String[]{"Capacity", "right", "false"};
            stringArrayArray10[2] = new String[]{"Exam Capacity", "right", "false"};
            stringArrayArray10[3] = new String[]{colArea, "right", "false"};
            stringArrayArray10[4] = new String[]{"IgnTooFar", "center", "true"};
            stringArrayArray10[5] = new String[]{"IgnChecks", "center", "true"};
            stringArrayArray10[6] = new String[]{"Availability", "left", "true"};
            stringArrayArray10[7] = new String[]{"Departments", "left", "true"};
            stringArrayArray10[8] = new String[]{"Control", "left", "true"};
            stringArrayArray10[9] = new String[]{"Events", "left", "true"};
            stringArrayArray = stringArrayArray10;
            stringArrayArray10[10] = new String[]{"Groups", "left", "true"};
        }
        String[][] fixedHeading2 = stringArrayArray;
        String[] stringArray = new String[fixedHeading2.length + (featuresOneColumn ? 0 : globalRoomFeatures.size() + deptRoomFeatures.size())];
        for (i = 0; i < fixedHeading2.length; ++i) {
            stringArray[i] = fixedHeading2[i][0];
        }
        if (!featuresOneColumn) {
            i = fixedHeading2.length;
            Iterator it = globalRoomFeatures.iterator();
            while (it.hasNext()) {
                stringArray[i] = ((GlobalRoomFeature)it.next()).getLabel();
                stringArray[i] = stringArray[i].replaceFirst(" ", "\n");
                ++i;
            }
            for (Object drf : deptRoomFeatures) {
                stringArray[i] = ((BaseRoomFeature)drf).getLabel();
                stringArray[i] = stringArray[i].replaceFirst(" ", "\n");
                if (roomListForm.getDeptCodeX().equalsIgnoreCase("All")) {
                    Department dept = Department.findByDeptCode(((DepartmentRoomFeature)drf).getDeptCode(), sessionId);
                    int n = i;
                    stringArray[n] = stringArray[n] + " (" + dept.getShortLabel() + ")";
                }
                ++i;
            }
        }
        TreeSet roomTypes = new TreeSet(RoomTypeDAO.getInstance().findAll());
        Hashtable<RoomType, CSVFile> tables = new Hashtable<RoomType, CSVFile>();
        for (RoomType t : roomTypes) {
            CSVFile table = new CSVFile();
            ArrayList<CSVFile.CSVField> header = new ArrayList<CSVFile.CSVField>();
            for (String h : t.isRoom() != false ? heading1 : stringArray) {
                header.add(new CSVFile.CSVField((Object)h));
            }
            table.setHeader(header);
            tables.put(t, table);
        }
        Department dept = new Department();
        dept = !roomListForm.getDeptCodeX().equalsIgnoreCase("All") ? Department.findByDeptCode(roomListForm.getDeptCodeX(), sessionId) : null;
        for (Location location : rooms) {
            boolean editable = this.sessionContext.hasPermission(location, Right.RoomDetail);
            Room room = location instanceof Room ? (Room)location : null;
            Building bldg = room == null ? null : room.getBuilding();
            CSVFile table = (CSVFile)tables.get(location.getRoomType());
            DecimalFormat df5 = new DecimalFormat("####0");
            CSVFile.CSVField[] text = new CSVFile.CSVField[location instanceof Room ? heading1.length : stringArray.length];
            int idx = 0;
            if (bldg != null) {
                text[idx] = new CSVFile.CSVField((Object)bldg.getAbbreviation());
                ++idx;
            }
            text[idx] = new CSVFile.CSVField((Object)(room == null ? location.getLabel() : room.getRoomNumber()));
            text[++idx] = new CSVFile.CSVField((Object)df5.format(location.getCapacity()));
            ++idx;
            if (examType != null) {
                text[idx] = location.isExamEnabled(examType) ? new CSVFile.CSVField((Object)df5.format(location.getExamCapacity())) : new CSVFile.CSVField((Object)"");
                text[++idx] = location.getArea() == null ? new CSVFile.CSVField((Object)"") : new CSVFile.CSVField((Object)dfa.format(location.getArea()));
                text[++idx] = location.isExamEnabled(examType) ? new CSVFile.CSVField((Object)location.getExamPreferencesAbbreviation(examType)) : new CSVFile.CSVField((Object)"");
                ++idx;
            } else {
                text[idx] = location.getArea() == null ? new CSVFile.CSVField((Object)"") : new CSVFile.CSVField((Object)dfa.format(location.getArea()));
                ++idx;
                PreferenceLevel roomPref = location.getRoomPreferenceLevel(dept);
                if (editable && roomPref != null && !PreferenceLevel.sNeutral.equals(roomPref.getPrefProlog())) {
                    if (room == null) {
                        text[0] = new CSVFile.CSVField((Object)(location.getLabel() + " (" + roomPref.getAbbreviation() + ")"));
                    } else {
                        text[0] = new CSVFile.CSVField((Object)(bldg == null ? "" : bldg.getAbbreviation()));
                        text[1] = new CSVFile.CSVField((Object)(room.getRoomNumber() + " (" + roomPref.getAbbreviation() + ")"));
                    }
                }
                if (location instanceof NonUniversityLocation) {
                    boolean itf = location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar();
                    text[idx] = new CSVFile.CSVField((Object)(itf ? "Yes" : "No"));
                    boolean con = location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck();
                    text[++idx] = new CSVFile.CSVField((Object)(con ? "YES" : "No"));
                    ++idx;
                }
                RequiredTimeTable rtt = location.getRoomSharingTable();
                text[idx] = new CSVFile.CSVField((Object)rtt.getModel().toString().replaceAll(", ", "\n"));
                Department controlDept = null;
                text[++idx] = new CSVFile.CSVField((Object)"");
                Set<RoomDept> rds = location.getRoomDepts();
                HashSet<Department> departments = new HashSet<Department>();
                for (RoomDept rd : rds) {
                    Department d = rd.getDepartment();
                    if (rd.isControl().booleanValue()) {
                        controlDept = d;
                    }
                    departments.add(d);
                }
                TreeSet<Department> ts = new TreeSet<Department>(new DepartmentNameComparator());
                ts.addAll(departments);
                if (ts.size() == session.getDepartments().size()) {
                    text[idx] = new CSVFile.CSVField((Object)"");
                } else {
                    for (Department d : ts) {
                        text[idx] = new CSVFile.CSVField((Object)(text[idx].toString() + (text[idx].toString().isEmpty() ? "" : "\n") + d.getShortLabel()));
                    }
                }
                text[++idx] = !roomListForm.getDeptCodeX().equalsIgnoreCase("All") && !roomListForm.getDeptCodeX().matches("Exam[0-9]*") ? (controlDept != null && controlDept.getDeptCode().equals(roomListForm.getDeptCodeX()) ? new CSVFile.CSVField((Object)"Yes") : new CSVFile.CSVField((Object)"No")) : (controlDept != null ? new CSVFile.CSVField((Object)controlDept.getShortLabel()) : new CSVFile.CSVField((Object)""));
                text[++idx] = location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents() != false ? new CSVFile.CSVField((Object)location.getEventDepartment().getShortLabel()) : new CSVFile.CSVField((Object)"");
                ++idx;
            }
            text[idx] = new CSVFile.CSVField((Object)"");
            for (RoomGroup rg : new TreeSet<RoomGroup>(location.getRoomGroups())) {
                if (!rg.isGlobal().booleanValue() && (examType != null || !depts.contains(rg.getDepartment()))) continue;
                if (!rg.isGlobal().booleanValue()) {
                    boolean skip = true;
                    for (RoomDept rd : location.getRoomDepts()) {
                        if (!rg.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                text[idx] = new CSVFile.CSVField((Object)(text[idx].toString() + (text[idx].toString().isEmpty() ? "" : "\n") + rg.getName()));
            }
            ++idx;
            if (featuresOneColumn) {
                text[idx] = new CSVFile.CSVField((Object)"");
                for (GlobalRoomFeature rf : new TreeSet<GlobalRoomFeature>((SortedSet<GlobalRoomFeature>)location.getGlobalRoomFeatures())) {
                    if (text[idx].toString().length() > 0) {
                        text[idx] = new CSVFile.CSVField((Object)(text[idx].toString() + "\n"));
                    }
                    text[idx] = new CSVFile.CSVField((Object)(text[idx].toString() + " " + rf.getLabelWithType()));
                }
                if (examType == null) {
                    for (DepartmentRoomFeature drf : new TreeSet<DepartmentRoomFeature>((SortedSet<DepartmentRoomFeature>)location.getDepartmentRoomFeatures())) {
                        if (!depts.contains(drf.getDepartment())) continue;
                        boolean skip = true;
                        for (RoomDept rd : location.getRoomDepts()) {
                            if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                            skip = false;
                            break;
                        }
                        if (skip) continue;
                        text[idx] = new CSVFile.CSVField((Object)(text[idx].toString() + (text[idx].toString().isEmpty() ? "" : "\n") + drf.getLabelWithType()));
                    }
                }
                ++idx;
            } else {
                for (GlobalRoomFeature grf : globalRoomFeatures) {
                    boolean b = location.hasFeature(grf);
                    text[idx] = new CSVFile.CSVField((Object)(b ? "Yes" : "No"));
                    ++idx;
                }
                for (DepartmentRoomFeature drf : deptRoomFeatures) {
                    boolean b = location.hasFeature(drf);
                    for (RoomDept rd : location.getRoomDepts()) {
                        if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                        b = false;
                        break;
                    }
                    text[idx] = new CSVFile.CSVField((Object)(b ? "Yes" : "No"));
                    ++idx;
                }
            }
            table.addLine(text);
        }
        for (RoomType t : roomTypes) {
            CSVFile table = (CSVFile)tables.get(t);
            if (table.getLines() == null || table.getLines().isEmpty()) continue;
            out.println(t.getLabel());
            out.println(table.getHeader().toString());
            for (CSVFile.CSVLine l : table.getLines()) {
                out.println(l.toString());
            }
            out.println();
        }
    }
}

