/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomGroupEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.struts.SpringAwareLookupDispatchAction;
import org.unitime.timetable.util.Constants;

@Service(value="/roomGroupEdit")
public class RoomGroupEditAction
extends SpringAwareLookupDispatchAction {
    @Autowired
    SessionContext sessionContext;

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("editRoomGroup", "editRoomGroup");
        map.put("button.delete", "deleteRoomGroup");
        map.put("button.update", "saveRoomGroup");
        map.put("button.addNew", "saveRoomGroup");
        map.put("button.returnToRoomGroupList", "cancelRoomGroup");
        return map;
    }

    public ActionForward editRoomGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        RoomGroupEditForm roomGroupEditForm = (RoomGroupEditForm)form;
        Long id = new Long(Long.parseLong(request.getParameter("id")));
        roomGroupEditForm.setId(id.toString());
        RoomGroupDAO rdao = new RoomGroupDAO();
        RoomGroup rg = (RoomGroup)rdao.get(id);
        this.sessionContext.checkPermission(rg, rg.isGlobal() != false ? Right.GlobalRoomGroupEdit : Right.DepartmenalRoomGroupEdit);
        roomGroupEditForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (roomGroupEditForm.getName() == null || roomGroupEditForm.getName().isEmpty()) {
            roomGroupEditForm.setName(rg.getName());
        }
        if (roomGroupEditForm.getAbbv() == null || roomGroupEditForm.getAbbv().isEmpty()) {
            roomGroupEditForm.setAbbv(rg.getAbbv());
        }
        roomGroupEditForm.setGlobal(rg.isGlobal());
        if (rg.isGlobal().booleanValue()) {
            Department department;
            roomGroupEditForm.setDeptCode(null);
            roomGroupEditForm.setDeptName(null);
            String dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (dept != null && dept.matches("Exam[0-9]*")) {
                roomGroupEditForm.setDeptName(((ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(dept.substring(4)))).getLabel() + " Examination Rooms");
            } else if (dept != null && !dept.isEmpty() && !"All".equals(dept) && (department = Department.findByDeptCode(dept, this.sessionContext.getUser().getCurrentAcademicSessionId())) != null) {
                roomGroupEditForm.setDeptName(department.getDeptCode() + " - " + department.getName());
            }
        } else {
            roomGroupEditForm.setDeptCode(rg.getDepartment().getDeptCode());
            roomGroupEditForm.setDeptName(rg.getDepartment().getDeptCode() + " - " + rg.getDepartment().getName());
        }
        roomGroupEditForm.setDeft(rg.isDefaultGroup());
        if (roomGroupEditForm.getDesc() == null || roomGroupEditForm.getDesc().isEmpty()) {
            roomGroupEditForm.setDesc(rg.getDescription());
        }
        Collection assigned = this.getAssignedRooms(rg);
        Collection available = this.getAvailableRooms(rg);
        TreeSet sortedAssignedRooms = new TreeSet(assigned);
        roomGroupEditForm.setAssignedRooms(sortedAssignedRooms);
        TreeSet sortedAvailableRooms = new TreeSet(available);
        roomGroupEditForm.setNotAssignedRooms(sortedAvailableRooms);
        roomGroupEditForm.setRooms();
        return mapping.findForward("showEdit");
    }

    public ActionForward cancelRoomGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RoomGroupEditForm roomGroupEditForm = (RoomGroupEditForm)form;
        if (roomGroupEditForm.getId() != null) {
            request.setAttribute("hash", (Object)("A" + roomGroupEditForm.getId()));
        }
        return mapping.findForward("showRoomGroupList");
    }

    public ActionForward deleteRoomGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroupEditForm roomGroupEditForm = (RoomGroupEditForm)form;
        Long id = new Long(roomGroupEditForm.getId());
        RoomGroupDAO rgdao = new RoomGroupDAO();
        org.hibernate.Session hibSession = rgdao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            RoomGroup rg = (RoomGroup)rgdao.get(id, hibSession);
            if (rg != null) {
                this.sessionContext.checkPermission(rg, rg.isGlobal() != false ? Right.GlobalRoomGroupDelete : Right.DepartmenalRoomGroupDelete);
                ChangeLog.addChange(hibSession, this.sessionContext, rg, ChangeLog.Source.ROOM_GROUP_EDIT, ChangeLog.Operation.DELETE, null, rg.getDepartment());
                Set<Location> rooms = rg.getRooms();
                for (Location r : rooms) {
                    Set<RoomGroup> roomGroups = r.getRoomGroups();
                    roomGroups.remove(rg);
                    hibSession.saveOrUpdate((Object)r);
                }
                for (RoomGroupPref p : hibSession.createQuery("from RoomGroupPref p where p.roomGroup.uniqueId = :id").setLong("id", id.longValue()).list()) {
                    p.getOwner().getPreferences().remove(p);
                    hibSession.delete((Object)p);
                    hibSession.saveOrUpdate((Object)p.getOwner());
                }
                hibSession.delete((Object)rg);
            }
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return mapping.findForward("showRoomGroupList");
    }

    public ActionForward saveRoomGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroupEditForm roomGroupEditForm = (RoomGroupEditForm)form;
        ActionMessages errors = new ActionMessages();
        errors = roomGroupEditForm.validate(mapping, request);
        if (errors.size() != 0) {
            this.saveErrors(request, errors);
            this.editRoomGroup(mapping, form, request, response);
            return mapping.findForward("showEdit");
        }
        this.update(mapping, roomGroupEditForm, request, response);
        if (roomGroupEditForm.getId() != null) {
            request.setAttribute("hash", (Object)("A" + roomGroupEditForm.getId()));
        }
        return mapping.findForward("showRoomGroupList");
    }

    private void update(ActionMapping mapping, RoomGroupEditForm roomGroupEditForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroup rg;
        Long id = new Long(roomGroupEditForm.getId());
        LocationDAO rdao = new LocationDAO();
        RoomGroupDAO rgdao = new RoomGroupDAO();
        this.sessionContext.checkPermission(rg, (rg = (RoomGroup)rgdao.get(id)).isGlobal() != false ? Right.GlobalRoomGroupEdit : Right.DepartmenalRoomGroupEdit);
        if (roomGroupEditForm.getName() != null && !roomGroupEditForm.getName().trim().equalsIgnoreCase("")) {
            rg.setName(roomGroupEditForm.getName());
        }
        if (roomGroupEditForm.getAbbv() != null && !roomGroupEditForm.getAbbv().trim().equalsIgnoreCase("")) {
            rg.setAbbv(roomGroupEditForm.getAbbv());
        }
        if (roomGroupEditForm.getDesc() != null) {
            rg.setDescription(roomGroupEditForm.getDesc().length() > 200 ? roomGroupEditForm.getDesc().substring(0, 200) : roomGroupEditForm.getDesc());
        }
        if (this.sessionContext.hasPermission(rg, Right.GlobalRoomGroupEditSetDefault)) {
            if (roomGroupEditForm.isDeft()) {
                rg.setDefaultGroup(Boolean.TRUE);
            } else {
                rg.setDefaultGroup(Boolean.FALSE);
            }
        }
        Object[] selectedAssigned = roomGroupEditForm.getAssignedSelected();
        String[] selectedNotAssigned = roomGroupEditForm.getNotAssignedSelected();
        Collection assignedRooms = this.getAssignedRooms(rg);
        String s1 = null;
        s1 = selectedAssigned.length != 0 ? Constants.arrayToStr(selectedAssigned, "", ",") : new String();
        org.hibernate.Session hibSession = rgdao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            this.checkDefault(hibSession, rg);
            if (selectedAssigned.length != assignedRooms.size()) {
                Set<Location> rooms = rg.getRooms();
                HashSet<Location> m = new HashSet<Location>();
                for (Location r : rooms) {
                    if (!assignedRooms.contains(r) || s1.indexOf(r.getUniqueId().toString()) != -1) continue;
                    Set<RoomGroup> roomGroups = r.getRoomGroups();
                    roomGroups.remove(rg);
                    hibSession.saveOrUpdate((Object)r);
                    m.add(r);
                }
                rooms.removeAll(m);
            }
            if (selectedNotAssigned.length != 0) {
                HashSet<Location> m = new HashSet<Location>();
                for (int i = 0; i < selectedNotAssigned.length; ++i) {
                    Location r = (Location)rdao.get(Long.valueOf(selectedNotAssigned[i]));
                    Set<RoomGroup> groups = r.getRoomGroups();
                    groups.add(rg);
                    hibSession.saveOrUpdate((Object)r);
                    m.add(r);
                }
                rg.setRooms(m);
            }
            hibSession.saveOrUpdate((Object)rg);
            ChangeLog.addChange(hibSession, this.sessionContext, rg, ChangeLog.Source.ROOM_GROUP_EDIT, ChangeLog.Operation.UPDATE, null, rg.getDepartment());
            tx.commit();
            hibSession.refresh((Object)rg);
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void checkDefault(org.hibernate.Session hibSession, RoomGroup rg) {
        if (!rg.isDefaultGroup().booleanValue()) {
            return;
        }
        for (RoomGroup x : RoomGroup.getAllRoomGroupsForSession(rg.getSession())) {
            if (x.getUniqueId().equals(rg.getUniqueId()) || !x.isDefaultGroup().booleanValue()) continue;
            x.setDefaultGroup(Boolean.FALSE);
            hibSession.saveOrUpdate((Object)x);
        }
    }

    private Collection getAssignedRooms(RoomGroup rg) throws Exception {
        ArrayList<Location> rooms;
        block4: {
            Department department;
            String dept;
            block3: {
                rooms = new ArrayList<Location>(rg.getRooms());
                dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
                if (dept == null || !dept.matches("Exam[0-9]*")) break block3;
                Long examType = Long.valueOf(dept.substring(4));
                Iterator i = rooms.iterator();
                while (i.hasNext()) {
                    if (((Location)i.next()).isExamEnabled(examType)) continue;
                    i.remove();
                }
                break block4;
            }
            if (dept == null || dept.isEmpty() || "All".equals(dept) || (department = Department.findByDeptCode(dept, this.sessionContext.getUser().getCurrentAcademicSessionId())) == null) break block4;
            Iterator i = rooms.iterator();
            block1: while (i.hasNext()) {
                Location location = (Location)i.next();
                for (RoomDept rd : location.getRoomDepts()) {
                    if (!rd.getDepartment().equals(department)) continue;
                    continue block1;
                }
                i.remove();
            }
        }
        return rooms;
    }

    private Collection getAvailableRooms(RoomGroup rg) throws Exception {
        ArrayList<Object> rooms = null;
        if (!rg.isGlobal().booleanValue() && rg.getDepartment() != null) {
            Department dept = rg.getDepartment();
            rooms = new ArrayList();
            for (RoomDept rd : dept.getRoomDepts()) {
                rooms.add(rd.getRoom());
            }
        } else {
            Session session = rg.getSession();
            String dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (dept != null && dept.matches("Exam[0-9]*")) {
                rooms = new ArrayList(Location.findAllExamLocations(session.getUniqueId(), Long.valueOf(dept.substring(4))));
            } else if (dept != null && !dept.isEmpty() && !"All".equals(dept)) {
                Department department = Department.findByDeptCode(dept, session.getUniqueId());
                if (department != null) {
                    rooms = new ArrayList();
                    for (RoomDept rd : department.getRoomDepts()) {
                        rooms.add(rd.getRoom());
                    }
                } else {
                    rooms = new ArrayList<Location>(Location.findAll(session.getUniqueId()));
                }
            } else {
                rooms = new ArrayList<Location>(Location.findAll(session.getUniqueId()));
            }
        }
        Collections.sort(rooms);
        rooms.removeAll(rg.getRooms());
        return rooms;
    }
}

