/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.action.EditRoomAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.RoomDetailForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="/roomDetail")
public class RoomDetailAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomDetailForm roomDetailForm = (RoomDetailForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = roomDetailForm.getDoit();
        if (doit != null) {
            if (doit.equals(rsc.getMessage("button.delete")) && "y".equals(request.getParameter("confirm"))) {
                this.doDelete(roomDetailForm, request);
                return mapping.findForward("showRoomList");
            }
            if (doit.equals(rsc.getMessage("button.returnToRoomList"))) {
                if (roomDetailForm.getId() != null) {
                    request.setAttribute("hash", (Object)("A" + roomDetailForm.getId()));
                }
                return mapping.findForward("showRoomList");
            }
            if (doit.equals(rsc.getMessage("button.modifyRoom"))) {
                return mapping.findForward("showEditRoom");
            }
            if (doit.equals(rsc.getMessage("button.modifyRoomDepts"))) {
                response.sendRedirect(response.encodeURL("gwt.jsp?page=roomavailability&id=" + roomDetailForm.getId()));
                return null;
            }
            if (doit.equals("Edit Event Availability")) {
                response.sendRedirect(response.encodeURL("gwt.jsp?page=roomavailability&events=1&id=" + roomDetailForm.getId()));
                return null;
            }
            if (doit.equals("Pictures")) {
                response.sendRedirect(response.encodeURL("gwt.jsp?page=roompictures&id=" + roomDetailForm.getId()));
                return null;
            }
            if (doit.equals(rsc.getMessage("button.modifyRoomGroups"))) {
                return mapping.findForward("showEditRoomGroup");
            }
            if (doit.equals(rsc.getMessage("button.modifyRoomFeatures"))) {
                return mapping.findForward("showEditRoomFeature");
            }
            if (doit.equals(rsc.getMessage("button.modifyRoomPreference")) || doit.equals(rsc.getMessage("button.addRoomPreference"))) {
                return mapping.findForward("showEditRoomPref");
            }
            if (doit.equals(rsc.getMessage("button.nextRoom"))) {
                response.sendRedirect(response.encodeURL("roomDetail.do?id=" + roomDetailForm.getNext()));
                return null;
            }
            if (doit.equals(rsc.getMessage("button.previousRoom"))) {
                response.sendRedirect(response.encodeURL("roomDetail.do?id=" + roomDetailForm.getPrevious()));
                return null;
            }
        }
        if (request.getParameter("id") == null && roomDetailForm.getId() == null) {
            return mapping.findForward("showRoomList");
        }
        Long id = Long.valueOf(request.getParameter("id") != null ? request.getParameter("id") : roomDetailForm.getId());
        this.sessionContext.checkPermission(id, "Location", Right.RoomDetail);
        LocationDAO ldao = new LocationDAO();
        Location location = (Location)ldao.get(id);
        if (location instanceof Room) {
            roomDetailForm.setNonUniv(false);
        } else {
            roomDetailForm.setNonUniv(true);
        }
        roomDetailForm.setPrevious(Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, id));
        roomDetailForm.setNext(Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, id));
        BackTracker.markForBack(request, "roomDetail.do?id=" + id, location.getLabel(), true, false);
        boolean timeVertical = CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
        RequiredTimeTable rtt = location.getRoomSharingTable(this.sessionContext.getUser());
        rtt.getModel().setDefaultSelection(UserProperty.GridSize.get(this.sessionContext.getUser()));
        roomDetailForm.setSharingTable(rtt.print(false, timeVertical));
        Vector<Department> depts = new Vector<Department>();
        for (RoomDept rd : location.getRoomDepts()) {
            depts.add(rd.getDepartment());
        }
        Collections.sort(depts);
        Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>(depts.size());
        Iterator<Object> i = depts.iterator();
        while (i.hasNext()) {
            Department department = (Department)i.next();
            PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral);
            Set roomPrefs = department.getEffectiveRoomPreferences();
            for (RoomPref rp : roomPrefs) {
                if (!rp.getRoom().equals(location)) continue;
                pref = rp.getPrefLevel();
                break;
            }
            if (pref.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                i.remove();
                continue;
            }
            prefs.addElement(pref);
        }
        roomDetailForm.setDepts(depts);
        roomDetailForm.setRoomPrefs(prefs);
        LookupTables.setupPrefLevels(request);
        for (ExamType examType : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            roomDetailForm.setExamEnabled(examType.getUniqueId().toString(), location.getExamTypes().contains(examType));
        }
        roomDetailForm.setExamCapacity(location.getExamCapacity());
        for (ExamType examType : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            if (examType.getType() == 1) {
                MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(location.getSession(), examType);
                epx.load(location);
                epx.setName("mp" + examType.getUniqueId());
                request.setAttribute("PeriodPrefs" + examType.getUniqueId(), (Object)epx.print(false));
                continue;
            }
            PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), examType.getUniqueId());
            px.load(location);
            px.setAllowRequired(false);
            RequiredTimeTable rttPx = new RequiredTimeTable(px);
            rttPx.setName("PeriodPrefs" + examType.getUniqueId());
            request.setAttribute("PeriodPrefs" + examType.getUniqueId(), (Object)rttPx.print(false, timeVertical, true, false));
        }
        roomDetailForm.setCapacity(location.getCapacity());
        roomDetailForm.setCoordinateX(location.getCoordinateX());
        roomDetailForm.setCoordinateY(location.getCoordinateY());
        roomDetailForm.setArea(location.getArea() == null ? null : new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).format(location.getArea()));
        roomDetailForm.setIgnoreTooFar(location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar());
        roomDetailForm.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        roomDetailForm.setGlobalFeatures(new TreeSet<GlobalRoomFeature>((SortedSet<GlobalRoomFeature>)location.getGlobalRoomFeatures()));
        roomDetailForm.setDepartmentFeatures(new TreeSet<DepartmentRoomFeature>((SortedSet<DepartmentRoomFeature>)location.getDepartmentRoomFeatures()));
        i = roomDetailForm.getDepartmentFeatures().iterator();
        while (i.hasNext()) {
            DepartmentRoomFeature departmentRoomFeature = (DepartmentRoomFeature)i.next();
            boolean skip = true;
            for (RoomDept rd : location.getRoomDepts()) {
                if (!departmentRoomFeature.getDepartment().equals(rd.getDepartment())) continue;
                skip = false;
                break;
            }
            if (!skip) continue;
            i.remove();
        }
        for (LocationPicture locationPicture : new TreeSet<LocationPicture>(location.getPictures())) {
            roomDetailForm.getPictures().add("picture?id=" + locationPicture.getUniqueId());
        }
        roomDetailForm.setGroups(new TreeSet<RoomGroup>(location.getRoomGroups()));
        i = roomDetailForm.getGroups().iterator();
        while (i.hasNext()) {
            RoomGroup roomGroup = (RoomGroup)i.next();
            if (roomGroup.isGlobal().booleanValue()) continue;
            boolean skip = true;
            for (RoomDept rd : location.getRoomDepts()) {
                if (!roomGroup.getDepartment().equals(rd.getDepartment())) continue;
                skip = false;
                break;
            }
            if (!skip) continue;
            i.remove();
        }
        if (location instanceof Room) {
            Room r = (Room)location;
            roomDetailForm.setName(r.getLabel());
        } else if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nonUnivLocation = (NonUniversityLocation)location;
            roomDetailForm.setName(nonUnivLocation.getName());
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("roomDetail", new ActionMessage("errors.lookup.notFound", (Object)"Room"));
            this.saveErrors(request, errors);
        }
        roomDetailForm.setExternalId(location.getExternalUniqueId());
        roomDetailForm.setType(location.getRoomType().getUniqueId());
        roomDetailForm.setTypeName(location.getRoomType().getLabel());
        for (RoomDept roomDept : location.getRoomDepts()) {
            if (!roomDept.isControl().booleanValue()) continue;
            roomDetailForm.setControl(roomDept.getDepartment().getUniqueId().toString());
        }
        roomDetailForm.setEventDepartment(location.getEventDepartment() == null ? null : location.getEventDepartment().getUniqueId().toString());
        roomDetailForm.setBreakTime(location.getEffectiveBreakTime() == 0 && location.getBreakTime() == null ? "" : String.valueOf(location.getEffectiveBreakTime()) + (location.getBreakTime() == null ? " <i>(Default)</i>" : ""));
        roomDetailForm.setEventStatus(location.getEffectiveEventStatus().toString() + (location.getEventStatus() == null ? " <i>(Default)</i>" : ""));
        roomDetailForm.setNote(location.getNote() == null ? "" : location.getNote());
        EditRoomAction.setupDepartments(request, this.sessionContext, location);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("showRoomDetail");
    }

    private void doDelete(RoomDetailForm roomDetailForm, HttpServletRequest request) throws Exception {
        Long id = Long.valueOf(request.getParameter("id"));
        LocationDAO ldao = new LocationDAO();
        Session hibSession = ldao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Location location = (Location)ldao.get(id, hibSession);
            if (location != null) {
                Event event;
                if (location instanceof NonUniversityLocation) {
                    this.sessionContext.checkPermission(id, "NonUniversityLocation", Right.NonUniversityLocationDelete);
                } else {
                    this.sessionContext.checkPermission(id, "Location", Right.RoomDelete);
                }
                ChangeLog.addChange(hibSession, this.sessionContext, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.DELETE, null, location.getControllingDepartment());
                List roomPrefs = hibSession.createCriteria(RoomPref.class).add((Criterion)Restrictions.eq((String)"room.uniqueId", (Object)id)).list();
                for (RoomDept rd : location.getRoomDepts()) {
                    Department department = rd.getDepartment();
                    department.getRoomDepts().remove(rd);
                    hibSession.delete((Object)rd);
                    hibSession.saveOrUpdate((Object)department);
                }
                for (RoomPref rp : roomPrefs) {
                    rp.getOwner().getPreferences().remove(rp);
                    hibSession.delete((Object)rp);
                    hibSession.saveOrUpdate((Object)rp.getOwner());
                }
                Iterator<Serializable> i = location.getAssignments().iterator();
                while (i.hasNext()) {
                    Assignment a = (Assignment)i.next();
                    a.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)a);
                    i.remove();
                }
                HashMap<Event, ArrayList<Meeting>> deletedMeetings = new HashMap<Event, ArrayList<Meeting>>();
                for (Meeting meeting : hibSession.createQuery("select m from Meeting m, Location l where l.uniqueId = :locId and m.locationPermanentId = l.permanentId and m.meetingDate >= l.session.eventBeginDate and m.meetingDate <= l.session.eventEndDate").setLong("locId", location.getUniqueId().longValue()).list()) {
                    event = meeting.getEvent();
                    event.getMeetings().remove(meeting);
                    ArrayList<Meeting> deleted = (ArrayList<Meeting>)deletedMeetings.get(event);
                    if (deleted == null) {
                        deleted = new ArrayList<Meeting>();
                        deletedMeetings.put(event, deleted);
                    }
                    deleted.add(meeting);
                }
                for (Map.Entry entry : deletedMeetings.entrySet()) {
                    event = (Event)entry.getKey();
                    List meetings = (List)entry.getValue();
                    if (event.getMeetings().isEmpty()) {
                        hibSession.delete((Object)event);
                        continue;
                    }
                    EventNote note = new EventNote();
                    note.setEvent(event);
                    note.setNoteType(4);
                    note.setTimeStamp(new Date());
                    note.setUser(this.sessionContext.getUser().getTrueName());
                    note.setUserId(this.sessionContext.getUser().getTrueExternalUserId());
                    note.setTextNote(location.getLabel() + " has been deleted.");
                    note.setMeetingCollection(meetings);
                    event.getNotes().add(note);
                    hibSession.saveOrUpdate((Object)event);
                }
                hibSession.delete((Object)location);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
    }
}

