/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.StaffDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Constants;

public class InstructorAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstructorEditForm frm = (InstructorEditForm)form;
        frm.setLookupEnabled(ApplicationProperty.InstructorExternalIdLookup.isTrue() && ApplicationProperty.InstructorExternalIdLookupClass.value() != null);
        return null;
    }

    protected void fillStaffInfo(InstructorEditForm frm, HttpServletRequest request) throws Exception {
        Staff staff = (Staff)new StaffDAO().get(new Long(frm.getSearchSelect()));
        frm.setPuId(staff.getExternalUniqueId());
        frm.setFname(staff.getFirstName() != null ? staff.getFirstName().trim() : "");
        frm.setMname(staff.getMiddleName() != null ? staff.getMiddleName().trim() : "");
        frm.setLname(staff.getLastName() != null ? staff.getLastName().trim() : "");
        frm.setTitle(staff.getAcademicTitle() != null ? staff.getAcademicTitle().trim() : "");
        frm.setEmail(staff.getEmail());
        if (staff.getPositionType() != null && (frm.getPosType() == null || frm.getPosType().trim().length() == 0)) {
            frm.setPosType(staff.getPositionType().getUniqueId().toString());
        }
    }

    protected void fillI2A2Info(InstructorEditForm frm, HttpServletRequest request) throws Exception {
        ExternalUidLookup.UserInfo results;
        String login = frm.getCareerAcct();
        if (login != null && login.trim().length() > 0 && frm.getLookupEnabled().booleanValue() && (results = this.lookupInstructor(frm)) != null) {
            frm.setPuId(results.getExternalId());
            frm.setCareerAcct(results.getUserName());
            frm.setFname(results.getFirstName());
            frm.setMname(results.getMiddleName());
            frm.setLname(results.getLastName());
            frm.setEmail(results.getEmail());
            frm.setTitle(results.getAcademicTitle());
        }
    }

    protected void findMatchingInstructor(InstructorEditForm frm, HttpServletRequest request) throws Exception {
        ExternalUidLookup.UserInfo results;
        frm.setMatchFound(new Boolean(false));
        String fname = frm.getFname();
        String lname = frm.getLname();
        String login = frm.getCareerAcct();
        if (login != null && login.trim().length() > 0 && frm.getLookupEnabled().booleanValue() && (results = this.lookupInstructor(frm)) != null) {
            frm.setI2a2Match(results);
            frm.setMatchFound(Boolean.TRUE);
        }
        List staffList = Staff.findMatchingName(fname, lname);
        frm.setStaffMatch(staffList);
        if (staffList != null && staffList.size() > 0) {
            frm.setMatchFound(new Boolean(true));
        }
    }

    private ExternalUidLookup.UserInfo lookupInstructor(InstructorEditForm frm) throws Exception {
        String id = frm.getCareerAcct();
        if (id != null && id.trim().length() > 0 && frm.getLookupEnabled().booleanValue()) {
            String className = ApplicationProperty.InstructorExternalIdLookupClass.value();
            ExternalUidLookup lookup = (ExternalUidLookup)Class.forName(className).newInstance();
            return lookup.doLookup(id);
        }
        return null;
    }

    protected void doUpdate(InstructorEditForm frm, HttpServletRequest request) throws Exception {
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            PositionType pt;
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = null;
            String instrId = frm.getInstructorId();
            if (instrId != null && instrId.trim().length() > 0) {
                inst = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(new Long(instrId));
            } else {
                inst = new DepartmentalInstructor();
                inst.setAttributes(new HashSet<InstructorAttribute>());
            }
            if (frm.getFname() != null && frm.getFname().trim().length() > 0) {
                inst.setFirstName(frm.getFname().trim());
            } else {
                inst.setFirstName(null);
            }
            if (frm.getMname() != null && frm.getMname().trim().length() > 0) {
                inst.setMiddleName(frm.getMname().trim());
            } else {
                inst.setMiddleName(null);
            }
            inst.setLastName(frm.getLname().trim());
            if (frm.getTitle() != null && frm.getTitle().trim().length() > 0) {
                inst.setAcademicTitle(frm.getTitle().trim());
            } else {
                inst.setAcademicTitle(null);
            }
            if (frm.getPuId() != null && frm.getPuId().trim().length() > 0 && !frm.getPuId().equalsIgnoreCase("null")) {
                inst.setExternalUniqueId(frm.getPuId().trim());
            }
            if (frm.getCareerAcct() != null && frm.getCareerAcct().trim().length() > 0) {
                inst.setCareerAcct(frm.getCareerAcct().trim());
            }
            inst.setEmail(frm.getEmail());
            if (frm.getPosType() != null && frm.getPosType().trim().length() > 0 && (pt = PositionType.findById(new Long(frm.getPosType().trim()))) != null) {
                inst.setPositionType(pt);
            }
            if (frm.getNote() != null && !frm.getNote().isEmpty()) {
                if (frm.getNote().length() > 2048) {
                    inst.setNote(frm.getNote().substring(0, 2048));
                } else {
                    inst.setNote(frm.getNote());
                }
            } else {
                inst.setNote(null);
            }
            Department d = null;
            if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) == null) {
                throw new Exception("Department Id could not be retrieved from session");
            }
            String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
            d = (Department)new DepartmentDAO().get(new Long(deptId));
            inst.setDepartment(d);
            d.getInstructors().add(inst);
            inst.setIgnoreToFar(new Boolean(frm.getIgnoreDist()));
            hibSession.saveOrUpdate((Object)inst);
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_EDIT, instrId == null || instrId.trim().length() <= 0 ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, inst.getDepartment());
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    protected boolean isDeptInstructorUnique(InstructorEditForm frm, HttpServletRequest request) {
        String query = "from DepartmentalInstructor where externalUniqueId=:puid and department.uniqueId=:deptId";
        if (frm.getInstructorId() != null && frm.getInstructorId().trim().length() > 0) {
            query = query + " and uniqueId!=:uniqueId";
        }
        DepartmentalInstructorDAO ddao = new DepartmentalInstructorDAO();
        Session hibSession = ddao.getSession();
        HttpSession httpSession = request.getSession();
        String deptId = (String)httpSession.getAttribute(Constants.DEPT_ID_ATTR_NAME);
        Query q = hibSession.createQuery(query);
        q.setString("puid", frm.getPuId().trim());
        q.setLong("deptId", Long.parseLong(deptId));
        if (frm.getInstructorId() != null && frm.getInstructorId().trim().length() > 0) {
            q.setLong("uniqueId", Long.parseLong(frm.getInstructorId().trim()));
        }
        return q.list().size() == 0;
    }
}

