/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.impl.LocalizedLookupDispatchAction;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.Messages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.PdfWorksheet;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.csv.CsvInstructionalOfferingTableBuilder;
import org.unitime.timetable.webutil.pdf.PdfInstructionalOfferingTableBuilder;

@Service(value="/instructionalOfferingSearch")
public class InstructionalOfferingSearchAction
extends LocalizedLookupDispatchAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    @Override
    protected Messages getMessages() {
        return MSG;
    }

    public ActionForward searchInstructionalOfferings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstructionalOffering io;
        TreeSet<InstructionalOffering> offerings;
        this.sessionContext.checkPermission(Right.InstructionalOfferings);
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        ActionErrors errors = null;
        errors = frm.validate(mapping, request);
        if (errors.size() > 0) {
            this.saveErrors(request, (ActionMessages)errors);
            frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            frm.setInstructionalOfferings(null);
            return mapping.findForward("showInstructionalOfferingSearch");
        }
        StringBuffer ids = new StringBuffer();
        StringBuffer names = new StringBuffer();
        StringBuffer subjIds = new StringBuffer();
        for (int i = 0; i < frm.getSubjectAreaIds().length; ++i) {
            if (i > 0) {
                names.append(",");
                subjIds.append(",");
            }
            ids.append("&subjectAreaIds=" + frm.getSubjectAreaIds()[i]);
            subjIds.append(frm.getSubjectAreaIds()[i]);
            names.append(((SubjectArea)new SubjectAreaDAO().get(new Long(frm.getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
        }
        this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjIds.toString());
        this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)frm.getCourseNbr());
        if ("1".equals(request.getParameter("loadInstrFilter"))) {
            InstructionalOfferingSearchAction.setupInstrOffrListSpecificFormFilters(this.sessionContext, frm);
        } else {
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.divSec", frm.getDivSec() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.demand", frm.getDemand() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.projectedDemand", frm.getProjectedDemand() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.minPerWk", frm.getMinPerWk() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.limit", frm.getLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.snapshotLimit", frm.getSnapshotLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.roomLimit", frm.getRoomLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.manager", frm.getManager() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.datePattern", frm.getDatePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.timePattern", frm.getTimePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.instructor", frm.getInstructor() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.preferences", frm.getPreferences() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.timetable", frm.getTimetable() == null ? "0" : (frm.getTimetable() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.credit", frm.getCredit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.subpartCredit", frm.getSubpartCredit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.schedulePrintNote", frm.getSchedulePrintNote() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.note", frm.getNote() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.title", frm.getTitle() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.exams", frm.getExams() == null ? "0" : (frm.getExams() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.instructorAssignment", frm.getInstructorAssignment() == null ? "0" : (frm.getInstructorAssignment() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.lms", frm.getLms() == null ? "0" : (frm.getLms() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.consent", frm.getConsent() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.sortBy", frm.getSortBy());
        }
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            frm.setExams(null);
        }
        Map<Long, TreeSet<InstructionalOffering>> instrOfferings = InstructionalOfferingSearchAction.getInstructionalOfferings(this.sessionContext.getUser().getCurrentAcademicSessionId(), this.classAssignmentService.getAssignment(), frm);
        frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        frm.setInstructionalOfferings(instrOfferings);
        if (instrOfferings.isEmpty()) {
            errors.add("searchResult", new ActionMessage("errors.generic", (Object)MSG.errorNoRecords()));
            this.saveErrors(request, (ActionMessages)errors);
            return mapping.findForward("showInstructionalOfferingSearch");
        }
        BackTracker.markForBack(request, "instructionalOfferingSearch.do?op=Back&doit=Search&loadInstrFilter=1" + ids + "&courseNbr=" + URLEncoder.encode(frm.getCourseNbr(), "utf-8"), MSG.labelInstructionalOfferings() + " (" + names + (frm.getCourseNbr() == null || frm.getCourseNbr().length() == 0 ? "" : " " + frm.getCourseNbr()) + ")", true, true);
        if ((request.getParameter("op") == null || request.getParameter("op") != null && !request.getParameter("op").equalsIgnoreCase("Back")) && frm.getSubjectAreaIds().length == 1 && (offerings = frm.getInstructionalOfferings(Long.valueOf(frm.getSubjectAreaIds()[0]))) != null && offerings.size() == 1 && this.sessionContext.hasPermission(io = offerings.first(), Right.InstructionalOfferingDetail)) {
            ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showInstructionalOfferingDetail"));
            redirect.addParameter("op", (Object)"view");
            redirect.addParameter("io", (Object)io.getUniqueId().toString());
            return redirect;
        }
        return mapping.findForward("showInstructionalOfferingList");
    }

    public ActionForward exportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward fwd = this.searchInstructionalOfferings(mapping, form, request, response);
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        if (this.getErrors(request).isEmpty()) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "offerings");
            new PdfInstructionalOfferingTableBuilder().pdfTableForInstructionalOfferings(out, WebSolver.getClassAssignmentProxy(request.getSession()), WebSolver.getExamSolver(request.getSession()), frm, frm.getSubjectAreaIds(), this.sessionContext, true, frm.getCourseNbr() == null || frm.getCourseNbr().length() == 0);
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public ActionForward exportCsv(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward fwd = this.searchInstructionalOfferings(mapping, form, request, response);
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        if (this.getErrors(request).isEmpty()) {
            PrintWriter out = ExportUtils.getCsvWriter(response, "offerings");
            new CsvInstructionalOfferingTableBuilder().csvTableForInstructionalOfferings(out, WebSolver.getClassAssignmentProxy(request.getSession()), WebSolver.getExamSolver(request.getSession()), frm, frm.getSubjectAreaIds(), this.sessionContext, true, frm.getCourseNbr() == null || frm.getCourseNbr().length() == 0);
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public static void setupInstrOffrListSpecificFormFilters(SessionContext sessionContext, InstructionalOfferingListForm frm) {
        frm.setDivSec("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.divSec", "0")));
        frm.setDemand("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.demand", "1")));
        frm.setProjectedDemand("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.projectedDemand", "1")));
        frm.setMinPerWk("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.minPerWk", "1")));
        frm.setLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.limit", "1")));
        frm.setSnapshotLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.snapshotLimit", "1")));
        frm.setRoomLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.roomLimit", "1")));
        frm.setManager("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.manager", "1")));
        frm.setDatePattern("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.datePattern", "1")));
        frm.setTimePattern("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.timePattern", "1")));
        frm.setInstructor("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.instructor", "1")));
        frm.setPreferences("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.preferences", "1")));
        frm.setTimetable("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.timetable", "1")));
        frm.setCredit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.credit", "0")));
        frm.setSubpartCredit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.subpartCredit", "0")));
        frm.setSchedulePrintNote("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.schedulePrintNote", "1")));
        frm.setNote("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.note", "0")));
        frm.setTitle("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.title", "0")));
        frm.setConsent("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.consent", "0")));
        frm.setSortBy(sessionContext.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        frm.setExams("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.exams", "0")));
        frm.setInstructorAssignment("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.instructorAssignment", "0")));
        frm.setLms("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.lms", "0")));
    }

    public ActionForward worksheetPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward fwd = this.searchInstructionalOfferings(mapping, form, request, response);
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        if (this.getErrors(request).isEmpty()) {
            ArrayList<SubjectArea> subjectAreas = new ArrayList<SubjectArea>();
            for (String subjectAreaId : frm.getSubjectAreaIds()) {
                SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId));
                if (subjectArea == null) continue;
                subjectAreas.add(subjectArea);
            }
            if (subjectAreas.isEmpty()) {
                return fwd;
            }
            OutputStream out = ExportUtils.getPdfOutputStream(response, "worksheet");
            PdfWorksheet.print(out, subjectAreas, frm.getCourseNbr());
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public static Map<Long, TreeSet<InstructionalOffering>> getInstructionalOfferings(Long sessionId, ClassAssignmentProxy classAssignmentProxy, InstructionalOfferingListForm form) {
        boolean fetchStructure = true;
        boolean fetchCredits = false;
        boolean fetchInstructors = false;
        boolean fetchPreferences = false;
        boolean fetchAssignments = false;
        boolean fetchReservations = false;
        Hashtable<Long, TreeSet<InstructionalOffering>> map = new Hashtable<Long, TreeSet<InstructionalOffering>>();
        for (String subjectAreaId : form.getSubjectAreaIds()) {
            TreeSet<InstructionalOffering> ts = InstructionalOffering.search(sessionId, Long.valueOf(subjectAreaId), form.getCourseNbr(), fetchStructure, fetchCredits, fetchInstructors, fetchPreferences, fetchAssignments, fetchReservations);
            if (ts.isEmpty()) continue;
            map.put(Long.valueOf(subjectAreaId), ts);
        }
        return map;
    }

    public ActionForward addInstructionalOfferings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CourseOffering course;
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        Long subjAreaId = frm.getSubjectAreaIds() == null || frm.getSubjectAreaIds().length < 1 ? null : Long.valueOf(frm.getSubjectAreaIds()[0]);
        String courseNbr = frm.getCourseNbr().trim();
        ActionMessages errors = new ActionMessages();
        if (!errors.isEmpty()) {
            frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            this.saveErrors(request, errors);
            if (frm.getInstructionalOfferings() == null || frm.getInstructionalOfferings().isEmpty()) {
                return mapping.findForward("showInstructionalOfferingSearch");
            }
            return mapping.findForward("showInstructionalOfferingList");
        }
        if (subjAreaId != null) {
            this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjAreaId.toString());
            this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
        }
        if (subjAreaId != null && !courseNbr.isEmpty() && ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue() && (course = CourseOffering.findBySessionSubjAreaIdCourseNbr(this.sessionContext.getUser().getCurrentAcademicSessionId(), subjAreaId, courseNbr)) != null) {
            ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showInstructionalOfferingDetail"));
            redirect.addParameter("op", (Object)"view");
            redirect.addParameter("io", (Object)course.getInstructionalOffering().getUniqueId().toString());
            return redirect;
        }
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showCourseOfferingEdit"));
        redirect.addParameter("op", (Object)MSG.actionAddCourseOffering());
        if (subjAreaId != null) {
            redirect.addParameter("subjAreaId", (Object)subjAreaId.toString());
        }
        redirect.addParameter("courseNbr", (Object)courseNbr);
        return redirect;
    }

    public static void setLastInstructionalOffering(SessionContext sessionContext, InstructionalOffering offering) {
        if (offering == null) {
            return;
        }
        String subjectAreaIds = (String)sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        String subjectAreaId = offering.getControllingCourseOffering().getSubjectArea().getUniqueId().toString();
        if (subjectAreaIds == null) {
            sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
        } else {
            boolean contain = false;
            for (String s : subjectAreaIds.split(",")) {
                if (!s.equals(subjectAreaId)) continue;
                contain = true;
                break;
            }
            if (!contain && sessionContext.hasPermission(offering.getControllingCourseOffering().getDepartment(), Right.InstructionalOfferings)) {
                sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            }
        }
        if (sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber) != null && !sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber).toString().isEmpty()) {
            sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)offering.getControllingCourseOffering().getCourseNbr());
        }
    }
}

