/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.ExamChangesForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/examChanges")
public class ExamChangesAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        ExamChangesForm myForm = (ExamChangesForm)form;
        this.sessionContext.checkPermission(Right.ExaminationAssignmentChanges);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Export PDF".equals(op) || "Apply".equals(op)) {
            myForm.save(this.sessionContext);
        } else if ("Refresh".equals(op)) {
            myForm.reset(mapping, request);
        }
        myForm.load(this.sessionContext);
        ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
        myForm.setNoSolver(solver == null);
        Collection<ExamAssignmentInfo[]> changes = null;
        if (myForm.getSubjectArea() != null && myForm.getSubjectArea() != 0L && myForm.getExamType() != null && solver != null) {
            if ("Initial".equals(myForm.getChangeType())) {
                changes = solver.getChangesToInitial(myForm.getSubjectArea());
            } else if ("Best".equals(myForm.getChangeType())) {
                changes = solver.getChangesToBest(myForm.getSubjectArea());
            } else {
                changes = new Vector<ExamAssignmentInfo[]>();
                List exams = null;
                exams = myForm.getSubjectArea() < 0L ? Exam.findAll(solver.getSessionId(), solver.getExamTypeId()) : Exam.findExamsOfSubjectArea(myForm.getSubjectArea(), solver.getExamTypeId());
                block0: for (Exam exam : exams) {
                    ExamAssignment assignment = solver.getAssignment(exam.getUniqueId());
                    if (assignment == null && exam.getAssignedPeriod() == null) continue;
                    if (assignment == null || exam.getAssignedPeriod() == null) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    if (!exam.getAssignedPeriod().getUniqueId().equals(assignment.getPeriodId())) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    if (exam.getAssignedRooms().size() != (assignment.getRooms() == null ? 0 : assignment.getRooms().size())) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    for (Location location : exam.getAssignedRooms()) {
                        if (assignment.hasRoom(location.getUniqueId())) continue;
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue block0;
                    }
                }
            }
        }
        WebTable.setOrder(this.sessionContext, "examChanges.ord", request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(true, myForm, changes);
        if ("Export PDF".equals(op) && table != null) {
            ExportUtils.exportPDF(this.getTable(false, myForm, changes), WebTable.getOrder(this.sessionContext, "examChanges.ord"), response, "changes");
            return null;
        }
        if (table != null) {
            myForm.setTable(table.printTable(WebTable.getOrder(this.sessionContext, "examChanges.ord")), 9, changes.size());
        }
        if (request.getParameter("backId") != null) {
            request.setAttribute("hash", (Object)request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("showReport");
    }

    public PdfWebTable getTable(boolean html, ExamChangesForm form, Collection<ExamAssignmentInfo[]> changes) {
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, "Examination Assignment Changes", "examChanges.do?ord=%%", new String[]{form.getShowSections() ? "Classes / Courses" : "Examination", "Period", "Room", "Seating" + nl + "Type", "Students", "Instructor", "Direct", ">2 A Day", "Back-To-Back"}, new String[]{"left", "left", "left", "center", "right", "left", "right", "right", "right"}, new boolean[]{true, true, true, true, false, true, false, false, false});
        table.setRowStyle("white-space:nowrap");
        try {
            for (ExamAssignmentInfo[] change : changes) {
                String btbStr;
                String m2dStr;
                String dcStr;
                ExamAssignmentInfo old = change[form.getReverse() ? 1 : 0];
                ExamAssignmentInfo exam = change[form.getReverse() ? 0 : 1];
                String period = "";
                if (ToolBox.equals((Object)old.getPeriodId(), (Object)exam.getPeriodId())) {
                    period = html ? exam.getPeriodAbbreviationWithPref() : exam.getPeriodAbbreviation();
                } else if (html) {
                    period = old.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>" : old.getPeriodAbbreviationWithPref();
                    period = period + " &rarr; ";
                    period = period + (exam.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>" : exam.getPeriodAbbreviationWithPref());
                } else {
                    period = old.getPeriodId() == null ? "@@ITALIC not-assigned @END_ITALIC" : old.getPeriodAbbreviation();
                    period = period + " -> ";
                    period = period + (exam.getPeriodId() == null ? "@@ITALIC not-assigned @@END_ITALIC" : exam.getPeriodAbbreviation());
                }
                String room = "";
                if (ToolBox.equals(old.getRooms(), exam.getRooms())) {
                    room = html ? exam.getRoomsNameWithPref(", ") : exam.getRoomsName(", ");
                } else if (exam.getMaxRooms() > 0) {
                    if (html) {
                        room = room + "<table border='0'><tr><td valign='middle'>";
                        room = room + (old.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>" : old.getRoomsNameWithPref("<br>"));
                        room = room + "</td><td valign='middle'>&rarr;</td><td valign='middle'>";
                        room = room + (exam.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>" : exam.getRoomsNameWithPref("<br>"));
                        room = room + "</td></tr></table>";
                    } else {
                        room = old.getPeriodId() == null ? "@@ITALIC not-assigned @END_ITALIC" : old.getRoomsName(", ");
                        room = room + " -> ";
                        room = room + (exam.getPeriodId() == null ? "@@ITALIC not-assigned @@END_ITALIC" : exam.getRoomsName(", "));
                    }
                }
                int xdc = exam.getNrDirectConflicts();
                int dc = xdc - old.getNrDirectConflicts();
                String string = xdc <= 0 ? "" : (dcStr = html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + xdc + "</font>" : String.valueOf(xdc));
                if (html && dc < 0) {
                    dcStr = dcStr + "<font color='" + PreferenceLevel.prolog2color("R") + "'> (" + dc + ")</font>";
                }
                if (html && dc > 0) {
                    dcStr = dcStr + "<font color='" + PreferenceLevel.prolog2color("P") + "'> (+" + dc + ")</font>";
                }
                if (!html && dc < 0) {
                    dcStr = dcStr + " (" + dc + ")";
                }
                if (!html && dc > 0) {
                    dcStr = dcStr + " (+" + dc + ")";
                }
                int xm2d = exam.getNrMoreThanTwoConflicts();
                int m2d = exam.getNrMoreThanTwoConflicts() - old.getNrMoreThanTwoConflicts();
                String string2 = xm2d <= 0 ? "" : (m2dStr = html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + xm2d + "</font>" : String.valueOf(xm2d));
                if (html && m2d < 0) {
                    m2dStr = m2dStr + "<font color='" + PreferenceLevel.prolog2color("-2") + "'> (" + m2d + ")</font>";
                }
                if (html && m2d > 0) {
                    m2dStr = m2dStr + "<font color='" + PreferenceLevel.prolog2color("2") + "'> (+" + m2d + ")</font>";
                }
                if (!html && m2d < 0) {
                    m2dStr = m2dStr + " (" + m2d + ")";
                }
                if (!html && m2d > 0) {
                    m2dStr = m2dStr + " (+" + m2d + ")";
                }
                int xbtb = exam.getNrBackToBackConflicts();
                int btb = exam.getNrBackToBackConflicts() - old.getNrBackToBackConflicts();
                int dbtb = exam.getNrDistanceBackToBackConflicts() - old.getNrDistanceBackToBackConflicts();
                String string3 = xbtb <= 0 ? "" : (btbStr = html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + xbtb + "</font>" : String.valueOf(xbtb));
                if (html) {
                    if (btb < 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> (" + btb + "</font>";
                    } else if (btb > 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'> (+" + btb + "</font>";
                    } else if (dbtb != 0) {
                        btbStr = btbStr + " (" + String.valueOf(btb);
                    }
                    if (dbtb < 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> d:" + dbtb + "</font>";
                    }
                    if (dbtb > 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'> d:+" + dbtb + "</font>";
                    }
                    if (btb < 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'>)</font>";
                    } else if (btb > 0) {
                        btbStr = btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'>)</font>";
                    } else if (dbtb != 0) {
                        btbStr = btbStr + ")";
                    }
                } else {
                    if (btb < 0) {
                        btbStr = btbStr + " (" + btb;
                    } else if (btb > 0) {
                        btbStr = btbStr + " (+" + btb;
                    } else if (dbtb != 0) {
                        btbStr = btbStr + " (" + String.valueOf(btb);
                    }
                    if (dbtb < 0) {
                        btbStr = btbStr + " d:" + dbtb;
                    }
                    if (dbtb > 0) {
                        btbStr = btbStr + " d:+" + dbtb;
                    }
                    if (btb < 0) {
                        btbStr = btbStr + ")";
                    } else if (btb > 0) {
                        btbStr = btbStr + ")";
                    } else if (dbtb != 0) {
                        btbStr = btbStr + ")";
                    }
                }
                table.addLine("onClick=\"showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + exam.getExamId() + "','900','90%');\"", new String[]{(html ? "<a name='" + exam.getExamId() + "'>" : "") + (form.getShowSections() ? exam.getSectionName(nl) : exam.getExamName()) + (html ? "</a>" : ""), period, room, 0 == exam.getSeatingType() ? "Normal" : "Exam", String.valueOf(exam.getNrStudents()), exam.getInstructorName(", "), dcStr, m2dStr, btbStr}, new Comparable[]{exam, exam.getPeriodId() == null ? old.getPeriodOrd() : exam.getPeriodOrd(), exam.getPeriodId() == null ? "0" + old.getRoomsName(":") : exam.getRoomsName(":"), Integer.valueOf(exam.getSeatingType()), Integer.valueOf(exam.getNrStudents()), exam.getInstructorName(":"), Integer.valueOf(dc), Integer.valueOf(m2d), Integer.valueOf(btb)}, exam.getExamId().toString());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return table;
    }
}

