/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Email;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.form.EnrollmentAuditPdfReportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

@Service(value="/enrollmentAuditPdfReport")
public class EnrollmentAuditPdfReportAction
extends Action {
    protected static Logger sLog = Logger.getLogger(EnrollmentAuditPdfReportAction.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        EnrollmentAuditPdfReportForm myForm = (EnrollmentAuditPdfReportForm)form;
        this.sessionContext.checkPermission(Right.EnrollmentAuditPDFReports);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Generate".equals(op)) {
            myForm.save(this.sessionContext);
        }
        myForm.load(this.sessionContext);
        if ("Generate".equals(op)) {
            ActionErrors errors = myForm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("show");
            }
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            try {
                block35: {
                    myForm.setReport("");
                    Hashtable<String, File> output = new Hashtable<String, File>();
                    for (int i = 0; i < myForm.getReports().length; ++i) {
                        myForm.log("Generating " + myForm.getReports()[i] + "...");
                        Class reportClass = EnrollmentAuditPdfReportForm.sRegisteredReports.get(myForm.getReports()[i]);
                        String reportName = null;
                        for (Map.Entry<String, Class> entry : PdfEnrollmentAuditReport.sRegisteredReports.entrySet()) {
                            if (!entry.getValue().equals(reportClass)) continue;
                            reportName = entry.getKey();
                        }
                        if (reportName == null) {
                            reportName = "r" + (i + 1);
                        }
                        String name = session.getAcademicTerm() + session.getSessionStartYear() + "_" + reportName;
                        if (myForm.getAll()) {
                            File file = ApplicationProperties.getTempFile(name, myForm.getModeIdx() == 2 ? "txt" : "pdf");
                            myForm.log("&nbsp;&nbsp;Writing <a href='temp/" + file.getName() + "'>" + reportName + "." + (myForm.getModeIdx() == 2 ? "txt" : "pdf") + "</a>");
                            PdfEnrollmentAuditReport report = (PdfEnrollmentAuditReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class).newInstance(myForm.getModeIdx(), file, session);
                            report.setShowId(myForm.getExternalId());
                            report.setShowName(myForm.getStudentName());
                            report.printReport();
                            report.close();
                            output.put(reportName + "." + (myForm.getModeIdx() == 2 ? "txt" : "pdf"), file);
                            continue;
                        }
                        TreeSet<SubjectArea> treeSet = new TreeSet<SubjectArea>();
                        String subjAbbvs = "";
                        for (int j = 0; j < myForm.getSubjects().length; ++j) {
                            SubjectArea subject = (SubjectArea)new SubjectAreaDAO().get(Long.valueOf(myForm.getSubjects()[j]));
                            if (subjAbbvs.length() == 0) {
                                subjAbbvs = subject.getSubjectAreaAbbreviation();
                            } else if (subjAbbvs.length() < 40) {
                                subjAbbvs = subjAbbvs + "_" + subject.getSubjectAreaAbbreviation();
                            } else if (subjAbbvs.charAt(subjAbbvs.length() - 1) != '.') {
                                subjAbbvs = subjAbbvs + "_...";
                            }
                            treeSet.add(subject);
                        }
                        File file = ApplicationProperties.getTempFile(name + subjAbbvs, myForm.getModeIdx() == 2 ? "txt" : "pdf");
                        myForm.log("&nbsp;&nbsp;Writing <a href='temp/" + file.getName() + "'>" + subjAbbvs + "_" + reportName + "." + (myForm.getModeIdx() == 2 ? "txt" : "pdf") + "</a>");
                        PdfEnrollmentAuditReport report = (PdfEnrollmentAuditReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class, TreeSet.class, String.class).newInstance(myForm.getModeIdx(), file, session, treeSet, subjAbbvs);
                        report.setShowId(myForm.getExternalId());
                        report.setShowName(myForm.getStudentName());
                        report.printReport();
                        report.close();
                        output.put(subjAbbvs + "_" + reportName + "." + (myForm.getModeIdx() == 2 ? "txt" : "pdf"), file);
                    }
                    byte[] buffer = new byte[32768];
                    int len = 0;
                    if (output.isEmpty()) {
                        myForm.log("<font color='orange'>No report generated.</font>");
                    } else if (myForm.getEmail()) {
                        myForm.log("Sending email(s)...");
                        try {
                            Object s;
                            Email mail = Email.createEmail();
                            mail.setSubject(myForm.getSubject() == null ? "Enrollment Audit Report" : myForm.getSubject());
                            mail.setText((myForm.getMessage() == null ? "" : myForm.getMessage() + "\r\n\r\n") + "For an up-to-date report, please visit " + request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/\r\n\r\nThis email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                            if (myForm.getAddress() != null) {
                                s = new StringTokenizer(myForm.getAddress(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipient(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            if (myForm.getCc() != null) {
                                s = new StringTokenizer(myForm.getCc(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            if (myForm.getBcc() != null) {
                                s = new StringTokenizer(myForm.getBcc(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            for (Map.Entry entry : output.entrySet()) {
                                mail.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getSessionStartYear() + "_" + (String)entry.getKey());
                            }
                            mail.send();
                            myForm.log("Email sent.");
                        }
                        catch (Exception e) {
                            myForm.log("<font color='red'>Unable to send email: " + e.getMessage() + "</font>");
                        }
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    if (output.size() == 1) {
                        request.setAttribute("RqOpenUrl", (Object)("temp/" + ((File)output.elements().nextElement()).getName()));
                    } else {
                        FileInputStream fis = null;
                        ZipOutputStream zip = null;
                        try {
                            File file = ApplicationProperties.getTempFile(session.getAcademicTerm() + session.getSessionStartYear(), "zip");
                            myForm.log("Writing <a href='temp/" + file.getName() + "'>" + session.getAcademicTerm() + session.getSessionStartYear() + ".zip</a>...");
                            zip = new ZipOutputStream(new FileOutputStream(file));
                            for (Map.Entry entry : output.entrySet()) {
                                zip.putNextEntry(new ZipEntry((String)entry.getKey()));
                                fis = new FileInputStream((File)entry.getValue());
                                while ((len = fis.read(buffer)) > 0) {
                                    zip.write(buffer, 0, len);
                                }
                                fis.close();
                                fis = null;
                                zip.closeEntry();
                            }
                            zip.flush();
                            zip.close();
                            request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                        }
                        catch (IOException iOException) {
                            if (fis != null) {
                                fis.close();
                            }
                            if (zip == null) break block35;
                            zip.close();
                        }
                    }
                }
                myForm.log("All done.");
            }
            catch (Exception e) {
                myForm.log("<font color='red'>Process failed: " + e.getMessage() + " (exception " + e.getClass().getName() + ")</font>");
                sLog.error((Object)e.getMessage(), (Throwable)e);
                errors.add("report", new ActionMessage("errors.generic", (Object)("Unable to generate report, reason: " + e.getMessage())));
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        return mapping.findForward("show");
    }

    public static class FileGenerator
    implements InstructorExamReport.FileGenerator {
        String iName;

        public FileGenerator(String name) {
            this.iName = name;
        }

        @Override
        public File generate(String prefix, String ext) {
            return ApplicationProperties.getTempFile(this.iName + "_" + prefix, ext);
        }
    }
}

