/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.form.DistributionTypeEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/distributionTypeEdit")
public class DistributionTypeEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors;
        DistributionTypeEditForm myForm = (DistributionTypeEditForm)form;
        this.sessionContext.checkPermission(Right.DistributionTypeEdit);
        String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        if (op == null) {
            Long id = new Long(Long.parseLong(request.getParameter("id")));
            myForm.setRefTableEntry((RefTableEntry)new DistributionTypeDAO().get(id), sessionId);
        }
        if (request.getParameterValues("depts") != null) {
            String[] depts = request.getParameterValues("depts");
            for (int i = 0; i < depts.length; ++i) {
                myForm.getDepartmentIds().add(new Long(depts[i]));
            }
        }
        List list = new DepartmentDAO().getSession().createCriteria(Department.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).addOrder(Order.asc((String)"deptCode")).list();
        Vector<LabelValueBean> availableDepts = new Vector<LabelValueBean>();
        for (Department d : list) {
            availableDepts.add(new LabelValueBean(d.getDeptCode() + "-" + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        if ("Save".equals(op)) {
            DistributionTypeDAO dao = new DistributionTypeDAO();
            Transaction tx = null;
            try {
                Session hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                DistributionType distType = (DistributionType)dao.get(myForm.getUniqueId());
                DistributionType x = (DistributionType)myForm.getRefTableEntry();
                distType.setAbbreviation(x.getAbbreviation());
                distType.setAllowedPref(x.getAllowedPref());
                distType.setDescr(x.getDescr());
                distType.setInstructorPref(x.isInstructorPref() == null ? Boolean.FALSE : x.isInstructorPref());
                distType.setLabel(x.getLabel());
                distType.setVisible(x.isVisible() == null ? Boolean.FALSE : x.isVisible());
                HashSet<Department> oldDepts = new HashSet<Department>(distType.getDepartments());
                Enumeration e = myForm.getDepartmentIds().elements();
                while (e.hasMoreElements()) {
                    Long departmentId = (Long)e.nextElement();
                    Department d = (Department)new DepartmentDAO().get(departmentId, hibSession);
                    if (d == null || oldDepts.remove(d)) continue;
                    distType.getDepartments().add(d);
                }
                for (Department d : oldDepts) {
                    if (!d.getSessionId().equals(sessionId)) continue;
                    distType.getDepartments().remove(d);
                }
                hibSession.saveOrUpdate((Object)distType);
                ChangeLog.addChange(hibSession, this.sessionContext, distType, ChangeLog.Source.DIST_TYPE_EDIT, ChangeLog.Operation.UPDATE, null, null);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            return mapping.findForward("showDistributionTypeList");
        }
        if ("Back".equals(op)) {
            return mapping.findForward("showDistributionTypeList");
        }
        if ("Add Department".equals(op)) {
            errors = new ActionErrors();
            if (myForm.getDepartmentId() == null || myForm.getDepartmentId() < 0L) {
                errors.add("department", new ActionMessage("errors.generic", (Object)"No department selected."));
            } else {
                boolean contains = myForm.getDepartmentIds().contains(myForm.getDepartmentId());
                if (contains) {
                    errors.add("department", new ActionMessage("errors.generic", (Object)"Department already present in the list of departments."));
                }
            }
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                myForm.getDepartmentIds().add(myForm.getDepartmentId());
            }
        }
        if ("Remove Department".equals(op)) {
            errors = new ActionErrors();
            if (myForm.getDepartmentId() == null || myForm.getDepartmentId() < 0L) {
                errors.add("department", new ActionMessage("errors.generic", (Object)"No department selected."));
            } else {
                boolean contains = myForm.getDepartmentIds().contains(myForm.getDepartmentId());
                if (!contains) {
                    errors.add("department", new ActionMessage("errors.generic", (Object)"Department not present in the list of departments."));
                }
            }
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                myForm.getDepartmentIds().remove(myForm.getDepartmentId());
            }
        }
        return mapping.findForward("showEdit");
    }
}

