/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.form.BuildingEditForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/buildingEdit")
public class BuildingEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String op;
            BuildingEditForm myForm = (BuildingEditForm)form;
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (op == null) {
                myForm.reset(mapping, request);
                myForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
                myForm.setOp("Save");
            }
            if ("Back".equals(op)) {
                return mapping.findForward("back");
            }
            if ("Add".equals(op)) {
                myForm.setOp("Save");
            }
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                    mapping.findForward("Save".equals(op) ? "add" : "edit");
                } else {
                    if ("Save".equals(op)) {
                        this.sessionContext.checkPermission(Right.BuildingAdd);
                    } else {
                        this.sessionContext.checkPermission(myForm.getUniqueId(), "Building", Right.BuildingEdit);
                    }
                    Transaction tx = null;
                    try {
                        org.hibernate.Session hibSession = new BuildingDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        this.saveOrUpdate(myForm, hibSession);
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                    return mapping.findForward("back");
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("externalId", new ActionMessage("errors.invalid", (Object)id));
                    this.saveErrors(request, errors);
                    return mapping.findForward("edit");
                }
                Building b = (Building)new BuildingDAO().get(Long.valueOf(id));
                if (b == null) {
                    return mapping.findForward("back");
                }
                this.sessionContext.checkPermission(b, Right.BuildingEdit);
                myForm.load(b);
            }
            if ("Delete".equals(op)) {
                this.sessionContext.checkPermission(myForm.getUniqueId(), "Building", Right.BuildingDelete);
                Transaction tx = null;
                try {
                    org.hibernate.Session hibSession = new BuildingDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    this.delete(myForm, hibSession);
                    tx.commit();
                    HibernateUtil.clearCache();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return mapping.findForward("back");
            }
            if ("Export PDF".equals(op)) {
                DecimalFormat df5 = new DecimalFormat("####0.######");
                PdfWebTable table = new PdfWebTable(5, "Buildings", null, new String[]{"Abbreviation", "Name", "External ID", "X-Coordinate", "Y-Coordinate"}, new String[]{"left", "left", "left", "right", "right"}, new boolean[]{true, true, true, true, true});
                for (Building b : Building.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                    table.addLine(null, new String[]{b.getAbbreviation(), b.getName(), b.getExternalUniqueId() == null ? "@@ITALIC N/A @@END_ITALIC " : b.getExternalUniqueId().toString(), b.getCoordinateX() == null ? "" : df5.format(b.getCoordinateX()), b.getCoordinateY() == null ? "" : df5.format(b.getCoordinateY())}, new Comparable[]{b.getAbbreviation(), b.getName(), b.getExternalUniqueId() == null ? "" : b.getExternalUniqueId(), b.getCoordinateX(), b.getCoordinateY()});
                }
                ExportUtils.exportPDF(table, PdfWebTable.getOrder(this.sessionContext, "BuildingList.ord"), response, "buildings");
                return null;
            }
            if ("Update Data".equals(op)) {
                this.sessionContext.checkPermission(Right.BuildingUpdateData);
                Room.addNewExternalRoomsToSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
                return mapping.findForward("back");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    public void saveOrUpdate(BuildingEditForm form, org.hibernate.Session hibSession) throws Exception {
        Building building = null;
        if (form.getUniqueId() != null) {
            building = (Building)BuildingDAO.getInstance().get(form.getUniqueId());
        }
        if (building == null) {
            building = new Building();
            building.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession));
        }
        building.setName(form.getName());
        building.setAbbreviation(form.getAbbreviation());
        building.setExternalUniqueId((String)(form.getExternalId() != null && form.getExternalId().length() == 0 ? null : form.getExternalId()));
        building.setCoordinateX(form.getCoordX() == null || form.getCoordX().length() == 0 ? null : Double.valueOf(form.getCoordX()));
        building.setCoordinateY(form.getCoordY() == null || form.getCoordY().length() == 0 ? null : Double.valueOf(form.getCoordY()));
        hibSession.saveOrUpdate((Object)building);
        ChangeLog.addChange(hibSession, this.sessionContext, building, ChangeLog.Source.BUILDING_EDIT, form.getUniqueId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
        if (Boolean.TRUE.equals(form.getUpdateRoomCoordinates()) && form.getUniqueId() != null) {
            for (Room room : hibSession.createQuery("from Room r where r.building.uniqueId = :buildingId").setLong("buildingId", building.getUniqueId().longValue()).list()) {
                if (ToolBox.equals((Object)room.getCoordinateX(), (Object)building.getCoordinateX()) && ToolBox.equals((Object)room.getCoordinateY(), (Object)building.getCoordinateY())) continue;
                room.setCoordinateX(building.getCoordinateX());
                room.setCoordinateY(building.getCoordinateY());
                hibSession.update((Object)room);
                ChangeLog.addChange(hibSession, this.sessionContext, room, room.getLabel() + " moved to " + room.getCoordinateX() + "," + room.getCoordinateY(), ChangeLog.Source.BUILDING_EDIT, ChangeLog.Operation.UPDATE, null, null);
            }
        }
    }

    public void delete(BuildingEditForm form, org.hibernate.Session hibSession) {
        Building building = (Building)BuildingDAO.getInstance().get(form.getUniqueId());
        if (building != null) {
            Iterator i = hibSession.createQuery("select r from Room r where r.building.uniqueId=:buildingId").setLong("buildingId", form.getUniqueId().longValue()).iterate();
            while (i.hasNext()) {
                Room r = (Room)i.next();
                hibSession.createQuery("delete RoomPref p where p.room.uniqueId=:roomId").setLong("roomId", r.getUniqueId().longValue()).executeUpdate();
                Iterator<Assignment> j = r.getAssignments().iterator();
                while (j.hasNext()) {
                    Assignment a = j.next();
                    a.getRooms().remove(r);
                    hibSession.saveOrUpdate((Object)a);
                    j.remove();
                }
                hibSession.delete((Object)r);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, building, ChangeLog.Source.BUILDING_EDIT, ChangeLog.Operation.DELETE, null, null);
            hibSession.delete((Object)building);
        }
    }
}

