/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ApplicationConfigForm;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SessionConfig;
import org.unitime.timetable.model.base.BaseApplicationConfig;
import org.unitime.timetable.model.base.BaseSessionConfig;
import org.unitime.timetable.model.dao.ApplicationConfigDAO;
import org.unitime.timetable.model.dao.SessionConfigDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="/applicationConfig")
public class ApplicationConfigAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oldValue;
        org.hibernate.Session hibSession;
        ApplicationConfig appConfig;
        SessionConfig sessionConfig;
        String op;
        this.sessionContext.checkPermission(Right.ApplicationConfig);
        ApplicationConfigForm frm = (ApplicationConfigForm)form;
        MessageResources rsc = this.getResources(request);
        String string = op = frm.getOp() != null ? frm.getOp() : request.getParameter("op");
        if (op == null) {
            frm.reset(mapping, request);
            op = frm.getOp();
        }
        if ("1".equals(request.getParameter("apply"))) {
            this.sessionContext.getUser().setProperty("ApplicationConfig.showAll", frm.getShowAll() ? "1" : "0");
        }
        ActionMessages errors = new ActionMessages();
        if (op.equals("edit")) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            String id = request.getParameter("id");
            if (id == null || id.trim().isEmpty()) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Name : " + id)));
                this.saveErrors(request, errors);
            } else {
                sessionConfig = SessionConfig.getConfig(id, this.sessionContext.getUser().getCurrentAcademicSessionId());
                if (sessionConfig == null) {
                    appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(id);
                    if (appConfig == null) {
                        ApplicationProperty p = ApplicationProperty.fromKey(id);
                        if (p != null) {
                            frm.setOp("add");
                            frm.setKey(id);
                            frm.setValue(ApplicationProperties.getProperty(id, ""));
                            frm.setDescription(p.description());
                            frm.setAllSessions(true);
                        } else {
                            errors.add("key", new ActionMessage("errors.invalid", (Object)("Name : " + id)));
                            this.saveErrors(request, errors);
                        }
                    } else {
                        frm.setKey(appConfig.getKey());
                        frm.setValue(appConfig.getValue());
                        frm.setDescription(appConfig.getDescription());
                        if (frm.getDescription() == null || frm.getDescription().isEmpty()) {
                            frm.setDescription(ApplicationProperty.getDescription(frm.getKey()));
                        }
                        frm.setAllSessions(true);
                    }
                } else {
                    ApplicationConfig appConfig2;
                    frm.setKey(sessionConfig.getKey());
                    frm.setValue(sessionConfig.getValue());
                    frm.setDescription(sessionConfig.getDescription());
                    if (frm.getDescription() == null || frm.getDescription().isEmpty()) {
                        frm.setDescription(ApplicationProperty.getDescription(frm.getKey()));
                    }
                    frm.setAllSessions(false);
                    List sessionIds = SessionConfigDAO.getInstance().getSession().createQuery("select session.uniqueId from SessionConfig where key = :key and value = :value").setString("key", id).setString("value", sessionConfig.getValue()).list();
                    Long[] sessionIdsArry = new Long[sessionIds.size()];
                    for (int i = 0; i < sessionIds.size(); ++i) {
                        sessionIdsArry[i] = (Long)sessionIds.get(i);
                    }
                    frm.setSessions(sessionIdsArry);
                    if ((sessionConfig.getDescription() == null || sessionConfig.getDescription().isEmpty()) && (appConfig2 = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(id)) != null) {
                        frm.setDescription(appConfig2.getDescription());
                    }
                }
            }
        }
        if (op.equals(rsc.getMessage("button.addAppConfig"))) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            frm.reset(mapping, request);
            frm.setAllSessions(true);
            if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
                frm.setSessions(new Long[]{this.sessionContext.getUser().getCurrentAcademicSessionId()});
            }
            frm.setOp(rsc.getMessage("button.createAppConfig"));
        }
        if (op.equals(rsc.getMessage("button.updateAppConfig")) || op.equals(rsc.getMessage("button.createAppConfig"))) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, errors);
            } else {
                try {
                    Serializable config;
                    hibSession = SessionConfigDAO.getInstance().getSession();
                    boolean update = op.equals(rsc.getMessage("button.updateAppConfig"));
                    oldValue = null;
                    boolean wasSession = false;
                    SessionConfig sessionConfig2 = SessionConfig.getConfig(frm.getKey(), this.sessionContext.getUser().getCurrentAcademicSessionId());
                    if (sessionConfig2 == null) {
                        ApplicationConfig appConfig3 = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(frm.getKey());
                        if (appConfig3 != null) {
                            oldValue = appConfig3.getValue();
                        }
                    } else {
                        oldValue = sessionConfig2.getValue();
                        wasSession = true;
                    }
                    if (frm.isAllSessions()) {
                        if (wasSession) {
                            if (update) {
                                for (SessionConfig config2 : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", frm.getKey()).setString("value", oldValue).list()) {
                                    this.solverServerService.setApplicationProperty(config2.getSession().getUniqueId(), frm.getKey(), null);
                                    hibSession.delete((Object)config2);
                                }
                            } else {
                                config = SessionConfig.getConfig(frm.getKey(), this.sessionContext.getUser().getCurrentAcademicSessionId());
                                if (config != null) {
                                    this.solverServerService.setApplicationProperty(((BaseSessionConfig)config).getSession().getUniqueId(), frm.getKey(), null);
                                    hibSession.delete((Object)config);
                                }
                            }
                        }
                        if ((config = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(frm.getKey())) == null) {
                            config = new ApplicationConfig();
                            ((BaseApplicationConfig)config).setKey(frm.getKey());
                        }
                        ((BaseApplicationConfig)config).setValue(frm.getValue());
                        ((BaseApplicationConfig)config).setDescription(frm.getDescription());
                        this.solverServerService.setApplicationProperty(null, frm.getKey(), frm.getValue());
                        hibSession.saveOrUpdate((Object)config);
                    } else {
                        if (update && !wasSession && (config = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(frm.getKey())) != null) {
                            this.solverServerService.setApplicationProperty(null, frm.getKey(), null);
                            hibSession.delete((Object)config);
                        }
                        HashSet<Long> updatedSessionIds = new HashSet<Long>();
                        for (Long sessionId : frm.getSessions()) {
                            SessionConfig config3 = (SessionConfig)hibSession.createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("key", frm.getKey()).uniqueResult();
                            if (config3 == null) {
                                config3 = new SessionConfig();
                                config3.setKey(frm.getKey());
                                config3.setSession((Session)SessionDAO.getInstance().get(sessionId, hibSession));
                            }
                            config3.setValue(frm.getValue());
                            config3.setDescription(frm.getDescription());
                            this.solverServerService.setApplicationProperty(sessionId, frm.getKey(), frm.getValue());
                            hibSession.saveOrUpdate((Object)config3);
                            updatedSessionIds.add(sessionId);
                        }
                        if (update && oldValue != null) {
                            for (SessionConfig other : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", frm.getKey()).setString("value", oldValue).list()) {
                                if (updatedSessionIds.contains(other.getSession().getUniqueId())) continue;
                                this.solverServerService.setApplicationProperty(other.getSession().getUniqueId(), frm.getKey(), null);
                                hibSession.delete((Object)other);
                            }
                        }
                    }
                    hibSession.flush();
                    request.setAttribute("hash", (Object)frm.getKey());
                    frm.reset(mapping, request);
                }
                catch (Exception e) {
                    errors.add("key", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    this.saveErrors(request, errors);
                }
            }
        }
        if (op.equals(rsc.getMessage("button.deleteAppConfig"))) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, errors);
            } else {
                try {
                    hibSession = SessionConfigDAO.getInstance().getSession();
                    sessionConfig = null;
                    if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
                        sessionConfig = (SessionConfig)hibSession.createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("key", frm.getKey()).uniqueResult();
                    }
                    if (sessionConfig == null) {
                        appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(frm.getKey());
                        if (appConfig != null) {
                            hibSession.delete((Object)appConfig);
                            this.solverServerService.setApplicationProperty(null, frm.getKey(), null);
                        }
                    } else {
                        oldValue = sessionConfig.getValue();
                        hibSession.delete((Object)sessionConfig);
                        this.solverServerService.setApplicationProperty(this.sessionContext.getUser().getCurrentAcademicSessionId(), frm.getKey(), null);
                        for (SessionConfig other : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", frm.getKey()).setString("value", oldValue).list()) {
                            this.solverServerService.setApplicationProperty(other.getSession().getUniqueId(), frm.getKey(), null);
                            hibSession.delete((Object)other);
                        }
                    }
                    hibSession.flush();
                    frm.reset(mapping, request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.add("key", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    this.saveErrors(request, errors);
                }
            }
        }
        if (op.equals(rsc.getMessage("button.cancelUpdateAppConfig"))) {
            request.setAttribute("hash", (Object)frm.getKey());
            frm.reset(mapping, request);
        }
        frm.setShowAll("1".equals(this.sessionContext.getUser().getProperty("ApplicationConfig.showAll", "0")));
        if ("list".equals(frm.getOp())) {
            this.getApplicationConfigList(request, frm.getShowAll());
            return mapping.findForward("list");
        }
        return mapping.findForward(rsc.getMessage("button.createAppConfig").equals(frm.getOp()) ? "add" : "edit");
    }

    private void getApplicationConfigList(HttpServletRequest request, boolean showAll) throws Exception {
        WebTable.setOrder(this.sessionContext, "applicationConfig.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(4, null, "applicationConfig.do?ord=%%", new String[]{"Name", "Value", "Description"}, new String[]{"left", "left", "left"}, null);
        webTable.enableHR("#9CB0CE");
        HashMap<String, Serializable> configs = new HashMap<String, Serializable>();
        for (Object config : ApplicationConfigDAO.getInstance().findAll()) {
            configs.put(((BaseApplicationConfig)config).getKey(), (Serializable)config);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : ApplicationProperties.getProperties().entrySet()) {
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (properties.containsKey(property.key()) || property.isSecret() || property.isDeprecated()) continue;
            if (property.reference() == null) {
                properties.put(property.key(), property.defaultValue() == null ? "" : property.defaultValue());
                continue;
            }
            boolean nomatch = true;
            for (Object key : properties.keySet()) {
                if (!property.matches(key.toString())) continue;
                nomatch = false;
                break;
            }
            if (!nomatch) continue;
            properties.put(property.key(), property.defaultValue() == null ? "" : property.defaultValue());
        }
        if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
            for (SessionConfig sessionConfig : SessionConfig.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                configs.put(sessionConfig.getKey(), sessionConfig);
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(ApplicationProperty.ApplicationConfigPattern.value());
        }
        catch (Exception exception) {
            pattern = Pattern.compile(ApplicationProperty.ApplicationConfigPattern.defaultValue());
        }
        boolean bl = this.sessionContext.hasPermission(Right.ApplicationConfigEdit);
        if (properties.isEmpty()) {
            webTable.addLine(null, new String[]{"No configuration keys found"}, null, null);
        } else {
            for (String key : new TreeSet(properties.keySet())) {
                Serializable config;
                String value = (String)properties.get(key);
                Object o = configs.get(key);
                ApplicationProperty p = ApplicationProperty.fromKey(key);
                String description = ApplicationProperty.getDescription(key);
                if (description == null) {
                    description = "";
                }
                if (o == null) {
                    if (!pattern.matcher(key).matches() || !showAll && p != null && (value == null ? "" : value).equals(p.value() == null ? "" : p.value())) continue;
                    String reference = null;
                    if (p != null && p.reference() != null) {
                        reference = p.reference();
                    }
                    if (p != null && p.isSecret()) continue;
                    webTable.addLine(bl && p != null && !p.isReadOnly() ? "onClick=\"document.location='applicationConfig.do?op=edit&id=" + (reference == null ? key : key.replace("%", "<" + reference + ">")) + "';\"" : null, new String[]{"<a name='" + (reference == null ? key : key.replace("%", "<" + reference + ">")) + "'>" + (reference == null ? HtmlUtils.htmlEscape((String)key) : HtmlUtils.htmlEscape((String)key).replace("%", "<i><u>" + reference + "</i></u>")) + "</a>", "<font color='gray'>" + HtmlUtils.htmlEscape((String)value) + "</font>", reference == null ? description : description.replace("%", "<i><u>" + reference + "</i></u>")}, (Comparable[])new String[]{key, value, description});
                    continue;
                }
                if (o instanceof SessionConfig) {
                    config = (SessionConfig)o;
                    if (((BaseSessionConfig)config).getDescription() != null && !((BaseSessionConfig)config).getDescription().isEmpty()) {
                        description = ((BaseSessionConfig)config).getDescription();
                    }
                    webTable.addLine(bl && (p == null || !p.isReadOnly()) ? "onClick=\"document.location='applicationConfig.do?op=edit&id=" + key + "';\"" : null, new String[]{"<a name='" + key + "'>" + HtmlUtils.htmlEscape((String)key) + " <sup><font color='#2066CE' title='Applies to " + ((BaseSessionConfig)config).getSession().getLabel() + "'>s)</font></sup></a>", HtmlUtils.htmlEscape((String)value), description}, (Comparable[])new String[]{key, value, description});
                    continue;
                }
                config = (ApplicationConfig)o;
                if (((BaseApplicationConfig)config).getDescription() != null && !((BaseApplicationConfig)config).getDescription().isEmpty()) {
                    description = ((BaseApplicationConfig)config).getDescription();
                }
                webTable.addLine(bl && (p == null || !p.isReadOnly()) ? "onClick=\"document.location='applicationConfig.do?op=edit&id=" + key + "';\"" : null, new String[]{"<a name='" + key + "'>" + HtmlUtils.htmlEscape((String)key) + "</a>", HtmlUtils.htmlEscape((String)value), description}, (Comparable[])new String[]{key, value, description});
            }
        }
        request.setAttribute("appConfig", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "applicationConfig.ord")));
    }
}

