/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.SpecialUseRoomForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LocationPermIdGenerator;

@Service(value="/addSpecialUseRoom")
public class AddSpecialUseRoomAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SpecialUseRoomForm specialUseRoomForm = (SpecialUseRoomForm)form;
        MessageResources rsc = this.getResources(request);
        ActionMessages errors = new ActionMessages();
        this.sessionContext.checkPermission(Right.AddSpecialUseRoom);
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        List<Building> buildings = Building.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (specialUseRoomForm.getDoit() != null) {
            String doit = specialUseRoomForm.getDoit();
            if (doit.equals(rsc.getMessage("button.returnToRoomList"))) {
                return mapping.findForward("showRoomList");
            }
            if (doit.equals(rsc.getMessage("button.addNew"))) {
                errors = specialUseRoomForm.validate(mapping, request);
                if (errors.isEmpty()) {
                    String forward = this.update(request, specialUseRoomForm);
                    if (forward != null) {
                        return mapping.findForward(forward);
                    }
                } else {
                    this.saveErrors(request, errors);
                }
            }
        }
        this.setup(request, departments, buildings);
        specialUseRoomForm.setDeptSize(departments.size());
        if (departments.size() == 1) {
            Department d = (Department)departments.iterator().next();
            specialUseRoomForm.setDeptCode(d.getDeptCode());
        } else if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null) {
            specialUseRoomForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        return mapping.findForward("showAdd");
    }

    private void setup(HttpServletRequest request, Set<Department> departments, List<Building> buildings) throws Exception {
        ArrayList<LabelValueBean> deptList = new ArrayList<LabelValueBean>();
        for (Department d : departments) {
            String code = d.getDeptCode().trim();
            String abbv = d.getName().trim();
            deptList.add(new LabelValueBean(code + " - " + abbv, code));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, deptList);
        ArrayList<LabelValueBean> bldgList = new ArrayList<LabelValueBean>();
        for (Building b : buildings) {
            bldgList.add(new LabelValueBean(b.getAbbreviation() + "-" + b.getName(), b.getUniqueId() + "-" + b.getAbbreviation()));
        }
        request.setAttribute(Building.BLDG_LIST_ATTR_NAME, bldgList);
    }

    private String update(HttpServletRequest request, SpecialUseRoomForm specialUseRoomForm) throws Exception {
        ActionMessages errors = new ActionMessages();
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Long bldgUniqueId = Long.valueOf(specialUseRoomForm.getBldgId().split("-")[0]);
        String bldgAbbv = specialUseRoomForm.getBldgId().split("-")[1];
        String roomNum = specialUseRoomForm.getRoomNum().trim();
        Room existingRoom = Room.findByBldgIdRoomNbr(bldgUniqueId, roomNum, sessionId);
        if (existingRoom != null) {
            errors.add("specialUseRoom", new ActionMessage("errors.exists", (Object)"Room "));
            this.saveErrors(request, errors);
            return null;
        }
        ExternalBuilding extBldg = ExternalBuilding.findByAbbv(sessionId, bldgAbbv);
        ExternalRoom extRoom = null;
        if (extBldg != null) {
            extRoom = extBldg.findRoom(roomNum);
        }
        if (extRoom == null) {
            errors.add("specialUseRoom", new ActionMessage("errors.invalid", (Object)"Room number "));
            this.saveErrors(request, errors);
            return null;
        }
        if (!this.sessionContext.hasPermission(extRoom, Right.AddSpecialUseRoomExternalRoom)) {
            errors.add("specialUseRoom", new ActionMessage("errors.room.ownership"));
            this.saveErrors(request, errors);
            return null;
        }
        org.hibernate.Session hibSession = new RoomDAO().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Room room = new Room();
            room.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession));
            room.setIgnoreTooFar(Boolean.FALSE);
            room.setIgnoreRoomCheck(Boolean.FALSE);
            room.setCoordinateX(extRoom.getCoordinateX());
            room.setCoordinateY(extRoom.getCoordinateY());
            room.setArea(extRoom.getArea());
            room.setCapacity(extRoom.getCapacity());
            room.setExamCapacity(0);
            room.setRoomNumber(roomNum);
            room.setRoomType(extRoom.getRoomType());
            room.setExternalUniqueId(extRoom.getExternalUniqueId());
            room.setClassification(extRoom.getClassification());
            room.setDisplayName(extRoom.getDisplayName());
            BuildingDAO bldgDAO = new BuildingDAO();
            Building bldg = (Building)bldgDAO.get(Long.valueOf(bldgUniqueId));
            room.setBuildingAbbv(bldgAbbv);
            room.setBuilding(bldg);
            room.setFeatures(new HashSet<RoomFeature>());
            room.setAssignments(new HashSet<Assignment>());
            room.setRoomGroups(new HashSet<RoomGroup>());
            room.setRoomDepts(new HashSet<RoomDept>());
            LocationPermIdGenerator.setPermanentId(room);
            hibSession.saveOrUpdate((Object)room);
            Set<ExternalRoomFeature> extRoomFeatures = extRoom.getRoomFeatures();
            if (!extRoomFeatures.isEmpty()) {
                this.addRoomFeatures(extRoomFeatures, room, hibSession);
                hibSession.saveOrUpdate((Object)room);
            }
            Department dept = null;
            if (specialUseRoomForm.getDeptCode() != null && specialUseRoomForm.getDeptCode().length() > 0) {
                String deptSelected = specialUseRoomForm.getDeptCode();
                RoomDept roomdept = new RoomDept();
                roomdept.setRoom(room);
                roomdept.setControl(Boolean.TRUE);
                dept = Department.findByDeptCode(deptSelected, sessionId);
                roomdept.setDepartment(dept);
                hibSession.saveOrUpdate((Object)roomdept);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, room, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.CREATE, null, dept);
            tx.commit();
            if (dept != null) {
                hibSession.refresh(dept);
            }
            hibSession.refresh((Object)room);
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        return "showRoomList";
    }

    private void addRoomFeatures(Set extRoomFeatures, Room room, org.hibernate.Session hibSession) {
        Set<RoomFeature> roomFeatures = room.getFeatures();
        Iterator f = extRoomFeatures.iterator();
        List<GlobalRoomFeature> globalRoomFeatures = RoomFeature.getAllGlobalRoomFeatures(room.getSession());
        block0: while (f.hasNext()) {
            ExternalRoomFeature extRoomFeature = (ExternalRoomFeature)f.next();
            String featureValue = extRoomFeature.getValue();
            for (RoomFeature roomFeature : globalRoomFeatures) {
                if (!roomFeature.getLabel().equalsIgnoreCase(featureValue)) continue;
                roomFeature.getRooms().add(room);
                hibSession.save((Object)roomFeature);
                roomFeatures.add(roomFeature);
                continue block0;
            }
        }
        room.setFeatures(roomFeatures);
    }
}

