/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import biweekly.component.VTimezone;
import biweekly.io.TimezoneInfo;
import biweekly.io.VTimezoneGenerator;
import biweekly.io.text.ICalReader;
import biweekly.property.TimezoneId;
import biweekly.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.unitime.timetable.defaults.ApplicationProperty;

public class CalendarVTimeZoneGenerator
implements VTimezoneGenerator {
    private static final Map<URI, VTimezone> cache = Collections.synchronizedMap(new HashMap());

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VTimezone generate(TimeZone timezone) throws IllegalArgumentException {
        VTimezone vTimezone;
        URI uri;
        try {
            String tz = ApplicationProperty.CalendarVTimeZoneID.value(timezone.getID());
            uri = tz != null ? new URI(tz) : new URI(ApplicationProperty.CalendarVTimeZone.value().replace("{id}", timezone.getID()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        VTimezone component = cache.get(uri);
        if (component != null) {
            return component;
        }
        ICalReader reader = null;
        try {
            reader = new ICalReader(uri.toURL().openStream());
            reader.readNext();
            TimezoneInfo tzinfo = reader.getTimezoneInfo();
            component = tzinfo.getComponents().iterator().next();
            TimezoneId componentId = component.getTimezoneId();
            if (componentId == null) {
                component.setTimezoneId(timezone.getID());
            } else if (!timezone.getID().equals(componentId.getValue())) {
                componentId.setValue(timezone.getID());
            }
            cache.put(uri, component);
            vTimezone = component;
        }
        catch (FileNotFoundException e) {
            try {
                throw this.notFound(e, timezone);
                catch (NoSuchElementException e2) {
                    throw this.notFound(e2, timezone);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return vTimezone;
    }

    private IllegalArgumentException notFound(Exception e, TimeZone timezone) {
        return new IllegalArgumentException("Timezone " + timezone.getID() + " not recognized.", e);
    }
}

