/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentPreferencePenalties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLLoader;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceOrder;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineConfig;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSection;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.AvoidUnbalancedWhenNoExpectations;
import org.cpsolver.studentsct.online.expectations.FractionallyOverExpected;
import org.cpsolver.studentsct.online.expectations.FractionallyUnbalancedWhenNoExpectations;
import org.cpsolver.studentsct.online.expectations.PercentageOverExpected;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSuggestions;
import org.cpsolver.studentsct.online.selection.OnlineSectioningSelection;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.cpsolver.studentsct.online.selection.SuggestionsBranchAndBound;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.Reservation;

public class Test {
    public static DecimalFormat sDF = new DecimalFormat("0.00000");
    public static Logger sLog = Logger.getLogger(Test.class);
    private OnlineSectioningModel iModel;
    private Assignment<Request, Enrollment> iAssignment;
    private boolean iSuggestions = false;
    private Map<String, Counter> iCounters = new HashMap<String, Counter>();

    public Test(DataProperties config) {
        this.iModel = new TestModel(config);
        this.iModel.setDistanceConflict(new DistanceConflict(new DistanceMetric(this.iModel.getProperties()), this.iModel.getProperties()));
        this.iModel.getDistanceConflict().register(this.iModel);
        this.iModel.getDistanceConflict().setAssignmentContextReference(this.iModel.createReference(this.iModel.getDistanceConflict()));
        this.iModel.setTimeOverlaps(new TimeOverlapsCounter(null, this.iModel.getProperties()));
        this.iModel.getTimeOverlaps().register(this.iModel);
        this.iModel.getTimeOverlaps().setAssignmentContextReference(this.iModel.createReference(this.iModel.getTimeOverlaps()));
        this.iModel.setStudentQuality(new StudentQuality(new DistanceMetric(this.iModel.getProperties()), this.iModel.getProperties()));
        this.iModel.getStudentQuality().register(this.iModel);
        this.iModel.getStudentQuality().setAssignmentContextReference(this.iModel.createReference(this.iModel.getStudentQuality()));
        this.iModel.setStudentWeights(new StudentSchedulingAssistantWeights(this.iModel.getProperties()));
        this.iAssignment = new DefaultSingleAssignment<Request, Enrollment>();
        this.iSuggestions = "true".equals(System.getProperty("suggestions", this.iSuggestions ? "true" : "false"));
        String overexp = System.getProperty("overexp");
        if (overexp != null) {
            String[] x;
            boolean bal = false;
            if (overexp.startsWith("b")) {
                bal = true;
                overexp = overexp.substring(1);
            }
            if ((x = overexp.split("[/\\-]")).length == 1) {
                this.iModel.setOverExpectedCriterion(new PercentageOverExpected(Double.valueOf(x[0])));
            } else if (x.length == 2) {
                this.iModel.setOverExpectedCriterion(bal ? new AvoidUnbalancedWhenNoExpectations(Double.valueOf(x[0]), Double.valueOf(x[1]) / 100.0) : new FractionallyOverExpected(Double.valueOf(x[0]), Double.valueOf(x[1])));
            } else {
                this.iModel.setOverExpectedCriterion(new FractionallyUnbalancedWhenNoExpectations(Double.valueOf(x[0]), Double.valueOf(x[1]), Double.valueOf(x[2]) / 100.0));
            }
        }
        sLog.info("Using " + (config.getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (config.getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal") + " weighting model with over-expected " + this.iModel.getOverExpectedCriterion() + (this.iSuggestions ? ", suggestions" : "") + ", " + System.getProperty("sort", "shuffle") + " order and " + config.getPropertyInt("Neighbour.BranchAndBoundTimeout", 1000) + " ms time limit.");
    }

    public OnlineSectioningModel model() {
        return this.iModel;
    }

    public Assignment<Request, Enrollment> assignment() {
        return this.iAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name, double value) {
        Map<String, Counter> map = this.iCounters;
        synchronized (map) {
            Counter c = this.iCounters.get(name);
            if (c == null) {
                c = new Counter();
                this.iCounters.put(name, c);
            }
            c.inc(value);
        }
    }

    public void inc(String name) {
        this.inc(name, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter get(String name) {
        Map<String, Counter> map = this.iCounters;
        synchronized (map) {
            Counter c = this.iCounters.get(name);
            if (c == null) {
                c = new Counter();
                this.iCounters.put(name, c);
            }
            return c;
        }
    }

    public double getPercDisbalancedSections(Assignment<Request, Enrollment> assignment, double perc) {
        boolean balanceUnlimited = this.model().getProperties().getPropertyBoolean("General.BalanceUnlimited", false);
        double disb10Sections = 0.0;
        double nrSections = 0.0;
        for (Offering offering : this.model().getOfferings()) {
            for (Config config : offering.getConfigs()) {
                double enrl = config.getEnrollmentTotalWeight(assignment, null);
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getSections().size() <= 1) continue;
                    nrSections += (double)subpart.getSections().size();
                    if (subpart.getLimit() > 0) {
                        double ratio = enrl / (double)subpart.getLimit();
                        for (Section section : subpart.getSections()) {
                            double desired = ratio * (double)section.getLimit();
                            if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, perc * (double)section.getLimit()))) continue;
                            disb10Sections += 1.0;
                        }
                        continue;
                    }
                    if (!balanceUnlimited) continue;
                    for (Section section : subpart.getSections()) {
                        double desired = enrl / (double)subpart.getSections().size();
                        if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, perc * desired))) continue;
                        disb10Sections += 1.0;
                    }
                }
            }
        }
        return 100.0 * disb10Sections / nrSections;
    }

    /*
     * Could not resolve type clashes
     */
    protected Course clone(Course course, long studentId, Student originalStudent, Map<Long, Section> classTable, StudentSectioningModel model) {
        Offering clonedOffering = new Offering(course.getOffering().getId(), course.getOffering().getName());
        clonedOffering.setModel(model);
        int courseLimit = course.getLimit();
        if (courseLimit >= 0) {
            if ((courseLimit -= course.getEnrollments(this.assignment()).size()) < 0) {
                courseLimit = 0;
            }
            for (Enrollment enrollment : course.getEnrollments(this.assignment())) {
                if (enrollment.getStudent().getId() != studentId) continue;
                ++courseLimit;
                break;
            }
        }
        Course clonedCourse = new Course(course.getId(), course.getSubjectArea(), course.getCourseNumber(), clonedOffering, courseLimit, course.getProjected());
        clonedCourse.setNote(course.getNote());
        Hashtable<Config, OnlineConfig> configs = new Hashtable<Config, OnlineConfig>();
        Hashtable<Subpart, Subpart> subparts = new Hashtable<Subpart, Subpart>();
        Hashtable<Section, OnlineSection> sections = new Hashtable<Section, OnlineSection>();
        for (Config config : course.getOffering().getConfigs()) {
            int configLimit = config.getLimit();
            int configEnrollment = config.getEnrollments(this.assignment()).size();
            if (configLimit >= 0) {
                if ((configLimit -= config.getEnrollments(this.assignment()).size()) < 0) {
                    configLimit = 0;
                }
                for (Enrollment enrollment2 : config.getEnrollments(this.assignment())) {
                    if (enrollment2.getStudent().getId() != studentId) continue;
                    ++configLimit;
                    --configEnrollment;
                    break;
                }
            }
            OnlineConfig clonedConfig = new OnlineConfig(config.getId(), configLimit, config.getName(), clonedOffering);
            clonedConfig.setInstructionalMethodId(config.getInstructionalMethodId());
            clonedConfig.setInstructionalMethodName(config.getInstructionalMethodName());
            clonedConfig.setInstructionalMethodReference(config.getInstructionalMethodReference());
            clonedConfig.setEnrollment(configEnrollment);
            configs.put(config, clonedConfig);
            for (Subpart subpart : config.getSubparts()) {
                Subpart clonedSubpart = new Subpart(subpart.getId(), subpart.getInstructionalType(), subpart.getName(), clonedConfig, subpart.getParent() == null ? null : (Subpart)subparts.get(subpart.getParent()));
                clonedSubpart.setAllowOverlap(subpart.isAllowOverlap());
                clonedSubpart.setCredit(subpart.getCredit());
                subparts.put(subpart, clonedSubpart);
                for (Section section : subpart.getSections()) {
                    int limit = section.getLimit();
                    int enrl = section.getEnrollments(this.assignment()).size();
                    if (limit >= 0) {
                        if ((limit -= section.getEnrollments(this.assignment()).size()) < 0) {
                            limit = 0;
                        }
                        if (studentId >= 0L) {
                            for (Object enrollment : section.getEnrollments(this.assignment())) {
                                if (((Enrollment)enrollment).getStudent().getId() != studentId) continue;
                                ++limit;
                                --enrl;
                                break;
                            }
                        }
                    }
                    OnlineSection clonedSection = new OnlineSection(section.getId(), limit, section.getName(course.getId()), clonedSubpart, section.getPlacement(), section.getInstructors(), section.getParent() == null ? null : (Section)sections.get(section.getParent()));
                    clonedSection.setName(-1L, section.getName(-1L));
                    clonedSection.setNote(section.getNote());
                    clonedSection.setSpaceExpected(section.getSpaceExpected());
                    clonedSection.setSpaceHeld(section.getSpaceHeld());
                    clonedSection.setEnrollment(enrl);
                    clonedSection.setCancelled(section.isCancelled());
                    clonedSection.setEnabled(section.isEnabled());
                    if (section.getIgnoreConflictWithSectionIds() != null) {
                        Object enrollment;
                        enrollment = section.getIgnoreConflictWithSectionIds().iterator();
                        while (enrollment.hasNext()) {
                            Long id = (Long)enrollment.next();
                            clonedSection.addIgnoreConflictWith(id);
                        }
                    }
                    if (limit > 0) {
                        double available = Math.round(section.getSpaceExpected() - (double)limit);
                        clonedSection.setPenalty(available / (double)section.getLimit());
                    }
                    sections.put(section, clonedSection);
                    classTable.put(section.getId(), clonedSection);
                }
            }
        }
        if (course.getOffering().hasReservations()) {
            for (Reservation reservation : course.getOffering().getReservations()) {
                boolean applicable;
                int reservationLimit = (int)Math.round(reservation.getLimit());
                if (reservationLimit >= 0) {
                    if ((reservationLimit -= reservation.getEnrollments(this.assignment()).size()) < 0) {
                        reservationLimit = 0;
                    }
                    for (Object enrollment : reservation.getEnrollments(this.assignment())) {
                        if (((Enrollment)enrollment).getStudent().getId() != studentId) continue;
                        ++reservationLimit;
                        break;
                    }
                    if (reservationLimit <= 0 && !reservation.mustBeUsed()) continue;
                }
                boolean bl = applicable = originalStudent != null && reservation.isApplicable(originalStudent);
                if (reservation instanceof CourseReservation) {
                    boolean bl2 = applicable = course.getId() == ((CourseReservation)reservation).getCourse().getId();
                }
                if (reservation instanceof DummyReservation) {
                    Object enrollment;
                    enrollment = course.getEnrollments(this.assignment()).iterator();
                    while (enrollment.hasNext()) {
                        Enrollment enrollment2;
                        enrollment2 = enrollment.next();
                        if (enrollment2.getStudent().getId() != studentId) continue;
                        applicable = true;
                        break;
                    }
                }
                OnlineReservation clonedReservation = new OnlineReservation(0, reservation.getId(), clonedOffering, reservation.getPriority(), reservation.canAssignOverLimit(), reservationLimit, applicable, reservation.mustBeUsed(), reservation.isAllowOverlap(), reservation.isExpired());
                for (Config config : reservation.getConfigs()) {
                    clonedReservation.addConfig((Config)configs.get(config));
                }
                for (Map.Entry entry : reservation.getSections().entrySet()) {
                    HashSet clonedSections = new HashSet();
                    for (Section section : (Set)entry.getValue()) {
                        clonedSections.add(sections.get(section));
                    }
                    clonedReservation.getSections().put((Subpart)subparts.get(entry.getKey()), clonedSections);
                }
            }
        }
        return clonedCourse;
    }

    protected Request addRequest(Student student, Student original, Request request, Map<Long, Section> classTable, StudentSectioningModel model) {
        if (request instanceof FreeTimeRequest) {
            return new FreeTimeRequest(student.getRequests().size() + 1, student.getRequests().size(), request.isAlternative(), student, ((FreeTimeRequest)request).getTime());
        }
        if (request instanceof CourseRequest) {
            ArrayList<Course> courses = new ArrayList<Course>();
            for (Course course : ((CourseRequest)request).getCourses()) {
                courses.add(this.clone(course, student.getId(), original, classTable, model));
            }
            CourseRequest clonnedRequest = new CourseRequest(student.getRequests().size() + 1, student.getRequests().size(), request.isAlternative(), student, courses, ((CourseRequest)request).isWaitlist(), request.isCritical(), null);
            block1: for (Request originalRequest : original.getRequests()) {
                Enrollment originalEnrollment = this.assignment().getValue(originalRequest);
                for (Course clonnedCourse : clonnedRequest.getCourses()) {
                    boolean needReservation;
                    if (!clonnedCourse.getOffering().hasReservations() || originalEnrollment == null || !clonnedCourse.equals(originalEnrollment.getCourse())) continue;
                    boolean bl = needReservation = clonnedCourse.getOffering().getUnreservedSpace(this.assignment(), clonnedRequest) < 1.0;
                    if (!needReservation) {
                        boolean configChecked = false;
                        for (Section originalSection : originalEnrollment.getSections()) {
                            Section clonnedSection = classTable.get(originalSection.getId());
                            if (clonnedSection.getUnreservedSpace(this.assignment(), clonnedRequest) < 1.0) {
                                needReservation = true;
                                break;
                            }
                            if (!configChecked && clonnedSection.getSubpart().getConfig().getUnreservedSpace(this.assignment(), clonnedRequest) < 1.0) {
                                needReservation = true;
                                break;
                            }
                            configChecked = true;
                        }
                    }
                    if (!needReservation) continue block1;
                    OnlineReservation reservation = new OnlineReservation(0, -original.getId(), clonnedCourse.getOffering(), 5, false, 1, true, false, false, true);
                    for (Section originalSection : originalEnrollment.getSections()) {
                        reservation.addSection(classTable.get(originalSection.getId()));
                    }
                    continue block1;
                }
            }
            return clonnedRequest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean section(Student original) {
        TestModel model = new TestModel(this.iModel.getProperties());
        model.setOverExpectedCriterion(this.iModel.getOverExpectedCriterion());
        Student student = new Student(original.getId());
        Hashtable<CourseRequest, Set<Section>> preferredSectionsForCourse = new Hashtable<CourseRequest, Set<Section>>();
        HashMap<Long, Section> classTable = new HashMap<Long, Section>();
        OnlineSectioningModel onlineSectioningModel = this.iModel;
        synchronized (onlineSectioningModel) {
            for (Request request : original.getRequests()) {
                Request clonnedRequest = this.addRequest(student, original, request, classTable, model);
                Enrollment enrollment = this.assignment().getValue(request);
                if (enrollment == null || !enrollment.isCourseRequest()) continue;
                HashSet sections = new HashSet();
                for (Section section : enrollment.getSections()) {
                    sections.add(classTable.get(section.getId()));
                }
                preferredSectionsForCourse.put((CourseRequest)clonnedRequest, sections);
            }
        }
        model.addStudent(student);
        model.setDistanceConflict(new DistanceConflict(this.iModel.getDistanceConflict().getDistanceMetric(), model.getProperties()));
        model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
        for (LinkedSections link : this.iModel.getLinkedSections()) {
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Offering offering : link.getOfferings()) {
                for (Subpart subpart : link.getSubparts(offering)) {
                    for (Section section : link.getSections(subpart)) {
                        Section x = (Section)classTable.get(section.getId());
                        if (x == null) continue;
                        sections.add(x);
                    }
                }
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(link.isMustBeUsed(), sections);
        }
        OnlineSectioningSelection selection = null;
        selection = model.getProperties().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(this.iModel.getProperties()) : new SuggestionSelection(model.getProperties());
        selection.setModel(model);
        selection.setPreferredSections(preferredSectionsForCourse);
        selection.setRequiredSections(new Hashtable<CourseRequest, Set<Section>>());
        selection.setRequiredFreeTimes(new HashSet<FreeTimeRequest>());
        long t0 = JProf.currentTimeMillis();
        AssignmentMap<Request, Enrollment> newAssignment = new AssignmentMap<Request, Enrollment>();
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select(newAssignment, student);
        long time = JProf.currentTimeMillis() - t0;
        this.inc("[C] CPU Time", time);
        if (neighbour == null) {
            this.inc("[F] Failure");
        } else {
            if (this.iSuggestions) {
                StudentPreferencePenalties studentPreferencePenalties = new StudentPreferencePenalties(StudentPreferencePenalties.sDistTypePreference);
                double maxOverExpected = 0.0;
                int assigned = 0;
                double penalty = 0.0;
                Hashtable<CourseRequest, Set<Section>> enrollments = new Hashtable<CourseRequest, Set<Section>>();
                ArrayList<RequestSectionPair> pairs = new ArrayList<RequestSectionPair>();
                for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                    Enrollment enrl = neighbour.getAssignment()[i];
                    if (enrl == null || !enrl.isCourseRequest() || enrl.getAssignments() == null) continue;
                    ++assigned;
                    for (Section section : enrl.getSections()) {
                        maxOverExpected += model.getOverExpected(newAssignment, section, enrl.getRequest());
                        pairs.add(new RequestSectionPair((Request)enrl.variable(), section));
                    }
                    enrollments.put((CourseRequest)enrl.variable(), enrl.getSections());
                    penalty += studentPreferencePenalties.getPenalty(enrl);
                }
                this.inc("[S] Initial Penalty", penalty /= (double)assigned);
                double nrSuggestions = 0.0;
                double nrAccepted = 0.0;
                double totalSuggestions = 0.0;
                double nrTries = 0.0;
                for (int i = 0; i < pairs.size(); ++i) {
                    int j;
                    RequestSectionPair pair = (RequestSectionPair)pairs.get(i);
                    SuggestionsBranchAndBound suggestionBaB = null;
                    suggestionBaB = model.getProperties().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSuggestions(model.getProperties(), student, newAssignment, new Hashtable<CourseRequest, Set<Section>>(), new HashSet<FreeTimeRequest>(), enrollments, pair.getRequest(), pair.getSection(), null, maxOverExpected, this.iModel.getProperties().getPropertyBoolean("StudentWeights.PriorityWeighting", true)) : new SuggestionsBranchAndBound(model.getProperties(), student, newAssignment, new Hashtable<CourseRequest, Set<Section>>(), new HashSet<FreeTimeRequest>(), enrollments, pair.getRequest(), pair.getSection(), null, maxOverExpected);
                    long x0 = JProf.currentTimeMillis();
                    TreeSet<SuggestionsBranchAndBound.Suggestion> suggestions = suggestionBaB.computeSuggestions();
                    this.inc("[S] Suggestion CPU Time", JProf.currentTimeMillis() - x0);
                    totalSuggestions += (double)suggestions.size();
                    if (!suggestions.isEmpty()) {
                        nrSuggestions += 1.0;
                    }
                    nrTries += 1.0;
                    SuggestionsBranchAndBound.Suggestion best = null;
                    for (SuggestionsBranchAndBound.Suggestion suggestion : suggestions) {
                        int a = 0;
                        double p = 0.0;
                        for (int j2 = 0; j2 < suggestion.getEnrollments().length; ++j2) {
                            Enrollment e = suggestion.getEnrollments()[j2];
                            if (e == null || !e.isCourseRequest() || e.getAssignments() == null) continue;
                            p += studentPreferencePenalties.getPenalty(e);
                            ++a;
                        }
                        p /= (double)a;
                        if (a <= assigned && (assigned != a || !(p < penalty))) continue;
                        best = suggestion;
                    }
                    if (best == null) continue;
                    nrAccepted += 1.0;
                    Enrollment[] e = best.getEnrollments();
                    for (j = 0; j < e.length; ++j) {
                        if (e[j] == null || e[j].getAssignments() != null) continue;
                        e[j] = null;
                    }
                    neighbour = new BranchBoundSelection.BranchBoundNeighbour(student, best.getValue(), e);
                    assigned = 0;
                    penalty = 0.0;
                    enrollments.clear();
                    pairs.clear();
                    for (j = 0; j < neighbour.getAssignment().length; ++j) {
                        Enrollment enrl = neighbour.getAssignment()[j];
                        if (enrl == null || !enrl.isCourseRequest() || enrl.getAssignments() == null) continue;
                        ++assigned;
                        for (Section section : enrl.getSections()) {
                            pairs.add(new RequestSectionPair((Request)enrl.variable(), section));
                        }
                        enrollments.put((CourseRequest)enrl.variable(), enrl.getSections());
                        penalty += studentPreferencePenalties.getPenalty(enrl);
                    }
                    this.inc("[S] Improved Penalty", penalty /= (double)assigned);
                }
                this.inc("[S] Final Penalty", penalty);
                if (nrSuggestions > 0.0) {
                    this.inc("[S] Classes with suggestion", nrSuggestions);
                    this.inc("[S] Avg. # of suggestions", totalSuggestions / nrSuggestions);
                    this.inc("[S] Suggestion acceptance rate [%]", nrAccepted / nrSuggestions);
                } else {
                    this.inc("[S] Student with no suggestions available", 1.0);
                }
                if (!pairs.isEmpty()) {
                    this.inc("[S] Probability that a class has suggestions [%]", nrSuggestions / nrTries);
                }
            }
            ArrayList<Enrollment> arrayList = new ArrayList<Enrollment>();
            block20: for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                Iterator<Request> request = original.getRequests().get(i);
                Enrollment clonnedEnrollment = neighbour.getAssignment()[i];
                if (clonnedEnrollment == null || clonnedEnrollment.getAssignments() == null) continue;
                if (request instanceof FreeTimeRequest) {
                    arrayList.add(((FreeTimeRequest)((Object)request)).createEnrollment());
                    continue;
                }
                for (Course course : ((CourseRequest)((Object)request)).getCourses()) {
                    if (course.getId() != clonnedEnrollment.getCourse().getId()) continue;
                    for (Config config : course.getOffering().getConfigs()) {
                        if (config.getId() != clonnedEnrollment.getConfig().getId()) continue;
                        HashSet<Section> assignments = new HashSet<Section>();
                        for (Subpart subpart : config.getSubparts()) {
                            for (Section section : subpart.getSections()) {
                                if (!clonnedEnrollment.getSections().contains(section)) continue;
                                assignments.add(section);
                            }
                        }
                        Reservation reservation = null;
                        if (clonnedEnrollment.getReservation() != null) {
                            for (Reservation reservation2 : course.getOffering().getReservations()) {
                                if (reservation2.getId() != clonnedEnrollment.getReservation().getId()) continue;
                                reservation = reservation2;
                                break;
                            }
                        }
                        arrayList.add(new Enrollment((Request)((Object)request), clonnedEnrollment.getPriority(), course, config, (Set<? extends SctAssignment>)assignments, reservation));
                        continue block20;
                    }
                }
            }
            OnlineSectioningModel i = this.iModel;
            synchronized (i) {
                for (Request r : original.getRequests()) {
                    Enrollment e = this.assignment().getValue(r);
                    r.setInitialAssignment(e);
                    if (e == null) continue;
                    Test.updateSpace(this.assignment(), e, true);
                }
                for (Request r : original.getRequests()) {
                    if (this.assignment().getValue(r) == null) continue;
                    this.assignment().unassign(0L, r);
                }
                boolean fail = false;
                for (Enrollment enrl : arrayList) {
                    if (this.iModel.conflictValues(this.assignment(), enrl).isEmpty()) {
                        this.assignment().assign(0L, enrl);
                        continue;
                    }
                    fail = true;
                    break;
                }
                if (fail) {
                    for (Request r : original.getRequests()) {
                        if (this.assignment().getValue(r) == null) continue;
                        this.assignment().unassign(0L, r);
                    }
                    for (Request r : original.getRequests()) {
                        if (r.getInitialAssignment() == null) continue;
                        this.assignment().assign(0L, (Enrollment)r.getInitialAssignment());
                    }
                    for (Request r : original.getRequests()) {
                        if (this.assignment().getValue(r) == null) continue;
                        Test.updateSpace(this.assignment(), this.assignment().getValue(r), false);
                    }
                } else {
                    for (Enrollment enrl : arrayList) {
                        Test.updateSpace(this.assignment(), enrl, false);
                    }
                }
                if (fail) {
                    return false;
                }
            }
            neighbour.assign((Assignment<Request, Enrollment>)newAssignment, 0L);
            int a = 0;
            int u = 0;
            int np = 0;
            int zp = 0;
            int pp = 0;
            int cp = 0;
            double over = 0.0;
            double p = 0.0;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                Enrollment e = (Enrollment)newAssignment.getValue(r);
                if (e != null) {
                    for (Section s : e.getSections()) {
                        if (s.getPenalty() < 0.0) {
                            ++np;
                        }
                        if (s.getPenalty() == 0.0) {
                            ++zp;
                        }
                        if (s.getPenalty() > 0.0) {
                            ++pp;
                        }
                        if (s.getLimit() > 0) {
                            p += s.getPenalty();
                            ++cp;
                        }
                        over += model.getOverExpected(newAssignment, s, r);
                    }
                    ++a;
                    continue;
                }
                ++u;
            }
            this.inc("[A] Student");
            if (over > 0.0) {
                this.inc("[O] Over", over);
            }
            if (a > 0) {
                this.inc("[A] Assigned", a);
            }
            if (u > 0) {
                this.inc("[A] Not Assigned", u);
            }
            this.inc("[V] Value", neighbour.value((Assignment<Request, Enrollment>)newAssignment));
            if (zp > 0) {
                this.inc("[P] Zero penalty", zp);
            }
            if (np > 0) {
                this.inc("[P] Negative penalty", np);
            }
            if (pp > 0) {
                this.inc("[P] Positive penalty", pp);
            }
            if (cp > 0) {
                this.inc("[P] Average penalty", p / (double)cp);
            }
        }
        this.inc("[T0] Time <10ms", time < 10L ? 1.0 : 0.0);
        this.inc("[T1] Time <100ms", time < 100L ? 1.0 : 0.0);
        this.inc("[T2] Time <250ms", time < 250L ? 1.0 : 0.0);
        this.inc("[T3] Time <500ms", time < 500L ? 1.0 : 0.0);
        this.inc("[T4] Time <1s", time < 1000L ? 1.0 : 0.0);
        this.inc("[T5] Time >=1s", time >= 1000L ? 1.0 : 0.0);
        return true;
    }

    public static void updateSpace(Assignment<Request, Enrollment> assignment, Enrollment enrollment, boolean increment) {
        if (enrollment == null || !enrollment.isCourseRequest()) {
            return;
        }
        for (Section section : enrollment.getSections()) {
            section.setSpaceHeld(section.getSpaceHeld() + (increment ? 1.0 : -1.0));
        }
        ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
        int totalLimit = 0;
        for (Enrollment enrl : enrollment.getRequest().values(assignment)) {
            if (!enrl.getCourse().equals(enrollment.getCourse())) continue;
            boolean overlaps = false;
            for (Request otherRequest : enrollment.getRequest().getStudent().getRequests()) {
                Enrollment otherErollment;
                if (otherRequest.equals(enrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = assignment.getValue(otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            feasibleEnrollments.add(enrl);
            if (totalLimit < 0) continue;
            int limit = enrl.getLimit();
            if (limit < 0) {
                totalLimit = -1;
                continue;
            }
            totalLimit += limit;
        }
        double change = enrollment.getRequest().getWeight() / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
        for (Enrollment feasibleEnrollment : feasibleEnrollments) {
            for (Section section : feasibleEnrollment.getSections()) {
                if (totalLimit > 0) {
                    section.setSpaceExpected(section.getSpaceExpected() + (increment ? change : -change) * (double)feasibleEnrollment.getLimit());
                    continue;
                }
                section.setSpaceExpected(section.getSpaceExpected() + (increment ? change : -change));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StudentChoiceOrder ord;
        sLog.info("Input: " + ToolBox.dict2string(this.model().getExtendedInfo(this.assignment()), 2));
        ArrayList<Student> students = new ArrayList<Student>(this.model().getStudents());
        String sort = System.getProperty("sort", "shuffle");
        if ("shuffle".equals(sort)) {
            Collections.shuffle(students);
        } else if ("choice".equals(sort)) {
            ord = new StudentChoiceOrder(this.model().getProperties());
            ord.setReverse(false);
            Collections.sort(students, ord);
        } else if ("referse".equals(sort)) {
            ord = new StudentChoiceOrder(this.model().getProperties());
            ord.setReverse(true);
            Collections.sort(students, ord);
        }
        Iterator<Student> iterator = students.iterator();
        int nrThreads = Integer.parseInt(System.getProperty("nrConcurrent", "10"));
        ArrayList<Executor> executors = new ArrayList<Executor>();
        for (int i = 0; i < nrThreads; ++i) {
            Executor executor = new Executor(iterator);
            executor.start();
            executors.add(executor);
        }
        long t0 = System.currentTimeMillis();
        while (iterator.hasNext()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long time = System.currentTimeMillis() - t0;
            OnlineSectioningModel onlineSectioningModel = this.iModel;
            synchronized (onlineSectioningModel) {
                sLog.info("Progress [" + time / 60000L + "m]: " + ToolBox.dict2string(this.model().getExtendedInfo(this.assignment()), 2));
            }
        }
        for (Executor executor : executors) {
            try {
                executor.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        sLog.info("Output: " + ToolBox.dict2string(this.model().getExtendedInfo(this.assignment()), 2));
        long time = System.currentTimeMillis() - t0;
        this.inc("[T] Run Time [m]", (double)time / 60000.0);
    }

    private void stats(File input) throws IOException {
        File file = new File(input.getParentFile(), "stats.csv");
        DecimalFormat df = new DecimalFormat("0.0000");
        boolean ex = file.exists();
        PrintWriter pw = new PrintWriter(new FileWriter(file, true));
        if (!ex) {
            pw.println("Input File,Run Time [m],Model,Sort,Over Expected,Not Assigned,Disb. Sections [%],Distance Confs.,Time Confs. [m],CPU Assignment [ms],Has Suggestions [%],Nbr Suggestions,Acceptance [%],CPU Suggestions [ms]");
        }
        pw.print(input.getName() + ",");
        pw.print(df.format(this.get("[T] Run Time [m]").sum()) + ",");
        pw.print(this.model().getProperties().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "");
        pw.print(this.model().getProperties().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal");
        pw.print(this.iSuggestions ? " with suggestions" : "");
        pw.print(",");
        pw.print(System.getProperty("sort", "shuffle") + ",");
        pw.print("\"" + this.model().getOverExpectedCriterion() + "\",");
        pw.print(this.get("[A] Not Assigned").sum() + ",");
        pw.print(df.format(this.getPercDisbalancedSections(this.assignment(), 0.1)) + ",");
        if (this.model().getStudentQuality() != null) {
            pw.print(df.format((double)this.model().getStudentQuality().getTotalPenalty(this.assignment(), StudentQuality.Type.Distance, StudentQuality.Type.ShortDistance) / (double)this.model().getStudents().size()) + ",");
            pw.print(df.format(5.0 * (double)this.model().getStudentQuality().getTotalPenalty(this.assignment(), StudentQuality.Type.CourseTimeOverlap, StudentQuality.Type.FreeTimeOverlap, StudentQuality.Type.Unavailability) / (double)this.model().getStudents().size()) + ",");
        } else {
            pw.print(df.format((double)this.model().getDistanceConflict().getTotalNrConflicts(this.assignment()) / (double)this.model().getStudents().size()) + ",");
            pw.print(df.format(5.0 * (double)this.model().getTimeOverlaps().getTotalNrConflicts(this.assignment()) / (double)this.model().getStudents().size()) + ",");
        }
        pw.print(df.format(this.get("[C] CPU Time").avg()) + ",");
        if (this.iSuggestions) {
            pw.print(df.format(this.get("[S] Probability that a class has suggestions [%]").avg()) + ",");
            pw.print(df.format(this.get("[S] Avg. # of suggestions").avg()) + ",");
            pw.print(df.format(this.get("[S] Suggestion acceptance rate [%]").avg()) + ",");
            pw.print(df.format(this.get("[S] Suggestion CPU Time").avg()));
        }
        pw.println();
        pw.flush();
        pw.close();
    }

    public static void main(String[] args) {
        try {
            System.setProperty("jprof", "cpu");
            BasicConfigurator.configure();
            DataProperties cfg = new DataProperties();
            cfg.setProperty("Neighbour.BranchAndBoundTimeout", "5000");
            cfg.setProperty("Suggestions.Timeout", "1000");
            cfg.setProperty("Extensions.Classes", DistanceConflict.class.getName() + ";" + TimeOverlapsCounter.class.getName());
            cfg.setProperty("StudentWeights.Class", StudentSchedulingAssistantWeights.class.getName());
            cfg.setProperty("StudentWeights.PriorityWeighting", "true");
            cfg.setProperty("StudentWeights.LeftoverSpread", "true");
            cfg.setProperty("StudentWeights.BalancingFactor", "0.0");
            cfg.setProperty("Reservation.CanAssignOverTheLimit", "true");
            cfg.setProperty("Distances.Ellipsoid", DistanceMetric.Ellipsoid.WGS84.name());
            cfg.setProperty("StudentWeights.MultiCriteria", "true");
            cfg.setProperty("CourseRequest.SameTimePrecise", "true");
            cfg.setProperty("log4j.rootLogger", "INFO, A1");
            cfg.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            cfg.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            cfg.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
            cfg.setProperty("log4j.logger.org.hibernate", "INFO");
            cfg.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            cfg.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            cfg.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            cfg.setProperty("log4j.logger.net", "INFO");
            cfg.setProperty("Xml.LoadBest", "false");
            cfg.setProperty("Xml.LoadCurrent", "false");
            cfg.putAll((Map<?, ?>)System.getProperties());
            PropertyConfigurator.configure(cfg);
            Test test = new Test(cfg);
            File input = new File(args[0]);
            StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(test.model(), test.assignment());
            loader.setInputFile(input);
            loader.load();
            test.run();
            Solver<Request, Enrollment> s = new Solver<Request, Enrollment>(cfg);
            s.setInitalSolution(test.model());
            StudentSectioningXMLSaver saver = new StudentSectioningXMLSaver(s);
            File output = new File(input.getParentFile(), input.getName().substring(0, input.getName().lastIndexOf(46)) + "-" + cfg.getProperty("run", "r0") + ".xml");
            saver.save(output);
            test.stats(input);
        }
        catch (Exception e) {
            sLog.error("Test failed: " + e.getMessage(), e);
        }
    }

    private static class Counter {
        private double iTotal = 0.0;
        private double iMin = 0.0;
        private double iMax = 0.0;
        private double iTotalSquare = 0.0;
        private int iCount = 0;

        private Counter() {
        }

        void inc(double value) {
            if (this.iCount == 0) {
                this.iTotal = value;
                this.iMin = value;
                this.iMax = value;
                this.iTotalSquare = value * value;
            } else {
                this.iTotal += value;
                this.iMin = Math.min(this.iMin, value);
                this.iMax = Math.max(this.iMax, value);
                this.iTotalSquare += value * value;
            }
            ++this.iCount;
        }

        int count() {
            return this.iCount;
        }

        double sum() {
            return this.iTotal;
        }

        double min() {
            return this.iMin;
        }

        double max() {
            return this.iMax;
        }

        double rms() {
            return this.iCount == 0 ? 0.0 : Math.sqrt(this.iTotalSquare / (double)this.iCount);
        }

        double avg() {
            return this.iCount == 0 ? 0.0 : this.iTotal / (double)this.iCount;
        }

        public String toString() {
            return sDF.format(this.sum()) + " (min: " + sDF.format(this.min()) + ", max: " + sDF.format(this.max()) + ", avg: " + sDF.format(this.avg()) + ", rms: " + sDF.format(this.rms()) + ", cnt: " + this.count() + ")";
        }
    }

    private static class RequestSectionPair {
        private Request iRequest;
        private Section iSection;

        RequestSectionPair(Request request, Section section) {
            this.iRequest = request;
            this.iSection = section;
        }

        Request getRequest() {
            return this.iRequest;
        }

        Section getSection() {
            return this.iSection;
        }
    }

    public class TestModel
    extends OnlineSectioningModel {
        public TestModel(DataProperties config) {
            super(config);
        }

        @Override
        public Map<String, String> getExtendedInfo(Assignment<Request, Enrollment> assignment) {
            Map<String, String> ret = super.getExtendedInfo(assignment);
            for (Map.Entry e : Test.this.iCounters.entrySet()) {
                ret.put((String)e.getKey(), ((Counter)e.getValue()).toString());
            }
            ret.put("Weighting model", (Test.this.model().getProperties().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (Test.this.model().getProperties().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal"));
            ret.put("B&B time limit", Test.this.model().getProperties().getPropertyInt("Neighbour.BranchAndBoundTimeout", 1000) + " ms");
            if (Test.this.iSuggestions) {
                ret.put("Suggestion time limit", Test.this.model().getProperties().getPropertyInt("Suggestions.Timeout", 1000) + " ms");
            }
            return ret;
        }
    }

    public class Executor
    extends Thread {
        private Iterator<Student> iStudents = null;

        public Executor(Iterator<Student> students) {
            this.iStudents = students;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Student student = this.iStudents.next();
                    int attempt = 1;
                    while (!Test.this.section(student)) {
                        sLog.warn(attempt + ". attempt failed for " + student.getId());
                        Test.this.inc("[F] Failed attempt", attempt);
                        if (++attempt == 101) break;
                        if (attempt <= 10) continue;
                        try {
                            Thread.sleep(ToolBox.random(100 * attempt));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (attempt <= 100) continue;
                    Test.this.inc("[F] Failed enrollment (all 100 attempts)");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
        }
    }
}

