/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Student;

public class FreeTimeRequest
extends Request
implements SctAssignment {
    private TimeLocation iTime = null;

    public FreeTimeRequest(long id, int priority, boolean alternative, Student student, TimeLocation time) {
        super(id, priority, alternative, student);
        this.iTime = time;
    }

    @Override
    public TimeLocation getTime() {
        return this.iTime;
    }

    @Override
    public int getNrRooms() {
        return 0;
    }

    @Override
    public List<RoomLocation> getRooms() {
        return new ArrayList<RoomLocation>(0);
    }

    @Override
    public boolean isOverlapping(SctAssignment assignment) {
        if (this.isAllowOverlap() || assignment.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignment.getTime() == null) {
            return false;
        }
        if (assignment instanceof FreeTimeRequest) {
            return false;
        }
        return this.getTime().hasIntersection(assignment.getTime());
    }

    @Override
    public boolean isOverlapping(Set<? extends SctAssignment> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null) {
            return false;
        }
        for (SctAssignment sctAssignment : assignments) {
            if (sctAssignment.isAllowOverlap() || sctAssignment.getTime() == null) continue;
            if (sctAssignment instanceof FreeTimeRequest) {
                return false;
            }
            if (!this.getTime().hasIntersection(sctAssignment.getTime())) continue;
            return true;
        }
        return false;
    }

    public Enrollment createEnrollment() {
        HashSet<FreeTimeRequest> assignments = new HashSet<FreeTimeRequest>();
        assignments.add(this);
        return new Enrollment(this, 0, null, assignments, null);
    }

    @Override
    public List<Enrollment> computeEnrollments(Assignment<Request, Enrollment> assignment) {
        ArrayList<Enrollment> enrollments = new ArrayList<Enrollment>(1);
        enrollments.add(this.createEnrollment());
        return enrollments;
    }

    @Override
    public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((FreeTimeRequestContext)this.getContext(assignment)).assigned(assignment, enrollment);
    }

    @Override
    public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((FreeTimeRequestContext)this.getContext(assignment)).unassigned(assignment, enrollment);
    }

    @Override
    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return ((FreeTimeRequestContext)this.getContext(assignment)).getEnrollments();
    }

    @Override
    public String getName() {
        return (this.isAlternative() ? "A" : "") + (1 + this.getPriority() + (this.isAlternative() ? -this.getStudent().nrRequests() : 0)) + ". Free Time " + this.getTime().getDayHeader() + " " + this.getTime().getStartTimeHeader(true) + " - " + this.getTime().getEndTimeHeader(true);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public double getBound() {
        return -this.getWeight() * ((StudentSectioningModel)this.getModel()).getStudentWeights().getBound(this);
    }

    @Override
    public boolean isAllowOverlap() {
        return this.getModel() == null ? true : ((StudentSectioningModel)this.getModel()).getStudentWeights().isFreeTimeAllowOverlaps();
    }

    @Override
    public int compareById(SctAssignment a) {
        if (a instanceof FreeTimeRequest) {
            return new Long(this.getId()).compareTo(((FreeTimeRequest)a).getId());
        }
        return 1;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getTime().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof CourseRequest && this.getTime().equals(((FreeTimeRequest)o).getTime());
    }

    @Override
    public Request.RequestContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new FreeTimeRequestContext(assignment);
    }

    @Override
    public float getMinCredit() {
        return 0.0f;
    }

    @Override
    public boolean isCritical() {
        return false;
    }

    public class FreeTimeRequestContext
    extends Request.RequestContext {
        private HashSet<Enrollment> iEnrollments;

        public FreeTimeRequestContext(Assignment<Request, Enrollment> assignment) {
            super(FreeTimeRequest.this, assignment);
            this.iEnrollments = new HashSet();
            Enrollment enrollment = assignment.getValue(FreeTimeRequest.this);
            if (enrollment != null) {
                this.assigned(assignment, enrollment);
            }
        }

        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            this.iEnrollments.add(enrollment);
        }

        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            this.iEnrollments.remove(enrollment);
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }
    }
}

