/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.studentord;

import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceOrder;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentGroupsChoiceRealFirstOrder
extends StudentChoiceOrder {
    public StudentGroupsChoiceRealFirstOrder(DataProperties config) {
        super(config);
    }

    public StudentGroupsChoiceRealFirstOrder() {
        super(new DataProperties());
        this.setReverse(true);
    }

    @Override
    public int compare(Student s1, Student s2) {
        int cmp;
        if (s1.isPriority() != s2.isPriority()) {
            return s1.isPriority() ? -1 : 1;
        }
        if (s1.isDummy()) {
            if (!s2.isDummy()) {
                return 1;
            }
        } else if (s2.isDummy()) {
            return -1;
        }
        if ((cmp = -Double.compare(this.nrGroups(s1), this.nrGroups(s2))) != 0) {
            return cmp;
        }
        return super.compare(s1, s2);
    }

    public double nrGroups(Student s) {
        double nrGroups = 0.0;
        for (Request r : s.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            nrGroups += (double)((CourseRequest)r).getRequestGroups().size();
        }
        return nrGroups / (double)s.getRequests().size();
    }
}

