/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.heuristics.RandomizedBacktrackNeighbourSelection;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;

public class BacktrackSelection
implements NeighbourSelection<Request, Enrollment>,
InfoProvider<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    protected RandomizedBacktrackNeighbourSelection iRBtNSel = null;
    protected Queue<Request> iRequests = null;
    protected boolean iIncludeAssignedRequests = false;
    protected long iNbrIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;
    protected StudentFilter iFilter = null;

    public BacktrackSelection(DataProperties properties) {
        this.iIncludeAssignedRequests = properties.getPropertyBoolean("Neighbour.IncludeAssignedRequests", this.iIncludeAssignedRequests);
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> variables = new ArrayList<Request>(this.iIncludeAssignedRequests ? solver.currentSolution().getModel().variables() : solver.currentSolution().getModel().unassignedVariables(solver.currentSolution().getAssignment()));
        Collections.shuffle(variables);
        this.iRequests = new LinkedList<Request>(variables);
        if (this.iRBtNSel == null) {
            try {
                this.iRBtNSel = new RandomizedBacktrackNeighbourSelection(solver.getProperties());
                this.iRBtNSel.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, variables.size());
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Backtracking...");
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
    }

    protected synchronized Request nextRequest() {
        Request request;
        do {
            if ((request = this.iRequests.poll()) != null) continue;
            return null;
        } while (this.iFilter != null && !this.iFilter.accept(request.getStudent()));
        return request;
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Request request = null;
        while ((request = this.nextRequest()) != null) {
            Progress.getInstance(solution.getModel()).incProgress();
            Enrollment e = request.getAssignment(solution.getAssignment());
            if (e != null && request instanceof FreeTimeRequest || e != null && e.getPriority() == 0 && ((CourseRequest)request).getSelectedChoices().isEmpty()) continue;
            Neighbour<Request, Enrollment> n = this.iRBtNSel.selectNeighbour(solution, request);
            if (this.iRBtNSel.getContext() != null) {
                ++this.iNbrIterations;
                this.iTotalTime += this.iRBtNSel.getContext().getTime();
                if (this.iRBtNSel.getContext().isTimeoutReached()) {
                    ++this.iNbrTimeoutReached;
                }
                if (n == null) {
                    ++this.iNbrNoSolution;
                }
            }
            if (n == null || !(n.value(solution.getAssignment()) <= 0.0)) continue;
            return n;
        }
        return null;
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iRBtNSel.getTimeout() / 1000.0) + " seconds reached)");
        }
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public StudentFilter getFilter() {
        return this.iFilter;
    }

    public BacktrackSelection withFilter(StudentFilter filter) {
        this.iFilter = filter;
        return this;
    }
}

