/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.LabelValueBean;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.IdValue;

public class LookupTables {
    public static void setupItypes(HttpServletRequest request, boolean basic) {
        request.setAttribute(ItypeDesc.ITYPE_ATTR_NAME, ItypeDesc.findAll(basic));
    }

    public static void setupExternalDepts(HttpServletRequest request, Long sessionId) throws Exception {
        request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(sessionId));
    }

    public static void setupNonExternalDepts(HttpServletRequest request, Long sessionId) throws Exception {
        request.setAttribute(Department.DEPT_ATTR_NAME, (Object)Department.findAllNonExternal(sessionId));
    }

    public static void setupDepts(HttpServletRequest request, Long sessionId) throws Exception {
        request.setAttribute(Department.DEPT_ATTR_NAME, Department.findAll(sessionId));
    }

    public static void setupDepartments(HttpServletRequest request, SessionContext context, boolean includeExternal) throws Exception {
        TreeSet<Department> departments = Department.getUserDepartments(context.getUser());
        if (includeExternal) {
            departments.addAll(Department.findAllExternal(context.getUser().getCurrentAcademicSessionId()));
        }
        ArrayList<LabelValueBean> deptList = new ArrayList<LabelValueBean>();
        for (Department d : departments) {
            String code = d.getDeptCode().trim();
            String abbv = d.getName().trim();
            if (d.isExternalManager().booleanValue()) {
                deptList.add(new LabelValueBean(code + " - " + abbv + " (" + d.getExternalMgrLabel() + ")", code));
                continue;
            }
            deptList.add(new LabelValueBean(code + " - " + abbv, code));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, deptList);
    }

    public static void setupRooms(HttpServletRequest request, PreferenceGroup pg) throws Exception {
        request.setAttribute(Room.ROOM_LIST_ATTR_NAME, (Object)pg.getAvailableRooms());
    }

    public static void setupBldgs(HttpServletRequest request, PreferenceGroup pg) throws Exception {
        request.setAttribute(Building.BLDG_LIST_ATTR_NAME, (Object)pg.getAvailableBuildings());
    }

    public static void setupPrefLevels(HttpServletRequest request) throws Exception {
        request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, PreferenceLevel.getPreferenceLevelList());
    }

    public static void setupPrefLevelsSoftOnly(HttpServletRequest request) throws Exception {
        request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, PreferenceLevel.getPreferenceLevelListSoftOnly());
    }

    public static void setupRoomFeatures(HttpServletRequest request, PreferenceGroup pg) throws Exception {
        request.setAttribute(RoomFeature.FEATURE_LIST_ATTR_NAME, (Object)pg.getAvailableRoomFeatures());
    }

    public static void setupDistribTypes(HttpServletRequest request, SessionContext context, DistributionType current) throws Exception {
        request.setAttribute(DistributionType.DIST_TYPE_ATTR_NAME, DistributionType.findApplicable(context, false, false, current));
    }

    public static void setupExamDistribTypes(HttpServletRequest request, SessionContext context, DistributionType current) throws Exception {
        request.setAttribute(DistributionType.DIST_TYPE_ATTR_NAME, DistributionType.findApplicable(context, false, true, current));
    }

    public static void setupInstructorDistribTypes(HttpServletRequest request, SessionContext context, PreferenceGroup pg) throws Exception {
        Set<DistributionType> types = DistributionType.findApplicable(context, true, false, null);
        if (pg != null) {
            for (DistributionPref dp : pg.getDistributionPreferences()) {
                if (types.contains(dp.getDistributionType())) continue;
                types.add(dp.getDistributionType());
            }
        }
        request.setAttribute(DistributionType.DIST_TYPE_ATTR_NAME, types);
    }

    public static void setupExaminationPeriods(HttpServletRequest request, Long sessionId, Long examType) throws Exception {
        request.setAttribute(ExamPeriod.PERIOD_ATTR_NAME, ExamPeriod.findAll(sessionId, examType));
    }

    public static void setupRoomGroups(HttpServletRequest request, PreferenceGroup pg) throws Exception {
        request.setAttribute(RoomGroup.GROUP_LIST_ATTR_NAME, (Object)pg.getAvailableRoomGroups());
    }

    public static void setupCourses(HttpServletRequest request, PreferenceGroup pg) throws Exception {
        request.setAttribute("crsOfferingList", (Object)pg.getAvailableCourses());
    }

    public static void setupInstructorAttributes(HttpServletRequest request, PreferenceGroup pg) {
        request.setAttribute(InstructorAttribute.ATTRIBUTES_LIST_ATTR_NAME, (Object)pg.getAvailableAttributes());
    }

    public static void setupInstructorAttributeTypes(HttpServletRequest request, PreferenceGroup pg) {
        request.setAttribute(InstructorAttributeType.ATTRIBUTE_TYPES_LIST_ATTR_NAME, (Object)pg.getAvailableAttributeTypes());
    }

    public static void setupDatePatterns(HttpServletRequest request, UserContext user, String inheritString, DatePattern inheritedDatePattern, Department department, DatePattern currentDatePattern) {
        Vector<IdValue> list = new Vector<IdValue>();
        list.addElement(new IdValue(new Long(-1L), inheritString + (inheritedDatePattern == null ? "" : " (" + inheritedDatePattern.getName() + ")")));
        try {
            for (DatePattern dp : DatePattern.findAll(user, department, currentDatePattern)) {
                list.addElement(new IdValue(dp.getUniqueId(), dp.getName()));
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        request.setAttribute(DatePattern.DATE_PATTERN_LIST_ATTR, list);
    }

    public static void setupDatePatterns(HttpServletRequest request, Session acadSession, boolean includeExtended, String inheritString, DatePattern inheritedDatePattern, Department department, DatePattern currentDatePattern) {
        Vector<IdValue> list = new Vector<IdValue>();
        list.addElement(new IdValue(new Long(-1L), inheritString + (inheritedDatePattern == null ? "" : " (" + inheritedDatePattern.getName() + ")")));
        try {
            for (DatePattern dp : DatePattern.findAll(acadSession, includeExtended, department, currentDatePattern)) {
                list.addElement(new IdValue(dp.getUniqueId(), dp.getName()));
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (inheritedDatePattern == null && list.size() == 1) {
            request.setAttribute(DatePattern.DATE_PATTERN_LIST_ATTR, null);
        } else {
            request.setAttribute(DatePattern.DATE_PATTERN_LIST_ATTR, list);
        }
    }

    public static void setupLearningManagementSystemInfos(HttpServletRequest request, UserContext user, boolean includeExtended, String inheritString, LearningManagementSystemInfo inheritedDatePattern) {
        Vector<IdValue> list = new Vector<IdValue>();
        list.addElement(new IdValue(new Long(-1L), inheritString + (inheritedDatePattern == null ? "" : " (" + inheritedDatePattern.getLabel() + ")")));
        try {
            for (LearningManagementSystemInfo lms : LearningManagementSystemInfo.findAll(user)) {
                list.addElement(new IdValue(lms.getUniqueId(), lms.getLabel()));
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        request.setAttribute(LearningManagementSystemInfo.LEARNING_MANAGEMENT_SYSTEM_LIST_ATTR, list);
    }

    public static void setupInstructors(HttpServletRequest request, SessionContext context, Long deptUid) throws Exception {
        StringBuffer query = new StringBuffer("");
        if (deptUid != null) {
            query.append(" and i.department.uniqueId = " + deptUid);
        }
        LookupTables.getInstructors(request, context, query);
    }

    public static void setupInstructors(HttpServletRequest request, SessionContext context, Long[] deptUids) throws Exception {
        StringBuffer query = new StringBuffer("");
        if (deptUids != null && deptUids.length > 0) {
            query.append(" and i.department.uniqueId in ( " + Constants.arrayToStr(deptUids, "", ", ") + " )");
        }
        LookupTables.getInstructors(request, context, query);
    }

    private static void getInstructors(HttpServletRequest request, SessionContext context, StringBuffer clause) throws Exception {
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        Long acadSessionId = context.getUser().getCurrentAcademicSessionId();
        StringBuffer query = new StringBuffer();
        query.append("select distinct i from DepartmentalInstructor i ");
        query.append(" where i.department.session.uniqueId = :acadSessionId ");
        query.append(clause);
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        org.hibernate.Session hibSession = idao.getSession();
        Query q = hibSession.createQuery(query.toString());
        q.setFetchSize(5000);
        q.setCacheable(true);
        q.setLong("acadSessionId", acadSessionId.longValue());
        List result = q.list();
        Vector<ComboBoxLookup> v = new Vector<ComboBoxLookup>(result.size());
        Vector<Long> h = new Vector<Long>(result.size());
        Collections.sort(result);
        for (DepartmentalInstructor di : result) {
            String name = di.getName(instructorNameFormat);
            v.addElement(new ComboBoxLookup(name, di.getUniqueId().toString()));
            if (!di.hasPreferences()) continue;
            h.add(di.getUniqueId());
        }
        request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME, v);
        request.setAttribute(DepartmentalInstructor.INSTR_HAS_PREF_ATTR_NAME, h);
    }

    public static void setupRoles(HttpServletRequest request) throws Exception {
        request.setAttribute(Roles.ROLES_ATTR_NAME, Roles.findAll(true));
    }

    public static void setupCourseOfferings(HttpServletRequest request, SessionContext context, CourseFilter filter) throws Exception {
        LookupTables.setupCourseOfferings(request, context, filter, "crsOfferingList");
    }

    public static void setupCourseOfferings(HttpServletRequest request, SessionContext context, CourseFilter filter, String attribute) throws Exception {
        ArrayList<CourseOffering> list = new ArrayList<CourseOffering>();
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            for (CourseOffering co : subject.getCourseOfferings()) {
                if (filter != null && !filter.accept(co)) continue;
                list.add(co);
            }
        }
        Collections.sort(list, new CourseOfferingComparator());
        request.setAttribute(attribute, list);
    }

    public static void setupCourseCreditFormats(HttpServletRequest request) throws Exception {
        request.setAttribute(CourseCreditFormat.COURSE_CREDIT_FORMAT_ATTR_NAME, CourseCreditFormat.getCourseCreditFormatList());
    }

    public static void setupCourseCreditTypes(HttpServletRequest request) throws Exception {
        request.setAttribute(CourseCreditType.COURSE_CREDIT_TYPE_ATTR_NAME, CourseCreditType.getCourseCreditTypeList());
    }

    public static void setupCourseCreditUnitTypes(HttpServletRequest request) throws Exception {
        request.setAttribute(CourseCreditUnitType.COURSE_CREDIT_UNIT_TYPE_ATTR_NAME, CourseCreditUnitType.getCourseCreditUnitTypeList());
    }

    public static void setupPositionTypes(HttpServletRequest request) throws Exception {
        request.setAttribute(PositionType.POSTYPE_ATTR_NAME, PositionType.getPositionTypeList());
    }

    public static void setupConsentType(HttpServletRequest request) {
        request.setAttribute(OfferingConsentType.CONSENT_TYPE_ATTR_NAME, OfferingConsentType.getConsentTypeList());
    }

    public static void setupTimetableManagers(HttpServletRequest request) {
        Vector v = new Vector(TimetableManager.getManagerList());
        request.setAttribute(TimetableManager.MGR_LIST_ATTR_NAME, v);
    }

    public static void setupExamTypes(HttpServletRequest request, Long sessionId) {
        request.setAttribute("examTypes", sessionId == null ? ExamType.findAll() : ExamType.findAllUsed(sessionId));
    }

    public static void setupExamTypes(HttpServletRequest request, UserContext user, DepartmentStatusType.Status ... status) {
        request.setAttribute("examTypes", ExamType.findAllUsedApplicable(user, status));
    }

    public static void setupCourseTypes(HttpServletRequest request) {
        request.setAttribute("courseTypes", CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference")));
    }

    public static void setupInstructorTeachingResponsibilities(HttpServletRequest request) {
        request.setAttribute("responsibilities", TeachingResponsibility.getInstructorTeachingResponsibilities());
    }

    public static void setupCoordinatorTeachingResponsibilities(HttpServletRequest request) {
        request.setAttribute("responsibilities", TeachingResponsibility.getCoordinatorTeachingResponsibilities());
    }

    public static interface CourseFilter {
        public boolean accept(CourseOffering var1);
    }
}

