/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class BatchEnrollStudent
extends EnrollStudent {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static AtomicLong sLastGeneratedId = new AtomicLong(-1L);
    public static final String sRequestsChangedStatus = "Modified";

    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Section section;
        if (this.getRequest().getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        StudentSolver solver = (StudentSolver)server;
        if (solver.isPublished()) {
            throw new SectioningException(MSG.exceptionSolverPublished());
        }
        StudentSectioningModel model = (StudentSectioningModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        Student student = null;
        for (Student s : model.getStudents()) {
            if (s.getId() != this.getRequest().getStudentId().longValue()) continue;
            student = s;
            break;
        }
        if (student == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        ArrayList<StudentEnrollmentProvider.EnrollmentFailure> failures = new ArrayList<StudentEnrollmentProvider.EnrollmentFailure>();
        if (solver.getConfig().getPropertyBoolean("Interactive.UpdateCourseRequests", true)) {
            Object adept;
            Iterator i;
            CourseRequest courseRequest;
            Course c;
            FreeTimeRequest f;
            FreeTimeRequest freeTimeRequest;
            TimeLocation time;
            HashSet<Choice> reqChoices;
            Object selChoices;
            ArrayList<Course> courses;
            ArrayList remaining = new ArrayList(student.getRequests());
            int priority = 0;
            Long ts = new Date().getTime();
            boolean changed = false;
            for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                courses = new ArrayList<Course>();
                selChoices = new HashSet();
                reqChoices = new HashSet<Choice>();
                if (r.hasRequestedCourse()) {
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.isFreeTime()) {
                            for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                                time = new TimeLocation(DayCode.toInt(DayCode.toDayCodes(freeTime.getDays())), freeTime.getStart(), freeTime.getLength(), 0, 0.0, Long.valueOf(-1L), "", server.getAcademicSession().getFreeTimePattern(), 0);
                                freeTimeRequest = null;
                                Iterator i2 = remaining.iterator();
                                while (i2.hasNext()) {
                                    Request adept2 = (Request)i2.next();
                                    if (!(adept2 instanceof FreeTimeRequest) || adept2.isAlternative() || !(f = (FreeTimeRequest)adept2).getTime().equals((Object)time)) continue;
                                    freeTimeRequest = f;
                                    i2.remove();
                                    break;
                                }
                                if (freeTimeRequest == null) {
                                    freeTimeRequest = new FreeTimeRequest(sLastGeneratedId.getAndDecrement(), priority, false, student, time);
                                    model.addVariable((Request)freeTimeRequest);
                                    changed = true;
                                    continue;
                                }
                                if (freeTimeRequest.getPriority() == priority) continue;
                                freeTimeRequest.setPriority(priority);
                                changed = true;
                            }
                            ++priority;
                            continue;
                        }
                        if (!rc.isCourse() || (c = this.getCourse(model, rc.getCourseId(), rc.getCourseName())) == null) continue;
                        courses.add(c);
                        if (rc.hasSelectedIntructionalMethods()) {
                            for (Config config : c.getOffering().getConfigs()) {
                                if (config.getInstructionalMethodId() == null || !rc.isSelectedIntructionalMethod(config.getInstructionalMethodId())) continue;
                                (rc.isSelectedIntructionalMethod(config.getInstructionalMethodId(), true) ? reqChoices : selChoices).add(new Choice(config));
                            }
                        }
                        if (!rc.hasSelectedClasses()) continue;
                        for (Config config : c.getOffering().getConfigs()) {
                            for (Subpart subpart : config.getSubparts()) {
                                for (Section section2 : subpart.getSections()) {
                                    if (!rc.isSelectedClass(section2.getId())) continue;
                                    if (rc.isSelectedClass(section2.getId(), true)) {
                                        reqChoices.add(new Choice(section2));
                                        continue;
                                    }
                                    selChoices.add(new Choice(section2));
                                }
                            }
                        }
                    }
                }
                if (courses.isEmpty()) continue;
                courseRequest = null;
                i = remaining.iterator();
                while (i.hasNext()) {
                    CourseRequest courseRequest2;
                    adept = (Request)i.next();
                    if (!(adept instanceof CourseRequest) || adept.isAlternative() || !(courseRequest2 = (CourseRequest)adept).getCourses().equals(courses)) continue;
                    courseRequest = courseRequest2;
                    i.remove();
                    break;
                }
                if (courseRequest == null) {
                    courseRequest = new CourseRequest(sLastGeneratedId.getAndDecrement(), priority, false, student, courses, r.isWaitList(), ts);
                    model.addVariable((Request)courseRequest);
                    changed = true;
                } else {
                    if (courseRequest.getPriority() != priority) {
                        courseRequest.setPriority(priority);
                        changed = true;
                    }
                    if (courseRequest.isWaitlist() != r.isWaitList()) {
                        courseRequest.setWaitlist(r.isWaitList());
                        changed = true;
                    }
                }
                if (!courseRequest.getSelectedChoices().equals(selChoices)) {
                    courseRequest.getSelectedChoices().clear();
                    courseRequest.getSelectedChoices().addAll(selChoices);
                    changed = true;
                }
                if (!courseRequest.getRequiredChoices().equals(reqChoices)) {
                    courseRequest.getRequiredChoices().clear();
                    courseRequest.getRequiredChoices().addAll(reqChoices);
                    changed = true;
                }
                ++priority;
            }
            for (CourseRequestInterface.Request r : this.getRequest().getAlternatives()) {
                courses = new ArrayList();
                selChoices = new HashSet();
                reqChoices = new HashSet();
                if (r.hasRequestedCourse()) {
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.isFreeTime()) {
                            for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                                time = new TimeLocation(DayCode.toInt(DayCode.toDayCodes(freeTime.getDays())), freeTime.getStart(), freeTime.getLength(), 0, 0.0, Long.valueOf(-1L), "", server.getAcademicSession().getFreeTimePattern(), 0);
                                freeTimeRequest = null;
                                Iterator i2 = remaining.iterator();
                                while (i2.hasNext()) {
                                    Request adept2 = (Request)i2.next();
                                    if (!(adept2 instanceof FreeTimeRequest) || !adept2.isAlternative() || !(f = (FreeTimeRequest)adept2).getTime().equals((Object)time)) continue;
                                    freeTimeRequest = f;
                                    i2.remove();
                                    break;
                                }
                                if (freeTimeRequest == null) {
                                    freeTimeRequest = new FreeTimeRequest(sLastGeneratedId.getAndDecrement(), priority, true, student, time);
                                    model.addVariable((Request)freeTimeRequest);
                                    changed = true;
                                    continue;
                                }
                                if (freeTimeRequest.getPriority() == priority) continue;
                                freeTimeRequest.setPriority(priority);
                                changed = true;
                            }
                            ++priority;
                            continue;
                        }
                        if (!rc.isCourse() || (c = this.getCourse(model, rc.getCourseId(), rc.getCourseName())) == null) continue;
                        courses.add(c);
                        if (rc.hasSelectedIntructionalMethods()) {
                            for (Config config : c.getOffering().getConfigs()) {
                                if (config.getInstructionalMethodId() == null || !rc.isSelectedIntructionalMethod(config.getInstructionalMethodId())) continue;
                                (rc.isSelectedIntructionalMethod(config.getInstructionalMethodId(), true) ? reqChoices : selChoices).add(new Choice(config));
                            }
                        }
                        if (!rc.hasSelectedClasses()) continue;
                        for (Config config : c.getOffering().getConfigs()) {
                            for (Subpart subpart : config.getSubparts()) {
                                for (Section section2 : subpart.getSections()) {
                                    if (!rc.isSelectedClass(section2.getId())) continue;
                                    if (rc.isSelectedClass(section2.getId(), true)) {
                                        reqChoices.add(new Choice(section2));
                                        continue;
                                    }
                                    selChoices.add(new Choice(section2));
                                }
                            }
                        }
                    }
                }
                if (courses.isEmpty()) continue;
                courseRequest = null;
                i = remaining.iterator();
                while (i.hasNext()) {
                    CourseRequest courseRequest3;
                    adept = (Request)i.next();
                    if (!(adept instanceof CourseRequest) || !adept.isAlternative() || !(courseRequest3 = (CourseRequest)adept).getCourses().equals(courses)) continue;
                    courseRequest = courseRequest3;
                    i.remove();
                    break;
                }
                if (courseRequest == null) {
                    courseRequest = new CourseRequest(sLastGeneratedId.getAndDecrement(), priority, true, student, courses, r.isWaitList(), ts);
                    model.addVariable((Request)courseRequest);
                    changed = true;
                } else if (courseRequest.getPriority() != priority) {
                    courseRequest.setPriority(priority);
                    changed = true;
                }
                if (!courseRequest.getSelectedChoices().equals(selChoices)) {
                    courseRequest.getSelectedChoices().clear();
                    courseRequest.getSelectedChoices().addAll(selChoices);
                    changed = true;
                }
                if (!courseRequest.getRequiredChoices().equals(reqChoices)) {
                    courseRequest.getRequiredChoices().clear();
                    courseRequest.getRequiredChoices().addAll(reqChoices);
                    changed = true;
                }
                ++priority;
            }
            for (Request request : remaining) {
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment != null) {
                    assignment.unassign(0L, (Variable)request);
                }
                student.getRequests().remove(request);
                model.removeVariable(request);
                changed = true;
            }
            if (changed) {
                Collections.sort(student.getRequests());
                student.setStatus(sRequestsChangedStatus);
            }
        }
        HashMap<CourseRequest, ArrayList<Section>> enrollments = new HashMap<CourseRequest, ArrayList<Section>>();
        for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
            if (a == null || a.getCourseId() == null || a.getClassId() == null) continue;
            CourseRequest request = null;
            Course course = null;
            block21: for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                for (Course c : ((CourseRequest)r).getCourses()) {
                    if (c.getId() != a.getCourseId().longValue()) continue;
                    course = c;
                    request = (CourseRequest)r;
                    break block21;
                }
            }
            if (request == null) {
                XCourse c = server.getCourse(a.getCourseId());
                XOffering offering = server.getOffering(c.getOfferingId());
                failures.add(new StudentEnrollmentProvider.EnrollmentFailure(c, offering.getSection(a.getClassId()), "Adding courses is not supported at the moment.", false));
                continue;
            }
            section = course.getOffering().getSection(a.getClassId().longValue());
            ArrayList<Section> sections = (ArrayList<Section>)enrollments.get(request);
            if (sections == null) {
                sections = new ArrayList<Section>();
                enrollments.put(request, sections);
            }
            sections.add(section);
        }
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
            if (enrollment == null) continue;
            assignment.unassign(0L, (Variable)request);
        }
        for (Request request : student.getRequests()) {
            if (request instanceof CourseRequest) {
                CourseRequest cr = (CourseRequest)request;
                List sections = (List)enrollments.get(cr);
                if (sections == null) continue;
                section = (Section)sections.get(0);
                int pririty = 0;
                Config config = section.getSubpart().getConfig();
                for (int i = 0; i < cr.getCourses().size(); ++i) {
                    if (!((Course)cr.getCourses().get(i)).getOffering().equals((Object)config.getOffering())) continue;
                    pririty = i;
                    break;
                }
                assignment.assign(0L, (Value)new Enrollment((Request)cr, pririty, config, new HashSet(sections), assignment));
                continue;
            }
            FreeTimeRequest ft = (FreeTimeRequest)request;
            Enrollment enrollment = ft.createEnrollment();
            if (model.inConflict(assignment, (Value)enrollment)) continue;
            assignment.assign(0L, (Value)enrollment);
        }
        return server.execute(server.createAction(GetAssignment.class).forStudent(this.getStudentId()).withMessages(failures), helper.getUser());
    }

    protected Course getCourse(StudentSectioningModel model, Long courseId, String courseName) {
        for (Offering offering : model.getOfferings()) {
            for (Course course : offering.getCourses()) {
                if (!(courseId != null ? courseId.equals(course.getId()) : course.getName().equalsIgnoreCase(courseName))) continue;
                return course;
            }
        }
        return null;
    }
}

