/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.AssignedClassesBackend;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.SolutionUnassignedClassesModel;
import org.unitime.timetable.solver.ui.UnassignedClassRow;
import org.unitime.timetable.solver.ui.UnassignedClassesModel;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.NotAssignedClassesRequest.class)
public class NotAssignedClassesBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.NotAssignedClassesRequest, CourseTimetablingSolverInterface.NotAssignedClassesResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.NotAssignedClassesResponse execute(CourseTimetablingSolverInterface.NotAssignedClassesRequest request, SessionContext context) {
        context.checkPermission(Right.NotAssignedClasses);
        CourseTimetablingSolverInterface.NotAssignedClassesResponse response = new CourseTimetablingSolverInterface.NotAssignedClassesResponse();
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        String subjects = request.getFilter().getParameterValue("subjectArea");
        context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(AssignedClassesBackend.isAllSubjects(subjects) ? Constants.ALL_OPTION_VALUE : request.getFilter().getParameterValue("subjectArea")));
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
        if (solver == null) {
            if (solutionIdsStr == null || solutionIdsStr.isEmpty()) {
                for (SolverGroup g : SolverGroup.getUserSolverGroups(context.getUser())) {
                    for (Object id : SolutionDAO.getInstance().getSession().createQuery("select s.uniqueId from Solution s where s.commited = true and s.owner = :groupId").setLong("groupId", g.getUniqueId().longValue()).setCacheable(true).list()) {
                        if (solutionIdsStr == null) {
                            solutionIdsStr = ((Long)id).toString();
                            continue;
                        }
                        solutionIdsStr = solutionIdsStr + (solutionIdsStr.isEmpty() ? "" : ",") + id;
                    }
                }
            }
            if (solutionIdsStr == null || solutionIdsStr.isEmpty()) {
                throw new GwtRpcException(MESSAGES.errorNotAssignedClassesNoSolution());
            }
        }
        UnassignedClassesModel model = null;
        String[] prefixes = null;
        if (!AssignedClassesBackend.isAllSubjects(subjects)) {
            ArrayList<String> list = new ArrayList<String>();
            for (String id : subjects.split(",")) {
                list.add(request.getFilter().getParameter("subjectArea").getOptionText(id) + " ");
            }
            prefixes = list.toArray(new String[list.size()]);
        }
        if (solver != null) {
            model = solver.getUnassignedClassesModel(prefixes);
            response.setShowNote(true);
        } else {
            ArrayList<Solution> solutions = new ArrayList<Solution>();
            Session hibSession = SolutionDAO.getInstance().getSession();
            for (String solutionId : solutionIdsStr.split(",")) {
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                if (solution == null) continue;
                solutions.add(solution);
            }
            if (!solutions.isEmpty()) {
                model = new SolutionUnassignedClassesModel(solutions, hibSession, instructorNameFormat, prefixes);
            }
        }
        if (model != null) {
            Collections.sort(model.rows());
            for (UnassignedClassRow ucr : model.rows()) {
                boolean showClassDetail = solver == null && context.hasPermission(ucr.getId(), "Class_", Right.ClassDetail);
                response.addRow(new TableInterface.TableRowInterface(ucr.getId(), showClassDetail ? "classDetail.do?cid=" + ucr.getId() : "gwt.jsp?page=suggestions&menu=hide&id=" + ucr.getId(), showClassDetail ? null : MESSAGES.dialogSuggestions(), new TableInterface.TableCellClassName(ucr.getName()), new TableInterface.TableCellItems((Collection<String>)ucr.getInstructors()), new TableInterface.TableCellInterface<Integer>(ucr.getNrStudents()), new TableInterface.TableCellText(ucr.getInitial())));
            }
        }
        response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colNrAssignedStudents()), new TableInterface.TableHeaderIterface(MESSAGES.colInitialAssignment()));
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        BackTracker.markForBack(context, "gwt.jsp?page=notAssignedClasses", MESSAGES.pageNotAssignedClasses(), true, true);
        if (ApplicationProperty.TimeGridShowCrosslists.isTrue()) {
            AssignedClassesBackend.addCrosslistedNames(response, ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
        }
        return response;
    }
}

