/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.rooms.TravelTimes;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=TravelTimes.TravelTimesRequest.class)
public class TravelTimesBackend
implements GwtRpcImplementation<TravelTimes.TravelTimesRequest, TravelTimes.TravelTimeResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public TravelTimes.TravelTimeResponse execute(TravelTimes.TravelTimesRequest request, SessionContext context) {
        TravelTimes.TravelTimeResponse response = new TravelTimes.TravelTimeResponse();
        switch (request.getCommand()) {
            case INIT: {
                context.checkPermission(Right.TravelTimesLoad);
                return new TravelTimes.TravelTimeResponse(context.getUser().getCurrentAcademicSessionId(), ((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId())).getLabel());
            }
            case LOAD: {
                context.checkPermission(Right.TravelTimesLoad);
                this.load(context.getUser().getCurrentAcademicSessionId(), request, response);
                break;
            }
            case SAVE: {
                context.checkPermission(Right.TravelTimesSave);
                this.save(context.getUser().getCurrentAcademicSessionId(), request);
            }
        }
        return response;
    }

    protected void load(Long sessionId, TravelTimes.TravelTimesRequest request, TravelTimes.TravelTimeResponse response) {
        DataProperties config = new DataProperties();
        config.setProperty("Distances.Ellipsoid", ApplicationProperty.DistanceEllipsoid.value());
        config.setProperty("Distances.Speed", ApplicationProperty.EventDistanceSpeed.value());
        DistanceMetric metric = new DistanceMetric(config);
        TravelTime.populateTravelTimes(metric, sessionId);
        String ids = "";
        int count = 0;
        if (request.hasRooms()) {
            for (TravelTimes.Room r : request.getRooms()) {
                ids = ids + (ids.isEmpty() ? "" : ",") + r.getId();
                if (++count != 100) continue;
                break;
            }
        }
        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
        TreeSet locations = new TreeSet(hibSession.createQuery("select distinct l from Location l where l.session.uniqueId = :sessionId" + (ids.isEmpty() ? "" : " and l.uniqueId in (" + ids + ")")).setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        List times = hibSession.createQuery("select t from TravelTime t where t.session.uniqueId = :sessionId" + (ids.isEmpty() ? "" : " and t.location1Id in (" + ids + ") and t.location1Id in (" + ids + ")")).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        for (Location location : locations) {
            TravelTimes.Room room = null;
            if (location instanceof Room) {
                Room r = (Room)location;
                room = new TravelTimes.Room(r.getUniqueId(), r.getLabel(), new TravelTimes.Building(r.getBuilding().getUniqueId(), r.getBuilding().getAbbreviation()));
            } else {
                room = new TravelTimes.Room(location.getUniqueId(), location.getLabel());
            }
            for (Location other : locations) {
                if (location.equals(other)) continue;
                if (location.getCoordinateX() != null && location.getCoordinateY() != null && other.getCoordinateX() != null && other.getCoordinateY() != null) {
                    room.setDistance(other.getUniqueId(), (Integer)metric.getDistanceInMinutes(location.getCoordinateX().doubleValue(), location.getCoordinateY().doubleValue(), other.getCoordinateX().doubleValue(), other.getCoordinateY().doubleValue()));
                }
                room.setTravelTime(other.getUniqueId(), metric.getTravelTimeInMinutes(location.getUniqueId(), other.getUniqueId()));
            }
            for (TravelTime t : times) {
                if (t.getLocation1Id().equals(location.getUniqueId())) {
                    room.setTravelTime(t.getLocation2Id(), t.getDistance());
                }
                if (!t.getLocation2Id().equals(location.getUniqueId())) continue;
                room.setTravelTime(t.getLocation1Id(), t.getDistance());
            }
            response.addRoom(room);
            if (response.getRooms().size() < 100) continue;
            break;
        }
    }

    protected void save(Long sessionId, TravelTimes.TravelTimesRequest request) {
        if (!request.hasRooms()) {
            return;
        }
        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
        String ids = "";
        for (TravelTimes.Room r : request.getRooms()) {
            ids = ids + (ids.isEmpty() ? "" : ",") + r.getId();
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        hibSession.createQuery("delete from TravelTime where session.uniqueId = :sessionId" + (ids.isEmpty() ? "" : " and location1Id in (" + ids + ") and location2Id in (" + ids + ")")).setLong("sessionId", sessionId.longValue()).executeUpdate();
        for (TravelTimes.Room room : request.getRooms()) {
            for (TravelTimes.Room other : request.getRooms()) {
                Integer distance;
                if (room.getId().compareTo(other.getId()) >= 0 || (distance = room.getTravelTime(other)) == null) continue;
                TravelTime time = new TravelTime();
                time.setSession(session);
                time.setLocation1Id(room.getId());
                time.setLocation2Id(other.getId());
                time.setDistance(distance);
                hibSession.saveOrUpdate((Object)time);
            }
        }
        hibSession.flush();
    }
}

