/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.model.EnrolledClass;
import org.cpsolver.instructor.model.Preference;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseInstructorAttributePref;
import org.unitime.timetable.model.base.BaseInstructorPref;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructorAttributeTypeDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.instructor.InstructorSchedulingDatabaseLoader;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.util.NameFormat;

public class InstructorSchedulingBackendHelper {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    protected InstructorInterface.CourseInfo getCourse(CourseOffering course) {
        InstructorInterface.CourseInfo info = new InstructorInterface.CourseInfo();
        info.setCourseId(course.getUniqueId());
        info.setCourseName(course.getCourseName());
        return info;
    }

    protected InstructorInterface.SectionInfo getSection(TeachingClassRequest r) {
        Class_ clazz = r.getTeachingClass();
        InstructorInterface.SectionInfo section = new InstructorInterface.SectionInfo();
        CourseOffering course = clazz.getSchedulingSubpart().getControllingCourseOffering();
        String room = null;
        TimeLocation time = null;
        Assignment assignment = clazz.getCommittedAssignment();
        if (assignment != null) {
            time = assignment.getTimeLocation();
            for (Location location : assignment.getRooms()) {
                if (room == null) {
                    room = location.getLabel();
                    continue;
                }
                room = room + ", " + location.getLabel();
            }
        }
        section.setSectionId(clazz.getUniqueId());
        section.setExternalId(InstructorSchedulingDatabaseLoader.getClassExternalId(course, clazz));
        section.setSectionName(clazz.getClassLabel(course));
        section.setSectionType(clazz.getSchedulingSubpart().getItypeDesc().trim());
        section.setCommon(r.isCommon());
        section.setTime(time != null ? time.getDayHeader() + " " + time.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + time.getEndTimeHeader(CONSTANTS.useAmPm()) : null);
        section.setDate(time != null ? time.getDatePatternName() : null);
        section.setRoom(room);
        return section;
    }

    protected InstructorInterface.InstructorInfo getInstructor(InstructorInterface.TeachingRequestInfo request, DepartmentalInstructor instructor, String nameFormat) {
        InstructorInterface.InstructorInfo info = new InstructorInterface.InstructorInfo();
        info.setInstructorId(instructor.getUniqueId());
        info.setInstructorName(instructor.getName(nameFormat));
        info.setExternalId(instructor.getExternalUniqueId());
        info.setMaxLoad(instructor.getMaxLoad() == null ? 0.0f : instructor.getMaxLoad().floatValue());
        if (instructor.getTeachingPreference() == null) {
            info.setTeachingPreference(PreferenceLevel.sProhibited);
        } else {
            info.setTeachingPreference(instructor.getTeachingPreference().getPrefProlog());
        }
        for (InstructorAttribute a : instructor.getAttributes()) {
            InstructorInterface.AttributeInterface attribute = new InstructorInterface.AttributeInterface();
            attribute.setId(a.getUniqueId());
            attribute.setName(a.getCode());
            InstructorInterface.AttributeTypeInterface type = new InstructorInterface.AttributeTypeInterface();
            type.setId(a.getType().getUniqueId());
            type.setLabel(a.getType().getReference());
            type.setConjunctive(a.getType().isConjunctive());
            type.setRequired(a.getType().isRequired());
            attribute.setType(type);
            info.addAttribute(attribute);
        }
        int[][] slot2pref = new int[Constants.NR_DAYS * 288][];
        for (int i = 0; i < slot2pref.length; ++i) {
            slot2pref[i] = new int[]{0, 0, 0};
        }
        for (org.unitime.timetable.model.Preference p : instructor.getPreferences()) {
            if (p instanceof InstructorCoursePref) {
                InstructorCoursePref cp = (InstructorCoursePref)p;
                info.addCoursePreference(new InstructorInterface.PreferenceInfo(cp.getCourse().getUniqueId(), cp.getCourse().getCourseName(), cp.getPrefLevel().getPrefProlog()));
                continue;
            }
            if (p instanceof DistributionPref) {
                DistributionPref dp = (DistributionPref)p;
                info.addDistributionPreference(new InstructorInterface.PreferenceInfo(dp.getDistributionType().getUniqueId(), dp.getDistributionType().getLabel(), dp.getPrefLevel().getPrefProlog()));
                continue;
            }
            if (!(p instanceof TimePref)) continue;
            TimePref tp = (TimePref)p;
            info.setAvailability(tp.getPreference());
            for (Preference<TimeLocation> pf : this.loadTimePreferences((TimePref)p)) {
                InstructorInterface.PreferenceInfo pi = new InstructorInterface.PreferenceInfo(new Long(((TimeLocation)pf.getTarget()).hashCode()), ((TimeLocation)pf.getTarget()).getLongName(CONSTANTS.useAmPm()), Constants.preferenceLevel2preference((int)pf.getPreference()));
                pi.setComparable(String.format("%03d:%05d", ((TimeLocation)pf.getTarget()).getDayCode(), ((TimeLocation)pf.getTarget()).getStartSlot()));
                info.addTimePreference(pi);
                TimeLocation.IntEnumeration i = ((TimeLocation)pf.getTarget()).getSlots();
                while (i.hasMoreElements()) {
                    int slot = (Integer)i.nextElement();
                    slot2pref[slot][0] = Math.min(slot2pref[slot][0], pf.getPreference());
                    slot2pref[slot][1] = Math.max(slot2pref[slot][1], pf.getPreference());
                }
            }
        }
        for (EnrolledClass ec : InstructorSchedulingDatabaseLoader.loadUnavailability(Class_DAO.getInstance().getSession(), instructor)) {
            InstructorInterface.PreferenceInfo pi = new InstructorInterface.PreferenceInfo(ec.getClassId(), ec.getLongName(CONSTANTS.useAmPm()), "P");
            pi.setComparable(String.format("%03d:%05d", ec.getDayCode(), ec.getStartSlot()));
            info.addTimePreference(pi);
            TimeLocation.IntEnumeration i = ec.getSlots();
            while (i.hasMoreElements()) {
                int slot = (Integer)i.nextElement();
                slot2pref[slot][0] = Math.min(slot2pref[slot][0], Constants.sPreferenceLevelProhibited);
                slot2pref[slot][1] = Math.max(slot2pref[slot][1], Constants.sPreferenceLevelProhibited);
                slot2pref[slot][2] = 1;
            }
            InstructorInterface.ClassInfo ci = new InstructorInterface.ClassInfo();
            ci.setCourseId(ec.getCourseId());
            ci.setCourse(ec.getCourse());
            ci.setClassId(ec.getClassId());
            ci.setSection(ec.getSection());
            ci.setExternalId(ec.getExternalId());
            ci.setType(ec.getType());
            ci.setInstructor(ec.isInstructor());
            ci.setRoom(ec.getRoom());
            ci.setTime(ec.getDayHeader() + " " + ec.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + ec.getEndTimeHeader(CONSTANTS.useAmPm()));
            ci.setDate(ec.getDatePatternName());
            info.addEnrollment(ci);
        }
        StringBuffer pattern = new StringBuffer(slot2pref.length);
        for (int i = 0; i < slot2pref.length; ++i) {
            int pref;
            int max = slot2pref[i][1];
            int min = slot2pref[i][0];
            int n = max > -min ? max : (pref = -min > max ? min : max);
            if (slot2pref[i][2] == 1) {
                pattern.append(PreferenceLevel.prolog2char(PreferenceLevel.sNotAvailable));
                continue;
            }
            pattern.append(PreferenceLevel.prolog2char(Constants.preferenceLevel2preference((int)pref)));
        }
        info.setAvailability(pattern.toString());
        return info;
    }

    protected List<Preference<TimeLocation>> loadTimePreferences(TimePref tp) {
        int j;
        int i;
        ArrayList<Preference<TimeLocation>> ret = new ArrayList<Preference<TimeLocation>>();
        TimePatternModel m = tp.getTimePatternModel();
        boolean[][] out = new boolean[m.getNrDays()][m.getNrTimes()];
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                boolean same;
                if (out[i][j]) continue;
                out[i][j] = true;
                if (PreferenceLevel.sNeutral.equals(m.getPreference(i, j))) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < m.getNrTimes() && !out[i][endTime + 1] && m.getPreference(i, endTime + 1).equals(m.getPreference(i, j))) {
                    ++endTime;
                }
                if (i == 0) {
                    same = true;
                    int k = i;
                    while (k + 1 < m.getNrDays()) {
                        for (int x = j; x <= endTime; ++x) {
                            if (!out[k + 1][x] && !m.getPreference(i, x).equals(m.getPreference(k + 1, x))) {
                                same = false;
                                break;
                            }
                            if (!same) break;
                        }
                        if (!same) break;
                        ++k;
                    }
                    if (same) {
                        endDay = m.getNrDays() - 1;
                    }
                }
                while (endDay + 1 < m.getNrDays()) {
                    same = true;
                    for (int x = j; x <= endTime; ++x) {
                        if (out[endDay + 1][x] || m.getPreference(i, x).equals(m.getPreference(endDay + 1, x))) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                int dayCode = 0;
                for (int a = i; a <= endDay; ++a) {
                    dayCode |= m.getDayCode(a);
                }
                TimeLocation time = new TimeLocation(dayCode, m.getStartSlot(j), m.getStartSlot(endTime) - m.getStartSlot(j) + m.getSlotsPerMtg(), 0, 0.0, null, "", null, m.getBreakTime());
                ret.add((Preference<TimeLocation>)new Preference((Object)time, Constants.preference2preferenceLevel((String)m.getPreference(i, j))));
            }
        }
        return ret;
    }

    protected InstructorInterface.TeachingRequestInfo getRequest(TeachingRequest tr, Context context, boolean checkConflicts) {
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        InstructorInterface.TeachingRequestInfo request = new InstructorInterface.TeachingRequestInfo();
        request.setRequestId(tr.getUniqueId());
        request.setNrInstructors(tr.getNbrInstructors());
        request.setCourse(this.getCourse(tr.getOffering().getControllingCourseOffering()));
        ArrayList<TimeLocation> noOverlap = new ArrayList<TimeLocation>();
        for (TeachingClassRequest tcr : new TreeSet<TeachingClassRequest>(tr.getClassRequests())) {
            Assignment assignment;
            request.addSection(this.getSection(tcr));
            if (!checkConflicts || tcr.isCanOverlap().booleanValue() || (assignment = tcr.getTeachingClass().getCommittedAssignment()) == null) continue;
            noOverlap.add(assignment.getTimeLocation());
        }
        request.setLoad(tr.getTeachingLoad().floatValue());
        for (org.unitime.timetable.model.Preference p : tr.getPreferences(InstructorPref.class)) {
            request.addInstructorPreference(new InstructorInterface.PreferenceInfo(((BaseInstructorPref)p).getInstructor().getUniqueId(), ((BaseInstructorPref)p).getInstructor().getName(context.getNameFormat()), p.getPrefLevel().getPrefProlog()));
        }
        for (org.unitime.timetable.model.Preference p : tr.getPreferences(InstructorAttributePref.class)) {
            request.addAttributePreference(new InstructorInterface.PreferenceInfo(((BaseInstructorAttributePref)p).getAttribute().getUniqueId(), ((BaseInstructorAttributePref)p).getAttribute().getName(), p.getPrefLevel().getPrefProlog()));
        }
        int index = 0;
        TreeSet<DepartmentalInstructor> instructors = new TreeSet<DepartmentalInstructor>();
        if (context.getSolver() != null) {
            InstructorInterface.TeachingRequestInfo info = context.getSolver().getTeachingRequestInfo(tr.getUniqueId());
            if (info != null && info.hasInstructors()) {
                for (InstructorInterface.InstructorInfo i : info.getInstructors()) {
                    DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(i.getInstructorId(), hibSession);
                    if (instructor == null) continue;
                    instructors.add(instructor);
                }
            }
        } else {
            instructors.addAll(tr.getAssignedInstructors());
        }
        block4: for (DepartmentalInstructor instructor : instructors) {
            InstructorInterface.InstructorInfo info = this.getInstructor(tr, request, instructor, this.getInstructorAssignments(instructor, null), context);
            if (context.getSolver() != null) {
                InstructorInterface.InstructorInfo i = context.getSolver().getInstructorInfo(instructor.getUniqueId());
                info.setAssignedLoad(i == null ? 0.0f : i.getAssignedLoad());
            } else {
                Number load = (Number)hibSession.createQuery("select sum(r.teachingLoad) from TeachingRequest r inner join r.assignedInstructors i where i.uniqueId = :instructorId").setLong("instructorId", instructor.getUniqueId().longValue()).setCacheable(true).uniqueResult();
                info.setAssignedLoad(load == null ? 0.0f : load.floatValue());
            }
            request.addInstructor(info);
            info.setAssignmentIndex(index++);
            if (!checkConflicts || noOverlap.isEmpty()) continue;
            for (EnrolledClass ec : InstructorSchedulingDatabaseLoader.loadUnavailability(hibSession, instructor)) {
                for (TimeLocation time : noOverlap) {
                    if (!time.hasIntersection((TimeLocation)ec)) continue;
                    info.setConflict(true);
                    continue block4;
                }
            }
        }
        return request;
    }

    public InstructorInterface.InstructorInfo getInstructorInfo(DepartmentalInstructor instructor, Context context) {
        InstructorInterface.InstructorInfo info = new InstructorInterface.InstructorInfo();
        info.setInstructorId(instructor.getUniqueId());
        info.setInstructorName(instructor.getName(context.getNameFormat()));
        info.setExternalId(instructor.getExternalUniqueId());
        info.setMaxLoad(instructor.getMaxLoad() == null ? 0.0f : instructor.getMaxLoad().floatValue());
        for (InstructorAttribute a : instructor.getAttributes()) {
            InstructorInterface.AttributeInterface attributeInterface = new InstructorInterface.AttributeInterface();
            attributeInterface.setId(a.getUniqueId());
            attributeInterface.setName(a.getCode());
            InstructorInterface.AttributeTypeInterface type = new InstructorInterface.AttributeTypeInterface();
            type.setId(a.getType().getUniqueId());
            type.setLabel(a.getType().getReference());
            type.setConjunctive(a.getType().isConjunctive());
            type.setRequired(a.getType().isRequired());
            attributeInterface.setType(type);
            info.addAttribute(attributeInterface);
        }
        int[][] slot2pref = new int[Constants.NR_DAYS * 288][];
        for (int i = 0; i < slot2pref.length; ++i) {
            slot2pref[i] = new int[]{0, 0, 0};
        }
        for (org.unitime.timetable.model.Preference preference : instructor.getPreferences()) {
            if (preference instanceof InstructorCoursePref) {
                InstructorCoursePref cp = (InstructorCoursePref)preference;
                info.addCoursePreference(new InstructorInterface.PreferenceInfo(cp.getCourse().getUniqueId(), cp.getCourse().getCourseName(), cp.getPrefLevel().getPrefProlog()));
                continue;
            }
            if (preference instanceof DistributionPref) {
                DistributionPref dp = (DistributionPref)preference;
                info.addDistributionPreference(new InstructorInterface.PreferenceInfo(dp.getDistributionType().getUniqueId(), dp.getDistributionType().getLabel(), dp.getPrefLevel().getPrefProlog()));
                continue;
            }
            if (!(preference instanceof TimePref)) continue;
            TimePref tp = (TimePref)preference;
            info.setAvailability(tp.getPreference());
            for (Preference<TimeLocation> pf : this.loadTimePreferences((TimePref)preference)) {
                InstructorInterface.PreferenceInfo pi = new InstructorInterface.PreferenceInfo(new Long(-((TimeLocation)pf.getTarget()).hashCode()), ((TimeLocation)pf.getTarget()).getLongName(CONSTANTS.useAmPm()), Constants.preferenceLevel2preference((int)pf.getPreference()));
                pi.setComparable(String.format("%03d:%05d", ((TimeLocation)pf.getTarget()).getDayCode(), ((TimeLocation)pf.getTarget()).getStartSlot()));
                info.addTimePreference(pi);
                TimeLocation.IntEnumeration i = ((TimeLocation)pf.getTarget()).getSlots();
                while (i.hasMoreElements()) {
                    int slot = (Integer)i.nextElement();
                    slot2pref[slot][0] = Math.min(slot2pref[slot][0], pf.getPreference());
                    slot2pref[slot][1] = Math.max(slot2pref[slot][1], pf.getPreference());
                }
            }
        }
        List<EnrolledClass> unavailability = InstructorSchedulingDatabaseLoader.loadUnavailability(Class_DAO.getInstance().getSession(), instructor);
        for (EnrolledClass ec : unavailability) {
            InstructorInterface.PreferenceInfo pi = new InstructorInterface.PreferenceInfo(ec.getClassId(), ec.getLongName(CONSTANTS.useAmPm()), "P");
            pi.setComparable(String.format("%03d:%05d", ec.getDayCode(), ec.getStartSlot()));
            info.addTimePreference(pi);
            TimeLocation.IntEnumeration i = ec.getSlots();
            while (i.hasMoreElements()) {
                int slot = (Integer)i.nextElement();
                slot2pref[slot][0] = Math.min(slot2pref[slot][0], Constants.sPreferenceLevelProhibited);
                slot2pref[slot][1] = Math.max(slot2pref[slot][1], Constants.sPreferenceLevelProhibited);
                slot2pref[slot][2] = 1;
            }
            InstructorInterface.ClassInfo ci = new InstructorInterface.ClassInfo();
            ci.setCourseId(ec.getCourseId());
            ci.setCourse(ec.getCourse());
            ci.setClassId(ec.getClassId());
            ci.setSection(ec.getSection());
            ci.setExternalId(ec.getExternalId());
            ci.setType(ec.getType());
            ci.setInstructor(ec.isInstructor());
            ci.setRoom(ec.getRoom());
            ci.setTime(ec.getDayHeader() + " " + ec.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + ec.getEndTimeHeader(CONSTANTS.useAmPm()));
            ci.setDate(ec.getDatePatternName());
            info.addEnrollment(ci);
        }
        StringBuffer stringBuffer = new StringBuffer(slot2pref.length);
        for (int i = 0; i < slot2pref.length; ++i) {
            int pref;
            int max = slot2pref[i][1];
            int min = slot2pref[i][0];
            int n = max > -min ? max : (pref = -min > max ? min : max);
            if (slot2pref[i][2] == 1) {
                stringBuffer.append(PreferenceLevel.prolog2char(PreferenceLevel.sNotAvailable));
                continue;
            }
            stringBuffer.append(PreferenceLevel.prolog2char(Constants.preferenceLevel2preference((int)pref)));
        }
        info.setAvailability(stringBuffer.toString());
        if (instructor.getTeachingPreference() == null) {
            info.setTeachingPreference(PreferenceLevel.sProhibited);
        } else {
            info.setTeachingPreference(instructor.getTeachingPreference().getPrefProlog());
        }
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        for (TeachingRequest tr : hibSession.createQuery("select r from TeachingRequest r inner join r.assignedInstructors i where i.uniqueId = :instructorId").setLong("instructorId", instructor.getUniqueId().longValue()).setCacheable(true).list()) {
            InstructorInterface.TeachingRequestInfo request;
            if (tr.isCancelled() || (request = this.getRequest(tr, info, context.getNameFormat(), unavailability)) == null) continue;
            if (info.getTeachingPreference() != null && !PreferenceLevel.sNeutral.equals(info.getTeachingPreference())) {
                request.setValue("Teaching Preferences", Constants.preference2preferenceLevel((String)info.getTeachingPreference()));
                info.addValue("Teaching Preferences", Constants.preference2preferenceLevel((String)info.getTeachingPreference()));
            }
            PreferenceCombination timePref = this.getTimePreference(instructor, tr);
            request.setValue("Time Preferences", timePref.getPreferenceInt());
            info.addValue("Time Preferences", timePref.getPreferenceInt());
            String coursePref = this.getCoursePreference(instructor, tr);
            request.setValue("Course Preferences", Constants.preference2preferenceLevel((String)coursePref));
            info.addValue("Course Preferences", Constants.preference2preferenceLevel((String)coursePref));
            String instrPref = this.getInstructorPreference(instructor, tr);
            request.setValue("Instructor Preferences", Constants.preference2preferenceLevel((String)instrPref));
            info.addValue("Instructor Preferences", Constants.preference2preferenceLevel((String)instrPref));
            PreferenceCombination attrPref = this.getAttributePreference(instructor, tr, context.getAttributeTypes());
            request.setValue("Attribute Preferences", attrPref.getPreferenceInt());
            info.addValue("Attribute Preferences", attrPref.getPreferenceInt());
            List<InstructorAssignment> assignments = this.getInstructorAssignments(instructor, null);
            String sameCoursePref = this.getSameCoursePreference(instructor, tr, assignments);
            request.setValue("Same Course", Constants.preference2preferenceLevel((String)sameCoursePref));
            info.addValue("Same Course", Constants.preference2preferenceLevel((String)sameCoursePref));
            String sameCommonPref = this.getSameCommonPreference(instructor, tr, assignments);
            request.setValue("Same Common", Constants.preference2preferenceLevel((String)sameCommonPref));
            info.addValue("Same Common", Constants.preference2preferenceLevel((String)sameCommonPref));
            info.addAssignedRequest(request);
        }
        return info;
    }

    protected InstructorInterface.TeachingRequestInfo getRequest(TeachingRequest tr, InstructorInterface.InstructorInfo instructor, String nameFormat, List<EnrolledClass> unavailability) {
        InstructorInterface.TeachingRequestInfo request = new InstructorInterface.TeachingRequestInfo();
        request.setRequestId(tr.getUniqueId());
        request.setNrInstructors(tr.getNbrInstructors());
        request.setCourse(this.getCourse(tr.getOffering().getControllingCourseOffering()));
        block0: for (TeachingClassRequest tcr : new TreeSet<TeachingClassRequest>(tr.getClassRequests())) {
            Assignment assignment;
            request.addSection(this.getSection(tcr));
            if (unavailability == null || tcr.isCanOverlap().booleanValue() || request.isConflict() || (assignment = tcr.getTeachingClass().getCommittedAssignment()) == null) continue;
            for (EnrolledClass ec : unavailability) {
                if (!ec.hasIntersection(assignment.getTimeLocation())) continue;
                request.setConflict(true);
                continue block0;
            }
        }
        request.setLoad(tr.getTeachingLoad().floatValue());
        instructor.setAssignedLoad(instructor.getAssignedLoad() + request.getLoad());
        return request;
    }

    protected PreferenceCombination getTimePreference(DepartmentalInstructor instructor, TeachingRequest tr) {
        MinMaxPreferenceCombination comb = new MinMaxPreferenceCombination();
        ArrayList<TimeLocation> noOverlap = new ArrayList<TimeLocation>();
        ArrayList<TimeLocation> canOverlap = new ArrayList<TimeLocation>();
        for (TeachingClassRequest tcr : tr.getClassRequests()) {
            Assignment assignment = tcr.getTeachingClass().getCommittedAssignment();
            if (assignment == null) continue;
            if (tcr.isCanOverlap().booleanValue()) {
                canOverlap.add(assignment.getTimeLocation());
                continue;
            }
            noOverlap.add(assignment.getTimeLocation());
        }
        for (TimePref p : instructor.effectivePreferences(TimePref.class)) {
            for (Preference<TimeLocation> pref : this.loadTimePreferences(p)) {
                for (TimeLocation time : noOverlap) {
                    if (!time.hasIntersection((TimeLocation)pref.getTarget())) continue;
                    comb.addPreferenceInt(pref.getPreference());
                }
                for (TimeLocation time : canOverlap) {
                    if (!time.hasIntersection((TimeLocation)pref.getTarget())) continue;
                    comb.addPreferenceInt(pref.isProhibited() ? Constants.sPreferenceLevelStronglyDiscouraged : pref.getPreference());
                }
            }
        }
        for (EnrolledClass ec : InstructorSchedulingDatabaseLoader.loadUnavailability(Class_DAO.getInstance().getSession(), instructor)) {
            for (TimeLocation time : noOverlap) {
                if (!time.hasIntersection((TimeLocation)ec)) continue;
                comb.addPreferenceInt(Constants.sPreferenceLevelProhibited);
            }
            for (TimeLocation time : canOverlap) {
                if (!time.hasIntersection((TimeLocation)ec)) continue;
                comb.addPreferenceInt(Constants.sPreferenceLevelStronglyDiscouraged);
            }
        }
        return comb;
    }

    protected String getCoursePreference(DepartmentalInstructor instructor, TeachingRequest tr) {
        CourseOffering course = tr.getOffering().getControllingCourseOffering();
        boolean hasRequired = false;
        for (InstructorCoursePref p : instructor.effectivePreferences(InstructorCoursePref.class)) {
            if (!p.getPrefLevel().getPrefProlog().equals("R")) continue;
            hasRequired = true;
            break;
        }
        for (InstructorCoursePref p : instructor.effectivePreferences(InstructorCoursePref.class)) {
            if (!p.getCourse().equals(course) || hasRequired && !p.getPrefLevel().getPrefProlog().equals("R")) continue;
            return p.getPrefLevel().getPrefProlog();
        }
        if (hasRequired) {
            return "P";
        }
        return "0";
    }

    protected String getInstructorPreference(DepartmentalInstructor instructor, TeachingRequest tr) {
        boolean hasRequired = false;
        for (InstructorPref p : tr.getPreferences(InstructorPref.class)) {
            if (!p.getPrefLevel().getPrefProlog().equals("R")) continue;
            hasRequired = true;
            break;
        }
        for (InstructorPref p : tr.getPreferences(InstructorPref.class)) {
            if (!p.getInstructor().equals(instructor) || hasRequired && !p.getPrefLevel().getPrefProlog().equals("R")) continue;
            return p.getPrefLevel().getPrefProlog();
        }
        if (hasRequired) {
            return "P";
        }
        return "0";
    }

    protected int getAttributePreference(DepartmentalInstructor instructor, TeachingRequest tr, InstructorAttributeType type) {
        HashSet<InstructorAttribute> attributes = new HashSet<InstructorAttribute>();
        for (InstructorAttribute a : instructor.getAttributes()) {
            if (a.getType().equals(type)) {
                attributes.add(a);
            }
            for (InstructorAttribute p = a.getParentAttribute(); p != null; p = p.getParentAttribute()) {
                if (!p.getType().equals(type)) continue;
                attributes.add(p);
            }
        }
        boolean hasReq = false;
        boolean hasPref = false;
        boolean needReq = false;
        boolean hasType = false;
        SumPreferenceCombination ret = new SumPreferenceCombination();
        for (InstructorAttributePref p : tr.getPreferences(InstructorAttributePref.class)) {
            if (!p.getAttribute().getType().equals(type)) continue;
            InstructorAttribute a = p.getAttribute();
            hasType = true;
            if (p.getPrefLevel().getPrefProlog().equals("R")) {
                needReq = true;
            }
            if (attributes.contains(a)) {
                if (p.getPrefLevel().getPrefProlog().equals("P")) {
                    return Constants.sPreferenceLevelProhibited;
                }
                if (p.getPrefLevel().getPrefProlog().equals("R")) {
                    hasReq = true;
                } else {
                    ret.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
                }
                hasPref = true;
                continue;
            }
            if (!p.getPrefLevel().getPrefProlog().equals("R") || !type.isConjunctive().booleanValue()) continue;
            return Constants.sPreferenceLevelProhibited;
        }
        if (needReq && !hasReq) {
            return Constants.sPreferenceLevelProhibited;
        }
        if (type.isRequired().booleanValue() && hasType && !hasPref) {
            return Constants.sPreferenceLevelProhibited;
        }
        return ret.getPreferenceInt();
    }

    public PreferenceCombination getAttributePreference(DepartmentalInstructor instructor, TeachingRequest tr, List<InstructorAttributeType> attributeTypes) {
        SumPreferenceCombination preference = new SumPreferenceCombination();
        for (InstructorAttributeType type : attributeTypes) {
            preference.addPreferenceInt(this.getAttributePreference(instructor, tr, type));
        }
        return preference;
    }

    public String getSameCoursePreference(DepartmentalInstructor instructor, TeachingRequest tr, List<InstructorAssignment> assignments) {
        if (assignments == null || assignments.size() < 2 || tr.getSameCoursePreference() == null) {
            return PreferenceLevel.sNeutral;
        }
        if (PreferenceLevel.sRequired.equals(tr.getSameCoursePreference().getPrefProlog())) {
            for (InstructorAssignment ia : assignments) {
                if (ia.sameCourse(tr)) continue;
                return PreferenceLevel.sProhibited;
            }
            return PreferenceLevel.sNeutral;
        }
        if (PreferenceLevel.sStronglyPreferred.equals(tr.getSameCoursePreference().getPrefProlog()) || PreferenceLevel.sPreferred.equals(tr.getSameCoursePreference().getPrefProlog())) {
            for (InstructorAssignment ia : assignments) {
                if (ia.sameCourse(tr)) continue;
                return PreferenceLevel.sNeutral;
            }
            return tr.getSameCoursePreference().getPrefProlog();
        }
        for (InstructorAssignment ia : assignments) {
            if (!ia.sameCourse(tr)) continue;
            return tr.getSameCoursePreference().getPrefProlog();
        }
        return PreferenceLevel.sNeutral;
    }

    public String getSameCommonPreference(DepartmentalInstructor instructor, TeachingRequest tr, List<InstructorAssignment> assignments) {
        if (assignments == null || assignments.size() < 2 || tr.getSameCommonPart() == null) {
            return "0";
        }
        if (PreferenceLevel.sRequired.equals(tr.getSameCommonPart().getPrefProlog())) {
            for (InstructorAssignment ia : assignments) {
                if (!ia.sameCourse(tr) || ia.sameCommon(tr)) continue;
                return PreferenceLevel.sProhibited;
            }
            return PreferenceLevel.sNeutral;
        }
        if (PreferenceLevel.sStronglyPreferred.equals(tr.getSameCommonPart().getPrefProlog()) || PreferenceLevel.sPreferred.equals(tr.getSameCommonPart().getPrefProlog())) {
            for (InstructorAssignment ia : assignments) {
                if (!ia.sameCourse(tr) || ia.sameCommon(tr)) continue;
                return PreferenceLevel.sNeutral;
            }
            return tr.getSameCommonPart().getPrefProlog();
        }
        for (InstructorAssignment ia : assignments) {
            if (!ia.sameCourse(tr) || !ia.shareCommon(tr)) continue;
            return tr.getSameCommonPart().getPrefProlog();
        }
        return PreferenceLevel.sNeutral;
    }

    protected boolean canTeach(DepartmentalInstructor instructor, TeachingRequest request, Context context) {
        if (request.isCancelled()) {
            return false;
        }
        if (request.getTeachingLoad().floatValue() > instructor.getMaxLoad().floatValue()) {
            return false;
        }
        PreferenceCombination timePref = this.getTimePreference(instructor, request);
        if (timePref.isProhibited()) {
            return false;
        }
        String coursePref = this.getCoursePreference(instructor, request);
        if ("P".equals(coursePref)) {
            return false;
        }
        String instrPref = this.getInstructorPreference(instructor, request);
        if ("P".equals(instrPref)) {
            return false;
        }
        PreferenceCombination attPref = this.getAttributePreference(instructor, request, context.getAttributeTypes());
        return !attPref.isProhibited();
    }

    protected InstructorInterface.InstructorInfo getInstructor(TeachingRequest tr, InstructorInterface.TeachingRequestInfo request, DepartmentalInstructor instructor, List<InstructorAssignment> assignments, Context context) {
        InstructorInterface.InstructorInfo info = this.getInstructor(request, instructor, context.getNameFormat());
        if (context.getSolver() != null) {
            InstructorInterface.InstructorInfo i = context.getSolver().getInstructorInfo(instructor.getUniqueId());
            info.setAssignedLoad(i == null ? 0.0f : i.getAssignedLoad());
        } else {
            Number load = (Number)TeachingRequestDAO.getInstance().getSession().createQuery("select sum(r.teachingLoad) from TeachingRequest r inner join r.assignedInstructors i where i.uniqueId = :instructorId").setLong("instructorId", instructor.getUniqueId().longValue()).setCacheable(true).uniqueResult();
            info.setAssignedLoad(load == null ? 0.0f : load.floatValue());
        }
        if (info.getTeachingPreference() != null && !PreferenceLevel.sNeutral.equals(info.getTeachingPreference())) {
            info.setValue("Teaching Preferences", Constants.preference2preferenceLevel((String)info.getTeachingPreference()));
        }
        info.setValue("Time Preferences", this.getTimePreference(instructor, tr).getPreferenceInt());
        info.setValue("Course Preferences", Constants.preference2preferenceLevel((String)this.getCoursePreference(instructor, tr)));
        info.setValue("Instructor Preferences", Constants.preference2preferenceLevel((String)this.getInstructorPreference(instructor, tr)));
        info.setValue("Attribute Preferences", this.getAttributePreference(instructor, tr, context.getAttributeTypes()).getPreferenceInt());
        info.setValue("Same Course", Constants.preference2preferenceLevel((String)this.getSameCoursePreference(instructor, tr, assignments)));
        info.setValue("Same Common", Constants.preference2preferenceLevel((String)this.getSameCommonPreference(instructor, tr, assignments)));
        return info;
    }

    public void computeDomainForClass(InstructorInterface.SuggestionsResponse response, TeachingRequest tr, int index, Context context) {
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        ArrayList<DepartmentalInstructor> current = new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
        Collections.sort(current);
        DepartmentalInstructor oldInstructor = index < current.size() ? (DepartmentalInstructor)current.get(index) : null;
        List list = hibSession.createQuery("select distinct i from DepartmentalInstructor i where i.department.uniqueId = :deptId and i.teachingPreference.prefProlog != :prohibited and i.maxLoad > 0.0").setLong("deptId", tr.getOffering().getControllingCourseOffering().getDepartment().getUniqueId().longValue()).setString("prohibited", PreferenceLevel.sProhibited).list();
        Collections.sort(list);
        for (DepartmentalInstructor instructor : list) {
            if (!this.canTeach(instructor, tr, context)) continue;
            Suggestion s = new Suggestion();
            s.set(tr, index, instructor, oldInstructor);
            response.addDomainValue(s.toInfo(context));
        }
    }

    public void computeDomainForInstructor(InstructorInterface.SuggestionsResponse response, DepartmentalInstructor instructor, TeachingRequest selected, Context context) {
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        List requests = hibSession.createQuery("select r from TeachingRequest r inner join r.offering.courseOfferings co where co.isControl = true and co.subjectArea.department.uniqueId = :deptId order by co.subjectAreaAbbv, co.courseNbr").setLong("deptId", instructor.getDepartment().getUniqueId().longValue()).setCacheable(true).list();
        InstructorAssignment selectedAssignment = null;
        if (selected != null) {
            ArrayList<DepartmentalInstructor> assigned = new ArrayList<DepartmentalInstructor>(selected.getAssignedInstructors());
            Collections.sort(assigned);
            int index = assigned.indexOf(instructor);
            if (index >= 0) {
                selectedAssignment = new InstructorAssignment(selected, index, instructor, instructor);
            }
        }
        for (TeachingRequest tr : requests) {
            InstructorInterface.TeachingRequestInfo request;
            if (!this.canTeach(instructor, tr, context) || (request = this.getRequest(tr, context, false)) == null) continue;
            int maxIndex = tr.getNbrInstructors() == 1 ? 1 : tr.getAssignedInstructors().size() + 1;
            ArrayList<DepartmentalInstructor> current = new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
            Collections.sort(current);
            for (int index = 0; index < tr.getNbrInstructors() && index < maxIndex; ++index) {
                Suggestion s = new Suggestion();
                s.set(tr, index, instructor, index < current.size() ? (DepartmentalInstructor)current.get(index) : null);
                response.addDomainValue(s.toInfo(context, selectedAssignment));
            }
        }
    }

    public Context createContext(SessionContext context, InstructorSchedulingProxy solver) {
        return new Context(context, solver);
    }

    public List<InstructorAssignment> getInstructorAssignments(DepartmentalInstructor instructor, List<InstructorAssignment> suggested) {
        ArrayList<InstructorAssignment> ret = new ArrayList<InstructorAssignment>();
        if (suggested != null) {
            for (InstructorAssignment a : suggested) {
                if (!instructor.equals(a.getAssigment())) continue;
                ret.add(a);
            }
        }
        block1: for (TeachingRequest tr : TeachingRequestDAO.getInstance().getSession().createQuery("select distinct r from TeachingRequest r inner join r.assignedInstructors i where i.uniqueId = :instructorId").setLong("instructorId", instructor.getUniqueId().longValue()).setCacheable(true).list()) {
            if (tr.isCancelled()) continue;
            if (suggested != null) {
                for (InstructorAssignment a : suggested) {
                    if (!a.getTeachingRequest().equals(tr) || !instructor.equals(a.getCurrentAssignment())) continue;
                    continue block1;
                }
            }
            ArrayList<DepartmentalInstructor> assignments = new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
            Collections.sort(assignments);
            ret.add(new InstructorAssignment(tr, assignments.indexOf(instructor), instructor, instructor));
        }
        return ret;
    }

    public class Suggestion {
        List<InstructorAssignment> iAssignments = new ArrayList<InstructorAssignment>();

        public void set(TeachingRequest request, int index, DepartmentalInstructor instructor, DepartmentalInstructor oldInstructor) {
            Iterator<InstructorAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                InstructorAssignment other = i.next();
                if (!other.getTeachingRequest().equals(request) || other.getIndex() != index) continue;
                if (instructor != null) {
                    other.setAssignment(instructor);
                } else {
                    i.remove();
                }
                return;
            }
            if (instructor != null) {
                this.iAssignments.add(new InstructorAssignment(request, index, instructor, oldInstructor));
            }
        }

        public List<InstructorAssignment> getAssignments() {
            return this.iAssignments;
        }

        public DepartmentalInstructor getAssignment(TeachingRequest tr, int index) {
            for (InstructorAssignment a : this.iAssignments) {
                if (!a.getTeachingRequest().equals(tr) || a.getIndex() != index) continue;
                return a.getAssigment();
            }
            ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
            Collections.sort(instructors);
            if (index < instructors.size()) {
                return (DepartmentalInstructor)instructors.get(index);
            }
            return null;
        }

        public List<InstructorAssignment> getAssignments(DepartmentalInstructor instructor) {
            if (instructor == null) {
                return null;
            }
            return InstructorSchedulingBackendHelper.this.getInstructorAssignments(instructor, this.getAssignments());
        }

        public void computeConflicts(InstructorAssignment assignment, Set<InstructorAssignment> conflicts, Context context) {
            for (InstructorAssignment instructorAssignment : this.getAssignments(assignment.getAssigment())) {
                if (instructorAssignment.equals(assignment) || conflicts.contains(instructorAssignment) || !instructorAssignment.overlaps(assignment.getTeachingRequest(), context)) continue;
                conflicts.add(instructorAssignment);
            }
            for (InstructorAssignment instructorAssignment : this.getAssignments(assignment.getAssigment())) {
                if (instructorAssignment.equals(assignment) || conflicts.contains(instructorAssignment)) continue;
                if (instructorAssignment.getTeachingRequest().equals(assignment.getTeachingRequest()) && instructorAssignment.getIndex() != assignment.getIndex()) {
                    conflicts.add(instructorAssignment);
                    continue;
                }
                if ((assignment.isSameCourseRequired() || instructorAssignment.isSameCourseRequired()) && !instructorAssignment.sameCourse(assignment.getTeachingRequest())) {
                    conflicts.add(instructorAssignment);
                    continue;
                }
                if ((assignment.isSameCourseProhibited() || instructorAssignment.isSameCourseProhibited()) && instructorAssignment.sameCourse(assignment.getTeachingRequest())) {
                    conflicts.add(instructorAssignment);
                    continue;
                }
                if (!instructorAssignment.sameCourse(assignment.getTeachingRequest())) continue;
                if ((assignment.isSameCommonRequired() || instructorAssignment.isSameCommonRequired()) && !instructorAssignment.sameCommon(assignment.getTeachingRequest())) {
                    conflicts.add(instructorAssignment);
                    continue;
                }
                if (!assignment.isSameCommonProhibited() && !instructorAssignment.isSameCommonProhibited() || !instructorAssignment.shareCommon(assignment.getTeachingRequest())) continue;
                conflicts.add(instructorAssignment);
            }
            float load = assignment.getLoad(context);
            for (InstructorAssignment conflict : conflicts) {
                if (!assignment.getAssigment().equals(conflict.getAssigment())) continue;
                load -= conflict.getLoad(context);
            }
            ArrayList<InstructorAssignment> arrayList = new ArrayList<InstructorAssignment>();
            ArrayList<InstructorAssignment> priority = new ArrayList<InstructorAssignment>();
            for (InstructorAssignment ta : this.getAssignments(assignment.getAssigment())) {
                if (ta.equals(assignment) || conflicts.contains(ta)) continue;
                arrayList.add(ta);
                if (!this.iAssignments.contains(ta)) {
                    priority.add(ta);
                }
                load += ta.getLoad(context);
            }
            while (load > assignment.getAssigment().getMaxLoad().floatValue()) {
                InstructorAssignment conflict;
                if (arrayList.isEmpty()) {
                    conflicts.add(assignment);
                    break;
                }
                if (!priority.isEmpty()) {
                    conflict = (InstructorAssignment)ToolBox.random(priority);
                    load -= conflict.getLoad(context);
                    priority.remove(conflict);
                    arrayList.remove(conflict);
                    conflicts.add(conflict);
                    continue;
                }
                conflict = (InstructorAssignment)ToolBox.random(arrayList);
                load -= conflict.getLoad(context);
                arrayList.remove(conflict);
                conflicts.add(conflict);
            }
        }

        public InstructorInterface.SuggestionInfo toInfo(Context context) {
            return this.toInfo(context, null);
        }

        public InstructorInterface.SuggestionInfo toInfo(Context context, InstructorAssignment selected) {
            if (context.getBase() != null) {
                for (InstructorAssignment a : context.getBase().iAssignments) {
                    if (this.iAssignments.contains(a) || a.getAssigment() == null) continue;
                    this.iAssignments.add(a);
                }
            }
            InstructorInterface.SuggestionInfo si = new InstructorInterface.SuggestionInfo();
            HashSet<InstructorAssignment> conflicts = new HashSet<InstructorAssignment>();
            if (selected != null && !this.iAssignments.contains(selected)) {
                conflicts.add(selected);
            }
            for (InstructorAssignment a : this.iAssignments) {
                this.computeConflicts(a, conflicts, context);
            }
            for (InstructorAssignment a : this.iAssignments) {
                if (conflicts.remove(a)) continue;
                si.addAssignment(a.toInfo(context, this.getAssignments(a.getAssigment())));
            }
            for (InstructorAssignment c : conflicts) {
                si.addAssignment(new InstructorAssignment(c.getTeachingRequest(), c.getIndex(), null).toInfo(context, this.getAssignments(c.getAssigment())));
            }
            for (InstructorInterface.AssignmentInfo ai : si.getAssignments()) {
                if (ai.getInstructor() != null) {
                    for (Map.Entry<String, Double> e : ai.getInstructor().getValues().entrySet()) {
                        si.addValue(e.getKey(), e.getValue());
                    }
                }
                if (ai.getRequest().getInstructor(ai.getIndex()) == null) continue;
                for (Map.Entry<String, Double> e : ai.getRequest().getInstructor(ai.getIndex()).getValues().entrySet()) {
                    si.addValue(e.getKey(), -e.getValue().doubleValue());
                }
            }
            return si;
        }

        public String toString() {
            return this.getAssignments().toString();
        }
    }

    public class InstructorAssignment {
        private TeachingRequest iRequest;
        private int iIndex;
        private DepartmentalInstructor iInstructor;
        private DepartmentalInstructor iOldInstructor;

        InstructorAssignment(TeachingRequest tr, int index, DepartmentalInstructor instructor) {
            this.iRequest = tr;
            this.iIndex = index;
            this.iInstructor = instructor;
            ArrayList<DepartmentalInstructor> current = new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
            Collections.sort(current);
            this.iOldInstructor = index < current.size() ? (DepartmentalInstructor)current.get(index) : null;
        }

        InstructorAssignment(TeachingRequest tr, int index, DepartmentalInstructor instructor, DepartmentalInstructor oldInstructor) {
            this.iRequest = tr;
            this.iIndex = index;
            this.iInstructor = instructor;
            this.iOldInstructor = oldInstructor;
        }

        public TeachingRequest getTeachingRequest() {
            return this.iRequest;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public DepartmentalInstructor getAssigment() {
            return this.iInstructor;
        }

        public DepartmentalInstructor getCurrentAssignment() {
            return this.iOldInstructor;
        }

        public void setAssignment(DepartmentalInstructor instructor) {
            this.iInstructor = instructor;
        }

        public boolean isSameCourseRequired() {
            return this.iRequest.getSameCoursePreference() != null && PreferenceLevel.sRequired.equals(this.iRequest.getSameCoursePreference().getPrefProlog());
        }

        public boolean isSameCourseProhibited() {
            return this.iRequest.getSameCoursePreference() != null && PreferenceLevel.sProhibited.equals(this.iRequest.getSameCoursePreference().getPrefProlog());
        }

        public boolean isSameCommonRequired() {
            return this.iRequest.getSameCommonPart() != null && PreferenceLevel.sRequired.equals(this.iRequest.getSameCommonPart().getPrefProlog());
        }

        public boolean isSameCommonProhibited() {
            return this.iRequest.getSameCommonPart() != null && PreferenceLevel.sProhibited.equals(this.iRequest.getSameCommonPart().getPrefProlog());
        }

        public InstructorInterface.AssignmentInfo toInfo(Context context, List<InstructorAssignment> assignments) {
            InstructorInterface.AssignmentInfo ai = new InstructorInterface.AssignmentInfo();
            ai.setRequest(InstructorSchedulingBackendHelper.this.getRequest(this.getTeachingRequest(), context, false));
            ai.setIndex(this.getIndex());
            if (this.getAssigment() != null) {
                ai.setInstructor(InstructorSchedulingBackendHelper.this.getInstructor(this.getTeachingRequest(), ai.getRequest(), this.getAssigment(), assignments, context));
            }
            return ai;
        }

        private boolean overlaps(TeachingRequest other, Context context) {
            for (TeachingClassRequest c1 : this.getTeachingRequest().getClassRequests()) {
                Assignment a1;
                if (c1.isCanOverlap().booleanValue() || (a1 = c1.getTeachingClass().getCommittedAssignment()) == null) continue;
                for (TeachingClassRequest c2 : other.getClassRequests()) {
                    Assignment a2;
                    if (c2.isCanOverlap().booleanValue() || c1.getTeachingClass().equals(c2.getTeachingClass()) || (a2 = c2.getTeachingClass().getCommittedAssignment()) == null || !a1.getTimeLocation().hasIntersection(a2.getTimeLocation())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean sameCourse(TeachingRequest other) {
            return this.getTeachingRequest().getOffering().equals(other.getOffering());
        }

        private boolean sameCommon(TeachingRequest other) {
            block0: for (TeachingClassRequest c1 : this.getTeachingRequest().getClassRequests()) {
                if (!c1.isCommon().booleanValue()) continue;
                for (TeachingClassRequest c2 : other.getClassRequests()) {
                    if (!c1.getTeachingClass().equals(c2.getTeachingClass())) continue;
                    continue block0;
                }
                return false;
            }
            block2: for (TeachingClassRequest c2 : other.getClassRequests()) {
                if (!c2.isCommon().booleanValue()) continue;
                for (TeachingClassRequest c1 : this.getTeachingRequest().getClassRequests()) {
                    if (!c1.getTeachingClass().equals(c2.getTeachingClass())) continue;
                    continue block2;
                }
                return false;
            }
            return true;
        }

        private boolean shareCommon(TeachingRequest other) {
            for (TeachingClassRequest c1 : this.getTeachingRequest().getClassRequests()) {
                for (TeachingClassRequest c2 : other.getClassRequests()) {
                    if (!c1.isCommon().booleanValue() && !c2.isCommon().booleanValue() || !c1.getTeachingClass().equals(c2.getTeachingClass())) continue;
                    return true;
                }
            }
            return false;
        }

        public float getLoad(Context context) {
            return this.getTeachingRequest().getTeachingLoad().floatValue();
        }

        public int hashCode() {
            return this.getTeachingRequest().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof InstructorAssignment)) {
                return false;
            }
            InstructorAssignment a = (InstructorAssignment)o;
            return this.getTeachingRequest().equals(a.getTeachingRequest()) && this.getIndex() == a.getIndex();
        }

        public String toString() {
            return this.getTeachingRequest() + "/" + this.getIndex() + ": " + (this.getCurrentAssignment() == null ? "" : this.getCurrentAssignment().nameLastNameFirst() + " > ") + (this.getAssigment() == null ? "NULL" : this.getAssigment().nameLastNameFirst());
        }
    }

    public static class Context {
        private String iNameFormat;
        private List<InstructorAttributeType> iAttributeTypes;
        private Suggestion iBase;
        private SessionContext iSessionContext;
        private InstructorSchedulingProxy iSolver;

        Context(SessionContext cx, InstructorSchedulingProxy solver) {
            this.iSessionContext = cx;
            this.iNameFormat = cx == null ? solver.getProperties().getProperty("General.InstructorFormat", NameFormat.LAST_FIRST.reference()) : UserProperty.NameFormat.get(cx.getUser());
            this.iAttributeTypes = InstructorAttributeTypeDAO.getInstance().getSession().createQuery("from InstructorAttributeType").setCacheable(true).list();
            this.iSolver = solver;
        }

        public String getNameFormat() {
            return this.iNameFormat;
        }

        public List<InstructorAttributeType> getAttributeTypes() {
            return this.iAttributeTypes;
        }

        public Suggestion getBase() {
            return this.iBase;
        }

        public void setBase(Suggestion base) {
            this.iBase = base;
        }

        public SessionContext getSessionContext() {
            return this.iSessionContext;
        }

        public InstructorSchedulingProxy getSolver() {
            return this.iSolver;
        }
    }
}

