/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.RefTableEntryDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=SavedHQLInterface.HQLQueriesRpcRequest.class)
public class HQLQueriesBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLQueriesRpcRequest, GwtRpcResponseList<SavedHQLInterface.Query>> {
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public GwtRpcResponseList<SavedHQLInterface.Query> execute(SavedHQLInterface.HQLQueriesRpcRequest request, SessionContext context) {
        SavedHQL.Flag ap = this.getAppearanceFlag(request.getAppearance());
        if (ap.getPermission() != null) {
            this.sessionContext.checkPermission(ap.getPermission());
        }
        GwtRpcResponseList<SavedHQLInterface.Query> ret = new GwtRpcResponseList<SavedHQLInterface.Query>();
        for (SavedHQL hql : SavedHQL.listAll(null, ap, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) {
            SavedHQLInterface.Query query = new SavedHQLInterface.Query();
            query.setName(hql.getName());
            query.setDescription(hql.getDescription());
            query.setQuery(hql.getQuery());
            query.setFlags(hql.getType());
            query.setId(hql.getUniqueId());
            for (SavedHQLParameter p : hql.getParameters()) {
                SavedHQLInterface.Parameter parameter = new SavedHQLInterface.Parameter();
                parameter.setLabel(p.getLabel() == null ? p.getName() : p.getLabel());
                parameter.setName(p.getName());
                parameter.setDefaultValue(p.getDefaultValue());
                parameter.setType(p.getType());
                if (p.getType().startsWith("enum(") && p.getType().endsWith(")")) {
                    for (String string : p.getType().substring("enum(".length(), p.getType().length() - 1).split(",")) {
                        parameter.addOption(string, string);
                    }
                } else if (p.getType().startsWith("reference(") && p.getType().endsWith(")")) {
                    try {
                        String string = p.getType().substring("reference(".length(), p.getType().length() - 1);
                        if ("StudentSectioningStatus".equals(string)) {
                            for (StudentSectioningStatus entry : StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId())) {
                                parameter.addOption(entry.getReference(), entry.getLabel());
                            }
                        }
                        for (RefTableEntry entry : RefTableEntryDAO.getInstance().getSession().createQuery("from " + string).setCacheable(true).list()) {
                            parameter.addOption(entry.getReference(), entry.getLabel());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    for (SavedHQL.Option option : SavedHQL.Option.values()) {
                        Long id;
                        if (!p.getType().equalsIgnoreCase(option.name())) continue;
                        parameter.setMultiSelect(option.allowMultiSelection());
                        for (Map.Entry<Long, String> entry : option.values(context.getUser()).entrySet()) {
                            parameter.addOption(entry.getKey().toString(), entry.getValue());
                        }
                        if (p.getDefaultValue() == null || (id = option.lookupValue(context.getUser(), p.getDefaultValue())) == null) break;
                        parameter.setValue(id.toString());
                        break;
                    }
                }
                query.addParameter(parameter);
            }
            ret.add(query);
        }
        return ret;
    }

    private SavedHQL.Flag getAppearanceFlag(String appearance) {
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (flag.getAppearance() == null || !flag.getAppearance().equalsIgnoreCase(appearance)) continue;
            return flag;
        }
        return SavedHQL.Flag.APPEARANCE_COURSES;
    }
}

