/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.util.Constants;

public class StudentAvailabilityConflicts
implements StudentSectioningReport {
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private StudentSectioningModel iModel = null;
    private TimeOverlapsCounter iTOC = null;

    public StudentAvailabilityConflicts(StudentSectioningModel model) {
        this.iModel = model;
        this.iTOC = model.getTimeOverlaps();
        if (this.iTOC == null) {
            this.iTOC = new TimeOverlapsCounter(null, model.getProperties());
        }
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public boolean shareHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        return e1 > s2 && e2 > s1;
    }

    public boolean inConflict(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (a1.getTime() == null || a2.getTime() == null) {
            return false;
        }
        if (ignoreBreakTimeConflicts) {
            TimeLocation t2;
            TimeLocation t1 = a1.getTime();
            return t1.shareDays(t2 = a2.getTime()) && this.shareHoursIgnoreBreakTime(t1, t2) && t1.shareWeeks(t2);
        }
        return a1.getTime().hasIntersection(a2.getTime());
    }

    public int nrSharedHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int start;
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        int end = Math.min(e1, e2);
        return end < (start = Math.max(s1, s2)) ? 0 : end - start;
    }

    public int share(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (!this.inConflict(a1, a2, ignoreBreakTimeConflicts)) {
            return 0;
        }
        if (ignoreBreakTimeConflicts) {
            return a1.getTime().nrSharedDays(a2.getTime()) * this.nrSharedHoursIgnoreBreakTime(a1.getTime(), a2.getTime());
        }
        return 5 * a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm, boolean includeAllowedOverlaps, boolean ignoreBreakTimeConflicts) {
        CSVFile csv = new CSVFile();
        if (includeAllowedOverlaps) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Student\nId"), new CSVFile.CSVField((Object)"Student\nName"), new CSVFile.CSVField((Object)"Student\nEmail"), new CSVFile.CSVField((Object)"Allowed\nOverlap"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Class"), new CSVFile.CSVField((Object)"Meeting Time"), new CSVFile.CSVField((Object)"Subpart\nOverlap"), new CSVFile.CSVField((Object)"Time\nOverride"), new CSVFile.CSVField((Object)"Conflicting\nAssignment"), new CSVFile.CSVField((Object)"Conflicting\nMeeting Time"), new CSVFile.CSVField((Object)"Teaching\nOverlap"), new CSVFile.CSVField((Object)"Overlap\n[min]")});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Student\nId"), new CSVFile.CSVField((Object)"Student\nName"), new CSVFile.CSVField((Object)"Student\nEmail"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Class"), new CSVFile.CSVField((Object)"Meeting Time"), new CSVFile.CSVField((Object)"Conflicting\nAssignment"), new CSVFile.CSVField((Object)"Conflicting\nMeeting Time"), new CSVFile.CSVField((Object)"Overlap\n[min]")});
        }
        TreeSet<Student> students = new TreeSet<Student>(new Comparator<Student>(){

            @Override
            public int compare(Student s1, Student s2) {
                return s1.getExternalId().compareTo(s2.getExternalId());
            }
        });
        students.addAll(this.getModel().getStudents());
        for (Student student : students) {
            if (student.isDummy() && !includeLastLikeStudents || !student.isDummy() && !includeRealStudents || student.getUnavailabilities().isEmpty()) continue;
            for (Request r : student.getRequests()) {
                Enrollment e = (Enrollment)assignment.getValue((Variable)r);
                if (e == null || r instanceof FreeTimeRequest) continue;
                for (Section s : e.getSections()) {
                    for (Unavailability u : student.getUnavailabilities()) {
                        if (!this.inConflict((SctAssignment)s, (SctAssignment)u, ignoreBreakTimeConflicts) || !includeAllowedOverlaps && (e.isAllowOverlap() || u.isAllowOverlap() || !s.isOverlapping((SctAssignment)u))) continue;
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                        if (dbStudent != null) {
                            line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                        }
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(e.isAllowOverlap() || u.isAllowOverlap() || !s.isOverlapping((SctAssignment)u)));
                        }
                        line.add(new CSVFile.CSVField((Object)e.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(s.getSubpart().getName() + " " + s.getName(e.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(s.getTime() == null ? "" : s.getTime().getDayHeader() + " " + s.getTime().getStartTimeHeader(useAmPm) + " - " + s.getTime().getEndTimeHeader(useAmPm))));
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(s.getSubpart().isAllowOverlap()));
                            line.add(new CSVFile.CSVField(e.getReservation() != null && e.getReservation().isAllowOverlap()));
                        }
                        if (u.getSection().getSubpart() == null) {
                            line.add(new CSVFile.CSVField((Object)u.getSection().getName()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)(u.getSection().getSubpart().getConfig().getOffering().getName() + " " + u.getSection().getSubpart().getName() + " " + u.getSection().getName())));
                        }
                        line.add(new CSVFile.CSVField((Object)(u.getTime() == null ? "" : u.getTime().getDayHeader() + " " + u.getTime().getStartTimeHeader(useAmPm) + " - " + u.getTime().getEndTimeHeader(useAmPm))));
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(u.isAllowOverlap()));
                        }
                        line.add(new CSVFile.CSVField((Object)sDF1.format(this.share((SctAssignment)s, (SctAssignment)u, ignoreBreakTimeConflicts))));
                        csv.addLine(line);
                    }
                }
            }
        }
        return csv;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true), properties.getPropertyBoolean("includeAllowedOverlaps", true), properties.getPropertyBoolean("ignoreBreakTimeConflicts", false));
    }
}

