/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.reports.pointintimedata.WSCHByDepartment;

public class AllWSCHForDepartmentByClass
extends WSCHByDepartment {
    private Long departmentId;

    public AllWSCHForDepartmentByClass() {
        this.getParameters().add(BasePointInTimeDataReports.Parameter.DEPARTMENT);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnSubjectArea());
        hdr.add(MSG.columnCourseNumber());
        hdr.add(MSG.columnItype());
        hdr.add(MSG.columnOrganized());
        hdr.add(MSG.columnSectionNumber());
        hdr.add(MSG.columnExternalId());
        hdr.add(MSG.columnOrganizedWeeklyClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyClassHours());
        hdr.add(MSG.columnWeeklyClassHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        hdr.add(MSG.columnNumberOfClassMeetings());
        this.setHeader(hdr);
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENT).size() == 1) {
            this.setDepartmentId((Long)this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENT).get(0));
        }
    }

    @Override
    public String reportName() {
        return MSG.deptWSCHReportAllHoursForDepartmentByClass();
    }

    @Override
    public String reportDescription() {
        return MSG.deptWSCBReportAllHoursForDepartmentByClassNote();
    }

    @Override
    protected float weeklyClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    protected float weeklyStudentClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    public void createWeeklyStudentContactHoursByDepartmentReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> processedClasses = new HashSet<Long>();
        Department d = (Department)hibSession.createQuery("from Department d where d.uniqueId = :id").setLong("id", this.getDepartmentId().longValue()).setCacheable(true).uniqueResult();
        for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, this.getDepartmentId(), hibSession)) {
            for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                ArrayList<String> row = new ArrayList<String>();
                row.add(d.getDeptCode());
                row.add(d.getAbbreviation());
                row.add(d.getName());
                row.add(pc.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getControllingPitCourseOffering().getSubjectArea().getSubjectAreaAbbreviation());
                row.add(pc.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getControllingPitCourseOffering().getCourseNbr());
                row.add(pc.getPitSchedulingSubpart().getItype().getAbbv());
                row.add(pc.getPitSchedulingSubpart().getItype().getOrganized().toString());
                row.add(pc.getSectionNumber().toString() + (pc.getPitSchedulingSubpart().getSchedulingSubpartSuffixCache().equals("-") ? "" : pc.getPitSchedulingSubpart().getSchedulingSubpartSuffixCache()));
                row.add(pc.getExternalUniqueId());
                row.add(Float.toString(pc.getOrganizedWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm())));
                row.add(Float.toString(pc.getNotOrganizedWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm())));
                row.add(Float.toString(this.weeklyClassHours(pc)));
                row.add(Float.toString(pc.getOrganizedWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm())));
                row.add(Float.toString(pc.getNotOrganizedWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm())));
                row.add(Float.toString(this.weeklyStudentClassHours(pc)));
                int cnt = 0;
                for (PitClassEvent pce : pc.getPitClassEvents()) {
                    cnt += pce.getPitClassMeetings().size();
                }
                row.add(Integer.toString(cnt));
                this.addDataRow(row);
            }
        }
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
}

