/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.commons.Email;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseMeeting;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.reports.PdfLegacyReport;
import org.unitime.timetable.reports.exam.AbbvExamScheduleByCourseReport;
import org.unitime.timetable.reports.exam.AbbvScheduleByCourseReport;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndInstructorReport;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndStudentReport;
import org.unitime.timetable.reports.exam.ExamPeriodChartReport;
import org.unitime.timetable.reports.exam.ExamScheduleByPeriodReport;
import org.unitime.timetable.reports.exam.ExamVerificationReport;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PeriodChartReport;
import org.unitime.timetable.reports.exam.ScheduleByCourseReport;
import org.unitime.timetable.reports.exam.ScheduleByPeriodReport;
import org.unitime.timetable.reports.exam.ScheduleByRoomReport;
import org.unitime.timetable.reports.exam.StudentExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;

public abstract class PdfLegacyExamReport
extends PdfLegacyReport {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Logger sLog = Logger.getLogger(PdfLegacyExamReport.class);
    public static Hashtable<String, Class> sRegisteredReports = new Hashtable();
    public static String sAllRegisteredReports = "";
    private Collection<ExamAssignmentInfo> iExams = null;
    private Session iSession = null;
    private Collection<SubjectArea> iSubjectAreas = null;
    private ExamType iExamType = null;
    protected boolean iDispRooms = true;
    protected String iNoRoom = "";
    protected boolean iDirect = true;
    protected boolean iM2d = true;
    protected boolean iBtb = false;
    protected int iLimit = -1;
    protected boolean iItype = false;
    protected boolean iClassSchedule = false;
    protected Hashtable<String, String> iRoomCodes = new Hashtable();
    protected String iRC = null;
    protected boolean iTotals = true;
    protected boolean iUseClassSuffix = false;
    protected boolean iDispLimits = true;
    protected Date iSince = null;
    protected boolean iExternal = false;
    protected boolean iDispFullTermDates = false;
    protected boolean iFullTermCheckDatePattern = true;
    protected boolean iMeetingTimeUseEvents = false;
    protected boolean iDispNote = false;
    protected boolean iCompact = false;
    protected boolean iRoomDisplayNames = false;
    protected static DecimalFormat sDF = new DecimalFormat("0.0");
    protected boolean iSubjectPrinted = false;
    protected boolean iITypePrinted = false;
    protected boolean iConfigPrinted = false;
    protected boolean iCoursePrinted = false;
    protected boolean iStudentPrinted = false;
    protected boolean iPeriodPrinted = false;
    protected boolean iNewPage = false;
    public static String[] DAY_NAMES_SHORT;
    private Date iSessionFirstDate = null;

    public PdfLegacyExamReport(int mode, File file, String title, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws DocumentException, IOException {
        this(mode, file == null ? null : new FileOutputStream(file), title, session, examType, subjectAreas, exams);
    }

    public PdfLegacyExamReport(int mode, OutputStream out, String title, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws DocumentException, IOException {
        super(mode, out, title, ApplicationProperty.ExaminationPdfReportTitle.value(examType == null ? "all" : examType.getReference(), examType == null ? "EXAMINATIONS" : examType.getLabel().toUpperCase() + " EXAMINATIONS"), title + " -- " + session.getLabel(), session.getLabel());
        if (subjectAreas != null && subjectAreas.size() == 1) {
            this.setFooter(subjectAreas.iterator().next().getSubjectAreaAbbreviation());
        }
        this.iExams = exams;
        this.iSession = session;
        this.iExamType = examType;
        this.iSubjectAreas = subjectAreas;
        this.iDispRooms = "true".equals(System.getProperty("room", "true"));
        this.iDispNote = "true".equals(System.getProperty("note", "false"));
        this.iCompact = "true".equals(System.getProperty("compact", "false"));
        this.iNoRoom = System.getProperty("noroom", ApplicationProperty.ExaminationsNoRoomText.value());
        this.iDirect = "true".equals(System.getProperty("direct", "true"));
        this.iM2d = "true".equals(System.getProperty("m2d", examType == null || examType.getType() == 0 ? "true" : "false"));
        this.iBtb = "true".equals(System.getProperty("btb", "false"));
        this.iLimit = Integer.parseInt(System.getProperty("limit", "-1"));
        this.iItype = "true".equals(System.getProperty("itype", ApplicationProperty.ExaminationReportsShowInstructionalType.value()));
        this.iTotals = "true".equals(System.getProperty("totals", "true"));
        this.iUseClassSuffix = "true".equals(System.getProperty("suffix", ApplicationProperty.ExaminationReportsClassSufix.value()));
        this.iExternal = ApplicationProperty.ExaminationReportsExternalId.isTrue();
        this.iDispLimits = "true".equals(System.getProperty("verlimit", "true"));
        this.iClassSchedule = "true".equals(System.getProperty("cschedule", ApplicationProperty.ExaminationPdfReportsIncludeClassSchedule.value()));
        this.iDispFullTermDates = "true".equals(System.getProperty("fullterm", "false"));
        this.iRoomDisplayNames = "true".equals(System.getProperty("roomDispNames", "true"));
        this.iFullTermCheckDatePattern = ApplicationProperty.ExaminationPdfReportsFullTermCheckDatePattern.isTrue();
        this.iMeetingTimeUseEvents = ApplicationProperty.ExaminationPdfReportsUseEventsForMeetingTimes.isTrue();
        if (System.getProperty("since") != null) {
            try {
                this.iSince = new SimpleDateFormat(System.getProperty("sinceFormat", "MM/dd/yy")).parse(System.getProperty("since"));
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to parse date " + System.getProperty("since") + ", reason: " + e.getMessage()));
            }
        }
        this.setRoomCode(System.getProperty("roomcode", ApplicationProperty.ExaminationRoomCode.value()));
    }

    public void setDispRooms(boolean dispRooms) {
        this.iDispRooms = dispRooms;
    }

    public void setNoRoom(String noRoom) {
        this.iNoRoom = noRoom;
    }

    public void setDirect(boolean direct) {
        this.iDirect = direct;
    }

    public void setM2d(boolean m2d) {
        this.iM2d = m2d;
    }

    public void setBtb(boolean btb) {
        this.iBtb = btb;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public void setItype(boolean itype) {
        this.iItype = itype;
    }

    public void setTotals(boolean totals) {
        this.iTotals = totals;
    }

    public void setUseClassSuffix(boolean useClassSuffix) {
        this.iUseClassSuffix = true;
    }

    public void setDispLimits(boolean dispLimits) {
        this.iDispLimits = dispLimits;
    }

    public void setClassSchedule(boolean classSchedule) {
        this.iClassSchedule = classSchedule;
    }

    public void setSince(Date since) {
        this.iSince = since;
    }

    public void setDispFullTermDates(boolean dispFullTermDates) {
        this.iDispFullTermDates = dispFullTermDates;
    }

    public void setUseRoomDisplayNames(boolean roomDispNames) {
        this.iRoomDisplayNames = roomDispNames;
    }

    public void setRoomCode(String roomCode) {
        if (roomCode == null || roomCode.length() == 0) {
            this.iRoomCodes = null;
            this.iRC = null;
            return;
        }
        this.iRoomCodes = new Hashtable();
        this.iRC = "";
        StringTokenizer s = new StringTokenizer(roomCode, ":;,=");
        while (s.hasMoreTokens()) {
            String room = s.nextToken();
            String code = s.hasMoreTokens() ? s.nextToken() : "#";
            this.iRoomCodes.put(room, code);
            if (this.iRC.length() > 0) {
                this.iRC = this.iRC + ", ";
            }
            this.iRC = this.iRC + code + ":" + room;
        }
    }

    public void setDispNote(boolean dispNote) {
        this.iDispNote = dispNote;
    }

    public void setCompact(boolean compact) {
        this.iCompact = compact;
    }

    public Collection<ExamAssignmentInfo> getExams() {
        return this.iExams;
    }

    public Session getSession() {
        return this.iSession;
    }

    public ExamType getExamType() {
        return this.iExamType;
    }

    public boolean hasSubjectArea(String abbv) {
        if (this.iSubjectAreas == null) {
            return true;
        }
        for (SubjectArea area : this.iSubjectAreas) {
            if (!area.getSubjectAreaAbbreviation().equals(abbv)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubjectArea(SubjectArea subject) {
        return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
    }

    public boolean hasSubjectArea(ExamInfo exam) {
        for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
            if (!this.hasSubjectArea(section)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubjectArea(ExamInfo.ExamSectionInfo section) {
        return this.hasSubjectArea(section.getSubject());
    }

    public boolean hasSubjectAreas() {
        return this.iSubjectAreas != null;
    }

    public Collection<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public abstract void printReport() throws DocumentException;

    @Override
    protected void headerPrinted() {
        this.iSubjectPrinted = false;
        this.iCoursePrinted = false;
        this.iStudentPrinted = false;
        this.iPeriodPrinted = false;
        this.iITypePrinted = false;
        this.iConfigPrinted = false;
        this.iNewPage = true;
    }

    @Override
    protected void println(String text) throws DocumentException {
        this.iNewPage = false;
        super.println(text);
    }

    public int getDaysCode(Set meetings) {
        int daysCode = 0;
        for (Meeting meeting : meetings) {
            Calendar date = Calendar.getInstance(Locale.US);
            date.setTime(meeting.getMeetingDate());
            switch (date.get(7)) {
                case 2: {
                    daysCode |= Constants.DAY_CODES[0];
                    break;
                }
                case 3: {
                    daysCode |= Constants.DAY_CODES[1];
                    break;
                }
                case 4: {
                    daysCode |= Constants.DAY_CODES[2];
                    break;
                }
                case 5: {
                    daysCode |= Constants.DAY_CODES[3];
                    break;
                }
                case 6: {
                    daysCode |= Constants.DAY_CODES[4];
                    break;
                }
                case 7: {
                    daysCode |= Constants.DAY_CODES[5];
                    break;
                }
                case 1: {
                    daysCode |= Constants.DAY_CODES[6];
                }
            }
        }
        return daysCode;
    }

    public String getMeetingDate(Event.MultiMeeting m) {
        if (m.getMeetings().isEmpty()) {
            return "ARRANGED HOURS";
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd");
        return df.format(m.getMeetings().first().getMeetingDate()) + " - " + df.format(m.getMeetings().last().getMeetingDate()) + " " + m.getDays(DAY_NAMES_SHORT, DAY_NAMES_SHORT);
    }

    public boolean isFullTerm(DatePattern dp, Date[] firstLast) {
        if (this.iFullTermCheckDatePattern && dp != null) {
            return dp.isDefault();
        }
        if (firstLast != null) {
            Date first = firstLast[0];
            Date last = firstLast[1];
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(this.getSession().getSessionBeginDateTime());
            c.add(3, 2);
            if (first.compareTo(c.getTime()) >= 0) {
                return false;
            }
            c.setTime(this.getSession().getClassesEndDateTime());
            c.add(3, -2);
            return last.compareTo(c.getTime()) > 0;
        }
        return false;
    }

    public boolean isFullTerm(ClassEvent classEvent) {
        DatePattern dp;
        if (this.iFullTermCheckDatePattern && (dp = classEvent.getClazz().effectiveDatePattern()) != null) {
            return dp.isDefault();
        }
        if (classEvent != null && !classEvent.getMeetings().isEmpty()) {
            Date first = null;
            Date last = null;
            for (Meeting m : classEvent.getMeetings()) {
                if (first == null || first.compareTo(m.getMeetingDate()) > 0) {
                    first = m.getMeetingDate();
                }
                if (last != null && last.compareTo(m.getMeetingDate()) >= 0) continue;
                last = m.getMeetingDate();
            }
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(this.getSession().getSessionBeginDateTime());
            c.add(3, 2);
            if (first.compareTo(c.getTime()) >= 0) {
                return false;
            }
            c.setTime(this.getSession().getClassesEndDateTime());
            c.add(3, -2);
            return last.compareTo(c.getTime()) > 0;
        }
        return false;
    }

    protected String getMeetingTime(ExamInfo.ExamSectionInfo section) {
        if (section.getOwner().getOwnerObject() instanceof Class_) {
            Assignment assignment;
            Date[] firstLast;
            SimpleDateFormat dpf = new SimpleDateFormat("MM/dd");
            Class_ clazz = (Class_)section.getOwner().getOwnerObject();
            if (this.iMeetingTimeUseEvents) {
                Set<Meeting> meetings;
                Set<Meeting> set = meetings = clazz.getCachedEvent() == null ? null : clazz.getCachedEvent().getMeetings();
                if (meetings != null && !meetings.isEmpty()) {
                    int dayCode = this.getDaysCode(meetings);
                    String days = "";
                    for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                        if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                        days = days + DAY_NAMES_SHORT[i];
                    }
                    String meetingTime = this.rpad(days, 5);
                    Meeting[] firstLastMeeting = this.firstLastMeeting(clazz.getCachedEvent());
                    meetingTime = meetingTime + " " + this.lpad(firstLastMeeting[0].startTime(), 6) + " - " + this.lpad(firstLastMeeting[0].stopTime(), 6) + " ";
                    Date first = firstLastMeeting[0].getMeetingDate();
                    Date last = firstLastMeeting[1].getMeetingDate();
                    meetingTime = !this.iDispFullTermDates && this.isFullTerm(clazz.getEvent()) ? meetingTime + this.rpad("", 14) : meetingTime + dpf.format(first) + " - " + dpf.format(last);
                    return meetingTime;
                }
            }
            Date[] dateArray = firstLast = (assignment = clazz.getCommittedAssignment()) == null ? null : this.firstLastDate(assignment.getTimeLocation());
            if (assignment != null) {
                TimeLocation t = assignment.getTimeLocation();
                String meetingTime = this.rpad(t.getDayHeader(), 5) + " " + this.lpad(t.getStartTimeHeader(CONSTANTS.useAmPm()), 6) + " - " + this.lpad(t.getEndTimeHeader(CONSTANTS.useAmPm()), 6) + " ";
                meetingTime = !this.iDispFullTermDates && this.isFullTerm(assignment.getDatePattern(), firstLast) ? meetingTime + this.rpad("", 14) : (firstLast != null ? meetingTime + dpf.format(firstLast[0]) + " - " + dpf.format(firstLast[1]) : meetingTime + this.rpad(t.getDatePatternName(), 14));
                return meetingTime;
            }
        }
        return this.rpad("", 36);
    }

    private Meeting[] firstLastMeeting(ClassEvent event) {
        if (event == null) {
            return null;
        }
        BaseMeeting first = null;
        BaseMeeting last = null;
        for (Meeting m : event.getMeetings()) {
            if (first == null || first.getMeetingDate().after(m.getMeetingDate())) {
                first = m;
            }
            if (last != null && !last.getMeetingDate().before(m.getMeetingDate())) continue;
            last = m;
        }
        if (first == null) {
            return null;
        }
        return new Meeting[]{first, last};
    }

    private Date[] firstLastDate(TimeLocation time) {
        int idx;
        if (time == null || time.getWeekCode().isEmpty()) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        if (this.iSessionFirstDate == null) {
            this.iSessionFirstDate = DateUtils.getDate(1, this.iSession.getPatternStartMonth(), this.iSession.getSessionStartYear());
        }
        cal.setTime(this.iSessionFirstDate);
        cal.add(6, idx);
        Date first = null;
        for (idx = time.getWeekCode().nextSetBit(0); idx < time.getWeekCode().size() && first == null; ++idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & Constants.DAY_CODES[0]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & Constants.DAY_CODES[1]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & Constants.DAY_CODES[2]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & Constants.DAY_CODES[3]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & Constants.DAY_CODES[4]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & Constants.DAY_CODES[5]) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & Constants.DAY_CODES[6]) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return null;
        }
        cal.setTime(this.iSessionFirstDate);
        cal.add(6, idx);
        Date last = null;
        for (idx = time.getWeekCode().length() - 1; idx >= 0 && last == null; --idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & Constants.DAY_CODES[0]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & Constants.DAY_CODES[1]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & Constants.DAY_CODES[2]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & Constants.DAY_CODES[3]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & Constants.DAY_CODES[4]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & Constants.DAY_CODES[5]) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & Constants.DAY_CODES[6]) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return null;
        }
        return new Date[]{first, last};
    }

    protected String getMeetingTime(Meeting meeting) {
        return this.lpad(meeting.startTime(), 6) + " - " + this.lpad(meeting.stopTime(), 6);
    }

    protected String getMeetingTime(String time) {
        int idx = time.indexOf(45);
        if (idx < 0) {
            return this.lpad(time, 15);
        }
        String start = time.substring(0, idx).trim();
        String stop = time.substring(idx + 1).trim();
        return this.lpad(start, '0', 6) + " - " + this.lpad(stop, '0', 6);
    }

    public String formatRoom(String room) {
        String r = room.trim();
        int idx = r.lastIndexOf(32);
        if (idx >= 0 && idx <= 5 && r.length() - idx - 1 <= 5) {
            return this.rpad(r.substring(0, idx), 5) + " " + this.rpad(r.substring(idx + 1), 5);
        }
        return this.rpad(r, 11);
    }

    public String formatRoom(ExamRoomInfo roomInfo) {
        if (roomInfo == null) {
            return this.rpad("", 11);
        }
        if (this.iRoomDisplayNames) {
            String dispName;
            Location location = roomInfo.getLocation();
            String string = dispName = location == null ? null : location.getDisplayName();
            if (dispName != null && !dispName.isEmpty()) {
                return this.rpad(dispName, 11);
            }
        }
        return this.formatRoom(roomInfo.getName());
    }

    public String formatRoom(Location location) {
        String dispName;
        if (location == null) {
            return this.rpad("", 11);
        }
        if (this.iRoomDisplayNames && (dispName = location.getDisplayName()) != null && !dispName.isEmpty()) {
            return this.rpad(dispName, 11);
        }
        return this.formatRoom(location.getLabel());
    }

    public String formatPeriod(ExamPeriod period) {
        return period.getStartDateLabel() + " " + this.lpad(period.getStartTimeLabel(), 6) + " - " + this.lpad(period.getEndTimeLabel(), 6);
    }

    public String formatPeriod(ExamPeriod period, int length, Integer printOffset) {
        return period.getStartDateLabel() + " " + this.lpad(period.getStartTimeLabel(printOffset == null ? 0 : printOffset), 6) + " - " + this.lpad(period.getEndTimeLabel(length, printOffset == null ? 0 : printOffset), 6);
    }

    public String formatPeriod(ExamAssignment assignment) {
        return assignment.getPeriod().getStartDateLabel() + " " + this.lpad(assignment.getPeriod().getStartTimeLabel(assignment.getPrintOffset()), 6) + " - " + this.lpad(assignment.getPeriod().getEndTimeLabel(assignment.getLength(), assignment.getPrintOffset()), 6);
    }

    public String getShortDate(Date date) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(date);
        String day = "";
        switch (c.get(7)) {
            case 2: {
                day = DAY_NAMES_SHORT[0];
                break;
            }
            case 3: {
                day = DAY_NAMES_SHORT[1];
                break;
            }
            case 4: {
                day = DAY_NAMES_SHORT[2];
                break;
            }
            case 5: {
                day = DAY_NAMES_SHORT[3];
                break;
            }
            case 6: {
                day = DAY_NAMES_SHORT[4];
                break;
            }
            case 7: {
                day = DAY_NAMES_SHORT[5];
                break;
            }
            case 1: {
                day = DAY_NAMES_SHORT[6];
            }
        }
        return day + " " + new SimpleDateFormat("MM/dd").format(date);
    }

    public String formatShortPeriod(ExamPeriod period, int length, Integer printOffset) {
        return this.getShortDate(period.getStartDate()) + " " + this.lpad(period.getStartTimeLabel(printOffset == null ? 0 : printOffset), 6) + "-" + this.lpad(period.getEndTimeLabel(length, printOffset == null ? 0 : printOffset), 6);
    }

    public String formatShortPeriod(ExamAssignment assignment) {
        return this.getShortDate(assignment.getPeriod().getStartDate()) + " " + this.lpad(assignment.getPeriod().getStartTimeLabel(assignment.getPrintOffset()), 6) + "-" + this.lpad(assignment.getPeriod().getEndTimeLabel(assignment.getLength(), assignment.getPrintOffset()), 6);
    }

    public String formatShortPeriodNoEndTime(ExamAssignment assignment) {
        return this.getShortDate(assignment.getPeriod().getStartDate()) + " " + this.lpad(assignment.getPeriod().getStartTimeLabel(assignment.getPrintOffset()), 6);
    }

    public String getItype(CourseOffering course, Class_ clazz) {
        if (this.iExternal) {
            String ext = clazz.getExternalId(course);
            return ext == null ? "" : ext;
        }
        return clazz.getSchedulingSubpart().getItypeDesc();
    }

    public static void sendEmails(String prefix, Hashtable<String, File> output, Hashtable<SubjectArea, Hashtable<String, File>> outputPerSubject, Hashtable<ExamInfo.ExamInstructorInfo, File> ireports, Hashtable<Student, File> sreports) {
        String email;
        File report;
        Object s;
        String url;
        String message;
        sLog.info((Object)"Sending email(s)...");
        if (!outputPerSubject.isEmpty() && "true".equals(System.getProperty("email.deputies", "false"))) {
            Hashtable files2send = new Hashtable();
            for (Map.Entry<SubjectArea, Hashtable<String, File>> entry : outputPerSubject.entrySet()) {
                if (entry.getKey().getDepartment().getTimetableManagers().isEmpty()) {
                    sLog.warn((Object)("No manager associated with subject area " + entry.getKey().getSubjectAreaAbbreviation() + " (" + entry.getKey().getDepartment().getLabel() + ")</font>"));
                }
                for (TimetableManager timetableManager : entry.getKey().getDepartment().getTimetableManagers()) {
                    if (timetableManager.getEmailAddress() == null || timetableManager.getEmailAddress().length() == 0) {
                        sLog.warn((Object)("Manager " + timetableManager.getName() + " has no email address."));
                        continue;
                    }
                    Hashtable files = (Hashtable)files2send.get(timetableManager);
                    if (files == null) {
                        files = new Hashtable();
                        files2send.put(timetableManager, files);
                    }
                    files.putAll(entry.getValue());
                }
            }
            if (files2send.isEmpty()) {
                sLog.error((Object)"Nothing to send.");
            } else {
                Set managers = files2send.keySet();
                while (!managers.isEmpty()) {
                    TimetableManager manager = (TimetableManager)managers.iterator().next();
                    Hashtable files = (Hashtable)files2send.get(manager);
                    managers.remove(manager);
                    sLog.info((Object)("Sending email to " + manager.getName() + " (" + manager.getEmailAddress() + ")..."));
                    try {
                        Email email2 = Email.createEmail();
                        email2.setSubject(System.getProperty("email.subject", "Examination Report"));
                        message = System.getProperty("email.body");
                        url = System.getProperty("email.url");
                        email2.setText((message == null ? "" : message + "\r\n\r\n") + (url == null ? "" : "For an up-to-date examination report, please visit " + url + "/\r\n\r\n") + "This email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                        email2.addRecipient(manager.getEmailAddress(), manager.getName());
                        Iterator i = managers.iterator();
                        while (i.hasNext()) {
                            TimetableManager timetableManager = (TimetableManager)i.next();
                            if (!files.equals(files2send.get(timetableManager))) continue;
                            sLog.info((Object)("  Including " + timetableManager.getName() + " (" + timetableManager.getEmailAddress() + ")"));
                            email2.addRecipient(timetableManager.getEmailAddress(), timetableManager.getName());
                            i.remove();
                        }
                        if (System.getProperty("email.to") != null) {
                            s = new StringTokenizer(System.getProperty("email.to"), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                email2.addRecipient(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (System.getProperty("email.cc") != null) {
                            s = new StringTokenizer(System.getProperty("email.cc"), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                email2.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (System.getProperty("email.bcc") != null) {
                            s = new StringTokenizer(System.getProperty("email.bcc"), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                email2.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        for (Map.Entry entry : files.entrySet()) {
                            email2.addAttachment((File)entry.getValue(), prefix + "_" + (String)entry.getKey());
                            sLog.info((Object)("  Attaching <a href='temp/" + ((File)entry.getValue()).getName() + "'>" + (String)entry.getKey() + "</a>"));
                        }
                        email2.send();
                        sLog.info((Object)"Email sent.");
                    }
                    catch (Exception exception) {
                        sLog.error((Object)("Unable to send email: " + exception.getMessage()));
                    }
                }
            }
        } else {
            try {
                Object s2;
                Email mail2 = Email.createEmail();
                mail2.setSubject(System.getProperty("email.subject", "Examination Report"));
                String message2 = System.getProperty("email.body");
                String url2 = System.getProperty("email.url");
                mail2.setText((message2 == null ? "" : message2 + "\r\n\r\n") + (url2 == null ? "" : "For an up-to-date examination report, please visit " + url2 + "/\r\n\r\n") + "This email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                if (System.getProperty("email.to") != null) {
                    StringTokenizer s22 = new StringTokenizer(System.getProperty("email.to"), ";,\n\r ");
                    while (s22.hasMoreTokens()) {
                        mail2.addRecipient(s22.nextToken(), null);
                    }
                }
                if (System.getProperty("email.cc") != null) {
                    s2 = new StringTokenizer(System.getProperty("email.cc"), ";,\n\r ");
                    while (((StringTokenizer)s2).hasMoreTokens()) {
                        mail2.addRecipientCC(((StringTokenizer)s2).nextToken(), null);
                    }
                }
                if (System.getProperty("email.bcc") != null) {
                    s2 = new StringTokenizer(System.getProperty("email.bcc"), ";,\n\r ");
                    while (((StringTokenizer)s2).hasMoreTokens()) {
                        mail2.addRecipientBCC(((StringTokenizer)s2).nextToken(), null);
                    }
                }
                for (Map.Entry entry : output.entrySet()) {
                    mail2.addAttachment((File)entry.getValue(), prefix + "_" + (String)entry.getKey());
                }
                mail2.send();
                sLog.info((Object)"Email sent.");
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to send email: " + e.getMessage()));
            }
        }
        if ("true".equals(System.getProperty("email.instructors", "false")) && ireports != null && !ireports.isEmpty()) {
            sLog.info((Object)"Emailing instructors...");
            for (ExamInfo.ExamInstructorInfo instructor : new TreeSet<ExamInfo.ExamInstructorInfo>(ireports.keySet())) {
                report = ireports.get(instructor);
                email = instructor.getInstructor().getEmail();
                if (email == null || email.length() == 0) {
                    sLog.warn((Object)("Unable to email <a href='temp/" + report.getName() + "'>" + instructor.getName() + "</a> -- instructor has no email address."));
                    continue;
                }
                try {
                    Email email3 = Email.createEmail();
                    email3.setSubject(System.getProperty("email.subject", "Examination Report"));
                    message = System.getProperty("email.body");
                    url = System.getProperty("email.url");
                    email3.setText((message == null ? "" : message + "\r\n\r\n") + (url == null ? "" : "For an up-to-date examination report, please visit " + url + "/\r\n\r\n") + "This email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                    email3.addRecipient(email, null);
                    if (System.getProperty("email.cc") != null) {
                        s = new StringTokenizer(System.getProperty("email.cc"), ";,\n\r ");
                        while (((StringTokenizer)s).hasMoreTokens()) {
                            email3.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                        }
                    }
                    if (System.getProperty("email.bcc") != null) {
                        s = new StringTokenizer(System.getProperty("email.bcc"), ";,\n\r ");
                        while (((StringTokenizer)s).hasMoreTokens()) {
                            email3.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                        }
                    }
                    email3.addAttachment(report, prefix + (report.getName().endsWith(".txt") ? ".txt" : ".pdf"));
                    email3.send();
                    sLog.info((Object)("&nbsp;&nbsp;An email was sent to <a href='temp/" + report.getName() + "'>" + instructor.getName() + "</a>."));
                }
                catch (Exception exception) {
                    sLog.error((Object)("Unable to email <a href='temp/" + report.getName() + "'>" + instructor.getName() + "</a> -- " + exception.getMessage()));
                }
            }
            sLog.info((Object)"Emails sent.");
        }
        if ("true".equals(System.getProperty("email.students", "false")) && sreports != null && !sreports.isEmpty()) {
            sLog.info((Object)"Emailing instructors...");
            for (Student student : new TreeSet<Student>(sreports.keySet())) {
                report = sreports.get(student);
                email = student.getEmail();
                if (email == null || email.length() == 0) {
                    sLog.warn((Object)("  Unable to email <a href='temp/" + report.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a> -- student has no email address."));
                    continue;
                }
                try {
                    Email email4 = Email.createEmail();
                    email4.setSubject(System.getProperty("email.subject", "Examination Report"));
                    message = System.getProperty("email.body");
                    url = System.getProperty("email.url");
                    email4.setText((message == null ? "" : message + "\r\n\r\n") + (url == null ? "" : "For an up-to-date examination report, please visit " + url + "/\r\n\r\n") + "This email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                    email4.addRecipient(email, null);
                    if (System.getProperty("email.cc") != null) {
                        s = new StringTokenizer(System.getProperty("email.cc"), ";,\n\r ");
                        while (((StringTokenizer)s).hasMoreTokens()) {
                            email4.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                        }
                    }
                    if (System.getProperty("email.bcc") != null) {
                        s = new StringTokenizer(System.getProperty("email.bcc"), ";,\n\r ");
                        while (((StringTokenizer)s).hasMoreTokens()) {
                            email4.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                        }
                    }
                    email4.addAttachment(report, prefix + (report.getName().endsWith(".txt") ? ".txt" : ".pdf"));
                    email4.send();
                    sLog.info((Object)(" An email was sent to <a href='temp/" + report.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a>."));
                }
                catch (Exception exception) {
                    sLog.error((Object)("Unable to email <a href='temp/" + report.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a> -- " + exception.getMessage() + "."));
                }
            }
            sLog.info((Object)"Emails sent.");
        }
    }

    public static TreeSet<ExamAssignmentInfo> loadExams(Long sessionId, Long examTypeId, boolean assgn, boolean ignNoEnrl, boolean eventConf) throws Exception {
        sLog.info((Object)"Loading exams...");
        long t0 = System.currentTimeMillis();
        Hashtable<Long, Exam> exams = new Hashtable<Long, Exam>();
        for (Exam exam : new ExamDAO().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            exams.put(exam.getUniqueId(), exam);
        }
        sLog.info((Object)"  Fetching related objects (class)...");
        new ExamDAO().getSession().createQuery("select c from Class_ c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("classType", 3).setCacheable(true).list();
        sLog.info((Object)"  Fetching related objects (config)...");
        new ExamDAO().getSession().createQuery("select c from InstrOfferingConfig c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:configType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("configType", 2).setCacheable(true).list();
        sLog.info((Object)"  Fetching related objects (course)...");
        new ExamDAO().getSession().createQuery("select c from CourseOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:courseType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("courseType", 1).setCacheable(true).list();
        sLog.info((Object)"  Fetching related objects (offering)...");
        new ExamDAO().getSession().createQuery("select c from InstructionalOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:offeringType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("offeringType", 0).setCacheable(true).list();
        sLog.info((Object)"  Fetching related class events...");
        Hashtable<Long, ClassEvent> classEvents = new Hashtable<Long, ClassEvent>();
        for (ClassEvent ce : ExamDAO.getInstance().getSession().createQuery("select c from ClassEvent c left join fetch c.meetings m, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.clazz.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("classType", 3).setCacheable(true).list()) {
            classEvents.put(ce.getClazz().getUniqueId(), ce);
        }
        Hashtable<Long, Set<Long>> owner2students = new Hashtable<Long, Set<Long>>();
        Hashtable<Long, Set<Exam>> student2exams = new Hashtable<Long, Set<Exam>>();
        Hashtable<Long, Hashtable<Long, Set<Long>>> owner2course2students = new Hashtable<Long, Hashtable<Long, Set<Long>>>();
        if (assgn) {
            Set<Long> studentsOfCourse;
            Hashtable<Long, Set<Long>> course2students;
            Long courseId;
            Set<Exam> examsOfStudent;
            Set<Long> studentsOfOwner;
            Long studentId;
            Long ownerId;
            Long examId;
            sLog.info((Object)"  Loading students (class)...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add((Exam)exams.get(examId));
                courseId = (Long)o[3];
                course2students = owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            sLog.info((Object)"  Loading students (config)...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add((Exam)exams.get(examId));
                courseId = (Long)o[3];
                course2students = owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            sLog.info((Object)"  Loading students (course)...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add((Exam)exams.get(examId));
                courseId = (Long)o[3];
                course2students = owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            sLog.info((Object)"  Loading students (offering)...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add((Exam)exams.get(examId));
                courseId = (Long)o[3];
                course2students = owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
        }
        Hashtable<Long, Set<Meeting>> period2meetings = new Hashtable<Long, Set<Meeting>>();
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(examTypeId);
        if (assgn && eventConf && ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(type.getReference())) {
            Set<Meeting> meetings;
            Meeting meeting;
            Long periodId;
            sLog.info((Object)"  Loading overlapping class meetings...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select p.uniqueId, m from ClassEvent ce inner join ce.meetings m, ExamPeriod p where p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
            sLog.info((Object)"  Loading overlapping course meetings...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select p.uniqueId, m from CourseEvent ce inner join ce.meetings m, ExamPeriod p where ce.reqAttendance=true and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeCourse.intValue().intValue()).setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
            sLog.info((Object)"  Loading overlapping examinations of different problems...");
            for (Object[] o : new ExamDAO().getSession().createQuery("select p.uniqueId, m from ExamEvent ce inner join ce.meetings m, ExamPeriod p where ce.exam.examType.uniqueId != :examTypeId and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeCourse.intValue().intValue()).setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
        }
        ExamAssignmentInfo.Parameters p = new ExamAssignmentInfo.Parameters(sessionId, examTypeId);
        sLog.info((Object)"  Creating exam assignments...");
        TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
        Enumeration e = exams.elements();
        while (e.hasMoreElements()) {
            Exam exam = (Exam)e.nextElement();
            ExamAssignmentInfo info = assgn ? new ExamAssignmentInfo(exam, owner2students, owner2course2students, student2exams, period2meetings, p) : new ExamAssignmentInfo(exam, (ExamPeriod)null, null);
            for (ExamInfo.ExamSectionInfo section : info.getSections()) {
                ClassEvent evt;
                if (section.getOwnerType() != 3 || (evt = (ClassEvent)classEvents.get(section.getOwnerId())) == null) continue;
                ((Class_)section.getOwner().getOwnerObject()).setEvent(evt);
            }
            if (ignNoEnrl && info.getStudentIds().isEmpty()) continue;
            ret.add(info);
        }
        long t1 = System.currentTimeMillis();
        sLog.info((Object)("Exams loaded in " + sDF.format((double)(t1 - t0) / 1000.0) + "s."));
        return ret;
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "puWestLafayetteTrdtn"), ApplicationProperties.getProperty("year", "2008"), ApplicationProperties.getProperty("term", "Spr"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            ExamType examType = ExamType.findByReference(ApplicationProperties.getProperty("type", "final"));
            boolean assgn = "true".equals(System.getProperty("assgn", "true"));
            boolean ignempty = "true".equals(System.getProperty("ignempty", "true"));
            int mode = 0;
            if ("text".equals(System.getProperty("mode"))) {
                mode = 2;
            }
            if ("ledger".equals(System.getProperty("mode"))) {
                mode = 1;
            }
            sLog.info((Object)("Exam type: " + examType.getLabel()));
            boolean perSubject = "true".equals(System.getProperty("persubject", "false"));
            TreeSet<SubjectArea> subjects = null;
            if (System.getProperty("subject") != null) {
                sLog.info((Object)"Loading subjects...");
                subjects = new TreeSet<SubjectArea>();
                String inSubjects = "";
                StringTokenizer s = new StringTokenizer(System.getProperty("subject"), ",");
                while (s.hasMoreTokens()) {
                    inSubjects = inSubjects + "'" + s.nextToken() + "'" + (s.hasMoreTokens() ? "," : "");
                }
                subjects.addAll(new _RootDAO().getSession().createQuery("select sa from SubjectArea sa where sa.session.uniqueId=:sessionId and sa.subjectAreaAbbreviation in (" + inSubjects + ")").setLong("sessionId", session.getUniqueId().longValue()).list());
            }
            TreeSet<ExamAssignmentInfo> exams = PdfLegacyExamReport.loadExams(session.getUniqueId(), examType.getUniqueId(), assgn, ignempty, true);
            if (subjects == null) {
                subjects = new TreeSet();
                for (ExamAssignmentInfo exam : exams) {
                    for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                        subjects.add(section.getOwner().getCourse().getSubjectArea());
                    }
                }
            }
            Hashtable<String, File> output = new Hashtable<String, File>();
            Hashtable<SubjectArea, Hashtable<String, File>> outputPerSubject = new Hashtable<SubjectArea, Hashtable<String, File>>();
            Hashtable<ExamInfo.ExamInstructorInfo, File> ireports = null;
            Hashtable<Student, File> sreports = null;
            StringTokenizer stk = new StringTokenizer(ApplicationProperties.getProperty("report", sAllRegisteredReports), ",");
            while (stk.hasMoreTokens()) {
                String reportName = stk.nextToken();
                Class reportClass = sRegisteredReports.get(reportName);
                if (reportClass == null) continue;
                sLog.info((Object)("Report: " + reportClass.getName().substring(reportClass.getName().lastIndexOf(46) + 1)));
                if (perSubject) {
                    for (SubjectArea subject : subjects) {
                        File file = new File(new File(ApplicationProperties.getProperty("output", ".")), session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference() + "_" + reportName + "_" + subject.getSubjectAreaAbbreviation() + (mode == 2 ? ".txt" : ".pdf"));
                        long t0 = System.currentTimeMillis();
                        sLog.info((Object)("Generating report " + file + " (" + subject.getSubjectAreaAbbreviation() + ") ..."));
                        ArrayList<SubjectArea> subjectList = new ArrayList<SubjectArea>();
                        subjectList.add(subject);
                        PdfLegacyExamReport report = (PdfLegacyExamReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(mode, file, session, examType, subjectList, exams);
                        report.printReport();
                        report.close();
                        output.put(subject.getSubjectAreaAbbreviation() + "_" + reportName + "." + (mode == 2 ? "txt" : "pdf"), file);
                        Hashtable<String, File> files = outputPerSubject.get(subject);
                        if (files == null) {
                            files = new Hashtable();
                            outputPerSubject.put(subject, files);
                        }
                        files.put(subject.getSubjectAreaAbbreviation() + "_" + reportName + "." + (mode == 2 ? "txt" : "pdf"), file);
                        long t1 = System.currentTimeMillis();
                        sLog.info((Object)("Report " + file + " generated in " + sDF.format((double)(t1 - t0) / 1000.0) + "s."));
                        if (report instanceof InstructorExamReport && "true".equals(System.getProperty("email.instructors", "false"))) {
                            ireports = ((InstructorExamReport)report).printInstructorReports(mode, session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference(), new InstructorExamReport.FileGenerator(){

                                @Override
                                public File generate(String prefix, String ext) {
                                    int idx = 0;
                                    File file = new File(prefix + "." + ext);
                                    while (file.exists()) {
                                        file = new File(prefix + "_" + ++idx + "." + ext);
                                    }
                                    return file;
                                }
                            });
                            continue;
                        }
                        if (!(report instanceof StudentExamReport) || !"true".equals(System.getProperty("email.students", "false"))) continue;
                        sreports = ((StudentExamReport)report).printStudentReports(mode, session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference(), new InstructorExamReport.FileGenerator(){

                            @Override
                            public File generate(String prefix, String ext) {
                                int idx = 0;
                                File file = new File(prefix + "." + ext);
                                while (file.exists()) {
                                    file = new File(prefix + "_" + ++idx + "." + ext);
                                }
                                return file;
                            }
                        });
                    }
                    continue;
                }
                File file = new File(new File(ApplicationProperties.getProperty("output", ".")), session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference() + "_" + reportName + (mode == 2 ? ".txt" : ".pdf"));
                long t0 = System.currentTimeMillis();
                sLog.info((Object)("Generating report " + file + " ..."));
                PdfLegacyExamReport report = (PdfLegacyExamReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(mode, file, session, examType, subjects, exams);
                report.printReport();
                report.close();
                output.put(reportName + "." + (mode == 2 ? "txt" : "pdf"), file);
                long t1 = System.currentTimeMillis();
                sLog.info((Object)("Report " + file.getName() + " generated in " + sDF.format((double)(t1 - t0) / 1000.0) + "s."));
                if (report instanceof InstructorExamReport && "true".equals(System.getProperty("email.instructors", "false"))) {
                    ireports = ((InstructorExamReport)report).printInstructorReports(mode, session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference(), new InstructorExamReport.FileGenerator(){

                        @Override
                        public File generate(String prefix, String ext) {
                            int idx = 0;
                            File file = new File(prefix + "." + ext);
                            while (file.exists()) {
                                file = new File(prefix + "_" + ++idx + "." + ext);
                            }
                            return file;
                        }
                    });
                    continue;
                }
                if (!(report instanceof StudentExamReport) || !"true".equals(System.getProperty("email.students", "false"))) continue;
                sreports = ((StudentExamReport)report).printStudentReports(mode, session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference(), new InstructorExamReport.FileGenerator(){

                    @Override
                    public File generate(String prefix, String ext) {
                        int idx = 0;
                        File file = new File(prefix + "." + ext);
                        while (file.exists()) {
                            file = new File(prefix + "_" + ++idx + "." + ext);
                        }
                        return file;
                    }
                });
            }
            if ("true".equals(System.getProperty("email", "false"))) {
                PdfLegacyExamReport.sendEmails(session.getAcademicTerm() + session.getSessionStartYear() + examType.getReference(), output, outputPerSubject, ireports, sreports);
            }
            sLog.info((Object)"All done.");
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        sRegisteredReports.put("crsn", ScheduleByCourseReport.class);
        sRegisteredReports.put("conf", ConflictsByCourseAndStudentReport.class);
        sRegisteredReports.put("iconf", ConflictsByCourseAndInstructorReport.class);
        sRegisteredReports.put("pern", ScheduleByPeriodReport.class);
        sRegisteredReports.put("xpern", ExamScheduleByPeriodReport.class);
        sRegisteredReports.put("room", ScheduleByRoomReport.class);
        sRegisteredReports.put("chart", PeriodChartReport.class);
        sRegisteredReports.put("xchart", ExamPeriodChartReport.class);
        sRegisteredReports.put("ver", ExamVerificationReport.class);
        sRegisteredReports.put("abbv", AbbvScheduleByCourseReport.class);
        sRegisteredReports.put("xabbv", AbbvExamScheduleByCourseReport.class);
        sRegisteredReports.put("instr", InstructorExamReport.class);
        sRegisteredReports.put("stud", StudentExamReport.class);
        for (String report : sRegisteredReports.keySet()) {
            sAllRegisteredReports = sAllRegisteredReports + (sAllRegisteredReports.length() > 0 ? "," : "") + report;
        }
        DAY_NAMES_SHORT = new String[]{"M", "T", "W", "R", "F", "S", "U"};
    }
}

