/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.CalendarExport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class StudentEmail
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private static GwtMessages GWT = Localization.create(GwtMessages.class);
    private Date iTimeStamp = new Date();
    private static Formats.Format<Date> sTimeStampFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private static Formats.Format<Date> sConsentApprovalDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
    private String iSubject = MSG.emailDeafultSubject();
    private String iSubjectExt = null;
    private String iMessage = null;
    private String iCC = null;
    private static Hashtable<Long, String> sLastMessage = new Hashtable();
    private byte[] iTimetableImage = null;
    private Long iStudentId;
    private XOffering iOldOffering;
    private XCourseId iOldCourseId;
    private XEnrollment iOldEnrollment;
    private XStudent iOldStudent;
    private XStudent iStudent;
    private CourseUrlProvider iCourseUrlProvider = null;
    private boolean iPermisionCheck = true;
    private boolean iIncludeCourseRequests = true;
    private boolean iIncludeClassSchedule = true;
    private static String[] sColor1 = new String[]{"2952A3", "B1365F", "7A367A", "5229A3", "29527A", "1B887A", "28754E", "0D7813", "528800", "88880E", "AB8B00", "BE6D00", "B1440E", "865A5A", "705770", "4E5D6C", "5A6986", "4A716C", "6E6E41", "8D6F47"};
    private static String[] sColor2 = new String[]{"668CD9", "E67399", "B373B3", "8C66D9", "668CB3", "59BFB3", "65AD89", "4CB052", "8CBF40", "BFBF4D", "E0C240", "F2A640", "E6804D", "BE9494", "A992A9", "8997A5", "94A2bE", "85AAA5", "A7A77D", "C4A883"};

    public StudentEmail forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public StudentEmail oldEnrollment(XOffering oldOffering, XCourseId oldCourseId, XEnrollment oldEnrollment) {
        this.iOldOffering = oldOffering;
        this.iOldCourseId = oldCourseId;
        this.iOldEnrollment = oldEnrollment;
        return this;
    }

    public StudentEmail oldStudent(XStudent oldStudent) {
        this.iOldStudent = oldStudent;
        return this;
    }

    public StudentEmail overridePermissions(boolean courseRequests, boolean classSchedule) {
        this.iPermisionCheck = false;
        this.iIncludeCourseRequests = courseRequests;
        this.iIncludeClassSchedule = classSchedule;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    private String getSubject() {
        return this.iSubject;
    }

    private void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getEmailSubject() {
        return this.iSubjectExt;
    }

    public void setEmailSubject(String subject) {
        this.iSubjectExt = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getCC() {
        return this.iCC;
    }

    public void setCC(String cc) {
        this.iCC = cc;
    }

    public XEnrollment getOldEnrollment() {
        return this.iOldEnrollment;
    }

    public XOffering getOldOffering() {
        return this.iOldOffering;
    }

    public XCourse getOldCourse() {
        return this.iOldOffering == null || this.iOldCourseId == null ? null : this.iOldOffering.getCourse(this.iOldCourseId);
    }

    public XStudent getOldStudent() {
        return this.iOldStudent;
    }

    public XStudent getStudent() {
        return this.iStudent;
    }

    public void setStudent(XStudent student) {
        this.iStudent = student;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            String providerClass = ApplicationProperty.CustomizationCourseLink.value();
            if (providerClass != null) {
                this.iCourseUrlProvider = (CourseUrlProvider)Class.forName(providerClass).newInstance();
            }
        }
        catch (Exception providerClass) {
            // empty catch block
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            boolean bl;
            OnlineSectioningLog.Enrollment.Builder enrollment;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            if (this.getOldEnrollment() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XSection xSection : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(xSection, this.getOldEnrollment()));
                }
                action.addEnrollment(enrollment);
            } else if (this.getOldStudent() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest xRequest : this.getOldStudent().getRequests()) {
                    XEnrollment e = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                    if (e == null) continue;
                    for (XSection xSection : server.getOffering(e.getOfferingId()).getSections(e)) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(xSection, e));
                    }
                }
                action.addEnrollment(enrollment);
            }
            XStudent student = server.getStudent(this.getStudentId());
            if (student == null) {
                Iterator<XRequest> iterator = false;
                return iterator;
            }
            this.setStudent(student);
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            OnlineSectioningLog.Enrollment.Builder enrollment2 = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment2.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
            for (XRequest r : student.getRequests()) {
                action.addRequest(OnlineSectioningHelper.toProto(r));
                XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                if (e == null) continue;
                for (XSection section : server.getOffering(e.getOfferingId()).getSections(e)) {
                    enrollment2.addSection(OnlineSectioningHelper.toProto(section, e));
                }
            }
            action.addEnrollment(enrollment2);
            boolean bl2 = false;
            Student dbStudent = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (dbStudent != null && dbStudent.getEmail() != null && !dbStudent.getEmail().isEmpty()) {
                action.getStudentBuilder().setName(dbStudent.getEmail());
                boolean emailEnabled = true;
                if (this.iPermisionCheck) {
                    StudentSectioningStatus studentSectioningStatus = dbStudent.getEffectiveStatus();
                    if (studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.email)) {
                        emailEnabled = false;
                    }
                    if (this.iIncludeClassSchedule && studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.enabled)) {
                        this.iIncludeClassSchedule = false;
                    }
                    if (this.iIncludeCourseRequests && studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.registration)) {
                        this.iIncludeCourseRequests = false;
                    }
                } else {
                    emailEnabled = true;
                }
                if (emailEnabled) {
                    final String string = this.generateMessage(dbStudent, server, helper);
                    if (string != null) {
                        String string2;
                        String additionalCC;
                        TimetableManager manager;
                        Email email = Email.createEmail();
                        email.addRecipient(dbStudent.getEmail(), helper.getStudentNameFormat().format(dbStudent));
                        helper.logOption("recipient", dbStudent.getEmail());
                        if (this.getCC() != null && !this.getCC().isEmpty()) {
                            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                            StringTokenizer s = new StringTokenizer(this.getCC(), ",;");
                            while (s.hasMoreTokens()) {
                                void var14_28;
                                String string3 = s.nextToken().trim();
                                if (string3.isEmpty()) continue;
                                if (suffix != null && string3.indexOf(64) < 0) {
                                    String string4 = string3 + suffix;
                                }
                                try {
                                    new InternetAddress((String)var14_28, true);
                                }
                                catch (AddressException e) {
                                    helper.warn(GWT.badEmailAddress((String)var14_28, e.getMessage()));
                                    continue;
                                }
                                email.addRecipientCC((String)var14_28, null);
                                helper.logOption("cc", (String)var14_28);
                            }
                        }
                        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
                            email.setSubject(this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                            helper.logOption("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                        } else {
                            email.setSubject(this.getSubject().replace("%session%", server.getAcademicSession().toString()));
                        }
                        if (this.getMessage() != null && !this.getMessage().isEmpty()) {
                            helper.logOption("message", this.getMessage());
                        }
                        if (helper.getUser() != null && this.getOldEnrollment() == null && this.getOldStudent() == null && (manager = (TimetableManager)helper.getHibSession().createQuery("from TimetableManager where externalUniqueId = :id").setString("id", helper.getUser().getExternalId()).uniqueResult()) != null && manager.getEmailAddress() != null) {
                            email.setReplyTo(manager.getEmailAddress(), manager.getName());
                            helper.logOption("reply-to", manager.getName() + " <" + manager.getEmailAddress() + ">");
                        }
                        if ((additionalCC = ApplicationProperty.OnlineSchedulingEmailCarbonCopy.value()) != null) {
                            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                            for (String address : additionalCC.split("[\n,]")) {
                                String cc = address.trim();
                                if (cc.isEmpty()) continue;
                                if (suffix != null && cc.indexOf(64) < 0) {
                                    cc = cc + suffix;
                                }
                                email.addRecipientCC(cc, null);
                            }
                        }
                        final StringWriter buffer = new StringWriter();
                        if (ApplicationProperty.OnlineSchedulingEmailIncludeMessage.isTrue()) {
                            PrintWriter printWriter = new PrintWriter(buffer);
                            this.generateTimetable(printWriter, server, helper);
                            printWriter.flush();
                            printWriter.close();
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "message.html";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(string.replace("<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>", buffer.toString()).getBytes("UTF-8"));
                                }

                                public String getContentType() {
                                    return "text/html; charset=UTF-8";
                                }
                            });
                        }
                        if (this.iTimetableImage != null) {
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "timetable.png";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(StudentEmail.this.iTimetableImage);
                                }

                                public String getContentType() {
                                    return "image/png";
                                }
                            });
                        }
                        if (ApplicationProperty.OnlineSchedulingEmailICalendar.isTrue() && this.iIncludeClassSchedule) {
                            try {
                                final String string5 = CalendarExport.getCalendar(server, helper, student);
                                if (string5 != null) {
                                    email.addAttachment(new DataSource(){

                                        public OutputStream getOutputStream() throws IOException {
                                            throw new IOException("No output stream.");
                                        }

                                        public String getName() {
                                            return "timetable.ics";
                                        }

                                        public InputStream getInputStream() throws IOException {
                                            return new ByteArrayInputStream(string5.getBytes("UTF-8"));
                                        }

                                        public String getContentType() {
                                            return "text/calendar; charset=UTF-8";
                                        }
                                    });
                                }
                            }
                            catch (IOException iOException) {
                                helper.warn("Unable to create calendar for student " + student.getStudentId() + ":" + iOException.getMessage());
                            }
                        }
                        if ((string2 = sLastMessage.get(student.getStudentId())) != null) {
                            email.setInReplyTo(string2);
                        }
                        email.setHTML(string);
                        helper.logOption("email", string.replace("<img src='cid:timetable.png' border='0' alt='Timetable Image'/>", buffer.toString()));
                        email.send();
                        String messageId = email.getMessageId();
                        if (messageId != null) {
                            sLastMessage.put(student.getStudentId(), messageId);
                        }
                        Date ts = new Date();
                        dbStudent.setScheduleEmailedDate(ts);
                        student.setEmailTimeStamp(ts);
                        helper.getHibSession().saveOrUpdate((Object)dbStudent);
                        helper.getHibSession().flush();
                        server.update(student, false);
                        bl = true;
                    } else {
                        helper.debug("Email notification failed to generate for student " + student.getName() + ".");
                    }
                } else {
                    helper.debug("Email notification is disabled for student " + student.getName() + ".");
                }
            } else {
                helper.debug("Student " + student.getName() + " has no email address on file.");
            }
            Boolean bl3 = bl;
            return bl3;
        }
        catch (Exception e) {
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "student-email";
    }

    protected URL getCourseUrl(AcademicSessionInfo session, XCourse course) {
        if (this.iCourseUrlProvider == null) {
            return null;
        }
        return this.iCourseUrlProvider.getCourseUrl(session, course.getSubjectArea(), course.getCourseNumber());
    }

    private String generateMessage(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setClassForTemplateLoading(StudentEmail.class, "/");
        cfg.setLocale(Localization.getJavaLocale());
        cfg.setOutputEncoding("utf-8");
        Template template = cfg.getTemplate(ApplicationProperty.OnlineSchedulingEmailTemplate.value());
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("msg", MSG);
        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
            input.put("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
        }
        input.put("student", this.getStudent());
        input.put("name", helper.getStudentNameFormat().format(student));
        input.put("server", server);
        input.put("helper", helper);
        input.put("message", this.getMessage());
        input.put("dfConsentApproval", sConsentApprovalDateFormat);
        StudentSectioningStatus status = student.getEffectiveStatus();
        if (this.iIncludeCourseRequests) {
            CourseRequestInterface requests = server.createAction(GetRequest.class).forStudent(student.getUniqueId()).withCustomValidation(status != null && status.hasOption(StudentSectioningStatus.Option.reqval)).execute(server, helper);
            input.put("requests", this.generateCourseRequests(student, requests, server, helper));
        }
        if (this.iIncludeClassSchedule) {
            Table classes = this.generateListOfClasses(student, server, helper);
            input.put("classes", classes);
            float totalCredit = 0.0f;
            Pattern pattern = Pattern.compile("\\d+\\.?\\d*");
            for (TableLine line : classes) {
                Matcher m;
                String credit = line.getCredit();
                if (credit == null || !(m = pattern.matcher(credit)).find()) continue;
                totalCredit += Float.parseFloat(m.group());
            }
            input.put("credit", Float.valueOf(totalCredit));
            if (!this.getStudent().getRequests().isEmpty() && ApplicationProperty.OnlineSchedulingEmailIncludeImage.isTrue()) {
                try {
                    this.iTimetableImage = this.generateTimetableImage(server);
                }
                catch (Exception e) {
                    helper.error("Unable to create timetable image: " + e.getMessage(), e);
                    StringWriter buffer = new StringWriter();
                    PrintWriter out = new PrintWriter(buffer);
                    this.generateTimetable(out, server, helper);
                    out.flush();
                    out.close();
                    input.put("timetable", buffer.toString());
                }
                if (this.iTimetableImage != null) {
                    input.put("timetable", "<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>");
                }
            }
        }
        AcademicSessionInfo session = server.getAcademicSession();
        if (this.getOldOffering() != null) {
            Table listOfChanges = new Table();
            Object newRequest = null;
            XOffering newOffering = null;
            XCourse course = this.getOldEnrollment() != null ? this.getOldOffering().getCourse(this.getOldEnrollment().getCourseId()) : this.getOldCourse();
            for (XRequest r : this.getStudent().getRequests()) {
                if (!(r instanceof XCourseRequest) || (this.getOldCourse() != null || ((XCourseRequest)r).getCourseIdByOfferingId(this.getOldOffering().getOfferingId()) == null) && (this.getOldCourse() == null || !((XCourseRequest)r).hasCourse(this.getOldCourse().getCourseId()))) continue;
                newRequest = (XCourseRequest)r;
                newOffering = server.getOffering(this.getOldOffering().getOfferingId());
                if (((XCourseRequest)newRequest).getEnrollment() == null) break;
                course = newOffering.getCourse(((XCourseRequest)newRequest).getEnrollment().getCourseId());
                break;
            }
            input.put("changedCourse", course);
            if (this.getOldEnrollment() == null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                this.setSubject(MSG.emailEnrollmentNew(course.getSubjectArea(), course.getCourseNumber()));
                XEnrollment enrollment = ((XCourseRequest)newRequest).getEnrollment();
                Iterator<XSection> consent = this.consent(server, enrollment);
                for (XSection section : newOffering.getSections(enrollment)) {
                    XSection parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart = newOffering.getSubpart(section.getSubpartId());
                    Object requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    } else {
                        requires = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, section, (String)requires, this.getCourseUrl(session, course)));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                String requires;
                this.setSubject(MSG.emailEnrollmentChanged(course.getSubjectArea(), course.getCourseNumber()));
                String consent = this.consent(server, ((XCourseRequest)newRequest).getEnrollment());
                block5: for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                    XSection parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart = newOffering.getSubpart(section.getSubpartId());
                    for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        String requires2 = null;
                        if (parent != null) {
                            requires2 = parent.getName(course.getCourseId());
                        }
                        XSubpart oldSubpart = this.getOldOffering().getSubpart(old.getSubpartId());
                        XSection oldParent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                        String oldRequires = null;
                        if (oldParent != null) {
                            oldRequires = oldParent.getName(course.getCourseId());
                        }
                        if (oldRequires == null && requires2 == null) {
                            requires2 = consent;
                            oldRequires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionModifiedLine((XCourseRequest)newRequest, course, oldSubpart, subpart, old, section, oldRequires, requires2, this.getCourseUrl(session, course)));
                        continue block5;
                    }
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    } else {
                        requires = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, section, requires, this.getCourseUrl(session, course)));
                }
                block7: for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        continue block7;
                    }
                    XSubpart subpart = this.getOldOffering().getSubpart(old.getSubpartId());
                    XSection parent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    }
                    listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, course, subpart, old, requires, this.getCourseUrl(session, course)));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && (newRequest == null || ((XCourseRequest)newRequest).getEnrollment() == null)) {
                this.setSubject(newRequest == null ? MSG.emailCourseDropReject(course.getSubjectArea(), course.getCourseNumber()) : MSG.emailCourseDropChange(course.getSubjectArea(), course.getCourseNumber()));
                if (newRequest != null && this.getStudent().canAssign((XCourseRequest)newRequest)) {
                    input.put("changeMessage", ((XRequest)newRequest).isAlternative() ? (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListedAlternative() : MSG.emailCourseNotEnrolledAlternative()) : (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListed() : MSG.emailCourseNotEnrolled()));
                } else if (newRequest == null && course.getConsentLabel() != null) {
                    input.put("changeMessage", MSG.emailConsentRejected(course.getConsentLabel().toLowerCase()));
                }
            }
        } else if (this.getOldStudent() != null && !this.getOldStudent().getRequests().isEmpty()) {
            boolean somethingWasAssigned = false;
            for (XRequest or : this.getOldStudent().getRequests()) {
                if (!(or instanceof XCourseRequest) || ((XCourseRequest)or).getEnrollment() == null) continue;
                somethingWasAssigned = true;
                break;
            }
            if (somethingWasAssigned) {
                XCourse course;
                Table listOfChanges = new Table();
                block10: for (XRequest nr : this.getStudent().getRequests()) {
                    if (nr instanceof XFreeTimeRequest) continue;
                    XCourseRequest ncr = (XCourseRequest)nr;
                    for (XRequest or : this.getOldStudent().getRequests()) {
                        String requires;
                        XSection parent;
                        Object subpart;
                        Object course2;
                        if (or instanceof XFreeTimeRequest) continue;
                        XCourseRequest ocr = (XCourseRequest)or;
                        if (!or.getRequestId().equals(nr.getRequestId())) continue;
                        if (ocr.getEnrollment() == null) {
                            if (ncr.getEnrollment() == null) continue;
                            String consent = this.consent(server, ncr.getEnrollment());
                            XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                            course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                XSubpart subpart2 = no.getSubpart(section.getSubpartId());
                                XSection parent2 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires3 = null;
                                if (parent2 != null) {
                                    requires3 = parent2.getName(((XCourseId)course2).getCourseId());
                                } else {
                                    requires3 = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionLine(ncr, (XCourse)course2, subpart2, section, requires3, this.getCourseUrl(session, (XCourse)course2)));
                            }
                            continue block10;
                        }
                        if (ncr.getEnrollment() == null) {
                            XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                            XCourse course3 = oo.getCourse(ocr.getEnrollment().getCourseId());
                            for (XSection section : oo.getSections(ocr.getEnrollment())) {
                                Iterator<XSection> subpart3 = oo.getSubpart(section.getSubpartId());
                                XSection parent3 = section.getParentId() == null ? null : oo.getSection(section.getParentId());
                                Object requires4 = null;
                                if (parent3 != null) {
                                    requires4 = parent3.getName(course3.getCourseId());
                                }
                                listOfChanges.add(new TableSectionDeletedLine(ncr, course3, (XSubpart)((Object)subpart3), section, (String)requires4, this.getCourseUrl(session, course3)));
                            }
                            continue block10;
                        }
                        XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                        XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                        course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                        String consent = this.consent(server, ncr.getEnrollment());
                        block14: for (XSection section : no.getSections(ncr.getEnrollment())) {
                            for (XSection old : oo.getSections(ocr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                if (StudentEmail.equals(section, old)) continue block14;
                                XSubpart subpart4 = no.getSubpart(section.getSubpartId());
                                XSection parent4 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires5 = null;
                                if (parent4 != null) {
                                    requires5 = parent4.getName(((XCourseId)course2).getCourseId());
                                }
                                XSubpart oldSubpart = oo.getSubpart(old.getSubpartId());
                                XSection oldParent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                                String oldRequires = null;
                                if (oldParent != null) {
                                    oldRequires = oldParent.getName(((XCourseId)course2).getCourseId());
                                }
                                if (oldRequires == null && requires5 == null) {
                                    requires5 = consent;
                                    oldRequires = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionModifiedLine(ncr, (XCourse)course2, oldSubpart, subpart4, old, section, oldRequires, requires5, this.getCourseUrl(session, (XCourse)course2)));
                                continue block14;
                            }
                            subpart = no.getSubpart(section.getSubpartId());
                            parent = section.getParentId() == null ? null : no.getSection(section.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(((XCourseId)course2).getCourseId());
                            } else {
                                requires = consent;
                                consent = null;
                            }
                            listOfChanges.add(new TableSectionLine(ncr, (XCourse)course2, (XSubpart)subpart, section, requires, this.getCourseUrl(session, (XCourse)course2)));
                        }
                        course2 = oo.getCourse(ocr.getEnrollment().getCourseId());
                        block16: for (XSection old : oo.getSections(ocr.getEnrollment())) {
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                continue block16;
                            }
                            subpart = oo.getSubpart(old.getSubpartId());
                            parent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(((XCourseId)course2).getCourseId());
                            }
                            listOfChanges.add(new TableSectionDeletedLine(ocr, (XCourse)course2, (XSubpart)subpart, old, requires, this.getCourseUrl(session, (XCourse)course2)));
                        }
                        continue block10;
                    }
                    if (ncr.getEnrollment() == null) continue;
                    XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                    course = no.getCourse(ncr.getEnrollment().getCourseId());
                    String consent = this.consent(server, ncr.getEnrollment());
                    for (XSection section : no.getSections(ncr.getEnrollment())) {
                        XSubpart subpart = no.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : no.getSection(section.getParentId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionLine(ncr, course, subpart, section, requires, this.getCourseUrl(session, course)));
                    }
                }
                block19: for (XRequest or : this.getOldStudent().getRequests()) {
                    if (or instanceof XFreeTimeRequest || ((XCourseRequest)or).getEnrollment() == null) continue;
                    for (XRequest nr : this.getStudent().getRequests()) {
                        if (or instanceof XFreeTimeRequest || !or.getRequestId().equals(nr.getRequestId())) continue;
                        continue block19;
                    }
                    XCourseRequest ocr = (XCourseRequest)or;
                    XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                    course = oo.getCourse(ocr.getEnrollment().getCourseId());
                    for (XSection section : oo.getSections(((XCourseRequest)or).getEnrollment())) {
                        XSubpart subpart = oo.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : oo.getSection(section.getParentId());
                        Object requires2 = null;
                        if (parent != null) {
                            requires2 = parent.getName(course.getCourseId());
                        }
                        listOfChanges.add(new TableSectionDeletedLine(ocr, course, subpart, section, (String)requires2, this.getCourseUrl(session, course)));
                    }
                }
                input.put("changes", listOfChanges);
            } else {
                this.setSubject(MSG.emailSubjectNotification());
            }
        } else {
            this.setSubject(MSG.emailSubjectNotification());
        }
        input.put("manager", !this.iPermisionCheck || helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER);
        input.put("changed", this.getOldEnrollment() != null || this.getOldStudent() != null);
        input.put("version", GWT.pageVersion(Constants.getVersion(), Constants.getReleaseDate()));
        input.put("copyright", GWT.pageCopyright());
        input.put("ts", sTimeStampFormat.format(this.getTimeStamp()));
        input.put("link", ApplicationProperty.UniTimeUrl.value());
        StringWriter s = new StringWriter();
        template.process(input, (Writer)new PrintWriter(s));
        s.flush();
        s.close();
        return s.toString();
    }

    CourseRequestsTable generateCourseRequests(Student student, CourseRequestInterface requests, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String free;
        CourseRequestLine line;
        CourseRequestLine line2;
        String note;
        String credit;
        String status;
        AbstractCollection prefs;
        Object msg;
        Object iconText;
        String icon;
        boolean first;
        CourseRequestsTable courseRequests = new CourseRequestsTable();
        Formats.Format<Number> df = Formats.getNumberFormat("0.#");
        CourseRequestInterface.CheckCoursesResponse check = new CourseRequestInterface.CheckCoursesResponse(requests.getConfirmations());
        courseRequests.hasWarn = requests.hasConfirmations();
        int priority = 1;
        for (CourseRequestInterface.Request request : requests.getCourses()) {
            if (!request.hasRequestedCourse()) continue;
            first = true;
            if (request.isWaitList()) {
                courseRequests.hasWait = true;
            }
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isCourse()) {
                    icon = null;
                    iconText = null;
                    msg = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                        icon = "stop.png";
                        iconText = msg;
                    } else if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                icon = "login.png";
                                iconText = MSG.enrolled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NEEDED: {
                                icon = "attention.png";
                                iconText = MSG.overrideNeeded((String)msg);
                                break;
                            }
                            case SAVED: {
                                icon = "action_check.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.requested(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                icon = "stop.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideRejected(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                icon = "time.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overridePending(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                icon = "attention.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideCancelled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                icon = "action_check.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideApproved(rc.getCourseName());
                                break;
                            }
                            default: {
                                if (check.isError(rc.getCourseName())) {
                                    icon = "stop.png";
                                }
                                iconText = msg;
                            }
                        }
                    }
                    if (rc.hasStatusNote()) {
                        iconText = (String)iconText + "\n" + MSG.overrideNote(rc.getStatusNote());
                    }
                    prefs = null;
                    if (rc.hasSelectedIntructionalMethods()) {
                        if (rc.hasSelectedClasses()) {
                            prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                        }
                    } else if (rc.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                    }
                    status = "";
                    if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                status = MSG.reqStatusEnrolled();
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                status = MSG.reqStatusApproved();
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                status = MSG.reqStatusCancelled();
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                status = MSG.reqStatusPending();
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                status = MSG.reqStatusRejected();
                            }
                        }
                    }
                    if (status.isEmpty()) {
                        status = MSG.reqStatusRegistered();
                    }
                    if (prefs != null) {
                        courseRequests.hasPref = true;
                    }
                    credit = rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format(rc.getCreditMin()) : df.format(rc.getCreditMin()) + " - " + df.format(rc.getCreditMax())) : "";
                    note = null;
                    if (check != null) {
                        note = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    }
                    if (rc.hasStatusNote()) {
                        note = (note == null ? "" : note + "\n") + rc.getStatusNote();
                    }
                    line2 = new CourseRequestLine();
                    line2.priority = first ? MSG.courseRequestsPriority(priority) : "";
                    line2.courseName = rc.getCourseName();
                    line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                    line2.credit = credit;
                    line2.prefs = StudentEmail.toString(prefs);
                    line2.note = note;
                    line2.icon = icon;
                    line2.iconText = iconText;
                    line2.status = status;
                    line2.waitlist = first && request.isWaitList();
                    line2.first = priority > 1 && first;
                    courseRequests.add(line2);
                } else if (rc.isFreeTime()) {
                    line = new CourseRequestLine();
                    free = "";
                    for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                        if (!free.isEmpty()) {
                            free = free + ", ";
                        }
                        free = free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                    }
                    line.priority = first ? MSG.courseRequestsPriority(priority) : "";
                    line.courseName = CONST.freePrefix() + free;
                    line.courseTitle = "";
                    line.credit = "";
                    line.prefs = "";
                    line.icon = "action_check.png";
                    line.iconText = MSG.requested(free);
                    line.status = MSG.reqStatusRegistered();
                    line.waitlist = false;
                    line.first = priority > 1 && first;
                    courseRequests.add(line);
                }
                first = false;
            }
            ++priority;
        }
        priority = 1;
        for (CourseRequestInterface.Request request : requests.getAlternatives()) {
            if (!request.hasRequestedCourse()) continue;
            first = true;
            if (request.isWaitList()) {
                courseRequests.hasWait = true;
            }
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isCourse()) {
                    icon = null;
                    iconText = null;
                    msg = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                        icon = "stop.png";
                        iconText = msg;
                    } else if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                icon = "login.png";
                                iconText = MSG.enrolled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NEEDED: {
                                icon = "attention.png";
                                iconText = MSG.overrideNeeded((String)msg);
                                break;
                            }
                            case SAVED: {
                                icon = "action_check.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.requested(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                icon = "stop.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideRejected(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                icon = "time.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overridePending(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                icon = "attention.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideCancelled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                icon = "action_check.png";
                                iconText = (msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideApproved(rc.getCourseName());
                                break;
                            }
                            default: {
                                if (check.isError(rc.getCourseName())) {
                                    icon = "stop.png";
                                }
                                iconText = msg;
                            }
                        }
                    }
                    if (rc.hasStatusNote()) {
                        iconText = (String)iconText + "\n" + MSG.overrideNote(rc.getStatusNote());
                    }
                    prefs = null;
                    if (rc.hasSelectedIntructionalMethods()) {
                        if (rc.hasSelectedClasses()) {
                            prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                        }
                    } else if (rc.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                    }
                    status = "";
                    if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                status = MSG.reqStatusEnrolled();
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                status = MSG.reqStatusApproved();
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                status = MSG.reqStatusCancelled();
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                status = MSG.reqStatusPending();
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                status = MSG.reqStatusRejected();
                            }
                        }
                    }
                    if (status.isEmpty()) {
                        status = MSG.reqStatusRegistered();
                    }
                    if (prefs != null) {
                        courseRequests.hasPref = true;
                    }
                    credit = rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format(rc.getCreditMin()) : df.format(rc.getCreditMin()) + " - " + df.format(rc.getCreditMax())) : "";
                    note = null;
                    if (check != null) {
                        note = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    }
                    if (rc.hasStatusNote()) {
                        note = (note == null ? "" : note + "\n") + rc.getStatusNote();
                    }
                    line2 = new CourseRequestLine();
                    line2.priority = first ? MSG.courseRequestsAlternative(priority) : "";
                    line2.courseName = rc.getCourseName();
                    line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                    line2.credit = credit;
                    line2.prefs = StudentEmail.toString(prefs);
                    line2.note = note;
                    line2.icon = icon;
                    line2.iconText = iconText;
                    line2.status = status;
                    line2.waitlist = first && request.isWaitList();
                    line2.first = first;
                    line2.firstalt = first && priority == 1;
                    courseRequests.add(line2);
                } else if (rc.isFreeTime()) {
                    line = new CourseRequestLine();
                    free = "";
                    for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                        if (!free.isEmpty()) {
                            free = free + ", ";
                        }
                        free = free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                    }
                    line.priority = first ? MSG.courseRequestsAlternative(priority) : "";
                    line.courseName = CONST.freePrefix() + free;
                    line.courseTitle = "";
                    line.credit = "";
                    line.prefs = "";
                    line.icon = "action_check.png";
                    line.iconText = MSG.requested(free);
                    line.status = MSG.reqStatusRegistered();
                    line.waitlist = false;
                    line.first = first;
                    line.firstalt = first && priority == 1;
                    courseRequests.add(line);
                }
                first = false;
            }
            ++priority;
        }
        if (requests.getMaxCreditOverrideStatus() != null) {
            float[] range;
            String icon2 = null;
            String status2 = "";
            String note2 = null;
            String iconText2 = null;
            if (requests.hasCreditWarning()) {
                note2 = requests.getCreditWarning();
                iconText2 = requests.getCreditWarning();
                courseRequests.hasWarn = true;
            }
            switch (requests.getMaxCreditOverrideStatus()) {
                case CREDIT_HIGH: {
                    icon2 = "stop.png";
                    status2 = MSG.reqStatusRejected();
                    iconText2 = iconText2 + "\n" + MSG.creditStatusTooHigh();
                    break;
                }
                case OVERRIDE_REJECTED: {
                    icon2 = "stop.png";
                    status2 = MSG.reqStatusRejected();
                    iconText2 = iconText2 + "\n" + MSG.creditStatusDenied();
                    break;
                }
                case OVERRIDE_NEEDED: 
                case CREDIT_LOW: {
                    icon2 = "attention.png";
                    status2 = MSG.reqStatusWarning();
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    icon2 = "attention.png";
                    status2 = MSG.reqStatusCancelled();
                    iconText2 = iconText2 + "\n" + MSG.creditStatusCancelled();
                    break;
                }
                case OVERRIDE_PENDING: {
                    icon2 = "time.png";
                    status2 = MSG.reqStatusPending();
                    iconText2 = iconText2 + "\n" + MSG.creditStatusPending();
                    break;
                }
                case OVERRIDE_APPROVED: {
                    icon2 = "action_check.png";
                    status2 = MSG.reqStatusApproved();
                    iconText2 = iconText2 + (iconText2 == null ? "" : iconText2 + "\n") + MSG.creditStatusApproved();
                    break;
                }
                case SAVED: {
                    icon2 = "action_check.png";
                    status2 = MSG.reqStatusRegistered();
                }
            }
            if (requests.hasCreditNote()) {
                note2 = (note2 == null ? "" : note2 + "\n") + requests.getCreditNote();
                courseRequests.hasWarn = true;
            }
            String credit2 = (range = requests.getCreditRange()) != null ? (range[0] < range[1] ? df.format(Float.valueOf(range[0])) + " - " + df.format(Float.valueOf(range[1])) : df.format(Float.valueOf(range[0]))) : "";
            CourseRequestLine line3 = new CourseRequestLine();
            line3.priority = "";
            line3.courseName = MSG.rowRequestedCredit();
            line3.courseTitle = "";
            line3.credit = credit2;
            line3.prefs = "";
            line3.note = note2;
            line3.icon = icon2;
            line3.iconText = iconText2;
            line3.status = status2;
            line3.last = true;
            courseRequests.add(line3);
        } else {
            float[] range = requests.getCreditRange();
            if (range != null && range[1] > 0.0f) {
                String credit3 = range != null ? (range[0] < range[1] ? df.format(Float.valueOf(range[0])) + " - " + df.format(Float.valueOf(range[1])) : df.format(Float.valueOf(range[0]))) : "";
                CourseRequestLine line4 = new CourseRequestLine();
                line4.priority = "";
                line4.courseName = MSG.rowRequestedCredit();
                line4.courseTitle = "";
                line4.credit = credit3;
                line4.prefs = "";
                line4.note = null;
                line4.icon = "";
                line4.iconText = "";
                line4.status = "";
                line4.last = true;
                courseRequests.add(line4);
            }
        }
        return courseRequests;
    }

    Table generateListOfClasses(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Table listOfClasses = new Table();
        AcademicSessionInfo session = server.getAcademicSession();
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)request;
                XEnrollment enrollment = cr.getEnrollment();
                if (enrollment == null) {
                    if (!this.getStudent().canAssign(cr)) continue;
                    XCourse course = server.getCourse(cr.getCourseIds().get(0).getCourseId());
                    listOfClasses.add(new TableCourseLine(cr, course, this.getCourseUrl(session, course)));
                } else {
                    XOffering offering = server.getOffering(enrollment.getOfferingId());
                    XCourse course = offering.getCourse(enrollment.getCourseId());
                    String consent = this.consent(server, enrollment);
                    for (XSection section : offering.getSections(enrollment)) {
                        XSection parent = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                        XSubpart subpart = offering.getSubpart(section.getSubpartId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfClasses.add(new TableSectionLine(cr, course, subpart, section, requires, this.getCourseUrl(session, course)));
                    }
                }
            }
            if (!(request instanceof XFreeTimeRequest)) continue;
            listOfClasses.add(new TableLineFreeTime((XFreeTimeRequest)request));
        }
        return listOfClasses;
    }

    public static boolean equals(XSection a, XSection b) {
        return ToolBox.equals((Object)a.getName(), (Object)b.getName()) && ToolBox.equals((Object)a.getTime(), (Object)b.getTime()) && ToolBox.equals(a.getRooms(), b.getRooms()) && ToolBox.equals(a.getInstructors(), b.getInstructors()) && ToolBox.equals((Object)a.getParentId(), (Object)b.getParentId());
    }

    private static String startTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot());
    }

    private static String endTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot() + time.getLength(), time.getBreakTime());
    }

    private String consent(OnlineSectioningServer server, XEnrollment enrollment) {
        if (enrollment == null || enrollment.getCourseId() == null) {
            return null;
        }
        XCourse info = server.getCourse(enrollment.getCourseId());
        if (info == null || info.getConsentLabel() == null) {
            return null;
        }
        if (enrollment.getApproval() == null) {
            return MSG.consentWaiting(info.getConsentLabel().toLowerCase());
        }
        return MSG.consentApproved(sConsentApprovalDateFormat.format(enrollment.getApproval().getTimeStamp()));
    }

    public void generateTimetable(PrintWriter out, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Enumeration<Integer> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        out.println("<table cellspacing='0' cellpadding='0'>");
        out.println("<tr><td align='left' style='vertical-align: top;'><table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 30px;'></div></td>");
        for (int i = 0; i < nrDays; ++i) {
            out.println("<td align='center' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 180px; '>" + DayCode.values()[i].getName() + "</div></td>");
        }
        out.println("</tr></table></td></tr>");
        out.println("<tr><td align='left' style='vertical-align: top;'><div style='width: " + (35 + 180 * nrDays) + "px; '>");
        out.println("<table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top; '><div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 30px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px; white-space: nowrap; position: absolute; left: 0px; top: " + top + "px;'>" + (CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h)) + "</div>");
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px;position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        out.println("</div></td>");
        out.println("<td align='left' style='vertical-align: top; '>");
        out.println("<div style='border-bottom: 1px solid #DDDDDD; position: relative; overflow-x: hidden; overflow-y: hidden; width: " + (5 + 180 * nrDays) + "px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        out.println("<div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 100%; height: 100%; '>");
        out.println("<div style='background: #FFFDDD; width: " + (2 + 180 * nrDays) + "px; height: 500px; position: absolute; left: 0px; top: " + (25 + 50 * (7 - firstHour)) + "px;'></div>");
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                if (dow.getIndex() >= nrDays || fr.getTime().getSlot() + fr.getTime().getLength() < 12 * firstHour || fr.getTime().getSlot() > 12 * lastHour) continue;
                out.println("<div style='background: #FFE1DD; width: 100%; color: #BA5353; font-size: x-small; text-align: left; white-space: nowrap; overflow: hidden;width: 183px; height: " + 125 * fr.getTime().getLength() / 30 + "px; position: absolute; left: " + 180 * dow.getIndex() + "px;top: " + (125 * fr.getTime().getSlot() / 30 - 50 * firstHour) + "px; '>");
                out.println("<div style='padding-left: 5px; white-space: nowrap; '>Free " + DayCode.toString(fr.getTime().getDays()) + " " + StudentEmail.startTime(fr.getTime()) + " - " + StudentEmail.endTime(fr.getTime()) + "</div>");
                out.println("</div>");
            }
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='display: block; border-top: 1px solid #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + top + "px; '></div>");
            out.println("<div style='display: block; border-top: 1px dotted #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        for (int i = 0; i <= nrDays; ++i) {
            int left = 180 * i;
            out.println("<div style='height: 100%; position: absolute; top: 0px; left: 0%; border-left: 1px solid #DDDDDD; border-right: 1px solid #DDDDDD; width: 2px; position: absolute; left: " + left + "px; top: 0px; '></div>");
        }
        out.println("</div>");
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 174 / col + (index + 1 != col && col > 1 ? -3 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 3;
                    int l = 4 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 1 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    out.println("<div style='overflow-x: hidden; overflow-y: hidden; width: " + w + "px; height: " + h + "px; position: absolute; left: " + l + "px; top: " + t + "px; position: absolute; font-size: x-small; font-family: arial; overflow: hidden; -webkit-border-radius: 6px; -moz-border-radius: 6px; color: #FFFFFF; border: 1px solid #" + sColor1[color] + "; background: #" + sColor2[color] + ";'>");
                    out.println("<table cellspacing='0' cellpadding='0' style='padding-left: 4px; padding-right: 4px; padding-bottom: 2px; padding-top: 2px; width: 100%; -webkit-border-top-left-radius: 5px; -webkit-border-top-right-radius: 5px; -moz-border-radius-topleft: 5px; -moz-border-radius-topright: 5px;background: #" + sColor1[color] + ";'><tr><td align='left' style='vertical-align: top; '>");
                    out.println("<div style='padding-left: 2px; width: 100%; font-size: x-small; white-space: nowrap; overflow: hidden; color: #FFFFFF;'>" + MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName() + "</div></td></tr></tbody></table>");
                    out.println("<div style='font-size: x-small; padding-left: 4px; white-space: wrap; -webkit-border-bottom-left-radius: 5px; -webkit-border-bottom-right-radius: 5px; -moz-border-radius-bottomleft: 5px; -moz-border-radius-bottomright: 5px;'>");
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            out.println("<span style='white-space: nowrap'>" + room.getName() + ",</span>");
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        out.println("<span style='white-space: nowrap'>" + instructor.getName() + ",</span>");
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        out.println("<span style='white-space: nowrap'>" + section.getTime().getDatePatternName() + "</span>");
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        out.println("<br>" + course.getNote().replace("\n", "<br>"));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        out.println("<br>" + section.getNote().replace("\n", "<br>"));
                    }
                    out.println("</div></div>");
                }
            }
            color = (1 + color) % sColor1.length;
        }
        out.println("</div></td></tr></table></div></td></tr>");
        out.println("</table>");
    }

    public byte[] generateTimetableImage(OnlineSectioningServer server) throws IOException {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Iterator<DayCode> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        BufferedImage image = new BufferedImage(39 + 180 * nrDays, 21 + 50 * (lastHour - firstHour), 1);
        Graphics2D g = image.createGraphics();
        g.setFont(new Font("Sans Serif", 0, 11));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(255, 255, 255));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int fh = g.getFontMetrics().getHeight();
        g.setColor(new Color(105, 145, 206));
        for (int i = 0; i < nrDays; ++i) {
            g.drawString(DayCode.values()[i].getName(), 40 + i * 180, 17);
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.drawString(CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h), 2, top + fh);
        }
        g.setColor(new Color(255, 253, 221));
        g.fillRect(35, 45 + 50 * (7 - firstHour), 5 + 180 * nrDays, 501);
        Stroke noStroke = g.getStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
        g.setColor(new Color(221, 221, 221));
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.setStroke(noStroke);
            g.drawLine(35, top, 39 + 180 * nrDays, top);
            g.setStroke(dotted);
            g.drawLine(35, top + 25, 39 + 180 * nrDays, top + 25);
        }
        g.setStroke(noStroke);
        g.drawLine(35, 20 + 50 * (lastHour - firstHour), 39 + 180 * nrDays, 20 + 50 * (lastHour - firstHour));
        g.setColor(new Color(255, 225, 221));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.fillRect(36 + 180 * dow.getIndex(), 21 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour, 182, 125 * fr.getTime().getLength() / 30 - 1);
            }
        }
        g.setColor(new Color(221, 221, 221));
        for (int i = 0; i <= nrDays; ++i) {
            g.drawLine(35 + 180 * i, 20, 35 + 180 * i, 20 + 50 * (lastHour - firstHour));
            g.drawLine(38 + 180 * i, 20, 38 + 180 * i, 20 + 50 * (lastHour - firstHour));
        }
        g.setColor(new Color(186, 83, 83));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.drawString(OnlineSectioningHelper.toString(fr), 42 + 180 * dow.getIndex(), 20 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour + fh);
            }
        }
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                block13: for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 176 / col + (index + 1 < col ? -2 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 1;
                    int l = 39 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 21 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    g.setColor(new Color(Integer.valueOf(sColor2[color], 16)));
                    g.fillRoundRect(l, t, w, h, 6, 6);
                    g.setColor(new Color(Integer.valueOf(sColor1[color], 16)));
                    g.drawRoundRect(l, t, w, h, 6, 6);
                    g.fillRoundRect(l, t, w, 2 + fh, 6, 6);
                    g.fillRect(l, t + fh - 2, w, 4);
                    g.setColor(new Color(255, 255, 255));
                    String text = MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName();
                    while (g.getFontMetrics().stringWidth(text) > w - 10) {
                        text = text.substring(0, text.length() - 1);
                    }
                    g.drawString(text, l + 5, t + fh - 2);
                    ArrayList<String> texts = new ArrayList<String>();
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            texts.add(room.getName());
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        texts.add(instructor.getName());
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        texts.add(section.getTime().getDatePatternName());
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        texts.add(course.getNote().replace("\n", "; "));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        texts.add(section.getNote().replace("\n", "; "));
                    }
                    int tt = t + fh;
                    String next = "";
                    int idx = 0;
                    while (idx < texts.size() || !next.isEmpty()) {
                        if (idx < texts.size()) {
                            next = next + (String)texts.get(idx++);
                            if (idx < texts.size()) {
                                next = next + ", ";
                            }
                        }
                        while (g.getFontMetrics().stringWidth(next.trim()) < w - 10 && idx < texts.size() && g.getFontMetrics().stringWidth(next + (String)texts.get(idx) + ",") < w - 10) {
                            next = next + (String)texts.get(idx++);
                            if (idx >= texts.size()) continue;
                            next = next + ", ";
                        }
                        text = next;
                        next = "";
                        while (g.getFontMetrics().stringWidth(text.trim()) > w - 10) {
                            int sp = text.lastIndexOf(32);
                            if (sp >= 0 && g.getFontMetrics().stringWidth(text.substring(sp)) < w - 10) {
                                next = text.substring(sp);
                                text = text.substring(0, sp);
                                continue;
                            }
                            next = text.substring(text.length() - 1, text.length()) + next;
                            text = text.substring(0, text.length() - 1);
                        }
                        if (tt + fh - 2 > t + h) continue block13;
                        g.drawString(text.trim(), l + 5, tt + fh - 2);
                        tt += fh;
                    }
                }
            }
            color = (1 + color) % sColor1.length;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.flush();
        out.close();
        return out.toByteArray();
    }

    public static String toString(Collection<?> items) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return items.iterator().next().toString();
        }
        if (items.size() == 2) {
            Iterator<?> i = items.iterator();
            return GWT.itemSeparatorPair(i.next().toString(), i.next().toString());
        }
        Iterator<?> i = items.iterator();
        String list = i.next().toString();
        while (i.hasNext()) {
            String item = i.next().toString();
            if (i.hasNext()) {
                list = GWT.itemSeparatorMiddle(list, item);
                continue;
            }
            list = GWT.itemSeparatorLast(list, item);
        }
        return list;
    }

    public class CourseRequestLine {
        public String priority;
        public String courseName;
        public String courseTitle;
        public String credit;
        public String prefs;
        public String note;
        public String status;
        public String icon;
        public String iconText;
        public boolean waitlist = false;
        public boolean first = false;
        public boolean firstalt = false;
        public boolean last = false;

        public String getPriority() {
            return this.priority;
        }

        public String getCourseName() {
            return this.courseName;
        }

        public String getCourseTitle() {
            return this.courseTitle;
        }

        public String getCredit() {
            return this.credit;
        }

        public String getPrefs() {
            return this.prefs;
        }

        public String getNote() {
            return this.note;
        }

        public String getStatus() {
            return this.status;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getIconText() {
            return this.iconText;
        }

        public boolean isWaitlist() {
            return this.waitlist;
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isFirstalt() {
            return this.firstalt;
        }

        public boolean isLast() {
            return this.last;
        }
    }

    public class CourseRequestsTable {
        List<CourseRequestLine> lines = new ArrayList<CourseRequestLine>();
        boolean hasPref = false;
        boolean hasWarn = false;
        boolean hasWait = false;
        String credit = "";

        void add(CourseRequestLine line) {
            this.lines.add(line);
        }

        public List<CourseRequestLine> getLines() {
            return this.lines;
        }

        public boolean getHasPref() {
            return this.hasPref;
        }

        public boolean getHasWarn() {
            return this.hasWarn;
        }

        public boolean getHasWait() {
            return this.hasWait;
        }

        public String getCredit() {
            return this.credit;
        }
    }

    public class Table
    extends ArrayList<TableLine> {
        private static final long serialVersionUID = 1L;

        public boolean sameCourse(TableLine a, TableLine b) {
            if (a instanceof TableCourseLine && b instanceof TableCourseLine) {
                return ((TableCourseLine)a).getCourse().equals(((TableCourseLine)b).getCourse());
            }
            return false;
        }

        public boolean isFirst(TableLine line) {
            int index = this.indexOf(line);
            return index <= 0 || !this.sameCourse(line, (TableLine)this.get(index - 1));
        }

        public boolean isLast(TableLine line) {
            int index = this.indexOf(line);
            return index + 1 >= this.size() || !this.sameCourse(line, (TableLine)this.get(index + 1));
        }

        @Override
        public boolean add(TableLine line) {
            line.setTable(this);
            return super.add(line);
        }
    }

    public static class TableSectionModifiedLine
    extends TableSectionLine {
        private XSubpart iOldSubpart;
        private XSection iOldSection;
        private String iOldRequires;

        public TableSectionModifiedLine(XCourseRequest request, XCourse course, XSubpart oldSubpart, XSubpart subpart, XSection oldSection, XSection section, String oldRequires, String requires, URL url) {
            super(request, course, subpart, section, requires, url);
            this.iOldSection = oldSection;
            this.iOldSubpart = oldSubpart;
            this.iOldRequires = oldRequires;
        }

        public XSubpart getOldSubpart() {
            return this.iOldSubpart;
        }

        public XSection getOldSection() {
            return this.iOldSection;
        }

        public XTime getOldTime() {
            return this.iOldSection.getTime();
        }

        @Override
        public String getName() {
            return this.diff(this.iOldSection.getName(this.iCourse.getCourseId()), this.iSection.getName(this.iCourse.getCourseId()));
        }

        public String diff(String a, String b) {
            if (a == null || a.isEmpty()) {
                return b == null || b.isEmpty() ? "<span style='text-decoration: none;'>&nbsp;</span>" : b;
            }
            if (b == null || b.isEmpty()) {
                return "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
            }
            if (a.equals(b)) {
                return a;
            }
            return b + "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
        }

        @Override
        public String getRequires() {
            return this.diff(this.iOldRequires, this.iRequires);
        }

        @Override
        public String getInstructors() {
            String oldInstructors = "";
            if (!this.iOldSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iOldSection.getInstructors()) {
                    if (!oldInstructors.isEmpty()) {
                        oldInstructors = oldInstructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        oldInstructors = oldInstructors + instructor.getName();
                        continue;
                    }
                    oldInstructors = oldInstructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            String instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!instructors.isEmpty()) {
                        instructors = instructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        instructors = instructors + instructor.getName();
                        continue;
                    }
                    instructors = instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            return this.diff(oldInstructors, instructors);
        }

        @Override
        public String getRooms() {
            String oldRooms = "";
            if (this.iOldSection.getRooms() != null && !this.iOldSection.getRooms().isEmpty()) {
                for (XRoom room : this.iOldSection.getRooms()) {
                    if (!oldRooms.isEmpty()) {
                        oldRooms = oldRooms + ", ";
                    }
                    oldRooms = oldRooms + room.getName();
                }
            }
            String rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!rooms.isEmpty()) {
                        rooms = rooms + ", ";
                    }
                    rooms = rooms + room.getName();
                }
            }
            return this.diff(oldRooms, rooms);
        }

        @Override
        public String getNote() {
            return this.diff(this.iOldSection.getNote(), this.iSection.getNote());
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getArrangeHours() {
            return this.diff(this.getOldTime() == null ? MSG.emailArrangeHours() : DayCode.toString(this.getOldTime().getDays()) + " " + StudentEmail.startTime(this.getOldTime()), MSG.emailArrangeHours());
        }

        @Override
        public String getDays() {
            return this.diff(this.getOldTime() == null ? null : DayCode.toString(this.getOldTime().getDays()), DayCode.toString(this.getTime().getDays()));
        }

        @Override
        public String getStart() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.startTime(this.getOldTime()), StudentEmail.startTime(this.getTime()));
        }

        @Override
        public String getEnd() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.endTime(this.getOldTime()), StudentEmail.endTime(this.getTime()));
        }

        @Override
        public String getDate() {
            return this.diff(this.getOldTime() == null ? null : this.getOldTime().getDatePatternName(), this.getTime().getDatePatternName());
        }
    }

    public static class TableSectionDeletedLine
    extends TableSectionLine {
        public TableSectionDeletedLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(request, course, subpart, section, requires, url);
        }

        @Override
        public String getCourseNote() {
            return null;
        }
    }

    public static class TableLineFreeTime
    implements TableLine {
        private XFreeTimeRequest iRequest;

        public TableLineFreeTime(XFreeTimeRequest request) {
            this.iRequest = request;
        }

        @Override
        public XRequest getRequest() {
            return this.iRequest;
        }

        @Override
        public String getSubject() {
            return MSG.freeTimeCourse();
        }

        @Override
        public String getCourseNumber() {
            return MSG.freeTimeSubject();
        }

        @Override
        public String getCourseTitle() {
            return null;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public XTime getTime() {
            return this.iRequest.getTime();
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public String getCredit() {
            return null;
        }

        @Override
        public String getNote() {
            return null;
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getRequires() {
            return null;
        }

        @Override
        public String getRooms() {
            return "";
        }

        @Override
        public String getInstructors() {
            return "";
        }

        @Override
        public boolean isFreeTime() {
            return true;
        }

        @Override
        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        @Override
        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        @Override
        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        @Override
        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        @Override
        public String getDate() {
            return this.getTime().getDatePatternName();
        }

        @Override
        public void setTable(Table table) {
        }

        @Override
        public boolean isLast() {
            return true;
        }

        @Override
        public boolean isFirst() {
            return true;
        }

        @Override
        public String getUrl() {
            return null;
        }
    }

    public static class TableSectionLine
    extends TableCourseLine {
        protected XSection iSection;
        protected XSubpart iSubpart;
        protected String iRequires;

        public TableSectionLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(request, course, url);
            this.iCourse = course;
            this.iSubpart = subpart;
            this.iSection = section;
            this.iRequires = requires;
        }

        @Override
        public String getType() {
            return this.iSection.getSubpartName();
        }

        @Override
        public String getName() {
            return this.iSection.getName(this.iCourse.getCourseId());
        }

        public XSection getSection() {
            return this.iSection;
        }

        public XSubpart getSubpart() {
            return this.iSubpart;
        }

        @Override
        public String getRequires() {
            return this.iRequires;
        }

        @Override
        public String getNote() {
            return this.iSection.getNote();
        }

        @Override
        public String getCourseNote() {
            return this.iCourse.getNote();
        }

        @Override
        public String getCredit() {
            return this.iSubpart == null ? null : this.iSubpart.getCreditAbbv(this.iCourse.getCourseId());
        }

        @Override
        public XTime getTime() {
            return this.iSection.getTime();
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public String getRooms() {
            String rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!rooms.isEmpty()) {
                        rooms = rooms + ", ";
                    }
                    rooms = rooms + room.getName();
                }
            }
            return rooms;
        }

        @Override
        public String getInstructors() {
            String instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!instructors.isEmpty()) {
                        instructors = instructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        instructors = instructors + "<span style='white-space: nowrap;'>" + instructor.getName() + "</span>";
                        continue;
                    }
                    instructors = instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none; white-space: nowrap;\">" + instructor.getName() + "</a>";
                }
            }
            return instructors;
        }

        @Override
        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        @Override
        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        @Override
        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        @Override
        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        @Override
        public String getDate() {
            return this.getTime().getDatePatternName();
        }
    }

    public static class TableCourseLine
    implements TableLine {
        protected XCourseRequest iRequest;
        protected XCourse iCourse;
        protected Table iTable;
        protected String iUrl;

        public TableCourseLine(XCourseRequest request, XCourse course, URL url) {
            this.iRequest = request;
            this.iCourse = course;
            this.iUrl = url == null ? null : url.toString();
        }

        @Override
        public XRequest getRequest() {
            return this.iRequest;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        @Override
        public String getSubject() {
            return this.getCourse().getSubjectArea();
        }

        @Override
        public String getCourseNumber() {
            return this.getCourse().getCourseNumber();
        }

        @Override
        public String getCourseTitle() {
            return this.getCourse().getTitle();
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public XTime getTime() {
            return null;
        }

        @Override
        public boolean isAssigned() {
            return false;
        }

        @Override
        public String getCredit() {
            return null;
        }

        @Override
        public String getNote() {
            if (this.iRequest.isAlternative()) {
                return this.iRequest.isWaitlist() ? MSG.emailWaitListedAlternativeRequest() : MSG.emailNotEnrolledAlternativeRequest();
            }
            return this.iRequest.isWaitlist() ? MSG.emailWaitListedRequest() : MSG.emailNotEnrolledRequest();
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getRequires() {
            return null;
        }

        @Override
        public String getRooms() {
            return null;
        }

        @Override
        public String getInstructors() {
            return null;
        }

        @Override
        public boolean isFreeTime() {
            return false;
        }

        @Override
        public String getArrangeHours() {
            return null;
        }

        @Override
        public String getDays() {
            return null;
        }

        @Override
        public String getStart() {
            return null;
        }

        @Override
        public String getEnd() {
            return null;
        }

        @Override
        public String getDate() {
            return null;
        }

        @Override
        public void setTable(Table table) {
            this.iTable = table;
        }

        @Override
        public boolean isLast() {
            return this.iTable.isLast(this);
        }

        @Override
        public boolean isFirst() {
            return this.iTable.isFirst(this);
        }

        @Override
        public String getUrl() {
            return this.iUrl;
        }
    }

    public static interface TableLine {
        public XRequest getRequest();

        public String getSubject();

        public String getCourseNumber();

        public String getCourseTitle();

        public String getType();

        public String getName();

        public String getUrl();

        public XTime getTime();

        public String getRooms();

        public String getInstructors();

        public boolean isAssigned();

        public boolean isFreeTime();

        public String getArrangeHours();

        public String getDays();

        public String getStart();

        public String getEnd();

        public String getDate();

        public String getCredit();

        public String getNote();

        public String getCourseNote();

        public String getRequires();

        public void setTable(Table var1);

        public boolean isLast();

        public boolean isFirst();
    }
}

