/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.hibernate.CacheMode;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCriticalCoursesHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.solver.CheckAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class EnrollStudent
implements OnlineSectioningAction<ClassAssignmentInterface>,
HasCacheMode {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private List<ClassAssignmentInterface.ClassAssignment> iAssignment;

    public EnrollStudent forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public EnrollStudent withRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public EnrollStudent withAssignment(List<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public List<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        ClassAssignmentInterface ret;
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        HashSet<Long> offeringIds = new HashSet<Long>();
        HashSet<Long> lockedCourses = new HashSet<Long>();
        List<StudentEnrollmentProvider.EnrollmentFailure> failures = null;
        boolean includeRequestInTheReturnMessage = false;
        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
            if (ca == null || ca.isFreeTime() || ca.isDummy() || ca.isTeachingAssignment()) continue;
            XCourse course = server.getCourse(ca.getCourseId());
            if (course == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
            }
            if (server.isOfferingLocked(course.getOfferingId())) {
                lockedCourses.add(course.getCourseId());
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    if (r.isWaitList() || !r.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.hasCourseId()) {
                            if (!rc.getCourseId().equals(course.getCourseId())) continue;
                            r.setWaitList(true);
                            continue;
                        }
                        if (!rc.hasCourseName() || !course.matchCourseName(rc.getCourseName())) continue;
                        r.setWaitList(true);
                    }
                }
                continue;
            }
            offeringIds.add(course.getOfferingId());
        }
        OnlineSectioningServer.ServerCallback<Boolean> offeringChecked = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Offering check failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        CriticalCoursesProvider.CriticalCourses cc = null;
        boolean checkCritical = ApplicationProperty.EnrollmentCheckCritical.isTrue();
        try {
            if (CustomCriticalCoursesHolder.hasProvider() && checkCritical) {
                cc = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(server, helper, server.getStudent(this.getStudentId()));
            }
        }
        catch (Exception e) {
            helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
        }
        TreeSet<ClassAssignmentInterface.ErrorMessage> checkErrors = this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed() ? new TreeSet<ClassAssignmentInterface.ErrorMessage>() : null;
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), offeringIds, this.name());
        OnlineSectioningInterface.GradeModes gradeModes = new OnlineSectioningInterface.GradeModes();
        try {
            helper.beginTransaction();
            try {
                Object newEnrollment;
                XOffering offering;
                Iterator<ClassWaitList> i;
                Iterator<Serializable> requests;
                Iterator<Object> i2;
                Object cd;
                FreeTime free;
                CourseDemand adept;
                Object courses;
                OnlineSectioningLog.Action.Builder action = helper.getAction();
                if (this.getRequest().getStudentId() != null) {
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
                }
                OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
                requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
                Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder> options = new Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder>();
                for (ClassAssignmentInterface.ClassAssignment assignment : this.getAssignment()) {
                    if (assignment == null) continue;
                    OnlineSectioningLog.Section s = OnlineSectioningHelper.toProto(assignment);
                    requested.addSection(s);
                    if (assignment.isFreeTime() || assignment.isDummy() || assignment.isTeachingAssignment()) continue;
                    OnlineSectioningLog.CourseRequestOption.Builder option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(assignment.getCourseId());
                    if (option == null) {
                        option = OnlineSectioningLog.CourseRequestOption.newBuilder().setType(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT);
                        options.put(assignment.getCourseId(), option);
                    }
                    option.addSection(s);
                }
                action.addEnrollment(requested);
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getRequest())) {
                    action.addRequest(r);
                }
                List<StudentEnrollmentProvider.EnrollmentRequest> enrlCheck = server.createAction(CheckAssignmentAction.class).forStudent(this.getStudentId()).withAssignment(this.getAssignment()).check(server, helper, checkErrors);
                Student student = (Student)helper.getHibSession().createQuery("select s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cd.freeTime as ft left join fetch cr.courseOffering as co left join fetch cr.courseRequestOptions as cro left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch e.clazz as c left join fetch c.managingDept as cmd left join fetch c.schedulingSubpart as ss where s.uniqueId = :studentId").setLong("studentId", this.getStudentId().longValue()).uniqueResult();
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                XStudent oldStudent = server.getStudent(this.getStudentId());
                action.getStudentBuilder().setUniqueId(student.getUniqueId()).setExternalId(oldStudent.getExternalId()).setName(oldStudent.getName());
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    failures = CustomStudentEnrollmentHolder.getProvider().enroll(server, helper, oldStudent, enrlCheck, lockedCourses, gradeModes);
                    Iterator<Serializable> i4 = this.getAssignment().iterator();
                    block12: while (i4.hasNext()) {
                        ClassAssignmentInterface.ClassAssignment ca = i4.next();
                        if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment()) continue;
                        for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                            if (f.isEnrolled() || !f.getSection().getSectionId().equals(ca.getClassId())) continue;
                            i4.remove();
                            continue block12;
                        }
                    }
                    block14: for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                        if (!f.isEnrolled()) continue;
                        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                            if (ca == null || !f.getSection().getSectionId().equals(ca.getClassId())) continue;
                            continue block14;
                        }
                        ClassAssignmentInterface.ClassAssignment ca = new ClassAssignmentInterface.ClassAssignment();
                        ca.setClassId(f.getSection().getSectionId());
                        ca.setCourseId(f.getCourse().getCourseId());
                        this.getAssignment().add(ca);
                    }
                }
                TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                int priority = 0;
                Date ts = new Date();
                HashMap<Long, Object> course2request = new HashMap<Long, Object>();
                HashMap<Long, Object> alt2demand = new HashMap<Long, Object>();
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    CourseOffering courseOffering;
                    courses = new ArrayList();
                    if (r.hasRequestedCourse()) {
                        for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            if (rc.isFreeTime()) {
                                for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                                    void var31_74;
                                    void var31_72;
                                    Object var31_70 = null;
                                    Iterator i3 = remaining.iterator();
                                    while (i3.hasNext()) {
                                        adept = (CourseDemand)i3.next();
                                        if (adept.getFreeTime() == null) continue;
                                        CourseDemand courseDemand = adept;
                                        i3.remove();
                                        break;
                                    }
                                    if (var31_72 == null) {
                                        CourseDemand courseDemand = new CourseDemand();
                                        courseDemand.setTimestamp(ts);
                                        courseDemand.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                        student.getCourseDemands().add(courseDemand);
                                        courseDemand.setStudent(student);
                                    }
                                    var31_74.setAlternative(false);
                                    var31_74.setPriority(priority);
                                    var31_74.setWaitlist(false);
                                    var31_74.setCritical(false);
                                    free = var31_74.getFreeTime();
                                    if (free == null) {
                                        free = new FreeTime();
                                        var31_74.setFreeTime(free);
                                    }
                                    free.setCategory(0);
                                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(freeTime.getDays())));
                                    free.setStartSlot(freeTime.getStart());
                                    free.setLength(freeTime.getLength());
                                    free.setSession(student.getSession());
                                    free.setName(freeTime.toString());
                                    helper.getHibSession().saveOrUpdate((Object)free);
                                    helper.getHibSession().saveOrUpdate((Object)var31_74);
                                }
                                ++priority;
                                continue;
                            }
                            XCourseId c = server.getCourse(rc.getCourseId(), rc.getCourseName());
                            if (c == null) continue;
                            courses.add(c);
                        }
                    }
                    if (courses.isEmpty()) continue;
                    cd = null;
                    Iterator i22 = remaining.iterator();
                    block20: while (i22.hasNext()) {
                        CourseDemand adept2 = (CourseDemand)i22.next();
                        if (adept2.getFreeTime() != null) continue;
                        for (org.unitime.timetable.model.CourseRequest courseRequest : adept2.getCourseRequests()) {
                            if (!courseRequest.getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                            cd = adept2;
                            i22.remove();
                            break block20;
                        }
                    }
                    if (cd == null) {
                        cd = new CourseDemand();
                        ((BaseCourseDemand)cd).setTimestamp(ts);
                        ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                        ((BaseCourseDemand)cd).setStudent(student);
                        ((BaseCourseDemand)cd).setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                        student.getCourseDemands().add((CourseDemand)cd);
                    } else {
                        i2 = ((BaseCourseDemand)cd).getEnrollmentMessages().iterator();
                        while (i2.hasNext()) {
                            StudentEnrollmentMessage message = (StudentEnrollmentMessage)i2.next();
                            helper.getHibSession().delete((Object)message);
                            i2.remove();
                        }
                    }
                    ((BaseCourseDemand)cd).setAlternative(false);
                    ((BaseCourseDemand)cd).setPriority(priority);
                    ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
                    if (checkCritical) {
                        ((BaseCourseDemand)cd).setCritical(EnrollStudent.isCritical((List<XCourseId>)courses, cc));
                    }
                    requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
                    int order = 0;
                    Iterator iterator = courses.iterator();
                    while (iterator.hasNext()) {
                        XCourseId xCourseId = (XCourseId)iterator.next();
                        org.unitime.timetable.model.CourseRequest cr22 = null;
                        if (requests.hasNext()) {
                            cr22 = (org.unitime.timetable.model.CourseRequest)requests.next();
                            if (cr22.getClassWaitLists() != null) {
                                i = cr22.getClassWaitLists().iterator();
                                while (i.hasNext()) {
                                    helper.getHibSession().delete((Object)i.next());
                                    i.remove();
                                }
                            }
                        } else {
                            cr22 = new org.unitime.timetable.model.CourseRequest();
                            ((BaseCourseDemand)cd).getCourseRequests().add(cr22);
                            cr22.setCourseDemand((CourseDemand)cd);
                            cr22.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                        }
                        cr22.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(xCourseId.getCourseId()));
                        cr22.setAllowOverlap(false);
                        cr22.setCredit(0);
                        cr22.setOrder(order++);
                        if (cr22.getCourseOffering() == null || !cr22.getCourseOffering().getUniqueId().equals(xCourseId.getCourseId())) {
                            cr22.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(xCourseId.getCourseId(), helper.getHibSession()));
                        }
                        cr22.updatePreferences(r.getRequestedCourse(xCourseId.getCourseId()), helper.getHibSession());
                        course2request.put(xCourseId.getCourseId(), cr22);
                        if (failures == null) continue;
                        String message = null;
                        for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : failures) {
                            if (!xCourseId.getCourseId().equals(enrollmentFailure.getCourse().getCourseId())) continue;
                            if (message == null) {
                                message = enrollmentFailure.getMessage();
                                continue;
                            }
                            if (message.contains(enrollmentFailure.getMessage())) continue;
                            message = message + "\n" + enrollmentFailure.getMessage();
                        }
                        if (message == null || message.isEmpty()) continue;
                        StudentEnrollmentMessage m = new StudentEnrollmentMessage();
                        m.setCourseDemand((CourseDemand)cd);
                        m.setLevel(0);
                        m.setType(0);
                        m.setTimestamp(ts);
                        m.setMessage(message.length() > 255 ? message.substring(0, 252) + "..." : message);
                        m.setOrder(0);
                        ((BaseCourseDemand)cd).getEnrollmentMessages().add(m);
                    }
                    while (requests.hasNext()) {
                        org.unitime.timetable.model.CourseRequest courseRequest = (org.unitime.timetable.model.CourseRequest)requests.next();
                        ((BaseCourseDemand)cd).getCourseRequests().remove(courseRequest);
                        helper.getHibSession().delete((Object)courseRequest);
                    }
                    helper.getHibSession().saveOrUpdate(cd);
                    if (helper.isAlternativeCourseEnabled() && ((BaseCourseDemand)cd).getCourseRequests().size() == 1 && (courseOffering = ((BaseCourseDemand)cd).getCourseRequests().iterator().next().getCourseOffering().getAlternativeOffering()) != null) {
                        alt2demand.put(courseOffering.getUniqueId(), cd);
                    }
                    ++priority;
                }
                for (CourseRequestInterface.Request r : this.getRequest().getAlternatives()) {
                    courses = new ArrayList();
                    if (r.hasRequestedCourse()) {
                        for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            XCourseId c;
                            if (rc.isFreeTime()) {
                                for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                                    void var31_82;
                                    void var31_80;
                                    Object var31_78 = null;
                                    Iterator i3 = remaining.iterator();
                                    while (i3.hasNext()) {
                                        adept = (CourseDemand)i3.next();
                                        if (adept.getFreeTime() == null) continue;
                                        CourseDemand courseDemand = adept;
                                        i3.remove();
                                        break;
                                    }
                                    if (var31_80 == null) {
                                        CourseDemand courseDemand = new CourseDemand();
                                        courseDemand.setTimestamp(ts);
                                        courseDemand.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                        student.getCourseDemands().add(courseDemand);
                                        courseDemand.setStudent(student);
                                    }
                                    var31_82.setAlternative(true);
                                    var31_82.setPriority(priority);
                                    var31_82.setWaitlist(false);
                                    var31_82.setCritical(false);
                                    free = var31_82.getFreeTime();
                                    if (free == null) {
                                        free = new FreeTime();
                                        var31_82.setFreeTime(free);
                                    }
                                    free.setCategory(0);
                                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(freeTime.getDays())));
                                    free.setStartSlot(freeTime.getStart());
                                    free.setLength(freeTime.getLength());
                                    free.setSession(student.getSession());
                                    free.setName(freeTime.toString());
                                    helper.getHibSession().saveOrUpdate((Object)free);
                                    helper.getHibSession().saveOrUpdate((Object)var31_82);
                                }
                                ++priority;
                                continue;
                            }
                            if (!rc.isCourse() || (c = server.getCourse(rc.getCourseId(), rc.getCourseName())) == null) continue;
                            courses.add(c);
                        }
                    }
                    if (courses.isEmpty()) continue;
                    cd = null;
                    i2 = remaining.iterator();
                    block31: while (i2.hasNext()) {
                        CourseDemand adept3 = (CourseDemand)i2.next();
                        if (adept3.getFreeTime() != null) continue;
                        for (org.unitime.timetable.model.CourseRequest courseRequest : adept3.getCourseRequests()) {
                            if (!courseRequest.getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                            cd = adept3;
                            i2.remove();
                            break block31;
                        }
                    }
                    if (cd == null) {
                        cd = new CourseDemand();
                        ((BaseCourseDemand)cd).setTimestamp(ts);
                        ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                        ((BaseCourseDemand)cd).setStudent(student);
                        student.getCourseDemands().add((CourseDemand)cd);
                    }
                    ((BaseCourseDemand)cd).setAlternative(true);
                    ((BaseCourseDemand)cd).setPriority(priority);
                    ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
                    ((BaseCourseDemand)cd).setCritical(false);
                    requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
                    int order = 0;
                    Iterator iterator = courses.iterator();
                    while (iterator.hasNext()) {
                        XCourseId xCourseId = (XCourseId)iterator.next();
                        org.unitime.timetable.model.CourseRequest cr = null;
                        if (requests.hasNext()) {
                            cr = (org.unitime.timetable.model.CourseRequest)requests.next();
                            if (cr.getClassWaitLists() != null) {
                                i = cr.getClassWaitLists().iterator();
                                while (i.hasNext()) {
                                    helper.getHibSession().delete((Object)i.next());
                                    i.remove();
                                }
                            }
                        } else {
                            cr = new org.unitime.timetable.model.CourseRequest();
                            ((BaseCourseDemand)cd).getCourseRequests().add(cr);
                            cr.setCourseDemand((CourseDemand)cd);
                        }
                        cr.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(xCourseId.getCourseId()));
                        cr.setAllowOverlap(false);
                        cr.setCredit(0);
                        cr.setOrder(order++);
                        if (cr.getCourseOffering() == null || !cr.getCourseOffering().getUniqueId().equals(xCourseId.getCourseId())) {
                            cr.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(xCourseId.getCourseId(), helper.getHibSession()));
                        }
                        cr.updatePreferences(r.getRequestedCourse(xCourseId.getCourseId()), helper.getHibSession());
                        course2request.put(xCourseId.getCourseId(), cr);
                    }
                    while (requests.hasNext()) {
                        org.unitime.timetable.model.CourseRequest courseRequest = (org.unitime.timetable.model.CourseRequest)requests.next();
                        ((BaseCourseDemand)cd).getCourseRequests().remove(courseRequest);
                        helper.getHibSession().delete((Object)courseRequest);
                    }
                    helper.getHibSession().saveOrUpdate(cd);
                    ++priority;
                }
                HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment> oldEnrollments = new HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment>();
                HashMap<Long, Object[]> oldApprovals = new HashMap<Long, Object[]>();
                for (StudentClassEnrollment e : student.getClassEnrollments()) {
                    oldEnrollments.put(new FindAssignmentAction.IdPair(e.getCourseOffering().getUniqueId(), e.getClazz().getUniqueId()), e);
                    if (e.getApprovedBy() == null || oldApprovals.containsKey(e.getCourseOffering().getUniqueId())) continue;
                    oldApprovals.put(e.getCourseOffering().getUniqueId(), new Object[]{e.getApprovedBy(), e.getApprovedDate()});
                }
                HashMap<Long, Class_> classes = new HashMap<Long, Class_>();
                String classIds = null;
                for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                    if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment() || oldEnrollments.containsKey(new FindAssignmentAction.IdPair(ca.getCourseId(), ca.getClassId()))) continue;
                    if (classIds == null) {
                        classIds = ca.getClassId().toString();
                        continue;
                    }
                    classIds = classIds + "," + ca.getClassId();
                }
                if (classIds != null) {
                    for (Class_ clazz : helper.getHibSession().createQuery("select c from Class_ c left join fetch c.studentEnrollments as e left join fetch c.schedulingSubpart as s where c.uniqueId in (" + classIds + ")").list()) {
                        classes.put(clazz.getUniqueId(), clazz);
                    }
                }
                HashMap<Long, Long> courseDemandId2courseId = new HashMap<Long, Long>();
                for (ClassAssignmentInterface.ClassAssignment classAssignment : this.getAssignment()) {
                    void var31_90;
                    if (classAssignment == null || classAssignment.isFreeTime() || classAssignment.getClassId() == null || classAssignment.isDummy() || classAssignment.isTeachingAssignment()) continue;
                    org.unitime.timetable.model.CourseRequest courseRequest = (org.unitime.timetable.model.CourseRequest)course2request.get(classAssignment.getCourseId());
                    if (courseRequest == null) {
                        void var31_88;
                        CourseDemand cd3 = (CourseDemand)alt2demand.get(classAssignment.getCourseId());
                        if (cd3 == null) {
                            i = remaining.iterator();
                            block40: while (i.hasNext()) {
                                CourseDemand adept4 = (CourseDemand)((Object)i.next());
                                if (adept4.getFreeTime() != null) continue;
                                for (org.unitime.timetable.model.CourseRequest r : adept4.getCourseRequests()) {
                                    if (!r.getCourseOffering().getUniqueId().equals(classAssignment.getCourseId())) continue;
                                    cd3 = adept4;
                                    org.unitime.timetable.model.CourseRequest courseRequest2 = r;
                                    i.remove();
                                    break block40;
                                }
                            }
                            if (cd3 == null) {
                                cd3 = new CourseDemand();
                                cd3.setTimestamp(ts);
                                cd3.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                cd3.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                                cd3.setStudent(student);
                                student.getCourseDemands().add(cd3);
                            }
                            cd3.setAlternative(false);
                            cd3.setPriority(priority++);
                            cd3.setWaitlist(false);
                            if (checkCritical) {
                                cd3.setCritical(EnrollStudent.isCritical(classAssignment, cc));
                            }
                        }
                        if (var31_88 == null) {
                            org.unitime.timetable.model.CourseRequest courseRequest3 = new org.unitime.timetable.model.CourseRequest();
                            cd3.getCourseRequests().add(courseRequest3);
                            courseRequest3.setCourseDemand(cd3);
                            courseRequest3.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(classAssignment.getCourseId()));
                            courseRequest3.setAllowOverlap(false);
                            courseRequest3.setCredit(0);
                            courseRequest3.setOrder(cd3.getCourseRequests().size());
                            courseRequest3.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(classAssignment.getCourseId(), helper.getHibSession()));
                        }
                        course2request.put(classAssignment.getCourseId(), var31_90);
                        helper.getHibSession().saveOrUpdate((Object)cd3);
                        courseDemandId2courseId.put(cd3.getUniqueId(), classAssignment.getCourseId());
                        includeRequestInTheReturnMessage = true;
                    } else {
                        Long courseId = (Long)courseDemandId2courseId.get(courseRequest.getCourseDemand().getUniqueId());
                        if (courseId == null) {
                            courseDemandId2courseId.put(courseRequest.getCourseDemand().getUniqueId(), classAssignment.getCourseId());
                        } else if (!courseId.equals(classAssignment.getCourseId())) {
                            courseRequest.getCourseDemand().getCourseRequests().remove(courseRequest);
                            CourseDemand cd4 = new CourseDemand();
                            cd4.setTimestamp(ts);
                            cd4.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd4.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd4.setStudent(student);
                            student.getCourseDemands().add(cd4);
                            cd4.setAlternative(false);
                            cd4.setPriority(priority++);
                            cd4.setWaitlist(false);
                            if (checkCritical) {
                                cd4.setCritical(EnrollStudent.isCritical(classAssignment, cc));
                            }
                            courseRequest.setCourseDemand(cd4);
                            cd4.getCourseRequests().add(courseRequest);
                            helper.getHibSession().saveOrUpdate((Object)cd4);
                            courseDemandId2courseId.put(cd4.getUniqueId(), classAssignment.getCourseId());
                            includeRequestInTheReturnMessage = true;
                        }
                    }
                    StudentClassEnrollment enrl = (StudentClassEnrollment)oldEnrollments.remove(new FindAssignmentAction.IdPair(classAssignment.getCourseId(), classAssignment.getClassId()));
                    if (enrl != null) {
                        if (var31_90.equals(enrl.getCourseRequest())) continue;
                        enrl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var31_90);
                        helper.getHibSession().update((Object)enrl);
                        continue;
                    }
                    Class_ clazz = (Class_)classes.get(classAssignment.getClassId());
                    if (clazz == null) continue;
                    if (lockedCourses.contains(classAssignment.getCourseId())) {
                        ClassWaitList cwl = new ClassWaitList();
                        cwl.setClazz(clazz);
                        cwl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var31_90);
                        cwl.setStudent(student);
                        cwl.setType(ClassWaitList.Type.LOCKED.ordinal());
                        cwl.setTimestamp(ts);
                        if (var31_90.getClassWaitLists() == null) {
                            var31_90.setClassWaitLists(new HashSet<ClassWaitList>());
                        }
                        var31_90.getClassWaitLists().add(cwl);
                        helper.getHibSession().saveOrUpdate((Object)cwl);
                        continue;
                    }
                    enrl = new StudentClassEnrollment();
                    enrl.setClazz(clazz);
                    enrl.setStudent(student);
                    enrl.setCourseOffering(var31_90.getCourseOffering());
                    clazz.getStudentEnrollments().add(enrl);
                    student.getClassEnrollments().add(enrl);
                    enrl.setTimestamp(ts);
                    enrl.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    Object[] approval = (Object[])oldApprovals.get(classAssignment.getCourseId());
                    if (approval != null) {
                        enrl.setApprovedBy((String)approval[0]);
                        enrl.setApprovedDate((Date)approval[1]);
                    }
                    enrl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var31_90);
                }
                for (CourseDemand courseDemand : remaining) {
                    if (courseDemand.getFreeTime() != null) {
                        helper.getHibSession().delete((Object)courseDemand.getFreeTime());
                    }
                    for (org.unitime.timetable.model.CourseRequest cr : courseDemand.getCourseRequests()) {
                        helper.getHibSession().delete((Object)cr);
                    }
                    student.getCourseDemands().remove(courseDemand);
                    helper.getHibSession().delete((Object)courseDemand);
                }
                for (StudentClassEnrollment studentClassEnrollment : oldEnrollments.values()) {
                    studentClassEnrollment.getClazz().getStudentEnrollments().remove(studentClassEnrollment);
                    student.getClassEnrollments().remove(studentClassEnrollment);
                    helper.getHibSession().delete((Object)studentClassEnrollment);
                }
                helper.getHibSession().saveOrUpdate((Object)student);
                XStudent newStudent = new XStudent(oldStudent, student.getCourseDemands(), helper, server.getAcademicSession().getFreeTimePattern());
                for (XRequest xRequest : newStudent.getRequests()) {
                    XCourseRequest courseRequest;
                    XEnrollment enrollment;
                    if (!(xRequest instanceof XCourseRequest) || (enrollment = (courseRequest = (XCourseRequest)xRequest).getEnrollment()) == null || enrollment.getReservation() != null || (offering = server.getOffering(enrollment.getOfferingId())) == null || offering.getReservations().isEmpty()) continue;
                    enrollment.setReservation(offering.guessReservation(server.getRequests(enrollment.getOfferingId()), newStudent, enrollment));
                }
                server.update(newStudent, true);
                for (XRequest xRequest : oldStudent.getRequests()) {
                    void var35_111;
                    XEnrollment oldEnrollment;
                    XEnrollment xEnrollment = oldEnrollment = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    XRequest newRequest = null;
                    newEnrollment = null;
                    if (newStudent != null) {
                        for (XRequest r : newStudent.getRequests()) {
                            XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                            if (e == null || !e.getOfferingId().equals(oldEnrollment.getOfferingId())) continue;
                            newRequest = (XCourseRequest)r;
                            newEnrollment = e;
                            break;
                        }
                    }
                    if (newEnrollment == null) {
                        Set<Long> set = oldEnrollment.getSectionIds();
                    } else {
                        HashSet<Long> hashSet = new HashSet<Long>();
                        for (Long sectionId : oldEnrollment.getSectionIds()) {
                            if (((XEnrollment)newEnrollment).getSectionIds().contains(sectionId)) continue;
                            hashSet.add(sectionId);
                        }
                    }
                    if (var35_111.isEmpty()) continue;
                    boolean checkOffering = false;
                    XOffering offering2 = server.getOffering(oldEnrollment.getOfferingId());
                    if (!offering2.getReservations().isEmpty()) {
                        checkOffering = true;
                        helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": there are reservations.");
                    } else {
                        XCourse course;
                        XConfig config;
                        XEnrollments enrollments = server.getEnrollments(oldEnrollment.getOfferingId());
                        for (Long sectionId : var35_111) {
                            XSection section = offering2.getSection(sectionId);
                            if (section == null || section.getLimit() < 0 || section.getLimit() - enrollments.countEnrollmentsForSection(sectionId) != 1) continue;
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": section " + section + " became available.");
                            break;
                        }
                        if (!(checkOffering || newEnrollment != null && ((XEnrollment)newEnrollment).getConfigId().equals(oldEnrollment.getConfigId()) || (config = offering2.getConfig(oldEnrollment.getConfigId())) == null || config.getLimit() < 0 || config.getLimit() - enrollments.countEnrollmentsForConfig(config.getConfigId()) != 1)) {
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": config " + config + " became available.");
                        }
                        if (!(checkOffering || newEnrollment != null && ((XCourseId)newEnrollment).getCourseId().equals(oldEnrollment.getCourseId()) || (course = offering2.getCourse(oldEnrollment.getCourseId())) == null || course.getLimit() < 0 || course.getLimit() - enrollments.countEnrollmentsForCourse(course.getCourseId()) != 1)) {
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": course " + course + " became available.");
                        }
                    }
                    if (checkOffering) {
                        server.execute(server.createAction(CheckOfferingAction.class).forOfferings(oldEnrollment.getOfferingId()), helper.getUser(), offeringChecked);
                    }
                    EnrollStudent.updateSpace(server, newEnrollment == null ? null : SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering2, (XEnrollment)newEnrollment), oldEnrollment == null ? null : SectioningRequest.convert(oldStudent, (XCourseRequest)xRequest, server, offering2, oldEnrollment), offering2);
                    server.persistExpectedSpaces(oldEnrollment.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder builder = OnlineSectioningLog.Enrollment.newBuilder();
                builder.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest oldRequest : oldStudent.getRequests()) {
                    XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    for (XSection xSection : server.getOffering(oldEnrollment.getOfferingId()).getSections(oldEnrollment)) {
                        builder.addSection(OnlineSectioningHelper.toProto(xSection, oldEnrollment));
                    }
                }
                action.addEnrollment(builder);
                block52: for (XRequest newRequest : newStudent.getRequests()) {
                    XEnrollment newEnrollment2 = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment2 == null) continue;
                    if (oldStudent != null) {
                        for (XRequest xRequest : oldStudent.getRequests()) {
                            XEnrollment oldEnrollment = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                            if (oldEnrollment == null || !oldEnrollment.getOfferingId().equals(newEnrollment2.getOfferingId())) continue;
                            continue block52;
                        }
                    }
                    offering = server.getOffering(newEnrollment2.getOfferingId());
                    EnrollStudent.updateSpace(server, SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering, newEnrollment2), null, offering);
                    server.persistExpectedSpaces(newEnrollment2.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder builder2 = OnlineSectioningLog.Enrollment.newBuilder();
                builder2.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest newRequest : newStudent.getRequests()) {
                    newEnrollment = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment == null) continue;
                    for (XSection section : server.getOffering(((XCourseId)newEnrollment).getOfferingId()).getSections((XEnrollment)newEnrollment)) {
                        builder2.addSection(OnlineSectioningHelper.toProto(section, (XEnrollment)newEnrollment));
                    }
                }
                action.addEnrollment(builder2);
                server.execute(server.createAction(NotifyStudentAction.class).forStudent(this.getStudentId()).oldStudent(oldStudent), helper.getUser());
                helper.commitTransaction();
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    SectioningException se = (SectioningException)e;
                    if (checkErrors != null && !checkErrors.isEmpty()) {
                        for (ClassAssignmentInterface.ErrorMessage em : checkErrors) {
                            se.addError(em);
                        }
                    }
                    throw se;
                }
                helper.error("Failed to enroll student " + this.getStudentId() + ": " + e.getMessage(), e);
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        finally {
            lock.release();
        }
        if (!includeRequestInTheReturnMessage) {
            if (ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue()) {
                includeRequestInTheReturnMessage = true;
            } else if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER && ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue()) {
                includeRequestInTheReturnMessage = true;
            } else if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
                includeRequestInTheReturnMessage = true;
            }
        }
        if ((ret = server.execute(server.createAction(GetAssignment.class).forStudent(this.getStudentId()).withMessages(failures).withErrors(checkErrors).withRequest(includeRequestInTheReturnMessage), helper.getUser())) != null && gradeModes.hasGradeModes()) {
            for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                    OnlineSectioningInterface.GradeMode m = gradeModes.get(a);
                    if (m == null) continue;
                    a.setGradeMode(m);
                }
            }
        }
        return ret;
    }

    public static int getLimit(Enrollment enrollment, Map<Long, XSection> sections) {
        Integer limit = null;
        for (Section s : enrollment.getSections()) {
            XSection section = sections.get(s.getId());
            if (section == null || section.getLimit() < 0) continue;
            if (limit == null) {
                limit = section.getLimit();
                continue;
            }
            limit = Math.min(limit, section.getLimit());
        }
        return limit == null ? -1 : limit;
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering offering) {
        EnrollStudent.updateSpace(server, newEnrollment, oldEnrollment, offering, offering);
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering newOffering, XOffering oldOffering) {
        Enrollment otherErollment;
        Object feasibleEnrollments;
        HashMap<Long, XSection> sections;
        if (newEnrollment == null && oldEnrollment == null) {
            return;
        }
        XExpectations expectations = server.getExpectations((newEnrollment == null ? oldEnrollment : newEnrollment).getOffering().getId());
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        if (oldEnrollment != null) {
            sections = new HashMap<Long, XSection>();
            if (oldOffering != null) {
                for (XConfig config : oldOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : oldEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)oldEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : oldEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)oldEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)otherRequest.getInitialAssignment()) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double increment = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator<Object> overlaps = feasibleEnrollments.iterator();
            while (overlaps.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)overlaps.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), increment * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), increment);
                }
            }
        }
        if (newEnrollment != null) {
            sections = new HashMap();
            if (newOffering != null) {
                for (XConfig config : newOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            for (Section section : newEnrollment.getSections()) {
                section.setSpaceHeld(section.getSpaceHeld() - 1.0);
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : newEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)newEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : newEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)newEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)assignment.getValue((Variable)otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double decrement = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator iterator = feasibleEnrollments.iterator();
            while (iterator.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)iterator.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), -decrement * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), -decrement);
                }
            }
        }
        server.update(expectations);
    }

    protected static boolean isCritical(List<XCourseId> courses, CriticalCoursesProvider.CriticalCourses critical) {
        XCourseId co;
        if (critical == null) {
            return false;
        }
        Iterator<XCourseId> iterator = courses.iterator();
        return iterator.hasNext() && critical.isCritical(co = iterator.next());
    }

    protected static boolean isCritical(ClassAssignmentInterface.ClassAssignment course, CriticalCoursesProvider.CriticalCourses critical) {
        if (critical == null) {
            return false;
        }
        if (course == null || course.getCourseId() == null) {
            return false;
        }
        return critical.isCritical(new XCourseId(null, course.getCourseId(), course.getCourseName()));
    }

    @Override
    public String name() {
        return "enroll";
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }
}

