/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import com.google.protobuf.InvalidProtocolBufferException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.Query;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindOnlineSectioningLogAction;
import org.unitime.timetable.util.Constants;

public class DbFindOnlineSectioningLogAction
extends FindOnlineSectioningLogAction {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.SectioningAction> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.beginTransaction();
        try {
            ArrayList<ClassAssignmentInterface.SectioningAction> ret = new ArrayList<ClassAssignmentInterface.SectioningAction>();
            DateFormat df = Localization.getDateFormat(CONST.timeStampFormat());
            NumberFormat nf = Localization.getNumberFormat(CONST.executionTimeFormat());
            AcademicSessionInfo session = server.getAcademicSession();
            FindOnlineSectioningLogAction.SectioningLogQueryFormatter formatter = new FindOnlineSectioningLogAction.SectioningLogQueryFormatter(session, helper);
            String join = "";
            for (String t : formatter.getGroupTypes()) {
                if (!this.getQuery().hasAttribute(t)) continue;
                join = join + "left outer join s.groups G_" + t + " ";
            }
            Query q = helper.getHibSession().createQuery("select l, s from OnlineSectioningLog l, Student s " + (this.getQuery().hasAttribute("area", "clasf", "classification", "major") ? "left outer join s.areaClasfMajors m " : "") + (this.getQuery().hasAttribute("minor") ? "left outer join s.areaClasfMinors n " : "") + (this.getQuery().hasAttribute("group") ? "left outer join s.groups g " : "") + (this.getQuery().hasAttribute("accommodation") ? "left outer join s.accomodations a " : "") + (this.getQuery().hasAttribute("course") || this.getQuery().hasAttribute("lookup") ? "left outer join s.courseDemands cd left outer join cd.courseRequests cr " : "") + join + "where l.session.uniqueId = :sessionId and l.session = s.session and l.student = s.externalUniqueId and (" + this.getQuery().toString(formatter) + ") " + (this.getQuery().hasAttribute("operation") ? "" : "and (l.result is not null or l.operation not in ('reload-offering', 'check-offering', 'reload-student')) and (l.result != 3 or l.operation not in ('validate-overrides', 'critical-courses', 'banner-update')) ") + "order by l.uniqueId desc");
            q.setLong("sessionId", session.getUniqueId().longValue());
            if (this.getLimit() != null) {
                q.setMaxResults(this.getLimit().intValue());
            }
            HashSet<Long> processedLogIds = new HashSet<Long>();
            for (Object[] o : q.list()) {
                try {
                    OnlineSectioningLog log = (OnlineSectioningLog)o[0];
                    Student student = (Student)o[1];
                    if (student == null || !processedLogIds.add(log.getUniqueId())) continue;
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    st.setId(student.getUniqueId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalUniqueId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setName(helper.getStudentNameFormat().format(student));
                    for (StudentAreaClassificationMajor acm : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                        st.addArea(acm.getAcademicArea().getAcademicAreaAbbreviation());
                        st.addClassification(acm.getAcademicClassification().getCode());
                        st.addMajor(acm.getMajor().getCode());
                    }
                    for (StudentAccomodation acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation());
                    }
                    for (StudentGroup gr : student.getGroups()) {
                        if (gr.getType() == null) {
                            st.addGroup(gr.getGroupAbbreviation(), gr.getGroupName());
                            continue;
                        }
                        st.addGroup(gr.getType().getReference(), gr.getGroupAbbreviation(), gr.getGroupName());
                    }
                    for (Advisor a : student.getAdvisors()) {
                        if (a.getLastName() == null) continue;
                        st.addAdvisor(helper.getInstructorNameFormat().format(a));
                    }
                    ClassAssignmentInterface.SectioningAction a = new ClassAssignmentInterface.SectioningAction();
                    a.setStudent(st);
                    a.setTimeStamp(log.getTimeStamp());
                    a.setOperation(Constants.toInitialCase(log.getOperation().replace('-', ' ')));
                    OnlineSectioningLog.Action action = OnlineSectioningLog.Action.parseFrom(log.getAction());
                    if (action.hasCpuTime()) {
                        a.setCpuTime(action.getCpuTime());
                    }
                    if (action.hasStartTime() && action.hasEndTime()) {
                        a.setWallTime(action.getEndTime() - action.getStartTime());
                    }
                    if (action.hasUser()) {
                        a.setUser(action.getUser().getName());
                    }
                    if (action.hasResult()) {
                        a.setResult(Constants.toInitialCase(action.getResult().name()));
                    }
                    String html = "<table class='unitime-ChangeLog'>";
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>General</td></tr>";
                    html = html + "<tr><td><b>" + MSG.colOperation() + ":</b></td><td>" + Constants.toInitialCase(log.getOperation().replace('-', ' ')) + "</td></tr>";
                    if (action.hasResult()) {
                        html = html + "<tr><td><b>" + MSG.colResult() + ":</b></td><td>" + Constants.toInitialCase(action.getResult().name()) + "</td></tr>";
                    }
                    html = html + "<tr><td><b>" + MSG.colStudent() + ":</b></td><td>" + helper.getStudentNameFormat().format(student) + "</td></tr>";
                    for (OnlineSectioningLog.Entity other : action.getOtherList()) {
                        html = html + "<tr><td><b>" + Constants.toInitialCase(other.getType().name()) + ":</b></td><td>" + other.getName() + "</td></tr>";
                    }
                    html = html + "<tr><td><b>Time Stamp:</b></td><td>" + df.format(log.getTimeStamp()) + "</td></tr>";
                    for (OnlineSectioningLog.Property p : action.getOptionList()) {
                        if ("student-email".equals(log.getOperation()) && p.getKey().equalsIgnoreCase("email")) continue;
                        html = html + "<tr><td><b>" + Constants.toInitialCase(p.getKey()) + ":</b></td><td><div class='property'>" + (p.hasValue() ? p.getValue() : "") + "</div></td></tr>";
                    }
                    if (action.hasCpuTime()) {
                        html = html + "<tr><td><b>" + MSG.colCpuTime() + ":</b></td><td>" + nf.format(1.0E-9 * (double)action.getCpuTime()) + "</td></tr>";
                    }
                    if (action.hasStartTime() && action.hasEndTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colWallTime() + ":</b></td><td>" + nf.format(0.001 * (double)(action.getEndTime() - action.getStartTime())) + "</td></tr>";
                    }
                    if (action.hasApiGetTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiGetTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiGetTime()) + "</td></tr>";
                    }
                    if (action.hasApiPostTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiPostTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiPostTime()) + "</td></tr>";
                    }
                    if (action.hasApiException()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiException() + ":</b></td><td>" + action.getApiException() + "</td></tr>";
                    }
                    if ("student-email".equals(log.getOperation())) {
                        for (OnlineSectioningLog.Property p : action.getOptionList()) {
                            if (!"email".equals(p.getKey()) || !p.hasValue()) continue;
                            html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>Email</td></tr>";
                            html = html + "<tr><td colspan='2'>" + p.getValue() + "</td></tr>";
                        }
                    }
                    if (!action.getRequestList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.courseRequestsCourses() + "</td></tr>";
                        html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colPriority() + "</td><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colPreferences() + "</td></tr>";
                    }
                    String request = "";
                    String selected = "";
                    int notAlt = 0;
                    int lastFT = -1;
                    for (OnlineSectioningLog.Request r : action.getRequestList()) {
                        if (!r.getAlternative()) {
                            notAlt = r.getPriority() + 1;
                        }
                        int idx = 0;
                        for (OnlineSectioningLog.Time time : r.getFreeTimeList()) {
                            if (idx == 0) {
                                html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (lastFT == r.getPriority() ? "" : (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternative(1 + r.getPriority() - notAlt))) + "</td>";
                                html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<td class='top-border-dashed' colspan='2'>" : "<td colspan='2'>") + CONST.freePrefix() + " ";
                                request = request + (lastFT == r.getPriority() ? ", " : (request.isEmpty() ? "" : "<br>") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " + CONST.freePrefix() + " ");
                            } else {
                                html = html + ", ";
                                request = request + ", ";
                            }
                            ++idx;
                            html = html + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                            request = request + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                            html = html + "</td></tr>";
                            lastFT = r.getPriority();
                        }
                        if (r.getFreeTimeList().isEmpty()) {
                            for (OnlineSectioningLog.Entity entity : r.getCourseList()) {
                                if (idx == 0) {
                                    html = html + (r.getPriority() > 0 ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternative(1 + r.getPriority() - notAlt)) + "</td>";
                                    html = html + (r.getPriority() > 0 ? "<td class='top-border-dashed'>" : "<td>");
                                    request = request + (request.isEmpty() ? "" : "<br>") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". ";
                                } else {
                                    html = html + "<tr><td></td><td>";
                                    request = request + ", ";
                                }
                                html = html + entity.getName();
                                request = request + entity.getName();
                                html = html + (r.getPriority() > 0 && ++idx == 1 ? "</td><td class='top-border-dashed'>" : "</td><td>");
                                for (int i = 0; i < entity.getParameterCount(); ++i) {
                                    html = html + (i > 0 ? ", " : "") + entity.getParameter(i).getValue();
                                }
                                html = html + "</td></tr>";
                            }
                        }
                        for (OnlineSectioningLog.Section section : r.getSectionList()) {
                            if (section.getPreference() != OnlineSectioningLog.Section.Preference.SELECTED) continue;
                            if (!selected.isEmpty()) {
                                selected = selected + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity entity : section.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + entity.getName();
                            }
                            String instr = "";
                            for (OnlineSectioningLog.Entity e4 : section.getInstructorList()) {
                                if (!instr.isEmpty()) {
                                    instr = instr + ", ";
                                }
                                instr = instr + e4.getName();
                            }
                            selected = selected + section.getCourse().getName() + " " + section.getSubpart().getName() + " " + section.getClazz().getName() + " " + (section.hasTime() ? DayCode.toString(section.getTime().getDays()) + " " + this.time(section.getTime().getStart()) + " - " + this.time(section.getTime().getStart() + section.getTime().getLength()) : "") + " " + loc;
                        }
                    }
                    if (!action.getRequestList().isEmpty()) {
                        html = html + "</table></td></tr>";
                    }
                    String enrollment = "";
                    HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String> enrollmentByType = new HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String>();
                    for (OnlineSectioningLog.Enrollment e5 : action.getEnrollmentList()) {
                        enrollment = "";
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + (e5.hasType() ? Constants.toInitialCase(e5.getType().name()) + " " : "") + MSG.enrollmentsTable() + "</td></tr>";
                        html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colSubject() + "</td><td class='unitime-TableHeader'>" + MSG.colClass() + "</td><td class='unitime-TableHeader'>" + MSG.colDays() + "</td><td class='unitime-TableHeader'>" + MSG.colStart() + "</td><td class='unitime-TableHeader'>" + MSG.colEnd() + "</td><td class='unitime-TableHeader'>" + MSG.colDate() + "</td><td class='unitime-TableHeader'>" + MSG.colRoom() + "</td><td class='unitime-TableHeader'>" + MSG.colInstructor() + "</td></tr>";
                        for (OnlineSectioningLog.Section s2 : e5.getSectionList()) {
                            void var30_46;
                            if (!s2.hasCourse()) continue;
                            if (!enrollment.isEmpty()) {
                                enrollment = enrollment + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity r : s2.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + r.getName();
                            }
                            String string = "";
                            for (OnlineSectioningLog.Entity r : s2.getInstructorList()) {
                                void var30_48;
                                if (!var30_46.isEmpty()) {
                                    String string2 = (String)var30_46 + ", ";
                                }
                                String string3 = (String)var30_48 + r.getName();
                            }
                            html = html + "<tr><td>" + s2.getCourse().getName() + "</td><td>" + s2.getSubpart().getName() + "</td><td>" + s2.getClazz().getName() + "</td><td>" + (s2.hasTime() ? DayCode.toString(s2.getTime().getDays()) : "") + "</td><td>" + (s2.hasTime() ? this.time(s2.getTime().getStart()) : "") + "</td><td>" + (s2.hasTime() ? this.time(s2.getTime().getStart() + s2.getTime().getLength()) : "") + "</td><td>" + (s2.hasTime() && s2.getTime().hasPattern() ? s2.getTime().getPattern() : "") + "</td><td>" + loc + "</td><td>" + (String)var30_46 + "</td></tr>";
                            enrollment = enrollment + s2.getCourse().getName() + " " + s2.getSubpart().getName() + " " + s2.getClazz().getName() + " " + (s2.hasTime() ? DayCode.toString(s2.getTime().getDays()) + " " + this.time(s2.getTime().getStart()) : "") + " " + loc;
                        }
                        html = html + "</table></td></tr>";
                        enrollmentByType.put(e5.getType(), enrollment);
                    }
                    String message = "";
                    if (!action.getMessageList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableMessages() + "</td></tr>";
                        for (OnlineSectioningLog.Message message2 : action.getMessageList()) {
                            if (message2.hasText()) {
                                html = html + "<tr><td><b>" + message2.getLevel().name() + ":</b></td><td>" + message2.getText() + "</td></tr>";
                                message = message2.getText();
                            }
                            if (!message2.hasException()) continue;
                            html = html + "<tr><td><b>Exception:</b></td><td>" + message2.getException() + "</td></tr>";
                            message = message2.getException();
                        }
                    }
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableProto() + "</td></tr>";
                    html = html + "<tr><td colspan='2' class='proto'>" + action.toString().replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;").replace("\n", "<br>") + "</td></tr>";
                    html = html + "</table>";
                    if (action.hasResult() && OnlineSectioningLog.Action.ResultType.FAILURE.equals((Object)action.getResult()) && !message.isEmpty()) {
                        a.setMessage(message);
                    } else if ("suggestions".equals(log.getOperation())) {
                        a.setMessage(selected.isEmpty() ? message : selected);
                    } else if ("section".equals(log.getOperation())) {
                        a.setMessage(request.isEmpty() ? message : request);
                    } else if (enrollmentByType.containsKey((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED)) {
                        a.setMessage((String)enrollmentByType.get((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED));
                    } else {
                        a.setMessage(enrollment.isEmpty() ? (request.isEmpty() ? message : request) : enrollment);
                    }
                    a.setProto(html);
                    ret.add(a);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
            }
            helper.commitTransaction();
            Collections.sort(ret);
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }
}

