/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.OnlineConfig;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSection;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.MinimizeConflicts;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.selection.BestPenaltyCriterion;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XDummyReservation;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindAssignmentAction
implements OnlineSectioningAction<List<ClassAssignmentInterface>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private CourseRequestInterface iRequest;
    private Collection<ClassAssignmentInterface.ClassAssignment> iAssignment;
    private Collection<ClassAssignmentInterface.ClassAssignment> iSpecialRegistration;

    public FindAssignmentAction forRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public FindAssignmentAction withAssignment(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    public FindAssignmentAction withSpecialRegistration(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iSpecialRegistration = assignment;
        return this;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getSpecialRegistration() {
        return this.iSpecialRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassAssignmentInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String override;
        long t0 = System.currentTimeMillis();
        OverExpectedCriterion overExpected = server.getOverExpectedCriterion();
        if ((this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areTimeConflictsAllowed() || this.getSpecialRegistration() != null) && server.getConfig().getPropertyBoolean("OverExpected.MinimizeConflicts", false)) {
            overExpected = new MinimizeConflicts(server.getConfig(), overExpected);
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), overExpected);
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.getRequest().getStudentId() != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getRequest().getStudentId()));
        }
        Student student = new Student(this.getRequest().getStudentId() == null ? -1L : this.getRequest().getStudentId());
        HashSet<IdPair> enrolled = null;
        OnlineSectioningServer.Lock readLock = server.readLock();
        ClassAssignmentInterface unavailabilities = null;
        try {
            Collection<Long> collection;
            CourseRequest cr;
            XStudent original;
            XStudent xStudent = original = this.getRequest().getStudentId() == null ? null : server.getStudent(this.getRequest().getStudentId());
            if (original != null) {
                unavailabilities = new ClassAssignmentInterface();
                GetAssignment.fillUnavailabilitiesIn(unavailabilities, original, server, helper, null);
                Collections.reverse(unavailabilities.getCourseAssignments());
                student.setExternalId(original.getExternalId());
                student.setName(original.getName());
                student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
                student.setAllowDisabled(original.isAllowDisabled());
                if (server instanceof StudentSolver) {
                    student.setMaxCredit(original.getMaxCredit());
                }
                action.getStudentBuilder().setUniqueId(original.getStudentId()).setExternalId(original.getExternalId()).setName(original.getName());
                enrolled = new HashSet<IdPair>();
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XEnrollment xEnrollment = ((XCourseRequest)xRequest).getEnrollment();
                    for (Long s : xEnrollment.getSectionIds()) {
                        enrolled.add(new IdPair(xEnrollment.getCourseId(), s));
                    }
                }
                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XCourseRequest cr2 = (XCourseRequest)xRequest;
                    XOffering offering = server.getOffering(cr2.getEnrollment().getOfferingId());
                    for (XSection section : offering.getSections(cr2.getEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(section, cr2.getEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            }
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet<XDistribution> hashSet = new HashSet<XDistribution>();
            if (this.getAssignment() != null) {
                this.getRequest().moveActiveSubstitutionsUp();
            }
            for (CourseRequestInterface.Request c : this.getRequest().getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null);
            }
            if (student.getRequests().isEmpty() && !CONSTANTS.allowEmptySchedule()) {
                throw new SectioningException(MSG.exceptionNoCourse());
            }
            for (CourseRequestInterface.Request c : this.getRequest().getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null);
            }
            if (helper.isAlternativeCourseEnabled()) {
                for (Object r : student.getRequests()) {
                    XOffering x;
                    XCourse ci;
                    XCourse course;
                    Long altCourseId;
                    if (r.isAlternative() || !(r instanceof CourseRequest) || (cr = (CourseRequest)r).getCourses().size() != 1 || (altCourseId = (course = server.getCourse(((Course)cr.getCourses().get(0)).getId())) == null ? null : course.getAlternativeCourseId()) == null) continue;
                    boolean hasCourse = false;
                    block10: for (Request x2 : student.getRequests()) {
                        if (!(x2 instanceof CourseRequest)) continue;
                        for (Course c : ((CourseRequest)x2).getCourses()) {
                            if (c.getId() != altCourseId.longValue()) continue;
                            hasCourse = true;
                            continue block10;
                        }
                    }
                    if (hasCourse || (ci = server.getCourse(altCourseId)) == null || (x = server.getOffering(ci.getOfferingId())) == null) continue;
                    cr.getCourses().add(FindAssignmentAction.clone(x, server.getEnrollments(x.getOfferingId()), ci.getCourseId(), student.getId(), original, classTable, server, (StudentSectioningModel)model, this.getAssignment() != null));
                    hashSet.addAll(x.getDistributions());
                }
            }
            if (student.getExternalId() != null && !student.getExternalId().isEmpty() && (collection = server.getInstructedOfferings(student.getExternalId())) != null) {
                for (Long offeringId : collection) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    offering.fillInUnavailabilities(student);
                }
            }
            if (this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed() || this.getSpecialRegistration() != null) {
                for (Object r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    cr = (CourseRequest)r;
                    for (Course course : cr.getCourses()) {
                        boolean space;
                        XCourse xc = server.getCourse(course.getId());
                        boolean time = this.getRequest().areTimeConflictsAllowed() && xc.areTimeConflictOverridesAllowed();
                        boolean bl = space = this.getRequest().areSpaceConflictsAllowed() && xc.areSpaceConflictOverridesAllowed();
                        if (!time && !space && this.getSpecialRegistration() == null) continue;
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), -100, space, 1, true, true, time, true, true);
                    }
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            for (XDistribution link : hashSet) {
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long sectionId : link.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
        }
        finally {
            readLock.release();
        }
        Hashtable<CourseRequest, Object> preferredSectionsForCourse = new Hashtable<CourseRequest, Object>();
        Hashtable<CourseRequest, Object> requiredOrSavedSectionsForCourse = new Hashtable<CourseRequest, Object>();
        Hashtable<CourseRequest, Set<Section>> hashtable = new Hashtable<CourseRequest, Set<Section>>();
        HashSet<FreeTimeRequest> hashSet = new HashSet<FreeTimeRequest>();
        HashSet<FreeTimeRequest> requiredFreeTimes = new HashSet<FreeTimeRequest>();
        HashSet<CourseRequest> requiredUnassigned = new HashSet<CourseRequest>();
        int notAssigned = 0;
        double selectedPenalty = 0.0;
        if (this.getAssignment() != null && !this.getAssignment().isEmpty()) {
            OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
            requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
            for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                if (a == null || !a.isAssigned()) continue;
                requested.addSection(OnlineSectioningHelper.toProto(a));
            }
            action.addEnrollment(requested);
            Enrollment[] enrollmentArry = new Enrollment[student.getRequests().size()];
            int idx = 0;
            for (Request r : student.getRequests()) {
                OnlineSectioningLog.Request.Builder rq = OnlineSectioningHelper.toProto(r);
                if (r instanceof CourseRequest) {
                    Object s;
                    Section section;
                    CourseRequest cr = (CourseRequest)r;
                    HashSet preferredSections = new HashSet();
                    HashSet<Section> requiredSections = new HashSet<Section>();
                    HashSet requiredOrSavedSections = new HashSet();
                    HashSet<CourseRequest> allowOverlaps = new HashSet<CourseRequest>();
                    boolean conflict = false;
                    boolean assigned = false;
                    ArrayList<ClassAssignmentInterface.ClassAssignment> specRegAdds = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
                    Iterator<Long> specRegDrops = new HashSet();
                    if (this.getSpecialRegistration() != null) {
                        for (ClassAssignmentInterface.ClassAssignment b : this.getSpecialRegistration()) {
                            if (cr.getCourse(b.getCourseId().longValue()) == null) continue;
                            if (b.isCourseAssigned()) {
                                specRegAdds.add(b);
                                continue;
                            }
                            specRegDrops.add(b.getClassId());
                        }
                    }
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || a.isFreeTime() || cr.getCourse(a.getCourseId().longValue()) == null || a.getClassId() == null) continue;
                        assigned = true;
                        section = cr.getSection(a.getClassId().longValue());
                        if (section == null || section.getLimit() == 0) continue;
                        if (specRegDrops.contains(a.getClassId())) {
                            rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(OnlineSectioningLog.Section.Preference.DROP));
                            continue;
                        }
                        if (a.isPinned()) {
                            requiredSections.add(section);
                        }
                        if (a.isPinned() || this.getSpecialRegistration() == null && a.isSaved() || this.getRequest().isNoChange()) {
                            if (!conflict) {
                                Iterator iterator = requiredOrSavedSections.iterator();
                                while (iterator.hasNext()) {
                                    s = (Section)iterator.next();
                                    if (!s.isOverlapping((SctAssignment)section)) continue;
                                    conflict = true;
                                    break;
                                }
                                boolean allowOverlap22 = false;
                                for (Reservation reservation : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                                    if (!reservation.isAllowOverlap()) continue;
                                    allowOverlap22 = true;
                                    break;
                                }
                                if (allowOverlap22) {
                                    allowOverlaps.add(cr);
                                } else {
                                    for (Map.Entry entry : requiredOrSavedSectionsForCourse.entrySet()) {
                                        if (!allowOverlaps.contains(entry.getKey())) {
                                            for (Section s2 : (Set)entry.getValue()) {
                                                if (!s2.isOverlapping((SctAssignment)section)) continue;
                                                conflict = true;
                                                break;
                                            }
                                        }
                                        if (!conflict) continue;
                                        break;
                                    }
                                }
                            }
                            if (!conflict) {
                                requiredOrSavedSections.add(section);
                            }
                        }
                        selectedPenalty += model.getOverExpected((Assignment)assignment, enrollmentArry, idx, section, (Request)cr);
                        preferredSections.add(section);
                        rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(a.isPinned() || a.isSaved() || this.getRequest().isNoChange() ? OnlineSectioningLog.Section.Preference.REQUIRED : OnlineSectioningLog.Section.Preference.PREFERRED));
                    }
                    if (!assigned && this.getRequest().isNoChange()) {
                        requiredUnassigned.add(cr);
                    } else if (!(this.getSpecialRegistration() == null || specRegDrops.isEmpty() && assigned || !specRegAdds.isEmpty())) {
                        requiredUnassigned.add(cr);
                    }
                    if (!specRegAdds.isEmpty()) {
                        for (ClassAssignmentInterface.ClassAssignment a : specRegAdds) {
                            section = cr.getSection(a.getClassId().longValue());
                            if (section == null) continue;
                            selectedPenalty += model.getOverExpected((Assignment)assignment, enrollmentArry, idx, section, (Request)cr);
                            preferredSections.add(section);
                            if (a.isPinned()) {
                                requiredSections.add(section);
                            }
                            if (!conflict && a.isPinned()) {
                                if (section.getLimit() == 0 && !this.getRequest().areSpaceConflictsAllowed()) {
                                    conflict = true;
                                }
                                Iterator allowOverlap22 = requiredOrSavedSections.iterator();
                                while (allowOverlap22.hasNext()) {
                                    s = (Section)allowOverlap22.next();
                                    if (!s.isOverlapping((SctAssignment)section)) continue;
                                    conflict = true;
                                    break;
                                }
                                boolean allowOverlap = false;
                                for (Reservation reservation : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                                    if (!reservation.isAllowOverlap()) continue;
                                    allowOverlap = true;
                                    break;
                                }
                                if (allowOverlap) {
                                    allowOverlaps.add(cr);
                                } else {
                                    for (Map.Entry entry : requiredOrSavedSectionsForCourse.entrySet()) {
                                        if (!allowOverlaps.contains(entry.getKey())) {
                                            for (Section s2 : (Set)entry.getValue()) {
                                                if (!s2.isOverlapping((SctAssignment)section)) continue;
                                                conflict = true;
                                                break;
                                            }
                                        }
                                        if (!conflict) continue;
                                        break;
                                    }
                                }
                                if (!conflict) {
                                    requiredOrSavedSections.add(section);
                                }
                            }
                            rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(OnlineSectioningLog.Section.Preference.ADD));
                        }
                    }
                    if (preferredSections.isEmpty()) {
                        ++notAssigned;
                    }
                    preferredSectionsForCourse.put(cr, preferredSections);
                    hashtable.put(cr, requiredSections);
                    if (!conflict) {
                        requiredOrSavedSectionsForCourse.put(cr, requiredOrSavedSections);
                    }
                    if (!preferredSections.isEmpty()) {
                        Section section2 = (Section)preferredSections.iterator().next();
                        enrollmentArry[idx] = new Enrollment((Request)cr, 0, section2.getSubpart().getConfig(), (Set)preferredSections, (Assignment)assignment);
                    }
                } else {
                    FreeTimeRequest ft = (FreeTimeRequest)r;
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || !a.isFreeTime() || !a.isPinned() && !this.getRequest().isNoChange() || ft.getTime() == null || ft.getTime().getStartSlot() != a.getStart() || ft.getTime().getLength() != a.getLength() || ft.getTime().getDayCode() != DayCode.toInt(DayCode.toDayCodes(a.getDays()))) continue;
                        if (a.isPinned()) {
                            hashSet.add(ft);
                        }
                        requiredFreeTimes.add(ft);
                        for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                            ftb.setPreference(OnlineSectioningLog.Section.Preference.REQUIRED);
                        }
                    }
                }
                action.addRequest(rq);
                ++idx;
            }
        } else {
            Iterator e = student.getRequests().iterator();
            while (e.hasNext()) {
                action.addRequest(OnlineSectioningHelper.toProto((Request)e.next()));
            }
        }
        long t1 = System.currentTimeMillis();
        boolean avoidOverExpected = server.getAcademicSession().isSectioningEnabled();
        if (avoidOverExpected && helper.getUser() != null && helper.getUser().hasType() && helper.getUser().getType() != OnlineSectioningLog.Entity.EntityType.STUDENT) {
            avoidOverExpected = false;
        }
        if ((override = ApplicationProperty.OnlineSchedulingAllowOverExpected.value()) != null) {
            avoidOverExpected = "false".equalsIgnoreCase(override);
        }
        double maxOverExpected = -1.0;
        if (avoidOverExpected && !(model.getOverExpectedCriterion() instanceof NeverOverExpected)) {
            if (notAssigned == 0 && this.getAssignment() != null && !this.getAssignment().isEmpty()) {
                maxOverExpected = selectedPenalty;
            } else {
                long x0 = System.currentTimeMillis();
                MultiCriteriaBranchAndBoundSelection selection = new MultiCriteriaBranchAndBoundSelection(model.getProperties());
                selection.setModel(model);
                selection.setPreferredSections(preferredSectionsForCourse);
                selection.setRequiredSections(hashtable);
                selection.setRequiredFreeTimes(requiredFreeTimes);
                selection.setTimeout(100);
                Enrollment[] neighbour = selection.select((Assignment)assignment, student, (MultiCriteriaBranchAndBoundSelection.SelectionCriterion)new BestPenaltyCriterion(student, model));
                long x1 = System.currentTimeMillis();
                if (neighbour != null) {
                    maxOverExpected = 0.0;
                    for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                        Enrollment enrollment = neighbour.getAssignment()[i];
                        if (enrollment == null || enrollment.getAssignments() == null || !enrollment.isCourseRequest()) continue;
                        for (Section section2 : enrollment.getSections()) {
                            maxOverExpected += model.getOverExpected((Assignment)assignment, neighbour.getAssignment(), i, section2, enrollment.getRequest());
                        }
                    }
                    if (maxOverExpected < selectedPenalty) {
                        maxOverExpected = selectedPenalty;
                    }
                    helper.debug("Maximum number of over-expected sections limited to " + maxOverExpected + " (computed in " + (x1 - x0) + " ms).");
                }
            }
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        selection.setPreferredSections(preferredSectionsForCourse);
        selection.setRequiredSections(requiredOrSavedSectionsForCourse);
        selection.setRequiredFreeTimes(requiredFreeTimes);
        selection.setRequiredUnassinged(requiredUnassigned);
        if (maxOverExpected >= 0.0) {
            selection.setMaxOverExpected(maxOverExpected);
        }
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student);
        boolean assigned = false;
        if (neighbour != null) {
            for (Enrollment e : neighbour.getAssignment()) {
                if (e == null) continue;
                assigned = true;
                break;
            }
        }
        if (!assigned) {
            selection.setRequiredSections(new Hashtable());
            selection.setRequiredFreeTimes(new HashSet());
            neighbour = selection.select((Assignment)assignment, student);
        }
        if (neighbour == null && student.getRequests().isEmpty()) {
            neighbour = new BranchBoundSelection.BranchBoundNeighbour(student, 0.0, new Enrollment[0]);
        }
        if (neighbour == null) {
            throw new SectioningException(MSG.exceptionNoSolution());
        }
        helper.debug("Using " + (server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal") + " weighting model with " + server.getConfig().getPropertyInt("Neighbour.BranchAndBoundTimeout", 1000) + " ms time limit.");
        neighbour.assign((Assignment)assignment, 0L);
        helper.debug("Solution: " + ToolBox.dict2string((Map)model.getInfo((Assignment)assignment), (int)2));
        OnlineSectioningLog.Enrollment.Builder solution = OnlineSectioningLog.Enrollment.newBuilder();
        solution.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
        solution.setValue(-neighbour.value((Assignment)assignment));
        for (Enrollment e : neighbour.getAssignment()) {
            if (e == null || e.getAssignments() == null) continue;
            for (Section section2 : e.getAssignments()) {
                solution.addSection(OnlineSectioningHelper.toProto((SctAssignment)section2, e));
            }
        }
        action.addEnrollment(solution);
        long t2 = System.currentTimeMillis();
        ClassAssignmentInterface ret = this.convert(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, neighbour, hashtable, hashSet, enrolled);
        if (unavailabilities != null) {
            for (ClassAssignmentInterface.CourseAssignment ca : unavailabilities.getCourseAssignments()) {
                ret.getCourseAssignments().add(0, ca);
            }
        }
        long t3 = System.currentTimeMillis();
        helper.debug("Sectioning took " + (t3 - t0) + "ms (model " + (t1 - t0) + "ms, sectioning " + (t2 - t1) + "ms, conversion " + (t3 - t2) + "ms)");
        ArrayList<ClassAssignmentInterface> rets = new ArrayList<ClassAssignmentInterface>(1);
        rets.add(ret);
        return rets;
    }

    public static Course clone(XOffering offering, XEnrollments enrollments, Long courseId, long studentId, XStudent originalStudent, Map<Long, Section> sections, OnlineSectioningServer server, StudentSectioningModel model, boolean hasAssignment) {
        Offering clonedOffering = new Offering(offering.getOfferingId().longValue(), offering.getName());
        clonedOffering.setModel((Model)model);
        XExpectations expectations = server.getExpectations(offering.getOfferingId());
        XCourse course = offering.getCourse(courseId);
        int courseLimit = course.getLimit();
        if (courseLimit >= 0) {
            if ((courseLimit -= enrollments.countEnrollmentsForCourse(courseId)) < 0) {
                courseLimit = 0;
            }
            for (XEnrollment enrollment2 : enrollments.getEnrollmentsForCourse(courseId)) {
                if (!enrollment2.getStudentId().equals(studentId)) continue;
                ++courseLimit;
                break;
            }
        }
        Course clonedCourse = new Course(courseId.longValue(), course.getSubjectArea(), course.getCourseNumber(), clonedOffering, courseLimit, course.getProjected());
        clonedCourse.setNote(course.getNote());
        clonedCourse.setCreditValue(course.getMinCredit());
        Hashtable<Long, OnlineConfig> configs = new Hashtable<Long, OnlineConfig>();
        Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
        for (XConfig config : offering.getConfigs()) {
            int configLimit = config.getLimit();
            int configEnrl = enrollments.countEnrollmentsForConfig(config.getConfigId());
            boolean configStudent = false;
            if (studentId >= 0L) {
                for (XEnrollment xEnrollment : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!xEnrollment.getStudentId().equals(studentId)) continue;
                    --configEnrl;
                    configStudent = true;
                    break;
                }
            }
            if (configLimit >= 0) {
                if ((configLimit -= configEnrl) < 0) {
                    configLimit = 0;
                }
                if (configStudent && configLimit == 0) {
                    configLimit = 1;
                }
            }
            OnlineConfig onlineConfig = new OnlineConfig(config.getConfigId().longValue(), configLimit, config.getName(), clonedOffering);
            if (config.getInstructionalMethod() != null) {
                onlineConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                onlineConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                onlineConfig.setInstructionalMethodReference(config.getInstructionalMethod().getReference());
            }
            onlineConfig.setEnrollment(configEnrl);
            configs.put(config.getConfigId(), onlineConfig);
            for (XSubpart xSubpart : config.getSubparts()) {
                Subpart clonedSubpart = new Subpart(xSubpart.getSubpartId().longValue(), xSubpart.getInstructionalType(), xSubpart.getName(), (Config)onlineConfig, xSubpart.getParentId() == null ? null : (Subpart)subparts.get(xSubpart.getParentId()));
                clonedSubpart.setAllowOverlap(xSubpart.isAllowOverlap());
                clonedSubpart.setCredit(xSubpart.getCredit(courseId));
                subparts.put(xSubpart.getSubpartId(), clonedSubpart);
                for (XSection section : xSubpart.getSections()) {
                    int limit = section.getLimit();
                    int enrl = enrollments.countEnrollmentsForSection(section.getSectionId());
                    boolean student = false;
                    if (studentId >= 0L) {
                        for (XEnrollment xEnrollment : enrollments.getEnrollmentsForSection(section.getSectionId())) {
                            if (!xEnrollment.getStudentId().equals(studentId)) continue;
                            --enrl;
                            student = true;
                            break;
                        }
                    }
                    if (limit >= 0) {
                        if ((limit -= enrl) < 0) {
                            limit = 0;
                        }
                        if (student && limit == 0) {
                            limit = 1;
                        }
                    }
                    ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
                    for (XRoom r : section.getRooms()) {
                        rooms.add(new RoomLocation(r.getUniqueId(), r.getName(), null, 0, 0, r.getX(), r.getY(), r.getIgnoreTooFar(), null));
                    }
                    Placement placement = section.getTime() == null || section.getTime().getDays() == 0 ? null : new Placement(new Lecture(section.getSectionId(), null, section.getSubpartId(), section.getName(), new ArrayList(), new ArrayList(), section.getNrRooms(), null, section.getLimit(), section.getLimit(), 1.0), new TimeLocation(section.getTime().getDays(), section.getTime().getSlot(), section.getTime().getLength(), 0, 0.0, section.getTime().getDatePatternId(), section.getTime().getDatePatternName(), section.getTime().getWeeks(), section.getTime().getBreakTime()), rooms);
                    OnlineSection clonedSection = new OnlineSection(section.getSectionId().longValue(), limit, section.getName(course.getCourseId()), clonedSubpart, placement, section.toInstructors(), section.getParentId() == null ? null : sections.get(section.getParentId()));
                    clonedSection.setName(-1L, section.getName(-1L));
                    clonedSection.setNote(section.getNote());
                    clonedSection.setSpaceExpected(expectations.getExpectedSpace(section.getSectionId()).doubleValue());
                    clonedSection.setEnrollment(enrl);
                    clonedSection.setCancelled(section.isCancelled());
                    clonedSection.setEnabled(student || section.isEnabledForScheduling());
                    for (XDistribution distribution : offering.getDistributions()) {
                        if (distribution.getDistributionType() != XDistributionType.IngoreConflicts || !distribution.hasSection(section.getSectionId())) continue;
                        for (Long id : distribution.getSectionIds()) {
                            if (id.equals(section.getSectionId())) continue;
                            clonedSection.addIgnoreConflictWith(id.longValue());
                        }
                    }
                    if (limit > 0) {
                        double available = Math.round(clonedSection.getSpaceExpected() - (double)limit);
                        clonedSection.setPenalty(available / (double)section.getLimit());
                    }
                    sections.put(section.getSectionId(), (Section)clonedSection);
                }
            }
        }
        boolean hasMustUse = false;
        for (XReservation reservation : offering.getReservations()) {
            boolean applicable;
            int reservationLimit = Math.round(reservation.getLimit());
            if (reservationLimit >= 0) {
                if ((reservationLimit -= enrollments.countEnrollmentsForReservation(reservation.getReservationId())) < 0) {
                    reservationLimit = 0;
                }
                for (XEnrollment xEnrollment : enrollments.getEnrollmentsForReservation(reservation.getReservationId())) {
                    if (!xEnrollment.getStudentId().equals(studentId)) continue;
                    ++reservationLimit;
                    break;
                }
                if (reservationLimit <= 0 && !(reservation.mustBeUsed() & !reservation.isExpired())) continue;
            }
            boolean bl = applicable = originalStudent != null && reservation.isApplicable(originalStudent, course);
            if (reservation instanceof XCourseReservation) {
                applicable = ((XCourseReservation)reservation).getCourseId().equals(courseId);
            }
            if (reservation instanceof XDummyReservation) {
                for (XEnrollment xEnrollment : enrollments.getEnrollmentsForCourse(courseId)) {
                    if (!xEnrollment.getStudentId().equals(studentId)) continue;
                    applicable = true;
                    break;
                }
            }
            if (applicable && reservation.mustBeUsed() && (reservation.isOverride() || !reservation.isExpired())) {
                hasMustUse = true;
            }
            if (!applicable && reservation.isExpired()) continue;
            OnlineReservation onlineReservation = new OnlineReservation(reservation.getType().ordinal(), reservation.getReservationId().longValue(), clonedOffering, reservation.getPriority(), reservation.canAssignOverLimit(), reservationLimit, applicable, reservation.mustBeUsed(), reservation.isAllowOverlap(), reservation.isExpired(), reservation.isOverride());
            onlineReservation.setAllowDisabled(reservation.isAllowDisabled());
            for (Long l : reservation.getConfigsIds()) {
                onlineReservation.addConfig((Config)configs.get(l));
            }
            for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                HashSet<Section> clonedSections = new HashSet<Section>();
                for (Long sectionId : entry.getValue()) {
                    clonedSections.add(sections.get(sectionId));
                }
                onlineReservation.getSections().put(subparts.get(entry.getKey()), clonedSections);
            }
        }
        if (!offering.getReservations().isEmpty() && hasAssignment) {
            for (XEnrollment enrollment6 : enrollments.getEnrollmentsForCourse(courseId)) {
                if (!enrollment6.getStudentId().equals(studentId)) continue;
                OnlineReservation clonedReservation = new OnlineReservation(XReservationType.Dummy.ordinal(), -2L, clonedOffering, 1000, false, 1, true, false, false, hasMustUse, true);
                clonedReservation = new OnlineReservation(XReservationType.Dummy.ordinal(), -2L, clonedOffering, 1000, false, 1, true, hasMustUse, false, true, true);
                clonedReservation.addConfig((Config)configs.get(enrollment6.getConfigId()));
                for (Long l : enrollment6.getSectionIds()) {
                    clonedReservation.addSection(sections.get(l));
                }
            }
        }
        return clonedCourse;
    }

    public static void addRequest(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, XStudent originalStudent, CourseRequestInterface.Request request, boolean alternative, boolean updateFromCache, Map<Long, Section> classTable, Set<XDistribution> distributions, boolean hasAssignment) {
        FindAssignmentAction.addRequest(server, model, assignment, student, originalStudent, request, alternative, updateFromCache, classTable, distributions, hasAssignment, false);
    }

    public static void addRequest(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, XStudent originalStudent, CourseRequestInterface.Request request, boolean alternative, boolean updateFromCache, Map<Long, Section> classTable, Set<XDistribution> distributions, boolean hasAssignment, boolean excludeInactive) {
        if (request.hasRequestedCourse()) {
            Vector<Course> cr = new Vector<Course>();
            HashSet<Choice> selChoices = new HashSet<Choice>();
            HashSet<Choice> reqChoices = new HashSet<Choice>();
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isFreeTime()) {
                    for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                        int dayCode = 0;
                        for (DayCode d : DayCode.values()) {
                            if (!freeTime.getDays().contains(d.getIndex())) continue;
                            dayCode |= d.getCode();
                        }
                        TimeLocation freeTimeLoc = new TimeLocation(dayCode, freeTime.getStart(), freeTime.getLength(), 0, 0.0, Long.valueOf(-1L), "", server.getAcademicSession().getFreeTimePattern(), 0);
                        new FreeTimeRequest((long)(student.getRequests().size() + 1), student.getRequests().size(), alternative, student, freeTimeLoc);
                    }
                    continue;
                }
                if (!rc.isCourse() || excludeInactive && rc.isInactive()) continue;
                XCourseId courseInfo = server.getCourse(rc.getCourseId(), rc.getCourseName());
                XOffering offering = null;
                if (courseInfo != null) {
                    offering = server.getOffering(courseInfo.getOfferingId());
                }
                if (offering == null) continue;
                Course course = FindAssignmentAction.clone(offering, server.getEnrollments(offering.getOfferingId()), courseInfo.getCourseId(), student.getId(), originalStudent, classTable, server, model, hasAssignment);
                cr.add(course);
                if (rc.hasSelectedIntructionalMethods()) {
                    for (Config config : course.getOffering().getConfigs()) {
                        if (config.getInstructionalMethodId() == null || !rc.isSelectedIntructionalMethod(config.getInstructionalMethodId())) continue;
                        selChoices.add(new Choice(config));
                        if (!rc.isSelectedIntructionalMethod(config.getInstructionalMethodId(), true)) continue;
                        reqChoices.add(new Choice(config));
                    }
                }
                if (rc.hasSelectedClasses()) {
                    for (Config config : course.getOffering().getConfigs()) {
                        for (Subpart subpart : config.getSubparts()) {
                            for (Section section : subpart.getSections()) {
                                if (!rc.isSelectedClass(section.getId())) continue;
                                selChoices.add(new Choice(section));
                                if (!rc.isSelectedClass(section.getId(), true)) continue;
                                for (Section s = section; s != null; s = s.getParent()) {
                                    reqChoices.add(new Choice(s));
                                }
                                reqChoices.add(new Choice(section.getSubpart().getConfig()));
                            }
                        }
                    }
                }
                distributions.addAll(offering.getDistributions());
            }
            if (!cr.isEmpty()) {
                CourseRequest clonnedRequest = new CourseRequest((long)(student.getRequests().size() + 1), student.getRequests().size(), alternative, student, cr, request.isWaitList(), null);
                clonnedRequest.getSelectedChoices().addAll(selChoices);
                clonnedRequest.getRequiredChoices().addAll(reqChoices);
                if (originalStudent != null) {
                    block8: for (XRequest originalRequest : originalStudent.getRequests()) {
                        XEnrollment originalEnrollment = originalRequest instanceof XCourseRequest ? ((XCourseRequest)originalRequest).getEnrollment() : null;
                        for (Course clonnedCourse : clonnedRequest.getCourses()) {
                            boolean needReservation;
                            if (originalEnrollment == null || !originalEnrollment.getCourseId().equals(clonnedCourse.getId())) continue;
                            if (!clonnedRequest.getRequiredChoices().isEmpty()) {
                                boolean config = false;
                                for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                    Section clonnedSection = classTable.get(originalSectionId);
                                    clonnedRequest.getRequiredChoices().add(new Choice(clonnedSection));
                                    if (config) continue;
                                    clonnedRequest.getRequiredChoices().add(new Choice(clonnedSection.getSubpart().getConfig()));
                                    config = true;
                                }
                            }
                            if (!clonnedCourse.getOffering().hasReservations()) continue block8;
                            boolean bl = needReservation = clonnedCourse.getOffering().getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0;
                            if (!needReservation) {
                                boolean configChecked = false;
                                for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                    Section clonnedSection = classTable.get(originalSectionId);
                                    if (clonnedSection.getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0) {
                                        needReservation = true;
                                        break;
                                    }
                                    if (!configChecked && clonnedSection.getSubpart().getConfig().getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0) {
                                        needReservation = true;
                                        break;
                                    }
                                    configChecked = true;
                                }
                            }
                            if (!needReservation) continue block8;
                            OnlineReservation reservation = new OnlineReservation(XReservationType.Dummy.ordinal(), -originalStudent.getStudentId().longValue(), clonnedCourse.getOffering(), 1000, false, 1, true, false, false, true);
                            for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                reservation.addSection(classTable.get(originalSectionId));
                            }
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    protected ClassAssignmentInterface convert(OnlineSectioningServer server, Assignment<Request, Enrollment> assignment, Enrollment[] enrollments, Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse, HashSet<FreeTimeRequest> requiredFreeTimes, boolean computeOverlaps, StudentQuality sq, Set<IdPair> savedClasses) throws SectioningException {
        DistanceMetric m = server.getDistanceMetric();
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        ClassAssignmentInterface ret = new ClassAssignmentInterface();
        int nrUnassignedCourses = 0;
        int nrAssignedAlt = 0;
        float assignedCredit = 0.0f;
        for (Enrollment enrollment : enrollments) {
            if (enrollment == null || enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) continue;
            assignedCredit += enrollment.getCredit();
        }
        for (Enrollment enrollment : enrollments) {
            CourseRequest r;
            ClassAssignmentInterface.ClassAssignment a;
            if (enrollment == null || enrollment.getRequest().isAlternative() && nrAssignedAlt >= nrUnassignedCourses && (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty())) continue;
            if (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) {
                CourseRequest r2;
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                if (enrollment.getRequest() instanceof CourseRequest) {
                    r2 = (CourseRequest)enrollment.getRequest();
                    Enrollment[] course = enrollment.getCourse();
                    if (server.isOfferingLocked(course.getOffering().getId())) {
                        ca.setLocked(true);
                    }
                    ca.setAssigned(false);
                    ca.setCourseId(course.getId());
                    ca.setSubject(course.getSubjectArea());
                    ca.setCourseNbr(course.getCourseNumber());
                    XCourse xc = server.getCourse(course.getId());
                    if (xc != null) {
                        ca.setTitle(xc.getTitle());
                    }
                    ca.setWaitListed(r2.isWaitlist());
                    ca.setHasCrossList(course.getOffering().getCourses().size() > 1);
                    if (!r2.isWaitlist()) {
                        ++nrUnassignedCourses;
                    }
                    if (computeOverlaps) {
                        TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                            @Override
                            public int compare(Enrollment e1, Enrollment e2) {
                                return e1.getRequest().compareTo(e2.getRequest());
                            }
                        });
                        Hashtable<Enrollment[], TreeSet<Section>> overlapingSections = new Hashtable<Enrollment[], TreeSet<Section>>();
                        List avEnrls = r2.getAvaiableEnrollmentsSkipSameTime(assignment);
                        for (Enrollment enrl : avEnrls) {
                            for (Enrollment x : enrollments) {
                                if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment) continue;
                                for (SctAssignment a2 : x.getAssignments()) {
                                    if (!a2.isOverlapping(enrl.getAssignments())) continue;
                                    overlap.add(x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    Enrollment[] cr = (Enrollment[])x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a2);
                                }
                            }
                        }
                        for (Enrollment q : overlap) {
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            String ov = o.getSubjectArea() + " " + o.getCourseNumber();
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = ov + ",";
                                }
                            }
                            ca.addOverlap(ov);
                        }
                        block7: for (Enrollment[] unavailability : enrollment.getStudent().getUnavailabilities()) {
                            for (Config config : course.getOffering().getConfigs()) {
                                for (Subpart subpart : config.getSubparts()) {
                                    for (Section section : subpart.getSections()) {
                                        if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                        ca.addOverlap(MSG.teachingAssignment(unavailability.getSection().getName()));
                                        continue block7;
                                    }
                                }
                            }
                        }
                        int alt = nrUnassignedCourses;
                        for (Enrollment x : enrollments) {
                            if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment || !x.getRequest().isAlternative() || !(x.getRequest() instanceof CourseRequest) || --alt != 0) continue;
                            Course o = x.getCourse();
                            ca.setInstead(o.getSubjectArea() + " " + o.getCourseNumber());
                            break;
                        }
                        if (avEnrls.isEmpty()) {
                            ca.setNotAvailable(true);
                            ca.setFull(course.getLimit() == 0);
                        }
                        if (r2.getStudent().hasMaxCredit()) {
                            Float minCred = null;
                            for (Course c : r2.getCourses()) {
                                if (!c.hasCreditValue() || minCred != null && !(minCred.floatValue() > c.getCreditValue().floatValue())) continue;
                                minCred = c.getCreditValue();
                            }
                            if (minCred != null && assignedCredit + minCred.floatValue() > r2.getStudent().getMaxCredit()) {
                                ca.setOverMaxCredit(Float.valueOf(r2.getStudent().getMaxCredit()));
                            }
                        }
                    }
                    ret.add(ca);
                    continue;
                }
                r2 = (FreeTimeRequest)enrollment.getRequest();
                ca.setAssigned(false);
                ca.setCourseId(null);
                if (computeOverlaps) {
                    for (Enrollment x : enrollments) {
                        if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment) continue;
                        for (SctAssignment a3 : x.getAssignments()) {
                            if (!r2.isOverlapping(a3) || !(x.getRequest() instanceof CourseRequest)) continue;
                            Course o = x.getCourse();
                            Section s = (Section)a3;
                            ca.addOverlap(o.getSubjectArea() + " " + o.getCourseNumber() + " " + s.getSubpart().getName());
                        }
                    }
                }
                if (ca.getOverlaps() == null) {
                    ca.setAssigned(true);
                }
                a = ca.addClassAssignment();
                a.setAlternative(r2.isAlternative());
                for (DayCode d : DayCode.toDayCodes(r2.getTime().getDayCode())) {
                    a.addDay(d.getIndex());
                }
                a.setStart(r2.getTime().getStartSlot());
                a.setLength(r2.getTime().getLength());
                ret.add(ca);
                continue;
            }
            if (enrollment.getRequest() instanceof CourseRequest) {
                r = (CourseRequest)enrollment.getRequest();
                Set<Section> requiredSections = null;
                if (requiredSectionsForCourse != null) {
                    requiredSections = requiredSectionsForCourse.get(r);
                }
                if (r.isAlternative() && assignment.getValue((Variable)r) != null) {
                    ++nrAssignedAlt;
                }
                TreeSet<Section> sections = new TreeSet<Section>(new EnrollmentSectionComparator());
                sections.addAll(enrollment.getSections());
                Course course = enrollment.getCourse();
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                if (server.isOfferingLocked(course.getOffering().getId())) {
                    ca.setLocked(true);
                }
                ca.setAssigned(true);
                ca.setWaitListed(r.isWaitlist());
                ca.setCourseId(course.getId());
                ca.setSubject(course.getSubjectArea());
                ca.setCourseNbr(course.getCourseNumber());
                ca.setHasCrossList(course.getOffering().getCourses().size() > 1);
                boolean hasAlt = false;
                if (r.getCourses().size() > 1) {
                    hasAlt = true;
                } else if (course.getOffering().getConfigs().size() > 1) {
                    hasAlt = true;
                } else {
                    for (Subpart s : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (s.getSections().size() <= 1) continue;
                        hasAlt = true;
                        break;
                    }
                }
                XOffering offering = server.getOffering(course.getOffering().getId());
                ca.setTitle(offering.getCourse(course.getId()).getTitle());
                XEnrollments enrl = server.getEnrollments(offering.getOfferingId());
                for (Section section : sections) {
                    Float credit;
                    Object x;
                    ClassAssignmentInterface.ClassAssignment a4 = ca.addClassAssignment();
                    a4.setAlternative(r.isAlternative());
                    a4.setClassId(section.getId());
                    a4.setSubpart(section.getSubpart().getName());
                    a4.setSection(section.getName(course.getId()));
                    a4.setExternalId(offering.getSection(section.getId()).getExternalId(course.getId()));
                    a4.setClassNumber(section.getName(-1L));
                    a4.setCancelled(section.isCancelled());
                    a4.setLimit(new int[]{enrl.countEnrollmentsForSection(section.getId()), offering.getSection(section.getId()).getLimit()});
                    if (section.getLimit() == 0) {
                        a4.setOverlapNote(MSG.sectionIsFull());
                    }
                    if (section.getTime() != null) {
                        for (DayCode d : DayCode.toDayCodes(section.getTime().getDayCode())) {
                            a4.addDay(d.getIndex());
                        }
                        a4.setStart(section.getTime().getStartSlot());
                        a4.setLength(section.getTime().getLength());
                        a4.setBreakTime(section.getTime().getBreakTime());
                        a4.setDatePattern(section.getTime().getDatePatternName());
                    } else {
                        x = offering.getSection(section.getId());
                        if (x != null && ((XSection)x).getTime() != null) {
                            a4.setDatePattern(((XSection)x).getTime().getDatePatternName());
                        }
                    }
                    if (section.getRooms() != null) {
                        for (RoomLocation rm : section.getRooms()) {
                            a4.addRoom(rm.getId(), rm.getName());
                        }
                    } else {
                        x = offering.getSection(section.getId());
                        if (x != null) {
                            for (XRoom rm : ((XSection)x).getRooms()) {
                                a4.addRoom(rm.getUniqueId(), rm.getName());
                            }
                        }
                    }
                    if (section.hasInstructors()) {
                        for (Instructor instructor : section.getInstructors()) {
                            a4.addInstructor(instructor.getName());
                            a4.addInstructoEmail(instructor.getEmail());
                        }
                    }
                    if (section.getParent() != null) {
                        a4.setParentSection(section.getParent().getName(course.getId()));
                    }
                    if (requiredSections != null && requiredSections.contains(section)) {
                        a4.setPinned(true);
                    }
                    a4.setSubpartId(section.getSubpart().getId());
                    a4.setHasAlternatives(hasAlt);
                    a4.addNote(course.getNote());
                    a4.addNote(section.getNote());
                    a4.setCredit(section.getSubpart().getCredit());
                    XSection xSection = offering.getSection(section.getId());
                    if (xSection != null && (credit = xSection.getCreditOverride(course.getId())) != null) {
                        a4.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                    }
                    int dist = 0;
                    String from = null;
                    TreeSet<String> overlap = new TreeSet<String>();
                    for (Enrollment x2 : enrollments) {
                        if (x2 == null || !x2.isCourseRequest() || x2.getAssignments() == null || x2.getAssignments().isEmpty()) continue;
                        for (Section s : x2.getSections()) {
                            if (s == section || s.getTime() == null) continue;
                            int d = this.distance(m, s, section);
                            if (d > dist) {
                                dist = d;
                                from = "";
                                Iterator k = s.getRooms().iterator();
                                while (k.hasNext()) {
                                    from = from + ((RoomLocation)k.next()).getName() + (k.hasNext() ? ", " : "");
                                }
                            }
                            if (sq.hasDistanceConflict(enrollment.getStudent(), s, section) && s.getTime().getStartSlot() < section.getTime().getStartSlot()) {
                                a4.setDistanceConflict(true);
                            }
                            if (section.getTime() == null || !section.getTime().hasIntersection(s.getTime()) || section.isToIgnoreStudentConflictsWith(s.getId())) continue;
                            overlap.add(MSG.clazz(x2.getCourse().getSubjectArea(), x2.getCourse().getCourseNumber(), s.getSubpart().getName(), s.getName(x2.getCourse().getId())));
                        }
                    }
                    for (Unavailability unavailability : enrollment.getStudent().getUnavailabilities()) {
                        if (section.getTime() == null || unavailability.getTime() == null || !section.getTime().hasIntersection(unavailability.getTime())) continue;
                        overlap.add(unavailability.getSection().getName());
                    }
                    if (!overlap.isEmpty()) {
                        String note = null;
                        Iterator j = overlap.iterator();
                        while (j.hasNext()) {
                            String n = (String)j.next();
                            if (note == null) {
                                if (section.getLimit() == 0) {
                                    note = MSG.noteFullSectionOverlapFirst(n);
                                    continue;
                                }
                                note = MSG.noteAllowedOverlapFirst(n);
                                continue;
                            }
                            if (j.hasNext()) {
                                note = note + MSG.noteAllowedOverlapMiddle(n);
                                continue;
                            }
                            note = note + MSG.noteAllowedOverlapLast(n);
                        }
                        a4.setOverlapNote(note);
                    }
                    a4.setBackToBackDistance(dist);
                    a4.setBackToBackRooms(from);
                    if (savedClasses != null && savedClasses.contains(new IdPair(course.getId(), section.getId()))) {
                        a4.setSaved(true);
                    }
                    if (a4.getParentSection() == null) {
                        a4.setParentSection(server.getCourse(course.getId()).getConsentLabel());
                    }
                    a4.setExpected(overExp.getExpected(section.getLimit(), section.getSpaceExpected()));
                    if (this.getSpecialRegistration() == null) continue;
                    for (ClassAssignmentInterface.ClassAssignment b : this.getSpecialRegistration()) {
                        if (!b.getClassId().equals(a4.getClassId())) continue;
                        a4.setSpecRegStatus(b.getSpecRegStatus());
                        a4.setSpecRegOperation(b.getSpecRegOperation());
                        if (!b.hasError()) continue;
                        a4.setError(b.getError());
                    }
                }
                ret.add(ca);
                continue;
            }
            r = (FreeTimeRequest)enrollment.getRequest();
            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
            ca.setAssigned(true);
            ca.setCourseId(null);
            a = ca.addClassAssignment();
            a.setAlternative(r.isAlternative());
            for (DayCode d : DayCode.toDayCodes(r.getTime().getDayCode())) {
                a.addDay(d.getIndex());
            }
            a.setStart(r.getTime().getStartSlot());
            a.setLength(r.getTime().getLength());
            if (requiredFreeTimes != null && requiredFreeTimes.contains(r)) {
                a.setPinned(true);
            }
            ret.add(ca);
        }
        return ret;
    }

    private ClassAssignmentInterface convert(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, BranchBoundSelection.BranchBoundNeighbour neighbour, Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse, HashSet<FreeTimeRequest> requiredFreeTimes, Set<IdPair> savedClasses) throws SectioningException {
        Enrollment[] enrollments = neighbour.getAssignment();
        if (enrollments == null || enrollments.length < student.getRequests().size()) {
            throw new SectioningException(MSG.exceptionNoSolution());
        }
        int idx = 0;
        for (Request r : student.getRequests()) {
            if (enrollments[idx] == null) {
                Config c = null;
                if (r instanceof CourseRequest) {
                    c = (Config)((Course)((CourseRequest)r).getCourses().get(0)).getOffering().getConfigs().get(0);
                }
                enrollments[idx] = new Enrollment(r, 0, c, null, assignment);
            }
            ++idx;
        }
        ClassAssignmentInterface ret = this.convert(server, assignment, enrollments, requiredSectionsForCourse, requiredFreeTimes, true, model.getStudentQuality(), savedClasses);
        ret.setValue(-neighbour.value(assignment));
        return ret;
    }

    @Override
    public String name() {
        return "section";
    }

    public int distance(DistanceMetric m, Section s1, Section s2) {
        TimeLocation t2;
        if (s1.getPlacement() == null || s2.getPlacement() == null) {
            return 0;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getNrSlotsPerMeeting() <= a2 && (dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getNrSlotsPerMeeting() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement());
        }
        return 0;
    }

    public static class IdPair {
        private Long iId1;
        private Long iId2;

        public IdPair(Long id1, Long id2) {
            this.iId1 = id1;
            this.iId2 = id2;
        }

        public Long getId1() {
            return this.iId1;
        }

        public Long getId2() {
            return this.iId2;
        }

        public int hashCode() {
            return this.iId1.hashCode() ^ this.iId2.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IdPair)) {
                return false;
            }
            return this.iId1.equals(((IdPair)o).iId1) && this.iId2.equals(((IdPair)o).iId2);
        }
    }

    public static class EnrollmentSectionComparator
    implements Comparator<Section> {
        public boolean isParent(Section s1, Section s2) {
            Section p1 = s1.getParent();
            if (p1 == null) {
                return false;
            }
            if (p1.equals((Object)s2)) {
                return true;
            }
            return this.isParent(p1, s2);
        }

        @Override
        public int compare(Section a, Section b) {
            if (this.isParent(a, b)) {
                return 1;
            }
            if (this.isParent(b, a)) {
                return -1;
            }
            int cmp = a.getSubpart().getInstructionalType().compareToIgnoreCase(b.getSubpart().getInstructionalType());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.getId(), b.getId());
        }
    }
}

