/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructorAssignment;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XStudentNote;

@SerializeWith(value=XStudentSerializer.class)
public class XStudent
extends XStudentId
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private List<XAreaClassificationMajor> iMajors = new ArrayList<XAreaClassificationMajor>();
    private List<XGroup> iGroups = new ArrayList<XGroup>();
    private List<String> iAccomodations = new ArrayList<String>();
    private List<XRequest> iRequests = new ArrayList<XRequest>();
    private String iStatus = null;
    private String iEmail = null;
    private Date iEmailTimeStamp = null;
    private List<XInstructorAssignment> iInstructorAssignments = new ArrayList<XInstructorAssignment>();
    private XStudentNote iLastNote = null;
    private Float iMaxCredit = null;
    private XOverride iMaxCreditOverride = null;
    private boolean iAllowDisabled = false;
    private List<XAdvisor> iAdvisors = new ArrayList<XAdvisor>();

    public XStudent() {
    }

    public XStudent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XStudent(Long studentId, String externalId, String name) {
        super(studentId, externalId, name);
    }

    /*
     * WARNING - void declaration
     */
    public XStudent(org.unitime.timetable.model.Student student, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        super(student, helper);
        void var6_22;
        this.iStatus = student.getSectioningStatus() == null ? null : student.getSectioningStatus().getReference();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate();
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
            this.iMajors.add(new XAreaClassificationMajor(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getMajor().getCode()));
        }
        if (this.iMajors.size() > 1) {
            Collections.sort(this.iMajors);
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            this.iGroups.add(new XGroup(studentGroup));
            StudentGroupType studentGroupType = studentGroup.getType();
            if (studentGroupType == null || studentGroupType.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.AlwaysAllowed) continue;
            this.iAllowDisabled = true;
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            this.iAccomodations.add(studentAccomodation.getAbbreviation());
        }
        for (Advisor advisor : student.getAdvisors()) {
            this.iAdvisors.add(new XAdvisor(advisor.getExternalUniqueId(), advisor.getLastName() == null ? null : helper.getInstructorNameFormat().format(advisor), advisor.getEmail()));
        }
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        demands.addAll(student.getCourseDemands());
        for (CourseDemand courseDemand : demands) {
            if (courseDemand.getFreeTime() != null) {
                this.iRequests.add(new XFreeTimeRequest(courseDemand, freeTimePattern));
                continue;
            }
            if (courseDemand.getCourseRequests().isEmpty()) continue;
            this.iRequests.add(new XCourseRequest(courseDemand, helper));
        }
        HashMap<CourseOffering, ArrayList<StudentClassEnrollment>> hashMap = new HashMap<CourseOffering, ArrayList<StudentClassEnrollment>>();
        for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
            if (this.getRequestForCourse(enrollment.getCourseOffering().getUniqueId()) != null) continue;
            ArrayList<StudentClassEnrollment> classes = (ArrayList<StudentClassEnrollment>)hashMap.get(enrollment.getCourseOffering());
            if (classes == null) {
                classes = new ArrayList<StudentClassEnrollment>();
                hashMap.put(enrollment.getCourseOffering(), classes);
            }
            classes.add(enrollment);
        }
        if (!hashMap.isEmpty()) {
            boolean bl = false;
            for (XRequest request : this.iRequests) {
                int n;
                if (request.isAlternative() || request.getPriority() <= n) continue;
                n = request.getPriority();
            }
            for (CourseOffering course : new TreeSet(hashMap.keySet())) {
                void var6_20;
                List classes = (List)hashMap.get(course);
                this.iRequests.add(new XCourseRequest(student, course, (int)(++var6_20), helper, classes));
            }
        }
        Collections.sort(this.iRequests);
        Object var6_21 = null;
        if (student.getNotes() != null) {
            for (StudentNote n : student.getNotes()) {
                if (var6_22 != null && var6_22.compareTo(n) >= 0) continue;
                StudentNote studentNote = n;
            }
        }
        if (var6_22 != null) {
            this.iLastNote = new XStudentNote((StudentNote)var6_22);
        }
        this.iMaxCredit = student.getMaxCredit();
        if (student.getOverrideMaxCredit() != null) {
            this.iMaxCreditOverride = new XOverride(student.getOverrideExternalId(), student.getOverrideTimeStamp(), student.getOverrideStatus(), student.getOverrideMaxCredit());
        }
    }

    public XStudent(XStudent student) {
        super(student);
        this.iStatus = student.getStatus();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getEmailTimeStamp();
        this.iMajors.addAll(student.getMajors());
        this.iGroups.addAll(student.getGroups());
        this.iAccomodations.addAll(student.getAccomodations());
        this.iRequests.addAll(student.getRequests());
        this.iAllowDisabled = student.iAllowDisabled;
        this.iAdvisors.addAll(student.getAdvisors());
    }

    public XStudent(XStudent student, Collection<CourseDemand> demands, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        super(student);
        this.iStatus = student.getStatus();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getEmailTimeStamp();
        this.iMajors.addAll(student.getMajors());
        this.iGroups.addAll(student.getGroups());
        this.iAccomodations.addAll(student.getAccomodations());
        this.iMaxCredit = student.getMaxCredit();
        this.iMaxCreditOverride = student.getMaxCreditOverride();
        this.iAllowDisabled = student.iAllowDisabled;
        this.iAdvisors.addAll(student.getAdvisors());
        if (demands != null) {
            for (CourseDemand cd : demands) {
                if (cd.getFreeTime() != null) {
                    this.iRequests.add(new XFreeTimeRequest(cd, freeTimePattern));
                    continue;
                }
                if (cd.getCourseRequests().isEmpty()) continue;
                this.iRequests.add(new XCourseRequest(cd, helper));
            }
        }
        Collections.sort(this.iRequests);
    }

    public static List<XRequest> loadRequests(org.unitime.timetable.model.Student student, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        ArrayList<XRequest> requests = new ArrayList<XRequest>();
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        demands.addAll(student.getCourseDemands());
        for (CourseDemand cd : demands) {
            if (cd.getFreeTime() != null) {
                requests.add(new XFreeTimeRequest(cd, freeTimePattern));
                continue;
            }
            if (cd.getCourseRequests().isEmpty()) continue;
            requests.add(new XCourseRequest(cd, helper));
        }
        Collections.sort(requests);
        return requests;
    }

    public XStudent(Student student, Assignment<Request, Enrollment> assignment) {
        super(student);
        this.iStatus = student.getStatus();
        this.iAllowDisabled = student.isAllowDisabled();
        Date date = this.iEmailTimeStamp = student.getEmailTimeStamp() == null ? null : new Date(student.getEmailTimeStamp());
        if (student.hasMaxCredit()) {
            this.iMaxCredit = Float.valueOf(student.getMaxCredit());
        }
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            this.iMajors.add(new XAreaClassificationMajor(acm.getArea(), acm.getClassification(), acm.getMajor()));
        }
        for (int i = 0; i < Math.min(student.getAcademicAreaClasiffications().size(), student.getMajors().size()); ++i) {
            this.iMajors.add(new XAreaClassificationMajor(((AcademicAreaCode)student.getMajors().get(i)).getArea(), ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(i)).getCode(), ((AcademicAreaCode)student.getMajors().get(i)).getCode()));
        }
        if (this.iMajors.size() > 1) {
            Collections.sort(this.iMajors);
        }
        for (AcademicAreaCode aac : student.getMinors()) {
            if ("A".equals(aac.getArea())) {
                this.iAccomodations.add(aac.getCode());
                continue;
            }
            this.iGroups.add(new XGroup(aac));
        }
        for (Instructor advisor : student.getAdvisors()) {
            this.iAdvisors.add(new XAdvisor(advisor.getExternalId(), advisor.getName(), advisor.getEmail()));
        }
        for (Request request : student.getRequests()) {
            if (request instanceof FreeTimeRequest) {
                this.iRequests.add(new XFreeTimeRequest((FreeTimeRequest)request));
                continue;
            }
            if (!(request instanceof CourseRequest)) continue;
            this.iRequests.add(new XCourseRequest((CourseRequest)request, assignment == null ? null : (Enrollment)assignment.getValue((Variable)request)));
        }
    }

    public List<XInstructorAssignment> getInstructorAssignments() {
        return this.iInstructorAssignments;
    }

    public boolean hasInstructorAssignments() {
        return this.iInstructorAssignments != null && !this.iInstructorAssignments.isEmpty();
    }

    public XStudentNote getLastNote() {
        return this.iLastNote;
    }

    public boolean hasLastNote() {
        return this.iLastNote != null && this.iLastNote.hasNote();
    }

    public void setLastNote(XStudentNote note) {
        this.iLastNote = note;
    }

    public XCourseRequest getRequestForCourse(Long courseId) {
        for (XRequest request : this.iRequests) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).hasCourse(courseId)) continue;
            return (XCourseRequest)request;
        }
        return null;
    }

    public XCourseRequest getRequestForCourseName(String courseName) {
        for (XRequest request : this.iRequests) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).hasCourseName(courseName)) continue;
            return (XCourseRequest)request;
        }
        return null;
    }

    public Float getMaxCredit() {
        return this.iMaxCredit;
    }

    public boolean hasMaxCredit() {
        return this.iMaxCredit != null;
    }

    public void setMaxCredit(Float maxCredit) {
        this.iMaxCredit = maxCredit;
    }

    public XOverride getMaxCreditOverride() {
        return this.iMaxCreditOverride;
    }

    public boolean isMaxCreditOverridePending() {
        return this.iMaxCreditOverride == null || this.iMaxCreditOverride.getStatus() == null ? false : this.iMaxCreditOverride.getStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public void setMaxCreditOverride(XOverride maxCreditOverride) {
        this.iMaxCreditOverride = maxCreditOverride;
    }

    public boolean isAllowDisabled() {
        return this.iAllowDisabled;
    }

    public void setAllowDisabled(boolean allowDisabled) {
        this.iAllowDisabled = allowDisabled;
    }

    public List<XAreaClassificationMajor> getMajors() {
        return this.iMajors;
    }

    public List<XGroup> getGroups() {
        return this.iGroups;
    }

    public List<String> getAccomodations() {
        return this.iAccomodations;
    }

    public boolean hasAccomodation(String accomodation) {
        return accomodation != null && this.iAccomodations.contains(accomodation);
    }

    public List<XAdvisor> getAdvisors() {
        return this.iAdvisors;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public Date getEmailTimeStamp() {
        return this.iEmailTimeStamp;
    }

    public void setEmailTimeStamp(Date emailTimeStamp) {
        this.iEmailTimeStamp = emailTimeStamp;
    }

    public List<XRequest> getRequests() {
        return this.iRequests;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public boolean canAssign(XCourseRequest request) {
        if (request.getEnrollment() != null) {
            return true;
        }
        int alt = 0;
        boolean found = false;
        for (XRequest r : this.iRequests) {
            boolean waitlist;
            boolean course;
            if (r.equals(request)) {
                found = true;
            }
            boolean assigned = !(course = r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() != null || r.equals(request);
            boolean bl = waitlist = course && ((XCourseRequest)r).isWaitlist();
            if (r.isAlternative()) {
                if (!assigned && (found || !waitlist)) continue;
                --alt;
                continue;
            }
            if (!course || waitlist || assigned) continue;
            ++alt;
        }
        return alt >= 0;
    }

    public Set<Long> getRequestedCourseIds() {
        HashSet<Long> courseIds = new HashSet<Long>();
        for (XRequest request : this.getRequests()) {
            if (!(request instanceof XCourseRequest)) continue;
            for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                courseIds.add(course.getCourseId());
            }
        }
        return courseIds;
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.getExternalId() + ")";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrMajors = in.readInt();
        this.iMajors.clear();
        for (int i = 0; i < nrMajors; ++i) {
            this.iMajors.add(new XAreaClassificationMajor(in));
        }
        int nrGroups = in.readInt();
        this.iGroups.clear();
        for (int i = 0; i < nrGroups; ++i) {
            this.iGroups.add(new XGroup(in));
        }
        int nrAccomodations = in.readInt();
        this.iAccomodations.clear();
        for (int i = 0; i < nrAccomodations; ++i) {
            this.iAccomodations.add((String)in.readObject());
        }
        int nrRequests = in.readInt();
        this.iRequests.clear();
        for (int i = 0; i < nrRequests; ++i) {
            this.iRequests.add(in.readBoolean() ? new XCourseRequest(in) : new XFreeTimeRequest(in));
        }
        this.iStatus = (String)in.readObject();
        this.iEmail = (String)in.readObject();
        Date date = this.iEmailTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        if (in.readBoolean()) {
            this.iLastNote = new XStudentNote(in);
        }
        this.iAllowDisabled = in.readBoolean();
        int nrAdvisors = in.readInt();
        this.iAdvisors.clear();
        for (int i = 0; i < nrAdvisors; ++i) {
            this.iAdvisors.add(new XAdvisor(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iMajors.size());
        for (XAreaClassificationMajor major : this.iMajors) {
            major.writeExternal(out);
        }
        out.writeInt(this.iGroups.size());
        for (XGroup group : this.iGroups) {
            group.writeExternal(out);
        }
        out.writeInt(this.iAccomodations.size());
        for (String accomodation : this.iAccomodations) {
            out.writeObject(accomodation);
        }
        out.writeInt(this.iRequests.size());
        for (XRequest request : this.iRequests) {
            if (request instanceof XCourseRequest) {
                out.writeBoolean(true);
                ((XCourseRequest)request).writeExternal(out);
                continue;
            }
            out.writeBoolean(false);
            ((XFreeTimeRequest)request).writeExternal(out);
        }
        out.writeObject(this.iStatus);
        out.writeObject(this.iEmail);
        out.writeBoolean(this.iEmailTimeStamp != null);
        if (this.iEmailTimeStamp != null) {
            out.writeLong(this.iEmailTimeStamp.getTime());
        }
        out.writeBoolean(this.iLastNote != null);
        if (this.iLastNote != null) {
            this.iLastNote.writeExternal(out);
        }
        out.writeBoolean(this.iAllowDisabled);
        out.writeInt(this.iAdvisors.size());
        for (XAdvisor advisor : this.iAdvisors) {
            advisor.writeExternal(out);
        }
    }

    public static class XAdvisorSerializer
    implements Externalizer<XAdvisor> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XAdvisor object) throws IOException {
            object.writeExternal(output);
        }

        public XAdvisor readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XAdvisor(input);
        }
    }

    @SerializeWith(value=XAdvisorSerializer.class)
    public static class XAdvisor
    implements Externalizable {
        public String iExternalId;
        public String iName;
        public String iEmail;

        public XAdvisor(String externalId, String name, String email) {
            this.iExternalId = externalId;
            this.iName = name;
            this.iEmail = email;
        }

        public XAdvisor(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readExternal(in);
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public String getEmail() {
            return this.iEmail;
        }

        public String getName() {
            return this.iName;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.iExternalId = (String)in.readObject();
            this.iName = (String)in.readObject();
            this.iEmail = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.iExternalId);
            out.writeObject(this.iName);
            out.writeObject(this.iEmail);
        }

        public String toString() {
            return this.iExternalId;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof XAdvisor)) {
                return false;
            }
            return this.getExternalId().equals(((XAdvisor)o).getExternalId());
        }
    }

    public static class XGroupSerializer
    implements Externalizer<XGroup> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XGroup object) throws IOException {
            object.writeExternal(output);
        }

        public XGroup readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XGroup(input);
        }
    }

    @SerializeWith(value=XGroupSerializer.class)
    public static class XGroup
    implements Externalizable {
        public String iType;
        public String iAbbreaviation;
        public String iTitle;

        public XGroup(StudentGroup g) {
            this.iType = g.getType() == null ? null : g.getType().getReference();
            this.iAbbreaviation = g.getGroupAbbreviation();
            this.iTitle = g.getGroupName() == null ? null : g.getGroupName();
        }

        public XGroup(AcademicAreaCode g) {
            this.iType = g.getArea() == null || g.getArea().isEmpty() ? null : g.getArea();
            this.iAbbreaviation = g.getCode();
            this.iTitle = g.getLabel() == null ? null : g.getLabel();
        }

        public XGroup(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readExternal(in);
        }

        public String getType() {
            return this.iType;
        }

        public String getAbbreviation() {
            return this.iAbbreaviation;
        }

        public String getTitle() {
            return this.iTitle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.iType = in.readBoolean() ? (String)in.readObject() : null;
            this.iAbbreaviation = (String)in.readObject();
            this.iTitle = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this.iType != null) {
                out.writeBoolean(true);
                out.writeObject(this.iType);
            } else {
                out.writeBoolean(false);
            }
            out.writeObject(this.iAbbreaviation);
            out.writeObject(this.iTitle);
        }

        public String toString() {
            return this.getAbbreviation();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof XGroup)) {
                return false;
            }
            return this.getAbbreviation().equals(((XGroup)o).getAbbreviation());
        }
    }

    public static class XStudentSerializer
    implements Externalizer<XStudent> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XStudent object) throws IOException {
            object.writeExternal(output);
        }

        public XStudent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XStudent(input);
        }
    }
}

