/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Student;

public abstract class BaseIndividualReservation
extends Reservation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Student> iStudents;

    public BaseIndividualReservation() {
        this.initialize();
    }

    public BaseIndividualReservation(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addTostudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof IndividualReservation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((IndividualReservation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((IndividualReservation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "IndividualReservation[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "IndividualReservation[\n\tExpirationDate: " + this.getExpirationDate() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tStartDate: " + this.getStartDate() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

