/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BasePreference;

public abstract class Preference
extends BasePreference
implements Comparable {
    private static final long serialVersionUID = 1L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final String BLANK_PREF_VALUE = "-";

    public Preference() {
    }

    public Preference(Long uniqueId) {
        super(uniqueId);
    }

    public String preferenceTitle(String nameFormat) {
        return this.getPrefLevel().getPrefName() + " " + this.preferenceText();
    }

    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " " + this.preferenceText();
    }

    public String preferenceHtml(String nameFormat) {
        return this.preferenceHtml(nameFormat, ApplicationProperty.PreferencesHighlighClassPreferences.isTrue());
    }

    public String preferenceDescription() {
        return null;
    }

    public String preferenceHtml(String nameFormat, boolean highlightClassPrefs) {
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && highlightClassPrefs) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = " (" + MSG.prefOwnerClass() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = " (" + MSG.prefOwnerSchedulingSubpart() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = " (" + MSG.prefOwnerInstructor() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = " (" + MSG.prefOwnerExamination() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = " (" + MSG.prefOwnerDepartment() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = " (" + MSG.prefOwnerSession() + ")";
        }
        String hint = HtmlUtils.htmlEscape((String)(this.preferenceTitle(nameFormat) + owner));
        String description = this.preferenceDescription();
        if (description != null && !description.isEmpty()) {
            hint = hint + "<br>" + HtmlUtils.htmlEscape((String)description.replace("'", "\\'")).replace("\n", "<br>");
        }
        sb.append("onmouseover=\"showGwtHint(this, '" + hint + "');\" onmouseout=\"hideGwtHint();\">");
        sb.append(this.preferenceAbbv(nameFormat));
        sb.append("</span>");
        return sb.toString();
    }

    public String preferenceText(String nameFormat) {
        return this.preferenceText();
    }

    public abstract String preferenceText();

    public String preferenceAbbv() {
        return this.preferenceText();
    }

    public String preferenceAbbv(String nameFormat) {
        return this.preferenceAbbv();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Preference)) {
            throw new RuntimeException("Object must be of type Preference");
        }
        Preference p = (Preference)o;
        int cmp = this.getClass().getName().compareTo(o.getClass().getName());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getUniqueId() == null || p.getUniqueId() == null) {
            return -1;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(p.getUniqueId() == null ? -1L : p.getUniqueId());
    }

    public boolean appliesTo(PreferenceGroup group) {
        return true;
    }

    public boolean weakenHardPreferences() {
        if (PreferenceLevel.sRequired.equals(this.getPrefLevel().getPrefProlog())) {
            this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
        }
        if (PreferenceLevel.sProhibited.equals(this.getPrefLevel().getPrefProlog())) {
            this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
        }
        return true;
    }

    public abstract Object clone();

    public abstract boolean isSame(Preference var1);

    public abstract Type getType();

    public static enum Type {
        TIME(TimePref.class),
        ROOM(RoomPref.class),
        ROOM_GROUP(RoomGroupPref.class),
        ROOM_FEATURE(RoomFeaturePref.class),
        BUILDING(BuildingPref.class),
        DISTRIBUTION(DistributionPref.class),
        PERIOD(ExamPeriodPref.class),
        DATE(DatePatternPref.class),
        ATTRIBUTE(InstructorAttributePref.class),
        COURSE(InstructorCoursePref.class),
        INSTRUCTOR(InstructorPref.class);

        Class<? extends Preference> iClazz;

        private Type(Class<? extends Preference> clazz) {
            this.iClazz = clazz;
        }

        public Class<? extends Preference> getImplementation() {
            return this.iClazz;
        }

        int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }

        public static int toInt(Type ... types) {
            int ret = 0;
            for (Type t : types) {
                ret += t.flag();
            }
            return ret;
        }
    }
}

