/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.Placement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.UniTimePrincipal;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseDemandDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.CheckCourses;
import org.unitime.timetable.onlinesectioning.basic.CheckEligibility;
import org.unitime.timetable.onlinesectioning.basic.CourseRequestEligibility;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.basic.GetDegreePlans;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.basic.ListClasses;
import org.unitime.timetable.onlinesectioning.basic.ListCourseOfferings;
import org.unitime.timetable.onlinesectioning.basic.ListEnrollments;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCriticalCoursesHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomDegreePlansHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.DefaultCourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.RequestStudentUpdates;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.ComputeSuggestionsAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationCancel;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationChangeGradeModes;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationEligibility;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationRetrieveAll;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationRetrieveGradeModes;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationSubmit;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationUpdate;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.FindOnlineSectioningLogAction;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindOnlineSectioningLogAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.updates.ApproveEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentGroup;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentStatus;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.MassCancelAction;
import org.unitime.timetable.onlinesectioning.updates.RejectEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.onlinesectioning.updates.SaveStudentRequests;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.permissions.AdministrationPermissions;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.BatchEnrollStudent;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.NameFormat;

@Service(value="sectioning.gwt")
public class SectioningServlet
implements SectioningService,
DisposableBean {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private static SecurityMessages SEC_MSG = Localization.create(SecurityMessages.class);
    private static Logger sLog = Logger.getLogger(SectioningServlet.class);
    private CourseDetailsProvider iCourseDetailsProvider;
    private CourseMatcherProvider iCourseMatcherProvider;
    private ExternalTermProvider iExternalTermProvider;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    private SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    private SolverServerService solverServerService;

    private CourseDetailsProvider getCourseDetailsProvider() {
        if (this.iCourseDetailsProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationCourseDetails.value();
                if (providerClass != null) {
                    this.iCourseDetailsProvider = (CourseDetailsProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize course detail provider: " + e.getMessage()));
                this.iCourseDetailsProvider = new DefaultCourseDetailsProvider();
            }
        }
        return this.iCourseDetailsProvider;
    }

    private CourseMatcherProvider getCourseMatcherProvider() {
        if (this.iCourseMatcherProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationCourseMatcher.value();
                if (providerClass != null) {
                    this.iCourseMatcherProvider = (CourseMatcherProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize course matcher provider: " + e.getMessage()));
            }
        }
        return this.iCourseMatcherProvider;
    }

    private ExternalTermProvider getExternalTermProvider() {
        if (this.iExternalTermProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationExternalTerm.value();
                if (providerClass != null) {
                    this.iExternalTermProvider = (ExternalTermProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize external term provider: " + e.getMessage()));
            }
        }
        return this.iExternalTermProvider;
    }

    private AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private StudentSolverProxy getStudentSolver() {
        return this.studentSectioningSolverService.getSolver();
    }

    private OnlineSectioningServer getServerInstance(Long academicSessionId, boolean canReturnDummy) {
        if (academicSessionId == null) {
            return null;
        }
        ApplicationProperties.setSessionId(academicSessionId);
        OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(academicSessionId.toString());
        if (server != null || !canReturnDummy) {
            return server;
        }
        SessionAttribute attribute = SessionAttribute.OnlineSchedulingDummyServer;
        ProxyHolder h = (ProxyHolder)this.sessionContext.getAttribute(attribute);
        if (h != null && h.isValid(academicSessionId)) {
            return (OnlineSectioningServer)h.getProxy();
        }
        org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(academicSessionId);
        if (session == null) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        server = new DatabaseServer(new AcademicSessionInfo(session), false);
        this.sessionContext.setAttribute(attribute, new ProxyHolder<Long, OnlineSectioningServer>(academicSessionId, server));
        return server;
    }

    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> listCourseOfferings(Long sessionId, String query, Integer limit) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        CourseMatcher matcher = this.getCourseMatcher(sessionId, server);
        if (server == null) {
            Session hibSession = CurriculumDAO.getInstance().getSession();
            if (query != null && !query.isEmpty() && CustomCourseLookupHolder.hasProvider()) {
                try {
                    List<CourseOffering> courses = CustomCourseLookupHolder.getProvider().getCourses(new AcademicSessionInfo((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId, hibSession)), hibSession, query, true);
                    if (courses != null && !courses.isEmpty()) {
                        ArrayList results = new ArrayList();
                        for (CourseOffering c : courses) {
                            if (!matcher.match(new XCourseId(c))) continue;
                            ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                            course.setCourseId(c.getUniqueId());
                            course.setSubject(c.getSubjectAreaAbbv());
                            course.setCourseNbr(c.getCourseNbr());
                            course.setTitle(c.getTitle());
                            course.setNote(c.getScheduleBookNote());
                            if (c.getCredit() != null) {
                                course.setCreditText(c.getCredit().creditText());
                                course.setCreditAbbv(c.getCredit().creditAbbv());
                            }
                            course.setTitle(c.getTitle());
                            course.setHasUniqueName(true);
                            course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                            boolean unlimited = false;
                            int courseLimit = 0;
                            int snapshotLimit = 0;
                            for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                                Integer snapshot;
                                if (cfg.isUnlimitedEnrollment().booleanValue()) {
                                    unlimited = true;
                                }
                                if (cfg.getLimit() != null) {
                                    courseLimit += cfg.getLimit().intValue();
                                }
                                if ((snapshot = cfg.getSnapShotLimit()) == null) continue;
                                snapshotLimit += snapshot.intValue();
                            }
                            if (c.getReservation() != null) {
                                courseLimit = c.getReservation();
                            }
                            if (courseLimit >= 9999) {
                                unlimited = true;
                            }
                            course.setLimit(unlimited ? -1 : courseLimit);
                            course.setSnapShotLimit(snapshotLimit);
                            course.setProjected(c.getProjectedDemand());
                            course.setEnrollment(c.getEnrollment());
                            course.setLastLike(c.getDemand());
                            results.add(course);
                            for (InstrOfferingConfig config : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                                if (config.getEffectiveInstructionalMethod() != null) {
                                    course.addInstructionalMethod(config.getEffectiveInstructionalMethod().getUniqueId(), config.getEffectiveInstructionalMethod().getLabel());
                                    continue;
                                }
                                course.setHasNoInstructionalMethod(true);
                            }
                        }
                        if (!results.isEmpty()) {
                            ListCourseOfferings.setSelection(results);
                            return results;
                        }
                    }
                }
                catch (Exception e) {
                    sLog.error((Object)("Failed to use the custom course lookup: " + e.getMessage()), (Throwable)e);
                }
            }
            String types = "";
            for (String ref : matcher.getAllowedCourseTypes()) {
                types = types + (types.isEmpty() ? "" : ", ") + "'" + ref + "'";
            }
            if (!matcher.isAllCourseTypes() && !matcher.isNoCourseType() && types.isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            boolean excludeNotOffered = ApplicationProperty.CourseRequestsShowNotOffered.isFalse();
            ArrayList<ClassAssignmentInterface.CourseAssignment> results = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            org.unitime.timetable.onlinesectioning.match.CourseMatcher parent = matcher.getParentCourseMatcher();
            for (CourseOffering c : hibSession.createQuery("select c from CourseOffering c where " + (excludeNotOffered ? "c.instructionalOffering.notOffered is false and " : "") + "c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and ((lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) like :q || '%') " + (query.length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + ") " + (matcher.isAllCourseTypes() ? "" : (matcher.isNoCourseType() ? (types.isEmpty() ? " and c.courseType is null " : " and (c.courseType is null or c.courseType.reference in (" + types + ")) ") : " and c.courseType.reference in (" + types + ") ")) + "order by case when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end,c.subjectArea.subjectAreaAbbreviation, c.courseNbr").setString("q", query.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(limit == null || limit <= 0 || parent != null ? Integer.MAX_VALUE : limit).list()) {
                if (parent != null && !parent.match(new XCourseId(c))) continue;
                ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                course.setCourseId(c.getUniqueId());
                course.setSubject(c.getSubjectAreaAbbv());
                course.setCourseNbr(c.getCourseNbr());
                course.setTitle(c.getTitle());
                course.setNote(c.getScheduleBookNote());
                if (c.getCredit() != null) {
                    course.setCreditText(c.getCredit().creditText());
                    course.setCreditAbbv(c.getCredit().creditAbbv());
                }
                course.setTitle(c.getTitle());
                course.setHasUniqueName(true);
                course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                boolean unlimited = false;
                int courseLimit = 0;
                for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (cfg.isUnlimitedEnrollment().booleanValue()) {
                        unlimited = true;
                    }
                    if (cfg.getLimit() == null) continue;
                    courseLimit += cfg.getLimit().intValue();
                }
                if (c.getReservation() != null) {
                    courseLimit = c.getReservation();
                }
                if (courseLimit >= 9999) {
                    unlimited = true;
                }
                course.setLimit(unlimited ? -1 : courseLimit);
                course.setProjected(c.getProjectedDemand());
                course.setEnrollment(c.getEnrollment());
                course.setLastLike(c.getDemand());
                results.add(course);
                for (InstrOfferingConfig config : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (config.getEffectiveInstructionalMethod() != null) {
                        course.addInstructionalMethod(config.getEffectiveInstructionalMethod().getUniqueId(), config.getEffectiveInstructionalMethod().getLabel());
                        continue;
                    }
                    course.setHasNoInstructionalMethod(true);
                }
                if (parent == null || limit == null || limit <= 0 || results.size() < limit) continue;
                break;
            }
            if (results.isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            return results;
        }
        Collection<ClassAssignmentInterface.CourseAssignment> results = null;
        try {
            results = server.execute(server.createAction(ListCourseOfferings.class).forQuery(query).withLimit(limit).withMatcher(matcher), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        if (results == null || results.isEmpty()) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CourseMatcher getCourseMatcher(Long sessionId, OnlineSectioningServer server) {
        CourseMatcherProvider provider;
        boolean noCourseType = true;
        boolean allCourseTypes = false;
        HashSet<String> allowedCourseTypes = new HashSet<String>();
        Long studentId = this.getStudentId(sessionId);
        Set<Object> courseIds = null;
        if (this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
            allCourseTypes = true;
        } else {
            try (Session hibSession = SessionDAO.getInstance().createNewSession();){
                StudentSectioningStatus status;
                Student student = studentId == null ? null : (Student)StudentDAO.getInstance().get(studentId, hibSession);
                StudentSectioningStatus studentSectioningStatus = status = student == null ? null : student.getEffectiveStatus();
                if (status != null) {
                    for (CourseType type : status.getTypes()) {
                        allowedCourseTypes.add(type.getReference());
                    }
                    boolean bl = noCourseType = !status.hasOption(StudentSectioningStatus.Option.notype);
                }
                if (student != null) {
                    if (server != null && !(server instanceof DatabaseServer)) {
                        courseIds = server.getRequestedCourseIds(studentId);
                    } else {
                        courseIds = new HashSet();
                        for (CourseDemand cd : student.getCourseDemands()) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                courseIds.add(cr.getCourseOffering().getUniqueId());
                            }
                        }
                    }
                }
            }
        }
        CourseMatcher matcher = new CourseMatcher(allCourseTypes, noCourseType, allowedCourseTypes, courseIds);
        if (studentId != null && (provider = this.getCourseMatcherProvider()) != null) {
            matcher.setParentCourseMatcher(provider.getCourseMatcher(this.getSessionContext(), studentId));
        }
        return matcher;
    }

    @Override
    public Collection<ClassAssignmentInterface.ClassAssignment> listClasses(boolean online, Long sessionId, String course) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (!online) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(ListClasses.class).forCourseAndStudent(course, this.getStudentId(sessionId)), this.currentUser());
        }
        this.setLastSessionId(sessionId);
        Long studentId = this.getStudentId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        HashSet<Long> allowedClasses = null;
        if (server == null) {
            org.unitime.timetable.model.Session session;
            if (!this.sessionContext.hasPermission(Right.HasRole) && (session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId)) != null && !session.canNoRoleReportClass()) {
                throw new SectioningException(MSG.exceptionClassScheduleNotAvaiable());
            }
            ArrayList<ClassAssignmentInterface.ClassAssignment> results = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            CourseOffering courseOffering = null;
            Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)").setString("course", course.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list().iterator();
            if (iterator.hasNext()) {
                CourseOffering c;
                courseOffering = c = (CourseOffering)iterator.next();
            }
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            ArrayList<Class_> classes = new ArrayList<Class_>();
            for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                for (SchedulingSubpart schedulingSubpart : config.getSchedulingSubparts()) {
                    classes.addAll(schedulingSubpart.getClasses());
                }
            }
            Collections.sort(classes, new ClassComparator(5));
            NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
            for (Class_ clazz : classes) {
                int maxLimit;
                if (!clazz.isEnabledForStudentScheduling().booleanValue()) {
                    if (studentId != null && allowedClasses == null) {
                        allowedClasses = new HashSet<Long>();
                        for (Reservation reservation : courseOffering.getInstructionalOffering().getReservations()) {
                            StudentGroupType type;
                            if (!(reservation instanceof StudentGroupReservation) || (type = ((StudentGroupReservation)reservation).getGroup().getType()) == null || type.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.WithGroupReservation) continue;
                            boolean hasStudent = false;
                            for (Student student : ((StudentGroupReservation)reservation).getGroup().getStudents()) {
                                if (!student.getUniqueId().equals(studentId)) continue;
                                hasStudent = true;
                                break;
                            }
                            if (!hasStudent) continue;
                            for (Class_ c : classes) {
                                if (c.isEnabledForStudentScheduling().booleanValue() || !reservation.isMatching(c)) continue;
                                allowedClasses.add(c.getUniqueId());
                            }
                        }
                        Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                        if (student != null) {
                            for (StudentGroup group : student.getGroups()) {
                                StudentGroupType type = group.getType();
                                if (type == null || type.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.AlwaysAllowed) continue;
                                for (Class_ c : classes) {
                                    if (c.isEnabledForStudentScheduling().booleanValue()) continue;
                                    allowedClasses.add(c.getUniqueId());
                                }
                            }
                        }
                    }
                    if (allowedClasses == null || !allowedClasses.contains(clazz.getUniqueId())) continue;
                }
                ClassAssignmentInterface.ClassAssignment classAssignment = new ClassAssignmentInterface.ClassAssignment();
                classAssignment.setClassId(clazz.getUniqueId());
                classAssignment.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                    classAssignment.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                classAssignment.setSection(clazz.getClassSuffix(courseOffering));
                if (classAssignment.getSection() == null) {
                    classAssignment.setSection(clazz.getSectionNumberString(hibSession));
                }
                classAssignment.setExternalId(clazz.getExternalId(courseOffering));
                if (classAssignment.getExternalId() == null) {
                    classAssignment.setExternalId(clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + clazz.getSectionNumberString());
                }
                classAssignment.setClassNumber(clazz.getSectionNumberString(hibSession));
                classAssignment.addNote(clazz.getSchedulePrintNote());
                Assignment assignment = clazz.getCommittedAssignment();
                Placement p = assignment == null ? null : assignment.getPlacement();
                int minLimit = clazz.getExpectedCapacity();
                int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit && p != null) {
                    int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = -1;
                }
                classAssignment.setCancelled(clazz.isCancelled());
                classAssignment.setLimit(new int[]{clazz.getEnrollment() == 0 ? -1 : clazz.getEnrollment(), limit});
                if (p != null && p.getTimeLocation() != null) {
                    for (DayCode d : DayCode.toDayCodes(p.getTimeLocation().getDayCode())) {
                        classAssignment.addDay(d.getIndex());
                    }
                    classAssignment.setStart(p.getTimeLocation().getStartSlot());
                    classAssignment.setLength(p.getTimeLocation().getLength());
                    classAssignment.setBreakTime(p.getTimeLocation().getBreakTime());
                    classAssignment.setDatePattern(p.getTimeLocation().getDatePatternName());
                }
                if (assignment != null) {
                    for (Location loc : assignment.getRooms()) {
                        classAssignment.addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                    }
                }
                if (!clazz.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instr : clazz.getClassInstructors()) {
                        classAssignment.addInstructor(nameFormat.format(instr.getInstructor()));
                        classAssignment.addInstructoEmail(instr.getInstructor().getEmail());
                    }
                }
                if (clazz.getParentClass() != null) {
                    classAssignment.setParentSection(clazz.getParentClass().getClassSuffix(courseOffering));
                }
                classAssignment.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                if (classAssignment.getParentSection() == null) {
                    classAssignment.setParentSection(courseOffering.getConsentType() == null ? null : courseOffering.getConsentType().getLabel());
                }
                results.add(classAssignment);
            }
            return results;
        }
        try {
            return server.execute(server.createAction(ListClasses.class).forCourseAndStudent(course, this.getStudentId(sessionId)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Collection<AcademicSessionProvider.AcademicSessionInfo> listAcademicSessions(boolean sectioning) throws SectioningException, PageAccessException {
        ArrayList<AcademicSessionProvider.AcademicSessionInfo> ret = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
        ExternalTermProvider extTerm = this.getExternalTermProvider();
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (sectioning) {
            for (String s : this.solverServerService.getOnlineStudentSchedulingContainer().getSolvers()) {
                StudentSectioningStatus status;
                Student student;
                Long studentId;
                OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(s);
                if (server == null || !server.isReady()) continue;
                org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(Long.valueOf(s));
                AcademicSessionInfo info = server.getAcademicSession();
                if (principal != null ? (studentId = principal.getStudentId(session.getUniqueId())) == null || (student = (Student)StudentDAO.getInstance().get(studentId)) == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enabled) && (!this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]) || !status.hasOption(StudentSectioningStatus.Option.admin)) && (!this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]) || !status.hasOption(StudentSectioningStatus.Option.advisor)) : !this.getSessionContext().hasPermissionAnySession((Object)session, Right.SchedulingAssistant, new Qualifiable[0])) continue;
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)));
            }
        } else {
            for (org.unitime.timetable.model.Session session : SessionDAO.getInstance().findAll()) {
                StudentSectioningStatus status;
                Student student;
                Long studentId;
                if (session.getStatusType().isTestSession() || !session.getStatusType().canPreRegisterStudents()) continue;
                AcademicSessionInfo info = new AcademicSessionInfo(session);
                if (principal != null ? (studentId = principal.getStudentId(session.getUniqueId())) == null || (student = (Student)StudentDAO.getInstance().get(studentId)) == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.regenabled) && (!this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]) || !status.hasOption(StudentSectioningStatus.Option.regadmin)) && (!this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]) || !status.hasOption(StudentSectioningStatus.Option.regadvisor)) : !this.getSessionContext().hasPermissionAnySession((Object)session, Right.CourseRequests, new Qualifiable[0])) continue;
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)));
            }
        }
        if (ret.isEmpty()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        Collections.sort(ret);
        if (!sectioning) {
            Collections.reverse(ret);
        }
        return ret;
    }

    @Override
    public String retrieveCourseDetails(Long sessionId, String course) throws SectioningException, PageAccessException {
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), sessionId, null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return this.getCourseDetailsProvider().getDetails(new AcademicSessionInfo(courseOffering.getSubjectArea().getSession()), courseOffering.getSubjectAreaAbbv(), courseOffering.getCourseNbr());
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return server.getCourseDetails(c.getCourseId(), this.getCourseDetailsProvider());
    }

    @Override
    public Long retrieveCourseOfferingId(Long sessionId, String course) throws SectioningException, PageAccessException {
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), sessionId, null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return courseOffering.getUniqueId();
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return c.getCourseId();
    }

    @Override
    public ClassAssignmentInterface section(boolean online, CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        try {
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
                ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser()).get(0);
                if (ret != null) {
                    ret.setCanEnroll(this.getStudentId(request.getAcademicSessionId()) != null);
                }
                return ret;
            }
            this.setLastSessionId(request.getAcademicSessionId());
            this.setLastRequest(request);
            request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser()).get(0);
            if (ret != null) {
                ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
                if (ret.isCanEnroll() && this.getStudentId(request.getAcademicSessionId()) == null) {
                    ret.setCanEnroll(false);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse checkCourses(boolean online, boolean sectioning, CourseRequestInterface request) throws SectioningException, PageAccessException {
        try {
            if (request.getAcademicSessionId() == null) {
                throw new SectioningException(MSG.exceptionNoAcademicSession());
            }
            if (request.getStudentId() == null) {
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            }
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                return server.execute(server.createAction(CheckCourses.class).forRequest(request), this.currentUser());
            }
            this.setLastSessionId(request.getAcademicSessionId());
            this.setLastRequest(request);
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
            if (server == null) {
                if (!sectioning && CustomCourseRequestsValidationHolder.hasProvider()) {
                    OnlineSectioningServer dummy = this.getServerInstance(request.getAcademicSessionId(), true);
                    return dummy.execute(dummy.createAction(CheckCourses.class).forRequest(request).withMatcher(this.getCourseMatcher(request.getAcademicSessionId(), server)).withCustomValidation(true), this.currentUser());
                }
                Session hibSession = CurriculumDAO.getInstance().getSession();
                CourseRequestInterface.CheckCoursesResponse response = new CourseRequestInterface.CheckCoursesResponse();
                CourseMatcher matcher = this.getCourseMatcher(request.getAcademicSessionId(), server);
                Long studentId = this.getStudentId(request.getAcademicSessionId());
                for (CourseRequestInterface.Request cr : request.getCourses()) {
                    if (!cr.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                        if (!rc.isCourse() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, rc, matcher) != null) continue;
                        response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MSG.validationCourseNotExists(rc.getCourseName()));
                        response.setErrorMessage(MSG.validationCourseNotExists(rc.getCourseName()));
                    }
                }
                for (CourseRequestInterface.Request cr : request.getAlternatives()) {
                    if (!cr.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                        if (!rc.isCourse() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, rc, matcher) != null) continue;
                        response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MSG.validationCourseNotExists(rc.getCourseName()));
                        response.setErrorMessage(MSG.validationCourseNotExists(rc.getCourseName()));
                    }
                }
                return response;
            }
            return server.execute(server.createAction(CheckCourses.class).forRequest(request).withMatcher(this.getCourseMatcher(request.getAcademicSessionId(), server)).withCustomValidation(!sectioning), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    public static CourseOffering lookupCourse(Session hibSession, Long sessionId, Long studentId, String courseName, CourseMatcher courseMatcher) {
        Iterator iterator;
        if (studentId != null && (iterator = hibSession.createQuery("select cr.courseOffering from CourseRequest cr where cr.courseDemand.student.uniqueId = :studentId and (lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr) = :course or lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr || ' - ' || cr.courseOffering.title) = :course)").setString("course", courseName.toLowerCase()).setLong("studentId", studentId.longValue()).setCacheable(true).setMaxResults(1).list().iterator()).hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        for (CourseOffering co : hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)").setString("course", courseName.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list()) {
            if (courseMatcher != null && !courseMatcher.match(new XCourse(co))) continue;
            return co;
        }
        return null;
    }

    public static CourseOffering lookupCourse(Session hibSession, Long sessionId, Long studentId, CourseRequestInterface.RequestedCourse rc, CourseMatcher courseMatcher) {
        if (rc.hasCourseId()) {
            CourseOffering co = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), hibSession);
            if (courseMatcher != null && !courseMatcher.match(new XCourse(co))) {
                return null;
            }
            return co;
        }
        if (rc.hasCourseName()) {
            return SectioningServlet.lookupCourse(hibSession, sessionId, studentId, rc.getCourseName(), courseMatcher);
        }
        return null;
    }

    @Override
    public Collection<ClassAssignmentInterface> computeSuggestions(boolean online, CourseRequestInterface request, Collection<ClassAssignmentInterface.ClassAssignment> currentAssignment, int selectedAssignmentIndex, String filter) throws SectioningException, PageAccessException {
        try {
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
                ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
                if (selectedAssignmentIndex >= 0) {
                    selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
                } else if (request.getLastCourse() != null) {
                    XCourseId course = server.getCourse(request.getLastCourse().getCourseId(), request.getLastCourse().getCourseName());
                    if (course == null) {
                        throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse().getCourseName()));
                    }
                    selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                    selectedAssignment.setCourseId(course.getCourseId());
                }
                Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter), this.currentUser());
                if (ret != null) {
                    boolean canEnroll = this.getStudentId(request.getAcademicSessionId()) != null;
                    for (ClassAssignmentInterface ca : ret) {
                        ca.setCanEnroll(canEnroll);
                    }
                }
                return ret;
            }
            this.setLastSessionId(request.getAcademicSessionId());
            if (selectedAssignmentIndex >= 0) {
                this.setLastRequest(request);
            }
            request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
            if (selectedAssignmentIndex >= 0) {
                selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
            } else if (request.getLastCourse() != null) {
                XCourseId course = server.getCourse(request.getLastCourse().getCourseId(), request.getLastCourse().getCourseName());
                if (course == null) {
                    throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse().getCourseName()));
                }
                selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                selectedAssignment.setCourseId(course.getCourseId());
            }
            Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter), this.currentUser());
            if (ret != null) {
                boolean canEnroll = server.getAcademicSession().isSectioningEnabled();
                if (canEnroll && this.getStudentId(request.getAcademicSessionId()) == null) {
                    canEnroll = false;
                }
                for (ClassAssignmentInterface ca : ret) {
                    ca.setCanEnroll(canEnroll);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String logIn(String userName, String password, String pin) throws SectioningException, PageAccessException {
        if (pin != null && !pin.isEmpty()) {
            this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingPIN, (Object)pin);
        } else {
            this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingPIN);
        }
        if ("LOOKUP".equals(userName)) {
            this.getSessionContext().checkPermissionAnySession(Right.StudentSchedulingAdvisor, new Qualifiable[0]);
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                List student = hibSession.createQuery("select m from Student m where m.externalUniqueId = :uid").setString("uid", password).list();
                if (!student.isEmpty()) {
                    UserContext user = this.getSessionContext().getUser();
                    UniTimePrincipal principal = new UniTimePrincipal(user.getTrueExternalUserId(), password, user.getTrueName());
                    for (Student s : student) {
                        if (!this.getSessionContext().hasPermissionAnySession((Object)s.getSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) continue;
                        principal.addStudentId(s.getSession().getUniqueId(), s.getUniqueId());
                        principal.setName(NameFormat.defaultFormat().format(s));
                    }
                    this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)principal);
                    this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastRequest);
                    String string = principal.getName();
                    return string;
                }
            }
        }
        if ("BATCH".equals(userName)) {
            this.getSessionContext().checkPermission(Right.StudentSectioningSolverDashboard);
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                XStudent student = server.getStudent(Long.valueOf(password));
                if (student == null) {
                    throw new SectioningException(MSG.exceptionLoginFailed());
                }
                UserContext user = this.getSessionContext().getUser();
                UniTimePrincipal uniTimePrincipal = new UniTimePrincipal(user.getTrueExternalUserId(), student.getExternalId(), user.getTrueName());
                uniTimePrincipal.addStudentId(server.getAcademicSession().getUniqueId(), student.getStudentId());
                uniTimePrincipal.setName(student.getName());
                this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)uniTimePrincipal);
                this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastRequest);
                String string = uniTimePrincipal.getName();
                return string;
            }
        }
        try {
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)userName, (Object)password);
            Authentication authResult = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            SecurityContextHolder.getContext().setAuthentication(authResult);
            UserContext user = (UserContext)authResult.getPrincipal();
            if (user.getCurrentAuthority() == null) {
                for (UserAuthority userAuthority : user.getAuthorities("Student", new Qualifiable[0])) {
                    if (this.getLastSessionId() != null && !userAuthority.getAcademicSession().getQualifierId().equals(this.getLastSessionId())) continue;
                    user.setCurrentAuthority(userAuthority);
                    break;
                }
            }
            LoginManager.loginSuceeded(authResult.getName());
            return user.getName() == null ? user.getUsername() : user.getName();
        }
        catch (Exception e) {
            LoginManager.addFailedLoginAttempt(userName, new Date());
            throw new PageAccessException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean logOut() throws SectioningException, PageAccessException {
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingUser);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingPIN);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastSession);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastRequest);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingEligibility);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastSpecialRequest);
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            return false;
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        return true;
    }

    @Override
    public String whoAmI() throws SectioningException, PageAccessException {
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (principal != null) {
            return principal.getName();
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null || user instanceof AnonymousUserContext) {
            return null;
        }
        return user.getName() == null ? user.getUsername() : user.getName();
    }

    public Long getStudentId(Long sessionId) {
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (principal != null) {
            return principal.getStudentId(sessionId);
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            return null;
        }
        Iterator<? extends UserAuthority> iterator = user.getAuthorities("Student", new SimpleQualifier("Session", sessionId)).iterator();
        if (iterator.hasNext()) {
            UserAuthority a = iterator.next();
            return a.getUniqueId();
        }
        return null;
    }

    public Long getLastSessionId() {
        Long sessionId;
        UserContext user;
        Long lastSessionId = (Long)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastSession);
        if (lastSessionId == null && (user = this.getSessionContext().getUser()) != null && (sessionId = user.getCurrentAcademicSessionId()) != null) {
            lastSessionId = sessionId;
        }
        return lastSessionId;
    }

    public void setLastSessionId(Long sessionId) {
        this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastSession, (Object)sessionId);
    }

    public CourseRequestInterface getLastRequest() {
        return (CourseRequestInterface)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastRequest);
    }

    public void setLastRequest(CourseRequestInterface request) {
        if (request == null || request.getAcademicSessionId() == null) {
            this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingLastRequest);
        } else if (request.isUpdateLastRequest()) {
            this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastRequest, (Object)request);
        }
    }

    @Override
    public AcademicSessionProvider.AcademicSessionInfo lastAcademicSession(boolean sectioning) throws SectioningException, PageAccessException {
        if (this.getSessionContext().isHttpSessionNew()) {
            throw new PageAccessException(MSG.exceptionUserNotLoggedIn());
        }
        Long sessionId = (Long)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastSession);
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        ExternalTermProvider extTerm = this.getExternalTermProvider();
        if (sectioning) {
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            AcademicSessionInfo s = server.getAcademicSession();
            if (s == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            return new AcademicSessionProvider.AcademicSessionInfo(s.getUniqueId(), s.getYear(), s.getTerm(), s.getCampus(), MSG.sessionName(s.getYear(), s.getTerm(), s.getCampus()), s.getSessionBeginDate()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(s)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(s));
        }
        org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId);
        if (session == null || session.getStatusType().isTestSession()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        if (!session.getStatusType().canPreRegisterStudents() || session.getStatusType().canSectionAssistStudents() || session.getStatusType().canOnlineSectionStudents()) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        AcademicSessionInfo info = new AcademicSessionInfo(session);
        return new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info));
    }

    @Override
    public CourseRequestInterface lastRequest(boolean online, boolean sectioning, Long sessionId) throws SectioningException, PageAccessException {
        Long studentId;
        CourseRequestInterface request = this.getLastRequest();
        if (request != null && !request.getAcademicSessionId().equals(sessionId)) {
            request = null;
        }
        if (request != null && request.getCourses().isEmpty() && request.getAlternatives().isEmpty()) {
            request = null;
        }
        if (request != null && request.getStudentId() != null && !request.getStudentId().equals(this.getStudentId(sessionId))) {
            request = null;
        }
        if (request == null && (request = this.savedRequest(online, sectioning, sessionId, studentId = this.getStudentId(sessionId))) == null && studentId == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        if (request == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        if (!request.getAcademicSessionId().equals(sessionId)) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        if (request.getCourses().isEmpty() && request.getAlternatives().isEmpty()) {
            throw new SectioningException(MSG.exceptionNoRequests());
        }
        return request;
    }

    @Override
    public ClassAssignmentInterface lastResult(boolean online, Long sessionId) throws SectioningException, PageAccessException {
        Long studentId = this.getStudentId(sessionId);
        if (studentId == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        if (!online) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
            if (ret != null) {
                ret.setCanEnroll(this.getStudentId(sessionId) != null);
            }
            return ret;
        }
        try {
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionBadSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
            if (ret == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
            if (ret.isCanEnroll() && this.getStudentId(sessionId) == null) {
                ret.setCanEnroll(false);
            }
            OnlineSectioningInterface.EligibilityCheck last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility);
            if (ret != null && last != null && last.hasGradeModes()) {
                for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                        OnlineSectioningInterface.GradeMode m = last.getGradeMode(a);
                        if (m == null) continue;
                        a.setGradeMode(m);
                    }
                }
            }
            if (!ret.getCourseAssignments().isEmpty()) {
                return ret;
            }
            throw new SectioningException(MSG.exceptionNoSchedule());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public CourseRequestInterface saveRequest(CourseRequestInterface request) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
        Long studentId = this.getStudentId(request.getAcademicSessionId());
        if (studentId == null && this.getSessionContext().hasPermissionAnySession((Object)request.getAcademicSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
            studentId = request.getStudentId();
        }
        if (server != null) {
            if (studentId == null) {
                throw new SectioningException(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            return server.execute(server.createAction(SaveStudentRequests.class).forStudent(studentId).withRequest(request).withCustomValidation(true), this.currentUser());
        }
        if (studentId == null) {
            throw new SectioningException(MSG.exceptionEnrollNotStudent(((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(request.getAcademicSessionId())).getLabel()));
        }
        try (Session hibSession = StudentDAO.getInstance().getSession();){
            Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser());
            CriticalCoursesProvider.CriticalCourses critical = null;
            try {
                if (CustomCriticalCoursesHolder.hasProvider()) {
                    critical = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(this.getServerInstance(request.getAcademicSessionId(), true), helper, new XStudentId(student, helper));
                }
            }
            catch (Exception e) {
                helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
            }
            SaveStudentRequests.saveRequest(null, helper, student, request, true, critical);
            hibSession.save((Object)student);
            hibSession.flush();
            CourseRequestInterface courseRequestInterface = request;
            return courseRequestInterface;
        }
    }

    @Override
    public ClassAssignmentInterface enroll(boolean online, CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        Long sessionId;
        if (request.getStudentId() == null) {
            sessionId = request.getAcademicSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        sessionId = this.canEnroll(online, request.getAcademicSessionId(), request.getStudentId());
        if (!request.getAcademicSessionId().equals(sessionId)) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        if (!online) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(BatchEnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment), this.currentUser());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getAcademicSessionId());
        this.setLastRequest(request);
        ClassAssignmentInterface ret = server.execute(server.createAction(EnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment), this.currentUser());
        OnlineSectioningInterface.EligibilityCheck last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility);
        if (ret != null && last != null) {
            for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                    if (a.getGradeMode() == null) continue;
                    last.addGradeMode(a.getExternalId(), a.getGradeMode().getCode(), a.getGradeMode().getLabel(), a.getGradeMode().isHonor());
                }
            }
        }
        return ret;
    }

    @Override
    public List<Long> canApprove(Long classOrOfferingId) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server;
            InstructionalOffering offering;
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
            }
            Session hibSession = SessionDAO.getInstance().getSession();
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            if ((server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false)) == null) {
                return null;
            }
            ArrayList<Long> coursesToApprove = new ArrayList<Long>();
            for (CourseOffering course : offering.getCourseOfferings()) {
                if (!this.getSessionContext().hasPermissionAnyAuthority((Object)course, Right.ConsentApproval, new Qualifiable[0])) continue;
                coursesToApprove.add(course.getUniqueId());
            }
            return coursesToApprove;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ClassAssignmentInterface.Enrollment> listEnrollments(Long classOrOfferingId) throws SectioningException, PageAccessException {
        try {
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
            }
            try (Session hibSession = SessionDAO.getInstance().getSession();){
                Class_ clazz;
                InstructionalOffering offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
                Class_ class_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (offering == null && clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                if (offering == null) {
                    offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
                }
                Long offeringId = offering.getUniqueId();
                this.getSessionContext().checkPermission(offering, Right.OfferingEnrollments);
                OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
                if (server == null || !offering.isAllowStudentScheduling() || offering.isNotOffered().booleanValue() || offering.getInstrOfferingConfigs().isEmpty()) {
                    BaseCourseRequest alt;
                    Object c;
                    ClassAssignmentInterface.Student st;
                    ClassAssignmentInterface.Enrollment e;
                    NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
                    NameFormat instructorNameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
                    Hashtable<String, void> approvedBy2name = new Hashtable<String, void>();
                    Hashtable<Long, ClassAssignmentInterface.Enrollment> student2enrollment = new Hashtable<Long, ClassAssignmentInterface.Enrollment>();
                    boolean canShowExtIds = this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId);
                    boolean canRegister = this.sessionContext.hasPermission(Right.CourseRequests);
                    boolean canUseAssistant = this.sessionContext.hasPermission(Right.SchedulingAssistant);
                    for (StudentClassEnrollment enrollment : hibSession.createQuery(clazz == null ? "from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId" : "select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.student.uniqueId in (select f.student.uniqueId from StudentClassEnrollment f where f.clazz.uniqueId = " + clazz.getUniqueId() + ")").setLong("offeringId", offeringId.longValue()).list()) {
                        e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(enrollment.getStudent().getUniqueId());
                        if (e == null) {
                            st = new ClassAssignmentInterface.Student();
                            st.setId(enrollment.getStudent().getUniqueId());
                            st.setSessionId(enrollment.getStudent().getSession().getUniqueId());
                            st.setExternalId(enrollment.getStudent().getExternalUniqueId());
                            st.setCanShowExternalId(canShowExtIds);
                            st.setCanRegister(canRegister);
                            st.setCanUseAssistant(canUseAssistant);
                            st.setName(nameFormat.format(enrollment.getStudent()));
                            for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(enrollment.getStudent().getAreaClasfMajors())) {
                                st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation());
                                st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode());
                                st.addMajor(studentAreaClassificationMajor.getMajor().getCode());
                            }
                            for (StudentGroup studentGroup : enrollment.getStudent().getGroups()) {
                                if (studentGroup.getType() == null) {
                                    st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                                    continue;
                                }
                                st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                            }
                            for (StudentAccomodation studentAccomodation : enrollment.getStudent().getAccomodations()) {
                                st.addAccommodation(studentAccomodation.getAbbreviation());
                            }
                            for (Advisor advisor : enrollment.getStudent().getAdvisors()) {
                                if (advisor.getLastName() == null) continue;
                                st.addAdvisor(instructorNameFormat.format(advisor));
                            }
                            e = new ClassAssignmentInterface.Enrollment();
                            e.setStudent(st);
                            e.setEnrolledDate(enrollment.getTimestamp());
                            c = new ClassAssignmentInterface.CourseAssignment();
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(enrollment.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.CourseAssignment)c).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.CourseAssignment)c).setTitle(enrollment.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.CourseAssignment)c).setHasCrossList(enrollment.getCourseOffering().getInstructionalOffering().hasCrossList());
                            e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                            student2enrollment.put(enrollment.getStudent().getUniqueId(), e);
                            if (enrollment.getCourseRequest() != null) {
                                e.setPriority(1 + enrollment.getCourseRequest().getCourseDemand().getPriority());
                                if (enrollment.getCourseRequest().getCourseDemand().getCourseRequests().size() > 1) {
                                    void var20_30;
                                    Object var20_29 = null;
                                    for (CourseRequest courseRequest : enrollment.getCourseRequest().getCourseDemand().getCourseRequests()) {
                                        if (var20_30 != null && courseRequest.getOrder().compareTo(var20_30.getOrder()) >= 0) continue;
                                        CourseRequest courseRequest2 = courseRequest;
                                    }
                                    if (!var20_30.equals(enrollment.getCourseRequest())) {
                                        e.setAlternative(var20_30.getCourseOffering().getCourseName());
                                    }
                                }
                                if (enrollment.getCourseRequest().getCourseDemand().isAlternative().booleanValue()) {
                                    void var20_33;
                                    CourseDemand courseDemand = enrollment.getCourseRequest().getCourseDemand();
                                    block14: for (CourseDemand courseDemand2 : enrollment.getStudent().getCourseDemands()) {
                                        if (courseDemand2.isAlternative().booleanValue() || courseDemand2.getPriority().compareTo(var20_33.getPriority()) >= 0 || courseDemand2.getCourseRequests().isEmpty()) continue;
                                        for (CourseRequest cr : courseDemand2.getCourseRequests()) {
                                            if (!cr.getClassEnrollments().isEmpty()) continue;
                                            continue block14;
                                        }
                                        CourseDemand courseDemand3 = courseDemand2;
                                    }
                                    alt = null;
                                    for (CourseRequest courseRequest : var20_33.getCourseRequests()) {
                                        if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                                        alt = courseRequest;
                                    }
                                    e.setAlternative(alt.getCourseOffering().getCourseName());
                                }
                                e.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                                e.setApprovedDate(enrollment.getApprovedDate());
                                if (enrollment.getApprovedBy() != null) {
                                    void var20_38;
                                    String string = (String)approvedBy2name.get(enrollment.getApprovedBy());
                                    if (string == null) {
                                        TimetableManager mgr = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :externalId").setString("externalId", enrollment.getApprovedBy()).setMaxResults(1).uniqueResult();
                                        if (mgr != null) {
                                            String string2 = mgr.getName();
                                        } else {
                                            DepartmentalInstructor departmentalInstructor = (DepartmentalInstructor)hibSession.createQuery("from DepartmentalInstructor where externalUniqueId = :externalId and department.session.uniqueId = :sessionId").setString("externalId", enrollment.getApprovedBy()).setLong("sessionId", enrollment.getStudent().getSession().getUniqueId().longValue()).setMaxResults(1).uniqueResult();
                                            if (departmentalInstructor != null) {
                                                String string3 = departmentalInstructor.nameLastNameFirst();
                                            }
                                        }
                                        if (var20_38 != null) {
                                            approvedBy2name.put(enrollment.getApprovedBy(), var20_38);
                                        }
                                    }
                                    e.setApprovedBy((String)(var20_38 == null ? enrollment.getApprovedBy() : var20_38));
                                }
                                e.setWaitList(enrollment.getCourseRequest().getCourseDemand().isWaitlist());
                            } else {
                                e.setPriority(-1);
                            }
                        }
                        ClassAssignmentInterface.ClassAssignment c2 = e.getCourse().addClassAssignment();
                        c2.setClassId(enrollment.getClazz().getUniqueId());
                        c2.setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                        if (c2.getSection() == null) {
                            c2.setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                        }
                        c2.setExternalId(enrollment.getClazz().getExternalId(enrollment.getCourseOffering()));
                        c2.setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                        c2.setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                    }
                    if (classOrOfferingId >= 0L) {
                        for (CourseRequest request : hibSession.createQuery("from CourseRequest r where r.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", classOrOfferingId.longValue()).list()) {
                            e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(request.getCourseDemand().getStudent().getUniqueId());
                            if (e != null) continue;
                            st = new ClassAssignmentInterface.Student();
                            st.setId(request.getCourseDemand().getStudent().getUniqueId());
                            st.setSessionId(request.getCourseDemand().getStudent().getSession().getUniqueId());
                            st.setExternalId(request.getCourseDemand().getStudent().getExternalUniqueId());
                            st.setCanShowExternalId(canShowExtIds);
                            st.setCanRegister(canRegister);
                            st.setCanUseAssistant(canUseAssistant);
                            st.setName(nameFormat.format(request.getCourseDemand().getStudent()));
                            for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(request.getCourseDemand().getStudent().getAreaClasfMajors())) {
                                st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation());
                                st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode());
                                st.addMajor(studentAreaClassificationMajor.getMajor().getCode());
                            }
                            for (StudentGroup studentGroup : request.getCourseDemand().getStudent().getGroups()) {
                                if (studentGroup.getType() == null) {
                                    st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                                    continue;
                                }
                                st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                            }
                            for (StudentAccomodation studentAccomodation : request.getCourseDemand().getStudent().getAccomodations()) {
                                st.addAccommodation(studentAccomodation.getAbbreviation());
                            }
                            for (Advisor advisor : request.getCourseDemand().getStudent().getAdvisors()) {
                                if (advisor.getLastName() == null) continue;
                                st.addAdvisor(instructorNameFormat.format(advisor));
                            }
                            e = new ClassAssignmentInterface.Enrollment();
                            e.setStudent(st);
                            c = new ClassAssignmentInterface.CourseAssignment();
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(request.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.CourseAssignment)c).setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(request.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.CourseAssignment)c).setTitle(request.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.CourseAssignment)c).setHasCrossList(request.getCourseOffering().getInstructionalOffering().hasCrossList());
                            e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                            e.setWaitList(request.getCourseDemand().isWaitlist());
                            student2enrollment.put(request.getCourseDemand().getStudent().getUniqueId(), e);
                            e.setPriority(1 + request.getCourseDemand().getPriority());
                            if (request.getCourseDemand().getCourseRequests().size() > 1) {
                                void var20_45;
                                Object var20_44 = null;
                                for (CourseRequest courseRequest : request.getCourseDemand().getCourseRequests()) {
                                    if (var20_45 != null && courseRequest.getOrder().compareTo(var20_45.getOrder()) >= 0) continue;
                                    CourseRequest courseRequest3 = courseRequest;
                                }
                                if (!var20_45.equals(request)) {
                                    e.setAlternative(var20_45.getCourseOffering().getCourseName());
                                }
                            }
                            if (request.getCourseDemand().isAlternative().booleanValue()) {
                                void var20_48;
                                CourseDemand courseDemand = request.getCourseDemand();
                                block23: for (CourseDemand courseDemand4 : request.getCourseDemand().getStudent().getCourseDemands()) {
                                    if (courseDemand4.isAlternative().booleanValue() || courseDemand4.getPriority().compareTo(var20_48.getPriority()) >= 0 || courseDemand4.getCourseRequests().isEmpty()) continue;
                                    for (CourseRequest cr : courseDemand4.getCourseRequests()) {
                                        if (!cr.getClassEnrollments().isEmpty()) continue;
                                        continue block23;
                                    }
                                    CourseDemand courseDemand5 = courseDemand4;
                                }
                                alt = null;
                                for (CourseRequest courseRequest : var20_48.getCourseRequests()) {
                                    if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                                    alt = courseRequest;
                                }
                                e.setAlternative(alt.getCourseOffering().getCourseName());
                            }
                            e.setRequestedDate(request.getCourseDemand().getTimestamp());
                        }
                    }
                    Iterator iterator = new ArrayList(student2enrollment.values());
                    return iterator;
                }
                List<ClassAssignmentInterface.Enrollment> list = server.execute(server.createAction(ListEnrollments.class).forOffering(offeringId).withSection(clazz == null ? null : clazz.getUniqueId()).canShowExternalIds(this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)).canRegister(this.sessionContext.hasPermission(Right.CourseRequests)).canUseAssistant(this.sessionContext.hasPermission(Right.SchedulingAssistant)).withPermissions(this.getSessionContext().hasPermissionAnySession(Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession(Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
                return list;
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassAssignmentInterface getEnrollment(boolean online, Long studentId) throws SectioningException, PageAccessException {
        try {
            Object clazz;
            ClassAssignmentInterface.CourseAssignment course;
            Student student;
            Session hibSession;
            block40: {
                if (!online) {
                    StudentSolverProxy server = this.getStudentSolver();
                    if (server != null) return server.execute(server.createAction(GetAssignment.class).forStudent(studentId).withRequest(true), this.currentUser());
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                this.getSessionContext().checkPermission(studentId, "Student", Right.StudentEnrollments);
                hibSession = SessionDAO.getInstance().getSession();
                student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                OnlineSectioningServer server = this.getServerInstance(student.getSession().getUniqueId(), false);
                if (server != null) {
                    ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId).withRequest(true).withCustomCheck(true), this.currentUser());
                    ret.setCanSetCriticalOverrides(this.getSessionContext().hasPermission(student, Right.StudentSchedulingChangeCriticalOverride));
                    ClassAssignmentInterface classAssignmentInterface = ret;
                    return classAssignmentInterface;
                }
                break block40;
                finally {
                    hibSession.close();
                }
            }
            Comparator<StudentClassEnrollment> cmp = new Comparator<StudentClassEnrollment>(){

                public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                    SchedulingSubpart p1 = s1.getParentSubpart();
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(StudentClassEnrollment a, StudentClassEnrollment b) {
                    SchedulingSubpart s2;
                    SchedulingSubpart s1 = a.getClazz().getSchedulingSubpart();
                    if (this.isParent(s1, s2 = b.getClazz().getSchedulingSubpart())) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    int cmp = s1.getItype().compareTo(s2.getItype());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Double.compare(s1.getUniqueId().longValue(), s2.getUniqueId().longValue());
                }
            };
            NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
            ClassAssignmentInterface ret = new ClassAssignmentInterface();
            Hashtable<Long, ClassAssignmentInterface.CourseAssignment> courses = new Hashtable<Long, ClassAssignmentInterface.CourseAssignment>();
            CourseCreditUnitConfig credit = null;
            TreeSet<StudentClassEnrollment> enrollments = new TreeSet<StudentClassEnrollment>(cmp);
            enrollments.addAll(hibSession.createQuery("from StudentClassEnrollment e where e.student.uniqueId = :studentId order by e.courseOffering.subjectAreaAbbv, e.courseOffering.courseNbr").setLong("studentId", studentId.longValue()).list());
            Object object = enrollments.iterator();
            while (true) {
                StudentClassEnrollment enrollment;
                block41: {
                    int maxLimit;
                    if (!object.hasNext()) break;
                    enrollment = (StudentClassEnrollment)object.next();
                    course = (ClassAssignmentInterface.CourseAssignment)courses.get(enrollment.getCourseOffering().getUniqueId());
                    if (course == null) {
                        course = new ClassAssignmentInterface.CourseAssignment();
                        courses.put(enrollment.getCourseOffering().getUniqueId(), course);
                        ret.add(course);
                        course.setAssigned(true);
                        course.setCourseId(enrollment.getCourseOffering().getUniqueId());
                        course.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                        course.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                        course.setTitle(enrollment.getCourseOffering().getTitle());
                        course.setWaitListed(enrollment.getCourseRequest() != null && enrollment.getCourseRequest().getCourseDemand().getWaitlist() != null && enrollment.getCourseRequest().getCourseDemand().getWaitlist() != false);
                        course.setHasCrossList(enrollment.getCourseOffering().getInstructionalOffering().hasCrossList());
                        credit = enrollment.getCourseOffering().getCredit();
                        if (enrollment.getCourseRequest() != null) {
                            course.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                        }
                    }
                    clazz = course.addClassAssignment();
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setClassId(enrollment.getClazz().getUniqueId());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseId(enrollment.getCourseOffering().getUniqueId());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseAssigned(true);
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setTitle(enrollment.getCourseOffering().getTitle());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                    if (((ClassAssignmentInterface.ClassAssignment)clazz).getSection() == null) {
                        ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                    }
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setExternalId(enrollment.getClazz().getExternalId(enrollment.getCourseOffering()));
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                    if (enrollment.getClazz().getParentClass() != null) {
                        ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getClassSuffix(enrollment.getCourseOffering()));
                        if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() == null) {
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getSectionNumberString(hibSession));
                        }
                    }
                    if (enrollment.getClazz().getSchedulePrintNote() != null) {
                        ((ClassAssignmentInterface.ClassAssignment)clazz).addNote(enrollment.getClazz().getSchedulePrintNote());
                    }
                    Iterator<Object> placement = enrollment.getClazz().getCommittedAssignment() == null ? null : enrollment.getClazz().getCommittedAssignment().getPlacement();
                    int minLimit = enrollment.getClazz().getExpectedCapacity();
                    int limit = maxLimit = enrollment.getClazz().getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && placement != null) {
                        int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (enrollment.getClazz().getRoomRatio() == null ? 1.0f : enrollment.getClazz().getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (enrollment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCancelled(enrollment.getClazz().isCancelled());
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setLimit(new int[]{enrollment.getClazz().getEnrollment(), limit});
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setEnrolledDate(enrollment.getTimestamp());
                    if (placement != null) {
                        if (placement.getTimeLocation() != null) {
                            for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                            }
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(placement.getTimeLocation().getStartSlot());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(placement.getTimeLocation().getLength());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setBreakTime(placement.getTimeLocation().getBreakTime());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setDatePattern(placement.getTimeLocation().getDatePatternName());
                        }
                        if (enrollment.getClazz().getCommittedAssignment() != null) {
                            for (Location loc : enrollment.getClazz().getCommittedAssignment().getRooms()) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                            }
                        }
                    }
                    if (!enrollment.getClazz().getDisplayInstructor().booleanValue()) break block41;
                    Iterator<ClassInstructor> roomLimit = enrollment.getClazz().getClassInstructors().iterator();
                    while (roomLimit.hasNext()) {
                        ClassInstructor ci = roomLimit.next();
                        if (!ci.isLead().booleanValue()) continue;
                        ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructor(nameFormat.format(ci.getInstructor()));
                        ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructoEmail(ci.getInstructor().getEmail() == null ? "" : ci.getInstructor().getEmail());
                    }
                }
                if (enrollment.getClazz().getSchedulingSubpart().getCredit() != null) {
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(enrollment.getClazz().getSchedulingSubpart().getCredit().creditAbbv() + "|" + enrollment.getClazz().getSchedulingSubpart().getCredit().creditText());
                } else if (credit != null) {
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(credit.creditAbbv() + "|" + credit.creditText());
                }
                Float creditOverride = enrollment.getClazz().getCredit(enrollment.getCourseOffering());
                if (creditOverride != null) {
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                credit = null;
                if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() != null) continue;
                ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getCourseOffering().getConsentType() == null ? null : enrollment.getCourseOffering().getConsentType().getLabel());
            }
            object = hibSession.createQuery("from CourseDemand d where d.student.uniqueId = :studentId order by d.priority").setLong("studentId", studentId.longValue()).list().iterator();
            block13: while (true) {
                BaseCourseRequest request;
                if (!object.hasNext()) {
                    ret.setRequest(this.getRequest(student));
                    ret.setCanSetCriticalOverrides(this.getSessionContext().hasPermission(student, Right.StudentSchedulingChangeCriticalOverride));
                    object = ret;
                    return object;
                }
                CourseDemand demand = (CourseDemand)object.next();
                if (demand.getFreeTime() == null) {
                    request = null;
                    clazz = demand.getCourseRequests().iterator();
                } else {
                    course = new ClassAssignmentInterface.CourseAssignment();
                    course.setAssigned(true);
                    clazz = course.addClassAssignment();
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(demand.getFreeTime().getLength());
                    for (DayCode d : DayCode.toDayCodes(demand.getFreeTime().getDayCode())) {
                        ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                    }
                    ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(demand.getFreeTime().getStartSlot());
                    block15: for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                        for (ClassAssignmentInterface.ClassAssignment c : ca.getClassAssignments()) {
                            if (!c.isAssigned()) continue;
                            for (int d : c.getDays()) {
                                if (!((ClassAssignmentInterface.ClassAssignment)clazz).getDays().contains(d) || c.getStart() + c.getLength() <= ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() || ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() + ((ClassAssignmentInterface.ClassAssignment)clazz).getLength() <= c.getStart()) continue;
                                course.setAssigned(false);
                                break block15;
                            }
                        }
                    }
                    course.setRequestedDate(demand.getTimestamp());
                    ret.add(course);
                    continue;
                }
                while (clazz.hasNext()) {
                    CourseRequest r = (CourseRequest)clazz.next();
                    if (courses.containsKey(r.getCourseOffering().getUniqueId())) continue block13;
                    if (request != null && r.getOrder().compareTo(request.getOrder()) >= 0) continue;
                    request = r;
                }
                if (request == null) continue;
                ClassAssignmentInterface.CourseAssignment course2 = new ClassAssignmentInterface.CourseAssignment();
                courses.put(request.getCourseOffering().getUniqueId(), course2);
                course2.setRequestedDate(demand.getTimestamp());
                ret.add(course2);
                course2.setAssigned(false);
                course2.setWaitListed(demand.getWaitlist() != null && demand.getWaitlist() != false);
                course2.setCourseId(request.getCourseOffering().getUniqueId());
                course2.setCourseNbr(request.getCourseOffering().getCourseNbr());
                course2.setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                course2.setTitle(request.getCourseOffering().getTitle());
                course2.setHasCrossList(request.getCourseOffering().getInstructionalOffering().hasCrossList());
                ClassAssignmentInterface.ClassAssignment clazz2 = course2.addClassAssignment();
                clazz2.setCourseId(request.getCourseOffering().getUniqueId());
                clazz2.setCourseAssigned(false);
                clazz2.setCourseNbr(request.getCourseOffering().getCourseNbr());
                clazz2.setTitle(request.getCourseOffering().getTitle());
                clazz2.setSubject(request.getCourseOffering().getSubjectAreaAbbv());
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            throw new PageAccessException(e.getMessage());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public String approveEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            server.execute(server.createAction(ApproveEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
            return approval;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean rejectEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            return server.execute(server.createAction(RejectEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private Long getStatusPageSessionId() throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (user.getCurrentAcademicSessionId() == null) {
            Long sessionId = this.getLastSessionId();
            if (sessionId != null) {
                return sessionId;
            }
        } else {
            return user.getCurrentAcademicSessionId();
        }
        throw new SectioningException(MSG.exceptionNoAcademicSession());
    }

    private HashSet<Long> getCoordinatingCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (this.getSessionContext().hasPermission(Right.HasRole)) {
            return null;
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.offeringCoordinators oc where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and oc.instructor.externalUniqueId = :extId").setLong("sessionId", sessionId.longValue()).setString("extId", user.getExternalUserId()).setCacheable(true).list());
        return courseIds;
    }

    private Set<String> getSubjectAreas() throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (!this.getSessionContext().hasPermission(Right.HasRole) || this.getSessionContext().hasPermission(Right.DepartmentIndependent)) {
            return null;
        }
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin) || this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            return null;
        }
        HashSet<String> subjects = new HashSet<String>();
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(user)) {
            subjects.add(subject.getSubjectAreaAbbreviation());
        }
        return subjects;
    }

    private HashSet<Long> getApprovableCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.offeringCoordinators oc where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType.reference = :reference and oc.instructor.externalUniqueId = :extId").setLong("sessionId", sessionId.longValue()).setString("reference", "IN").setString("extId", user.getExternalUserId()).setCacheable(true).list());
        if (!user.getCurrentAuthority().hasRight(Right.HasRole)) {
            return courseIds;
        }
        if (user.getCurrentAuthority().hasRight(Right.SessionIndependent)) {
            return new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select c.uniqueId from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        }
        for (Department d : Department.getUserDepartments(user)) {
            courseIds.addAll(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c where c.subjectArea.department.uniqueId = :departmentId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null").setLong("departmentId", d.getUniqueId().longValue()).setCacheable(true).list());
        }
        return courseIds;
    }

    private HashSet<Long> getMyStudents(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null || user.getCurrentAuthority() == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        return new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select s.uniqueId from Advisor a inner join a.students s where a.externalUniqueId = :user and a.role.reference = :role and a.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("user", user.getExternalUserId()).setString("role", user.getCurrentAuthority().getRole()).setCacheable(true).list());
    }

    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> findEnrollmentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas()).withFilter(filter), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas()).withFilter(filter), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, null, null, this.getMyStudents(server.getAcademicSession().getUniqueId()), this.getSubjectAreas()).withFilter(filter), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> findStudentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
                }
                return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, null, null, this.getMyStudents(server.getAcademicSession().getUniqueId()), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<String[]> querySuggestions(boolean online, String query, int limit) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                UserContext user = this.getSessionContext().getUser();
                return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            UserContext user = this.getSessionContext().getUser();
            return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> findEnrollments(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId, Long classId) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (this.getSessionContext().isAuthenticated()) {
                    this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant), this.getMyStudents(sessionId)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant), this.getMyStudents(sessionId)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            if (this.getSessionContext().isAuthenticated()) {
                this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
            }
            return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true, this.getMyStudents(server.getAcademicSession().getUniqueId())).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Long canEnroll(boolean online, Long studentId) throws SectioningException, PageAccessException {
        return this.canEnroll(online, null, studentId);
    }

    protected Long canEnroll(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningInterface.EligibilityCheck check;
            OnlineSectioningInterface.EligibilityCheck last;
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                CourseRequestInterface request = server.execute(server.createAction(GetRequest.class).forStudent(studentId), this.currentUser());
                if (request == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                return server.getAcademicSession().getUniqueId();
            }
            boolean recheckCustomEligibility = ApplicationProperty.OnlineSchedulingCustomEligibilityRecheck.isTrue();
            if (!(recheckCustomEligibility || (last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility)) == null || !last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT) && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL))) {
                recheckCustomEligibility = true;
            }
            if ((check = this.checkEligibility(online, true, sessionId, studentId, null, recheckCustomEligibility)) == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT)) {
                throw new SectioningException(check.getMessage() == null ? (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED) ? MSG.exceptionAuthenticationPinNotProvided() : MSG.exceptionInsufficientPrivileges()) : check.getMessage()).withEligibilityCheck(check);
            }
            if (studentId.equals(this.getStudentId(check.getSessionId()))) {
                return check.getSessionId();
            }
            if (this.getSessionContext().hasPermissionAnySession((Object)check.getSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
                return check.getSessionId();
            }
            OnlineSectioningServer server = this.getServerInstance(check.getSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            if (this.getStudentId(check.getSessionId()) == null) {
                throw new PageAccessException(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            throw new PageAccessException(MSG.exceptionInsufficientPrivileges());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    protected CourseRequestInterface getRequest(Student student) {
        OnlineSectioningServer server;
        CourseRequestInterface request = new CourseRequestInterface();
        request.setAcademicSessionId(student.getSession().getUniqueId());
        request.setStudentId(student.getUniqueId());
        request.setSaved(true);
        request.setMaxCredit(student.getMaxCredit());
        if (student.getOverrideMaxCredit() != null) {
            request.setMaxCreditOverride(student.getOverrideMaxCredit());
            request.setMaxCreditOverrideExternalId(student.getOverrideExternalId());
            request.setMaxCreditOverrideTimeStamp(student.getOverrideTimeStamp());
            Integer status = student.getOverrideStatus();
            if (status == null) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
            } else {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
            }
        }
        boolean setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnly.isTrue();
        if (this.getSessionContext().hasPermissionAnySession((Object)student.getSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) || this.getSessionContext().hasPermissionAnySession((Object)student.getSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
            setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnlyIfAdmin.isTrue();
        }
        boolean reservedNoPriority = ApplicationProperty.OnlineSchedulingReservedRequestNoPriorityChanges.isTrue();
        boolean reservedNoAlternatives = ApplicationProperty.OnlineSchedulingReservedRequestNoAlternativeChanges.isTrue();
        boolean enrolledNoPriority = ApplicationProperty.OnlineSchedulingAssignedRequestNoPriorityChanges.isTrue();
        boolean enrolledNoAlternatives = ApplicationProperty.OnlineSchedulingAssignedRequestNoAlternativeChanges.isTrue();
        HashSet<Long> courseIds = new HashSet<Long>();
        if (!student.getCourseDemands().isEmpty()) {
            TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

                @Override
                public int compare(CourseDemand d1, CourseDemand d2) {
                    if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                        return 1;
                    }
                    if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                        return -1;
                    }
                    int cmp = d1.getPriority().compareTo(d2.getPriority());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return d1.getUniqueId().compareTo(d2.getUniqueId());
                }
            });
            demands.addAll(student.getCourseDemands());
            CourseRequestInterface.Request lastRequest = null;
            int lastRequestPriority = -1;
            for (CourseDemand cd : demands) {
                CourseRequestInterface.Request r = null;
                if (cd.getFreeTime() != null) {
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(cd.getFreeTime().getStartSlot());
                    ft.setLength(cd.getFreeTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(cd.getFreeTime().getDayCode())) {
                        ft.addDay(day.getIndex());
                    }
                    if (lastRequest != null && lastRequestPriority == cd.getPriority() && lastRequest.hasRequestedCourse() && lastRequest.getRequestedCourse(0).isFreeTime()) {
                        lastRequest.getRequestedCourse(0).addFreeTime(ft);
                        continue;
                    }
                    r = new CourseRequestInterface.Request();
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.addFreeTime(ft);
                    r.addRequestedCourse(rc);
                    if (cd.isAlternative().booleanValue()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                    lastRequest = r;
                    lastRequestPriority = cd.getPriority();
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    continue;
                }
                if (cd.getCourseRequests().isEmpty()) continue;
                r = new CourseRequestInterface.Request();
                for (CourseRequest course : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
                    courseIds.add(course.getCourseOffering().getUniqueId());
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(course.getCourseOffering().getUniqueId());
                    rc.setCourseName(course.getCourseOffering().getSubjectAreaAbbv() + " " + course.getCourseOffering().getCourseNbr() + (!CONSTANTS.showCourseTitle() ? "" : " - " + course.getCourseOffering().getTitle()));
                    rc.setCourseTitle(course.getCourseOffering().getTitle());
                    CourseCreditUnitConfig credit = course.getCourseOffering().getCredit();
                    if (credit != null) {
                        rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                    }
                    boolean hasEnrollments = !course.getClassEnrollments().isEmpty();
                    rc.setReadOnly(hasEnrollments);
                    rc.setCanDelete(!hasEnrollments);
                    if (hasEnrollments) {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                    } else if (course.getOverrideStatus() != null) {
                        rc.setStatus(course.isRequestApproved() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED : (course.isRequestRejected() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED : (course.isRequestCancelled() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED : CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING)));
                    } else {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                    if (hasEnrollments) {
                        if (enrolledNoAlternatives) {
                            rc.setCanChangeAlternatives(false);
                        }
                        if (enrolledNoPriority) {
                            rc.setCanChangePriority(false);
                        }
                    }
                    if (setReadOnlyWhenReserved) {
                        for (Reservation reservation : course.getCourseOffering().getInstructionalOffering().getReservations()) {
                            if (!(reservation instanceof IndividualReservation) && !(reservation instanceof StudentGroupReservation) && !(reservation instanceof LearningCommunityReservation) || !reservation.isMustBeUsed() || reservation.isExpired() || !reservation.isApplicable(student, course)) continue;
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (reservedNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (!reservedNoPriority) break;
                            rc.setCanChangePriority(false);
                            break;
                        }
                    }
                    rc.setOverrideExternalId(course.getOverrideExternalId());
                    rc.setOverrideTimeStamp(course.getOverrideTimeStamp());
                    if (course.getPreferences() != null) {
                        for (StudentSectioningPref ssp : course.getPreferences()) {
                            if (ssp instanceof StudentClassPref) {
                                StudentClassPref scp = (StudentClassPref)ssp;
                                rc.setSelectedClass(scp.getClazz().getUniqueId(), scp.getClazz().getClassPrefLabel(course.getCourseOffering()), scp.isRequired(), true);
                                continue;
                            }
                            if (!(ssp instanceof StudentInstrMthPref)) continue;
                            StudentInstrMthPref imp = (StudentInstrMthPref)ssp;
                            rc.setSelectedIntructionalMethod(imp.getInstructionalMethod().getUniqueId(), imp.getInstructionalMethod().getLabel(), imp.isRequired(), true);
                        }
                    }
                    r.addRequestedCourse(rc);
                }
                if (r.hasRequestedCourse()) {
                    if (cd.isAlternative().booleanValue()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                }
                r.setWaitList(cd.getWaitlist());
                if (cd.isCriticalOverride() != null) {
                    r.setCritical(cd.isCriticalOverride());
                } else {
                    r.setCritical(cd.isCritical());
                }
                r.setTimeStamp(cd.getTimestamp());
                lastRequest = r;
                lastRequestPriority = cd.getPriority();
            }
        }
        if (!student.getClassEnrollments().isEmpty()) {
            TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
            for (StudentClassEnrollment enrl : student.getClassEnrollments()) {
                if (courseIds.contains(enrl.getCourseOffering().getUniqueId())) continue;
                courses.add(enrl.getCourseOffering());
            }
            for (CourseOffering c : courses) {
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseId(c.getUniqueId());
                rc.setCourseName(c.getSubjectAreaAbbv() + " " + c.getCourseNbr() + (!CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                rc.setCourseTitle(c.getTitle());
                CourseCreditUnitConfig credit = c.getCredit();
                if (credit != null) {
                    rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                }
                r.addRequestedCourse(rc);
                request.getCourses().add(r);
                rc.setReadOnly(true);
                rc.setCanDelete(false);
                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
            }
        }
        if (CustomCourseRequestsValidationHolder.hasProvider() && (server = this.getServerInstance(student.getSession().getUniqueId(), true)) != null) {
            try {
                return server.execute(server.createAction(CustomCourseRequestsValidationHolder.Check.class).withRequest(request), this.currentUser());
            }
            catch (SectioningException e) {
                sLog.warn((Object)("Failed to validate course requests: " + e.getMessage()), (Throwable)e);
            }
        }
        return request;
    }

    @Override
    public CourseRequestInterface savedRequest(boolean online, boolean sectioning, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        OnlineSectioningServer server;
        if (studentId == null) {
            studentId = this.getStudentId(sessionId);
            if (studentId == null && sessionId != null && online && CustomCourseRequestsHolder.hasProvider() && (server = this.getServerInstance(sessionId, false)) != null) {
                return server.execute(server.createAction(GetRequest.class), this.currentUser());
            }
            if (studentId == null) {
                throw new SectioningException(MSG.exceptionNoStudent());
            }
        }
        if (!online) {
            server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(GetRequest.class).forStudent(studentId, sectioning), this.currentUser());
        }
        server = this.getServerInstance(sessionId == null ? this.canEnroll(online, studentId) : sessionId, false);
        if (server != null) {
            return server.execute(server.createAction(GetRequest.class).forStudent(studentId, sectioning).withCustomValidation(!sectioning), this.currentUser());
        }
        try (Session hibSession = StudentDAO.getInstance().getSession();){
            Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            CourseRequestInterface request = this.getRequest(student);
            if (request.isEmpty() && CustomCourseRequestsHolder.hasProvider()) {
                OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser());
                CourseRequestInterface r = CustomCourseRequestsHolder.getProvider().getCourseRequests(this.getServerInstance(sessionId, true), helper, new XStudentId(student, helper));
                if (r != null) {
                    CourseRequestInterface courseRequestInterface = r;
                    return courseRequestInterface;
                }
            }
            CourseRequestInterface courseRequestInterface = request;
            return courseRequestInterface;
        }
    }

    @Override
    public ClassAssignmentInterface savedResult(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        if (online) {
            OnlineSectioningServer server = this.getServerInstance(sessionId == null ? this.canEnroll(online, studentId) : sessionId, false);
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
            OnlineSectioningInterface.EligibilityCheck last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility);
            if (ret != null && last != null && last.hasGradeModes()) {
                for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                        OnlineSectioningInterface.GradeMode m = last.getGradeMode(a);
                        if (m == null) continue;
                        a.setGradeMode(m);
                    }
                }
            }
            return ret;
        }
        StudentSolverProxy server = this.getStudentSolver();
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoSolver());
        }
        ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
        if (ret != null) {
            ret.setCanEnroll(this.getStudentId(sessionId) != null);
        }
        return ret;
    }

    @Override
    public Boolean selectSession(Long sessionId) {
        this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastSession, (Object)sessionId);
        UserContext user = this.getSessionContext().getUser();
        if (user != null && user.getCurrentAuthority() != null) {
            List<? extends UserAuthority> authorities = user.getAuthorities(user.getCurrentAuthority().getRole(), new SimpleQualifier("Session", sessionId));
            if (!authorities.isEmpty()) {
                user.setCurrentAuthority(authorities.get(0));
            } else {
                user.setCurrentAuthority(null);
            }
        }
        return true;
    }

    private OnlineSectioningInterface.StudentStatusInfo toStudentStatusInfo(StudentSectioningStatus status, List<CourseType> types, boolean admin, boolean advisor) {
        OnlineSectioningInterface.StudentStatusInfo info = new OnlineSectioningInterface.StudentStatusInfo();
        info.setUniqueId(status.getUniqueId());
        info.setReference(status.getReference());
        info.setLabel(status.getLabel());
        info.setCanAccessAssistantPage(status.hasOption(StudentSectioningStatus.Option.enabled));
        info.setCanAccessRequestsPage(status.hasOption(StudentSectioningStatus.Option.regenabled));
        info.setCanStudentEnroll(status.hasOption(StudentSectioningStatus.Option.enrollment));
        info.setCanStudentRegister(status.hasOption(StudentSectioningStatus.Option.registration));
        info.setCanAdvisorEnroll(status.hasOption(StudentSectioningStatus.Option.advisor));
        info.setCanAdvisorRegister(status.hasOption(StudentSectioningStatus.Option.regadvisor));
        info.setCanAdminEnroll(status.hasOption(StudentSectioningStatus.Option.admin));
        info.setCanAdminRegister(status.hasOption(StudentSectioningStatus.Option.regadmin));
        info.setWaitList(status.hasOption(StudentSectioningStatus.Option.waitlist));
        info.setCanRequire(status.hasOption(StudentSectioningStatus.Option.canreq));
        info.setEmail(status.hasOption(StudentSectioningStatus.Option.email));
        info.setNoSchedule(status.hasOption(StudentSectioningStatus.Option.noschedule));
        info.setMessage(status.getMessage());
        if (status.getFallBackStatus() != null) {
            info.setFallback(status.getFallBackStatus().getLabel());
        }
        if (!status.hasOption(StudentSectioningStatus.Option.notype)) {
            TreeSet<String> prohibited = new TreeSet<String>();
            for (CourseType courseType : types) {
                if (status.getTypes() != null && status.getTypes().contains(courseType)) continue;
                prohibited.add(courseType.getReference());
            }
            if (!prohibited.isEmpty()) {
                String refs = "";
                for (String ref : prohibited) {
                    refs = refs + (refs.isEmpty() ? "" : ", ") + ref;
                }
                info.setCourseTypes(MSG.courseTypesAllBut(refs));
            }
        } else {
            TreeSet<String> allowed = new TreeSet<String>();
            for (CourseType courseType : status.getTypes()) {
                allowed.add(courseType.getReference());
            }
            if (allowed.isEmpty()) {
                info.setCourseTypes(MSG.courseTypesNoneAllowed());
            } else {
                Object refs = "";
                for (String ref : allowed) {
                    refs = (String)refs + (((String)refs).isEmpty() ? "" : ", ") + ref;
                }
                info.setCourseTypes(MSG.courseTypesAllowed((String)refs));
            }
        }
        if (status.getEffectiveStartDate() != null || status.getEffectiveStartPeriod() != null) {
            if (status.getEffectiveStartDate() == null) {
                info.setEffectiveStart(Constants.slot2str(status.getEffectiveStartPeriod()));
            } else if (status.getEffectiveStartPeriod() == null) {
                info.setEffectiveStart(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStartDate()));
            } else {
                info.setEffectiveStart(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStartDate()) + " " + Constants.slot2str(status.getEffectiveStartPeriod()));
            }
        }
        if (status.getEffectiveStopDate() != null || status.getEffectiveStopPeriod() != null) {
            if (status.getEffectiveStopDate() == null) {
                info.setEffectiveStop(Constants.slot2str(status.getEffectiveStopPeriod()));
            } else if (status.getEffectiveStopPeriod() == null) {
                info.setEffectiveStop(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStopDate()));
            } else {
                info.setEffectiveStop(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStopDate()) + " " + Constants.slot2str(status.getEffectiveStopPeriod()));
            }
        }
        if (this.getSessionContext().hasPermission(Right.SchedulingAssistant)) {
            info.setCanUseAssistant(StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.enabled) || admin && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.admin) || advisor && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.advisor));
        }
        if (this.getSessionContext().hasPermission(Right.CourseRequests)) {
            info.setCanRegister(StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regenabled) || admin && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regadmin) || advisor && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regadvisor));
        }
        return info;
    }

    @Override
    public List<OnlineSectioningInterface.StudentStatusInfo> lookupStudentSectioningStates() throws SectioningException, PageAccessException {
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("select distinct t from CourseOffering c inner join c.courseType t where c.instructionalOffering.session = :sessionId order by t.reference").setLong("sessionId", this.getStatusPageSessionId().longValue()).setCacheable(true).list();
        ArrayList<OnlineSectioningInterface.StudentStatusInfo> ret = new ArrayList<OnlineSectioningInterface.StudentStatusInfo>();
        boolean advisor = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        boolean admin = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]);
        boolean email = true;
        boolean waitlist = CustomStudentEnrollmentHolder.isAllowWaitListing();
        boolean specreg = CustomSpecialRegistrationHolder.hasProvider();
        boolean reqval = CustomCourseRequestsValidationHolder.hasProvider();
        if (admin) {
            org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(this.getStatusPageSessionId());
            OnlineSectioningInterface.StudentStatusInfo info = null;
            if (session.getDefaultSectioningStatus() != null) {
                info = this.toStudentStatusInfo(session.getDefaultSectioningStatus(), courseTypes, admin, advisor);
                info.setUniqueId(null);
                info.setReference("");
                info.setLabel(MSG.studentStatusSessionDefault(session.getDefaultSectioningStatus().getLabel()));
                info.setEffectiveStart(null);
                info.setEffectiveStop(null);
            } else {
                info = new OnlineSectioningInterface.StudentStatusInfo();
                info.setReference("");
                info.setLabel(MSG.studentStatusSystemDefault());
                info.setAllEnabled();
            }
            info.setEmail(email);
            info.setWaitList(waitlist);
            info.setSpecialRegistration(specreg);
            info.setRequestValiadtion(reqval);
            ret.add(info);
        }
        for (StudentSectioningStatus s : StudentSectioningStatus.findAll(this.getStatusPageSessionId())) {
            if (s.isPast() || advisor && !admin && !s.hasOption(StudentSectioningStatus.Option.advcanset)) continue;
            OnlineSectioningInterface.StudentStatusInfo info = this.toStudentStatusInfo(s, courseTypes, admin, advisor);
            info.setEmail(email && s.hasOption(StudentSectioningStatus.Option.email));
            info.setWaitList(waitlist && s.hasOption(StudentSectioningStatus.Option.waitlist));
            info.setSpecialRegistration(specreg && s.hasOption(StudentSectioningStatus.Option.specreg));
            info.setRequestValiadtion(reqval && s.hasOption(StudentSectioningStatus.Option.reqval));
            info.setCanRequire(s.hasOption(StudentSectioningStatus.Option.canreq));
            ret.add(info);
        }
        return ret;
    }

    @Override
    public Boolean sendEmail(Long studentId, String subject, String message, String cc, Boolean courseRequests, Boolean classSchedule) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingEmailStudent);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                if (!myStudentIds.contains(studentId)) {
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingEmailStudent.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            StudentEmail email = server.createAction(StudentEmail.class).forStudent(studentId);
            if (courseRequests != null && classSchedule != null) {
                email.overridePermissions(courseRequests, classSchedule);
            }
            email.setCC(cc);
            email.setEmailSubject(subject == null || subject.isEmpty() ? MSG.defaulSubject() : subject);
            email.setMessage(message);
            return server.execute(email, this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean changeStatus(List<Long> studentIds, String note, String ref) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingChangeStudentStatus);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingChangeStudentStatus.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            Boolean ret = server.execute(server.createAction(ChangeStudentStatus.class).forStudents(studentIds).withStatus(ref).withNote(note), this.currentUser());
            try {
                SessionFactory hibSessionFactory = SessionDAO.getInstance().getSession().getSessionFactory();
                for (Long studentId : studentIds) {
                    hibSessionFactory.getCache().evictEntity(Student.class, (Serializable)studentId);
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to evict cache: " + e.getMessage()));
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean changeStudentGroup(List<Long> studentIds, Long groupId, boolean remove) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingChangeStudentGroup);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingChangeStudentGroup.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            return server.execute(server.createAction(ChangeStudentGroup.class).forStudents(studentIds).withGroup(groupId, remove), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private OnlineSectioningLog.Entity currentUser() {
        UserContext user = this.getSessionContext().getUser();
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        String pin = (String)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingPIN);
        String specialRequestId = (String)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastSpecialRequest);
        if (user != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getTrueExternalUserId()).setName(user.getTrueName() == null ? user.getUsername() : user.getTrueName()).setType(user instanceof AdministrationPermissions.Chameleon || principal != null ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT);
            if (pin != null) {
                entity.addParameterBuilder().setKey("pin").setValue(pin);
            }
            if (principal != null && principal.getStudentExternalId() != null) {
                entity.addParameterBuilder().setKey("student").setValue(principal.getStudentExternalId());
            }
            if (specialRequestId != null) {
                entity.addParameterBuilder().setKey("specreq").setValue(specialRequestId);
            }
            return entity.build();
        }
        if (principal != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(principal.getExternalId()).setName(principal.getName()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER);
            if (pin != null) {
                entity.addParameterBuilder().setKey("pin").setValue(pin);
            }
            if (specialRequestId != null) {
                entity.addParameterBuilder().setKey("specreq").setValue(specialRequestId);
            }
            return entity.build();
        }
        return null;
    }

    @Override
    public List<ClassAssignmentInterface.SectioningAction> changeLog(String query) throws SectioningException, PageAccessException {
        Long sessionId = this.getStatusPageSessionId();
        OnlineSectioningServer server = this.getServerInstance(sessionId, true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (server instanceof DatabaseServer) {
            return server.execute(server.createAction(DbFindOnlineSectioningLogAction.class).forQuery(query, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)), this.currentUser());
        }
        return server.execute(server.createAction(FindOnlineSectioningLogAction.class).forQuery(query, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)), this.currentUser());
    }

    @Override
    public Boolean massCancel(List<Long> studentIds, String statusRef, String subject, String message, String cc) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingMassCancel);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingMassCancel.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            return server.execute(server.createAction(MassCancelAction.class).forStudents(studentIds).withStatus(statusRef).withEmail(subject, message, cc), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public OnlineSectioningInterface.EligibilityCheck checkEligibility(boolean online, boolean sectioning, Long sessionId, Long studentId, String pin) throws SectioningException, PageAccessException {
        return this.checkEligibility(online, sectioning, sessionId, studentId, pin, true);
    }

    public OnlineSectioningInterface.EligibilityCheck checkEligibility(boolean online, boolean sectioning, Long sessionId, Long studentId, String pin, boolean includeCustomCheck) throws SectioningException, PageAccessException {
        try {
            Student student;
            if (pin != null && !pin.isEmpty()) {
                this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingPIN, (Object)pin);
            }
            if (includeCustomCheck) {
                this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingEligibility);
            }
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoSolver(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
                }
                OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
                check.setSessionId(server.getAcademicSession().getUniqueId());
                check.setStudentId(studentId);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, !server.isPublished());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, ApplicationProperty.SolverDashboardAllowWaitList.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.SolverDashboardAllowScheduleReset.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, ApplicationProperty.OnlineSchedulingConfirmCourseDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, CustomDegreePlansHolder.hasProvider());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, true);
                return check;
            }
            if (sessionId == null && studentId != null && (student = (Student)StudentDAO.getInstance().get(studentId)) != null) {
                sessionId = student.getSession().getUniqueId();
            }
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            } else {
                this.setLastSessionId(sessionId);
            }
            if (sessionId == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoAcademicSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                return new OnlineSectioningInterface.EligibilityCheck(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            if (studentId == null) {
                studentId = this.getStudentId(sessionId);
            }
            OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN, this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR, this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST, user instanceof AnonymousUserContext);
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleReset.isTrue());
            if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET) && (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR))) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleResetIfAdmin.isTrue());
            }
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, ApplicationProperty.OnlineSchedulingConfirmCourseDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, CustomDegreePlansHolder.hasProvider());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
            check.setSessionId(sessionId);
            check.setStudentId(studentId);
            if (!sectioning) {
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    Student student2;
                    Student student3 = student2 = studentId == null ? null : (Student)StudentDAO.getInstance().get(studentId);
                    if (student2 == null) {
                        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                            check.setMessage(MSG.exceptionEnrollNotStudent(((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId)).getLabel()));
                        }
                        return check;
                    }
                    StudentSectioningStatus status = student2.getEffectiveStatus();
                    if (status == null) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, true);
                    } else {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, status.hasOption(StudentSectioningStatus.Option.regenabled) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && status.hasOption(StudentSectioningStatus.Option.regadmin) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) && status.hasOption(StudentSectioningStatus.Option.regadvisor));
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, status.hasOption(StudentSectioningStatus.Option.waitlist));
                        check.setMessage(status.getMessage());
                    }
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, this.getSessionContext().hasPermissionAnyAuthority((Object)student2, Right.StudentSchedulingCanRegister, new Qualifiable[0]));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.getSessionContext().hasPermissionAnyAuthority((Object)student2, Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0]));
                    if (!check.hasMessage() && !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
                        check.setMessage(MSG.exceptionAccessDisabled());
                    }
                    return check;
                }
                return server.execute(server.createAction(CourseRequestEligibility.class).forStudent(studentId).withCheck(check).includeCustomCheck(includeCustomCheck).withPermission(this.getSessionContext().hasPermissionAnyAuthority(studentId, "Student", Right.StudentSchedulingCanRegister, new Qualifiable[0]), this.getSessionContext().hasPermissionAnyAuthority(studentId, "Student", Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0])), this.currentUser());
            }
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoServerForSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            OnlineSectioningInterface.EligibilityCheck ret = server.execute(server.createAction(CheckEligibility.class).forStudent(studentId).withCheck(check).includeCustomCheck(includeCustomCheck).withPermission(this.getSessionContext().hasPermissionAnyAuthority(studentId, "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]), this.getSessionContext().hasPermissionAnyAuthority(studentId, "Student", Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0])), this.currentUser());
            if (includeCustomCheck) {
                this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingEligibility, (Object)ret);
            }
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionUnknown(e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : (e.getCause() != null ? e.getCause().getClass().getSimpleName() : e.getClass().getSimpleName())), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
        }
    }

    public void destroy() throws Exception {
        for (Customization customization : Customization.values()) {
            customization.release();
        }
    }

    @Override
    public OnlineSectioningInterface.SectioningProperties getProperties(Long sessionId) throws SectioningException, PageAccessException {
        OnlineSectioningInterface.SectioningProperties properties = new OnlineSectioningInterface.SectioningProperties();
        properties.setAdmin(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]));
        properties.setAdvisor(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]));
        if (sessionId == null && this.getSessionContext().getUser() != null) {
            sessionId = this.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        properties.setSessionId(sessionId);
        if (sessionId != null) {
            properties.setChangeLog(properties.isAdmin() && this.getServerInstance(sessionId, true) != null);
            properties.setMassCancel(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingMassCancel));
            properties.setEmail(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingEmailStudent));
            properties.setChangeStatus(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingChangeStudentStatus));
            properties.setRequestUpdate(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingRequestStudentUpdate));
            properties.setCheckStudentOverrides(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingCheckStudentOverrides));
            properties.setValidateStudentOverrides(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingValidateStudentOverrides));
            properties.setRecheckCriticalCourses(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingRecheckCriticalCourses));
            if (this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingChangeStudentGroup)) {
                for (StudentGroup g : StudentGroupDAO.getInstance().getSession().createQuery("from StudentGroup g where g.type.advisorsCanSet = true and g.session = :sessionId order by g.groupAbbreviation").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    properties.addEditableGroup(new OnlineSectioningInterface.StudentGroupInfo(g.getUniqueId(), g.getGroupAbbreviation(), g.getGroupName(), g.getType() == null ? null : g.getType().getReference()));
                }
            }
        }
        return properties;
    }

    @Override
    public Boolean requestStudentUpdate(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingRequestStudentUpdate);
        return server.execute(server.createAction(RequestStudentUpdates.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public Boolean checkStudentOverrides(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingCheckStudentOverrides);
        return server.execute(server.createAction(CustomCourseRequestsValidationHolder.Update.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public Boolean validateStudentOverrides(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingValidateStudentOverrides);
        return server.execute(server.createAction(CustomCourseRequestsValidationHolder.Validate.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public Boolean recheckCriticalCourses(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingRecheckCriticalCourses);
        return server.execute(server.createAction(CustomCriticalCoursesHolder.CheckCriticalCourses.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public List<DegreePlanInterface> listDegreePlans(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            sessionId = this.getLastSessionId();
        }
        if (studentId == null) {
            studentId = this.getStudentId(sessionId);
        } else if (!studentId.equals(this.getStudentId(sessionId))) {
            this.getSessionContext().checkPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        }
        OnlineSectioningServer server = null;
        if (!online) {
            server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
        } else {
            server = this.getServerInstance(sessionId, true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
        }
        return server.execute(server.createAction(GetDegreePlans.class).forStudent(studentId), this.currentUser());
    }

    @Override
    public ClassAssignmentInterface.Student lookupStudent(boolean online, String studentId) throws SectioningException, PageAccessException {
        if (this.getSessionContext().getUser() == null || this.getSessionContext().getUser().getCurrentAcademicSessionId() == null) {
            return null;
        }
        Student student = Student.findByExternalId(this.getSessionContext().getUser().getCurrentAcademicSessionId(), studentId);
        if (student == null) {
            return null;
        }
        this.getSessionContext().checkPermission(student, Right.StudentEnrollments);
        ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
        st.setId(student.getUniqueId());
        st.setSessionId(this.getSessionContext().getUser().getCurrentAcademicSessionId());
        st.setExternalId(student.getExternalUniqueId());
        st.setCanShowExternalId(this.getSessionContext().hasPermission(Right.EnrollmentsShowExternalId));
        st.setCanRegister(this.getSessionContext().hasPermission(Right.CourseRequests) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanRegister));
        st.setCanUseAssistant(online ? this.getSessionContext().hasPermission(Right.SchedulingAssistant) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanEnroll) : this.getStudentSolver() != null);
        st.setName(student.getName(ApplicationProperty.OnlineSchedulingStudentNameFormat.value()));
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
            st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation());
            st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode());
            st.addMajor(studentAreaClassificationMajor.getMajor().getCode());
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            if (studentGroup.getType() == null) {
                st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                continue;
            }
            st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            st.addAccommodation(studentAccomodation.getAbbreviation());
        }
        for (Advisor advisor : student.getAdvisors()) {
            if (advisor.getLastName() == null) continue;
            st.addAdvisor(NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value()).format(advisor));
        }
        return st;
    }

    @Override
    public SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitSpecialRequest(SpecialRegistrationInterface.SubmitSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationSubmit.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse checkSpecialRequestEligibility(SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationEligibility.class).withRequest(request), this.currentUser());
    }

    @Override
    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> retrieveAllSpecialRequests(SpecialRegistrationInterface.RetrieveAllSpecialRegistrationsRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationRetrieveAll.class).withRequest(request), this.currentUser());
    }

    @Override
    public ClassAssignmentInterface.Student lookupStudent(boolean online, Long studentId) throws SectioningException, PageAccessException {
        if (this.getSessionContext().getUser() == null || this.getSessionContext().getUser().getCurrentAcademicSessionId() == null) {
            return null;
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        if (student == null) {
            return null;
        }
        this.getSessionContext().checkPermission(student, Right.StudentEnrollments);
        ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
        st.setId(student.getUniqueId());
        st.setSessionId(this.getSessionContext().getUser().getCurrentAcademicSessionId());
        st.setExternalId(student.getExternalUniqueId());
        st.setCanShowExternalId(this.getSessionContext().hasPermission(Right.EnrollmentsShowExternalId));
        st.setCanRegister(this.getSessionContext().hasPermission(Right.CourseRequests) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanRegister));
        st.setCanUseAssistant(online ? this.getSessionContext().hasPermission(Right.SchedulingAssistant) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanEnroll) : this.getStudentSolver() != null);
        st.setName(student.getName(ApplicationProperty.OnlineSchedulingStudentNameFormat.value()));
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
            st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation());
            st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode());
            st.addMajor(studentAreaClassificationMajor.getMajor().getCode());
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            if (studentGroup.getType() == null) {
                st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                continue;
            }
            st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            st.addAccommodation(studentAccomodation.getAbbreviation());
        }
        for (Advisor advisor : student.getAdvisors()) {
            if (advisor.getLastName() == null) continue;
            st.addAdvisor(NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value()).format(advisor));
        }
        return st;
    }

    @Override
    public ClassAssignmentInterface section(boolean online, CourseRequestInterface request, List<ClassAssignmentInterface.ClassAssignment> currentAssignment, List<ClassAssignmentInterface.ClassAssignment> specialRegistration) throws SectioningException, PageAccessException {
        try {
            this.setLastSessionId(request.getAcademicSessionId());
            this.setLastRequest(request);
            request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment).withSpecialRegistration(specialRegistration), this.currentUser()).get(0);
            if (ret != null) {
                ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
                if (ret.isCanEnroll() && this.getStudentId(request.getAcademicSessionId()) == null) {
                    ret.setCanEnroll(false);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    @Override
    public SpecialRegistrationInterface.CancelSpecialRegistrationResponse cancelSpecialRequest(SpecialRegistrationInterface.CancelSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationCancel.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse retrieveGradeModes(SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationRetrieveGradeModes.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.ChangeGradeModesResponse changeGradeModes(SpecialRegistrationInterface.ChangeGradeModesRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getSessionId());
        SpecialRegistrationInterface.ChangeGradeModesResponse ret = server.execute(server.createAction(SpecialRegistrationChangeGradeModes.class).withRequest(request), this.currentUser());
        OnlineSectioningInterface.EligibilityCheck last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility);
        if (ret != null && ret.hasGradeModes() && last != null) {
            for (Map.Entry<String, OnlineSectioningInterface.GradeMode> e : ret.getGradeModes().toMap().entrySet()) {
                last.addGradeMode(e.getKey(), e.getValue().getCode(), e.getValue().getLabel(), e.getValue().isHonor());
            }
        }
        return ret;
    }

    @Override
    public Boolean changeCriticalOverride(Long studentId, Long courseId, Boolean critical) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermission(studentId, Right.StudentSchedulingChangeCriticalOverride);
        try {
            Session hibSession = CourseDemandDAO.getInstance().getSession();
            CourseDemand cd = (CourseDemand)hibSession.createQuery("select cr.courseDemand from CourseRequest cr where cr.courseOffering = :courseId and cr.courseDemand.student = :studentId").setLong("studentId", studentId.longValue()).setLong("courseId", courseId.longValue()).setMaxResults(1).uniqueResult();
            if (cd == null) {
                return null;
            }
            cd.setCriticalOverride(critical);
            hibSession.save((Object)cd);
            hibSession.flush();
            OnlineSectioningServer server = this.getServerInstance(cd.getStudent().getSession().getUniqueId(), false);
            if (server != null) {
                server.execute(server.createAction(ReloadStudent.class).forStudents(studentId), this.currentUser());
            }
            return cd.isCriticalOverride() != null ? cd.isCriticalOverride() : (cd.isCritical() != null ? cd.isCritical() : false);
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException("Failed to update critical status: " + e.getMessage(), e);
        }
    }

    @Override
    public SpecialRegistrationInterface.UpdateSpecialRegistrationResponse updateSpecialRequest(SpecialRegistrationInterface.UpdateSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        if (request.getSessionId() == null) {
            request.setSessionId(this.getLastSessionId());
        }
        if (request.getStudentId() == null) {
            Long sessionId = request.getSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        if (request.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.setLastSessionId(request.getSessionId());
        return server.execute(server.createAction(SpecialRegistrationUpdate.class).withRequest(request), this.currentUser());
    }

    static class CourseMatcher
    extends AbstractCourseMatcher {
        private org.unitime.timetable.onlinesectioning.match.CourseMatcher iParent;
        private static final long serialVersionUID = 1L;
        private boolean iAllCourseTypes;
        private boolean iNoCourseType;
        private Set<String> iAllowedCourseTypes;
        private Set<Long> iAllowedCourseIds;

        public CourseMatcher(boolean allCourseTypes, boolean noCourseType, Set<String> allowedCourseTypes, Set<Long> allowedCourseIds) {
            this.iAllCourseTypes = allCourseTypes;
            this.iNoCourseType = noCourseType;
            this.iAllowedCourseTypes = allowedCourseTypes;
            this.iAllowedCourseIds = allowedCourseIds;
        }

        public boolean isAllCourseTypes() {
            return this.iAllCourseTypes;
        }

        public boolean isNoCourseType() {
            return this.iNoCourseType;
        }

        public boolean hasAllowedCourseTypes() {
            return this.iAllowedCourseTypes != null && !this.iAllowedCourseTypes.isEmpty();
        }

        public Set<String> getAllowedCourseTypes() {
            return this.iAllowedCourseTypes;
        }

        public Set<Long> getAllowedCourseIds() {
            return this.iAllowedCourseIds;
        }

        public boolean isAllowedCourseId(XCourseId course) {
            return this.iAllowedCourseIds != null && course != null && this.iAllowedCourseIds.contains(course.getCourseId());
        }

        public org.unitime.timetable.onlinesectioning.match.CourseMatcher getParentCourseMatcher() {
            return this.iParent;
        }

        public void setParentCourseMatcher(org.unitime.timetable.onlinesectioning.match.CourseMatcher parent) {
            this.iParent = parent;
        }

        @Override
        public boolean match(XCourseId course) {
            if (this.isAllowedCourseId(course)) {
                return true;
            }
            return course != null && course.matchType(this.iAllCourseTypes, this.iNoCourseType, this.iAllowedCourseTypes) && (this.iParent == null || this.iParent.match(course));
        }
    }
}

