/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.sectioning.AcademicSessionSelector;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningWidget;
import org.unitime.timetable.gwt.client.sectioning.UserAuthentication;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class StudentSectioningPage
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);

    public StudentSectioningPage(final Mode mode) {
        final UserAuthentication userAuthentication = new UserAuthentication(UniTimePageHeader.getInstance().getMiddle(), mode.isSectioning() ? !CONSTANTS.isAuthenticationRequired() : false);
        if (Window.Location.getParameter((String)"student") == null) {
            this.iSectioningService.whoAmI(new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired() || CONSTANTS.tryAuthenticationWhenGuest()) {
                        if (CONSTANTS.allowUserLogin()) {
                            userAuthentication.authenticate();
                        } else if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired()) {
                            ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                        } else {
                            userAuthentication.authenticated(null);
                        }
                    }
                }

                public void onSuccess(String result) {
                    if (result == null) {
                        if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired() || CONSTANTS.tryAuthenticationWhenGuest()) {
                            if (CONSTANTS.allowUserLogin()) {
                                userAuthentication.authenticate();
                            } else if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired()) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                            } else {
                                userAuthentication.authenticated(result);
                            }
                        } else {
                            userAuthentication.authenticated(result);
                        }
                    } else {
                        userAuthentication.authenticated(result);
                    }
                }
            });
        }
        final AcademicSessionSelector sessionSelector = new AcademicSessionSelector(UniTimePageHeader.getInstance().getRight(), mode);
        this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                userAuthentication.setAllowLookup(result.isAdminOrAdvisor());
                if (Window.Location.getParameter((String)"session") != null || Window.Location.getParameter((String)"term") != null) {
                    sessionSelector.selectSession(new AcademicSessionProvider.AcademicSessionMatcher(){

                        protected boolean matchCampus(AcademicSessionProvider.AcademicSessionInfo info, String campus) {
                            if (info.hasExternalCampus() && campus.equalsIgnoreCase(info.getExternalCampus())) {
                                return true;
                            }
                            return campus.equalsIgnoreCase(info.getCampus());
                        }

                        protected boolean matchTerm(AcademicSessionProvider.AcademicSessionInfo info, String term) {
                            if (info.hasExternalTerm() && term.equalsIgnoreCase(info.getExternalTerm())) {
                                return true;
                            }
                            return term.equalsIgnoreCase(info.getTerm() + info.getYear()) || term.equalsIgnoreCase(info.getYear() + info.getTerm()) || term.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus());
                        }

                        protected boolean matchSession(AcademicSessionProvider.AcademicSessionInfo info, String session) {
                            if (info.hasExternalTerm() && info.hasExternalCampus() && session.equalsIgnoreCase(info.getExternalTerm() + info.hasExternalCampus())) {
                                return true;
                            }
                            return session.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus()) || session.equalsIgnoreCase(info.getTerm() + info.getYear()) || session.equals(info.getSessionId().toString());
                        }

                        @Override
                        public boolean match(AcademicSessionProvider.AcademicSessionInfo info) {
                            String campus = Window.Location.getParameter((String)"campus");
                            if (campus != null && !this.matchCampus(info, campus)) {
                                return false;
                            }
                            String term = Window.Location.getParameter((String)"term");
                            if (term != null && !this.matchTerm(info, term)) {
                                return false;
                            }
                            String session = Window.Location.getParameter((String)"session");
                            return session == null || this.matchSession(info, session);
                        }
                    }, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(Boolean result) {
                            if (Window.Location.getParameter((String)"student") != null && userAuthentication.isAllowLookup()) {
                                UserAuthentication.personFound(Window.Location.getParameter((String)"student"));
                            }
                        }
                    });
                }
            }
        });
        UniTimePageHeader.getInstance().getLeft().setVisible(false);
        UniTimePageHeader.getInstance().getLeft().setPreventDefault(true);
        final StudentSectioningWidget widget = new StudentSectioningWidget(true, sessionSelector, userAuthentication, mode, true);
        this.initWidget((Widget)widget);
        UniTimePageHeader.getInstance().getRight().setClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (widget.isChanged()) {
                    UniTimeConfirmationDialog.confirm(widget.useDefaultConfirmDialog(), mode.isSectioning() ? MESSAGES.queryLeaveChangesOnClassSchedule() : MESSAGES.queryLeaveChangesOnCourseRequests(), new Command(){

                        public void execute() {
                            sessionSelector.selectSession();
                        }
                    });
                } else {
                    sessionSelector.selectSession();
                }
            }
        });
        UniTimePageHeader.getInstance().getMiddle().setClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CONSTANTS.allowUserLogin()) {
                    if (widget.isChanged()) {
                        UniTimeConfirmationDialog.confirm(widget.useDefaultConfirmDialog(), mode.isSectioning() ? MESSAGES.queryLeaveChangesOnClassSchedule() : MESSAGES.queryLeaveChangesOnCourseRequests(), new Command(){

                            public void execute() {
                                if (userAuthentication.isLoggedIn()) {
                                    userAuthentication.logOut();
                                } else {
                                    userAuthentication.authenticate();
                                }
                            }
                        });
                    } else if (userAuthentication.isLoggedIn()) {
                        userAuthentication.logOut();
                    } else {
                        userAuthentication.authenticate();
                    }
                } else if (userAuthentication.isAllowLookup()) {
                    userAuthentication.doLookup();
                } else if (userAuthentication.isLoggedIn()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "logOut.do");
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                }
            }
        });
        userAuthentication.addUserAuthenticatedHandler(new UserAuthentication.UserAuthenticatedHandler(){

            @Override
            public void onLogIn(UserAuthentication.UserAuthenticatedEvent event) {
                if (!mode.isSectioning()) {
                    sessionSelector.selectSession(null, false);
                }
                sessionSelector.selectSession();
            }

            @Override
            public void onLogOut(UserAuthentication.UserAuthenticatedEvent event) {
                if (!event.isGuest()) {
                    widget.clearMessage();
                    widget.clear();
                }
                userAuthentication.authenticate();
            }
        });
        sessionSelector.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                if (event.isChanged()) {
                    widget.clearMessage();
                    widget.clear();
                }
                widget.checkEligibility(event.getNewAcademicSessionId(), null, true, null);
                userAuthentication.setLookupOptions("mustHaveExternalId,source=students,session=" + event.getNewAcademicSessionId());
            }
        });
        if (Window.Location.getParameter((String)"session") == null && Window.Location.getParameter((String)"term") == null) {
            this.iSectioningService.lastAcademicSession(mode.isSectioning(), new AsyncCallback<AcademicSessionProvider.AcademicSessionInfo>(){

                public void onFailure(Throwable caught) {
                    if (!userAuthentication.isShowing() && !UniTimeFrameDialog.hasDialog()) {
                        sessionSelector.selectSession();
                    }
                }

                public void onSuccess(AcademicSessionProvider.AcademicSessionInfo result) {
                    sessionSelector.selectSession(result, true);
                }
            });
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (widget.isChanged()) {
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                    event.setMessage(mode.isSectioning() ? MESSAGES.queryLeaveChangesOnClassSchedule() : MESSAGES.queryLeaveChangesOnCourseRequests());
                }
            }
        });
    }

    public static enum Mode {
        SECTIONING(true),
        REQUESTS(false);

        boolean iSectioning;

        private Mode(boolean isSectioning) {
            this.iSectioning = isSectioning;
        }

        public boolean isSectioning() {
            return this.iSectioning;
        }
    }
}

