/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;

public class DegreePlansSelectionDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static DateTimeFormat sModifiedDateFormat = ServerDateTimeFormat.getFormat(CONSTANTS.timeStampFormat());
    private SimpleForm iForm;
    private UniTimeTable<DegreePlanInterface> iTable;
    private UniTimeHeaderPanel iFooter;
    private String iLastSubmit = null;

    public DegreePlansSelectionDialog() {
        super(true, true);
        this.setEscapeToHide(true);
        this.setEnterToSubmit(new Command(){

            public void execute() {
                if (DegreePlansSelectionDialog.this.iTable.getSelectedRow() > 0) {
                    DegreePlansSelectionDialog.this.doSubmit((DegreePlanInterface)DegreePlansSelectionDialog.this.iTable.getData(DegreePlansSelectionDialog.this.iTable.getSelectedRow()));
                }
            }
        });
        this.setText(MESSAGES.dialogSelectDegreePlan());
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("unitime-SelectDegreePlan");
        this.iTable = new UniTimeTable();
        this.iTable.addStyleName("plans-table");
        this.iTable.setAllowSelection(true);
        this.iTable.setAllowMultiSelect(false);
        this.iForm.addRow((Widget)this.iTable);
        this.iFooter = new UniTimeHeaderPanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.setWidget((Widget)this.iForm);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colDegreePlanName()));
        header.add(new UniTimeTableHeader(MESSAGES.colDegreePlanDegree()));
        header.add(new UniTimeTableHeader(MESSAGES.colDegreePlanLastModified()));
        header.add(new UniTimeTableHeader(MESSAGES.colDegreePlanModifiedBy()));
        this.iTable.addRow(null, header);
        this.iFooter.addButton("select", MESSAGES.buttonDegreePlanSelect(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DegreePlansSelectionDialog.this.iTable.getSelectedRow() > 0) {
                    DegreePlansSelectionDialog.this.doSubmit((DegreePlanInterface)DegreePlansSelectionDialog.this.iTable.getData(DegreePlansSelectionDialog.this.iTable.getSelectedRow()));
                }
            }
        });
        this.iFooter.addButton("cancel", MESSAGES.buttonDegreePlanCancel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DegreePlansSelectionDialog.this.hide();
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<DegreePlanInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<DegreePlanInterface> event) {
                if (event.getData() != null) {
                    DegreePlansSelectionDialog.this.doSubmit(event.getData());
                }
            }
        });
    }

    public void open(List<DegreePlanInterface> plans) {
        this.iTable.clearTable(1);
        int select = -1;
        boolean hasTS = false;
        for (DegreePlanInterface plan : plans) {
            ArrayList<P> row = new ArrayList<P>();
            P p = new P("icons");
            if (plan.isLocked()) {
                Image lock = new Image(RESOURCES.locked());
                lock.setTitle(MESSAGES.hintLockedPlan());
                p.add((Widget)lock);
            } else if (plan.isActive()) {
                Image active = new Image(RESOURCES.activePlan());
                active.setTitle(MESSAGES.hintActivePlan());
                p.add((Widget)active);
            }
            row.add(p);
            row.add((P)new Label(plan.getName() == null ? "" : plan.getName()));
            row.add((P)new Label(plan.getDegree() == null ? "" : plan.getDegree()));
            row.add((P)new Label(plan.getLastModified() == null ? "" : sModifiedDateFormat.format(plan.getLastModified())));
            row.add((P)new Label(plan.getModifiedWho() == null ? "" : plan.getModifiedWho()));
            if (plan.getLastModified() != null || plan.getModifiedWho() != null) {
                hasTS = true;
            }
            if (plan.getId().equals(this.iLastSubmit)) {
                select = this.iTable.getRowCount();
            } else if (select < 0 && plan.isActive()) {
                select = this.iTable.getRowCount();
            }
            this.iTable.addRow(plan, row);
        }
        this.iTable.setColumnVisible(3, hasTS);
        this.iTable.setColumnVisible(4, hasTS);
        this.iTable.setSelected(select < 0 ? 1 : select, true);
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                DegreePlansSelectionDialog.this.iFooter.setFocus("select", true);
            }
        });
        this.updateAriaStatus(true);
    }

    @Override
    public void show() {
        super.show();
        this.updateAriaStatus(true);
    }

    public void doSubmit(DegreePlanInterface plan) {
        if (plan != null) {
            AriaStatus.getInstance().setText(ARIA.selectedDegreePlan(plan.getName(), plan.getDegree()));
        }
        this.iLastSubmit = plan.getId();
        this.hide();
    }

    @Override
    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (event.getTypeInt() == 128) {
            if (event.getNativeEvent().getKeyCode() == 38) {
                int row = this.iTable.getSelectedRow();
                if (row >= 0) {
                    this.iTable.setSelected(row, false);
                }
                if (--row <= 0) {
                    row = this.iTable.getRowCount() - 1;
                }
                this.iTable.setSelected(row, true);
                this.updateAriaStatus(false);
            } else if (event.getNativeEvent().getKeyCode() == 40) {
                int row = this.iTable.getSelectedRow();
                if (row >= 0) {
                    this.iTable.setSelected(row, false);
                }
                if (++row >= this.iTable.getRowCount()) {
                    row = 1;
                }
                this.iTable.setSelected(row, true);
                this.updateAriaStatus(false);
            }
        }
    }

    protected void updateAriaStatus(boolean justOpened) {
        String text = "";
        if (justOpened) {
            text = ARIA.showingDegreePlans(this.iTable.getRowCount() - 1);
        }
        int row = this.iTable.getSelectedRow();
        DegreePlanInterface plan = this.iTable.getData(row);
        if (row >= 0 && plan != null) {
            text = text + (text.isEmpty() ? "" : " ") + ARIA.showingDegreePlan(row, this.iTable.getRowCount() - 1, plan.getName(), plan.getDegree());
            if (plan.getLastModified() != null && plan.getModifiedWho() != null) {
                text = text + ARIA.lastModified(plan.getLastModified(), plan.getModifiedWho());
            }
        }
        AriaStatus.getInstance().setText(text);
    }
}

