/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page.mobile;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.PageLabelDisplay;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class MobilePageLabelImpl
extends P
implements PageLabelDisplay {
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private P iName = new P("text");
    private Image iHelp = new Image(RESOURCES.help());
    private Image iClose = null;
    private String iUrl = null;

    public MobilePageLabelImpl() {
        super(new String[0]);
        this.iHelp.addStyleName("icon");
        this.iHelp.setVisible(false);
        this.add((Widget)this.iName);
        this.add((Widget)this.iHelp);
        this.iHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MobilePageLabelImpl.this.iUrl == null || MobilePageLabelImpl.this.iUrl.isEmpty()) {
                    return;
                }
                if (Window.getClientWidth() >= 600) {
                    UniTimeFrameDialog.openDialog(MESSAGES.pageHelp(MobilePageLabelImpl.this.getText()), MobilePageLabelImpl.this.iUrl);
                } else {
                    ToolBox.open(MobilePageLabelImpl.this.iUrl);
                }
            }
        });
        if (MobilePageLabelImpl.hasParentWindow()) {
            this.iClose = new Image(RESOURCES.close());
            this.iClose.addStyleName("icon");
            this.iClose.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MobilePageLabelImpl.tellParentToCloseThisWindo();
                }
            });
            this.add((Widget)this.iClose);
        }
    }

    @Override
    public String getText() {
        return this.iName.getText();
    }

    @Override
    public void setText(String text) {
        this.iName.setText(text);
        this.iHelp.setTitle(MESSAGES.pageHelp(text));
        if (this.iClose != null) {
            this.iClose.setTitle(MESSAGES.pageClose(text));
        }
    }

    public MenuInterface.PageNameInterface getValue() {
        return new MenuInterface.PageNameInterface(this.getText(), this.iUrl);
    }

    public void setValue(MenuInterface.PageNameInterface value) {
        this.setValue(value, false);
    }

    public void setValue(MenuInterface.PageNameInterface value, boolean fireEvents) {
        this.iUrl = value.getHelpUrl();
        this.iHelp.setVisible(this.iUrl != null && !this.iUrl.isEmpty());
        this.setText(value.getName());
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<MenuInterface.PageNameInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public static native boolean hasParentWindow();

    public static native boolean tellParentToCloseThisWindo();
}

