/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.PersonInterface;

public class Lookup
extends UniTimeDialogBox
implements HasValue<PersonInterface> {
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private VerticalPanel iPanel;
    private UniTimeTable<PersonInterface> iTable;
    private ScrollPanel iScroll;
    private AriaTextBox iQuery;
    private String iOptions;
    private Timer iTimer;
    private String iLastQuery = null;
    private PersonInterface iValue = null;
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);

    public Lookup() {
        super(true, true);
        this.addStyleName("unitime-PeopleLookup");
        this.setText(MESSAGES.dialogPeopleLookup());
        this.setEscapeToHide(true);
        this.iPanel = new VerticalPanel();
        this.iPanel.setSpacing(2);
        this.iQuery = new AriaTextBox();
        this.iQuery.addStyleName("query");
        this.iQuery.setAriaLabel(ARIA.peopleLookupName());
        HorizontalPanel queryPanel = new HorizontalPanel();
        Label filterText = new Label(MESSAGES.propName(), false);
        filterText.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        queryPanel.setWidth("75px");
        queryPanel.add((Widget)filterText);
        queryPanel.setCellHorizontalAlignment((Widget)filterText, HasHorizontalAlignment.ALIGN_RIGHT);
        queryPanel.setCellVerticalAlignment((Widget)filterText, HasVerticalAlignment.ALIGN_MIDDLE);
        queryPanel.add((Widget)this.iQuery);
        HTML blank = new HTML("&nbsp;");
        blank.setWidth("75px");
        queryPanel.add((Widget)blank);
        this.iPanel.add((Widget)queryPanel);
        this.iPanel.setCellHorizontalAlignment((Widget)queryPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.iTable = new UniTimeTable();
        this.iScroll = new ScrollPanel(this.iTable);
        this.iScroll.setStyleName("unitime-ScrollPanel");
        this.iPanel.add((Widget)this.iScroll);
        this.setWidget((Widget)this.iPanel);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colNamePerson()));
        header.add(new UniTimeTableHeader(MESSAGES.colEmail()));
        header.add(new UniTimeTableHeader(MESSAGES.colPhone()));
        header.add(new UniTimeTableHeader(MESSAGES.colDepartment()));
        header.add(new UniTimeTableHeader(MESSAGES.colSource()));
        this.iTable.addRow(null, header);
        this.iTable.setAllowSelection(true);
        this.iTable.setWidth("100%");
        this.iTimer = new Timer(){

            public void run() {
                Lookup.this.update();
            }
        };
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<PersonInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<PersonInterface> event) {
                if (event.getData() != null) {
                    Lookup.this.iTimer.cancel();
                    Lookup.this.hide();
                    Lookup.this.setValue(event.getData(), true);
                }
            }
        });
        this.iQuery.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                Lookup.this.iTimer.schedule(500);
            }
        });
        this.sinkEvents(128);
    }

    private void scrollToSelectedRow() {
        int row = this.iTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        Element scroll = this.iScroll.getElement();
        Element item = this.iTable.getRowFormatter().getElement(this.iTable.getSelectedRow());
        if (item == null) {
            return;
        }
        int realOffset = 0;
        while (item != null && !item.equals((Object)scroll)) {
            realOffset += item.getOffsetTop();
            item = item.getOffsetParent();
        }
        scroll.setScrollTop(realOffset - scroll.getOffsetHeight() / 2);
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 128: {
                PersonInterface person;
                int row;
                if (event.getKeyCode() == 40 && this.iTable.getRowCount() > 1 && this.iTable.getData(1) != null) {
                    row = this.iTable.getSelectedRow();
                    if (row >= 0) {
                        this.iTable.setSelected(row, false);
                    }
                    row = row < 0 ? 1 : ++row;
                    if (row >= this.iTable.getRowCount()) {
                        row = 1;
                    }
                    this.iTable.setSelected(row, true);
                    this.setAriaStatus();
                    this.scrollToSelectedRow();
                    event.preventDefault();
                    event.stopPropagation();
                }
                if (event.getKeyCode() == 38 && this.iTable.getRowCount() > 1 && this.iTable.getData(1) != null) {
                    row = this.iTable.getSelectedRow();
                    if (row >= 0) {
                        this.iTable.setSelected(row, false);
                    }
                    row = row < 0 ? this.iTable.getRowCount() - 1 : --row;
                    if (row <= 0) {
                        row = this.iTable.getRowCount() - 1;
                    }
                    this.iTable.setSelected(row, true);
                    this.setAriaStatus();
                    this.scrollToSelectedRow();
                    event.preventDefault();
                    event.stopPropagation();
                }
                if (event.getKeyCode() != 13 || (row = this.iTable.getSelectedRow()) < 0 || (person = this.iTable.getData(row)) == null) break;
                this.iTimer.cancel();
                this.hide();
                this.setValue(person, true);
                AriaStatus.getInstance().setText(ARIA.suggestionSelected(this.toAriaString(person)));
            }
        }
    }

    protected String toAriaString(PersonInterface person) {
        String aria = person.getName();
        if (person.getEmail() != null && !person.getEmail().isEmpty()) {
            aria = aria + ", " + MESSAGES.colEmail() + " " + person.getEmail();
        }
        if (person.getPhone() != null && !person.getPhone().isEmpty()) {
            aria = aria + ", " + MESSAGES.colPhone() + " " + person.getPhone();
        }
        if (person.getDepartment() != null && !person.getDepartment().isEmpty()) {
            aria = aria + ", " + MESSAGES.colDepartment() + " " + person.getDepartment();
        }
        if (person.getSource() != null && !person.getSource().isEmpty()) {
            aria = aria + ", " + MESSAGES.colSource() + " " + person.getSource();
        }
        return aria;
    }

    protected void setAriaStatus() {
        PersonInterface person;
        int row = this.iTable.getSelectedRow();
        if (row >= 1 && (person = this.iTable.getData(row)) != null) {
            AriaStatus.getInstance().setText(ARIA.onSuggestion(row, this.iTable.getRowCount() - 1, this.toAriaString(person)));
        }
    }

    public void setQuery(String query) {
        this.iQuery.setText(query);
    }

    public void setOptions(String options) {
        this.iOptions = options;
    }

    public void update() {
        final String q = this.iQuery.getText().trim();
        if (q.equals(this.iLastQuery)) {
            return;
        }
        if (q.isEmpty()) {
            this.iTable.clearTable(1);
            return;
        }
        this.iTable.clearTable(1);
        ArrayList<LoadingImage> line = new ArrayList<LoadingImage>();
        line.add(new LoadingImage());
        this.iTable.addRow(null, line);
        RPC.execute(new PersonInterface.LookupRequest(q, this.iOptions), new AsyncCallback<GwtRpcResponseList<PersonInterface>>(){

            public void onSuccess(GwtRpcResponseList<PersonInterface> result) {
                Lookup.this.iLastQuery = q;
                Lookup.this.iTable.clearTable(1);
                boolean hasId = true;
                for (PersonInterface person : result) {
                    int col;
                    ArrayList<Label> line = new ArrayList<Label>();
                    line.add(new Label(person.getName(), false));
                    line.add(new Label(person.getEmail(), false));
                    line.add(new Label(person.getPhone(), false));
                    line.add(new Label(person.getDepartment()));
                    line.add(new Label(person.getSource()));
                    Lookup.this.iTable.addRow(person, line);
                    if (person.getId() != null && !person.getId().isEmpty() && !"null".equals(person.getId())) continue;
                    int row = Lookup.this.iTable.getRowCount() - 1;
                    for (col = 0; col < Lookup.this.iTable.getCellCount(row); ++col) {
                        Lookup.this.iTable.getCellFormatter().addStyleName(row, col, "unitime-Disabled");
                    }
                    if (!hasId) continue;
                    hasId = false;
                    if (row <= 1) continue;
                    for (col = 0; col < Lookup.this.iTable.getCellCount(row); ++col) {
                        Lookup.this.iTable.getCellFormatter().addStyleName(row, col, "unitime-TopLineDash");
                    }
                }
                if (result.isEmpty()) {
                    ArrayList<ErrorLine> line = new ArrayList<ErrorLine>();
                    line.add(new ErrorLine(MESSAGES.errorNoPersonMatchingQuery(q), false));
                    Lookup.this.iTable.addRow(null, line);
                    AriaStatus.getInstance().setText(MESSAGES.errorNoPersonMatchingQuery(q));
                } else {
                    if (Lookup.this.iTable.getSelectedRow() < 1) {
                        Lookup.this.iTable.setSelected(1, true);
                    }
                    if (result.size() == 1) {
                        AriaStatus.getInstance().setText(ARIA.showingOneSuggestion(Lookup.this.toAriaString((PersonInterface)result.get(0))));
                    } else if (Lookup.this.iTable.getSelectedRow() == 1) {
                        AriaStatus.getInstance().setText(ARIA.showingMultipleSuggestions(result.size(), q, Lookup.this.toAriaString((PersonInterface)result.get(0))));
                    } else {
                        AriaStatus.getInstance().setText(ARIA.showingMultipleSuggestionsNoneSelected(result.size(), q));
                    }
                }
            }

            public void onFailure(Throwable caught) {
                Lookup.this.iTable.clearTable(1);
                ArrayList<ErrorLine> line = new ArrayList<ErrorLine>();
                line.add(new ErrorLine(MESSAGES.failedLookup(caught.getMessage()), true));
                Lookup.this.iTable.addRow(null, line);
                AriaStatus.getInstance().setText(MESSAGES.failedLookup(caught.getMessage()));
            }
        });
    }

    public static native void createTriggers();

    @Override
    public void center() {
        super.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Lookup.this.iLastQuery = null;
                Lookup.this.iQuery.setFocus(true);
                Lookup.this.iQuery.selectAll();
                Lookup.this.update();
            }
        });
    }

    public static void peopleLookup(String query, final JavaScriptObject callback, String options) {
        final Lookup lookup = new Lookup();
        if (query != null && !query.trim().isEmpty()) {
            lookup.setQuery(query);
        }
        lookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                if (event.getValue() != null) {
                    lookup.fireCallback(callback, ((PersonInterface)event.getValue()).getId(), ((PersonInterface)event.getValue()).getFirstName(), ((PersonInterface)event.getValue()).getMiddleName(), ((PersonInterface)event.getValue()).getLastName(), ((PersonInterface)event.getValue()).getEmail(), ((PersonInterface)event.getValue()).getPhone(), ((PersonInterface)event.getValue()).getAcademicTitle(), ((PersonInterface)event.getValue()).getName());
                }
            }
        });
        lookup.setOptions(options);
        lookup.center();
    }

    public native void fireCallback(JavaScriptObject var1, String ... var2);

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<PersonInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public PersonInterface getValue() {
        return this.iValue;
    }

    public void setValue(PersonInterface value) {
        this.setValue(value, false);
    }

    public void setValue(PersonInterface value, boolean fireEvents) {
        this.iValue = value;
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public static class LoadingImage
    extends Image
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasCellAlignment {
        public LoadingImage() {
            super(RESOURCES.loading_small());
        }

        @Override
        public int getColSpan() {
            return 5;
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    public static class ErrorLine
    extends Label
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasStyleName {
        private boolean iError;

        public ErrorLine(String text, boolean error) {
            super(text);
            this.iError = error;
        }

        @Override
        public int getColSpan() {
            return 5;
        }

        @Override
        public String getStyleName() {
            return this.iError ? "unitime-ErrorMessage" : "unitime-Message";
        }
    }
}

