/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;
import org.unitime.timetable.model.ContactCategory;
import org.unitime.timetable.model.dao.ContactCategoryDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.IdValue;

public class InquiryForm
extends ActionForm {
    private static final long serialVersionUID = -2461671741219768003L;
    private String iOp;
    private String iSubject;
    private String iMessage;
    private long iType;
    private List carbonCopy;
    private String puid = null;
    private boolean iNoRole;
    private transient FormFile iFile;
    protected DynamicListObjectFactory factoryEmails = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String(Constants.BLANK_OPTION_VALUE);
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iType < 0L) {
            errors.add("type", new ActionMessage("errors.generic", (Object)"Please specify category of this inquiry:"));
        }
        if (this.iMessage.trim().length() == 0) {
            errors.add("message", new ActionMessage("errors.generic", (Object)"Message is required."));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iSubject = null;
        this.iMessage = null;
        this.iType = -1L;
        this.puid = null;
        this.carbonCopy = DynamicList.getInstance(new ArrayList(), this.factoryEmails);
        this.iFile = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public long getType() {
        return this.iType;
    }

    public void setType(long type) {
        this.iType = type;
    }

    public String getTypeMsg(long type) {
        ContactCategory cc = (ContactCategory)ContactCategoryDAO.getInstance().get(type);
        return cc.getLabel();
    }

    public Vector getTypeOptions() {
        Vector<IdValue> ret = new Vector<IdValue>();
        for (ContactCategory cc : ContactCategoryDAO.getInstance().getSession().createQuery("from ContactCategory order by reference").setCacheable(true).list()) {
            if (cc.getHasRole().booleanValue() && this.iNoRole) continue;
            ret.add(new IdValue(cc.getUniqueId(), cc.getLabel()));
        }
        return ret;
    }

    public void updateMessage() {
        if (this.iMessage != null && !this.iMessage.isEmpty()) {
            String message = null;
            boolean eq = false;
            for (ContactCategory cc : ContactCategoryDAO.getInstance().getSession().createQuery("from ContactCategory order by reference").setCacheable(true).list()) {
                if (cc.getMessage() != null && cc.getMessage().replaceAll("\\s+", "").equals(this.iMessage.replaceAll("\\s+", ""))) {
                    eq = true;
                }
                if (!cc.getUniqueId().equals(this.iType)) continue;
                message = cc.getMessage();
            }
            if (!eq) {
                return;
            }
            this.iMessage = message;
        } else {
            ContactCategory cc = (ContactCategory)ContactCategoryDAO.getInstance().get(this.iType);
            this.iMessage = cc == null ? null : cc.getMessage();
        }
    }

    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid != null && puid.trim().length() == 0 ? null : puid;
    }

    public boolean getNoRole() {
        return this.iNoRole;
    }

    public void setNoRole(boolean noRole) {
        this.iNoRole = noRole;
    }

    public List getCarbonCopy() {
        return this.carbonCopy;
    }

    public void setCarbonCopy(List carbonCopy) {
        this.carbonCopy = carbonCopy;
    }

    public String getCarbonCopy(int key) {
        return this.carbonCopy.get(key).toString();
    }

    public void setCarbonCopy(int key, Object value) {
        this.carbonCopy.set(key, value);
    }

    public void addToCarbonCopy(String carbonCopy) {
        this.carbonCopy.add(carbonCopy);
    }

    public void removeCarbonCopy(int rowNum) {
        if (rowNum >= 0) {
            this.carbonCopy.remove(rowNum);
        }
    }

    public FormFile getFile() {
        return this.iFile;
    }

    public void setFile(FormFile file) {
        this.iFile = file;
    }
}

