/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Date;
import java.util.HashSet;
import org.apache.commons.fileupload.FileItem;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventDetailBackend;
import org.unitime.timetable.events.EventEmail;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=EventInterface.ApproveEventRpcRequest.class)
public class ApproveEventBackend
extends EventAction<EventInterface.ApproveEventRpcRequest, EventInterface.SaveOrApproveEventRpcResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public EventInterface.SaveOrApproveEventRpcResponse execute(EventInterface.ApproveEventRpcRequest request, EventAction.EventContext context) {
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            FileItem attachment;
            Event event;
            Session session = (Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession);
            EventInterface.SaveOrApproveEventRpcResponse response = new EventInterface.SaveOrApproveEventRpcResponse();
            Event event2 = event = request.getEvent() == null || request.getEvent().getId() == null ? null : (Event)EventDAO.getInstance().get(request.getEvent().getId(), hibSession);
            if (event == null) {
                throw new GwtRpcException(MESSAGES.failedApproveEventNoEvent());
            }
            if (!request.hasMeetings()) {
                throw new GwtRpcException(MESSAGES.failedApproveEventNoMeetings());
            }
            Date now = new Date();
            int firstDayOfWeek = ApplicationProperty.EventGridStartDay.intValue();
            HashSet<Meeting> affectedMeetings = new HashSet<Meeting>();
            block16: for (Meeting meeting : event.getMeetings()) {
                for (EventInterface.MeetingInterface m : request.getMeetings()) {
                    if (!meeting.getUniqueId().equals(m.getId())) continue;
                    response.addUpdatedMeeting(m);
                    affectedMeetings.add(meeting);
                    switch (request.getOperation()) {
                        case REJECT: {
                            if (!context.hasPermission(meeting, Right.EventMeetingApprove)) {
                                throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToReject(ApproveEventBackend.toString(meeting)));
                            }
                            meeting.setStatus(Meeting.Status.REJECTED);
                            meeting.setApprovalDate(now);
                            m.setApprovalDate(now);
                            m.setApprovalStatus(meeting.getApprovalStatus());
                            hibSession.saveOrUpdate((Object)meeting);
                            break;
                        }
                        case APPROVE: {
                            if (!context.hasPermission(meeting, Right.EventMeetingApprove)) {
                                throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToApprove(ApproveEventBackend.toString(meeting)));
                            }
                            meeting.setStatus(Meeting.Status.APPROVED);
                            meeting.setApprovalDate(now);
                            m.setApprovalDate(now);
                            m.setApprovalStatus(meeting.getApprovalStatus());
                            hibSession.saveOrUpdate((Object)meeting);
                            break;
                        }
                        case CANCEL: {
                            switch (meeting.getEvent().getEventType()) {
                                case 1: 
                                case 2: {
                                    if (context.hasPermission(meeting, Right.EventMeetingCancelExam)) break;
                                    throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(ApproveEventBackend.toString(meeting)));
                                }
                                case 0: {
                                    if (context.hasPermission(meeting, Right.EventMeetingCancelClass)) break;
                                    throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(ApproveEventBackend.toString(meeting)));
                                }
                                default: {
                                    if (context.hasPermission(meeting, Right.EventMeetingCancel)) break;
                                    throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(ApproveEventBackend.toString(meeting)));
                                }
                            }
                            meeting.setStatus(Meeting.Status.CANCELLED);
                            meeting.setApprovalDate(now);
                            m.setApprovalDate(now);
                            m.setApprovalStatus(meeting.getApprovalStatus());
                            hibSession.saveOrUpdate((Object)meeting);
                        }
                    }
                    continue block16;
                }
            }
            EventNote note = new EventNote();
            note.setEvent(event);
            switch (request.getOperation()) {
                case APPROVE: {
                    note.setNoteType(2);
                    break;
                }
                case REJECT: {
                    note.setNoteType(3);
                    break;
                }
                case CANCEL: {
                    note.setNoteType(7);
                    break;
                }
                default: {
                    note.setNoteType(6);
                }
            }
            note.setTimeStamp(now);
            note.setUser(context.getUser().getTrueName());
            note.setUserId(context.getUser().getTrueExternalUserId());
            note.setAffectedMeetings(affectedMeetings);
            note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getUpdatedMeetings(), CONSTANTS, "\n", new EventInterface.DateFormatter(){
                Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);

                @Override
                public String formatFirstDate(Date date) {
                    return this.dfShort.format(date);
                }

                @Override
                public String formatLastDate(Date date) {
                    return this.dfLong.format(date);
                }
            }));
            if (request.hasMessage()) {
                note.setTextNote(request.getMessage());
            }
            if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                note.setTextNote(note.getTextNote().substring(0, 2000));
            }
            if ((attachment = (FileItem)context.getAttribute(SessionAttribute.LastUploadedFile)) != null) {
                note.setAttachedName(attachment.getName());
                note.setAttachedFile(attachment.get());
                note.setAttachedContentType(attachment.getContentType());
            }
            event.getNotes().add(note);
            hibSession.saveOrUpdate((Object)note);
            EventInterface.NoteInterface n = new EventInterface.NoteInterface();
            n.setId(note.getUniqueId());
            n.setDate(now);
            n.setMeetings(note.getMeetings());
            n.setUser(context.getUser().getTrueName());
            n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
            n.setNote(request.getMessage());
            n.setAttachment(attachment == null ? null : attachment.getName());
            n.setLink(attachment == null ? null : QueryEncoderBackend.encode("event=" + event.getUniqueId() + "&note=" + note.getUserId()));
            response.addNote(n);
            if (event.getMeetings().isEmpty()) {
                response.setEvent(EventDetailBackend.getEventDetail((Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession), event, context));
                response.getEvent().setId(null);
                hibSession.delete((Object)event);
            } else {
                hibSession.update((Object)event);
                response.setEvent(EventDetailBackend.getEventDetail(session, event, context));
            }
            tx.commit();
            tx = null;
            new EventEmail(request, response).send(context);
            return response;
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.rollback();
            }
            if (ex instanceof GwtRpcException) {
                throw (GwtRpcException)ex;
            }
            throw new GwtRpcException(ex.getMessage(), ex);
        }
    }
}

