/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dom4j.Element;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseSolverGroup;
import org.unitime.timetable.model.base.BaseTimePattern;
import org.unitime.timetable.model.base.BaseTimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class AcademicSessionSetupImport
extends BaseImport {
    protected static Formats.Format<Number> sFloatFormat = Formats.getNumberFormat("0.000");

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("sessionSetup")) {
            throw new Exception("Given XML file is not academic session setup file.");
        }
        try {
            Element studentAccomodationsEl;
            Element studentGroupsEl;
            Element posMinorsEl;
            Element posMajorsEl;
            Element academicClassificationsEl;
            Element academicAreasEl;
            Element examinationPeriodsEl;
            Element timePatternsEl;
            Element datePatternsEl;
            Element solverGroupsEl;
            Element managersEl;
            Element subjectAreasEl;
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Formats.Format<Date> dateFormat = Formats.getDateFormat(root.attributeValue("dateFormat", "yyyy/M/d"));
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            session = this.createOrUpdateSession(session, root, dateFormat);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Element departmentsEl = root.element("departments");
            if (departmentsEl != null) {
                this.importDepartments(departmentsEl, session);
            }
            if ((subjectAreasEl = root.element("subjectAreas")) != null) {
                this.importSubjectAreas(subjectAreasEl, session);
            }
            if ((managersEl = root.element("managers")) != null) {
                this.importManagers(managersEl, session);
            }
            if ((solverGroupsEl = root.element("solverGroups")) != null) {
                this.importSolverGroups(solverGroupsEl, session);
            }
            if ((datePatternsEl = root.element("datePatterns")) != null) {
                this.importDatePatterns(datePatternsEl, session, dateFormat);
            }
            if ((timePatternsEl = root.element("timePatterns")) != null) {
                this.importTimePatterns(timePatternsEl, session);
            }
            if ((examinationPeriodsEl = root.element("examinationPeriods")) != null) {
                Iterator i = examinationPeriodsEl.elementIterator("periods");
                while (i.hasNext()) {
                    Element periodsEl = (Element)i.next();
                    this.importExaminationPeriods(periodsEl, session, dateFormat);
                }
            }
            if ((academicAreasEl = root.element("academicAreas")) != null) {
                this.importAcademicAreas(academicAreasEl, session);
            }
            if ((academicClassificationsEl = root.element("academicClassifications")) != null) {
                this.importAcademicClassifications(academicClassificationsEl, session);
            }
            if ((posMajorsEl = root.element("posMajors")) != null) {
                this.importMajors(posMajorsEl, session);
            }
            if ((posMinorsEl = root.element("posMinors")) != null) {
                this.importMinors(posMinorsEl, session);
            }
            if ((studentGroupsEl = root.element("studentGroups")) != null) {
                this.importStudentGroups(studentGroupsEl, session);
            }
            if ((studentAccomodationsEl = root.element("studentAccomodations")) != null) {
                this.importStudentAccomodations(studentAccomodationsEl, session);
            }
            this.commitTransaction();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    public Session createOrUpdateSession(Session session, Element root, Formats.Format<Date> dateFormat) throws ParseException {
        Element holidayEl;
        this.info("Importing academic session...");
        Element sessionEl = root.element("session");
        if (sessionEl == null) {
            return session;
        }
        if (session == null) {
            session = new Session();
            session.setAcademicInitiative(root.attributeValue("campus"));
            session.setAcademicTerm(root.attributeValue("term"));
            session.setAcademicYear(root.attributeValue("year"));
            session.setStatusType(DepartmentStatusType.findByRef("initial"));
            session.setBuildings(new HashSet<Building>());
            session.setDepartments(new HashSet<Department>());
            session.setDistributionObjects(new HashSet<DistributionObject>());
            session.setInstructionalOfferings(new HashSet<InstructionalOffering>());
            session.setPreferences(new HashSet<Preference>());
            session.setRooms(new HashSet<Location>());
            session.setSubjectAreas(new HashSet<SubjectArea>());
            session.setLastWeekToEnroll(1);
            session.setLastWeekToChange(1);
            session.setLastWeekToDrop(4);
        }
        session.setSessionBeginDateTime(dateFormat.parse(sessionEl.attributeValue("startDate")));
        session.setSessionEndDateTime(dateFormat.parse(sessionEl.attributeValue("endDate")));
        session.setClassesEndDateTime(dateFormat.parse(sessionEl.attributeValue("classEndDate")));
        session.setExamBeginDate(dateFormat.parse(sessionEl.attributeValue("examStartDate")));
        session.setEventBeginDate(dateFormat.parse(sessionEl.attributeValue("eventStartDate", sessionEl.attributeValue("startDate"))));
        session.setEventEndDate(dateFormat.parse(sessionEl.attributeValue("eventEndDate", sessionEl.attributeValue("endDate"))));
        Element deadlinesEl = sessionEl.element("deadlines");
        if (deadlinesEl != null) {
            session.setLastWeekToEnroll(Integer.valueOf(deadlinesEl.attributeValue("lastWeekToEnroll", "1")));
            session.setLastWeekToChange(Integer.valueOf(deadlinesEl.attributeValue("lastWeekToChange", "1")));
            session.setLastWeekToDrop(Integer.valueOf(deadlinesEl.attributeValue("lastWeekToDrop", "4")));
        }
        if ((holidayEl = sessionEl.element("holidays")) != null) {
            StringBuffer holiday = new StringBuffer();
            int acadYear = session.getSessionStartYear();
            int startMonth = DateUtils.getStartMonth(session.getEventBeginDate() != null && session.getEventBeginDate().before(session.getSessionBeginDateTime()) ? session.getEventBeginDate() : session.getSessionBeginDateTime(), acadYear, ApplicationProperty.SessionNrExcessDays.intValue());
            int endMonth = DateUtils.getEndMonth(session.getEventEndDate() != null && session.getEventEndDate().after(session.getSessionEndDateTime()) ? session.getEventEndDate() : session.getSessionEndDateTime(), acadYear, ApplicationProperty.SessionNrExcessDays.intValue());
            HashMap<Date, Integer> date2index = new HashMap<Date, Integer>();
            int idx = 0;
            for (int m = startMonth; m <= endMonth; ++m) {
                int daysOfMonth = DateUtils.getNrDaysOfMonth(m, acadYear);
                for (int d = 1; d <= daysOfMonth; ++d) {
                    date2index.put(DateUtils.getDate(d, m, acadYear), idx);
                    holiday.append('0');
                    ++idx;
                }
            }
            Iterator i = holidayEl.elementIterator("holiday");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                Date d = dateFormat.parse(e.attributeValue("date"));
                Integer index = (Integer)date2index.get(d);
                if (index == null) continue;
                holiday.setCharAt(index, '1');
            }
            i = holidayEl.elementIterator("break");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                Date sd = dateFormat.parse(e.attributeValue("startDate", e.attributeValue("date")));
                Date ed = dateFormat.parse(e.attributeValue("endDate", e.attributeValue("date")));
                Integer i1 = (Integer)date2index.get(sd);
                Integer i2 = (Integer)date2index.get(ed);
                if (i1 == null || i2 == null) continue;
                for (int j = i1.intValue(); j <= i2; ++j) {
                    holiday.setCharAt(j, '2');
                }
            }
            session.setHolidays(holiday.toString());
        }
        this.getHibSession().saveOrUpdate((Object)session);
        this.flush(true);
        return session;
    }

    public void importDepartments(Element root, Session session) {
        this.info("Importing departments...");
        Hashtable<String, Department> id2dept = new Hashtable<String, Department>();
        Hashtable<String, Department> code2dept = new Hashtable<String, Department>();
        for (Department dept : this.getHibSession().createQuery("from Department where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (dept.getExternalUniqueId() != null) {
                id2dept.put(dept.getExternalUniqueId(), dept);
            }
            code2dept.put(dept.getDeptCode(), dept);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element distEl;
            Element instructorEl;
            Element requiredEl;
            Element studentsEl;
            Element eventsEl;
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String code = element.attributeValue("code");
            Department dept = null;
            if (externalId != null) {
                dept = (Department)id2dept.remove(externalId);
            }
            if (dept == null) {
                dept = (Department)code2dept.get(code);
            }
            if (dept == null) {
                dept = new Department();
                dept.setSession(session);
                dept.setExternalManager(false);
                dept.setAllowEvents(false);
                dept.setAllowStudentScheduling(true);
                dept.setAllowReqTime(false);
                dept.setAllowReqRoom(false);
                dept.setAllowReqDistribution(false);
                dept.setInheritInstructorPreferences(true);
                dept.setDistributionPrefPriority(0);
                dept.setSubjectAreas(new HashSet<SubjectArea>());
                this.debug("Department " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Department " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            dept.setExternalUniqueId(externalId);
            dept.setDeptCode(code);
            dept.setAbbreviation(element.attributeValue("abbreviation"));
            dept.setName(element.attributeValue("name"));
            Element externalEl = element.element("externalManager");
            if (externalEl != null) {
                dept.setExternalManager("true".equalsIgnoreCase(externalEl.attributeValue("enabled", "true")));
                dept.setExternalMgrAbbv(externalEl.attributeValue("abbreviation"));
                dept.setExternalMgrLabel(externalEl.attributeValue("label"));
                if (dept.getUniqueId() == null) {
                    dept.setInheritInstructorPreferences(dept.getExternalManager() == false);
                }
            }
            if ((eventsEl = element.element("eventManagement")) != null) {
                dept.setAllowEvents("true".equalsIgnoreCase(eventsEl.attributeValue("enabled", "true")));
            }
            if ((studentsEl = element.element("studentScheduling")) != null) {
                dept.setAllowStudentScheduling("true".equalsIgnoreCase(studentsEl.attributeValue("enabled", "true")));
            }
            if ((requiredEl = element.element("required")) != null) {
                dept.setAllowReqTime("true".equalsIgnoreCase(requiredEl.attributeValue("time", "true")));
                dept.setAllowReqTime("true".equalsIgnoreCase(requiredEl.attributeValue("room", "true")));
                dept.setAllowReqTime("true".equalsIgnoreCase(requiredEl.attributeValue("distribution", "true")));
            }
            if ((instructorEl = element.element("instructorPreferences")) != null) {
                dept.setInheritInstructorPreferences("true".equalsIgnoreCase(instructorEl.attributeValue("inherit", "true")));
            }
            if ((distEl = element.element("distributionPreferences")) != null) {
                dept.setDistributionPrefPriority(Integer.parseInt(distEl.attributeValue("priority", "0")));
            }
            this.getHibSession().saveOrUpdate((Object)dept);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (Department dept : id2dept.values()) {
                this.debug("Department " + dept.getDeptCode() + " (" + dept.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)dept);
            }
        }
        this.flush(true);
    }

    public void importSubjectAreas(Element root, Session session) {
        this.info("Importing subject ares...");
        Hashtable<String, SubjectArea> id2subject = new Hashtable<String, SubjectArea>();
        Hashtable<String, SubjectArea> abbv2subject = new Hashtable<String, SubjectArea>();
        for (SubjectArea subject : this.getHibSession().createQuery("from SubjectArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (subject.getExternalUniqueId() != null) {
                id2subject.put(subject.getExternalUniqueId(), subject);
            }
            abbv2subject.put(subject.getSubjectAreaAbbreviation(), subject);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String abbv = element.attributeValue("abbreviation");
            SubjectArea subject = null;
            if (externalId != null) {
                subject = (SubjectArea)id2subject.remove(externalId);
            }
            if (subject == null) {
                subject = (SubjectArea)abbv2subject.get(abbv);
            }
            if (subject == null) {
                subject = new SubjectArea();
                subject.setSession(session);
                this.debug("Subject area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Subject area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            subject.setExternalUniqueId(externalId);
            subject.setSubjectAreaAbbreviation(abbv);
            subject.setTitle(element.attributeValue("title"));
            subject.setDepartment(Department.findByDeptCode(element.attributeValue("department"), session.getUniqueId()));
            this.getHibSession().saveOrUpdate((Object)subject);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (SubjectArea subject : id2subject.values()) {
                this.debug("Subject area " + subject.getSubjectAreaAbbreviation() + " (" + subject.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)subject);
            }
        }
        this.flush(true);
    }

    /*
     * WARNING - void declaration
     */
    public void importManagers(Element root, Session session) {
        this.info("Importing managers...");
        Hashtable<String, TimetableManager> id2manager = new Hashtable<String, TimetableManager>();
        for (Object m : new TreeSet(this.getHibSession().createQuery("select distinct m from TimetableManager m inner join m.departments d where d.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list())) {
            id2manager.put(((BaseTimetableManager)m).getExternalUniqueId(), (TimetableManager)m);
        }
        Hashtable<String, TimetableManager> allManagers = new Hashtable<String, TimetableManager>();
        for (Object m : new TreeSet(this.getHibSession().createQuery("from TimetableManager m").list())) {
            allManagers.put(((BaseTimetableManager)m).getExternalUniqueId(), (TimetableManager)m);
        }
        Hashtable<String, Department> code2dept = new Hashtable<String, Department>();
        for (Object dept : this.getHibSession().createQuery("from Department where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            code2dept.put(((BaseDepartment)dept).getDeptCode(), (Department)dept);
        }
        Hashtable<String, Roles> ref2role = new Hashtable<String, Roles>();
        for (Roles role : Roles.findAll(true, this.getHibSession())) {
            ref2role.put(role.getReference(), role);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            TimetableManager manager = (TimetableManager)id2manager.get(externalId);
            if (manager == null) {
                manager = (TimetableManager)allManagers.get(externalId);
            }
            if (manager == null) {
                manager = new TimetableManager();
                manager.setSolverGroups(new HashSet<SolverGroup>());
                manager.setManagerRoles(new HashSet<ManagerRole>());
                manager.setDepartments(new HashSet<Department>());
                this.debug("Manager " + externalId + " created.");
            } else {
                this.debug("Manager " + externalId + " updated.");
            }
            manager.setExternalUniqueId(externalId);
            manager.setFirstName(element.attributeValue("firstName"));
            manager.setMiddleName(element.attributeValue("middleName"));
            manager.setLastName(element.attributeValue("lastName"));
            manager.setEmailAddress(element.attributeValue("email"));
            manager.setAcademicTitle(element.attributeValue("acadTitle"));
            HashSet<Department> departments = new HashSet<Department>(manager.getDepartments());
            Iterator mIt = element.elementIterator("department");
            while (mIt.hasNext()) {
                Element element2 = (Element)mIt.next();
                Department department2 = (Department)code2dept.get(element2.attributeValue("code"));
                if (department2 == null || departments.remove(department2)) continue;
                manager.getDepartments().add(department2);
                department2.getTimetableManagers().add(manager);
            }
            for (Department department : departments) {
                if (!session.equals(department.getSession())) continue;
                manager.getDepartments().remove(department);
                department.getTimetableManagers().remove(manager);
            }
            HashMap<String, ManagerRole> roles = new HashMap<String, ManagerRole>();
            for (ManagerRole mr : manager.getManagerRoles()) {
                roles.put(mr.getRole().getReference(), mr);
            }
            boolean bl = false;
            Iterator rIt = element.elementIterator("role");
            while (rIt.hasNext()) {
                void var13_13;
                Element rEl = (Element)rIt.next();
                ManagerRole role = (ManagerRole)roles.remove(rEl.attributeValue("reference"));
                if (role == null) {
                    role = new ManagerRole();
                    role.setRole((Roles)ref2role.get(rEl.attributeValue("reference")));
                    role.setTimetableManager(manager);
                    manager.getManagerRoles().add(role);
                }
                role.setPrimary("true".equalsIgnoreCase(rEl.attributeValue("primary", var13_13 == false ? "true" : "false")));
                role.setReceiveEmails("true".equalsIgnoreCase(rEl.attributeValue("email", "true")));
                ++var13_13;
            }
            for (ManagerRole mr : roles.values()) {
                this.getHibSession().delete((Object)mr);
                manager.getManagerRoles().remove(mr);
            }
            this.getHibSession().saveOrUpdate((Object)manager);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (TimetableManager manager : id2manager.values()) {
                this.debug("Manager " + manager.getExternalUniqueId() + " removed.");
                Iterator<Department> i = manager.getDepartments().iterator();
                while (i.hasNext()) {
                    Department d = i.next();
                    if (!session.equals(d.getSession())) continue;
                    i.remove();
                }
                if (manager.getDepartments().isEmpty()) {
                    this.getHibSession().delete((Object)manager);
                    continue;
                }
                this.getHibSession().update((Object)manager);
            }
        }
        this.flush(true);
    }

    public void importSolverGroups(Element root, Session session) {
        this.info("Importing solver groups...");
        Hashtable<String, SolverGroup> abbv2group = new Hashtable<String, SolverGroup>();
        for (Object g : this.getHibSession().createQuery("from SolverGroup where session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            abbv2group.put(((BaseSolverGroup)g).getAbbv(), (SolverGroup)g);
        }
        Hashtable<String, TimetableManager> id2manager = new Hashtable<String, TimetableManager>();
        for (Object m : new TreeSet(this.getHibSession().createQuery("from TimetableManager m").list())) {
            id2manager.put(((BaseTimetableManager)m).getExternalUniqueId(), (TimetableManager)m);
        }
        Hashtable<String, Department> code2dept = new Hashtable<String, Department>();
        for (Department dept : this.getHibSession().createQuery("from Department where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            code2dept.put(dept.getDeptCode(), dept);
        }
        HashSet<Department> updatedDepartments = new HashSet<Department>();
        HashSet<TimetableManager> updatedManagers = new HashSet<TimetableManager>();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String abbv = element.attributeValue("abbreviation");
            SolverGroup group = (SolverGroup)abbv2group.remove(abbv);
            if (group == null) {
                group = new SolverGroup();
                group.setDepartments(new HashSet<Department>());
                group.setSession(session);
                group.setSolutions(new HashSet<Solution>());
                group.setTimetableManagers(new HashSet<TimetableManager>());
                this.debug("Solver group " + abbv + " created.");
            } else {
                this.debug("Solver group " + abbv + " updated.");
            }
            group.setAbbv(abbv);
            group.setName(element.attributeValue("name"));
            HashSet<Department> departments = new HashSet<Department>(group.getDepartments());
            Iterator dIt = element.elementIterator("department");
            while (dIt.hasNext()) {
                Element dEl = (Element)dIt.next();
                Department department = (Department)code2dept.get(dEl.attributeValue("code"));
                if (department == null || departments.remove(department)) continue;
                if (department.getSolverGroup() != null) {
                    department.getSolverGroup().getDepartments().remove(department);
                }
                department.setSolverGroup(group);
                group.getDepartments().add(department);
                updatedDepartments.add(department);
            }
            for (Department department : departments) {
                group.getDepartments().remove(department);
                department.setSolverGroup(null);
                updatedDepartments.add(department);
            }
            HashSet<TimetableManager> managers = new HashSet<TimetableManager>(group.getTimetableManagers());
            Iterator mIt = element.elementIterator("manager");
            while (mIt.hasNext()) {
                Element mEl = (Element)mIt.next();
                TimetableManager manager = (TimetableManager)id2manager.get(mEl.attributeValue("externalId"));
                if (manager == null || managers.remove(manager)) continue;
                manager.getSolverGroups().add(group);
                group.getTimetableManagers().add(manager);
                updatedManagers.add(manager);
            }
            for (TimetableManager manager : managers) {
                group.getTimetableManagers().remove(manager);
                manager.getSolverGroups().remove(group);
                updatedManagers.add(manager);
            }
            this.getHibSession().saveOrUpdate((Object)group);
        }
        boolean incremental = "true".equalsIgnoreCase(root.attributeValue("incremental"));
        for (SolverGroup group : abbv2group.values()) {
            if (incremental && !group.getDepartments().isEmpty()) {
                this.getHibSession().update((Object)group);
                continue;
            }
            this.debug("Solver group " + group.getAbbv() + " removed.");
            Iterator<Comparable<Department>> i = group.getDepartments().iterator();
            while (i.hasNext()) {
                Department d = i.next();
                d.setSolverGroup(null);
                i.remove();
                updatedDepartments.add(d);
            }
            for (TimetableManager m : group.getTimetableManagers()) {
                m.getSolverGroups().remove(group);
                updatedManagers.add(m);
            }
            this.getHibSession().delete((Object)group);
        }
        for (Department d : updatedDepartments) {
            this.getHibSession().saveOrUpdate((Object)d);
        }
        for (TimetableManager m : updatedManagers) {
            this.getHibSession().saveOrUpdate((Object)m);
        }
        this.flush(true);
    }

    public void importAcademicAreas(Element root, Session session) {
        this.info("Importing academic areas...");
        Hashtable<String, AcademicArea> id2area = new Hashtable<String, AcademicArea>();
        Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
        for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (area.getExternalUniqueId() != null) {
                id2area.put(area.getExternalUniqueId(), area);
            }
            abbv2area.put(area.getAcademicAreaAbbreviation(), area);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String abbv = element.attributeValue("abbreviation");
            AcademicArea area = null;
            if (externalId != null) {
                area = (AcademicArea)id2area.remove(externalId);
            }
            if (area == null) {
                area = (AcademicArea)abbv2area.get(abbv);
            }
            if (area == null) {
                area = new AcademicArea();
                area.setSession(session);
                this.debug("Academic area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Academic area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            area.setExternalUniqueId(externalId);
            area.setAcademicAreaAbbreviation(abbv);
            area.setTitle(element.attributeValue("title", element.attributeValue("longTitle")));
            this.getHibSession().saveOrUpdate((Object)area);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (AcademicArea area : id2area.values()) {
                this.debug("Academic area " + area.getAcademicAreaAbbreviation() + " (" + area.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)area);
            }
        }
        this.flush(true);
    }

    public void importAcademicClassifications(Element root, Session session) {
        this.info("Importing academic classifications...");
        Hashtable<String, AcademicClassification> id2clasf = new Hashtable<String, AcademicClassification>();
        Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
        for (AcademicClassification clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (clasf.getExternalUniqueId() != null) {
                id2clasf.put(clasf.getExternalUniqueId(), clasf);
            }
            code2clasf.put(clasf.getCode(), clasf);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String code = element.attributeValue("code");
            AcademicClassification clasf = null;
            if (externalId != null) {
                clasf = (AcademicClassification)id2clasf.remove(externalId);
            }
            if (clasf == null) {
                clasf = (AcademicClassification)code2clasf.get(code);
            }
            if (clasf == null) {
                clasf = new AcademicClassification();
                clasf.setSession(session);
                this.debug("Academic classification " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Academic classification " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            clasf.setExternalUniqueId(externalId);
            clasf.setCode(code);
            clasf.setName(element.attributeValue("name"));
            this.getHibSession().saveOrUpdate((Object)clasf);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (AcademicClassification clasf : id2clasf.values()) {
                this.debug("Academic classification " + clasf.getCode() + " (" + clasf.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)clasf);
            }
        }
        this.flush(true);
    }

    public void importMajors(Element root, Session session) {
        this.info("Importing majors...");
        Hashtable<String, PosMajor> id2major = new Hashtable<String, PosMajor>();
        Hashtable<String, Object> code2major = new Hashtable<String, Object>();
        for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (((BasePosMajor)major).getExternalUniqueId() != null) {
                id2major.put(((BasePosMajor)major).getExternalUniqueId(), (PosMajor)major);
            }
            for (AcademicArea area : ((BasePosMajor)major).getAcademicAreas()) {
                code2major.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode(), major);
            }
        }
        Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
        for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            abbv2area.put(area.getAcademicAreaAbbreviation(), area);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String code = this.trim(element.attributeValue("code"), "code", 40);
            AcademicArea area = (AcademicArea)abbv2area.get(element.attributeValue("academicArea"));
            if (area == null) {
                this.warn("Unknown academic area " + element.attributeValue("academicArea"));
                continue;
            }
            PosMajor major = null;
            if (externalId != null) {
                major = (PosMajor)id2major.remove(externalId);
            }
            if (major == null) {
                major = (PosMajor)code2major.get(area.getAcademicAreaAbbreviation() + ":" + code);
            }
            if (major == null) {
                major = new PosMajor();
                major.setSession(session);
                major.setAcademicAreas(new HashSet<AcademicArea>());
                this.debug("Major " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Major " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            major.setExternalUniqueId(externalId);
            major.setCode(code);
            major.setName(this.trim(element.attributeValue("name"), "name", 100));
            major.getAcademicAreas().clear();
            major.getAcademicAreas().add(area);
            area.getPosMajors().add(major);
            this.getHibSession().saveOrUpdate((Object)major);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (PosMajor major : id2major.values()) {
                String abbv = null;
                for (AcademicArea area : major.getAcademicAreas()) {
                    area.getPosMajors().remove(major);
                    abbv = area.getAcademicAreaAbbreviation();
                }
                this.debug("Major " + abbv + " " + major.getCode() + " (" + major.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)major);
            }
        }
        this.flush(true);
    }

    public void importMinors(Element root, Session session) {
        this.info("Importing minors...");
        Hashtable<String, PosMinor> id2minor = new Hashtable<String, PosMinor>();
        Hashtable<String, Object> code2minor = new Hashtable<String, Object>();
        for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (((BasePosMinor)minor).getExternalUniqueId() != null) {
                id2minor.put(((BasePosMinor)minor).getExternalUniqueId(), (PosMinor)minor);
            }
            for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), minor);
            }
        }
        Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
        for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            abbv2area.put(area.getAcademicAreaAbbreviation(), area);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String code = element.attributeValue("code");
            AcademicArea area = (AcademicArea)abbv2area.get(element.attributeValue("academicArea"));
            if (area == null) {
                this.warn("Unknown academic area " + element.attributeValue("academicArea"));
                continue;
            }
            PosMinor minor = null;
            if (externalId != null) {
                minor = (PosMinor)id2minor.remove(externalId);
            }
            if (minor == null) {
                minor = (PosMinor)code2minor.get(area.getAcademicAreaAbbreviation() + ":" + code);
            }
            if (minor == null) {
                minor = new PosMinor();
                minor.setSession(session);
                minor.setAcademicAreas(new HashSet<AcademicArea>());
                this.debug("Minor " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Minor " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            minor.setExternalUniqueId(externalId);
            minor.setCode(code);
            minor.setName(element.attributeValue("name"));
            minor.getAcademicAreas().clear();
            minor.getAcademicAreas().add(area);
            area.getPosMinors().add(minor);
            this.getHibSession().saveOrUpdate((Object)minor);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (PosMinor minor : id2minor.values()) {
                String abbv = null;
                for (AcademicArea area : minor.getAcademicAreas()) {
                    area.getPosMinors().remove(minor);
                    abbv = area.getAcademicAreaAbbreviation();
                }
                this.debug("Minor " + abbv + " " + minor.getCode() + " (" + minor.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)minor);
            }
        }
        this.flush(true);
    }

    public void importStudentGroups(Element root, Session session) {
        this.info("Importing student groups...");
        Hashtable<String, StudentGroup> id2group = new Hashtable<String, StudentGroup>();
        Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
        for (StudentGroup group : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (group.getExternalUniqueId() != null) {
                id2group.put(group.getExternalUniqueId(), group);
            }
            code2group.put(group.getGroupAbbreviation(), group);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String code = element.attributeValue("code");
            String name = element.attributeValue("name");
            String size = element.attributeValue("size");
            String type = element.attributeValue("type");
            StudentGroup group = null;
            if (externalId != null) {
                group = (StudentGroup)id2group.remove(externalId);
            }
            if (group == null) {
                group = (StudentGroup)code2group.get(code);
            }
            if (group == null) {
                group = new StudentGroup();
                group.setSession(session);
                this.debug("Group " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Group " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            group.setExternalUniqueId(externalId);
            group.setGroupAbbreviation(code);
            group.setGroupName(name);
            try {
                group.setExpectedSize(size == null || size.isEmpty() ? null : Integer.valueOf(size));
            }
            catch (NumberFormatException e) {
                group.setExpectedSize(null);
            }
            group.setType(type == null ? null : StudentGroupType.findByReference(type, this.getHibSession()));
            this.getHibSession().saveOrUpdate((Object)group);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (StudentGroup group : id2group.values()) {
                this.debug("Group " + group.getGroupAbbreviation() + " (" + group.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)group);
            }
        }
        this.flush(true);
    }

    public void importStudentAccomodations(Element root, Session session) {
        this.info("Importing student accomodations...");
        Hashtable<String, StudentAccomodation> id2accomodation = new Hashtable<String, StudentAccomodation>();
        Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
        for (StudentAccomodation accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            if (accomodation.getExternalUniqueId() != null) {
                id2accomodation.put(accomodation.getExternalUniqueId(), accomodation);
            }
            code2accomodation.put(accomodation.getAbbreviation(), accomodation);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String externalId = element.attributeValue("externalId");
            String abbv = element.attributeValue("code");
            String name = element.attributeValue("name");
            StudentAccomodation accomodation = null;
            if (externalId != null) {
                accomodation = (StudentAccomodation)id2accomodation.remove(externalId);
            }
            if (accomodation == null) {
                accomodation = (StudentAccomodation)code2accomodation.get(abbv);
            }
            if (accomodation == null) {
                accomodation = new StudentAccomodation();
                accomodation.setSession(session);
                this.debug("Accomodation " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " created.");
            } else {
                this.debug("Accomodation " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
            }
            accomodation.setExternalUniqueId(externalId);
            accomodation.setAbbreviation(abbv);
            accomodation.setName(name);
            this.getHibSession().saveOrUpdate((Object)accomodation);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (StudentAccomodation accomodation : id2accomodation.values()) {
                this.debug("Accomodation " + accomodation.getAbbreviation() + " (" + accomodation.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)accomodation);
            }
        }
        this.flush(true);
    }

    public void importTimePatterns(Element root, Session session) {
        this.info("Importing time patterns...");
        Hashtable<String, TimePattern> name2pattern = new Hashtable<String, TimePattern>();
        for (Object p : this.getHibSession().createQuery("from TimePattern where session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            name2pattern.put(((BaseTimePattern)p).getName(), (TimePattern)p);
        }
        Hashtable<String, Department> code2dept = new Hashtable<String, Department>();
        for (Department dept : this.getHibSession().createQuery("from Department where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            code2dept.put(dept.getDeptCode(), dept);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Object time2;
            Element element = (Element)it.next();
            String name = element.attributeValue("name");
            TimePattern pattern = (TimePattern)name2pattern.remove(name);
            if (pattern == null) {
                pattern = new TimePattern();
                pattern.setTimes(new HashSet<TimePatternTime>());
                pattern.setDays(new HashSet<TimePatternDays>());
                pattern.setDepartments(new HashSet<Department>());
                pattern.setSession(session);
                this.debug("Time pattern " + name + " created.");
            } else {
                this.debug("Time pattern " + name + " updated.");
            }
            pattern.setName(name);
            pattern.setNrMeetings(Integer.parseInt(element.attributeValue("nbrMeetings", "1")));
            pattern.setMinPerMtg(Integer.parseInt(element.attributeValue("minsPerMeeting", "50")));
            pattern.setVisible("true".equalsIgnoreCase(element.attributeValue("visible", "true")));
            pattern.setSlotsPerMtg(Integer.parseInt(element.attributeValue("nbrSlotsPerMeeting", "12")));
            pattern.setBreakTime(Integer.parseInt(element.attributeValue("breakTime", "0")));
            String type = element.attributeValue("type", TimePattern.sTypes[0]);
            for (int tId = 0; tId < TimePattern.sTypes.length; ++tId) {
                if (!TimePattern.sTypes[tId].equalsIgnoreCase(type)) continue;
                pattern.setType(tId);
            }
            HashSet<Department> departments = new HashSet<Department>(pattern.getDepartments());
            Iterator dIt = element.elementIterator("department");
            while (dIt.hasNext()) {
                Element element2 = (Element)dIt.next();
                Department department2 = (Department)code2dept.get(element2.attributeValue("code"));
                if (department2 == null || departments.remove(department2)) continue;
                pattern.getDepartments().add(department2);
            }
            for (Department department : departments) {
                pattern.getDepartments().remove(department);
            }
            HashMap<Integer, TimePatternTime> times = new HashMap<Integer, TimePatternTime>();
            for (TimePatternTime time3 : pattern.getTimes()) {
                times.put(time3.getStartSlot(), time3);
            }
            Iterator iterator = element.elementIterator("time");
            while (iterator.hasNext()) {
                Element tEl = (Element)iterator.next();
                int slot = this.time2slot(Integer.parseInt(tEl.attributeValue("start")));
                if (times.remove(slot) != null) continue;
                TimePatternTime time2 = new TimePatternTime();
                time2.setStartSlot(slot);
                pattern.getTimes().add(time2);
            }
            for (Object time2 : times.values()) {
                pattern.getTimes().remove(time2);
            }
            HashMap<Integer, TimePatternDays> hashMap = new HashMap<Integer, TimePatternDays>();
            time2 = pattern.getDays().iterator();
            while (time2.hasNext()) {
                TimePatternDays d = (TimePatternDays)time2.next();
                hashMap.put(d.getDayCode(), d);
            }
            Iterator tIt2 = element.elementIterator("days");
            while (tIt2.hasNext()) {
                Element tEl = (Element)tIt2.next();
                int code = this.days2code(tEl.attributeValue("code"));
                if (hashMap.remove(code) != null) continue;
                TimePatternDays d = new TimePatternDays();
                d.setDayCode(code);
                pattern.getDays().add(d);
            }
            for (TimePatternDays d : hashMap.values()) {
                pattern.getDays().remove(d);
            }
            this.getHibSession().saveOrUpdate((Object)pattern);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (TimePattern tp : name2pattern.values()) {
                this.debug("Time pattern " + tp.getName() + " removed.");
                this.getHibSession().delete((Object)tp);
            }
        }
        this.flush(true);
    }

    public void importDatePatterns(Element root, Session session, Formats.Format<Date> dateFormat) throws ParseException {
        this.info("Importing date patterns...");
        Hashtable<String, DatePattern> name2pattern = new Hashtable<String, DatePattern>();
        for (Object p : this.getHibSession().createQuery("from DatePattern where session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            name2pattern.put(((BaseDatePattern)p).getName(), (DatePattern)p);
        }
        Hashtable<String, Department> code2dept = new Hashtable<String, Department>();
        for (Department dept : this.getHibSession().createQuery("from Department where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            code2dept.put(dept.getDeptCode(), dept);
        }
        Hashtable<String, DatePattern> updatedPatterns = new Hashtable<String, DatePattern>();
        HashMap<String, ArrayList<String>> parents = new HashMap<String, ArrayList<String>>();
        DatePattern defaultDatePattern = null;
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element dEl;
            String nbrWeeks;
            Element element = (Element)it.next();
            String name = element.attributeValue("name");
            DatePattern pattern = (DatePattern)name2pattern.remove(name);
            if (pattern == null) {
                pattern = new DatePattern();
                pattern.setDepartments(new HashSet<Department>());
                pattern.setParents(new HashSet<DatePattern>());
                pattern.setSession(session);
                pattern.setType(0);
                pattern.setOffset(0);
                pattern.setPattern("0");
                this.debug("Date pattern " + name + " created.");
            } else {
                this.debug("Date pattern " + name + " updated.");
            }
            pattern.setName(name);
            pattern.setVisible("true".equalsIgnoreCase(element.attributeValue("visible", "true")));
            String type = element.attributeValue("type", DatePattern.sTypes[0]);
            for (int tId = 0; tId < DatePattern.sTypes.length; ++tId) {
                if (!DatePattern.sTypes[tId].equalsIgnoreCase(type)) continue;
                pattern.setType(tId);
            }
            if ("true".equalsIgnoreCase(element.attributeValue("default", "false"))) {
                defaultDatePattern = pattern;
            }
            pattern.setNumberOfWeeks((nbrWeeks = element.attributeValue("nbrWeeks")) == null || nbrWeeks.isEmpty() ? null : Float.valueOf(sFloatFormat.parse(nbrWeeks).floatValue()));
            HashSet<Department> departments = new HashSet<Department>(pattern.getDepartments());
            Iterator dIt = element.elementIterator("department");
            while (dIt.hasNext()) {
                dEl = (Element)dIt.next();
                Department department = (Department)code2dept.get(dEl.attributeValue("code"));
                if (department == null || departments.remove(department)) continue;
                pattern.getDepartments().add(department);
            }
            for (Department department : departments) {
                pattern.getDepartments().remove(department);
            }
            if (pattern.getType() == 4) {
                dIt = element.elementIterator("datePattern");
                while (dIt.hasNext()) {
                    dEl = (Element)dIt.next();
                    String child = dEl.attributeValue("name");
                    ArrayList<String> p = (ArrayList<String>)parents.get(child);
                    if (p == null) {
                        p = new ArrayList<String>();
                        parents.put(child, p);
                    }
                    p.add(name);
                }
            }
            BitSet weekCode = new BitSet();
            int startMonth = session.getPatternStartMonth();
            int endMonth = session.getPatternEndMonth();
            int year = session.getSessionStartYear();
            HashMap<Date, Integer> date2index = new HashMap<Date, Integer>();
            int idx = 0;
            for (int m = startMonth; m <= endMonth; ++m) {
                int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
                for (int d = 1; d <= daysOfMonth; ++d) {
                    date2index.put(DateUtils.getDate(d, m, year), idx);
                    ++idx;
                }
            }
            Iterator dIt2 = element.elementIterator("dates");
            while (dIt2.hasNext()) {
                Element dEl2 = (Element)dIt2.next();
                Date sd = dateFormat.parse(dEl2.attributeValue("fromDate", dEl2.attributeValue("date")));
                Date ed = dateFormat.parse(dEl2.attributeValue("toDate", dEl2.attributeValue("date")));
                Integer i1 = (Integer)date2index.get(sd);
                Integer i2 = (Integer)date2index.get(ed);
                if (i1 == null || i2 == null) continue;
                for (int j = i1.intValue(); j <= i2; ++j) {
                    weekCode.set(j, true);
                }
            }
            if (pattern.getType() != 4) {
                pattern.setPatternBitSet(weekCode);
            }
            updatedPatterns.put(pattern.getName(), pattern);
        }
        for (DatePattern pattern : updatedPatterns.values()) {
            List p = (List)parents.get(pattern.getName());
            HashSet<DatePattern> patterns = new HashSet<DatePattern>(pattern.getParents());
            if (p != null) {
                for (String name : p) {
                    DatePattern dp = (DatePattern)updatedPatterns.get(name);
                    if (dp == null || patterns.remove(dp)) continue;
                    pattern.getParents().add(dp);
                }
            }
            pattern.getParents().removeAll(patterns);
        }
        for (DatePattern pattern : updatedPatterns.values()) {
            this.getHibSession().saveOrUpdate((Object)pattern);
        }
        if (defaultDatePattern != null) {
            if (!this.getHibSession().contains((Object)session)) {
                session = (Session)SessionDAO.getInstance().get(session.getUniqueId(), this.getHibSession());
            }
            session.setDefaultDatePattern(defaultDatePattern);
            this.getHibSession().saveOrUpdate((Object)session);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (DatePattern dp : name2pattern.values()) {
                this.debug("Date pattern " + dp.getName() + " removed.");
                this.getHibSession().delete((Object)dp);
            }
        }
        this.flush(true);
    }

    public int time2slot(int time) {
        int hour = time / 100;
        int min = time % 100;
        if (min % Constants.SLOT_LENGTH_MIN != 0) {
            min -= min % Constants.SLOT_LENGTH_MIN;
        }
        return (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
    }

    public int days2code(String daysOfWeek) {
        int code = 0;
        String tmpDays = daysOfWeek;
        if (tmpDays.contains("Th")) {
            code += Constants.DAY_CODES[3];
            tmpDays = tmpDays.replace("Th", "..");
        }
        if (tmpDays.contains("R")) {
            code += Constants.DAY_CODES[3];
            tmpDays = tmpDays.replace("R", "..");
        }
        if (tmpDays.contains("Su")) {
            code += Constants.DAY_CODES[6];
            tmpDays = tmpDays.replace("Su", "..");
        }
        if (tmpDays.contains("U")) {
            code += Constants.DAY_CODES[6];
            tmpDays = tmpDays.replace("U", "..");
        }
        if (tmpDays.contains("M")) {
            code += Constants.DAY_CODES[0];
            tmpDays = tmpDays.replace("M", ".");
        }
        if (tmpDays.contains("T")) {
            code += Constants.DAY_CODES[1];
            tmpDays = tmpDays.replace("T", ".");
        }
        if (tmpDays.contains("W")) {
            code += Constants.DAY_CODES[2];
            tmpDays = tmpDays.replace("W", ".");
        }
        if (tmpDays.contains("F")) {
            code += Constants.DAY_CODES[4];
            tmpDays = tmpDays.replace("F", ".");
        }
        if (tmpDays.contains("S")) {
            code += Constants.DAY_CODES[5];
            tmpDays = tmpDays.replace("S", ".");
        }
        return code;
    }

    public void importExaminationPeriods(Element root, Session session, Formats.Format<Date> dateFormat) throws ParseException {
        this.info("Importing " + root.attributeValue("type") + " examination periods...");
        ExamType type = ExamType.findByReference(root.attributeValue("type"));
        if (type == null) {
            this.error("Examination type " + root.attributeValue("type") + " does not exist.");
            return;
        }
        HashMap<String, ExamPeriod> periods = new HashMap<String, ExamPeriod>();
        for (ExamPeriod period : this.getHibSession().createQuery("from ExamPeriod p where p.session.uniqueId = :sessionId and p.examType.uniqueId = :typeId").setLong("sessionId", session.getUniqueId().longValue()).setLong("typeId", type.getUniqueId().longValue()).list()) {
            periods.put(period.getDateOffset() + ":" + period.getStartSlot(), period);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Date date = dateFormat.parse(element.attributeValue("date"));
            long diff = date.getTime() - session.getExamBeginDate().getTime();
            int offset = (int)Math.round((double)diff / 8.64E7);
            int startSlot = this.time2slot(Integer.valueOf(element.attributeValue("startTime")));
            ExamPeriod period = (ExamPeriod)periods.remove(offset + ":" + startSlot);
            if (period == null) {
                period = new ExamPeriod();
                period.setSession(session);
                period.setExamType(type);
                period.setDateOffset(offset);
                period.setStartSlot(startSlot);
            }
            period.setLength(Integer.valueOf(element.attributeValue("length", "60")) / 5);
            period.setEventStartOffset(Integer.valueOf(element.attributeValue("eventStartOffset", "0")));
            period.setEventStopOffset(Integer.valueOf(element.attributeValue("eventStopOffset", "0")));
            period.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("preference", "0")));
            if (period.getUniqueId() == null) {
                this.debug("Examination period " + period.getName() + " created.");
            } else {
                this.debug("Examination period " + period.getName() + " updated.");
            }
            this.getHibSession().saveOrUpdate((Object)period);
        }
        if (!"true".equalsIgnoreCase(root.attributeValue("incremental"))) {
            for (ExamPeriod period : periods.values()) {
                this.debug("Examination period " + period.getName() + " removed.");
                this.getHibSession().delete((Object)period);
            }
        }
        this.flush(true);
    }
}

