/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.server.UniTimePrincipal;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;

@Service(value="/api/sectioning")
public class OnlineStudentSchedulingConnector
extends ApiConnector {
    @Autowired
    protected ApplicationContext applicationContext;

    protected SectioningService getSectioningService() {
        return (SectioningService)this.applicationContext.getBean("sectioning.gwt", SectioningService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void execute(ApiHelper helper, Flag type) throws IOException {
        void var7_13;
        String pin;
        String operation = helper.getParameter("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Parameter 'operation' was not provided.");
        }
        Operation op = null;
        try {
            op = Operation.valueOf(operation);
        }
        catch (Exception e) {
            new IllegalArgumentException("Operation '" + operation + "' is not a valid " + type.name() + " operation.");
        }
        if (op == null || !op.hasFlag(type)) {
            new IllegalArgumentException("Operation '" + operation + "' is not a valid " + type.name() + " operation.");
        }
        if (op.hasFlag(Flag.NO_SESSION)) {
            helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiOnlineStudentScheduliung, new Qualifiable[0]);
            op.execute(this.getSectioningService(), helper, type, null, null);
            return;
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null && helper.getSessionContext().getUser() != null) {
            sessionId = helper.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiOnlineStudentScheduliung, new Qualifiable[0]);
        for (UserAuthority userAuthority : helper.getSessionContext().getUser().getAuthorities()) {
            if (userAuthority.getAcademicSession() == null || !sessionId.equals(userAuthority.getAcademicSession().getQualifierId()) || !userAuthority.hasRight(Right.ApiOnlineStudentScheduliung)) continue;
            helper.getSessionContext().getUser().setCurrentAuthority(userAuthority);
            if (!helper.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) continue;
            break;
        }
        helper.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastSession, (Object)sessionId);
        String studentId = helper.getParameter("studentId");
        Object var7_9 = null;
        if (studentId != null && helper.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                List student = hibSession.createQuery("select m from Student m where m.externalUniqueId = :uid").setString("uid", studentId).setCacheable(true).list();
                if (!student.isEmpty()) {
                    UserContext user = helper.getSessionContext().getUser();
                    UniTimePrincipal uniTimePrincipal = new UniTimePrincipal(user.getExternalUserId(), studentId, user.getName());
                    for (Student s : student) {
                        uniTimePrincipal.addStudentId(s.getSession().getUniqueId(), s.getUniqueId());
                        uniTimePrincipal.setName(NameFormat.defaultFormat().format(s));
                    }
                    helper.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)uniTimePrincipal);
                } else {
                    UserContext user = helper.getSessionContext().getUser();
                    UniTimePrincipal uniTimePrincipal = new UniTimePrincipal(user.getExternalUserId(), studentId, user.getName());
                    helper.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)uniTimePrincipal);
                }
            }
        }
        if ((pin = helper.getParameter("pin")) != null) {
            helper.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingPIN, (Object)pin);
        }
        op.execute(this.getSectioningService(), helper, type, sessionId, var7_13 == null ? null : var7_13.getStudentId(sessionId));
    }

    @Override
    public void doGet(ApiHelper helper) throws IOException {
        this.execute(helper, Flag.GET);
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        this.execute(helper, Flag.POST);
    }

    @Override
    protected String getName() {
        return "sectioning";
    }

    public static class FindInfosRequest {
        Boolean online;
        String query;
        SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter;
        Long courseId;
        Long classId;
    }

    public static class MassCancelRequest
    extends StudentIdsRequest {
        String status;
        String subject;
        String message;
        String cc;
    }

    public static class ChangeStatusRequest
    extends StudentIdsRequest {
        String status;
    }

    public static class ApproveEnrollmentsRequest
    extends StudentIdsRequest {
        Long classOrOfferingId;
    }

    public static class StudentIdsRequest {
        List<Long> studentIds;
    }

    public static class SectionRequest {
        Boolean online;
        CourseRequestInterface request;
        ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment;
        Integer selectedAssignment;
        String filter;
    }

    public static enum Operation {
        listCourseOfferings(new OpExecution<Collection<ClassAssignmentInterface.CourseAssignment>>(){

            @Override
            public Collection<ClassAssignmentInterface.CourseAssignment> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.listCourseOfferings(sessionId, helper.getOptinalParameter("query", ""), helper.getOptinalParameterInteger("limit", null));
            }
        }, Flag.GET),
        listAcademicSessions(new OpExecution<Collection<AcademicSessionProvider.AcademicSessionInfo>>(){

            @Override
            public Collection<AcademicSessionProvider.AcademicSessionInfo> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.listAcademicSessions(helper.getOptinalParameterBoolean("sectioning", true));
            }
        }, Flag.GET, Flag.NO_SESSION),
        retrieveCourseDetails(new OpExecution<String>(){

            @Override
            public String execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.retrieveCourseDetails(sessionId, helper.getRequiredParameter("course"));
            }
        }, Flag.GET),
        listClasses(new OpExecution<Collection<ClassAssignmentInterface.ClassAssignment>>(){

            @Override
            public Collection<ClassAssignmentInterface.ClassAssignment> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.listClasses(helper.getOptinalParameterBoolean("online", true), sessionId, helper.getRequiredParameter("course"));
            }
        }, Flag.GET),
        retrieveCourseOfferingId(new OpExecution<Long>(){

            @Override
            public Long execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.retrieveCourseOfferingId(sessionId, helper.getRequiredParameter("course"));
            }
        }, Flag.GET),
        checkCourses(new OpExecution<CourseRequestInterface.CheckCoursesResponse>(){

            @Override
            public CourseRequestInterface.CheckCoursesResponse execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                CourseRequestInterface request = (CourseRequestInterface)helper.getRequest((Type)((Object)CourseRequestInterface.class));
                request.setAcademicSessionId(sessionId);
                if (request.getStudentId() == null && studentId != null) {
                    request.setStudentId(studentId);
                }
                return service.checkCourses(helper.getOptinalParameterBoolean("online", true), helper.getOptinalParameterBoolean("sectioning", false), request);
            }
        }, Flag.POST),
        section(new OpExecution<ClassAssignmentInterface>(){

            @Override
            public ClassAssignmentInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                SectionRequest request = (SectionRequest)helper.getRequest((Type)((Object)SectionRequest.class));
                if (request.request != null) {
                    request.request.setAcademicSessionId(sessionId);
                    if (request.request.getStudentId() == null && studentId != null) {
                        request.request.setStudentId(studentId);
                    }
                }
                return service.section(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), request.request, request.currentAssignment);
            }
        }, Flag.POST),
        computeSuggestions(new OpExecution<Collection<ClassAssignmentInterface>>(){

            @Override
            public Collection<ClassAssignmentInterface> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                SectionRequest request = (SectionRequest)helper.getRequest((Type)((Object)SectionRequest.class));
                if (request.request != null) {
                    request.request.setAcademicSessionId(sessionId);
                    if (request.request.getStudentId() == null && studentId != null) {
                        request.request.setStudentId(studentId);
                    }
                }
                return service.computeSuggestions(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), request.request, request.currentAssignment, helper.getOptinalParameterInteger("selectedAssignment", request.selectedAssignment == null ? 0 : request.selectedAssignment), helper.getOptinalParameter("filter", request.filter));
            }
        }, Flag.POST),
        checkEligibility(new OpExecution<OnlineSectioningInterface.EligibilityCheck>(){

            @Override
            public OnlineSectioningInterface.EligibilityCheck execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.checkEligibility(helper.getOptinalParameterBoolean("online", true), helper.getOptinalParameterBoolean("sectioning", false), sessionId, studentId, helper.getOptinalParameter("pin", null));
            }
        }, Flag.GET),
        saveRequest(new OpExecution<CourseRequestInterface>(){

            @Override
            public CourseRequestInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                CourseRequestInterface request = (CourseRequestInterface)helper.getRequest((Type)((Object)CourseRequestInterface.class));
                request.setAcademicSessionId(sessionId);
                if (request.getStudentId() == null && studentId != null) {
                    request.setStudentId(studentId);
                }
                return service.saveRequest(request);
            }
        }, Flag.POST),
        enroll(new OpExecution<ClassAssignmentInterface>(){

            @Override
            public ClassAssignmentInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                SectionRequest request = (SectionRequest)helper.getRequest((Type)((Object)SectionRequest.class));
                if (request.request != null) {
                    request.request.setAcademicSessionId(sessionId);
                    if (request.request.getStudentId() == null && studentId != null) {
                        request.request.setStudentId(studentId);
                    }
                }
                return service.enroll(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), request.request, request.currentAssignment);
            }
        }, Flag.POST),
        getProperties(new OpExecution<OnlineSectioningInterface.SectioningProperties>(){

            @Override
            public OnlineSectioningInterface.SectioningProperties execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.getProperties(sessionId);
            }
        }, Flag.GET),
        listEnrollments(new OpExecution<List<ClassAssignmentInterface.Enrollment>>(){

            @Override
            public List<ClassAssignmentInterface.Enrollment> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.listEnrollments(helper.getRequiredParameterLong("offeringId"));
            }
        }, Flag.GET),
        getEnrollment(new OpExecution<ClassAssignmentInterface>(){

            @Override
            public ClassAssignmentInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.getEnrollment(helper.getOptinalParameterBoolean("online", true), studentId);
            }
        }, Flag.GET),
        canApprove(new OpExecution<List<Long>>(){

            @Override
            public List<Long> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.canApprove(helper.getRequiredParameterLong("classOrOfferingId"));
            }
        }, Flag.GET),
        approveEnrollments(new OpExecution<String>(){

            @Override
            public String execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                ApproveEnrollmentsRequest request = null;
                if (Flag.POST == type) {
                    request = (ApproveEnrollmentsRequest)helper.getRequest((Type)((Object)ApproveEnrollmentsRequest.class));
                }
                if (request == null) {
                    request = new ApproveEnrollmentsRequest();
                }
                if (request.studentIds == null) {
                    request.studentIds = new ArrayList();
                }
                if (request.studentIds.isEmpty() && studentId != null) {
                    request.studentIds.add(studentId);
                }
                return service.approveEnrollments(helper.getOptinalParameterLong("classOrOfferingId", request.classOrOfferingId), request.studentIds);
            }
        }, Flag.GET, Flag.POST),
        rejectEnrollments(new OpExecution<Boolean>(){

            @Override
            public Boolean execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                ApproveEnrollmentsRequest request = null;
                if (Flag.POST == type) {
                    request = (ApproveEnrollmentsRequest)helper.getRequest((Type)((Object)ApproveEnrollmentsRequest.class));
                }
                if (request == null) {
                    request = new ApproveEnrollmentsRequest();
                }
                if (request.studentIds == null) {
                    request.studentIds = new ArrayList();
                }
                if (request.studentIds.isEmpty() && studentId != null) {
                    request.studentIds.add(studentId);
                }
                return service.rejectEnrollments(helper.getOptinalParameterLong("classOrOfferingId", request.classOrOfferingId), request.studentIds);
            }
        }, Flag.GET, Flag.POST),
        findEnrollmentInfos(new OpExecution<List<ClassAssignmentInterface.EnrollmentInfo>>(){

            @Override
            public List<ClassAssignmentInterface.EnrollmentInfo> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                FindInfosRequest request = null;
                if (type == Flag.POST) {
                    request = (FindInfosRequest)helper.getRequest((Type)((Object)FindInfosRequest.class));
                }
                if (request == null) {
                    request = new FindInfosRequest();
                }
                return service.findEnrollmentInfos(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), helper.getOptinalParameter("query", request.query == null ? "" : request.query), request.filter, helper.getOptinalParameterLong("courseId", request.courseId));
            }
        }, Flag.GET, Flag.POST),
        findStudentInfos(new OpExecution<List<ClassAssignmentInterface.StudentInfo>>(){

            @Override
            public List<ClassAssignmentInterface.StudentInfo> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                FindInfosRequest request = null;
                if (type == Flag.POST) {
                    request = (FindInfosRequest)helper.getRequest((Type)((Object)FindInfosRequest.class));
                }
                if (request == null) {
                    request = new FindInfosRequest();
                }
                return service.findStudentInfos(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), helper.getOptinalParameter("query", request.query == null ? "" : request.query), request.filter);
            }
        }, Flag.GET, Flag.POST),
        findEnrollments(new OpExecution<List<ClassAssignmentInterface.Enrollment>>(){

            @Override
            public List<ClassAssignmentInterface.Enrollment> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                FindInfosRequest request = null;
                if (type == Flag.POST) {
                    request = (FindInfosRequest)helper.getRequest((Type)((Object)FindInfosRequest.class));
                }
                if (request == null) {
                    request = new FindInfosRequest();
                }
                return service.findEnrollments(helper.getOptinalParameterBoolean("online", request.online == null ? true : request.online), helper.getOptinalParameter("query", request.query == null ? "" : request.query), request.filter, helper.getOptinalParameterLong("courseId", request.courseId), helper.getOptinalParameterLong("classId", request.classId));
            }
        }, Flag.GET, Flag.POST),
        querySuggestions(new OpExecution<List<String[]>>(){

            @Override
            public List<String[]> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.querySuggestions(helper.getOptinalParameterBoolean("online", true), helper.getOptinalParameter("query", ""), helper.getOptinalParameterInteger("limit", null));
            }
        }, Flag.GET),
        canEnroll(new OpExecution<Long>(){

            @Override
            public Long execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.canEnroll(helper.getOptinalParameterBoolean("online", true), studentId);
            }
        }, Flag.GET),
        savedRequest(new OpExecution<CourseRequestInterface>(){

            @Override
            public CourseRequestInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.savedRequest(helper.getOptinalParameterBoolean("online", true), helper.getOptinalParameterBoolean("sectioning", true), sessionId, studentId);
            }
        }, Flag.GET),
        savedResult(new OpExecution<ClassAssignmentInterface>(){

            @Override
            public ClassAssignmentInterface execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.savedResult(helper.getOptinalParameterBoolean("online", true), sessionId, studentId);
            }
        }, Flag.GET),
        lookupStudentSectioningStates(new OpExecution<List<OnlineSectioningInterface.StudentStatusInfo>>(){

            @Override
            public List<OnlineSectioningInterface.StudentStatusInfo> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.lookupStudentSectioningStates();
            }
        }, Flag.GET),
        sendEmail(new OpExecution<Boolean>(){

            @Override
            public Boolean execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.sendEmail(studentId, helper.getOptinalParameter("subject", null), helper.getOptinalParameter("message", null), helper.getOptinalParameter("cc", null), helper.getOptinalParameterBoolean("courseRequests", null), helper.getOptinalParameterBoolean("classSchedule", null));
            }
        }, Flag.GET, Flag.POST),
        changeStatus(new OpExecution<Boolean>(){

            @Override
            public Boolean execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                ChangeStatusRequest request = (ChangeStatusRequest)helper.getRequest((Type)((Object)ChangeStatusRequest.class));
                if (request == null) {
                    request = new ChangeStatusRequest();
                }
                if (request.studentIds == null) {
                    request.studentIds = new ArrayList();
                }
                if (request.studentIds.isEmpty() && studentId != null) {
                    request.studentIds.add(studentId);
                }
                return service.changeStatus(request.studentIds, helper.getOptinalParameter("note", request.status), helper.getOptinalParameter("status", request.status));
            }
        }, Flag.GET, Flag.POST),
        changeLog(new OpExecution<List<ClassAssignmentInterface.SectioningAction>>(){

            @Override
            public List<ClassAssignmentInterface.SectioningAction> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                String sid = helper.getOptinalParameter("studentId", null);
                return service.changeLog(helper.getOptinalParameter("query", sid == null ? "" : "id:" + sid));
            }
        }, Flag.GET),
        massCancel(new OpExecution<Boolean>(){

            @Override
            public Boolean execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                MassCancelRequest request = null;
                if (type == Flag.POST) {
                    request = (MassCancelRequest)helper.getRequest((Type)((Object)MassCancelRequest.class));
                }
                if (request == null) {
                    request = new MassCancelRequest();
                }
                if (request.studentIds == null) {
                    request.studentIds = new ArrayList();
                }
                if (request.studentIds.isEmpty() && studentId != null) {
                    request.studentIds.add(studentId);
                }
                return service.massCancel(request.studentIds, helper.getOptinalParameter("status", request.status), helper.getOptinalParameter("subject", request.subject), helper.getOptinalParameter("message", request.message), helper.getOptinalParameter("cc", request.cc));
            }
        }, Flag.GET, Flag.POST),
        requestStudentUpdate(new OpExecution<Boolean>(){

            @Override
            public Boolean execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                StudentIdsRequest request = null;
                if (type == Flag.POST) {
                    request = (StudentIdsRequest)helper.getRequest((Type)((Object)StudentIdsRequest.class));
                }
                if (request == null) {
                    request = new StudentIdsRequest();
                }
                if (request.studentIds == null) {
                    request.studentIds = new ArrayList<Long>();
                }
                if (request.studentIds.isEmpty() && studentId != null) {
                    request.studentIds.add(studentId);
                }
                return service.requestStudentUpdate(request.studentIds);
            }
        }, Flag.GET, Flag.POST),
        listDegreePlans(new OpExecution<List<DegreePlanInterface>>(){

            @Override
            public List<DegreePlanInterface> execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
                return service.listDegreePlans(helper.getOptinalParameterBoolean("online", true), sessionId, studentId);
            }
        }, Flag.GET);

        int iFlags = 0;
        OpExecution iExecution = null;

        private Operation(OpExecution execution, Flag ... flags) {
            this.iExecution = execution;
            for (Flag f : flags) {
                this.iFlags |= f.toInt();
            }
        }

        public boolean hasFlag(Flag f) {
            return f.has(this.iFlags);
        }

        public void execute(SectioningService service, ApiHelper helper, Flag type, Long sessionId, Long studentId) throws IOException {
            helper.setResponse(this.iExecution.execute(service, helper, type, sessionId, studentId));
        }
    }

    public static interface OpExecution<R> {
        public R execute(SectioningService var1, ApiHelper var2, Flag var3, Long var4, Long var5) throws IOException;
    }

    public static enum Flag {
        GET,
        POST,
        NO_SESSION;


        public int toInt() {
            return 1 << this.ordinal();
        }

        public boolean has(int flags) {
            return (flags & this.toInt()) == this.toInt();
        }
    }
}

