/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructionalOfferingConfigEditForm;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SimpleItypeConfig;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SicComparator;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.AccessDeniedException;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.SchedulingSubpartTableBuilder;

@Service(value="/instructionalOfferingConfigEdit")
public class InstructionalOfferingConfigEditAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    Permission.PermissionDepartment permissionDepartment;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String courseOfferingId;
        Vector sp;
        String op;
        MessageResources rsc = this.getResources(request);
        InstructionalOfferingConfigEditForm frm = (InstructionalOfferingConfigEditForm)form;
        Department contrDept = null;
        if (frm.getConfigId() == null || frm.getConfigId() == 0L) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.valueOf(frm.getInstrOfferingId()));
            this.sessionContext.checkPermission(offering, Right.InstrOfferingConfigAdd);
            contrDept = offering.getControllingCourseOffering().getSubjectArea().getDepartment();
        }
        if (frm.getConfigId() != null && frm.getConfigId() != 0L) {
            InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(frm.getConfigId());
            this.sessionContext.checkPermission(config, Right.InstrOfferingConfigEdit);
            contrDept = config.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment();
        }
        String html = "";
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null) {
            op = request.getParameter("hdnOp");
        }
        if (op == null || op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + op);
        }
        frm.setOp(op);
        LookupTables.setupItypes(request, true);
        LookupTables.setupExternalDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        TreeSet<Department> ts = new TreeSet<Department>();
        for (Department d : (TreeSet)request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            if (!this.sessionContext.hasPermission(d, Right.InstrOfferingConfigEditDepartment) || !this.permissionDepartment.check(this.sessionContext.getUser(), contrDept, DepartmentStatusType.Status.OwnerEdit, d, DepartmentStatusType.Status.ManagerEdit)) continue;
            ts.add(d);
        }
        request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, ts);
        request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        this.search("-1111", new Vector(), true);
        if (op.equalsIgnoreCase(rsc.getMessage("op.edit")) || op.equalsIgnoreCase(MSG.actionEditConfiguration())) {
            Long configId = null;
            try {
                configId = new Long(request.getParameter("configId"));
            }
            catch (Exception e) {
                throw new Exception(MSG.errorConfigIDNotValid() + request.getParameter("configId"));
            }
            this.sessionContext.checkPermission(configId, "InstrOfferingConfig", Right.InstrOfferingConfigEdit);
            this.loadDetailFromConfig(frm, configId, false);
            sp = this.loadOriginalConfig(frm.getConfigId(), frm);
            boolean createAsNew = false;
            if (sp != null && sp.size() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), configId.toString(), createAsNew, frm.getUnlimited(), frm.getDurationTypeText());
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
            } else {
                this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, null);
            }
        }
        if (op.equals(MSG.actionAddConfiguration())) {
            Object object2 = request.getParameter("uid") == null ? (request.getAttribute("uid") == null ? null : request.getAttribute("uid").toString()) : (courseOfferingId = request.getParameter("uid"));
            if (courseOfferingId == null || courseOfferingId.trim().length() == 0) {
                throw new Exception(MSG.exceptionCourseOfferingIdNeeded());
            }
            this.sessionContext.checkPermission((Serializable)((Object)frm.getInstrOfferingId()), "InstructionalOffering", Right.InstrOfferingConfigAdd);
            this.loadDetailFromCourseOffering(frm, new Long(courseOfferingId), true, false);
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)"");
        }
        if (op.equalsIgnoreCase(MSG.actionMakeOffered())) {
            Object object3 = request.getParameter("uid") == null ? (request.getAttribute("uid") == null ? null : request.getAttribute("uid").toString()) : (courseOfferingId = request.getParameter("uid"));
            if (courseOfferingId == null || courseOfferingId.trim().length() == 0) {
                throw new Exception(MSG.exceptionCourseOfferingIdNeeded());
            }
            this.loadDetailFromCourseOffering(frm, new Long(courseOfferingId), true, true);
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)"");
            if (frm.getConfigId() != null && frm.getConfigId().intValue() > 0) {
                sp = this.loadOriginalConfig(frm.getConfigId(), frm);
                if (sp != null && sp.size() > 0) {
                    this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
                    html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), courseOfferingId, false, frm.getUnlimited(), frm.getDurationTypeText());
                    request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                } else {
                    this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
                    request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, null);
                }
            }
        }
        if (op.equals(MSG.actionAddInstructionalTypeToConfig())) {
            ActionErrors errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("displayForm");
            }
            this.addInstructionalType(frm);
            frm.setItype(Constants.BLANK_OPTION_VALUE);
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (op.indexOf(rsc.getMessage("op.shift")) >= 0 || op.equals(rsc.getMessage("op.delete"))) {
            int limit = 0;
            try {
                limit = Integer.parseInt(request.getParameter("limit"));
            }
            catch (Exception e) {
                limit = 0;
            }
            frm.setLimit(limit);
            this.processShiftOrDelete(request.getParameter("id"), op);
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (op.equalsIgnoreCase("multipleLimits")) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (op.equals(MSG.actionSaveConfiguration()) || op.equals(MSG.actionUpdateConfiguration())) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
            ActionErrors errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("displayForm");
            }
            try {
                this.updateConfig(request, frm);
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("instructionalOfferingDetail"));
                redirect.addParameter("io", (Object)frm.getInstrOfferingId());
                redirect.addParameter("op", (Object)"view");
                return redirect;
            }
            catch (Exception e) {
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
                request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                errors.add("subparts", new ActionMessage("errors.generic", (Object)("Configuration could not be updated. If possible, split your configuration change into 2 or more separate operations. " + (e.getClass().getName().startsWith("org.hibernate.") ? "" : "Exception: " + e.getMessage()))));
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("displayForm");
            }
        }
        if (op.equals(MSG.actionDeleteConfiguration())) {
            this.sessionContext.checkPermission(frm.getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigDelete);
            this.deleteConfig(request, frm);
            ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("instructionalOfferingDetail"));
            redirect.addParameter("io", (Object)frm.getInstrOfferingId());
            redirect.addParameter("op", (Object)"view");
            redirect.addParameter("cfgDelete", (Object)"1");
            return redirect;
        }
        if (op.equalsIgnoreCase("unlimitedEnrollment")) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(request, this.sessionContext, frm.getLimit(), frm.getCourseOfferingId(), false, frm.getUnlimited(), frm.getDurationTypeText());
            request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
            return mapping.findForward("displayForm");
        }
        return mapping.findForward("displayForm");
    }

    private void loadDetailFromConfig(InstructionalOfferingConfigEditForm frm, Long configId, boolean init) throws Exception {
        ClassDurationType dtype;
        if (configId == null) {
            throw new Exception("Config Id need for operation. ");
        }
        InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(configId);
        if (ioc == null) {
            throw new Exception("Congifuration not found for id: " + configId);
        }
        frm.setConfigId(configId);
        frm.setName(ioc.getName());
        frm.setUnlimited(ioc.isUnlimitedEnrollment());
        Long courseOfferingId = ioc.getControllingCourseOffering().getUniqueId();
        this.loadDetailFromCourseOffering(frm, courseOfferingId, init, false);
        frm.setDurationType(ioc.getClassDurationType() == null ? -1L : ioc.getClassDurationType().getUniqueId());
        for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
            if (this.sessionContext.hasPermission(subpart, Right.InstrOfferingConfigEditSubpart)) continue;
            frm.setDurationTypeEditable(false);
            break;
        }
        if (frm.getDurationTypes().size() <= 1 && (dtype = ioc.getEffectiveDurationType()) != null && dtype.isVisible().booleanValue()) {
            frm.setDurationTypeEditable(false);
        }
        frm.setInstructionalMethod(ioc.getInstructionalMethod() == null ? -1L : ioc.getInstructionalMethod().getUniqueId());
    }

    private void loadDetailFromCourseOffering(InstructionalOfferingConfigEditForm frm, Long courseOfferingId, boolean init, boolean loadDefaultConfig) throws Exception {
        if (courseOfferingId == null) {
            throw new Exception("Course Offering Id need for operation. ");
        }
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        CourseOffering co = (CourseOffering)coDao.get(courseOfferingId);
        if (co == null) {
            throw new Exception("Course Offering not found for id: " + courseOfferingId);
        }
        InstructionalOffering io = co.getInstructionalOffering();
        frm.setCourseOfferingId(co.getUniqueId().toString());
        frm.setSubjectArea(co.getSubjectAreaAbbv());
        frm.setCourseNumber(co.getCourseNbr());
        frm.setInstrOfferingName(co.getCourseNameWithTitle());
        frm.setInstrOfferingId(io.getUniqueId().toString());
        frm.setNotOffered(io.isNotOffered());
        frm.setDurationType(io.getSession().getDefaultClassDurationType() == null ? -1L : io.getSession().getDefaultClassDurationType().getUniqueId());
        frm.setDurationTypeDefault(io.getSession().getDefaultClassDurationType() == null ? MSG.systemDefaultDurationType() : MSG.sessionDefault(io.getSession().getDefaultClassDurationType().getLabel()));
        frm.setDurationTypeEditable(true);
        frm.setInstructionalMethod(null);
        frm.setInstructionalMethodDefault(io.getSession().getDefaultInstructionalMethod() == null ? null : io.getSession().getDefaultInstructionalMethod().getLabel());
        Set<InstrOfferingConfig> configs = io.getInstrOfferingConfigs();
        frm.setConfigCount(new Integer(configs.size()));
        String linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value();
        if (linkLookupClass != null && linkLookupClass.trim().length() > 0) {
            ExternalLinkLookup lookup = (ExternalLinkLookup)Class.forName(linkLookupClass).newInstance();
            Map results = lookup.getLink(io);
            if (results == null) {
                throw new Exception(lookup.getErrorMessage());
            }
            frm.setCatalogLinkLabel((String)results.get("label"));
            frm.setCatalogLinkLocation((String)results.get("href"));
        }
        if (loadDefaultConfig) {
            if (configs == null || configs.size() == 0) {
                frm.setConfigId(null);
                frm.setName("1");
            } else {
                InstrOfferingConfig ioc = configs.iterator().next();
                frm.setConfigId(ioc.getUniqueId());
                if (init) {
                    frm.setName(ioc.getName());
                    frm.setUnlimited(ioc.isUnlimitedEnrollment());
                }
            }
        } else if (frm.getName() == null || frm.getName().trim().length() == 0) {
            frm.setName(InstrOfferingConfig.getGeneratedName(io));
        }
    }

    private Vector loadOriginalConfig(Long configId, InstructionalOfferingConfigEditForm frm) throws Exception {
        InstrOfferingConfigDAO cfgDao = new InstrOfferingConfigDAO();
        InstrOfferingConfig config = (InstrOfferingConfig)cfgDao.get(configId);
        frm.setLimit(config.getLimit());
        Vector sp = this.toSimpleItypeConfig(config);
        if (sp != null && sp.size() > 0) {
            Collections.sort(sp, new SicComparator());
        }
        return sp;
    }

    private void addInstructionalType(InstructionalOfferingConfigEditForm frm) throws Exception {
        ItypeDescDAO itypeDao = new ItypeDescDAO();
        ItypeDesc itype = (ItypeDesc)itypeDao.get(new Integer(frm.getItype()));
        if (itype == null) {
            throw new Exception("Instructional Type not found");
        }
        Vector<SimpleItypeConfig> sp = (Vector<SimpleItypeConfig>)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null) {
            sp = new Vector<SimpleItypeConfig>();
        }
        SimpleItypeConfig sic = new SimpleItypeConfig(itype);
        sic.setSubpartId(-1L);
        sp.addElement(sic);
        this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, sp);
    }

    private void processShiftOrDelete(String id, String op) throws Exception {
        Object tmp;
        SimpleItypeConfig subp;
        int i;
        Object tmp2;
        int indx2;
        int indx1;
        SimpleItypeConfig parent;
        Vector sp = (Vector)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            throw new Exception("Could not retrieve user defined configs");
        }
        Vector indx = new Vector();
        SimpleItypeConfig result = this.search(id, indx, false);
        if (result == null) {
            throw new Exception("Could not retrieve config element: " + id);
        }
        int index = Integer.parseInt(indx.elementAt(0).toString());
        if (op.equalsIgnoreCase("shiftUp")) {
            parent = result.getParent();
            if (parent == null) {
                indx1 = index;
                indx2 = indx1 - 1;
                tmp2 = sp.elementAt(indx1);
                sp.insertElementAt(tmp2, indx2);
                sp.removeElementAt(indx1 + 1);
            } else {
                Vector v = parent.getSubparts();
                for (i = 0; i < v.size(); ++i) {
                    subp = (SimpleItypeConfig)v.elementAt(i);
                    if (subp.getId() != Long.parseLong(id)) continue;
                    tmp = v.elementAt(i);
                    v.insertElementAt(tmp, i - 1);
                    v.removeElementAt(i + 1);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftDown")) {
            parent = result.getParent();
            if (parent == null) {
                indx1 = index + 1;
                indx2 = index;
                tmp2 = sp.elementAt(indx1);
                sp.insertElementAt(tmp2, indx2);
                sp.removeElementAt(indx1 + 1);
            } else {
                Vector v = parent.getSubparts();
                for (i = 0; i < v.size(); ++i) {
                    subp = (SimpleItypeConfig)v.elementAt(i);
                    if (subp.getId() != Long.parseLong(id)) continue;
                    tmp = v.elementAt(i + 1);
                    v.insertElementAt(tmp, i);
                    v.removeElementAt(i + 2);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftLeft")) {
            parent = result.getParent();
            Vector v = parent.getSubparts();
            for (i = 0; i < v.size(); ++i) {
                subp = (SimpleItypeConfig)v.elementAt(i);
                if (subp.getId() != Long.parseLong(id)) continue;
                v.removeElementAt(i);
                break;
            }
            SimpleItypeConfig grandParent = parent.getParent();
            result.setParent(grandParent);
            if (grandParent == null) {
                sp.insertElementAt(result, index + 1);
            } else {
                Vector v1 = grandParent.getSubparts();
                for (int i2 = 0; i2 < v1.size(); ++i2) {
                    SimpleItypeConfig subp2 = (SimpleItypeConfig)v1.elementAt(i2);
                    if (subp2.getId() != parent.getId()) continue;
                    v1.insertElementAt(result, i2 + 1);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftRight")) {
            parent = result.getParent();
            if (parent == null) {
                SimpleItypeConfig curr = (SimpleItypeConfig)sp.elementAt(index);
                SimpleItypeConfig prev = (SimpleItypeConfig)sp.elementAt(index - 1);
                prev.addSubpart(curr);
                sp.removeElementAt(index);
            } else {
                Vector v = parent.getSubparts();
                for (int i3 = 0; i3 < v.size(); ++i3) {
                    subp = (SimpleItypeConfig)v.elementAt(i3);
                    if (subp.getId() != Long.parseLong(id)) continue;
                    SimpleItypeConfig curr = (SimpleItypeConfig)v.elementAt(i3);
                    SimpleItypeConfig prev = (SimpleItypeConfig)v.elementAt(i3 - 1);
                    prev.addSubpart(curr);
                    v.removeElementAt(i3);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("delete")) {
            parent = result.getParent();
            if (parent == null) {
                sp.removeElementAt(index);
            } else {
                Vector v = parent.getSubparts();
                for (int i4 = 0; i4 < v.size(); ++i4) {
                    subp = (SimpleItypeConfig)v.elementAt(i4);
                    if (subp.getId() != Long.parseLong(id)) continue;
                    v.removeElementAt(i4);
                    break;
                }
            }
        }
        this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
    }

    private SimpleItypeConfig search(String id, Vector indx, boolean clearErrorFlags) {
        Vector sp = (Vector)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            return null;
        }
        SimpleItypeConfig result = null;
        for (int i = 0; i < sp.size(); ++i) {
            SimpleItypeConfig sic = (SimpleItypeConfig)sp.elementAt(i);
            indx.clear();
            indx.addElement("" + i);
            if (clearErrorFlags) {
                sic.setHasError(false);
            }
            if ((result = this.searchR(sic, id, clearErrorFlags)) != null) break;
        }
        if (clearErrorFlags) {
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
        }
        return result;
    }

    private SimpleItypeConfig searchR(SimpleItypeConfig sic, String id, boolean clearErrorFlags) {
        if (sic.getId() == Long.parseLong(id)) {
            return sic;
        }
        Vector v = sic.getSubparts();
        SimpleItypeConfig result = null;
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = (SimpleItypeConfig)v.elementAt(i);
            if (clearErrorFlags) {
                sic1.setHasError(false);
            }
            if ((result = this.searchR(sic1, id, clearErrorFlags)) != null) break;
        }
        return result;
    }

    private void deleteConfig(HttpServletRequest request, InstructionalOfferingConfigEditForm frm) throws Exception {
        Session hibSession = null;
        Transaction tx = null;
        try {
            InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
            hibSession = iocDao.getSession();
            tx = hibSession.beginTransaction();
            Long configId = frm.getConfigId();
            InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(configId);
            InstructionalOffering io = ioc.getInstructionalOffering();
            this.deleteSubpart(request, hibSession, ioc, new HashMap());
            io.removeConfiguration(ioc);
            io.computeLabels(hibSession);
            if (!ioc.isUnlimitedEnrollment().booleanValue()) {
                io.setLimit(new Integer(io.getLimit() - ioc.getLimit()));
            }
            ChangeLog.addChange(hibSession, this.sessionContext, io, io.getCourseName() + " [" + ioc.getName() + "]", ChangeLog.Source.INSTR_CFG_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            Event.deleteFromEvents(hibSession, ioc);
            Exam.deleteFromExams(hibSession, ioc);
            hibSession.saveOrUpdate((Object)io);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).newInstance()).validateConfigChangeCanOccur(io, hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            hibSession.flush();
            tx.commit();
            hibSession.refresh((Object)io);
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void updateConfig(HttpServletRequest request, InstructionalOfferingConfigEditForm frm) throws Exception {
        Vector sp = (Vector)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            return;
        }
        RoomGroup rg = RoomGroup.getGlobalDefaultRoomGroup(this.sessionContext.getUser().getCurrentAcademicSessionId());
        InstrOfferingConfig ioc = null;
        InstructionalOffering io = null;
        Session hibSession = null;
        Transaction tx = null;
        try {
            InstructionalMethod imeth;
            InstructionalOfferingDAO ioDao = new InstructionalOfferingDAO();
            InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
            hibSession = iocDao.getSession();
            tx = hibSession.beginTransaction();
            io = (InstructionalOffering)ioDao.get(new Long(frm.getInstrOfferingId()));
            Long configId = frm.getConfigId();
            Boolean unlimitedEnroll = frm.getUnlimited() == null ? new Boolean(false) : frm.getUnlimited();
            int limit = unlimitedEnroll != false ? 0 : frm.getLimit();
            ClassDurationType dtype = frm.getDurationType() == null || frm.getDurationType() < 0L ? null : (ClassDurationType)ClassDurationTypeDAO.getInstance().get(frm.getDurationType(), hibSession);
            InstructionalMethod instructionalMethod = imeth = frm.getInstructionalMethod() == null || frm.getInstructionalMethod() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(frm.getInstructionalMethod(), hibSession);
            if (configId == null || configId.intValue() == 0) {
                ioc = new InstrOfferingConfig();
                ioc.setLimit(new Integer(limit));
                ioc.setName(frm.getName());
                ioc.setUnlimitedEnrollment(unlimitedEnroll);
                ioc.setInstructionalOffering(io);
                ioc.setClassDurationType(dtype);
                ioc.setInstructionalMethod(imeth);
                io.addToinstrOfferingConfigs(ioc);
                hibSession.saveOrUpdate((Object)ioc);
                hibSession.saveOrUpdate((Object)io);
            } else {
                ioc = (InstrOfferingConfig)iocDao.get(configId);
                ioc.setLimit(new Integer(limit));
                ioc.setName(frm.getName());
                ioc.setUnlimitedEnrollment(unlimitedEnroll);
                ioc.setClassDurationType(dtype);
                ioc.setInstructionalMethod(imeth);
            }
            HashMap notDeletedSubparts = new HashMap();
            for (int i = 0; i < sp.size(); ++i) {
                SimpleItypeConfig sic = (SimpleItypeConfig)sp.elementAt(i);
                this.createOrUpdateSubpart(request, hibSession, sic, ioc, null, rg, notDeletedSubparts);
                this.createOrUpdateClasses(request, hibSession, sic, ioc, null);
            }
            Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
            for (SchedulingSubpart subp : s) {
                if (subp.getParentSubpart() != null) continue;
                Debug.debug("Setting parents for " + subp.getItypeDesc());
                this.updateParentClasses(subp, null, hibSession, notDeletedSubparts);
            }
            this.deleteSubpart(request, hibSession, ioc, notDeletedSubparts);
            hibSession.saveOrUpdate((Object)ioc);
            hibSession.saveOrUpdate((Object)io);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).newInstance()).validateConfigChangeCanOccur(io, hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            io.computeLabels(hibSession);
            ChangeLog.addChange(hibSession, this.sessionContext, ioc, ChangeLog.Source.INSTR_CFG_EDIT, configId == null || configId.intValue() == 0 ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            hibSession.flush();
            tx.commit();
            hibSession.refresh((Object)ioc);
            hibSession.refresh((Object)io);
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ioc != null) {
                    hibSession.refresh(ioc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (io != null) {
                    hibSession.refresh(io);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void updateParentClasses(SchedulingSubpart subpart, SchedulingSubpart parent, Session hibSession, HashMap notDeletedSubparts) {
        Set<SchedulingSubpart> childSubparts;
        Set<Class_> classes;
        if (parent == null) {
            Debug.debug("Parent is null. Setting all classes to have no parent");
            classes = subpart.getClasses();
            for (Class_ c : classes) {
                c.setParentClass(null);
                hibSession.saveOrUpdate((Object)c);
            }
        } else {
            classes = subpart.getClasses();
            ArrayList<Class_> classesList = new ArrayList<Class_>(classes);
            Collections.sort(classesList, new ClassComparator(1));
            Set<Class_> parentClasses = parent.getClasses();
            int parentNumClasses = parentClasses.size();
            if (parentNumClasses > 0) {
                Class_ childClass;
                Iterator<Class_> cci = classesList.iterator();
                int classPerParent = classesList.size() / parentNumClasses;
                int classPerParentRem = classesList.size() % parentNumClasses;
                Debug.debug("Setting " + classPerParent + " class(es) per parent");
                Debug.debug("Odd number of classes found - " + classPerParentRem + " classes ... ");
                Iterator<Class_> i = parentClasses.iterator();
                while (i.hasNext() && classPerParent != 0) {
                    Class_ parentClass = i.next();
                    for (int j = 0; j < classPerParent; ++j) {
                        Class_ pc;
                        childClass = cci.next();
                        if (notDeletedSubparts.get(childClass.getSchedulingSubpart().getUniqueId()) != null) {
                            Debug.debug("Setting class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                            childClass.setParentClass(parentClass);
                            parentClass.addTochildClasses(childClass);
                            hibSession.saveOrUpdate((Object)parentClass);
                            hibSession.saveOrUpdate((Object)childClass);
                        } else {
                            if (!this.sessionContext.hasPermission(childClass, Right.ClassDelete)) {
                                throw new AccessDeniedException("Class " + childClass.getClassLabel(hibSession) + " cannot be deleted.");
                            }
                            Debug.debug("Deleting class " + childClass.getClassLabel());
                            if (childClass.getParentClass() != null) {
                                pc = childClass.getParentClass();
                                pc.getChildClasses().remove(childClass);
                                hibSession.saveOrUpdate((Object)pc);
                                childClass.setParentClass(null);
                                hibSession.saveOrUpdate((Object)childClass);
                            }
                            classes.remove(childClass);
                            childClass.deleteAllDependentObjects(hibSession, false);
                            hibSession.delete((Object)childClass);
                            hibSession.saveOrUpdate((Object)subpart);
                        }
                        if (classPerParentRem == 0) continue;
                        if (cci.hasNext()) {
                            childClass = cci.next();
                            if (notDeletedSubparts.get(childClass.getSchedulingSubpart().getUniqueId()) != null) {
                                Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                childClass.setParentClass(parentClass);
                                parentClass.addTochildClasses(childClass);
                                hibSession.saveOrUpdate((Object)parentClass);
                                hibSession.saveOrUpdate((Object)childClass);
                            } else {
                                if (!this.sessionContext.hasPermission(childClass, Right.ClassDelete)) {
                                    throw new AccessDeniedException("Class " + childClass.getClassLabel(hibSession) + " cannot be deleted.");
                                }
                                Debug.debug("Deleting ODD class " + childClass.getClassLabel());
                                if (childClass.getParentClass() != null) {
                                    pc = childClass.getParentClass();
                                    pc.getChildClasses().remove(childClass);
                                    hibSession.saveOrUpdate((Object)pc);
                                    childClass.setParentClass(null);
                                    hibSession.saveOrUpdate((Object)childClass);
                                }
                                classes.remove(childClass);
                                childClass.deleteAllDependentObjects(hibSession, false);
                                hibSession.delete((Object)childClass);
                                hibSession.saveOrUpdate((Object)childClass.getSchedulingSubpart());
                            }
                        }
                        --classPerParentRem;
                    }
                }
                if (classPerParentRem != 0) {
                    Iterator<Class_> cci2 = classesList.iterator();
                    for (Class_ parentClass : parentClasses) {
                        if (cci2.hasNext()) {
                            childClass = cci2.next();
                            Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                            childClass.setParentClass(parentClass);
                            parentClass.addTochildClasses(childClass);
                            hibSession.saveOrUpdate((Object)parentClass);
                            hibSession.saveOrUpdate((Object)childClass);
                        }
                        if (--classPerParentRem != 0) continue;
                        break;
                    }
                }
                hibSession.saveOrUpdate((Object)parent);
            }
        }
        if ((childSubparts = subpart.getChildSubparts()) == null || childSubparts.size() == 0) {
            return;
        }
        for (SchedulingSubpart cs : childSubparts) {
            this.updateParentClasses(cs, subpart, hibSession, notDeletedSubparts);
        }
    }

    private void deleteSubpart(HttpServletRequest request, Session hibSession, InstrOfferingConfig ioc, HashMap notDeletedSubparts) throws Exception {
        Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
        HashMap<Long, Long> deletedSubparts = new HashMap<Long, Long>();
        Iterator<SchedulingSubpart> i = s.iterator();
        while (i.hasNext()) {
            Set<SchedulingSubpart> childSubparts;
            SchedulingSubpart tmpSubpart = i.next();
            if (notDeletedSubparts.get(tmpSubpart.getUniqueId()) != null) continue;
            Debug.debug("Deleting subpart ... " + tmpSubpart.getUniqueId() + ", " + tmpSubpart.getItypeDesc());
            Set<Class_> classes = tmpSubpart.getClasses();
            Iterator<Class_> j = classes.iterator();
            while (j.hasNext()) {
                Class_ c = j.next();
                this.deleteChildClasses(c, hibSession, 1, false);
                Class_ pc = c.getParentClass();
                if (pc != null) {
                    pc.getChildClasses().remove(c);
                    if (notDeletedSubparts.get(pc.getSchedulingSubpart().getUniqueId()) != null) {
                        hibSession.saveOrUpdate((Object)pc);
                    }
                }
                j.remove();
            }
            SchedulingSubpart parentSubpart = tmpSubpart.getParentSubpart();
            if (parentSubpart != null) {
                if (parentSubpart.getChildSubparts() != null) {
                    parentSubpart.getChildSubparts().remove(tmpSubpart);
                }
                tmpSubpart.setParentSubpart(null);
                if (deletedSubparts.get(parentSubpart.getUniqueId()) == null) {
                    hibSession.saveOrUpdate((Object)parentSubpart);
                }
            }
            if ((childSubparts = tmpSubpart.getChildSubparts()) != null) {
                Debug.debug("Child subparts exist ... " + childSubparts.size());
            }
            tmpSubpart.setChildSubparts(null);
            deletedSubparts.put(tmpSubpart.getUniqueId(), tmpSubpart.getUniqueId());
            hibSession.delete((Object)tmpSubpart);
            i.remove();
        }
        hibSession.saveOrUpdate((Object)ioc);
        hibSession.flush();
    }

    private void createOrUpdateSubpart(HttpServletRequest request, Session hibSession, SimpleItypeConfig sic, InstrOfferingConfig ioc, SchedulingSubpart parent, RoomGroup rg, HashMap notDeletedSubparts) throws Exception {
        String subpartId = request.getParameter("subpartId" + sic.getId());
        String minLimitPerClass = request.getParameter("mnlpc" + sic.getId());
        String maxLimitPerClass = request.getParameter("mxlpc" + sic.getId());
        String minPerWk = request.getParameter("mpw" + sic.getId());
        String numClasses = request.getParameter("nc" + sic.getId());
        String numRooms = request.getParameter("nr" + sic.getId());
        String roomRatio = request.getParameter("rr" + sic.getId());
        String managingDept = request.getParameter("md" + sic.getId());
        String disabled = request.getParameter("disabled" + sic.getId());
        if (subpartId != null) {
            sic.setSubpartId(Long.parseLong(subpartId));
        }
        if (minLimitPerClass != null) {
            sic.setMinLimitPerClass(Constants.getPositiveInteger(minLimitPerClass, 0));
        }
        if (maxLimitPerClass != null) {
            sic.setMaxLimitPerClass(Constants.getPositiveInteger(maxLimitPerClass, 0));
        }
        if (minPerWk != null) {
            sic.setMinPerWeek(Integer.parseInt(minPerWk));
        }
        if (numClasses != null) {
            sic.setNumClasses(Integer.parseInt(numClasses));
        }
        if (numRooms != null) {
            sic.setNumRooms(Constants.getPositiveInteger(numRooms, 0));
        }
        if (roomRatio != null) {
            sic.setRoomRatio(Constants.getPositiveFloat(roomRatio, 0.0f));
        }
        if (managingDept != null) {
            sic.setManagingDeptId(Long.parseLong(managingDept));
        }
        if (disabled != null) {
            sic.setDisabled(new Boolean(request.getParameter("disabled" + sic.getId())));
        }
        long sid = sic.getSubpartId();
        int mnlpc = sic.getMinLimitPerClass();
        int mxlpc = sic.getMaxLimitPerClass();
        int mpw = sic.getMinPerWeek();
        int nr = sic.getNumRooms();
        float rr = sic.getRoomRatio();
        long md = sic.getManagingDeptId();
        boolean db = sic.isDisabled();
        if (ioc.isUnlimitedEnrollment().booleanValue()) {
            mnlpc = 0;
            mxlpc = 0;
            nr = 0;
            rr = 0.0f;
        }
        if (request.getParameter("varLimits") == null) {
            mnlpc = mxlpc;
        }
        SchedulingSubpart subpart = null;
        if (sid < 0L) {
            Debug.debug("Subpart does not exist ... Creating subpart - " + sic.getItype().getDesc());
            subpart = new SchedulingSubpart();
            subpart.setInstrOfferingConfig(ioc);
            subpart.setItype(sic.getItype());
            subpart.setMinutesPerWk(new Integer(mpw));
            subpart.setParentSubpart(parent);
            subpart.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
            subpart.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
            ioc.addToschedulingSubparts(subpart);
            if (md < 0L && !ioc.isUnlimitedEnrollment().booleanValue() && rg != null) {
                HashSet<Preference> prefs = new HashSet<Preference>();
                RoomGroupPref rgp = new RoomGroupPref();
                rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(PreferenceLevel.PREF_LEVEL_REQUIRED)));
                rgp.setRoomGroup(rg);
                rgp.setOwner(subpart);
                prefs.add(rgp);
                subpart.setPreferences(prefs);
            }
            hibSession.saveOrUpdate((Object)subpart);
            hibSession.flush();
            hibSession.refresh((Object)subpart);
            sid = subpart.getUniqueId();
            Debug.debug("New subpart uniqueid: " + sid);
            sic.setSubpartId(sid);
            notDeletedSubparts.put(new Long(sid), "");
        } else {
            Debug.debug("Subpart exists ... Updating");
            notDeletedSubparts.put(new Long(sid), "");
            Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
            for (SchedulingSubpart tmpSubpart : s) {
                if (tmpSubpart.getUniqueId() != sid) continue;
                subpart = tmpSubpart;
                break;
            }
            if (subpart == null) {
                throw new Exception("Scheduling Subpart " + sid + " was not found.");
            }
            Debug.debug("Creating / Updating subpart - " + subpart.getItypeDesc());
            Set<Class_> classes = subpart.getClasses();
            if (!db) {
                if (subpart.getMinutesPerWk() != mpw) {
                    Debug.debug("Minutes per week changed ... Deleting time prefs on subpart and classes");
                    subpart.setMinutesPerWk(new Integer(mpw));
                }
                if (ApplicationProperty.ConfigEditDeleteTimePrefs.isTrue()) {
                    DurationModel model = subpart.getInstrOfferingConfig().getDurationModel();
                    Iterator<Serializable> i = subpart.getPreferences().iterator();
                    while (i.hasNext()) {
                        Preference pref = i.next();
                        if (!(pref instanceof TimePref) || model.isValidCombination(mpw, subpart.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                        pref.setOwner(null);
                        hibSession.delete((Object)pref);
                        i.remove();
                    }
                    for (Class_ c : classes) {
                        Set<Preference> cPrefs = c.getPreferences();
                        Iterator<Preference> j = cPrefs.iterator();
                        while (j.hasNext()) {
                            Preference pref = j.next();
                            if (!(pref instanceof TimePref) || model.isValidCombination(mpw, c.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                            pref.setOwner(null);
                            hibSession.delete((Object)pref);
                            j.remove();
                        }
                        hibSession.saveOrUpdate((Object)c);
                    }
                }
                boolean managerChanged = false;
                long mdId = md;
                if (md < 0L) {
                    mdId = subpart.getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId();
                }
                if (subpart.getManagingDept().getUniqueId() != mdId) {
                    Debug.debug("Subpart Managing department changed ...");
                    managerChanged = true;
                    subpart.deleteAllDistributionPreferences(hibSession);
                    Set<Preference> prefs = subpart.getPreferences();
                    Iterator<Preference> prefI = prefs.iterator();
                    while (prefI.hasNext()) {
                        Department mgDept;
                        Preference a = prefI.next();
                        if (a instanceof RoomPref || a instanceof BuildingPref || a instanceof RoomGroupPref || a instanceof RoomFeaturePref) {
                            prefI.remove();
                        }
                        if (!(a instanceof TimePref) || !(mgDept = (Department)new DepartmentDAO().get(new Long(mdId))).isExternalManager().booleanValue() || subpart.getControllingDept().isAllowReqTime() != null && subpart.getControllingDept().isAllowReqTime().booleanValue() || mgDept.isAllowReqTime() != null && mgDept.isAllowReqTime().booleanValue()) continue;
                        ((TimePref)a).weakenHardPreferences();
                    }
                    if (md < 0L && !ioc.isUnlimitedEnrollment().booleanValue() && rg != null) {
                        RoomGroupPref rgp = new RoomGroupPref();
                        rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(PreferenceLevel.PREF_LEVEL_REQUIRED)));
                        rgp.setRoomGroup(rg);
                        rgp.setOwner(subpart);
                        prefs.add(rgp);
                    }
                }
                Iterator<Class_> i = classes.iterator();
                while (i.hasNext()) {
                    Debug.debug("Updating expected capacity and room capacity on class ...");
                    Class_ c = i.next();
                    c.setExpectedCapacity(new Integer(mnlpc));
                    c.setMaxExpectedCapacity(new Integer(mxlpc));
                    c.setRoomRatio(new Float(rr));
                    c.setNbrRooms(new Integer(nr));
                    if (c.getDisplayInstructor() == null) {
                        c.setDisplayInstructor(new Boolean(true));
                    }
                    if (c.getEnabledForStudentScheduling() == null) {
                        c.setEnabledForStudentScheduling(new Boolean(true));
                    }
                    if (managerChanged) {
                        if (c.getManagingDept().getUniqueId() != mdId) {
                            Debug.debug("Class Managing department changed ...");
                            c.setManagingDept((Department)new DepartmentDAO().get(new Long(mdId)), this.sessionContext.getUser(), hibSession);
                            c.deleteAllDistributionPreferences(hibSession);
                            Set<Preference> prefs = c.getPreferences();
                            Iterator<Preference> prefI = prefs.iterator();
                            while (prefI.hasNext()) {
                                Preference a = prefI.next();
                                if (a instanceof RoomPref || a instanceof BuildingPref || a instanceof RoomGroupPref || a instanceof RoomFeaturePref) {
                                    prefI.remove();
                                }
                                if (!(a instanceof TimePref)) continue;
                                if (((TimePref)a).getTimePattern().getType() == 5) {
                                    prefI.remove();
                                    continue;
                                }
                                if (!c.getManagingDept().isExternalManager().booleanValue() || c.getControllingDept().isAllowReqTime() != null && c.getControllingDept().isAllowReqTime().booleanValue() || c.getManagingDept().isAllowReqTime() != null && c.getManagingDept().isAllowReqTime().booleanValue()) continue;
                                ((TimePref)a).weakenHardPreferences();
                            }
                        } else {
                            Debug.debug("Class Managing department same as subpart ... ignoring");
                        }
                    }
                    hibSession.saveOrUpdate((Object)c);
                }
            }
            if (parent != null && subpart.getParentSubpart() != null && !subpart.getParentSubpart().equals(parent) || parent == null && subpart.getParentSubpart() != null || parent != null && subpart.getParentSubpart() == null) {
                Debug.debug("Updating parent subparts and classes ...");
                subpart.setParentSubpart(parent);
                if (parent == null) {
                    Debug.debug("No parent subparts ... making top level class");
                    for (Class_ childClass : subpart.getClasses()) {
                        childClass.setParentClass(null);
                        hibSession.saveOrUpdate((Object)childClass);
                    }
                } else {
                    Debug.debug("Parent subpart exists ... setting parent class");
                    ArrayList<Class_> classesList = new ArrayList<Class_>(classes);
                    Collections.sort(classesList, new ClassComparator(1));
                    Set<Class_> parentClasses = parent.getClasses();
                    int parentNumClasses = parentClasses.size();
                    if (parentNumClasses > 0) {
                        Class_ childClass;
                        Iterator<Class_> cci = classesList.iterator();
                        int classPerParent = classesList.size() / parentNumClasses;
                        int classPerParentRem = classesList.size() % parentNumClasses;
                        Debug.debug("Setting " + classPerParent + " class(es) per parent");
                        Debug.debug("Odd number of classes found - " + classPerParentRem + " classes ... ");
                        Iterator<Class_> i = parentClasses.iterator();
                        while (i.hasNext() && classPerParent != 0) {
                            Class_ parentClass = i.next();
                            for (int j = 0; j < classPerParent; ++j) {
                                childClass = cci.next();
                                Debug.debug("Setting class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                childClass.setParentClass(parentClass);
                                parentClass.addTochildClasses(childClass);
                                hibSession.saveOrUpdate((Object)parentClass);
                                hibSession.saveOrUpdate((Object)childClass);
                                if (classPerParentRem == 0) continue;
                                if (cci.hasNext()) {
                                    childClass = cci.next();
                                    Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                    childClass.setParentClass(parentClass);
                                    parentClass.addTochildClasses(childClass);
                                    hibSession.saveOrUpdate((Object)parentClass);
                                    hibSession.saveOrUpdate((Object)childClass);
                                }
                                --classPerParentRem;
                            }
                        }
                        if (classPerParentRem != 0) {
                            Iterator<Class_> cci2 = classesList.iterator();
                            for (Class_ parentClass : parentClasses) {
                                if (cci2.hasNext()) {
                                    childClass = cci2.next();
                                    Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                    childClass.setParentClass(parentClass);
                                    parentClass.addTochildClasses(childClass);
                                    hibSession.saveOrUpdate((Object)parentClass);
                                    hibSession.saveOrUpdate((Object)childClass);
                                }
                                if (--classPerParentRem != 0) continue;
                                break;
                            }
                        }
                        hibSession.saveOrUpdate((Object)parent);
                    }
                }
            }
            hibSession.saveOrUpdate((Object)subpart);
            hibSession.flush();
            hibSession.refresh((Object)subpart);
            if (parent != null) {
                hibSession.refresh((Object)parent);
            }
        }
        Vector v = sic.getSubparts();
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = (SimpleItypeConfig)v.elementAt(i);
            this.createOrUpdateSubpart(request, hibSession, sic1, ioc, subpart, rg, notDeletedSubparts);
        }
        hibSession.saveOrUpdate((Object)ioc);
        hibSession.flush();
    }

    private void createOrUpdateClasses(HttpServletRequest request, Session hibSession, SimpleItypeConfig sic, InstrOfferingConfig ioc, SchedulingSubpart parent) throws Exception {
        long sid = sic.getSubpartId();
        int mnlpc = sic.getMinLimitPerClass();
        int mxlpc = sic.getMaxLimitPerClass();
        int nc = sic.getNumClasses();
        int nr = sic.getNumRooms();
        float rr = sic.getRoomRatio();
        long md = sic.getManagingDeptId();
        boolean db = sic.isDisabled();
        if (ioc.isUnlimitedEnrollment().booleanValue()) {
            mnlpc = 0;
            mxlpc = 0;
            nr = 0;
            rr = 0.0f;
        }
        if (request.getParameter("varLimits") == null) {
            mnlpc = mxlpc;
        }
        Comparator<Class_> classComparator = new Comparator<Class_>(){

            @Override
            public int compare(Class_ c1, Class_ c2) {
                if (c1.isCancelled().booleanValue() && !c2.isCancelled().booleanValue()) {
                    return 1;
                }
                if (!c1.isCancelled().booleanValue() && c2.isCancelled().booleanValue()) {
                    return -1;
                }
                if (c1.getEnrollment() == 0 && c2.getEnrollment() != 0) {
                    return 1;
                }
                if (c1.getEnrollment() != 0 && c2.getEnrollment() == 0) {
                    return -1;
                }
                return c1.getUniqueId().compareTo(c2.getUniqueId());
            }
        };
        SchedulingSubpart subpart = null;
        if (sid < 0L) {
            throw new Exception("Subpart does not exist ... Cannot create classes ");
        }
        Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
        for (SchedulingSubpart tmpSubpart : s) {
            if (tmpSubpart.getUniqueId() != sid) continue;
            subpart = tmpSubpart;
            break;
        }
        if (subpart == null) {
            throw new Exception("Scheduling Subpart " + sid + " was not found.");
        }
        Debug.debug("Creating / Updating classes for subpart - " + subpart.getItypeDesc());
        Set<Class_> classes = subpart.getClasses();
        int numCls = classes.size();
        boolean readOnly = false;
        if (db) {
            Debug.debug("Subpart is readonly ... cannot change classes");
            readOnly = true;
        }
        HashMap<Long, Integer> cpClasses = new HashMap<Long, Integer>();
        if (parent != null) {
            int peerNumClasses;
            for (Class_ c : classes) {
                if (c.getParentClass() == null) continue;
                Integer classCount = (Integer)cpClasses.get(c.getParentClass().getUniqueId());
                if (classCount == null) {
                    cpClasses.put(c.getParentClass().getUniqueId(), new Integer(1));
                    continue;
                }
                cpClasses.put(c.getParentClass().getUniqueId(), new Integer(classCount + 1));
            }
            int cpNumClasses = cpClasses.size();
            if (cpNumClasses != (peerNumClasses = parent.getClasses().size())) {
                int diff;
                if (readOnly) {
                    throw new Exception("Subpart " + subpart.toString() + " has read-only permissions - Number of classes cannot be changed. ");
                }
                Debug.debug("Parents per child ( " + cpNumClasses + " ) do not match up to - " + peerNumClasses);
                int classesPerParent = numCls / peerNumClasses;
                if (numCls > classesPerParent && cpClasses.size() > 0) {
                    diff = (numCls - classesPerParent) / cpClasses.size();
                    Debug.debug("Deleting " + diff + " classes per current parent");
                    Set parentClassKeys = cpClasses.keySet();
                    for (Long parentClassId : parentClassKeys) {
                        int parentClassCount = (Integer)cpClasses.get(parentClassId);
                        int deleteCount = parentClassCount - classesPerParent;
                        Debug.debug("Deleting " + deleteCount + " classes for parent class: " + parentClassId.toString());
                        ArrayList<Class_> adepts = new ArrayList<Class_>();
                        for (Class_ c1 : classes) {
                            if (!c1.getParentClass().getUniqueId().equals(parentClassId)) continue;
                            adepts.add(c1);
                        }
                        Collections.sort(adepts, classComparator);
                        for (int ct = adepts.size() - deleteCount; ct < adepts.size(); ++ct) {
                            Class_ c = (Class_)adepts.get(ct);
                            if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                            Class_ pc = c.getParentClass();
                            if (pc != null) {
                                pc.getChildClasses().remove(c);
                                hibSession.saveOrUpdate((Object)pc);
                            }
                            classes.remove(c);
                        }
                        hibSession.saveOrUpdate((Object)subpart);
                        hibSession.saveOrUpdate((Object)parent);
                        hibSession.flush();
                    }
                } else {
                    diff = classesPerParent - numCls;
                    Debug.debug("Adding  " + diff + " classes");
                }
            }
        }
        if ((numCls = classes.size()) != nc) {
            if (readOnly) {
                throw new Exception("Subpart " + subpart.toString() + " has read-only permissions - Number of classes cannot be changed. ");
            }
            if (nc > numCls) {
                Debug.debug("No. of classes increased ... Adding " + (nc - numCls) + " classes");
                for (int ct = 0; ct < nc - numCls; ++ct) {
                    Class_ c = new Class_();
                    c.setSchedulingSubpart(subpart);
                    c.setExpectedCapacity(new Integer(mnlpc));
                    c.setMaxExpectedCapacity(new Integer(mxlpc));
                    c.setRoomRatio(new Float(rr));
                    c.setNbrRooms(new Integer(nr));
                    c.setDisplayInstructor(new Boolean(true));
                    c.setEnabledForStudentScheduling(new Boolean(true));
                    c.setPreferences(new HashSet<Preference>());
                    if (md > 0L) {
                        c.setManagingDept((Department)new DepartmentDAO().get(new Long(md)), this.sessionContext.getUser(), hibSession);
                    }
                    c.setCancelled(false);
                    subpart.addToclasses(c);
                }
                hibSession.saveOrUpdate((Object)subpart);
                hibSession.flush();
                this.setParentClass(hibSession, subpart, parent, nc);
            } else {
                Debug.debug("No. of classes decreased ... Deleting " + (numCls - nc) + " classes");
                ArrayList<Class_> adepts = new ArrayList<Class_>(classes);
                Collections.sort(adepts, classComparator);
                if (parent == null || numCls - nc == 1) {
                    for (int ct = nc; ct < numCls; ++ct) {
                        Class_ c = adepts.get(ct);
                        if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                        Class_ pc = c.getParentClass();
                        if (pc != null) {
                            pc.getChildClasses().remove(c);
                            hibSession.saveOrUpdate((Object)pc);
                        }
                        classes.remove(c);
                    }
                } else {
                    cpClasses.clear();
                    for (Class_ c : classes) {
                        if (c.getParentClass() == null) continue;
                        Integer classCount = (Integer)cpClasses.get(c.getParentClass().getUniqueId());
                        if (classCount == null) {
                            cpClasses.put(c.getParentClass().getUniqueId(), new Integer(1));
                            continue;
                        }
                        cpClasses.put(c.getParentClass().getUniqueId(), new Integer(classCount + 1));
                    }
                    int diff = (numCls - nc) / cpClasses.size();
                    Debug.debug("Deleting " + diff + " classes per current parent");
                    Set parentClassKeys = cpClasses.keySet();
                    for (Long parentClassId : parentClassKeys) {
                        Debug.debug("Deleting " + diff + " classes for parent class: " + parentClassId.toString());
                        adepts.clear();
                        for (Class_ c1 : classes) {
                            if (!c1.getParentClass().getUniqueId().equals(parentClassId)) continue;
                            adepts.add(c1);
                        }
                        Collections.sort(adepts, classComparator);
                        for (int ct = adepts.size() - diff; ct < adepts.size(); ++ct) {
                            Class_ c = adepts.get(ct);
                            if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                            Class_ pc = c.getParentClass();
                            if (pc != null) {
                                pc.getChildClasses().remove(c);
                                hibSession.saveOrUpdate((Object)pc);
                            }
                            classes.remove(c);
                        }
                        hibSession.saveOrUpdate((Object)subpart);
                        hibSession.saveOrUpdate((Object)parent);
                        hibSession.flush();
                    }
                }
                hibSession.saveOrUpdate((Object)subpart);
            }
        }
        Vector v = sic.getSubparts();
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = (SimpleItypeConfig)v.elementAt(i);
            this.createOrUpdateClasses(request, hibSession, sic1, ioc, subpart);
        }
    }

    public boolean deleteChildClasses(Class_ c, Session hibSession, int recurseLevel, boolean canCancel) {
        Debug.debug("Deleting class (" + recurseLevel + ") ... " + c.getClassLabel() + " - " + c.getUniqueId());
        Iterator<Class_> i = c.getChildClasses().iterator();
        while (i.hasNext()) {
            Class_ cc = i.next();
            SchedulingSubpart ps = cc.getSchedulingSubpart();
            if (!this.deleteChildClasses(cc, hibSession, recurseLevel + 1, canCancel)) continue;
            ps.getClasses().remove(cc);
            hibSession.saveOrUpdate((Object)ps);
            i.remove();
        }
        if (this.sessionContext.hasPermission(c, Right.ClassDelete)) {
            c.deleteAllDependentObjects(hibSession, false);
            hibSession.delete((Object)c);
            return true;
        }
        if (canCancel && this.sessionContext.hasPermission(c, Right.ClassCancel)) {
            c.setCancelled(true);
            c.cancelEvent(this.sessionContext.getUser(), hibSession, true);
            hibSession.saveOrUpdate((Object)c);
            return false;
        }
        throw new AccessDeniedException("Class " + c.getClassLabel(hibSession) + " cannot be deleted or cancelled.");
    }

    public void setParentClass(Session hibSession, SchedulingSubpart subpart, SchedulingSubpart parent, int subpartNumClasses) {
        if (parent != null) {
            Set<Class_> parentClasses = parent.getClasses();
            int parentNumClasses = parentClasses.size();
            int classesPerParent = subpartNumClasses / parentNumClasses;
            HashMap<Long, Integer> cpClasses = new HashMap<Long, Integer>();
            for (Class_ c : parent.getClasses()) {
                int childClassCount = 0;
                Set<Class_> ccl = c.getChildClasses();
                if (ccl != null) {
                    for (Class_ cc : ccl) {
                        if (!cc.getSchedulingSubpart().equals(subpart)) continue;
                        ++childClassCount;
                    }
                }
                cpClasses.put(c.getUniqueId(), new Integer(childClassCount));
            }
            ArrayList parentClassKeys = new ArrayList(cpClasses.keySet());
            Collections.sort(parentClassKeys);
            for (Long parentClassId : parentClassKeys) {
                int parentClassCount = (Integer)cpClasses.get(parentClassId);
                if (classesPerParent <= parentClassCount) continue;
                int addCount = classesPerParent - parentClassCount;
                Debug.debug("Adding " + addCount + " classes for parent class: " + parentClassId.toString());
                ArrayList<Class_> ccList = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(ccList, new ClassComparator(1));
                Iterator<Class_> cci = ccList.iterator();
                for (Class_ parentClass : parentClasses) {
                    if (!parentClass.getUniqueId().equals(parentClassId)) continue;
                    for (int j = 0; j < addCount; ++j) {
                        Class_ childClass = null;
                        while ((childClass = cci.next()).getParentClass() != null) {
                        }
                        childClass.setParentClass(parentClass);
                        parentClass.addTochildClasses(childClass);
                        hibSession.saveOrUpdate((Object)parentClass);
                        hibSession.saveOrUpdate((Object)childClass);
                    }
                }
            }
            hibSession.saveOrUpdate((Object)parent);
        }
    }

    public Vector toSimpleItypeConfig(InstrOfferingConfig config) throws Exception {
        Vector<SimpleItypeConfig> sp = new Vector<SimpleItypeConfig>();
        Set<SchedulingSubpart> subparts = config.getSchedulingSubparts();
        for (SchedulingSubpart subpart : subparts) {
            if (subpart.getParentSubpart() != null) continue;
            SimpleItypeConfig sic = this.toSimpleItypeConfig(config, subpart);
            sp.addElement(sic);
        }
        return sp;
    }

    private SimpleItypeConfig toSimpleItypeConfig(InstrOfferingConfig config, SchedulingSubpart subpart) throws Exception {
        ItypeDesc itype = subpart.getItype();
        SimpleItypeConfig sic = new SimpleItypeConfig(itype);
        boolean isDisabled = this.setSicProps(config, subpart, sic);
        Set<SchedulingSubpart> s = subpart.getChildSubparts();
        for (SchedulingSubpart child : s) {
            SimpleItypeConfig childSic = this.toSimpleItypeConfig(config, child);
            boolean isDisabledChild = this.setSicProps(config, child, childSic);
            sic.addSubpart(childSic);
            if (!isDisabledChild) continue;
            isDisabled = true;
        }
        if (isDisabled) {
            sic.setDisabled(true);
        }
        return sic;
    }

    private boolean setSicProps(InstrOfferingConfig config, SchedulingSubpart subpart, SimpleItypeConfig sic) {
        int mnlpc = subpart.getMinClassLimit();
        int mxlpc = subpart.getMaxClassLimit();
        int mpw = subpart.getMinutesPerWk();
        int numClasses = subpart.getNumClasses();
        int numRooms = subpart.getMaxRooms();
        float rc = subpart.getMaxRoomRatio();
        long md = subpart.getManagingDept().getUniqueId();
        boolean mixedManaged = subpart.hasMixedManagedClasses();
        if (mnlpc < 0) {
            mnlpc = config.getLimit();
        }
        if (mxlpc < 0) {
            mxlpc = mnlpc;
        }
        if (numClasses < 0) {
            numClasses = 0;
        }
        if (mixedManaged) {
            md = 0L;
        }
        sic.setMinLimitPerClass(mnlpc);
        sic.setMaxLimitPerClass(mxlpc);
        sic.setMinPerWeek(mpw);
        sic.setNumClasses(numClasses);
        sic.setNumRooms(numRooms);
        sic.setRoomRatio(rc);
        sic.setSubpartId(subpart.getUniqueId());
        sic.setManagingDeptId(md);
        if (!this.sessionContext.hasPermission(subpart, Right.InstrOfferingConfigEditSubpart) || mixedManaged) {
            sic.setDisabled(true);
            sic.setNotOwned(true);
            return true;
        }
        for (Class_ c : subpart.getClasses()) {
            if (this.sessionContext.hasPermission(c, Right.ClassDelete)) continue;
            sic.setNotOwned(true);
            break;
        }
        return false;
    }
}

